

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/RptSLAHistory.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2007  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/RptSLAHistory.script,v $ $Id: RptSLAHistory.script,v 1.1.6.2 2019/02/12 19:40:24 junlu Exp $";
-- TABLENAME RptSLAHistory

print '... inserting Table: RptSLAHistory'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME RptSLAHistory

DECLARE @MinHistoryDate DATETIME = (SELECT MIN(date) FROM RptSLAHistory WITH (NOLOCK) WHERE days = 1)

DECLARE @MinDefaultDate DATETIME = (SELECT MIN(date) FROM RptSLAHistory WITH (NOLOCK) WHERE days = -1)

IF ISNULL(@MinDefaultDate, '1970-01-01') > ISNULL(@MinHistoryDate, '1970-01-01')

BEGIN

	DECLARE	@ClientGroupSLADays TABLE (clientGroupId INT, slaDays INT)

	DECLARE @CS_SLADays INT = 30

	SELECT	@CS_SLADays = longVal 

	FROM	APP_ComponentProp WITH (NOLOCK)

	WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3300 AND modified = 0

	IF ISNULL(@CS_SLADays, 0) <= 0 SET @CS_SLADays = 30
	INSERT	INTO @ClientGroupSLADays


	SELECT	componentId, longVal 

	FROM	APP_ComponentProp WITH (NOLOCK)

	WHERE	componentType = 8 AND propertyTypeId = 3300 AND modified = 0

	IF NOT EXISTS (SELECT * FROM @ClientGroupSLADays WHERE slaDays <> @CS_SLADays)
		INSERT INTO RptSLAHistory


		SELECT	date, -1, fullJobsOnly, nClientsMet, nClientsMissed, nClientsExcluded

		FROM	RptSLAHistory WITH (NOLOCK)

		WHERE	days = @CS_SLADays AND date >= @MinHistoryDate AND date < @MinDefaultDate

	ELSE

	IF EXISTS (SELECT * FROM @ClientGroupSLADays)

	BEGIN

		CREATE TABLE #TempClientSLADays (clientId INT, clientGroupId INT, slaDays INT)
		INSERT INTO #TempClientSLADays


		SELECT	T.clientId, T.clientGroupId, T.slaDays

		FROM	(SELECT CG.slaDays, CGA.clientId, CGA.clientGroupId, ROW_NUMBER() OVER (PARTITION BY CGA.clientId ORDER BY CG.slaDays) AS rowId

				FROM	@ClientGroupSLADays CG INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON CG.clientGroupId = CGA.clientGroupId) T

				INNER JOIN (SELECT clientId FROM RptSLAClient WITH (NOLOCK) WHERE days = 1 AND fullJobsOnly = 0 AND status IN (1,2)) S 

					ON T.clientId = S.clientId

		WHERE	T.rowId = 1
		INSERT INTO #TempClientSLADays


		SELECT	S.clientId, 0, @CS_SLADays

		FROM	(SELECT clientId FROM RptSLAClient WITH (NOLOCK) WHERE days = 1 AND fullJobsOnly = 0 AND status IN (1,2)) S 

				LEFT OUTER JOIN #TempClientSLADays T ON S.clientId = T.clientId

		WHERE	T.clientId IS NULL

		DECLARE @ClientsPerSLADays TABLE (slaDays INT, nClients INT)
		INSERT INTO @ClientsPerSLADays


		SELECT	slaDays, COUNT(clientId)

		FROM	#TempClientSLADays

		GROUP BY slaDays

		DECLARE @TotalClients INT = 0

		SELECT	@TotalClients = SUM(nClients) FROM @ClientsPerSLADays

		IF @TotalClients > 0
			INSERT INTO RptSLAHistory


			SELECT	date, -1, fullJobsOnly, 

					SUM(nClientsMet*C.nClients)/@TotalClients, 

					SUM(nClientsMissed*C.nClients)/@TotalClients, 

					SUM(nClientsExcluded*C.nClients)/@TotalClients

			FROM	RptSLAHistory H WITH (NOLOCK)

					INNER JOIN @ClientsPerSLADays C ON H.days = C.slaDays

			WHERE	date >= @MinHistoryDate AND date < @MinDefaultDate

			GROUP BY date, fullJobsOnly

		DROP TABLE #TempClientSLADays

	END

END

