

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/RemoveSecureLDAPNetworkGatewayConfiguration.script] ---------- 


SET QUOTED_IDENTIFIER ON

-----------------------------------------------------------------------------------------------------------------------------------------

--  Script  :   RemoveSecureLDAPNetworkGatewayConfiguration

--  Purpose :   Secure LDAP does not work with network gateways in between the CS and the AD. 

--				This script removes the network gateways configuration (TPPM) for ADs with Secure LDAP enabled.

-----------------------------------------------------------------------------------------------------------------------------------------

SET NOCOUNT ON

DECLARE @scriptExecuted INT = 0

DECLARE @uniqueScriptID uniqueidentifier = '148C7B74-5DF3-428F-9BE9-9568FAC4AD9D'

SELECT @scriptExecuted = 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = @uniqueScriptID

IF @scriptExecuted = 0

BEGIN

    BEGIN TRY

        BEGIN TRANSACTION

		DELETE 

		FROM APP_FirewallTPPM 

WHERE tppmType=4 AND tppmParams IN (SELECT id

															FROM UMDSProviders 

															WHERE useSecureLdap=1)
        INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


        VALUES (@uniqueScriptID

                , 'RemoveSecureLDAPNetworkGatewayConfiguration'

                , 'This script removes the network gateways configuration (TPPM) for ADs with Secure LDAP enabled.'

                , DATEDIFF(second,'01/01/1970',GETUTCDATE()) 

, 16

                , 0

, (16 + 1))

        COMMIT TRANSACTION

    END TRY

    BEGIN CATCH

        PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

        ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

        ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

        ERROR MESSAGE: ' + ERROR_MESSAGE() + '

        ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

        ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

        PRINT 'Rolling back transaction'

        ROLLBACK TRANSACTION

    END CATCH

END

SET NOCOUNT OFF

