

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/RelocateSharePointMemberServersProps.script] ---------- 


SET QUOTED_IDENTIFIER ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

------------------------------------------------------------------------

-- rcsid[]='@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/RelocateSharePointMemberServersProps.script,v $ $Id: RelocateSharePointMemberServersProps.script,v 1.1.2.1 2018/09/14 16:17:10 abilbrey Exp $';

--==================================================================================

--	This script moves client properties, 'SharePoint Member Servers', from the

--	APP_ClientProp Table to the APP_ComponentProp Table. The reason for this is

--	that the XML Document can become too large to be stored in the APP_ClientProp

--	attrVal column which is only an NVARCHAR(1024).  Upgrading the table to

--	NVARCHAR(MAX) would incur a high regression hit due to ~92 binaries needing

--	to be recompiled.

--==================================================================================

SET NOCOUNT ON

DECLARE @SPGuid    VARCHAR(40) = '2B526089-EC3E-44A8-B5EF-63B17C3B7AAB'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @SPGuid)

BEGIN

	DECLARE @sRcnt			INT = 0

	DECLARE @iRcnt			INT = 0

	DECLARE @dRcnt			INT = 0

	DECLARE @cmpTgr			TINYINT = 0

	DECLARE @cpTgr			TINYINT = 0

	DECLARE @tryCatch		TINYINT = 0

	DECLARE @tranStarted	TINYINT = 0

	IF OBJECT_ID('tempdb.dbo.#SharePointPropRows') IS NOT NULL 

		DROP TABLE #SharePointPropRows

	CREATE TABLE #SharePointPropRows (

		cpId		INT PRIMARY KEY

	)

	-- Get all SharePoint row ids that need to be moved
	INSERT INTO #SharePointPropRows(cpId)


		SELECT

			cp.id

		FROM APP_ClientProp cp WITH(NOLOCK)

		WHERE

			cp.attrName = N'SharePoint Member Servers'

			AND cp.modified >= 0		-- added to force usage of a SEEK op

	SET @sRcnt = @@ROWCOUNT

	-- If rows found, then there is more processing to be done

	IF (@sRcnt > 0)

	BEGIN

		BEGIN TRY

			-- If CCS Laptop Triggers are enabled, then disable these tables

			IF EXISTS (

				SELECT is_disabled

				FROM sys.triggers WITH(NOLOCK)

				WHERE name LIKE 'APP_CCSComponentPropTableChange'

				AND is_disabled = 0		-- not disabled

			)

			BEGIN

				SET @cmpTgr = 1

				EXEC('DISABLE TRIGGER dbo.APP_CCSComponentPropTableChange ON dbo.APP_ComponentProp')

				PRINT 'RelocateSharePointMemberServersProps Trigger APP_CCSComponentPropTableChange disabled'

			END

			IF EXISTS (

				SELECT is_disabled

				FROM sys.triggers WITH(NOLOCK)

				WHERE name LIKE 'APP_CCSClientPropTableChange'

				AND is_disabled = 0	-- not disabled

			)

			BEGIN

				SET @cpTgr = 1

				EXEC('DISABLE TRIGGER dbo.APP_CCSClientPropTableChange ON dbo.APP_ClientProp')

				PRINT 'RelocateSharePointMemberServersProps Trigger APP_CCSClientPropTableChange disabled'

			END

			-- Start Transaction

			BEGIN TRAN

			SET @tranStarted = 1

			-- Move SharePoint properties from APP_ClientProp to APP_ComponentProp Table
			INSERT INTO APP_ComponentProp (componentType, componentId, propertyTypeId, dataType, longVal, longlongVal, stringVal, created, modified)


				SELECT

					3,						-- CV_COMPONENT_TYPE_CLIENT

					cp.componentNameId,		-- clientId

					1046,					-- CV_COMPONENT_SHAREPOINT_SECONDARY_MEMBER_SERVERS

					1,						-- PROPERTY_STRING

					0,

					0,

					cp.attrVal,				-- XML Document

					cp.created,

					cp.modified

				FROM APP_ClientProp cp WITH(NOLOCK)

					INNER JOIN #SharePointPropRows r ON

						r.cpId = cp.id

			SET @iRcnt = @@ROWCOUNT

			IF (@sRcnt <> @iRcnt)

			BEGIN

				RAISERROR('SELECT and INSERT row count do not match.', 16, 1)

			END

			-- Delete APP_ClientProp rows moved.

			DELETE cp

			FROM APP_ClientProp cp

				INNER JOIN #SharePointPropRows r ON

					r.cpId = cp.id 

			SET @dRcnt = @@ROWCOUNT

			IF (@sRcnt <> @iRcnt)

			BEGIN

				RAISERROR('SELECT and DELETE row count do not match.', 16, 1)

			END

			-- Processing done commit transaction

			COMMIT TRAN

			SET @tranStarted = 2

		END TRY

		BEGIN CATCH

			SET @tryCatch = 1

			DECLARE @newLine        NVARCHAR(3) = NCHAR(13) -- + CHAR(10)

			DECLARE @msg NVARCHAR(2047) = @newLine + @newLine

			SET @msg += 'INSIDE CATCH BLOCK WITH FOLLOWING ERROR: ' + @newLine

			SET @msg += '   ERROR CODE: ' + CAST(ERROR_NUMBER() AS NVARCHAR(12)) + @newLine

			SET @msg += '   SQL SCRIPT: RelocateSharePointMemberServersProps ' + @newLine

			SET @msg += '   ERROR LINE NO: ' + CAST(ERROR_LINE() AS NVARCHAR(12)) + @newLine

			SET @msg += '   ERROR MESSAGE: ' + ERROR_MESSAGE() + @newLine

			SET @msg += '   ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS NVARCHAR(12)) + @newLine

			SET @msg += '   ERROR STATE: ' + CAST(ERROR_STATE() AS NVARCHAR(12)) + @newLine + @newLine

			PRINT @msg

			IF (@tranStarted = 1)

			BEGIN

				ROLLBACK TRAN

			END

		END CATCH

		-- If CCS Laptop Triggers were disabled, re-enabled them

		IF (@cmpTgr = 1)

		BEGIN

			EXEC('ENABLE TRIGGER dbo.APP_CCSComponentPropTableChange ON dbo.APP_ComponentProp')

			PRINT 'RelocateSharePointMemberServersProps Trigger APP_CCSComponentPropTableChange enabled'

		END

		IF (@cpTgr = 1)

		BEGIN

			EXEC('ENABLE TRIGGER dbo.APP_CCSClientPropTableChange ON dbo.APP_ClientProp')

			PRINT 'RelocateSharePointMemberServersProps Trigger APP_CCSClientPropTableChange enabled'

		END

		-- If Exception caught, re-throw it to terminate upgrade processing

		IF (@tryCatch = 1)

		BEGIN

			RAISERROR('RelocateSharePointMemberServersProps failed.', 16, 1)

		END

		-- Indicate to future database upgrades that the script has executed.
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@SPGuid, 'RelocateSharePointMemberServersProps', 'Relocate identified SharePoint client properties to component properties table.', dbo.getunixtime(GETUTCDATE()), 16, 0, (16 + 2))

	END

END

