

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/RelocateClientNetworkInfoToComponentPropTable.script] ---------- 


SET QUOTED_IDENTIFIER ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998 CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

------------------------------------------------------------------------

-----------------------------------------------------------------------------------------------------------------------------------------

--  Script  :   RelocateClientNetworkInfoToComponentPropTable.script

--  Purpose :   This script moves Client IP Addresses and Client Hostnames from APP_ClientProp table to the APP_ComponentProp table

-----------------------------------------------------------------------------------------------------------------------------------------

--======================================================================================

--	This script moves client properties, 'Client IP Addresses','Client Hostnames' from 

--	APP_ClientProp Table to the APP_ComponentProp Table. The reason for this is

--	that the number of IP addresses and hostnames can become too large to be stored 

--  in the APP_ClientProp attrVal column which is only an NVARCHAR(1024).

--	Upgrading the table to NVARCHAR(MAX) would incur a high regression hit due 

--	to ~92 binaries needing to be recompiled.

--======================================================================================

SET NOCOUNT ON

DECLARE @ClientNetworkInfoExists INT = 0

DECLARE @uniqueScriptID uniqueidentifier = '53F69B0D-01ED-46D8-8A5B-5DAB8C189E3E'

SELECT @ClientNetworkInfoExists = 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = @uniqueScriptID

IF @ClientNetworkInfoExists = 0

BEGIN

    BEGIN TRY

		-- Start Transaction

        BEGIN TRANSACTION

        DECLARE @createdTime INTEGER = dbo.GetUnixTime(CURRENT_TIMESTAMP);

        -- Client IP Addresses
        INSERT INTO APP_ComponentProp (componentType, componentId, propertyTypeId, dataType, longVal, longlongVal, stringVal, created, modified)


        SELECT

3,							-- CV_COMPONENT_TYPE_CLIENT

					cp.componentNameId,										-- clientId

2102,					-- CV_COMPONENT_CLIENT_IP_ADDRESSES

					1,														-- PROPERTY_STRING

					0,

					0,

					cp.attrVal,												-- IP Addresses

					cp.created,

					cp.modified

				FROM APP_ClientProp cp WITH(NOLOCK)

					WHERE

					cp.attrName =  N'Client IP Addresses'

					AND cp.modified>=0

		-- Client HostNames

		UNION ALL

        SELECT

3,							-- CV_COMPONENT_TYPE_CLIENT

					cp.componentNameId,										-- clientId

2103,						-- CV_COMPONENT_CLIENT_HOSTNAMES

					1,														-- PROPERTY_STRING

					0,

					0,

					cp.attrVal,												-- Hostnames

					cp.created,

					cp.modified

				FROM APP_ClientProp cp WITH(NOLOCK)

				WHERE

					cp.attrName = N'Client Hostnames'

					AND cp.modified>=0

		-- Delete APP_ClientProp rows moved.

		-- Delete Client IP Addresses and Client Hostnames

			DELETE cp

			FROM APP_ClientProp cp

			WHERE cp.attrName = N'Client IP Addresses' OR cp.attrName = N'Client Hostnames'
        INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


        VALUES (@uniqueScriptID

                , 'RelocateClientNetworkInfoToComponentPropTable'

                , 'This script moves Client IP Addresses and Client Hostnames from APP_ClientProp table to the APP_ComponentProp table'

                , DATEDIFF(second,'01/01/1970',CURRENT_TIMESTAMP) 

, 16

                , 0

, (16 + 1))

        COMMIT TRANSACTION

    END TRY

    BEGIN CATCH

        PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

        ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

        ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

        ERROR MESSAGE: ' + ERROR_MESSAGE() + '

        ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

        ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

        PRINT 'Rolling back transaction'

        ROLLBACK TRANSACTION

		;THROW;

    END CATCH

END

SET NOCOUNT OFF
