

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NetworkShareClientUpgrade.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 2016  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/NetworkShareClientUpgrade.script,v $ $Id: NetworkShareClientUpgrade.script,v 1.1.2.6 2020/10/04 00:58:41 abilbrey Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '40EB7EF8-DB9E-40EB-AC8D-4890651A5844')

BEGIN

	-- Tbl script file should not have any function calls because they may not exist during upgrade

	DECLARE @timeNow INT = datediff(second, '01/01/1970', getUTCDate())

	IF OBJECT_ID('tempdb.dbo.#idaList') IS NOT NULL

        DROP TABLE #idaList

	IF OBJECT_ID('tempdb.dbo.#subclientList') IS NOT NULL

        DROP TABLE #subclientList

	CREATE TABLE #idaList (id INT)

	CREATE TABLE #subclientList (id INT)

	--Find agent list to upgrade
	INSERT INTO #idaList


	SELECT	distinct I.id

	FROM	APP_IdaName I

		INNER JOIN APP_IdaProp IP

			ON I.id = IP.componentNameId AND IP.attrName = 'FPOLICY PRIMARY CLIENT' AND IP.modified = 0

		INNER JOIN APP_Client C

			ON C.id = I.clientId

		LEFT OUTER JOIN APP_IdaProp IP2

			ON I.id = IP2.componentNameId AND IP2.attrName = 'Backup Configuration Nodes' AND IP2.modified = 0

	WHERE	((C.status & 0x80) <> 0 OR (C.status & 0x8000000) <> 0) --CV_STATUS_NAS, CV_STATUS_NON_NDMP

		AND I.appTypeId IN (29, 33)

		AND IP.attrVal <> '0'

		AND ((IP2.attrVal IS NULL) OR CAST(IP2.attrVal AS XML).value('count(/App_BackupConfigurationNodes/backupDataAccessNodes/@clientId)', 'int') = 0)

	--Find subclient list to upgrade
	INSERT INTO #subclientList


	SELECT	distinct A.id

	FROM	APP_Application A

		INNER JOIN APP_Client C

			ON A.clientId = C.id

		INNER JOIN APP_SubclientProp SP

			ON A.id = SP.componentNameId AND SP.attrName = 'Turbo NAS Proxy Client' AND	SP.modified = 0

		LEFT OUTER JOIN APP_SubclientProp SP2

			ON A.id = SP2.componentNameId AND SP2.attrName = 'Backup Configuration Nodes' AND SP2.modified = 0

	WHERE  ((C.status & 0x80) <> 0 OR (C.status & 0x8000000) <> 0) --CV_STATUS_NAS, CV_STATUS_NON_NDMP

		AND A.appTypeId IN (29, 33)

		AND SP.attrVal <> '0'

		AND ((SP2.attrVal IS NULL) OR CAST(SP2.attrVal AS XML).value('count(/App_BackupConfigurationNodes/backupDataAccessNodes/@clientId)', 'int') = 0)

	--Upgrade agent

	UPDATE APP_IDAProp

	SET		modified = @timeNow

	FROM	APP_IDAProp IP, #idaList L

	WHERE	IP.componentNameId = L.id

		AND	IP.attrName = 'Backup Configuration Nodes'

		AND IP.modified = 0
	INSERT INTO APP_IDAProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


	SELECT * FROM

	(SELECT	IL.id as 'id', 'Backup Configuration Nodes' as 'attrName', 1 as 'attrType', 

		(SELECT 3 AS 'backupDataAccessNodes/@_type_',

				I.attrVal AS 'backupDataAccessNodes/@clientId',

				C.name AS 'backupDataAccessNodes/@clientName'

		FROM	APP_IDAProp I, APP_Client C

		WHERE	I.componentNameID = IL.id

			AND	I.attrName = 'FPOLICY PRIMARY CLIENT'

			AND I.modified = 0

			AND I.attrVal = CAST(C.id AS NVARCHAR(1024))

		FOR XML PATH(''), ROOT('App_BackupConfigurationNodes')

		) as 'attrVal', @timeNow as 'created', 0 as 'modified', 0 as 'ccpid'

	FROM	#idaList IL) AS A

	WHERE A.attrVal IS NOT NULL

	--Upgrade subclient

	UPDATE APP_SubClientProp

	SET		modified = @timeNow

	FROM	APP_SubClientProp SCP, #subclientList L

	WHERE	SCP.componentNameId = L.id

		AND	SCP.attrName = 'Backup Configuration Nodes'

		AND SCP.modified = 0
	INSERT INTO APP_SubclientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


	SELECT * FROM

	(

	SELECT	SL.id as 'id', 'Backup Configuration Nodes' 'attrName', 1 'attrType', 

		(SELECT 3 AS 'backupDataAccessNodes/@_type_',

				A.attrVal AS 'backupDataAccessNodes/@clientId',

				C.name AS 'backupDataAccessNodes/@clientName'

		FROM	APP_SubclientProp A, APP_Client C

		WHERE	A.componentNameId = SL.id

			AND A.attrName = 'Turbo NAS Proxy Client'

			AND A.modified = 0

			AND A.attrVal = CAST(C.id AS NVARCHAR(1024))

		FOR XML PATH(''), ROOT('App_BackupConfigurationNodes')

		) as 'attrVal', @timeNow as 'created', 0 as 'modified', 0 as 'ccpId'

	FROM	#subclientList SL) AS A

	WHERE A.attrVal IS NOT NULL

	IF OBJECT_ID('tempdb.dbo.#idaList') IS NOT NULL

        DROP TABLE #idaList

	IF OBJECT_ID('tempdb.dbo.#subclientList') IS NOT NULL

        DROP TABLE #subclientList

	-- Tbl script file should not have any function calls because they may not exist during upgrade
    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


    VALUES('40EB7EF8-DB9E-40EB-AC8D-4890651A5844', 'NetworkShareClientUpgrade', 'Upgrade iDA and subclient properties for Network share clients', @timeNow, 16, 0, (16 + 2)) --SIM_ID_GX_REL110 = 16

END

SET NOCOUNT OFF

GO

SET QUOTED_IDENTIFIER ON

GO
