

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NT_SLAHealthAlertRule.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/NT_SLAHealthAlertRule.script,v $ $Id: NT_SLAHealthAlertRule.script,v 1.2.2.4 2020/07/07 13:44:14 mnatarajan Exp $";

Set Quoted_Identifier ON

BEGIN

-------------------------------------------------------------------------------------

	----------------------------------------------------------------------------

	--									Variables							  --

	----------------------------------------------------------------------------

BEGIN TRY

	declare @queryId int

	set @queryId = 0	

	DECLARE @adminID			as integer		= ISNULL((Select top 1 ID from UMUSERS where (flags & 67) = 67 AND Name <> 'ROMS'), 1)

	DECLARE @errCode INTEGER

	DECLARE @errStr  nvarchar(1024) = ''

	declare @queryName nvarchar(max) = 'SLA Health check'

	If exists(select 1 from NTQueryList where queryName=@queryName)

	begin	

		select @queryId = queryId from NTQueryList where queryName=@queryName

		-- Get XML into table variable and update it. Then update it back to temp table. 

		IF object_id('tempdb.dbo.#queryListColumnTmp') is not null 

			DROP TABLE #queryListColumnTmp

		CREATE TABLE #queryListColumnTmp

		(

			columnIndex INT, 

			xmlData XML,

			inputName NVARCHAR(1024)

		)

		CREATE CLUSTERED INDEX queryListColumnTmp_columnIndex_Idx ON #queryListColumnTmp(columnIndex)
		INSERT INTO #queryListColumnTmp(columnIndex,xmldata)


		SELECT columnIndex, convert(xml,xmlInfo)

		FROM NTQueryColumnList(NOLOCK)

		WHERE queryId=@queryId

		AND columnType=1

		AND convert(xml,xmlInfo).exist('App_XMLSchema/@name')=0

		UPDATE #queryListColumnTmp

		SET inputName = xmlData.value('(App_XMLSchema/@inputName)[1]','NVARCHAR(1024)')

		UPDATE #queryListColumnTmp

		SET xmlData.modify('insert (attribute name {sql:column("inputName")}) into (App_XMLSchema)[1]')

		Update NTQueryColumnList

		set xmlInfo = CONVERT(NVARCHAR(MAX),queryListColumnTmp.xmlData)

		FROM NTQueryColumnList 

		INNER JOIN #queryListColumnTmp queryListColumnTmp ON queryId=@queryId

		AND columnType=1

		AND NTQueryColumnList.columnIndex = queryListColumnTmp.columnIndex		

		UPDATE NTQueryColumnList

		SET xmlInfo = '<App_XMLSchema controlType="2" defaultValue="" displayName="" documentation="" name="LastNDays" inputName="LastNDays" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" readOnly="0" required="1" type="{http://www.w3.org/2001/XMLSchema}integer" typeOptions="0"><defaultValues val=""/><options val="1"/><options val="2"/><options val="3"/><options val="5"/><options val="7"/><options val="14"/><options val="21"/><options val="30"/></App_XMLSchema>'

		WHERE columnName = 'LastNDays'

		AND queryId=@queryId

		AND columnType=1

		IF object_id('tempdb.dbo.#queryListColumnTmp') is not null 

			DROP TABLE #queryListColumnTmp

		RETURN

	end

	Begin tran SLACustomRule	
	Insert into NTQueryList(queryMessageId,defaultfrequency,status,queryCreator,visibility,taskId,queryString,


		xmlInfo,queryName,queryDescription,queryCriteriaName,GUID,commcellAssociation,isOverwriteAssociationAtAlertAllowed)

	select 0,86400,2,@adminID,0,0,

'SET NOCOUNT ON

--------- Insert your SQL statements here 

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

-- This query is to find the Clients that are not protected in last 30 days.

-- This is used for SLA report in health check.

DECLARE @nProtected     INT = 0

DECLARE @nNotProtected  INT = 0

DECLARE @nExcluded      INT = 0

DECLARE @clients        XML

DECLARE @csReleaseId    INT

SELECT  @csReleaseId = releaseId FROM APP_Client WHERE id = 2

-- Get not-protected clients/subclients and the reason for not being protected

IF  @csReleaseId < 15

BEGIN

    CREATE TABLE #TblSubclient (

    ClientId        INT,

    ClientName      NVARCHAR(256),

    AgentName       NVARCHAR(256),

    InstanceName    NVARCHAR(256),

    BackupSetName   NVARCHAR(256),

    SubclientName   NVARCHAR(256),

    Category        NVARCHAR(64),

    SLA_Reason      NVARCHAR(64),

    LastBackupJobID INT,

    LastJobStatus   NVARCHAR(32),

    LastJobEndTime  VARCHAR(20)

    )

    CREATE TABLE #TblNotProtectedClient (ClientId INT)

    CREATE TABLE #TblProtectedClient (ClientId INT)
    INSERT INTO #TblSubclient


    SELECT  C.id, C.name, Agent, Instance, BackupSet, Subclient, 

            Category, SLA_Reason, LastBackupJobID, LastJobStatus, LastJobEndTime

    FROM    dbo.DataProtectionCoverage(@LastNDays, 0)

            INNER JOIN APP_Client C WITH (NOLOCK) ON C.name = Client
    INSERT INTO #TblNotProtectedClient


    SELECT DISTINCT ClientId FROM #TblSubclient 

    WHERE Category = ''Not Protected''

    SET @nNotProtected = @@ROWCOUNT
    INSERT INTO #TblProtectedClient


    SELECT DISTINCT S.ClientId FROM #TblSubclient S LEFT OUTER JOIN #TblNotProtectedClient N ON S.ClientId = N.ClientId

    WHERE S.Category = ''Protected'' AND N.ClientId IS NULL

    SET @nProtected = @@ROWCOUNT

    SELECT @nExcluded = COUNT(DISTINCT S.ClientId) FROM #TblSubclient S 

        LEFT OUTER JOIN #TblNotProtectedClient N ON S.ClientId = N.ClientId

        LEFT OUTER JOIN #TblProtectedClient P ON S.ClientId = P.ClientId

    WHERE S.Category = ''Excluded'' AND N.ClientId IS NULL AND P.ClientId IS NULL

    DROP TABLE #TblNotProtectedClient

    DROP TABLE #TblProtectedClient

    DROP TABLE #TblSubclient

END

ELSE

BEGIN

    CREATE TABLE #tempSLA

    (

        date            datetime,

        clientId        int,

        appId           int,

        fullJobsOnly    int,

        appTypeId       int,

        status          int,

        category        int,

        lastSeenTime    int

    )

    CREATE TABLE #tempSLAClient

    (

        date            datetime,

        days            int,

        fullJobsOnly    int,

        clientId        int,

        isProtected     int,

        category        int

    )

    DECLARE @Summary TABLE (status INT, counts INT)

    -- Only for EDC cells or exclude all EDC cells. No mixture. One capture time for all EDC cells.

    DECLARE @IgnoreEDCCommCells INT = 0

    DECLARE @EDCDumpCaptureTime INT = 0

    DECLARE @IsEDC              INT = 0

    SELECT  @IgnoreEDCCommCells = CAST(CAST(value AS NVARCHAR(32)) AS INT)

    FROM    GXGlobalParam WITH (NOLOCK)

    WHERE   name = ''IgnoreEDCCellsForSLA''

    IF  @IgnoreEDCCommCells = 0

    BEGIN

        SELECT  @EDCDumpCaptureTime = CAST(CAST(value AS NVARCHAR(32)) AS INT)

        FROM    GXGlobalParam WITH (NOLOCK)

        WHERE   name = ''EDCDumpCaptureTime''

        IF  @EDCDumpCaptureTime > 0

            SET @IsEDC = 1

    END

    DECLARE @lastDate   DATETIME

    DECLARE @endDate    DATETIME

    DECLARE @fromDate   DATETIME

    DECLARE @bias       INT

    DECLARE @lastTime   INT

    IF @IsEDC = 1

    BEGIN

        SET @lastDate = (

            SELECT  MAX(date) 

            FROM    RptSLA S WITH (NOLOCK)

                    INNER JOIN APP_Application A WITH (NOLOCK) ON S.appId = A.id

                    INNER JOIN APP_CommCell CC WITH (NOLOCK) ON A.origCCId = CC.id AND CC.type >= 100)
        INSERT INTO #tempSLA


        SELECT  date, clientId, appId, fullJobsOnly, appTypeId, status, category, lastSeenTime

        FROM    RptSLA WITH (NOLOCK)

        WHERE   date = @lastDate AND fullJobsOnly = 0 AND status IN (1, 2)
        INSERT INTO #tempSLAClient


        SELECT  date, days, fullJobsOnly, clientId, (status & 1), category

        FROM    RptSLAClient WITH (NOLOCK)

        WHERE   date = @lastDate AND days = @LastNDays AND fullJobsOnly = 0 AND status IN (1, 2)

    END

    ELSE

    BEGIN

        SET @lastDate = (SELECT MAX(date) FROM RptSLA WITH (NOLOCK))

        SET @lastDate = DATEADD(DAY, 1, @lastDate)

        EXEC RptOneDaySLA @lastDate

        DELETE #tempSLA WHERE fullJobsOnly <> 0 OR status = 3

        DELETE #tempSLAClient WHERE days <> @LastNDays OR fullJobsOnly <> 0

	DELETE #tempSLA FROM #tempSLAClient WHERE #tempSLA.clientId = #tempSLAClient.clientId AND #tempSLAClient.category = 6

    END

    SET @endDate    = DATEADD(DAY, 1, @lastDate)

    SET @fromDate   = DATEADD(DAY, -1*@LastNDays, @lastDate)

	-- Tbl script file should not have any function calls because they may not exist during upgrade

    SET @bias       = DATEDIFF(second, ''01/01/1970'', GETDATE()) - DATEDIFF(second, ''01/01/1970'', GETUTCDATE())

    SET @lastTime   = DATEDIFF(second, ''01/01/1970'', @endDate) - @bias
    INSERT INTO @Summary


    SELECT CASE WHEN S.category = 6 THEN 3 WHEN S.isProtected > 0 THEN 1 ELSE 2 END, COUNT(S.clientId)

    FROM #tempSLAClient S WITH (NOLOCK) INNER JOIN APP_Client C WITH (NOLOCK)

        ON S.clientId = C.id AND S.date = @lastDate AND S.days = @LastNDays AND S.fullJobsOnly = 0

	GROUP BY CASE WHEN S.category = 6 THEN 3 WHEN S.isProtected > 0 THEN 1 ELSE 2 END
    INSERT INTO #tempSLA


	SELECT	S.*

	FROM	RptSLA S WITH (NOLOCK)

			INNER JOIN #tempSLA T ON S.clientId = T.clientId

				AND (CASE WHEN S.appTypeId = 106 THEN 0 ELSE S.appId END) = (CASE WHEN T.appTypeId = 106 THEN 0 ELSE T.appId END)

	WHERE	S.date > @fromDate AND S.date < @lastDate AND S.fullJobsOnly = 0 AND S.status IN (1, 2)

    SELECT  @nProtected    = counts FROM @Summary WHERE status = 1

    SELECT  @nNotProtected = counts FROM @Summary WHERE status = 2

    SELECT  @nExcluded     = counts FROM @Summary WHERE status = 3

    SET	    @nExcluded     += (SELECT COUNT(DISTINCT clientId) FROM #tempSLA WHERE date = @lastDate AND status = 3 AND appId = 0 AND fullJobsOnly = 0)

    DROP TABLE #tempSLAClient

    DROP TABLE #tempSLA

END

--------- END SURVEY QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

if (@nNotProtected+@nProtected>0)

begin

    if ( (@nProtected*100/(@nNotProtected+@nProtected))>=@slaPercent)

    begin   

        return

    end

end

SELECT  

            CASE 

                WHEN (@nNotProtected+@nProtected)>0

                THEN @nProtected*100/(@nNotProtected+@nProtected)

            ELSE 0 END as SLAPercent

SET NOCOUNT OFF

'

,'','SLA Health check','Custom query to alert when SLA requirement is not met',

'Alert when CommCell SLA for last <LastNDays,1> days is less than <slaPercent,1> Percent',NEWID(),

'<App_Associations><entity _type_="124" commCellId="2" /></App_Associations>',1

	SET @errCode = @@ERROR

	IF	@errCode <> 0

	BEGIN

		SET @errStr = 'ERROR: System Created Default SLA custom rule -- Failed to insert in NTQueryList'

		GOTO ERROR_EXIT

	END

	set @queryId = @@IDENTITY
	Insert into NTQueryColumnList(queryId,columnIndex,isColumnFilterable,lmDataType,columnName,columnFriendlyName,


		isPrimaryKey,supportedOpTypes,columnType,xmlInfo)

	select @queryId,0,0,0,'SLAPercent','SLA Percent',0,'0,1,4,5,6,7',0,'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails shldColumnBePartOfAlert="1"/>'

	union

	select @queryId,0,0,0,'slaPercent','slaPercent',0,'',1,'<App_XMLSchema controlType="0" defaultValue="" displayName="" documentation="" name="slaPercent" inputName="slaPercent" inputType="java.lang.Double" listType="0" maximumValue="" minimumValue="" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}double" typeOptions="0"><defaultValues val=""/></App_XMLSchema>'

	union

	select @queryId,1,0,0,'LastNDays','LastNDays',0,'',1,'<App_XMLSchema controlType="2" defaultValue="" displayName="" documentation="" name="LastNDays" inputName="LastNDays" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" readOnly="0" required="1" type="{http://www.w3.org/2001/XMLSchema}integer" typeOptions="0"><defaultValues val=""/><options val="1"/><options val="2"/><options val="3"/><options val="5"/><options val="7"/><options val="14"/><options val="21"/><options val="30"/></App_XMLSchema>'

	SET @errCode = @@ERROR

	IF	@errCode <> 0

	BEGIN

		SET @errStr = 'ERROR: System Created Default SLA custom rule -- Failed to insert in NTQueryColumnList'

		GOTO ERROR_EXIT

	END

	Commit Tran SLACustomRule

	return

ERROR_EXIT:

End try

begin catch

	IF @@TRANCOUNT > 0

        ROLLBACK TRAN SLACustomRule

	if len(@errStr)=0 and len(ERROR_MESSAGE())>0

	begin

		set @errStr = ERROR_MESSAGE()

	end

	if len(@errStr)>0

		RAISERROR(@errStr, 16, 1) 	

end catch

End

