

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NT_MoreThanXGbBackedUpAlertRule.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/NT_MoreThanXGbBackedUpAlertRule.script,v $ $Id: NT_MoreThanXGbBackedUpAlertRule.script,v 1.2.2.2 2020/07/07 13:44:08 mnatarajan Exp $";

Set Quoted_Identifier ON

BEGIN

-------------------------------------------------------------------------------------

    ----------------------------------------------------------------------------

    --                                  Variables                             --

    ----------------------------------------------------------------------------

BEGIN TRY

    declare @queryId int

    set @queryId = 0    

    DECLARE @adminID            as integer      = ISNULL((Select top 1 ID from UMUSERS where (flags & 67) = 67 AND Name <> 'ROMS'), 1)

    DECLARE @errCode INTEGER

    DECLARE @errStr  nvarchar(1024) = ''

    declare @queryName nvarchar(max) = 'Backup exceeds X GB'

    If exists(select 1 from NTQueryList where queryName=@queryName)

    begin

		-- In case query is already present, we need to add name attribute with value for inputName attribute in case needed

		select @queryId = queryId from NTQueryList where queryName=@queryName

		-- Get XML into table variable and update it. Then update it back to temp table. 

		IF object_id('tempdb.dbo.#queryListColumnTmp') is not null 

			DROP TABLE #queryListColumnTmp

		CREATE TABLE #queryListColumnTmp

		(

			columnIndex INT, 

			xmlData XML,

			inputName NVARCHAR(1024)

		)

		CREATE CLUSTERED INDEX queryListColumnTmp_columnIndex_Idx ON #queryListColumnTmp(columnIndex)
		INSERT INTO #queryListColumnTmp(columnIndex,xmldata)


		SELECT columnIndex, convert(xml,xmlInfo)

		FROM NTQueryColumnList(NOLOCK)

		WHERE queryId=@queryId

		AND columnType=1

		AND convert(xml,xmlInfo).exist('App_XMLSchema/@name')=0

		UPDATE #queryListColumnTmp

		SET inputName = xmlData.value('(App_XMLSchema/@inputName)[1]','NVARCHAR(1024)')

		UPDATE #queryListColumnTmp

		SET xmlData.modify('insert (attribute name {sql:column("inputName")}) into (App_XMLSchema)[1]')

		Update NTQueryColumnList

		set xmlInfo = CONVERT(NVARCHAR(MAX),queryListColumnTmp.xmlData)

		FROM NTQueryColumnList 

		INNER JOIN #queryListColumnTmp queryListColumnTmp ON queryId=@queryId

		AND columnType=1

		AND NTQueryColumnList.columnIndex = queryListColumnTmp.columnIndex		

		IF object_id('tempdb.dbo.#queryListColumnTmp') is not null 

			DROP TABLE #queryListColumnTmp

		RETURN

    end

    Begin Tran     
    Insert into NTQueryList(queryMessageId,defaultfrequency,status,queryCreator,visibility,taskId,queryString,


        xmlInfo,queryName,queryDescription,queryCriteriaName,GUID,commcellAssociation,isOverwriteAssociationAtAlertAllowed)

    select 0,86400,2,@adminID,0,0,

'SET NOCOUNT ON

--------- Insert your SQL statements here 

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT jobID, UserName , clientId, appTypeId, instance, backupSet, applicationId, CONVERT (nvarchar(max), ROUND((CONVERT (float,uncompBytes)/POWER(2,30)),2))+'' GB'' as ''BackedupSize''

FROM RunningBackups  

WHERE CONVERT (float,uncompBytes) / POWER(2,30) >= @maxSize AND (userId=@userId OR dbo.isBkpJobVisible(@userId,commCellId,clientId,appTypeId,instance,backupSet,applicationId)=1) 

SET NOCOUNT OFF',

--------- END QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

'','Backup exceeds X GB','Custom query for sending alert when size of data being backed up exceeds X GB',

'Threshold size of data in GB<maxSize,1>',NEWID(),

'<App_Associations><entity _type_="124" commCellId="2" /></App_Associations>',1

    SET @errCode = @@ERROR

    IF  @errCode <> 0

    BEGIN

        SET @errStr = 'ERROR: System Created Default Backup exceeds X GB custom rule -- Failed to insert in NTQueryList'

        GOTO ERROR_EXIT

    END

    set @queryId = @@IDENTITY
    Insert into NTQueryColumnList(queryId,columnIndex,isColumnFilterable,lmDataType,columnName,columnFriendlyName,


isPrimaryKey,supportedOpTypes,columnType,xmlInfo)

select @queryId,0,0,0,'maxSize','Threshold Size (GB)',0,'',1,'<App_XMLSchema controlType="0" defaultValue="5" displayName="Threshold Size (GB)" documentation="" name="maxSize" inputName="maxSize" inputType="java.lang.Float" listType="0" maximumValue="" minimumValue="1" readOnly="0" required="1" type="{http://www.w3.org/2001/XMLSchema}float" typeOptions="0"><defaultValues val=""/></App_XMLSchema>'

union

select @queryId,0,1,0,'jobID','JobID',1,'0,1,4,5,6,7',0,'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails shldColumnBePartOfAlert="1"/>'

union

select @queryId,1,1,1,'UserName','User',0,'2,3,0,1',0,'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails shldColumnBePartOfAlert="1"/>'

union

select @queryId,2,1,14,'clientId','Client',0,'9',0,'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails shldColumnBePartOfAlert="1"/>'

union

select @queryId,3,1,13,'appTypeId','Application Type',0,'9',0,'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails shldColumnBePartOfAlert="1"/>'

union

select @queryId,4,1,12,'instance','Instance',0,'9',0,'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails shldColumnBePartOfAlert="1"/>'

union

select @queryId,5,1,11,'backupSet','BackupSet',0,'9',0,'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails shldColumnBePartOfAlert="1"/>'

union

select @queryId,6,1,10,'applicationId','Subclient',0,'9',0,'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails shldColumnBePartOfAlert="1"/>'

union

select @queryId,7,1,1,'BackedupSize','Backed Up Size',0,'2,3,0,1',0,'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails shldColumnBePartOfAlert="1"/>'

    SET @errCode = @@ERROR

    IF  @errCode <> 0

    BEGIN

        SET @errStr = 'ERROR: System Default Backup exceeds X GB custom rule -- Failed to insert in NTQueryColumnList'

        GOTO ERROR_EXIT

    END

    Commit Tran 

    return

ERROR_EXIT:

End try

begin catch

    IF @@TRANCOUNT > 0

        ROLLBACK TRAN 

    if len(@errStr)=0 and len(ERROR_MESSAGE())>0

    begin

        set @errStr = ERROR_MESSAGE()

    end

    if len(@errStr)>0

        RAISERROR(@errStr, 16, 1)   

end catch

End
