

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTUpdateAlertInfoInPlan.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/NTUpdateAlertInfoInPlan.script,v $ $Id: NTUpdateAlertInfoInPlan.script,v 1.1.2.110.8.1 2021/01/28 18:33:11 alakra Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

declare @guid uniqueidentifier = '2FF382EF-6A9C-4BFB-8C15-AEACDBDC3714'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       

DECLARE @globalParamPlanUpdateExec INT = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamPlanUpdateExec = 0)        -- not done, create the activity monitoring dashboard

BEGIN

	declare @alertxml xml

	set @alertxml = (SELECT id '@alertId', notificationName '@alertName'

		FROM NTNotificationRule 

		WHERE (status&128)>0 --NT_STATUS_LAPTOP_ALERT 

AND (status & 262144 ) = 0 -- Dont show hidden alerts for plans.

		AND revision>0

		for xml path('alerts'),root('alerts')

		)

	declare @gxglobalparamTemp table

	(

		id int,

		name nvarchar(maX),

		value xml

	)
	Insert into @gxglobalparamTemp


	select id,name,value from GXGlobalParam

	where name like '%plan%'

	and convert(xml,value).exist('//Api_GetPlanDetailsResp')=1

	and modified=0

	-- Remove the alerts node from xml and replace it with @alertxml xml

	-- replace value of (//Api_GetPlanDetailsResp/plan/alerts/alerts[@alertName="Restore Job failed"]/@alertId)[1] with sql:variable("@alertIdForRestore")

	update @gxglobalparamTemp

    set value.modify('delete (//Api_GetPlanDetailsResp/plan/alerts)[1]')

	update @gxglobalparamTemp

    set value.modify('insert (sql:variable("@alertxml")  ) after (//Api_GetPlanDetailsResp/plan/summary)[1]')

	update GXGlobalParam

	set value=convert(nvarchar(max),gxglobalparamTemp.value)

	from GXGlobalParam inner join @gxglobalparamTemp gxglobalparamTemp

	on GXGlobalParam.id=gxglobalparamTemp.id
    INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'PlanUpdateAlertInfoInGlobalParam', 'Update alert information in plan XML', @curUtcDateTime, 16, 0 , (16 + 2))

END

SET NOCOUNT OFF

GO

