

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTSynthFullDataLossDetectionAlert.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- Add simpana event viewer alert for Synthetic Full Data Loss Detection

DECLARE  @errorCode			INT         

DECLARE  @errorString		NVARCHAR(1024)

SET @errorCode	= 0

SET @errorString = ''

declare @guid uniqueidentifier = '04587843-5AFF-4E55-8341-42D80C188C84'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       

DECLARE @globalParamPlanUpdateExec INT = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamPlanUpdateExec = 1)        -- not done, create the activity monitoring dashboard

begin

	return

end

BEGIN TRY

	BEGIN TRAN

	Update NTNotificationrule

	set revision=0,status=2

	where notificationName='Synthetic Full Data Loss Detection'

	and alertTypeId=58 -- 'NT_ALERTTYPE_EVENT_MONITORING'
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'DeleteSynthfullAlert', 'Delete synthfull alert', @curUtcDateTime, 16, 0 , (16 + 2))

END TRY

BEGIN CATCH

	SET @errorCode = ERROR_NUMBER()

	SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

END CATCH

IF @errorCode = 0

	COMMIT TRAN

ELSE

BEGIN

	IF LEN(@errorString) > 0

		Print @errorString

	ELSE

		Print 'SQL Error encountered while running the script hence rolling back Transaction'

	ROLLBACK TRAN

END

