

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTRemoveVSAAlertsForNonVSAOEM.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- Add simpana event viewer alert for Ransomware event.

DECLARE  @errorCode			INT      = 0

DECLARE  @errorString		NVARCHAR(1024) = ''

DECLARE @oem INT = ISNULL((SELECT CAST(value AS INT) FROM gxglobalparam WHERE name = 'MiniBrandId'), 0)

-- Do this only for non VSA OEM 106 - Virtual Server 

IF @oem = 106 

begin

    return

end

-- OEM id is 0. Maybe fresh install case. Dont do anything. 

IF @oem = 0 

begin

    return

end

declare @isTranStarted int = 0

BEGIN TRY

	BEGIN TRAN

	set @isTranStarted = 1

	-- delete VSA specific alerts. 

	Update NTNotificationRule 

	set revision = 0, status=2

	where notificationName in ('VM Backup failed', 'VM Backup succeeded', 'VM Backup succeeded with errors')

	and (status&2048)>0 -- they shld have default flag set. 

END TRY

BEGIN CATCH

	SET @errorCode = ERROR_NUMBER()

	SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

END CATCH

IF @errorCode = 0

	if @isTranStarted>0

	begin

		COMMIT TRAN

	end

ELSE

BEGIN

	IF LEN(@errorString) > 0

		Print @errorString

	ELSE

		Print 'SQL Error encountered while running the script hence rolling back Transaction'

	if @isTranStarted>0

	begin

		ROLLBACK TRAN

	end

END


