

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTQueryColumnList.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/NTQueryColumnList.script,v $ $Id: NTQueryColumnList.script,v 1.3.2.2 2020/07/07 13:44:11 mnatarajan Exp $";

SET Quoted_Identifier ON

BEGIN

-------------------------------------------------------------------------------------

	----------------------------------------------------------------------------

	--									Variables							  --

	----------------------------------------------------------------------------

	DECLARE @errStr  nvarchar(1024) = ''

BEGIN TRY	

	-- Get XML into table variable and update it. Then update it back to temp table. 

	IF object_id('tempdb.dbo.#queryListColumnTmp') is not null 

		DROP TABLE #queryListColumnTmp

	CREATE TABLE #queryListColumnTmp

	(

		queryID		INT,

		columnIndex INT, 

		xmlData XML,

		inputName NVARCHAR(1024),

		inputType NVARCHAR(1024)

	)

	CREATE CLUSTERED INDEX queryListColumnTmp_columnIndex_Idx ON #queryListColumnTmp(queryID,columnIndex)
	INSERT INTO #queryListColumnTmp(queryID, columnIndex,xmldata)


	SELECT queryID, columnIndex, convert(xml,xmlInfo)

	FROM NTQueryColumnList(NOLOCK)

	WHERE columnType=1

	AND (

		convert(xml,xmlInfo).exist('App_XMLSchema/@name')=0

		OR convert(xml,xmlInfo).exist('App_XMLSchema/@className')=0

	)

	UPDATE #queryListColumnTmp

	SET inputName = xmlData.value('(App_XMLSchema/@inputName)[1]','NVARCHAR(1024)'),

	inputType = xmlData.value('(App_XMLSchema/@inputType)[1]','NVARCHAR(1024)')

	UPDATE #queryListColumnTmp

	SET xmlData.modify('insert (attribute name {sql:column("inputName")}) into (App_XMLSchema)[1]')

	WHERE xmlData.exist('App_XMLSchema/@name')=0

	UPDATE #queryListColumnTmp

	SET xmlData.modify('insert (attribute className {sql:column("inputType")}) into (App_XMLSchema)[1]')

	WHERE xmlData.exist('App_XMLSchema/@className')=0

	Update NTQueryColumnList

	set xmlInfo = CONVERT(NVARCHAR(MAX),queryListColumnTmp.xmlData)

	FROM NTQueryColumnList 

	INNER JOIN #queryListColumnTmp queryListColumnTmp ON NTQueryColumnList.queryId=queryListColumnTmp.queryId

	AND columnType=1

	AND NTQueryColumnList.columnIndex = queryListColumnTmp.columnIndex

	IF object_id('tempdb.dbo.#queryListColumnTmp') is not null 

		DROP TABLE #queryListColumnTmp

End try

begin catch

	if len(@errStr)=0 and len(ERROR_MESSAGE())>0

    begin

        set @errStr = ERROR_MESSAGE()

    end

    if len(@errStr)>0

        RAISERROR(@errStr, 16, 1)   

end catch

SET  NOCOUNT OFF

End

