

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTMissingClientGroupOwnerAlert.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

--

--  +========================================================================+

--  |      

--	|		Copyright (c) 1998  CommVault Systems, Inc.                

--  |               All rights reserved.                                

--  |                                                                   

--  |                                                                

--  |     This is unpublished proprietary source code of CommVault  

--  |     Systems, Inc. The copyright notice above does not evidence 

--  |     any actual or intended publication of such source code. 

--  +========================================================================+

--  +========================================================================+

--  |   Script Name: NTMissingClientGroupOwnerAlert.script   

--	|	Description: Client Group Owner is replaced by Client Group Scope

--  |				 We do not need missing client group owner alert anymore. 

--  |                This script removes missing client group owner alert from DB. 

--	|

--  +========================================================================+

SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON

DECLARE @uniqueSQLScriptGUIDString VARCHAR(128) = '9C8F29AE-9673-479D-B752-C7E16F958EA9'

DECLARE @uniqueSQLScriptGUIDExists BIT = 0

SELECT @uniqueSQLScriptGUIDExists = 1

FROM GXUniqueSQLScriptExecTracking 

WHERE

	SqlScriptGUID = @uniqueSQLScriptGUIDString

IF @uniqueSQLScriptGUIDExists = 0

BEGIN

	DECLARE  @errorCode         INT   =  0      

	DECLARE  @errorString       VARCHAR(1024) = ''  

	DECLARE @nowTime            INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

	BEGIN TRY		

		IF OBJECT_ID('tempdb.dbo.#alertIDs') IS NOT NULL DROP TABLE #alertIDs

			CREATE TABLE #alertIDs(alertId INT)

		DECLARE @queryId INT = 0

		-- check if missing client group owner alert query exists

		SET @queryId = (SELECT queryId FROM NTQueryList WITH (NOLOCK) WHERE queryName = 'Missing Client Group Owner')

		-- one alert query can be used for multiple alerts, we need to delete all such alerts.
		INSERT INTO #alertIDs


		SELECT NtNotificationId FROM NTNotificationQueryMapping WITH (NOLOCK) WHERE QueryId = @queryId

		-- remove queries and related information

		DELETE FROM NTQueryColumnList WHERE queryId = @queryId

		DELETE FROM NTQueryList WHERE queryId = @queryId

		-- remove alerts related information

		DELETE NTM FROM NTmessages NTM

		INNER JOIN #alertIDs alerts ON NTM.NTnotificationID = alerts.alertId

		DELETE NTM FROM NTmessageFormat NTM

		INNER JOIN #alertIDs alerts ON NTM.NTnotificationID = alerts.alertId

		DELETE NTM FROM NTnotificationUsers NTM

		INNER JOIN #alertIDs alerts ON NTM.NTnotificationID = alerts.alertId	

		DELETE NTA FROM NTnotificationAction NTA

		INNER JOIN #alertIDs alerts ON NTA.NTnotificationID = alerts.alertId	

		DELETE NTA FROM NTattachedFiles NTA

		INNER JOIN #alertIDs alerts ON NTA.NTnotificationID = alerts.alertId

		DELETE NTQ FROM NTRomsQueue NTQ

		INNER JOIN #alertIDs alerts ON NTQ.NTnotificationID = alerts.alertId

		DELETE NTG FROM NTnotificationExternalGroups NTG

		INNER JOIN #alertIDs alerts ON NTG.NTnotificationID = alerts.alertId

		DELETE NTG FROM NTnotificationGroups NTG

		INNER JOIN #alertIDs alerts ON NTG.NTnotificationID = alerts.alertId

		DELETE NTM FROM NTmessageTracking NTM

		INNER JOIN #alertIDs alerts ON NTM.NTnotificationID = alerts.alertId

		DELETE NTQ FROM NTSpoolQueue NTQ

		INNER JOIN #alertIDs alerts ON NTQ.NTnotificationID = alerts.alertId

		DELETE NTM FROM NTmessageHistory NTM

		INNER JOIN #alertIDs alerts ON NTM.NTnotificationID = alerts.alertId

		DELETE NTSelParam FROM NTSelCriteriaParams NTSelParam

		INNER JOIN NTSelCriteria NTSelCri ON NTSelCri.id = NTSelParam.selCriteriaid

		INNER JOIN #alertIDs alerts ON NTSelCri.ruleId = alerts.alertId

		DELETE NTSel FROM NTSelCriteria NTSel 

		INNER JOIN #alertIDs alerts ON NTSel.ruleId = alerts.alertId

		-- once all properties related to Missing client group owner alert are removed,

		-- remove "rule & query mapping from NTNotificationQueryMapping" and "rule from NTnotificationRule""

		DELETE NTMapping FROM NTNotificationQueryMapping NTMapping 

		INNER JOIN #alertIDs alerts ON alerts.alertId =NTMapping.NTnotificationID

		DELETE NTRule FROM NTnotificationRule NTRule 

		INNER JOIN #alertIDs alerts ON alerts.alertId = NTRule.id

	END TRY

	BEGIN CATCH

		SET @errorCode = ERROR_NUMBER()

		SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

	END CATCH

	IF @errorCode <> 0

	BEGIN

		IF LEN(@errorString) > 0

			Print @errorString

		ELSE

			Print 'SQL Error encountered while running the script'

	END

	IF OBJECT_ID('tempdb.dbo.#alertIDs') IS NOT NULL DROP TABLE #alertIDs
	INSERT INTO GXUniqueSQLScriptExecTracking


		VALUES(@uniqueSQLScriptGUIDString, 'RemoveMissingClientGroupOwner', 'Remove Missing client group owner rule and alert', @nowTime, 16, 0, 18)

END

SET NOCOUNT OFF

SET QUOTED_IDENTIFIER ON
