

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDiskSpaceLowAlertCriteria.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/NTDiskSpaceLowAlertCriteria.script,v $ $Id: NTDiskSpaceLowAlertCriteria.script,v 1.1.2.3 2019/12/12 19:25:32 sjohnson Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

declare @guid uniqueidentifier = '0549FFAF-EAD7-416D-988F-BE64903DCCA4'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       

DECLARE @DiskSpaceLowScriptExec INT = 0

SELECT @DiskSpaceLowScriptExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@DiskSpaceLowScriptExec = 0)        -- not done, create the activity monitoring dashboard

BEGIN

	declare @ntRuleIdForClientDiskSpaceLow table

	(

		ruleId int,

		reportingOptions int,

		delayTimeSeconds int,

		persistTimeSeconds int

	)
	Insert into @ntRuleIdForClientDiskSpaceLow(ruleId,reportingOptions,delayTimeSeconds,persistTimeSeconds)


	select distinct ruleId,1,0,0 from NTSelCriteria

	inner join NTNotificationRule on NTSelCriteria.ruleId=NTNotificationRule.id

	and NTNotificationRule.alertTypeId=10 --NT_ALERTTYPE_CLIENTS

	and NTSelCriteria.availCriteriaId=18 --NT_DISK_SPACE_LOW

	Update ntRuleIdForClientDiskSpaceLow

	set reportingOptions = NTSelCriteria.reportingOptions,

		delayTimeSeconds = NTSelCriteria.delayTimeSeconds,

		persistTimeSeconds = NTSelCriteria.persistTimeSeconds

	from @ntRuleIdForClientDiskSpaceLow ntRuleIdForClientDiskSpaceLow, NTSelCriteria

	where ntRuleIdForClientDiskSpaceLow.ruleId=NTSelCriteria.RuleId
	Insert into NTSelCriteria(availCriteriaId,esclationLevel,ruleId, reportingOptions,delayTimeSeconds,persistTimeSeconds)


select distinct 77,1,ruleId,reportingOptions,delayTimeSeconds,persistTimeSeconds

	from @ntRuleIdForClientDiskSpaceLow

	union

select distinct 79,1,ruleId,reportingOptions,delayTimeSeconds,persistTimeSeconds

	from @ntRuleIdForClientDiskSpaceLow

	delete from @ntRuleIdForClientDiskSpaceLow
	Insert into @ntRuleIdForClientDiskSpaceLow(ruleId,reportingOptions,delayTimeSeconds,persistTimeSeconds)


	select distinct ruleId,1,0,0 from NTSelCriteria

	inner join NTNotificationRule on NTSelCriteria.ruleId=NTNotificationRule.id

	and NTNotificationRule.alertTypeId=13 --NT_ALERTTYPE_MediaAgents

	and NTSelCriteria.availCriteriaId=18 --NT_DISK_SPACE_LOW

	Update ntRuleIdForClientDiskSpaceLow

	set reportingOptions = NTSelCriteria.reportingOptions,

		delayTimeSeconds = NTSelCriteria.delayTimeSeconds,

		persistTimeSeconds = NTSelCriteria.persistTimeSeconds

	from @ntRuleIdForClientDiskSpaceLow ntRuleIdForClientDiskSpaceLow, NTSelCriteria

	where ntRuleIdForClientDiskSpaceLow.ruleId=NTSelCriteria.RuleId
	Insert into NTSelCriteria(availCriteriaId,esclationLevel,ruleId, reportingOptions,delayTimeSeconds,persistTimeSeconds)


select distinct 78,1,ruleId,reportingOptions,delayTimeSeconds,persistTimeSeconds

	from @ntRuleIdForClientDiskSpaceLow

	union

select distinct 79,1,ruleId,reportingOptions,delayTimeSeconds,persistTimeSeconds

	from @ntRuleIdForClientDiskSpaceLow
    INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'NTDiskSpaceLowAlertCriteria', 'Add selection of new disk space low criteria for existing alerts', @curUtcDateTime, 16, 0 , (16 + 2))

END

SET NOCOUNT OFF

GO

