

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDeleteRomsAlert.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/NTDeleteRomsAlert.script,v $ $Id: NTDeleteRomsAlert.script,v 1.1.2.2 2019/12/12 19:24:59 sjohnson Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

declare @guid uniqueidentifier = 'C5C9D067-74E8-4CE3-B284-AB2C222FAAE5'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       

DECLARE @globalParamRomsAlertDeleteExec INT = 0

SELECT @globalParamRomsAlertDeleteExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

declare  @errorCode             integer = 0

declare  @errorString           nvarchar(1024) = ''

IF (@globalParamRomsAlertDeleteExec = 0)        -- not done, create the default alerts.

BEGIN

BEGIN TRY

	Begin tran
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'NTDeleteDefaultRomsAlerts', 'Tblscript to delete default ROMS alerts', @curUtcDateTime, 16, 0 , (16 + 2))

	update NTnotificationRule  set status = 2 , revision = 0

Where revision > 0

and notificationName in (

'roms_jm_01',

'roms_jm_02',

'roms_jm_03',

'roms_jm_04',

'roms_jm_05',

'roms_jm_06',

'roms_mm_01',

'roms_mm_02',

'roms_mm_03',

'roms_am_01',

'roms_am_02',

'roms_au_01',

'roms_au_04',

'roms_au_02',

'roms_au_03',

'roms_cf_01',

'roms_cf_02',

'roms_cf_03',

'roms_cf_04',

'roms_cf_05')

	END TRY

	 BEGIN CATCH

		 set @errorCode = ERROR_NUMBER()

		 set @errorString = 'Error in deleting default roms alerts. Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()

	 END CATCH

	IF @errorCode = 0

		COMMIT TRAN

	ELSE 

		ROLLBACK TRAN

END

SET NOCOUNT OFF

GO

