

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDefaultTapeOMLMismatchAlert.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- Add simpana event viewer alert for Tape OML Mismatch warning.

DECLARE  @errorCode			INT         

DECLARE  @errorString		VARCHAR(1024)

DECLARE @allClientXmlEntities	NVARCHAR(MAX)= '<CVGui_CommCellTreeNode>

  <associations _type_="2" />

  <associations _type_="27" />

  <clientGroups includeAll="0" />

  <clients includeAll="0" />

  <criterias includeAll="0" />

  <libraries includeAll="0" />

  <mediaAgents includeAll="0" />

  <storagePolcies includeAll="0" />

  <trackingJobs />

  <trackingPolicies includeAll="0" />

  <trackingSchedules />

  <workflows includeAll="0" />

</CVGui_CommCellTreeNode>'

DECLARE @adminID					INT = ISNULL((Select top 1 ID from UMUSERS where (flags & 67) = 67), 1)

DECLARE @masterGroupId				INT = ISNULL((Select top 1 ID from UMGroups where name='master'), 1)    --_US_ADMIN_GROUP__

DECLARE @emptyDateTime				DATETIME = '1900-01-01 00:00:00.000'

DECLARE @localeId					INT = 0				-- Default Locale US-English 

DECLARE @ruleState					INT = 0

DECLARE @nowTime					INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

DECLARE @createdAlertsId			INT = 1

DECLARE @notifType					INT = 1				-- !! WAS !! 'NT_LAPTOP_ALERTNOTIF' + EMAIL (TO FAKE OUT GUI, FOR NOW!)

----  FOR CURSOR -----

DECLARE @alertId					INT

DECLARE @alertType					INT

DECLARE @notificationName			NVARCHAR(128)		-- 'NT_MAX_NOTIFICATION_NAME_SIZE'

DECLARE @description				NVARCHAR(1024)		-- 'NT_MAX_ALERT_DESCRIPTION_SIZE'

DECLARE @msgFmtText					NVARCHAR(max) 

DECLARE @msgFmtHtml					NVARCHAR(max)

DECLARE @cursorXmlEntities			NVARCHAR(MAX)

DECLARE @alertsToAdd table (      

		alertId						INT PRIMARY KEY,

		alertType					INT NOT NULL,

		notificationName			NVARCHAR(128),

		description					NVARCHAR(1024),

		msgFmtText					NVARCHAR(MAX),

		msgFmtHtml					NVARCHAR(MAX),

		xmlEntities					NVARCHAR(MAX)

)

DECLARE @criteriasToAdd table (         

		alertId						INT,

		criteriaId					INT,

		criteriaParamType			INT,

		criteriaParamValue			INT,

		criteriaParamUnit			INT

		PRIMARY KEY(alertId,criteriaId)

)

DECLARE @simpanaEventCriteria table (

		alertId						INT,

		criteriaxml					NVARCHAR(MAX)              

)

----------------------

DECLARE @thisAlertId				INT

SET @errorCode	= 0

SET @errorString = ''

BEGIN TRY

	BEGIN TRAN

	DECLARE @htmldefaultTemplateForDefaultAlert NVARCHAR(MAX)

	DECLARE @textdefaultTemplateForDefaultAlert NVARCHAR(MAX)

IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name='UseNewAlertTemplate' AND value=1)

		SET @htmldefaultTemplateForDefaultAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Event ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Monitoring Criteria</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;MONITORING CRITERIA STRING&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Severity</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT SEVERITY&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Job ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;JOB ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Event Date</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT DATE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Program</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT PROGRAM&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Client</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CLIENT DISPLAY NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Description</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DESCRIPTION&gt;</font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'

	ELSE

		SET @htmldefaultTemplateForDefaultAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table cellspacing="0" style="border-bottom-color: #dedede; border-left-width: 0px; border-right-color: #dedede; border-left-style: solid; border-right-style: solid; border-top-style: solid; border-right-width: 0px; border-bottom-width: 0px; border-bottom-style: solid; border-top-color: #dedede; border-left-color: #dedede; border-top-width: 0px" width="600" align="center" border="1" cellpadding="0">  <tr>  <td>  <center>  <table cellspacing="0" id="contentTbl" width="600" align="center" border="0" cellpadding="0">  <tr style="background-color: #666666">  <td valign="middle" align="left">  <div style="margin-bottom: 4px; margin-top: 4px; margin-left: 10px">  <font color="#EEEEEE" size="6" face="Helvetica,sans-serif">&lt;ALERT NAME&gt; </font>  </div>  </td>  </tr>  <tr>  <td valign="middle" align="left" bgcolor="#DCDEDE" colspan="1">  <ul style="margin-bottom: 4px; margin-top: 4px">  <strong><font size="4" face="Helvetica,sans-serif">CommCell: </font><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong>  </ul>  <ul style="margin-bottom: 4px; margin-top: 4px">  <strong><font size="4" face="Helvetica,sans-serif">Type: </font><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong>  </ul>  <ul style="margin-bottom: 4px; margin-top: 4px">  <strong><font size="4" face="Helvetica,sans-serif">Detected Criteria: </font><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;DETECTED CRITERIA&gt;</font></strong>  </ul>  <ul style="margin-bottom: 4px; margin-top: 4px">  <strong><font size="4" face="Helvetica,sans-serif">Detected Time: </font><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;TIME&gt;</font></strong>  </ul>  </td>  </tr>  <tr>  <td width="100%" align="left" colspan="1">  <ul>  <li style="margin-bottom: 4px; margin-top: 4px">  <font color="#000000" size="3" face="Helvetica,sans-serif">Event ID: &lt;EVENT ID&gt; </font> </li>  <li style="margin-bottom: 4px; margin-top: 4px">  <font color="#000000" size="3" face="Helvetica,sans-serif">Monitoring Criteria: &lt;MONITORING CRITERIA STRING&gt; </font> </li>  <li style="margin-bottom: 4px; margin-top: 4px">  <font color="#000000" size="3" face="Helvetica,sans-serif">Severity: &lt;EVENT SEVERITY&gt; </font> </li>  <li style="margin-bottom: 4px; margin-top: 4px">  <font color="#000000" size="3" face="Helvetica,sans-serif">Job ID: &lt;JOB ID&gt; </font> </li>  <li style="margin-bottom: 4px; margin-top: 4px">  <font color="#000000" size="3" face="Helvetica,sans-serif">Event Date: &lt;EVENT DATE&gt; </font> </li>  <li style="margin-bottom: 4px; margin-top: 4px">  <font color="#000000" size="3" face="Helvetica,sans-serif">Program: &lt;EVENT PROGRAM&gt; </font> </li>  <li style="margin-bottom: 4px; margin-top: 4px">  <font color="#000000" size="3" face="Helvetica,sans-serif">Client: &lt;CLIENT DISPLAY NAME&gt; </font> </li>  <li style="margin-bottom: 4px; margin-top: 4px">  <font color="#000000" size="3" face="Helvetica,sans-serif">Description: &lt;DESCRIPTION&gt; </font> </li>  </ul>  </td>  </tr>  <tr style="background-color: #666666">  <td align="left" colspan="1">     </td>  </tr>  </table>  </center>  </td>  </tr>  </table>'

	SET @textdefaultTemplateForDefaultAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Event ID: <EVENT ID> MsgNewLine_MsgTab_ Monitoring Criteria: <MONITORING CRITERIA STRING> MsgNewLine_MsgTab_ Severity: <EVENT SEVERITY> MsgNewLine_MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Event Date: <EVENT DATE> MsgNewLine_MsgTab_ Program: <EVENT PROGRAM> MsgNewLine_MsgTab_ Client: <CLIENT DISPLAY NAME> MsgNewLine_MsgTab_ Description: <DESCRIPTION> MsgNewLine_MsgTab_'

	DECLARE @eventCriteriaXml NVARCHAR(MAX)

	SET @eventCriteriaXml = '<?xml version=''1.0'' encoding=''UTF-8''?><LogMonitoring_ConditionsList criteriaName="(Severity contains Critical;) AND (Description contains Media ID of the OML does not match) AND (Locale equals to English)" opBetweenConditions="0">

	  <conditions operation="2" value1="&lt;?xml version=''1.0'' encoding=''UTF-8''?>&lt;LogMonitoring_IntegersList>&lt;valuesList val=&quot;9&quot; />&lt;/LogMonitoring_IntegersList>" value2="" isregex="0" isCaseSensitive="0" isInclusive="0" matchWholeWord="0">

		<column _type_="87" columnId="1" columnName="Severity" />

	  </conditions>

	  <conditions operation="2" value1="Media ID of the OML does not match" value2="" isregex="0" isCaseSensitive="0" isInclusive="0" matchWholeWord="0">

		<column _type_="87" columnId="7" columnName="Description" />

	  </conditions>

	  <conditions operation="0" value1="&lt;?xml version=''1.0'' encoding=''UTF-8''?>&lt;LogMonitoring_IntegersList>&lt;valuesList val=&quot;0&quot; />&lt;/LogMonitoring_IntegersList>" value2="" isregex="0" isCaseSensitive="0" isInclusive="0" matchWholeWord="0">

		<column _type_="87" columnId="8" columnName="Locale" />

	  </conditions>

	</LogMonitoring_ConditionsList>'
	INSERT INTO @alertsToAdd


	SELECT		@createdAlertsId,

				58,		-- 'NT_ALERTTYPE_EVENT_MONITORING''

				'Tape OML Mismatch Alert',

				'Default alert for Tape OML Mismatch',

				@textdefaultTemplateForDefaultAlert,

				@htmldefaultTemplateForDefaultAlert,

				@allClientXmlEntities
	INSERT INTO @criteriasToAdd


	SELECT @createdAlertsId, 62 /* NT_EVENT_MONITORING */, NULL, NULL, NULL
	INSERT INTO @simpanaEventCriteria VALUES ( @createdAlertsId , @eventCriteriaXml )


	IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN

				  CLOSE newDefaultAlertsCursor

	IF ( CURSOR_STATUS('global','newDefaultAlertsCursor') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursor') = -1 )

			DEALLOCATE newDefaultAlertsCursor

	DECLARE newDefaultAlertsCursor CURSOR FOR

			SELECT  alertId, alertType, notificationName, description, msgFmtText, msgFmtHtml , XmlEntities 

				FROM @alertsToAdd

	OPEN newDefaultAlertsCursor

	FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId,@alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml,@cursorXmlEntities 

	WHILE @@FETCH_STATUS = 0

	BEGIN

		-- Check whether this alert is already present. If so, dont insert again. 

		IF EXISTS(SELECT 1 FROM NTNotificationRule

				WHERE notificationName=@notificationName AND revision=1

		)

		BEGIN

				FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId, @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml, @cursorXmlEntities 

				CONTINUE

		END
		INSERT INTO NTNotificationRule (categoryId,             alertTypeId,


										notificationName,       revision,

										lastModified,           description,

										notifType,              notifOwner,

										locale,                 status,

										ruleState,              ruleState2,

										lastTimeTriggered,      lastTimeTriggered2,

										lastTimeChecked,        hasAttachments,

										hasAttachments2,        xmlEntityList,

										origCCId,               GUID			)

		SELECT                          categoryID,             @alertType,

										@notificationName,      1,

										@nowTime,               @description,

										@notifType,             @adminID,                     

										@localeId,              (1|2048),

										-- Status 1 OR 2048 ( disabled and Default alert)

										@ruleState,             @ruleState,

										@emptyDateTime,         @emptyDateTime,

										@emptyDateTime,         0,

										0,                      @cursorXmlEntities ,

										2,                      newid() 

		FROM NTAlerttype where id = @alertType

		SET @thisAlertId = @@Identity 
		INSERT INTO NTSelCriteria (availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)


		SELECT criteriaId,1, @thisAlertId, 0, 0, 0

		FROM @criteriasToAdd

		WHERE alertId = @alertId

		IF EXISTS(SELECT 1 FROM @criteriasToAdd WHERE alertId = @alertId AND criteriaParamType IS NOT NULL AND 

				criteriaParamValue IS NOT NULL AND criteriaParamUnit IS NOT NULL)

		BEGIN
				INSERT INTO NTSelCriteriaParams (selCriteriaid, paramIndex, type, value, unit, occurrences)


				SELECT id, 0, criteriaParamType, criteriaParamValue, criteriaParamUnit, 0

				FROM NTSelcriteria , @criteriasToAdd newCriterias

				WHERE NTSelcriteria.ruleid = @thisAlertId

					AND newCriterias.alertId = @alertId

					AND newCriterias.criteriaParamType IS NOT NULL 

					AND newCriterias.criteriaParamValue IS NOT NULL AND newCriterias.criteriaParamUnit IS NOT NULL

		END           
		INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)            


				VALUES (@thisAlertId, 1, null, null, 0)
		INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)            


				VALUES (@thisAlertId, 2, null, null, 0)

		-- ADD DEFAULT (EMAIL) MESSAGE:                 

																--
		INSERT INTO NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,


										SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,

										baseDir,userName,password, rssID, messageFormatType, formatStringHtml)

				VALUES        (@thisAlertId, 1, 1, @msgFmtText, N'', 

							0, 0, 0, 0, 2,

									'', '', '', '', 1, @msgFmtHtml)                

		IF(@alertId = 1)

		BEGIN
			INSERT INTO NTnotificationUsers(NtnotificationId,userId,escalationLevel)


			SELECT @thisAlertId, @adminID, 1              

		END

		ELSE

		BEGIN
			INSERT INTO NTnotificationGroups(NTNotificationId,groupId,escalationLevel)


			SELECT @thisAlertId, @masterGroupId, 1

		END       

		-- Add an entry into for "Simpana Event Log Monitoring" AlertType if criteria is present

		IF(@alertType=58)

		BEGIN

				DECLARE @templateId int

				-- Only one template for Simpana events. Hence retrieve the template id and store it here.

				SELECT @templateId = templateId

				FROM APP_Template

				WHERE templateForMonitoringType = 3
				INSERT INTO NTSimpanaEventCriteria(commcellId, notifRuleId, templateId, criteriaXML, severity)


				SELECT 2, @thisAlertId, @templateId, criteriaxml, 0

				FROM @simpanaEventCriteria 

				WHERE alertId =  @alertId

		END

		FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId, @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml, @cursorXmlEntities              

	END

END TRY

BEGIN CATCH

	SET @errorCode = ERROR_NUMBER()

	SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

END CATCH

IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN

	CLOSE newDefaultAlertsCursor

IF ( CURSOR_STATUS('global','newDefaultAlertsCursor') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursor') = -1 )

	DEALLOCATE newDefaultAlertsCursor

IF @errorCode = 0

	COMMIT TRAN

ELSE

BEGIN

	IF LEN(@errorString) > 0

		Print @errorString

	ELSE

		Print 'SQL Error encountered while running the script hence rolling back Transaction'

	ROLLBACK TRAN

END

