

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDefaultSyntheticFullUnusualDropAlert.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- ----------------------------------------------------------------------

--  WARNING: THIS ALERT (Default synthetic full unusual drop alert) IS

--           DROPPED BY DEFAULT AS THE ALERT (Unusual Job Activity) IS

--           NOW DEFAULT FOR THIS PURPOSE. THIS SCRIPT WAS KEPT TO

--           DROP THIS ALERT WHERE IT WAS ALREADY COMMITED.

-- ----------------------------------------------------------------------*/

-- Add simpana event viewer alert for Synthetic Full dropped files detection event.

DECLARE  @errorCode         INT         

DECLARE  @errorString       NVARCHAR(1024)

declare @guid uniqueidentifier = 'EE333652-C461-4D89-96D3-29E06EF55DAE'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       

DECLARE @globalParamPlanUpdateExec INT = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamPlanUpdateExec = 1)        -- not done, create the activity monitoring dashboard

BEGIN

    RETURN -- Dont execute below.

END

DECLARE @thisAlertId                INT

SET @errorCode  = 0

SET @errorString = ''

BEGIN TRY

    BEGIN TRAN
    INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'NTDefaultSyntheticFullUnusualDropAlert', 'Default synthetic full unusual drop alert', @curUtcDateTime, 16, 0 , (16 + 2))

    -- Check whether this alert is already present. If so, disable it. 

    IF EXISTS(SELECT 1 FROM NTNotificationRule

            WHERE notificationName='Synthetic Full Unusual Drop Alert' AND revision > 0

    )

    BEGIN

            UPDATE NTnotificationRule set status = 2, revision = 0 WHERE notificationName = 'Synthetic Full Unusual Drop Alert'            

    END

END TRY

BEGIN CATCH

    SET @errorCode = ERROR_NUMBER()

    SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

END CATCH

IF @errorCode = 0

    COMMIT TRAN

ELSE

BEGIN

    IF LEN(@errorString) > 0

        Print @errorString

    ELSE

        Print 'SQL Error encountered while running the script hence rolling back Transaction'

    ROLLBACK TRAN

END

