

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDefaultServiceBasedAlert.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 2016  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/NTDefaultServiceBasedAlert.script,v $ $Id: NTDefaultServiceBasedAlert.script,v 1.1.2.10 2019/12/12 19:24:09 sjohnson Exp $";

GO

SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON

GO

declare @guid uniqueidentifier = '4B074291-A19D-4463-A4BB-35D561AEAF5B'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       

DECLARE @globalParamAlertCreateExec INT = 0

SELECT @globalParamAlertCreateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

declare  @errorCode             integer = 0

declare  @errorString           nvarchar(1024) = ''

IF (@globalParamAlertCreateExec = 0)        -- not done, create the default alerts.

BEGIN

	--DELETE GXUniqueSQLScriptExecTracking gp WHERE Name ='DefaultServiceBasedAlert'

	-- Tbl script file should not have any function calls because they may not exist during upgrade

	DECLARE @nowTime			as integer	= datediff(second, '01/01/1970', getUTCDate())

	DECLARE @xmlEntities		AS nvarchar(MAX)= '<CVGui_CommCellTreeNode xmlns:xsi="http:--www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_CommCellTreeNodeType.xsd"><trackingSchedules /><trackingJobs /><associations _type_="2" clientGroupId="0" clientGroupName="" clientId="0" clientName="" applicationId="0" appName="" instanceId="0" instanceName="" backupsetId="0" backupsetName="" subclientId="0" subclientName="" mediaAgentId="0" mediaAgentName="" schedulePolicyId="0" schedulePolicyName="" libraryId="0" libraryName="" storagePolicyId="0" storagePolicyName="" copyId="0" copyName="" trackingPolicyId="0" trackingPolicyName="" workflowId="0" workflowName="" policyId="0" policyName="" criteriaId="0" criteriaName="" /></CVGui_CommCellTreeNode>'

	DECLARE	@emptyDateTime		AS datetime	= '1900-01-01 00:00:00.000'

	DECLARE @localeId			AS integer		= 1

	DECLARE @status				AS integer		= 1 		

	DECLARE	@ruleState			AS integer		= 0

DECLARE	@reportOptions		AS integer		= 1		-- 'NT_REPORT_IMMEDIATE'

DECLARE	@categoryId			as integer 		= 8				-- 'NT_CATEGORY_OPERATION_MANAGEMENT'

	DECLARE @adminID			as integer		= ISNULL((Select top 1 ID from UMUSERS where (flags & 67) = 67 AND Name <> 'ROMS'), 1)

DECLARE @notifType			AS integer		= (1	+ 8192)

	DECLARE @SelCriteriaId		integer

	DECLARE @thisCriteria		int

	--

	DECLARE @alertType			INTEGER

	DECLARE @categoryType		INTEGER

DECLARE @notificationName	NVARCHAR(128)			-- 'NT_MAX_NOTIFICATION_NAME_SIZE'

DECLARE @description		NVARCHAR(1024)			-- 'NT_MAX_ALERT_DESCRIPTION_SIZE'

	DECLARE @msgFmtText			NVARCHAR(max) 

	DECLARE @msgFmtHtml 		NVARCHAR(max)

	DECLARE @alertsToAdd table (

			alertType			int Not Null,

			categoryType			int,

notificationName	nvarchar(128),

description			nvarchar(1024),

			msgFmtText			nvarchar(max),

			msgFmtHtml			nvarchar(max)

	)

	--

	DECLARE	@thisAlertId		integer

	DECLARE @NTAlertCIEntries	INT

	SET @errorCode	= 0

	SET @errorString= ''

	SET @NTAlertCIEntries = 0

	BEGIN TRY

		IF (@@TRANCOUNT = 0)

		BEGIN

				 BEGIN TRANSACTION NTAlertCIEntries

				 SET @NTAlertCIEntries = 1

		END
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'DefaultServiceBasedAlert', 'Create default service based alerts', @curUtcDateTime, 16, 0 , (16 + 2))

		UPDATE NTNotificationRule 

					SET notificationName = 'Web end point - Offline',

status = (@status | 2048)

					WHERE notificationName = 'Service unreachable'

		UPDATE NTNotificationRule 

					SET notificationName = 'Web end point - Online',

status = (@status | 2048)

					WHERE notificationName = 'Service up and running'

		INSERT @alertsToAdd VALUES(

58,

				1,

				'Web end point - Offline',

				'Alert for service down or unreachable.',

				'<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: admin MsgNewLine_ MsgNewLine_ MsgTab_ Event ID: <EVENT ID> MsgNewLine_MsgTab_ Monitoring Criteria: <MONITORING CRITERIA STRING> MsgNewLine_MsgTab_ Severity: <EVENT SEVERITY> MsgNewLine_MsgTab_ Job ID: N\A MsgNewLine_MsgTab_ Event Date: <EVENT DATE> MsgNewLine_MsgTab_ Program: <EVENT PROGRAM> MsgNewLine_MsgTab_ Client: <CLIENT DISPLAY NAME> MsgNewLine_MsgTab_ Description: <DESCRIPTION> MsgNewLine_MsgTab_',

				'<SUBJECT BEGIN>Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE><IS ESCALATED?><SUBJECT END><body bgcolor="#ffffff" text="#000000" link="#0000ff" vlink="#0000ff" alink="#0000ff"><table border="0" cellpadding="5" cellspacing="1" width="100%"><tr><td colspan=2 bgcolor="#D1DDF5"><font face="verdana" size="2"><b>Title</b></font></td></tr><tr><td width="120" bgcolor="#EBF4F7"><font face="verdana" size="2">&lt;ALERT NAME&gt;</font></td><td width="580" bgcolor="#F9F9F5"><font face="verdana, helvetica, arial" size="2">&lt;CLIENT DISPLAY NAME&gt;</font></td></tr><tr><td colspan=2 bgcolor="#D1DDF5"><font face="verdana" size="2"><b>Message</b></font></td></tr><tr><td width="120" bgcolor="#EBF4F7"><font face="verdana" size="2">Message</font></td><td width="580" bgcolor="#F9F9F5"><font face="verdana, helvetica, arial" size="2">&lt;DESCRIPTION&gt;</font></td></tr> <tr><td width="120" bgcolor="#EBF4F7"><font face="verdana" size="2">Detected Time</font></td><td width="580" bgcolor="#F9F9F5"><font face="verdana, helvetica, arial" size="2">&lt;TIME&gt;</font></td></tr><tr><td width="120" bgcolor="#EBF4F7"><font face="verdana" size="2">CommCell</font></td><td width="580" bgcolor="#F9F9F5"><font face="verdana, helvetica, arial" size="2">&lt;COMMCELL NAME&gt;</font></td></tr><tr><td width="120" bgcolor="#EBF4F7"><font face="verdana" size="2">Event ID</font></td><td width="580" bgcolor="#F9F9F5"><font face="verdana, helvetica, arial" size="2">&lt;EVENT ID&gt;</font></td></tr><tr><td colspan=2 bgcolor="#D1DDF5"><font face="verdana" size="2"><b>Alarm Details</b></font></td></tr><tr><td width="120" bgcolor="#EBF4F7"><font face="verdana" size="2">Message</font></td><td width="580" bgcolor="#F9F9F5"><font face="verdana, helvetica, arial" size="2">&lt;DESCRIPTION&gt;</font></td></tr><tr><td width="120" bgcolor="#EBF4F7"><font face="verdana" size="2">Device Name</font></td><td width="580" bgcolor="#F9F9F5"><font face="verdana, helvetica, arial" size="2">&lt;CLIENT DISPLAY NAME&gt;</font></td></tr><tr><td width="120" bgcolor="#EBF4F7"> <font face="verdana" size="2">Error Condition</font></td><td width="580" bgcolor="#F9F9F5"><font face="verdana, helvetica, arial" size="2">&lt;ALERT NAME&gt;</font></td></tr></table><table border="0" cellpadding="5" cellspacing="1" width="100%"><tr><td align="right" bgcolor="#D1DDF5"><font face="verdana, helvetica, arial" size="2">Generated at &lt;EVENT DATE&gt;</font></td></tr></table></body>'

				)

		INSERT @alertsToAdd VALUES(

58,

				2,

				'Web end point - Online',

				'Alert for service state changed to running.',

				'<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: admin MsgNewLine_ MsgNewLine_ MsgTab_ Event ID: <EVENT ID> MsgNewLine_MsgTab_ Monitoring Criteria: <MONITORING CRITERIA STRING> MsgNewLine_MsgTab_ Severity: <EVENT SEVERITY> MsgNewLine_MsgTab_ Job ID: N\A MsgNewLine_MsgTab_ Event Date: <EVENT DATE> MsgNewLine_MsgTab_ Program: <EVENT PROGRAM> MsgNewLine_MsgTab_ Client: <CLIENT DISPLAY NAME> MsgNewLine_MsgTab_ Description: <DESCRIPTION> MsgNewLine_MsgTab_',

				'<SUBJECT BEGIN>Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE><IS ESCALATED?><SUBJECT END><body bgcolor="#ffffff" text="#000000" link="#0000ff" vlink="#0000ff" alink="#0000ff"><table border="0" cellpadding="5" cellspacing="1" width="100%"><tr><td colspan=2 bgcolor="#D1DDF5"><font face="verdana" size="2"><b>Title</b></font></td></tr><tr><td width="120" bgcolor="#EBF4F7"><font face="verdana" size="2">&lt;ALERT NAME&gt;</font></td><td width="580" bgcolor="#F9F9F5"><font face="verdana, helvetica, arial" size="2">&lt;CLIENT DISPLAY NAME&gt;</font></td></tr><tr><td colspan=2 bgcolor="#D1DDF5"><font face="verdana" size="2"><b>Message</b></font></td></tr><tr><td width="120" bgcolor="#EBF4F7"><font face="verdana" size="2">Message</font></td><td width="580" bgcolor="#F9F9F5"><font face="verdana, helvetica, arial" size="2">&lt;DESCRIPTION&gt;</font></td></tr> <tr><td width="120" bgcolor="#EBF4F7"><font face="verdana" size="2">Detected Time</font></td><td width="580" bgcolor="#F9F9F5"><font face="verdana, helvetica, arial" size="2">&lt;TIME&gt;</font></td></tr><tr><td width="120" bgcolor="#EBF4F7"><font face="verdana" size="2">CommCell</font></td><td width="580" bgcolor="#F9F9F5"><font face="verdana, helvetica, arial" size="2">&lt;COMMCELL NAME&gt;</font></td></tr><tr><td width="120" bgcolor="#EBF4F7"><font face="verdana" size="2">Event ID</font></td><td width="580" bgcolor="#F9F9F5"><font face="verdana, helvetica, arial" size="2">&lt;EVENT ID&gt;</font></td></tr><tr><td colspan=2 bgcolor="#D1DDF5"><font face="verdana" size="2"><b>Alarm Details</b></font></td></tr><tr><td width="120" bgcolor="#EBF4F7"><font face="verdana" size="2">Message</font></td><td width="580" bgcolor="#F9F9F5"><font face="verdana, helvetica, arial" size="2">&lt;DESCRIPTION&gt;</font></td></tr><tr><td width="120" bgcolor="#EBF4F7"><font face="verdana" size="2">Device Name</font></td><td width="580" bgcolor="#F9F9F5"><font face="verdana, helvetica, arial" size="2">&lt;CLIENT DISPLAY NAME&gt;</font></td></tr><tr><td width="120" bgcolor="#EBF4F7"> <font face="verdana" size="2">Alert Condition</font></td><td width="580" bgcolor="#F9F9F5"><font face="verdana, helvetica, arial" size="2">&lt;ALERT NAME&gt;</font></td></tr></table><table border="0" cellpadding="5" cellspacing="1" width="100%"><tr><td align="right" bgcolor="#D1DDF5"><font face="verdana, helvetica, arial" size="2">Generated at &lt;EVENT DATE&gt;</font></td></tr></table></body>'

				)

		-- check if cursor exists

		IF ( CURSOR_STATUS('global', 'newServiceBasedAlertCursor') >= 0   OR CURSOR_STATUS('local', 'newServiceBasedAlertCursor') >= 0 )  -- CLOSE CURSOR IF OPEN

			CLOSE newServiceBasedAlertCursor

		IF ( CURSOR_STATUS('global','newServiceBasedAlertCursor') = -1     OR CURSOR_STATUS('local','newServiceBasedAlertCursor') = -1 )

			DEALLOCATE newServiceBasedAlertCursor

		DECLARE newServiceBasedAlertCursor CURSOR STATIC FOR

			SELECT  alertType, categoryType, notificationName, description, msgFmtText, msgFmtHtml

			   FROM @alertsToAdd

		OPEN newServiceBasedAlertCursor

		FETCH NEXT FROM newServiceBasedAlertCursor INTO @alertType, @categoryType, @notificationName, @description, @msgFmtText, @msgFmtHtml

		WHILE @@FETCH_STATUS = 0

		BEGIN

			IF NOT EXISTS(SELECT * FROM NTNotificationRule WITH(NOLOCK) where alertTypeId = @alertType AND notificationName = @notificationName AND categoryId =@categoryId)

			BEGIN	

				INSERT NTNotificationRule (	categoryId,				alertTypeId,

										notificationName,		revision,

										lastModified,			description,

										notifType,				notifOwner,

										locale,					status,

										ruleState,				ruleState2,

										lastTimeTriggered,		lastTimeTriggered2,

										lastTimeChecked,		hasAttachments,

										hasAttachments2,		xmlEntityList,

										origCCId,				GUID)

				VALUES (					@categoryId,			@alertType,

										@notificationName,		1,

										@nowTime,				@description,

										@notifType,				@adminID,

0,					(@status | 2048),

											-- 1 DefaultLocale US-English .. Create  default alerts in disabled state

										-- 2048 for for specifying the alert is systam generated.

										@ruleState,				@ruleState,

										@emptyDateTime,			@emptyDateTime,

										@emptyDateTime,			0,

										0,						@xmlEntities,

										default,				newid() )

				SET @thisAlertId = (SELECT Id FROM NTNotificationRule WITH(NOLOCK) where alertTypeId = @alertType AND notificationName = @notificationName AND categoryId =@categoryId)

	--		ADD CRITERIA:

				INSERT NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)

				VALUES(62, 1, @thisAlertId, @reportOptions, 0, 0 )		-- 'NT_EVENT_MONITORING'

				IF @categoryType = 1

				BEGIN	
					INSERT INTO NTSimpanaEventCriteria


					VALUES( 2,	@thisAlertId,	4, '<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_ConditionsList criteriaName="(Event Code equals to 72:176) AND (Locale equals to English)" opBetweenConditions="0"><conditions operation="0" value1="72:176" value2="" isregex="1" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="6" columnName="Event Code" /></conditions><conditions operation="0" value1="&lt;?xml version=''1.0'' encoding=''UTF-8''?>&lt;LogMonitoring_IntegersList>&lt;valuesList val=&quot;0&quot; />&lt;/LogMonitoring_IntegersList>" value2="" isregex="1" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="8" columnName="Locale" /></conditions></LogMonitoring_ConditionsList>',	0)

				END

				IF @categoryType = 2

				BEGIN	
					INSERT INTO NTSimpanaEventCriteria


					VALUES( 2,	@thisAlertId,	4, '<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_ConditionsList criteriaName="(Event Code equals to 72:164|72:165) AND (Locale equals to English)" opBetweenConditions="0"><conditions operation="0" value1="72:164|72:165" value2="" isregex="1" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="6" columnName="Event Code" /></conditions><conditions operation="0" value1="&lt;?xml version=''1.0'' encoding=''UTF-8''?>&lt;LogMonitoring_IntegersList>&lt;valuesList val=&quot;0&quot; />&lt;/LogMonitoring_IntegersList>" value2="" isregex="1" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="8" columnName="Locale" /></conditions></LogMonitoring_ConditionsList>',	0)

				END

-- ADD DEFAULT (EMAIL) MESSAGE:

			--		ADD DEFAULT (EMAIL) MESSAGE:		

				INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,

								SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,

								baseDir,userName,password, rssID, messageFormatType, formatStringHtml)

				VALUES		(@thisAlertId, 16, 1, '', N'',

							 0, 0, 0, 0, 0,

							 '', '', '', '', 0, '')

				INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,

									SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,

									baseDir,userName,password, rssID, messageFormatType, formatStringHtml)

					VALUES		(@thisAlertId, 1, 1, @msgFmtText, N'',

								 0, 0, 0, 0, 0,

								 '', '', '', '', 1, @msgFmtHtml)

				INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,

									SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,

									baseDir,userName,password, rssID, messageFormatType, formatStringHtml)

					VALUES		(@thisAlertId, 8192, 1, @msgFmtText, N'',

								 0, 0, 0, 0, 0,

								 '', '', '', '', 1, @msgFmtHtml)

	-- ADD DEFAULT USER (SHOULDN'T HAVE TO DO THIS, BUT REQ'D TO SUPPORT CURRENT ALERT GUI)

				INSERT NTnotificationUsers  (NTnotificationID, userId,    escalationLevel)

				VALUES (@thisAlertId, @adminID, 1)	

			END

			ELSE

			BEGIN		

			--update event id

				IF @categoryType = 1

				BEGIN

					SET @thisAlertId = (SELECT Id FROM NTNotificationRule WITH(NOLOCK) where alertTypeId = @alertType AND notificationName = @notificationName AND categoryId =@categoryId)

					UPDATE NTmessageFormat

					SET formatStringHtml=@msgFmtHtml

					WHERE NTnotificationID = @thisAlertId AND messageType in(1,8192)		

					UPDATE NTSimpanaEventCriteria

					SET criteriaXML = '<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_ConditionsList criteriaName="(Event Code equals to 72:176) AND (Locale equals to English)" opBetweenConditions="0"><conditions operation="0" value1="72:176" value2="" isregex="1" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="6" columnName="Event Code" /></conditions><conditions operation="0" value1="&lt;?xml version=''1.0'' encoding=''UTF-8''?>&lt;LogMonitoring_IntegersList>&lt;valuesList val=&quot;0&quot; />&lt;/LogMonitoring_IntegersList>" value2="" isregex="1" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="8" columnName="Locale" /></conditions></LogMonitoring_ConditionsList>'

					where notifRuleId = @thisAlertId

				END

				IF @categoryType = 2

				BEGIN

					SET @thisAlertId = (SELECT Id FROM NTNotificationRule WITH(NOLOCK) where alertTypeId = @alertType AND notificationName = @notificationName AND categoryId =@categoryId)

					UPDATE NTmessageFormat

					SET formatStringHtml=@msgFmtHtml

					WHERE NTnotificationID = @thisAlertId AND messageType in(1,8192)	

					UPDATE NTSimpanaEventCriteria

					SET criteriaXML = '<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_ConditionsList criteriaName="(Event Code equals to 72:164|72:165) AND (Locale equals to English)" opBetweenConditions="0"><conditions operation="0" value1="72:164|72:165" value2="" isregex="1" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="6" columnName="Event Code" /></conditions><conditions operation="0" value1="&lt;?xml version=''1.0'' encoding=''UTF-8''?>&lt;LogMonitoring_IntegersList>&lt;valuesList val=&quot;0&quot; />&lt;/LogMonitoring_IntegersList>" value2="" isregex="1" isCaseSensitive="0" isInclusive="0" matchWholeWord="0"><column _type_="87" columnId="8" columnName="Locale" /></conditions></LogMonitoring_ConditionsList>'

					where notifRuleId = @thisAlertId

				END

			END			

			FETCH NEXT FROM newServiceBasedAlertCursor INTO @alertType, @categoryType, @notificationName, @description, @msgFmtText, @msgFmtHtml		

		END		

		CLOSE newServiceBasedAlertCursor

		DEALLOCATE newServiceBasedAlertCursor	

		Update NTNotificationRule 

		set revision = 0, status=2

		where notificationName in ('Service unreachable Alert')

	END TRY

	BEGIN CATCH

		set @errorCode = ERROR_NUMBER()

		set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()	 

	END CATCH

	IF ( CURSOR_STATUS('global', 'newServiceBasedAlertCursor') >= 0   OR CURSOR_STATUS('local', 'newServiceBasedAlertCursor') >= 0 )  -- CLOSE CURSOR IF OPEN

			CLOSE newServiceBasedAlertCursor

	IF ( CURSOR_STATUS('global','newServiceBasedAlertCursor') = -1     OR CURSOR_STATUS('local','newServiceBasedAlertCursor') = -1 )

			DEALLOCATE newServiceBasedAlertCursor

	IF @errorCode = 0

		IF (@NTAlertCIEntries = 1)

		 BEGIN

			COMMIT TRANSACTION NTAlertCIEntries

			SET @NTAlertCIEntries = 0

		END

	ELSE 

		IF (@NTAlertCIEntries = 1)

		BEGIN

			IF LEN(@errorString) > 0

				Print @errorString

			ELSE

				Print 'SQL Error encountered while running the script hence rolling back Transaction'

			ROLLBACK TRANSACTION NTAlertCIEntries

			SET @NTAlertCIEntries = 0

		END

END

