

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDefaultScaleOutDiskHealthAlert.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/NTDefaultScaleOutDiskHealthAlert.script,v $ $Id: NTDefaultScaleOutDiskHealthAlert.script,v 1.1.2.5 2020/06/25 03:34:33 shubhamagrawal Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

DECLARE  @errorCode INT         

DECLARE  @errorString VARCHAR(1024) 

BEGIN TRY

	DECLARE @alertCreationGuid uniqueidentifier = 'C876A922-5A16-481C-9092-7D231E4B4A22'

	DECLARE @makingDiskIdPrimaryKeyGuid uniqueidentifier = '0DD2DE45-CD4A-42DA-8297-4BD216FAEC67' --this GUID was used in this script before, so it could be present in DB

	--DECLARE @addingVolumeNotMountedAlertGuid uniqueidentifier = '7C3D7897-7429-4491-8AB3-67102B47CF9C' --this GUI was also used in this script before, so it could be present in DB

	DECLARE @addingVolumeNotMountedAlertGuid uniqueidentifier = 'D411DF82-E99D-4684-9A38-FDF9DB6EF7B4'

	DECLARE @nowTime INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

	DECLARE @thisAlertId        INT

	DECLARE @xmlEntitites		NVARCHAR(MAX) = '<CVGui_CommCellTreeNode><clients includeAll="0" /><clientGroups includeAll="0" /><libraries includeAll="0" /><mediaAgents includeAll="0" /><storagePolcies includeAll="0" /><trackingPolicies includeAll="0" /><trackingSchedules /><trackingJobs /><criterias includeAll="0" /> <workflows includeAll="0" /><commcells includeAll="0" /></CVGui_CommCellTreeNode>'

	DECLARE @adminID			INT = ISNULL((SELECT TOP 1 id from UMUsers where (flags & 67) = 67), 1)

	DECLARE @alertId			INT = 1

	DECLARE @alertType          INT = 65

	DECLARE @notifType          INT = 131073

	DECLARE @localeId           INT = 0

	DECLARE @ruleState          INT = 1

	DECLARE @emptyDateTime      DATETIME = '1900-01-01 00:00:00.000'

	DECLARE @reportOptions      INT = 1                 -- 'NT_REPORT_IMMEDIATE'

	DECLARE @notificationName   NVARCHAR(128)   = 'Scale out disk health'             -- 'NT_MAX_NOTIFICATION_NAME_SIZE'

	DECLARE @description        NVARCHAR(1024)  = 'Default alert for Hyperscale Disk Health' 

	DECLARE @queryName NVARCHAR(MAX) = 'ScaleOutDiskHealthRule'

	DECLARE @queryId INT

	DECLARE @defaultFreq INT = 3600

	DECLARE @msgFmtText NVARCHAR(MAX) = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_ MsgNewLine_ MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Alert Rule Name : <QUERY NAME> MsgNewLine_MsgTab_ Storage Pool : <INDEX 1> MsgNewLine_MsgTab_ Node : <INDEX 3> MsgNewLine_MsgTab_ Drive : <INDEX 6> MsgNewLine_MsgTab_ Mount Point : <INDEX 7> MsgNewLine_MsgTab_ Issue : <INDEX 9> MsgNewLine_MsgTab_ Condition Cleared: : <CONDITION CLEARED Y/N>'

	DECLARE @queryString NVARCHAR(MAX)= 'exec MMGetScaleOutDiskHealthAlertInfo'

	DECLARE @criteriasToAdd table ( alertId             INT,

									criteriaId          INT,

									criteriaParamType   INT,

									criteriaParamValue  INT,

									criteriaParamUnit   INT

									PRIMARY KEY(alertId,criteriaId)

								)
	INSERT INTO @criteriasToAdd


		SELECT @alertId, 75 /* NT_GENERIC_QUERY (Custom Query)*/, NULL, NULL, NULL

	BEGIN TRAN

		IF NOT EXISTS ( SELECT 1 FROM GXUniqueSQLScriptExecTracking  WITH(NOLOCK) WHERE SqlScriptGUID = @alertCreationGuid )

		BEGIN

			-- Check whether this alert is already present. If so, dont insert again.

	        IF NOT EXISTS (SELECT 1 FROM NTNotificationRule WHERE notificationName=@notificationName AND revision=1)

			BEGIN

				-- Status 2049 ( Default alert, disabled ). Creating this alert in disabled state
				INSERT INTO NTNotificationRule (categoryId, alertTypeId,  notificationName, revision, lastModified,  description,  notifType, notifOwner,    locale, status,  ruleState, ruleState2, lastTimeTriggered, lastTimeTriggered2, lastTimeChecked, hasAttachments, hasAttachments2, xmlEntityList, origCCId,	 GUID )


				       SELECT                            9,  @alertType, @notificationName,        1,     @nowTime, @description, @notifType,   @adminID, @localeId, (2048), @ruleState, @ruleState,    @emptyDateTime,     @emptyDateTime,  @emptyDateTime,			  0,			   0, @xmlEntitites,		2, newid()

	                   FROM NTAlertType WHERE id = @alertType

				SET @thisAlertId = @@Identity
				INSERT INTO NTSelCriteria(availCriteriaid, esclationLevel,		 ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)


	                SELECT					   criteriaId,				1, @thisAlertId,   @reportOptions,				  0,				0

	                FROM @criteriasToAdd WHERE alertId = @alertId

				IF EXISTS (SELECT 1 FROM @criteriasToAdd WHERE alertId = @alertId AND criteriaParamType IS NOT NULL AND  criteriaParamValue IS NOT NULL AND criteriaParamUnit IS NOT NULL)

	            BEGIN
	                INSERT INTO NTSelCriteriaParams (selCriteriaid, paramIndex,				type,				value,				unit, occurrences)


						SELECT									id,			 0, criteriaParamType, criteriaParamValue, criteriaParamUnit,		0

						FROM NTSelcriteria , @criteriasToAdd newCriterias

						WHERE NTSelcriteria.ruleid = @thisAlertId

							AND newCriterias.alertId = @alertId

							AND newCriterias.criteriaParamType IS NOT NULL 

							AND newCriterias.criteriaParamValue IS NOT NULL 

							AND newCriterias.criteriaParamUnit IS NOT NULL

	            END
				INSERT INTO NTmessages	(NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)


	                    VALUES			(	 @thisAlertId,				 1,				  NULL,			   NULL,		0),

										(	 @thisAlertId,				 2,				  NULL,			   NULL,		0)

				DECLARE @formatStringHtml NVARCHAR(MAX)

IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name='UseNewAlertTemplate' AND value=1 and modified=0)

					SET @formatStringHtml = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border-top-color: #2f4e66; border-top-style: solid; border-top-width: 1px; border-right-color: #2f4e66; border-right-style: solid; border-right-width: 1px; border-bottom-color: #2f4e66; border-bottom-style: solid; border-bottom-width: 1px; border-left-color: #2f4e66; border-left-style: solid; border-left-width: 1px"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"><td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Alert Rule Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;QUERY NAME&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif">&lt;TABLE DATA&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Condition Cleared</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CONDITION CLEARED Y/N&gt;</font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At: &lt;TIME&gt; </font> </td> </tr> </table> </center></td> </tr> </table></div>'

				ELSE

					SET @formatStringHtml = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellpadding="0" cellspacing="0" border="1" align="center" width="100%" style="border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-style: solid; border-top-color: #dedede; border-right-color: #dedede; border-bottom-color: #dedede; border-left-style: solid; border-right-style: solid; border-top-width: 0px; border-right-width: 0px"> <tr> <td> <center> <table cellpadding="0" border="0" id="contentTbl" width="100%" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td valign="middle" align="left"> <div style="margin-left: 10px; margin-bottom: 4px; margin-top: 4px"> <font size="6" face="Helvetica,sans-serif" color="#EEEEEE">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td colspan="1" valign="middle" align="left" bgcolor="#DCDEDE"> <ul style="margin-top: 4px; margin-bottom: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>CommCell: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-top: 4px; margin-bottom: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>Type: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-top: 4px; margin-bottom: 4px"> <font size="3" face="Helvetica,sans-serif" color="#000000">User: &lt;USER NAME&gt;</font> </li> <li style="margin-top: 4px; margin-bottom: 4px"> <font size="3" face="Helvetica,sans-serif" color="#000000">Alert Rule Name : &lt;QUERY NAME&gt;</font> </li> <font size="3" face="Helvetica,sans-serif" color="#000000">&lt;TABLE DATA&gt;</font> <li style="margin-top: 4px; margin-bottom: 4px"> <font size="3" face="Helvetica,sans-serif" color="#000000">Condition Cleared: : &lt;CONDITION CLEARED Y/N&gt;</font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">   </td> </tr> </table> </center> </td> </tr> </table> </div>' 
				INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage, SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions, messageFormatType, formatStringHtml)


	                    VALUES				(	 @thisAlertId,			 1,				  1,  @msgFmtText,				N'',			  0,			0,			  0,		  0,		 0,					1, @formatStringHtml),

											(	 @thisAlertId,		131072,				  1,  @msgFmtText,				N'',			  0,			0,			  0,		  0,		 0,					0,				N'')
				INSERT INTO NTnotificationUsers(NtnotificationId,	userId, escalationLevel)


	                SELECT							@thisAlertId, @adminID,		1

				IF NOT EXISTS ( SELECT 1 FROM NTQueryList WHERE queryName = @queryName)

	            BEGIN

					Print  'Creating alert Rule "Scale Out Disk Health Rule" since its not present  in the machine'

						DECLARE @GUID VARCHAR(40) = NEWID()

						Declare @queryDescription NVARCHAR(MAX) = 'Rule detects disks with I/O test failure, smart test failure,gluster daemon issues and those missing in previous health check cycles.'

						Declare @xmlInfo NVARCHAR(MAX) = '<?xml version="1.0" encoding="UTF-16" standalone="no" ?><App_AdditionalQueryDetails alertCriteria="0" alertType="0" isHealthParam="0" querySeverity="1"><externalQueryEntity _type_="125"/><scriptDescription description="Rule detects disks with I/O test failure, smart test failure,gluster daemon issues and those missing in previous health check cycles." guid="D7894C45-CEDA-4E0D-873D-2A6AD2552F5C" reportName="ScaleOutDiskHealthRule" revision="$Revision: 1.1.2.5 $ M&lt;1533153226441>"/></App_AdditionalQueryDetails>'
						INSERT INTO NTQueryList VALUES


		                   (	0,    -- queryMessageId

								@defaultFreq, --default frequency 

								0,     -- status 

								1,     -- Query Creator

								1,     -- Visibility

								0,     -- Task Id,

								@queryString,

								@xmlInfo,

								@queryName, -- queryName

								@queryDescription,

								'',                     -- queryCriteriaName

								@GUID,                  -- GUID

								'<App_Associations><entity _type_="125" /></App_Associations>', -- commcellAssociation ----

								1                       -- isOverwriteAssociationAtAlertAllowed

		                   ) 

				END

				DECLARE @taskId	 INT

				SELECT @queryId = queryId , @taskId = taskId FROM NTQueryList  WHERE queryName  = @queryName  

				DELETE FROM NTQueryColumnList WHERE QueryId = @queryId
	            INSERT INTO NTQueryColumnList


					VALUES	(@queryId,	0,	0,	0,	'SDSStoragePoolId',			'StoragePoolId',	1,	'0,1,4,5,6,7',	0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>'),

							(@queryId,	1,	0,	1,	'StoragePoolName',			'Storage Pool',		0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

							(@queryId,	2,	0,	0,	'clientId',					'Node Id',			1,	'0,1,4,5,6,7',	0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>'),

							(@queryId,	3,	0,	1,	'hostName',					'Node',				0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

							(@queryId,	4,	0,	0,	'diskId',					'diskId',			1,	'0,1,4,5,6,7',	0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>'),

							(@queryId,	5,	0,	1,	'StorageLibrary',			'Library',			0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>'),

							(@queryId,	6,	0,	1,	'blockDevPath',				'Drive',			0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

							(@queryId,	7,	0,	1,	'brickPath',				'Mount Point',		0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

							(@queryId,	8,	0,	0,	'IssueType',				'Issue Type',		1,	'0,1,4,5,6,7',	0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>'),

							(@queryId,	9,	0,	1,	'Issue',					'Issue',			0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/> ')
				INSERT INTO NTNotificationQueryMapping 


					VALUES( @queryId, @thisAlertId, @emptyDateTime, @emptyDateTime,  0, @taskId,

							'',

							'<CVGui_QueryAdditionalInfo><queryParameters/><externalQueryInfo _type_="125"/></CVGui_QueryAdditionalInfo>',

							'',

							@queryName

						)

			END
			INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


					VALUES(@alertCreationGuid , 'NTDefaultAlert_ScaleOutDiskHealthAlert', 'Tblscript to add default alerts for HyperScale hardware components', @nowTime, 16, 0 , (16 + 2))

		END

		IF NOT EXISTS ( SELECT 1 FROM GXUniqueSQLScriptExecTracking  WITH(NOLOCK) WHERE SqlScriptGUID = @addingVolumeNotMountedAlertGuid )

		AND EXISTS (SELECT 1 FROM NTQueryList  WHERE queryName  = @queryName)

		BEGIN

			SELECT @queryId = queryId FROM NTQueryList  WHERE queryName  = @queryName  

			UPDATE NTQueryList

			SET  	queryString = @queryString, 

					defaultfrequency = IIF(defaultfrequency = 86400, @defaultFreq, defaultfrequency)

			WHERE queryName = @queryName

			UPDATE C

SET reportingOptions = 1

			FROM NTSelCriteria C

				INNER JOIN NTNotificationQueryMapping map ON map.NtNotificationId = C.ruleId

			WHERE QueryId = @queryId

			UPDATE C

			SET 	messageFormatType = IIF(messageType = 1, 1, 0),

					formatString = @msgFmtText

			FROM 	NTmessageFormat C

				INNER JOIN NTNotificationQueryMapping map ON map.NtNotificationId = C.NtNotificationId

			WHERE map.QueryId = @queryId

			DELETE FROM NTQueryColumnList WHERE QueryId = @queryId
	        INSERT INTO NTQueryColumnList


				VALUES	(@queryId,	0,	0,	0,	'SDSStoragePoolId',			'StoragePoolId',	1,	'0,1,4,5,6,7',	0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>'),

						(@queryId,	1,	0,	1,	'StoragePoolName',			'Storage Pool',		0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

						(@queryId,	2,	0,	0,	'clientId',					'Node Id',			1,	'0,1,4,5,6,7',	0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>'),

						(@queryId,	3,	0,	1,	'hostName',					'Node',				0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

						(@queryId,	4,	0,	0,	'diskId',					'diskId',			1,	'0,1,4,5,6,7',	0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>'),

						(@queryId,	5,	0,	1,	'StorageLibrary',			'Library',			0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>'),

						(@queryId,	6,	0,	1,	'blockDevPath',				'Drive',			0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

						(@queryId,	7,	0,	1,	'brickPath',				'Mount Point',		0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

						(@queryId,	8,	0,	0,	'IssueType',				'Issue Type',		1,	'0,1,4,5,6,7',	0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>'),

						(@queryId,	9,	0,	1,	'Issue',					'Issue',			0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/> ')
			INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


					VALUES(@addingVolumeNotMountedAlertGuid , 'NTDefaultAlert_ScaleOutDiskHealthAlert_VolumeNotMountedAlert', 'Update Script to add volume not mounted alert support', @nowTime, 16, 0 , (16 + 2))

		END

	COMMIT TRAN 

END TRY

BEGIN CATCH

	SET @errorCode = ERROR_NUMBER()

    SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

	Print @errorString

	ROLLBACK TRAN

END CATCH

