

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDefaultIndexStateAlert.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

DECLARE  @errorCode			INT         

DECLARE  @errorString		VARCHAR(1024)   

DECLARE @nowTime			INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

DECLARE @taskId				INT

DECLARE @xmlEntities		NVARCHAR(MAX)= '<CVGui_CommCellTreeNode>

	<associations _type_="124" commCellId="2" />

	<clientGroups includeAll="0" />

	<clients includeAll="0" />

	<commcells includeAll="0" />

	<criterias includeAll="0" />

	<libraries includeAll="0" />

	<mediaAgents includeAll="0" />

	<storagePolcies includeAll="0" />

	<trackingJobs />

	<trackingPolicies includeAll="0" />

	<trackingSchedules />

	<workflows includeAll="0" />

</CVGui_CommCellTreeNode>'

DECLARE @adminID			INT = ISNULL((SELECT TOP 1 id from UMUsers where (flags & 67) = 67), 1)

DECLARE	@emptyDateTime		DATETIME = '1900-01-01 00:00:00.000'

DECLARE @localeId			INT = 0

DECLARE	@ruleState			INT = 1					-- Alert Severity

DECLARE	@reportOptions		INT = 1					-- 'NT_REPORT_IMMEDIATE'

DECLARE @persistTimeSeconds INT = 0

DECLARE @createdAlertsId	INT = 1

DECLARE @notifType			INT = 139265			-- 'NT_EMAIL_ALERTNOTIF' + 'NT_LIVEFEEDS_ALERTNOTIF' + 'NT_ALERTNOTIF_FOR_CI'

DECLARE @queryId			INT

----  FOR CURSOR -----

DECLARE @alertId			INT

DECLARE @alertType			INT

DECLARE @notificationName	NVARCHAR(128)			-- 'NT_MAX_NOTIFICATION_NAME_SIZE'

DECLARE @description		NVARCHAR(1024)			-- 'NT_MAX_ALERT_DESCRIPTION_SIZE'

DECLARE @msgFmtText			NVARCHAR(max)

DECLARE @msgFmtHtml 		NVARCHAR(max)

DECLARE @cursorXmlEntities  NVARCHAR(MAX)

--

--

DECLARE @alertsToAdd table (

		alertId				INT PRIMARY KEY,

		alertType			INT NOT NULL,

		notificationName	NVARCHAR(128),

		description			NVARCHAR(1024),

		msgFmtText			NVARCHAR(MAX),

		msgFmtHtml			NVARCHAR(MAX),

		xmlEntities			NVARCHAR(MAX)

)

DECLARE @criteriasToAdd table (

		alertId				INT,

		criteriaId			INT,

		criteriaParamType	INT,

		criteriaParamValue	INT,

		criteriaParamUnit	INT

		PRIMARY KEY(alertId,criteriaId)

)

----------------------

DECLARE	@thisAlertId		INT

DECLARE @existingAlertId	INT

DECLARE @existingQueryId	INT

SET @errorCode	= 0

SET @errorString = ''

BEGIN TRY

	BEGIN TRAN

	--We will check what is the version of alert.

	--Version = 0 --> Alert does not exists.

	--Version >= 1 --> Alert exists but may needs to be updated (Also do not create alert again if user deleted it.)

	DECLARE @alertVersion INT

	IF EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = 'NTDefaultAlert_IndexState_Verison')

	BEGIN

		SET @alertVersion = ISNULL((SELECT value FROM GXGlobalParam WHERE name = 'NTDefaultAlert_IndexState_Verison'), 0)

	END

	ELSE

	BEGIN

		IF EXISTS (SELECT 1 FROM NTNotificationRule WHERE notificationName = 'Index State' AND revision = 1)

			SET @alertVersion = 1

		ELSE IF EXISTS (SELECT 1 FROM NTQueryList WHERE queryName = 'Index State')

			SET @alertVersion = 1

		ELSE

			SET @alertVersion = 0

	END

	IF (@alertVersion = 0) -- Alert does not exist, therefore create.

	BEGIN

		DECLARE @htmldefaultTemplateForNoIndexBackupAlert NVARCHAR(max)

		DECLARE @textdefaultTemplateForNoIndexBackupAlert NVARCHAR(max)

IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name='UseNewAlertTemplate' AND value=1)

			SET @htmldefaultTemplateForNoIndexBackupAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Alert Rule Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;QUERY NAME&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif">&lt;TABLE DATA&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Condition Cleared</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CONDITION CLEARED Y/N&gt;</font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'

		ELSE

			SET @htmldefaultTemplateForNoIndexBackupAlert = '

	<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table cellpadding="0" cellspacing="0" border="1" align="center" width="100%" style="border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-style: solid; border-top-color: #dedede; border-right-color: #dedede; border-bottom-color: #dedede; border-left-style: solid; border-right-style: solid; border-top-width: 0px; border-right-width: 0px">

	 <tr>

	 <td>

	 <center>

	 <table cellpadding="0" border="0" id="contentTbl" width="100%" align="center" cellspacing="0">

	 <tr style="background-color: #666666">

	 <td valign="middle" align="left">

	 <div style="margin-left: 10px; margin-bottom: 4px; margin-top: 4px">

	 <font size="6" face="Helvetica,sans-serif" color="#EEEEEE">&lt;ALERT NAME&gt; </font>

	 </div>

	 </td>

	 </tr>

	 <tr>

	 <td colspan="1" valign="middle" align="left" bgcolor="#DCDEDE">

	 <ul style="margin-top: 4px; margin-bottom: 4px">

	 <font size="4" face="Helvetica,sans-serif"><strong>CommCell: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong>

	 </ul>

	 <ul style="margin-top: 4px; margin-bottom: 4px">

	 <font size="4" face="Helvetica,sans-serif"><strong>Type: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong>

	 </ul>

	 </td>

	 </tr>

	 <tr>

	 <td width="100%" colspan="1" align="left">

	 <ul>

	 <li style="margin-top: 4px; margin-bottom: 4px">

	 <font size="3" face="Helvetica,sans-serif" color="#000000">User: &lt;USER NAME&gt;

	</font> </li>

	 <li style="margin-top: 4px; margin-bottom: 4px">

	 <font size="3" face="Helvetica,sans-serif" color="#000000">Alert Rule Name : &lt;QUERY NAME&gt;

	</font> </li>

	 <font size="3" face="Helvetica,sans-serif" color="#000000">&lt;TABLE DATA&gt;

	</font>

	 <li style="margin-top: 4px; margin-bottom: 4px">

	 <font size="3" face="Helvetica,sans-serif" color="#000000">Condition Cleared: : &lt;CONDITION CLEARED Y/N&gt;

	</font> </li>

	 </ul>

	 </td>

	 </tr>

	 <tr style="background-color: #666666">

	 <td colspan="1" align="left">

 	  Please check for reason and escalate the issue

	 </td>

	 </tr>

	 </table>

	 </center>

	 </td>

	 </tr>

	 </table>'

		SET @textdefaultTemplateForNoIndexBackupAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_ MsgNewLine_ MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Alert Rule Name : <QUERY NAME> MsgNewLine_MsgTab_ ClientName : <INDEX 0> MsgNewLine_MsgTab_ Agent : <INDEX 1> MsgNewLine_MsgTab_ BackupsetName : <INDEX 2> MsgNewLine_MsgTab_ DbName : <INDEX 3> MsgNewLine_MsgTab_ IndexServer : <INDEX 4> MsgNewLine_MsgTab_ Last successful job (time) : <INDEX 5> MsgNewLine_MsgTab_ errorstatus : <INDEX 6> MsgNewLine_MsgTab_ Remarks : <INDEX 7> MsgNewLine_MsgTab_ Condition Cleared: : <CONDITION CLEARED Y/N>'
		INSERT INTO @alertsToAdd VALUES(


				@createdAlertsId,

				65,		-- 'NT_ALERTTYPE_CUSTOM_QUERY'

				'Index State',

				'Default alert for error status of index',

				@textdefaultTemplateForNoIndexBackupAlert,

				@htmldefaultTemplateForNoIndexBackupAlert,

				@xmlEntities

		)
		INSERT INTO @criteriasToAdd


		SELECT @createdAlertsId, 75 /* NT_GENERIC_QUERY (Custom Query)*/, NULL, NULL, NULL

		IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN

			CLOSE newDefaultAlertsCursor

		IF ( CURSOR_STATUS('global','newDefaultAlertsCursor') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursor') = -1 )

			DEALLOCATE newDefaultAlertsCursor

		DECLARE newDefaultAlertsCursor CURSOR FOR

			SELECT  alertId, alertType, notificationName, description, msgFmtText, msgFmtHtml, xmlEntities

				FROM @alertsToAdd

		OPEN newDefaultAlertsCursor

		FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId, @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml, @cursorXmlEntities

		WHILE @@FETCH_STATUS = 0

		BEGIN

			-- Check whether this alert is already present. If so, dont insert again.

			IF EXISTS (SELECT 1 FROM NTNotificationRule

				WHERE notificationName=@notificationName AND revision=1

			)

			BEGIN

				FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId, @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml, @cursorXmlEntities

				CONTINUE

			END
			INSERT INTO NTNotificationRule (categoryId,				alertTypeId,


											notificationName,		revision,

											lastModified,			description,

											notifType,				notifOwner,

											locale,					status,

											ruleState,				ruleState2,

											lastTimeTriggered,		lastTimeTriggered2,

											lastTimeChecked,		hasAttachments,

											hasAttachments2,		xmlEntityList,

											origCCId,				GUID            )

			SELECT							categoryID,						@alertType,

											@notificationName,		1,

											@nowTime,				@description,

											@notifType,				@adminID,

											@localeId,				(2048),								    

											-- 2048 for specifying the alert is system generated.

											@ruleState,				@ruleState,

											@emptyDateTime,			@emptyDateTime,

											@emptyDateTime,			0,

											0,						@cursorXmlEntities ,

											2,						newid()

			FROM NTAlertType WHERE id = @alertType

			SET @thisAlertId = @@Identity
			INSERT INTO NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)


			SELECT criteriaId, 1, @thisAlertId, @reportOptions , 0, @persistTimeSeconds

			FROM @criteriasToAdd

			WHERE alertId = @alertId

			IF EXISTS (SELECT 1 FROM @criteriasToAdd WHERE alertId = @alertId AND criteriaParamType IS NOT NULL AND

				criteriaParamValue IS NOT NULL AND criteriaParamUnit IS NOT NULL)

			BEGIN
				INSERT INTO NTSelCriteriaParams (selCriteriaid, paramIndex, type, value, unit, occurrences)


				SELECT id, 0, criteriaParamType, criteriaParamValue, criteriaParamUnit, 0

				FROM NTSelcriteria , @criteriasToAdd newCriterias

				WHERE NTSelcriteria.ruleid = @thisAlertId

					AND newCriterias.alertId = @alertId

					AND newCriterias.criteriaParamType IS NOT NULL 

					AND newCriterias.criteriaParamValue IS NOT NULL AND newCriterias.criteriaParamUnit IS NOT NULL

			END
			INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)


				VALUES (@thisAlertId, 1, null, null, 0)
			INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)


				VALUES (@thisAlertId, 2, null, null, 0)

			-- :ADD DEFAULT MESSAGES:--
			INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


								SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

								messageFormatType, formatStringHtml)

				VALUES		(@thisAlertId, 1, 1, @msgFmtText, N'',

               					0, 0, 0, 0, 0,

								1, @msgFmtHtml)
			INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


								SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

								messageFormatType, formatStringHtml)

				VALUES		(@thisAlertId, 8192, 1, @msgFmtText, N'',

               					0, 0, 0, 0, 0,

								1, @msgFmtHtml)
			INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


								SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

								messageFormatType, formatStringHtml)

				VALUES		(@thisAlertId, 131072, 1, @msgFmtText, N'',

               					0, 0, 0, 0, 0,

								0, N'')
			INSERT INTO NTnotificationUsers(NtnotificationId,userId,escalationLevel)


			SELECT @thisAlertId,@adminID,1

			FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId, @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml, @cursorXmlEntities

			IF NOT EXISTS ( SELECT 1 FROM NTQueryList WHERE queryName = 'Index State')

			BEGIN

				Print  'Creating alert Rule " Index State " since its not present  in the machine '

				DECLARE @GUID VARCHAR(40)

				SET @GUID = NEWID()
				INSERT INTO NTQueryList VALUES


				(

				0 ,    -- queryMessageId

				86400, --default frequency

				0,     -- status 

				1,     -- Query Creator

				1,     -- Visibility

				0,     -- Task Id 

				-----  Query ---------- 

	'DECLARE @tcur INT = dbo.GetUnixTime(getdate())

	SELECT * INTO #tempIDAType FROM dbo.getIdxAppTypeNames()

	IF object_id(''dbo.IdxDbState'') IS NOT NULL

	SELECT DISTINCT CC.name ClientName, ida.appName Agent, bs.name BackupsetName, idx.dbName DbName, mm.name IndexServer, 

	st.properties.value(''(/Indexing_DbStats/@lastCompletedBkpTime)[1]'',''INT'') AS LastSuccessfullJobTime,

	(CASE WHEN st.errorLvl > 0 AND st.errorLvl <=5 THEN 1 ELSE 0 END) errorstatus, 

	st.errorDesc Remarks

	FROM App_IndexDBInfo idx WITH (NOLOCK) 

	JOIN APP_BackupSetName bs WITH (NOLOCK) ON bs.id = idx.backupSetId 

	JOIN APP_Application app WITH (NOLOCK) ON app.backupSet = bs.id 

	JOIN APP_Client CC WITH (NOLOCK) ON cc.id = app.clientId 

	JOIN app_client mm WITH (NOLOCK) ON mm.id = idx.currentIdxServer

	JOIN #tempIDAType ida WITH (NOLOCK) ON idx.type = ida.idxAppType

	LEFT JOIN IdxDbState st ON idx.id = st.dbId'

	------------------------- Query ends ------------------------------------------------

				,

				---- xmlInfo ----

				'<?xml version="1.0" encoding="UTF-16" standalone="no" ?><App_AdditionalQueryDetails querySeverity="1"><externalQueryEntity _type_="125"/><scriptDescription guid="4ccbe58e-3ffb-42b0-9b95-52ba124ddbb4"/></App_AdditionalQueryDetails>',

				'Index State',	-- queryName

				'Indicates error status of index',		--queryDescription

				'',						-- queryCriteriaName

				@GUID,					-- GUID

				---- commcellAssociation ----

				'<App_Associations>

					<entity _type_="124" clientSidePackage="1" commCellId="2" consumeLicense="1" srmReportSet="0" srmReportType="0" type="0" />

				</App_Associations>',

				1						-- isOverwriteAssociationAtAlertAllowed

				)

			END

			SELECT @queryId = queryId , @taskId = taskId FROM NTQueryList  

			WHERE queryName  = 'Index State'

			IF NOT EXISTS (SELECT 1 FROM NTQueryColumnList WHERE QueryId = @queryId)

			BEGIN
				INSERT INTO NTQueryColumnList VALUES


				(

				@queryId ,  0 , 0 , 1 , 'ClientName' , 'ClientName' , 0 ,'2,3,0,1' , 0 , '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1"/>'

				)
				INSERT INTO NTQueryColumnList VALUES


				(

				@queryId ,  1 , 0 , 1 , 'Agent' , 'Agent' , 0 ,'2,3,0,1' , 0 , '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1"/>'

				)
				INSERT INTO NTQueryColumnList VALUES


				(

				@queryId ,  2 , 0 , 1 , 'BackupsetName' , 'BackupsetName' , 0 ,'2,3,0,1' , 0 , '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1"/>'

				)
				INSERT INTO NTQueryColumnList VALUES


				(

				@queryId ,  3 , 0 , 1 , 'DbName' , 'DbName' , 0 ,'2,3,0,1' , 0 , '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1"/>'

				)
				INSERT INTO NTQueryColumnList VALUES


				(

				@queryId ,  4 , 0 , 1 , 'IndexServer' , 'IndexServer' , 0 ,'2,3,0,1' , 0 , '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1"/>'

				)
				INSERT INTO NTQueryColumnList VALUES


				(

				@queryId ,  5 , 0 , 2 , 'LastSuccessfullJobTime' , 'Last successful job (time)' , 0 ,'0,1,4,5,6,7' , 0 , '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1"/>'

				)
				INSERT INTO NTQueryColumnList VALUES


				(

				@queryId ,  6 , 1 , 0 , 'errorstatus' , 'errorstatus' , 0 ,'0,1,4,5,6,7' , 0 , '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0"/>'

				)
				INSERT INTO NTQueryColumnList VALUES


				(

				@queryId ,  7 , 0 , 1 , 'Remarks' , 'Remarks' , 0 ,'2,3,0,1' , 0 , '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1"/>'

				)

			END
			INSERT INTO NTNotificationQueryMapping 


			VALUES(

				@queryId, @thisAlertId, @emptyDateTime, @emptyDateTime,

				0, @taskId,

				'<LogMonitoring_CriteriaList opBetweenCriterias="0"><criteriaList conditionsXML="&lt;?xml version=''1.0'' encoding=''UTF-8''?>&lt;LogMonitoring_ConditionsList criteriaName=&quot;(errorstatus equals to 1)&quot; opBetweenConditions=&quot;0&quot;>&lt;conditions isCaseSensitive=&quot;0&quot; value1=&quot;1&quot; operation=&quot;0&quot;>&lt;column columnName=&quot;errorstatus&quot; />&lt;/conditions>&lt;/LogMonitoring_ConditionsList>" criteriaId="0" criteriaName="(errorstatus equals to 1)"/></LogMonitoring_CriteriaList>',

				'<CVGui_QueryAdditionalInfo><externalQueryInfo _type_="125"/><queryParameters/></CVGui_QueryAdditionalInfo>',

				'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><CVGui_CommcellQueryCriteriaStringList><commcellQueryCriterias commcellId="2" queryCriteriaString="(  ( errorstatus = ''1''  )  )"/><commcellQueryCriterias commcellId="0" queryCriteriaString="(  ( errorstatus = ''1''  )  )"/></CVGui_CommcellQueryCriteriaStringList>',

				'Index State'

			)	
			INSERT INTO GXGlobalParam VALUES ('NTDefaultAlert_IndexState_Verison', 2, @nowTime, 0)


		END

	END	

	ELSE IF (@alertVersion >= 1) -- Alert exists but may not be updated with correct values therefore update. Or Do not update if user deleted the alert.

	BEGIN

		IF EXISTS (SELECT 1 FROM NTNotificationRule WHERE notificationName = 'Index State' AND revision=1)

		BEGIN

			SET @existingAlertId = (SELECT id FROM NTNotificationRule WHERE notificationName = 'Index State' AND revision=1)

			UPDATE NTNotificationQueryMapping

			SET isScheduled = 0,

			nextRunTime = @emptyDateTime

			WHERE NtNotificationId = @existingAlertId AND taskId = 0

			UPDATE NTSelCriteria

			SET reportingOptions = @reportOptions,

			persistTimeSeconds = @persistTimeSeconds

			WHERE ruleId = @existingAlertId

		END

		IF EXISTS (SELECT 1 FROM NTQueryList WHERE queryName = 'Index State')

		BEGIN

			SET @existingQueryId = (SELECT queryId FROM NTQueryList WHERE queryName  = 'Index State')

			IF EXISTS(SELECT 1 FROM NTQueryColumnList WHERE columnName = 'LastSuccessfullJobTime' AND lmDataType = 1 AND queryId = @existingQueryId)

				UPDATE NTQueryColumnList SET lmDataType = 2, columnFriendlyName = 'Last successful job (time)'

				WHERE queryId = @existingQueryId AND columnName = 'LastSuccessfullJobTime'

			UPDATE NTQueryList

			SET queryString = 

	'IF object_id(''tempdb.dbo.#AppsExcluded'') IS NOT NULL DROP TABLE #AppsExcluded

IF object_id(''tempdb.dbo.#tempValidApps'') is not null DROP TABLE #tempValidApps

IF object_id(''tempdb.dbo.#tempSCIndexBS'') is not null DROP TABLE #tempSCIndexBS

DECLARE @criticalDaysIdxState INT = 3

DECLARE @transientErrorBufferTime BIGINT = dbo.GetUnixTime(GETUTCDATE() - 3)

CREATE TABLE #AppsExcluded(appId INT, PRIMARY KEY(appId))

-- List of apps that has backup activity disabled thru different entry points
INSERT INTO #AppsExcluded


SELECT DISTINCT APP.id   -- Backup disabled for Client Group

FROM APP_Application APP WITH (NOLOCK)

	JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON APP.clientId = CGA.clientId

	JOIN JMJobAction J WITH (NOLOCK) ON J.opType = 4 AND J.action = 1

	AND CGA.clientGroupId = J.clientGroupId AND J.clientGroupId > 0 AND J.clientId = 1 AND J.appType = 0 AND J.appId = 1

UNION

SELECT DISTINCT APP.id   -- Backup disabled for Subclient Policy

FROM APP_Application APP WITH (NOLOCK)

	JOIN (

		SELECT componentNameId AS appId, CAST(attrVal AS INT) AS subclientPolicyAppId

		FROM APP_SubClientProp WITH (NOLOCK)

		WHERE attrName = ''Associated subclient Policy'' AND cs_attrName = CHECKSUM(N''Associated subclient Policy'') AND modified = 0

	) T ON APP.id = T.appId

	JOIN JMJobAction J WITH (NOLOCK) ON J.opType = 4 AND J.action = 1

	AND J.appId = T.subclientPolicyAppId

UNION

SELECT DISTINCT APP.id   -- Backup disabled for Subclient

FROM APP_Application APP WITH (NOLOCK)

	JOIN JMJobAction J WITH (NOLOCK) ON J.opType = 4 AND J.action = 1

	AND J.appId = APP.id

UNION

SELECT DISTINCT APP.id   -- Backup disabled for Client: 1) For all appTypes 2) For a particular appType

FROM APP_Application APP WITH (NOLOCK)

	JOIN JMJobAction J WITH (NOLOCK) ON J.opType = 4 AND J.action = 1

    AND J.clientId = APP.ClientId AND J.appType IN (APP.appTypeId, 0)  

UNION

SELECT DISTINCT APP.id   -- Backup Disabled for Instance

FROM APP_Application APP WITH (NOLOCK)

	JOIN JMJobAction J WITH (NOLOCK) ON J.opType = 4 AND J.action = 1

    AND J.instanceId = APP.instance AND J.instanceId > 1

SELECT DISTINCT BS.id INTO #tempSCIndexBS

FROM APP_BackupSetName BS WITH(NOLOCK) 

WHERE  dbo.isSubClientIndexEnabled(BS.id)  = 1

-- Exclude Legal Hold clients
INSERT INTO #AppsExcluded (appId)


SELECT DISTINCT APP.id FROM APP_Application APP WITH (NOLOCK)

JOIN APP_BackupSetProp PROP WITH (NOLOCK) ON PROP.componentNameId = APP.backupSet

WHERE PROP.attrName = ''OnDemand Backupset'' AND PROP.attrVal = ''1'' AND PROP.modified = 0

AND NOT EXISTS(SELECT 1 FROM #AppsExcluded WHERE #AppsExcluded.appId = APP.id)

SELECT DISTINCT APP.id id INTO #tempValidApps 

FROM APP_Application APP WITH (NOLOCK) 

JOIN ARCHFILE AF WITH (NOLOCK) ON AF.appId = APP.id and AF.isValid = 1 AND AF.fileType IN (2,6)

JOIN archFileCopy AFC WITH (NOLOCK) ON AF.id = AFC.archFileId AND AFC.isValid = 1 AND (AFC.flags & 256 = 0)

WHERE APP.subclientStatus & 4214 = 0 --CV_STATUS_UNINSTALLED, CV_STATUS_DELETED, CV_STATUS_DUMMY, CV_STATUS_HIDDEN, CV_STATUS_CMD_LINE, CV_STATUS_LOGCMD_LINE

AND NOT EXISTS(SELECT 1 FROM #AppsExcluded WHERE #AppsExcluded.appId = APP.id)

SELECT DISTINCT CC.name ClientName, ida.name Agent, bs.name BackupsetName,

(CASE WHEN TBS.id IS NULL THEN idx.backupSetGUID ELSE APP.guid END) DbName,

mm.name IndexServer, 

CONVERT(varchar, dbo.UTCToCellLocalTime(dbo.GetDateTime(ISNULL(st.properties.value(''(/Indexing_DbStats/@lastCompletedBkpTime)[1]'',''INT''),0) ),2),0) LastSuccessfullJobTime,

(CASE WHEN (st.errorLvl BETWEEN 1 AND 5) AND (ISNULL(st.properties.value(''(/Indexing_DbStats/@lastIdxErrorTime)[1]'',''INT''), -1) < @transientErrorBufferTime) THEN 1 ELSE 0 END) errorstatus, st.errorDesc Remarks

FROM App_IndexDBInfo idx WITH (NOLOCK)

JOIN APP_BackupSetName BS WITH (NOLOCK) on BS.id = idx.backupSetId 

JOIN idxdbstate st WITH(NOLOCK) ON idx.id = st.dbId

JOIN APP_Application app WITH (NOLOCK) on app.backupSet = bs.id 

JOIN #tempValidApps apps ON APP.id = APPS.id 

JOIN APP_Client CC WITH (NOLOCK) on cc.id = app.clientId 

JOIN app_client mm WITH (NOLOCK) on mm.id = idx.currentIdxServer

JOIN APP_iDAType ida WITH (NOLOCK) on APP.appTypeId = IDA.type

LEFT JOIN #tempSCIndexBS TBS ON BS.id = TBS.id

WHERE (TBS.id IS NULL OR APP.GUID = idx.dbName)'

			WHERE queryName = 'Index State'

			UPDATE NTQueryColumnList

			SET isPrimaryKey = 0

			WHERE queryId = @existingQueryId AND isPrimaryKey = 1

		END

		IF NOT EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = 'NTDefaultAlert_IndexState_Verison')

		BEGIN
			INSERT INTO GXGlobalParam VALUES ('NTDefaultAlert_IndexState_Verison', 2, @nowTime, 0)


		END

		ELSE

		BEGIN

			UPDATE GXGlobalParam SET value = 2 WHERE name = 'NTDefaultAlert_IndexState_Verison'

		END

	END

END TRY

BEGIN CATCH

	SET @errorCode = ERROR_NUMBER()

	SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

END CATCH

IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN

	CLOSE newDefaultAlertsCursor

IF ( CURSOR_STATUS('global','newDefaultAlertsCursor') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursor') = -1 )

	DEALLOCATE newDefaultAlertsCursor

IF @errorCode = 0

	COMMIT TRAN

ELSE

BEGIN

	IF LEN(@errorString) > 0

		Print @errorString

	ELSE

		Print 'SQL Error encountered while running the script hence rolling back Transaction'

	ROLLBACK TRAN

END

