

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDefaultEventBasedAlertForRecallFailure.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

DECLARE  @errorCode INT         

DECLARE  @errorString VARCHAR(1024)   

DECLARE @Alertguid uniqueidentifier

SELECT  @Alertguid = 'DABBECEC-35D8-4257-8602-D8E5022EB6BC'

IF NOT EXISTS ( SELECT 1 FROM GXUniqueSQLScriptExecTracking  WITH(NOLOCK) WHERE SqlScriptGUID = @Alertguid )

BEGIN 

DECLARE @nowTime			INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

DECLARE @xmlEntities		NVARCHAR(MAX)= '<CVGui_CommCellTreeNode>

  <clients includeAll="0" />

  <clientGroups includeAll="0" />

  <libraries includeAll="0" />

  <mediaAgents includeAll="0" />

  <storagePolcies includeAll="0" />

  <trackingPolicies includeAll="0" />

  <trackingSchedules />

  <trackingJobs />

  <criterias includeAll="0" />

  <workflows includeAll="0" />

  <associations _type_="2" />

  <commcells includeAll="0" />

</CVGui_CommCellTreeNode>'

DECLARE @adminID			INT =  ISNULL((SELECT TOP 1 id from UMUsers where (flags & (0x001 + 0x002 + 0x040)) > 0), 1)

DECLARE @notificationName	NVARCHAR(128)	= 'Recall Failure Alert'						-- 'NT_MAX_NOTIFICATION_NAME_SIZE'

DECLARE @description		NVARCHAR(128)	= 'Default alert for recall failure'			-- 'NT_MAX_ALERT_DESCRIPTION_SIZE'

DECLARE	@emptyDateTime		DATETIME = '1900-01-01 00:00:00.000'

DECLARE @localeId			INT = 0

DECLARE	@ruleState			INT = 0				-- Alert Severity

DECLARE @notifType			INT = 131072 + 1

DECLARE @esclationLevel		INT = 1	

DECLARE	@reportOptions		INT = 1

DECLARE @delayTimeSeconds 	INT = 0

DECLARE @persistTimeSeconds INT = 0

DECLARE @msgFmtText			NVARCHAR(max)

DECLARE @msgFmtHtml 		NVARCHAR(max)

DECLARE	@thisAlertId		INT

SET @errorCode	= 0

SET @errorString = ''

BEGIN TRY

	BEGIN TRAN

IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name='UseNewAlertTemplate' AND value=1)

			SET @msgFmtHtml = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll">  <table cellspacing="0" cellpadding="0" width="100%" style="border-top-color: #2f4e66; border-top-style: solid; border-top-width: 1px; border-right-color: #2f4e66; border-right-style: solid; border-right-width: 1px; border-bottom-color: #2f4e66; border-bottom-style: solid; border-bottom-width: 1px; border-left-color: #2f4e66; border-left-style: solid; border-left-width: 1px">  <tr>  <td>  <center>  <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0">  <tr style="background-color: #2f4e66">  <td valign="middle" align="left" colspan="3">  <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px">  <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font>  </div>  </td>  </tr>  <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null">  <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px">  <font size="3" color="#444444" face="sans-serif"><b>Type </b></font>  </td>  <td colspan="2">  <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font>  </td>  </tr>  <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null">  <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px">  <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font>  </td>  <td colspan="2">  <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font>  </td>  </tr>  <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null">  <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px">  <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font>  </td>  <td colspan="2">  <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font>  </td>  </tr>  <tr>  <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td>  </tr>  <tr>  <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px">  <font size="3" color="#444444" face="sans-serif"><b>Event ID</b></font>  </td>  <td colspan="2">  <font size="3" color="#444444" face="sans-serif">&lt;EVENT ID&gt; </font>  </td>  </tr>  <tr>  <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px">  <font size="3" color="#444444" face="sans-serif"><b>Monitoring Criteria</b></font>  </td>  <td colspan="2">  <font size="3" color="#444444" face="sans-serif">&lt;MONITORING CRITERIA STRING&gt; </font>  </td>  </tr>  <tr>  <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px">  <font size="3" color="#444444" face="sans-serif"><b>Severity</b></font>  </td>  <td colspan="2">  <font size="3" color="#444444" face="sans-serif">&lt;EVENT SEVERITY&gt; </font>  </td>  </tr>  <tr>  <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px">  <font size="3" color="#444444" face="sans-serif"><b>Job ID</b></font>  </td>  <td colspan="2">  <font size="3" color="#444444" face="sans-serif">&lt;JOB ID&gt; </font>  </td>  </tr>  <tr>  <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px">  <font size="3" color="#444444" face="sans-serif"><b>Event Date</b></font>  </td>  <td colspan="2">  <font size="3" color="#444444" face="sans-serif">&lt;EVENT DATE&gt; </font>  </td>  </tr>  <tr>  <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px">  <font size="3" color="#444444" face="sans-serif"><b>Program</b></font>  </td>  <td colspan="2">  <font size="3" color="#444444" face="sans-serif">&lt;EVENT PROGRAM&gt; </font>  </td>  </tr>  <tr>  <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px">  <font size="3" color="#444444" face="sans-serif"><b>Client</b></font>  </td>  <td colspan="2">  <font size="3" color="#444444" face="sans-serif">&lt;CLIENT DISPLAY NAME&gt; </font>  </td>  </tr>  <tr>  <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px">  <font size="3" color="#444444" face="sans-serif"><b>Description</b></font>  </td>  <td colspan="2">  <font size="3" color="#444444" face="sans-serif">&lt;DESCRIPTION&gt;</font>  </td>  </tr>  <tr style="background-color: #2f4e66">  <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px">  <font size="3" face="sans-serif" color="#ffffff">Generated At: &lt;TIME&gt; </font>  </td>  </tr>  </table>  </center>  </td>  </tr>  </table>  </div>'

		ELSE

			SET @msgFmtHtml = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll">  <table cellpadding="0" cellspacing="0" border="1" align="center" width="75%" style="border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-style: solid; border-top-color: #dedede; border-right-color: #dedede; border-bottom-color: #dedede; border-left-style: solid; border-right-style: solid; border-top-width: 0px; border-right-width: 0px">  <tr>  <td>  <center>  <table cellpadding="0" border="0" id="contentTbl" width="100%" align="center" cellspacing="0">  <tr style="background-color: #666666">  <td valign="middle" align="left">  <div style="margin-left: 10px; margin-bottom: 4px; margin-top: 4px">  <font size="6" face="Helvetica,sans-serif" color="#EEEEEE">&lt;ALERT NAME&gt; </font>  </div>  </td>  </tr>  <tr>  <td colspan="1" valign="middle" align="left" bgcolor="#DCDEDE">  <ul style="margin-top: 4px; margin-bottom: 4px">  <font size="4" face="Helvetica,sans-serif"><strong>CommCell: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong>  </ul>  <ul style="margin-top: 4px; margin-bottom: 4px">  <font size="4" face="Helvetica,sans-serif"><strong>Type: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong>  </ul>  <ul style="margin-top: 4px; margin-bottom: 4px">  <font size="4" face="Helvetica,sans-serif"><strong>Detected Criteria: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;DETECTED CRITERIA&gt;</font></strong>  </ul>  <ul style="margin-top: 4px; margin-bottom: 4px">  <font size="4" face="Helvetica,sans-serif"><strong>Detected Time: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;TIME&gt;</font></strong>  </ul>  </td>  </tr>  <tr>  <td width="100%" colspan="1" align="left">  <ul>  <li style="margin-top: 4px; margin-bottom: 4px">  <font size="3" face="Helvetica,sans-serif" color="#000000">Event ID: &lt;EVENT ID&gt; </font> </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font size="3" face="Helvetica,sans-serif" color="#000000">Monitoring Criteria: &lt;MONITORING CRITERIA STRING&gt; </font> </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font size="3" face="Helvetica,sans-serif" color="#000000">Severity: &lt;EVENT SEVERITY&gt; </font> </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font size="3" face="Helvetica,sans-serif" color="#000000">Job ID: &lt;JOB ID&gt; </font> </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font size="3" face="Helvetica,sans-serif" color="#000000">Event Date: &lt;EVENT DATE&gt; </font> </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font size="3" face="Helvetica,sans-serif" color="#000000">Program: &lt;EVENT PROGRAM&gt; </font> </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font size="3" face="Helvetica,sans-serif" color="#000000">Client: &lt;CLIENT DISPLAY NAME&gt; </font> </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font size="3" face="Helvetica,sans-serif" color="#000000">Description: &lt;DESCRIPTION&gt; </font> </li>  </ul>  </td>  </tr>  <tr style="background-color: #666666">  <td colspan="1" align="left">    </td>  </tr>  </table>  </center>  </td>  </tr>  </table>  </div>'

		SET @msgFmtText	 = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Event ID  <EVENT ID> MsgNewLine_MsgTab_ Monitoring Criteria  <MONITORING CRITERIA STRING> MsgNewLine_MsgTab_ Severity  <EVENT SEVERITY> MsgNewLine_MsgTab_ Job ID  <JOB ID> MsgNewLine_MsgTab_ Event Date  <EVENT DATE> MsgNewLine_MsgTab_ Program  <EVENT PROGRAM> MsgNewLine_MsgTab_ Client  <CLIENT DISPLAY NAME> MsgNewLine_MsgTab_ Description  <DESCRIPTION>'

			-- Check whether this alert is already present. If so, dont insert again.

			IF NOT EXISTS (SELECT 1 FROM NTNotificationRule

				WHERE notificationName=@notificationName AND revision=1

			)

			BEGIN

DECLARE @status INT = 2048 + 1
			INSERT INTO NTNotificationRule (categoryId,				alertTypeId,


											notificationName,		revision,

											lastModified,			description,

											notifType,				notifOwner,

											locale,					status,

											ruleState,				ruleState2,

											lastTimeTriggered,		lastTimeTriggered2,

											lastTimeChecked,		hasAttachments,

											hasAttachments2,		xmlEntityList,

											origCCId,				GUID            )

SELECT							8, 58,

											@notificationName,		1,

											@nowTime,				@description,

											@notifType,				@adminID,

											@localeId,				@status,								    

											@ruleState,				@ruleState,

											@emptyDateTime,			@emptyDateTime,

											@emptyDateTime,			0,

											0,						@xmlEntities ,

											2,						newid()

			SET @thisAlertId = @@Identity
			INSERT INTO NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)


SELECT 62, @esclationLevel, @thisAlertId, @reportOptions , @delayTimeSeconds, @persistTimeSeconds

			DECLARE @templateId INT

			-- Only one template for Simpana events. Hence retrieve the template id and store it here.

			SELECT @templateId = templateId

			FROM

			APP_Template WHERE templateForMonitoringType = 3 -- ENUM MonitoringType::SIMPANA_EVENTVIEWER 
			INSERT INTO NTSimpanaEventCriteria


                    VALUES( 2, @thisAlertId, @templateId, '<?xml version="1.0" encoding="UTF-8"?><LogMonitoring_ConditionsList criteriaName="(Event Code equals to 72:182)" opBetweenConditions="0"><conditions matchWholeWord="0" isCaseSensitive="0" value2="" value1="72:182" isInclusive="0" isregex="0" operation="0"><column _type_="87" columnId="6" columnName="Event Code" /></conditions></LogMonitoring_ConditionsList>', 0)
			INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)


				VALUES (@thisAlertId, 1, null, null, 0)
			INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)


				VALUES (@thisAlertId, 2, null, null, 0)

			-- :ADD DEFAULT MESSAGES:--
			INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


								SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

								messageFormatType, formatStringHtml)

VALUES		(@thisAlertId, 1, 1, @msgFmtText, N'',

               					0, 0, 0, 0, 0,

								1, @msgFmtHtml)
			INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


								SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

								messageFormatType, formatStringHtml)

VALUES		(@thisAlertId, 131072, 1, @msgFmtText, N'',

               					0, 0, 0, 0, 0,

								0, N'')
			INSERT INTO NTnotificationUsers(NtnotificationId,userId,escalationLevel)


			SELECT @thisAlertId,@adminID,1

	END

END TRY

BEGIN CATCH

	SET @errorCode = ERROR_NUMBER()

	SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

END CATCH
INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


    VALUES(@Alertguid , 'NTDefaultEventBasedAlertForRecallFailure', 'Tblscript to add Alert to notify admin on recall failure', @nowTime, 16, 0 , (16 + 2))

SELECT @errorCode=@@error

IF @errorCode = 0

	COMMIT TRAN

ELSE

BEGIN

	IF LEN(@errorString) > 0

		Print @errorString

	ELSE

		Print 'SQL Error encountered while running the script hence rolling back Transaction'

	ROLLBACK TRAN

END

END
