

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDefaultEdgeDrivepausedAlert.script] ---------- 


SET QUOTED_IDENTIFIER OFF

DECLARE @errorCode INT    

DECLARE  @errorString VARCHAR(1024)

DECLARE @nowTime            INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

DECLARE @Alertguid uniqueidentifier

SELECT  @Alertguid='B786793D-5488-4752-B7A6-3695C1AAEF6E'

IF NOT EXISTS ( SELECT 1 FROM GXUniqueSQLScriptExecTracking  WITH(NOLOCK) WHERE SqlScriptGUID = @Alertguid )

BEGIN 

DECLARE @taskId             INT

DECLARE @xmlEntities        NVARCHAR(MAX)= '<CVGui_CommCellTreeNode>

  <clients includeAll="0" />

  <clientGroups includeAll="0" />

  <libraries includeAll="0" />

  <mediaAgents includeAll="0" />

  <storagePolcies includeAll="0" />

  <trackingPolicies includeAll="0" />

  <trackingSchedules />

  <trackingJobs />

  <criterias includeAll="0" />

  <workflows includeAll="0" />

  <associations _type_="125" />

  <commcells includeAll="0" />

</CVGui_CommCellTreeNode>'

DECLARE @adminID            INT = ISNULL((SELECT TOP 1 id from UMUsers where (flags & 67) = 67), 1)

DECLARE @emptyDateTime      DATETIME = '1900-01-01 00:00:00.000'

DECLARE @localeId           INT = 0

DECLARE @ruleState          INT = 2                 -- Alert Severity

DECLARE @reportOptions      INT = 1                 -- 'NT_REPORT_IMMEDIATE'

DECLARE @persistTimeSeconds INT = 0

DECLARE @createdAlertsId    INT = 1

DECLARE @notifType          INT = 139265            -- 'NT_EMAIL_ALERTNOTIF' + 'NT_LIVEFEEDS_ALERTNOTIF' + 'NT_ALERTNOTIF_FOR_CI'

DECLARE @queryId            INT

----  FOR CURSOR -----

DECLARE @alertId            INT

DECLARE @alertType          INT

DECLARE @notificationName   NVARCHAR(128)           -- 'NT_MAX_NOTIFICATION_NAME_SIZE'

DECLARE @description        NVARCHAR(1024)          -- 'NT_MAX_ALERT_DESCRIPTION_SIZE'

DECLARE @msgFmtText         NVARCHAR(max)

DECLARE @msgFmtHtml         NVARCHAR(max)

DECLARE @cursorXmlEntities  NVARCHAR(MAX)

--

--

DECLARE @alertsToAdd table (

        alertId             INT PRIMARY KEY,

        alertType           INT NOT NULL,

        notificationName    NVARCHAR(128),

        description         NVARCHAR(1024),

        msgFmtText          NVARCHAR(MAX),

        msgFmtHtml          NVARCHAR(MAX),

        xmlEntities         NVARCHAR(MAX)

)

DECLARE @criteriasToAdd table (

        alertId             INT,

        criteriaId          INT,

        criteriaParamType   INT,

        criteriaParamValue  INT,

        criteriaParamUnit   INT

        PRIMARY KEY(alertId,criteriaId)

)

----------------------

DECLARE @thisAlertId        INT

DECLARE @existingAlertId    INT

DECLARE @existingQueryId    INT

SET @errorCode  = 0

SET @errorString = ''

BEGIN TRY

    BEGIN TRAN

    IF NOT  EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = 'NTDefaultAlert_EdgeDriveWithPausedJobs_User') -- Alert does not exist, therefore create.

    BEGIN

        DECLARE @htmldefaultTemplateForNoIndexBackupAlert NVARCHAR(max)

        DECLARE @textdefaultTemplateForNoIndexBackupAlert NVARCHAR(max)

        SET @htmldefaultTemplateForNoIndexBackupAlert = 		

		'<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll">

 <h1>

 <span><font face="Helvetica,sans-serif" color="#808080">COMMVAULT</font></span>

 </h1>

 <hr> <h2>

 <span><font face="Helvetica,sans-serif" color="#808080">Edge Drive Paused Alert</font></span>

 </h2>

 <p line-height="14.4pt">

 <font face="sans-serif" size="3" color="#333333">Edge Drive has been in a paused state for more than the allowed threshold. If Edge Drive was manually paused, resume Edge Drive to continue syncing your data.If you did not pause Edge Drive, please contact your administrator for assistance.</font>

 </p>

 <p line-height="14.4pt">

 <font face="sans-serif" size="3" color="#333333">

</font> </p>

 <table cellpadding="0" cellspacing="0" border="1" align="center" width="100%" style="border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-style: solid; border-top-color: #dedede; border-right-color: #dedede; border-bottom-color: #dedede; border-left-style: solid; border-right-style: solid; border-top-width: 0px; border-right-width: 0px">

 <tr>

 <td>

 <center>

 <table cellpadding="0" border="0" id="contentTbl" width="100%" align="center" cellspacing="0">

 <tr style="background-color: #666666">

 <td colspan="1" valign="middle" align="left" bgcolor="#DCDEDE"> </td>

 </tr>

 <tr>

 <td width="100%" colspan="1" align="left">

 <font size="3" face="Helvetica,sans-serif" color="#666666">&lt;INPUT DATA&gt;&lt;TABLE DATA&gt;</font>

 </td>

 </tr>

 </table>

 </center>

 </td>

 </tr>

 </table>

 </div>'

        SET @textdefaultTemplateForNoIndexBackupAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_ MsgNewLine_ MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Alert Rule Name : <QUERY NAME> MsgNewLine_MsgTab_ <INPUT DATA> MsgNewLine_MsgTab_ JobID : <INDEX 0> MsgNewLine_MsgTab_ JobName : <INDEX 1> MsgNewLine_MsgTab_ Condition Cleared: : <CONDITION CLEARED Y/N>'
        INSERT INTO @alertsToAdd VALUES(


                @createdAlertsId,

                65,     -- 'NT_ALERTTYPE_CUSTOM_QUERY'

                'Edge Drive Has Paused Jobs (User Alert)',

                'Default alert Edge Drive Has Paused Jobs (User Alert)',

                @textdefaultTemplateForNoIndexBackupAlert,

                @htmldefaultTemplateForNoIndexBackupAlert,

                @xmlEntities

        )
        INSERT INTO @criteriasToAdd


        SELECT @createdAlertsId, 75 /* NT_GENERIC_QUERY (Custom Query)*/, NULL, NULL, NULL

        IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN

            CLOSE newDefaultAlertsCursor

        IF ( CURSOR_STATUS('global','newDefaultAlertsCursor') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursor') = -1 )

            DEALLOCATE newDefaultAlertsCursor

        DECLARE newDefaultAlertsCursor CURSOR FOR

            SELECT  alertId, alertType, notificationName, description, msgFmtText, msgFmtHtml, xmlEntities

                FROM @alertsToAdd

        OPEN newDefaultAlertsCursor

        FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId, @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml, @cursorXmlEntities

        WHILE @@FETCH_STATUS = 0

        BEGIN

            -- Check whether this alert is already present. If so, dont insert again.

            IF EXISTS (SELECT 1 FROM NTNotificationRule

                WHERE notificationName=@notificationName AND revision=1

            )

            BEGIN

                FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId, @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml, @cursorXmlEntities

                CONTINUE

            END
            INSERT INTO NTNotificationRule (categoryId,             alertTypeId,


                                            notificationName,       revision,

                                            lastModified,           description,

                                            notifType,              notifOwner,

                                            locale,                 status,

                                            ruleState,              ruleState2,

                                            lastTimeTriggered,      lastTimeTriggered2,

                                            lastTimeChecked,        HasAttachments,

                                            HasAttachments2,        xmlEntityList,

                                            origCCId,               GUID            )

            SELECT                          9,                     @alertType,

                                            @notificationName,      1,

                                            @nowTime,               @description,

                                            @notifType,             @adminID,

                                            @localeId,              (16|2048|1),											

                                            -- 2048 for specifying the alert is system generated.

											-- NT_STATUS_DISABLED 1

                                            @ruleState,             @ruleState,

                                            @emptyDateTime,         @emptyDateTime,

                                            @emptyDateTime,         0,

                                            0,                      @cursorXmlEntities ,

                                            2,                      newid()

            FROM NTAlertType WHERE id = @alertType

            SET @thisAlertId = @@Identity
            INSERT INTO NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)


            SELECT criteriaId, 1, @thisAlertId, @reportOptions , 0, @persistTimeSeconds

            FROM @criteriasToAdd

            WHERE alertId = @alertId

            IF EXISTS (SELECT 1 FROM @criteriasToAdd WHERE alertId = @alertId AND criteriaParamType IS NOT NULL AND

                criteriaParamValue IS NOT NULL AND criteriaParamUnit IS NOT NULL)

            BEGIN
                INSERT INTO NTSelCriteriaParams (selCriteriaid, paramIndex, type, value, unit, occurrences)


                SELECT id, 0, criteriaParamType, criteriaParamValue, criteriaParamUnit, 0

                FROM NTSelcriteria , @criteriasToAdd newCriterias

                WHERE NTSelcriteria.ruleid = @thisAlertId

                    AND newCriterias.alertId = @alertId

                    AND newCriterias.criteriaParamType IS NOT NULL 

                    AND newCriterias.criteriaParamValue IS NOT NULL AND newCriterias.criteriaParamUnit IS NOT NULL

            END
            INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)


                VALUES (@thisAlertId, 1, null, null, 0)
            INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)


                VALUES (@thisAlertId, 2, null, null, 0)

            -- :ADD DEFAULT MESSAGES:--
            INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


                                SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

                                messageFormatType, formatStringHtml)

                VALUES      (@thisAlertId, 1, 1, @msgFmtText, N'',

                                0, 0, 0, 0, 0,

                                1, @msgFmtHtml)
            INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


                                SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

                                messageFormatType, formatStringHtml)

                VALUES      (@thisAlertId, 131072, 1, @msgFmtText, N'',

                                0, 0, 0, 0, 0,

                                0, N'')
            INSERT INTO NTnotificationUsers(NtnotificationId,userId,escalationLevel)


            SELECT @thisAlertId,@adminID,1

            FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId, @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml, @cursorXmlEntities

            IF NOT EXISTS ( SELECT 1 FROM NTQueryList WHERE queryName = 'Edge Drive Has Paused Jobs (User Alert)')

            BEGIN

                Print  'Creating alert Rule " edge Drive Status " since its not present  in the machine '

                DECLARE @GUID VARCHAR(40)

                SET @GUID = NEWID()
                INSERT INTO NTQueryList VALUES


                (

                0 ,    -- queryMessageId

                86400, --default frequency

                0,     -- status 

                1,     -- Query Creator

                1,     -- Visibility

                0,     -- Task Id 

                -----  Query ---------- 

                'DECLARE @triggerTimeInSec INT= @UserEdgeDrivePausedThreshold * 86400  ;

DECLARE @currentTime INT= dbo.GetUnixTime(GETUTCDATE());

DECLARE @blacklist   INT = CAST(0x20 AS INT)    

DECLARE @paused   INT = CAST(0x1 AS INT)	 

DECLARE @isLaptop INT  = CAST(0x1000 AS INT)  

SELECT 

       JMJobInFo.JobID,

	   C.Name,      

	   U.email 

FROM JMJobInFo WITH (READUNCOMMITTED)

	 INNER JOIN JMBkpJobInfo WITH (READUNCOMMITTED) ON JMJobInFo.jobId = JMBkpJobInfo.jobid

	 INNER JOIN APP_Application Ap WITH (READUNCOMMITTED) ON JMBkpJobInfo.applicationId = Ap.id

	 INNER JOIN App_Subclientprop SCP WITH (READUNCOMMITTED) ON Ap.id = SCP.componentNameId	           

	 INNER JOIN UmUsers U WITH (READUNCOMMITTED) ON U.id = SCP.attrVal  	

	 INNER JOIN App_SyncCloudConfig SC WITH (READUNCOMMITTED) ON SC.subclientId = Ap.id

	 INNER JOIN App_Client C WITH (READUNCOMMITTED) ON C.id = JMBkpJobInfo.targetClientId

	 CROSS APPLY 

			 (SELECT MAX(EndTime) JobRunTime FROM   JMBkpAttemptInfo JmAttmpt WITH (READUNCOMMITTED) WHERE JmAttmpt.jobid=JMJobInFo.JobID) JobRun

WHERE 

 SCP.attrname = ''Edge Drive User Id''  AND Ap.subclientStatus& 0x20000 = 0x20000    

 AND (SC.syncType in (3,4) AND SC.flag & @paused = @paused AND SC.flag & @blacklist = 0)  

 AND SCP.Modified=0	 and ISNUMERIC(SCP.attrval)=1  AND JMJobInFo.[displayState]  in (5,15 ) AND (@currentTime - CAST(JobRunTime  AS INT)) > @triggerTimeInSec

 AND C.status = @isLaptop  

'

    ------------------------- Query ends ------------------------------------------------

                ,

                ---- xmlInfo ----

				'<?xml version="1.0" encoding="UTF-16" standalone="no" ?><App_AdditionalQueryDetails alertCriteria="0" alertType="0" defaultHtmlTemplate="" defaultTextTemplate="" isHealthParam="0" querySeverity="2"><externalQueryEntity _type_="125"/><scriptDescription description="Edge Drive Pause exceeds X Minutes." guid="B331B63C-1238-4DBA-9E49-F063662885D8" reportName="Edge Drive Has Paused Jobs (User Alert)" revision="$Revision: 1.1.2.2 $ M&lt;1518459706185>"/></App_AdditionalQueryDetails>',

                'Edge Drive Has Paused Jobs (User Alert)',  -- queryName

                'Edge Drive Pause exceeds X Minutes.',     --queryDescription

                '',                     -- queryCriteriaName

                @GUID,                  -- GUID

                ---- commcellAssociation ----

                '<App_Associations>

                    <entity _type_="124" clientSidePackage="1" commCellId="2" consumeLicense="1" srmReportSet="0" srmReportType="0" type="0" />

                </App_Associations>',

                1                       -- isOverwriteAssociationAtAlertAllowed

                )   

            END

            SELECT @queryId = queryId , @taskId = taskId FROM NTQueryList  

            WHERE queryName  = 'Edge Drive Has Paused Jobs (User Alert)'

            IF NOT EXISTS (SELECT 1 FROM NTQueryColumnList WHERE QueryId = @queryId)

            BEGIN
                INSERT INTO NTQueryColumnList VALUES


                (

                @queryId ,  0 , 0 , 0 , 'UserEdgeDrivePausedThreshold' , 'Edge Suspension Notification Threshold (in Days)' , 0 ,'' , 1 , '<App_XMLSchema attribute="0" className="java.lang.Integer" controlHidden="0" controlType="0" displayName="Edge Suspension Notification Threshold (in Days)" documentation="Specifies the amount of days backup Has not been perfomed for the laptop" hidden="0" inputName="UserEdgeDrivePausedThreshold" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" name="UserEdgeDrivePausedThreshold" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>'

                )
			    INSERT INTO NTQueryColumnList VALUES


                (

                @queryId ,  0 , 0 , 0 , 'JobID' , 'JobID' , 1 ,'0,1,4,5,6,7' , 0 , '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1"/>'

                )
			   INSERT INTO NTQueryColumnList VALUES


                (

                @queryId ,  1 , 0 , 1 , 'name' , 'Client Name' , 0 ,'2,3,0,1' , 0 , '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1"/>'

                )
				 INSERT INTO NTQueryColumnList VALUES


                (

                @queryId ,  2 , 0 , 1 , 'Email' , 'Email' , 0 ,'2,3,0,1' , 0 , '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="1"/>'

                )

            END
            INSERT INTO NTNotificationQueryMapping 


            VALUES(

                @queryId, @thisAlertId, @emptyDateTime, @emptyDateTime,

                0, @taskId,

                '',

                '<CVGui_QueryAdditionalInfo><queryParameters><queryParameters isList="0" javaType="" listColDataType="" paramName="UserEdgeDrivePausedThreshold" sqlDataType="" value="&lt;UserEdgeDrivePausedThreshold>7&lt;/UserEdgeDrivePausedThreshold>"/></queryParameters><externalQueryInfo _type_="125"/></CVGui_QueryAdditionalInfo>',

                '',

                'edge Drive Status'

            )
            INSERT INTO GXGlobalParam VALUES ('NTDefaultAlert_EdgeDriveWithPausedJobs_User', 2, @nowTime, 0)


        END

    END

END TRY

BEGIN CATCH

    SET @errorCode = ERROR_NUMBER()

    SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

END CATCH

IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN

    CLOSE newDefaultAlertsCursor

IF ( CURSOR_STATUS('global','newDefaultAlertsCursor') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursor') = -1 )

    DEALLOCATE newDefaultAlertsCursor
INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


    VALUES(@Alertguid , 'NTDefaultAlert_EdgeDriveWithPausedJobs_User', 'Tblscript to add Alert To notify users on paused edge drive', @nowTime, 16, 0 , (16 + 2))

SELECT @errorCode=@@error

IF @errorCode = 0

    COMMIT TRAN

ELSE

BEGIN

    IF LEN(@errorString) > 0

        Print @errorString

    ELSE

        Print 'SQL Error encountered while running the script hence rolling back Transaction'

    ROLLBACK TRAN

END

END

-- One time update to disable the alert by default

DECLARE @disableAlertGuid uniqueidentifier = 'ED3724DD-96D1-4EA4-94DD-0D99783D32E7'

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking  WITH(NOLOCK) WHERE SqlScriptGUID = @disableAlertGuid)

BEGIN

	UPDATE NTNotificationRule SET status=status|1 WHERE notificationName='Edge Drive Has Paused Jobs (User Alert)'	-- NT_STATUS_DISABLED 1
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


    VALUES(@disableAlertGuid , 'Disable_NTDefaultAlert_EdgeDrivePaused', 'Disable EdgeDrive Paused Alert by default', @nowTime, 16, 0 , (16 + 2))

END
