

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDefaultDriveShareAlert.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/NTDefaultDriveShareAlert.script,v $ $Id: NTDefaultDriveShareAlert.script,v 1.1.2.8 2019/12/12 22:39:22 vdevassy Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

declare @guid uniqueidentifier = '5B902C75-D60B-436C-A9D3-1F470742F213'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       

DECLARE @globalParamAlertCreateExec INT = 0

SELECT @globalParamAlertCreateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

declare  @errorCode             integer = 0

declare  @errorString           nvarchar(1024) = ''

DECLARE @htmldefaultTemplate nvarchar(max)

DECLARE @textdefaultTemplate nvarchar(max)	

set @htmldefaultTemplate = '<SUBJECT BEGIN> <OPERATION DATA> <SUBJECT END><!DOCTYPE HTML><html><head><table border="0" cellpadding="0" cellspacing="0" bgcolor="#ffffff"  align="center" style="color: #666;background: #ffffff;width: $SHARE NOTIFICATION WIDTH$;border:0;"><tbody><tr><td width="100%" valign="middle" bgcolor="#ffffff" style="color: #666666;background: #ffffff;vertical-align: middle;font-family: Helvetica, Arial, sans-serif;font-size: 1.5em;line-height: 1.25em;text-align: left;padding: 0;margin:0;"><p style="font-family: Helvetica, Arial, sans-serif;font-size: 1.5em; margin: 0;padding:0;text-transform: uppercase;font-weight: bold;text-align:center">COMMVAULT</p><hr width="100%" noshade="noshade" size="1" color="#666666" style="height: 1px;"></td></tr><tr><td>&nbsp;</td></tr><tr><td width="100%" valign="middle" bgcolor="#ffffff" style="color: #666666;background: #ffffff;vertical-align: middle;font-family: Helvetica, Arial, sans-serif;font-size: 1.85em;line-height: 1.25em;text-align: left;padding: 0;margin:0;"><p style="margin: 0;padding:0;">&lt;OPERATION DATA BODY&gt;</p></td></tr><tr><td>&nbsp;</td></tr><tr><td width="100%" valign="middle" bgcolor="#ffffff" style="color: #666666;background: #ffffff;vertical-align: middle;font-size: 1em;line-height: 1.2em;text-align: left;font-family: Helvetica, Arial, sans-serif;"><p>&lt;SHARE ENTITY INFO&gt; &lt;DIGEST INFO&gt;</p></td></tr><tr><td width="100%" valign="middle" bgcolor="#ffffff" style="color: #666666;background: #ffffff;vertical-align: middle;font-family: Helvetica, Arial, sans-serif;font-size: 1.85em;line-height: 1.25em;text-align: left;padding: 0;margin:0;"><hr width="100%" noshade="noshade" size="1" color="#666666" style="height: 1px;"><p style="font-size: 12px; color: #666666;font-family: Helvetica, Arial, sans-serif;padding: 5px 10px;">Please contact your <a href="mailto:$ADMIN URL$" style="color: #31709C;">administrator</a> if you need help or do not recognize the sender of this email</p></td></tr></tbody></table></body></html>'

set @textdefaultTemplate = ''

IF (@globalParamAlertCreateExec = 0)        -- not done, create the default alerts.

BEGIN
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'DefaultAlertForDriveShare', 'Tblscript to create default subscription based alerts', @curUtcDateTime, 16, 0 , (16 + 2))

	DECLARE @nowTime			as integer	= @curUtcDateTime

	DECLARE @xmlEntities		AS nvarchar(MAX)= '<CVGui_CommCellTreeNode><clients includeAll="0" /><clientGroups includeAll="0" /><libraries includeAll="0" /><mediaAgents includeAll="0" /><storagePolcies includeAll="0" /><trackingPolicies includeAll="0" /><trackingSchedules /><trackingJobs /><criterias includeAll="0" /><workflows includeAll="0" /><associations _type_="12" /><commcells includeAll="0" /></CVGui_CommCellTreeNode>'

	DECLARE	@emptyDateTime		AS datetime	= '1900-01-01 00:00:00.000'

	DECLARE @localeId			AS integer		= 0

	-- We need only 1 alert per message since client owners are being addressed. We cant send emails to owners of multiple clients. 

DECLARE @status				AS integer		= 128 + 16 + 262144		-- 'NNT_STATUS_LAPTOP_ALERT

	DECLARE	@ruleState			AS integer		= 0

	DECLARE	@reportOptions		AS integer		= 0		-- 'NT_REPORT_IMMEDIATE' 

	DECLARE @persistTimeSeconds AS integer		= 0 -- 1 day repeat duration

DECLARE	@categoryId			as integer 		=  2				-- 'NT_CATEGORY_JOB_MANAGEMENT'

	DECLARE @adminID			as integer		= ISNULL((Select top 1 ID from UMUSERS where (flags & 67) = 67 AND Name <> 'ROMS'), 1)

	DECLARE @SelCriteriaId		integer	

	DECLARE @thisCriteria		int

DECLARE @notifType			AS integer	= 1			-- !! WAS !! 'NT_LAPTOP_ALERTNOTIF' + EMAIL (TO FAKE OUT GUI, FOR NOW!)

	--

	---

	----  FOR CURSOR -----

	DECLARE @alertType			INTEGER

DECLARE @notificationName	NVARCHAR(128)			-- 'NT_MAX_NOTIFICATION_NAME_SIZE'

DECLARE @description		NVARCHAR(1024)			-- 'NT_MAX_ALERT_DESCRIPTION_SIZE'

	DECLARE @msgFmtText			NVARCHAR(max) 

	DECLARE @msgFmtHtml 		NVARCHAR(max)

	--

	--		

	DECLARE @alertsToAdd table (

			alertType			int Not Null,

notificationName	nvarchar(128),

description			nvarchar(1024),

			msgFmtText			nvarchar(max),

			msgFmtHtml			nvarchar(max)

	)

	----------------------

	DECLARE	@thisAlertId		integer

	SET @errorCode	= 0

	SET @errorString= ''

	BEGIN TRY

		BEGIN TRAN

			-- CLEANUP FOR TESTING PURPOSES ONLY!

		INSERT @alertsToAdd VALUES(

72,

				'Edge drive/share operations alert',

				'Alert for edge drive/share operations',

				@textdefaultTemplate,

				@htmldefaultTemplate				

				)

		DECLARE newAlertsCursor CURSOR STATIC FOR

			SELECT  alertType, notificationName, description, msgFmtText, msgFmtHtml

			   FROM @alertsToAdd

		OPEN newAlertsCursor

			FETCH NEXT FROM newAlertsCursor INTO @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml

			WHILE @@FETCH_STATUS = 0

			BEGIN

			-- Check whether this alert is already present. If so, dont insert again. 

			if exists(select 1 from NTNotificationRule

				where ( notificationName=@notificationName)

				and revision=1

			)

			BEGIN

				UPDATE NTNotificationRule

SET status = status | 262144 -- Make change to make it hidden.

				WHERE ( notificationName='Edge drive/share operations alert')

				AND revision=1

				FETCH NEXT FROM newAlertsCursor INTO @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml

				continue

			END

			INSERT NTNotificationRule (	categoryId,				alertTypeId,

										notificationName,		revision,

										lastModified,			description,

										notifType,				notifOwner,

										locale,					status,

										ruleState,				ruleState2,

										lastTimeTriggered,		lastTimeTriggered2,

										lastTimeChecked,		hasAttachments,

										hasAttachments2,		xmlEntityList,

										origCCId,				GUID)

			VALUES (					@categoryId,			@alertType				,

										@notificationName,		1,

										@nowTime,				@description,

										@notifType,				@adminID,			

0,					(@status|2048),			-- 0 DefaultLocale US-English

										@ruleState,				@ruleState,

										@emptyDateTime,			@emptyDateTime,

										@emptyDateTime,			0,

										0,						@xmlEntities,

										default,				newid() )	

			SET @thisAlertId = @@Identity 

			INSERT NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)

VALUES(83, 1, @thisAlertId, @reportOptions, 0, @persistTimeSeconds)		-- 'NT_CLIENT_JOB_NOT_RUN
			INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)		


				VALUES (@thisAlertId, 1, null, null, 0)
			INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)		


				VALUES (@thisAlertId, 2, null, null, 0)

			-- ADD DEFAULT (EMAIL) MESSAGE:			

			INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,

								SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,

								baseDir,userName,password, rssID, messageFormatType, formatStringHtml)

				VALUES		(@thisAlertId, 1, 1, @msgFmtText, N'', 

0, 0, 0, 0, 2,

							 '', '', '', '', 1, @msgFmtHtml)

	-- ADD DEFAULT USER (SHOULDN'T HAVE TO DO THIS, BUT REQ'D TO SUPPORT CURRENT ALERT GUI)

	--		INSERT NTnotificationUsers  (NTnotificationID, userId,    escalationLevel)

	--			VALUES (@thisAlertId, @adminID, 1)

			FETCH NEXT FROM newAlertsCursor INTO @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml

		END

	END TRY

	 BEGIN CATCH

		 set @errorCode = ERROR_NUMBER()

		 set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()

	 END CATCH

 		IF ( CURSOR_STATUS('global', 'newAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN

			CLOSE newAlertsCursor

		IF ( CURSOR_STATUS('global','newAlertsCursor') = -1     OR CURSOR_STATUS('local','newAlertsCursor') = -1 )

			DEALLOCATE newAlertsCursor	

	IF @errorCode = 0

		COMMIT TRAN

	ELSE 

		ROLLBACK TRAN

END

Else

begin

	Update NTMessageformat

	set formatStringHtml=@htmldefaultTemplate

	from NTMessageformat inner join NTNotificationrule on 

	NTNotificationrule.id = NTMessageformat.NTNotificationId

and NTNotificationrule.alertTypeId=72

	and notificationName='Edge drive/share operations alert'	

	-- For existing setups mark the alert hidden so that it doesnt show up in commcell console.

	UPDATE NTNotificationRule

SET status = status | 262144 -- Make change to make it hidden.

	WHERE ( notificationName='Edge drive/share operations alert')

	AND revision=1

end

SET NOCOUNT OFF

GO

