

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDefaultDiskSpaceLowAlertFix.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]='@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/NTDefaultDiskSpaceLowAlertFix.script,v $ $Id: NTDefaultDiskSpaceLowAlertFix.script,v 1.1.2.3 2018/06/16 12:40:45 vdevassy Exp $';

-- PUT ANY #DEFINES HERE

-- ----------------------

declare @guid uniqueidentifier = '4C56C1DD-F400-4BAC-8EBB-D1FFC7E196D7'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       

DECLARE  @errorCode			INT  = 0

DECLARE  @errorString		NVARCHAR(1024) = ''

begin try

begin tran

DECLARE @paramAlertModifyExec INT = 0

SELECT @paramAlertModifyExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

if (@paramAlertModifyExec=0)

begin
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'DiskSpaceLowAlertFix', 'Tblscript to update default disk space low alerts', @curUtcDateTime, 16, 0 , (16 + 2))

	declare @diskSpaceLowAlertId int = 0

	select @diskSpaceLowAlertId = id from NTNotificationRule

	where notificationName='Low disk space on client'

	and alertTypeId=10 --NT_ALERTTYPE_CLIENTS

	and revision=1

	and (status&2)=0

	and (status & 2048)>0

	if @diskSpaceLowAlertId>0

	begin		
		Insert into NTSelCriteria(availCriteriaId,esclationlevel,ruleId, reportingOptions, delayTimeSeconds,persistTimeSeconds)


select 77,s1.esclationlevel,s1.ruleid,s1.reportingOptions,s1.delayTimeSeconds,s1.persistTimeSeconds from NTSelCriteria s1 ---- disk space low for job results directory

left join NTSelCriteria s2 on s1.ruleId=s2.ruleId and s2.availCriteriaId=77 and S1.ruleId=@diskSpaceLowAlertId

			where S1.ruleId=@diskSpaceLowAlertId

			and S2.ruleId is null

		union

select 79,s1.esclationlevel,s1.ruleid,s1.reportingOptions,s1.delayTimeSeconds,s1.persistTimeSeconds from NTSelCriteria s1 ---- disk space low for galaxy directory

left join NTSelCriteria s2 on s1.ruleId=s2.ruleId and s2.availCriteriaId=79 and S1.ruleId=@diskSpaceLowAlertId

			where S1.ruleId=@diskSpaceLowAlertId

			and S2.ruleId is null

	end

	-- Now the same for disk space low on mediaagent alert also

	set @diskSpaceLowAlertId=0

	select @diskSpaceLowAlertId = id from NTNotificationRule

	where notificationName='Disk space low on media agent'

	and alertTypeId=13 --NT_ALERTTYPE_MEDIA_AGENTS

	and revision=1

	and (status&2)=0

	and (status & 2048)>0

	if @diskSpaceLowAlertId>0

	begin		
		Insert into NTSelCriteria(availCriteriaId,esclationlevel,ruleId, reportingOptions, delayTimeSeconds,persistTimeSeconds)


select 78,s1.esclationlevel,s1.ruleid,s1.reportingOptions,s1.delayTimeSeconds,s1.persistTimeSeconds from NTSelCriteria s1 ---- disk space low for index cache directory

left join NTSelCriteria s2 on s1.ruleId=s2.ruleId and s2.availCriteriaId=78 and S1.ruleId=@diskSpaceLowAlertId

			where S1.ruleId=@diskSpaceLowAlertId

			and S2.ruleId is null

		union

select 79,s1.esclationlevel,s1.ruleid,s1.reportingOptions,s1.delayTimeSeconds,s1.persistTimeSeconds from NTSelCriteria s1 ---- disk space low for galaxy directory

left join NTSelCriteria s2 on s1.ruleId=s2.ruleId and s2.availCriteriaId=79 and S1.ruleId=@diskSpaceLowAlertId

			where S1.ruleId=@diskSpaceLowAlertId

			and S2.ruleId is null

	end

end

end try

BEGIN CATCH

	SET @errorCode = ERROR_NUMBER()

	SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

END CATCH

IF @errorCode = 0

	COMMIT TRAN

ELSE

BEGIN

	IF LEN(@errorString) > 0

		Print @errorString

	ELSE

		Print 'SQL Error encountered while running the script hence rolling back Transaction'

	ROLLBACK TRAN

END

