

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDefaultDeDupPruningPerformanceAlert.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- This alert was replaced by an admin alert, it's not required anymore, so this script will disable it.

DECLARE  @errorCode         INT = 0

DECLARE  @errorString       NVARCHAR(1024) = ''

DECLARE @guid UNIQUEIDENTIFIER = 'C7FB4A17-30B0-47E9-BFD0-FC143E072B40'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())

DECLARE @thisAlertId                INT

DECLARE @scriptExecuted INT = 0

SELECT @scriptExecuted = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@scriptExecuted = 1)      

BEGIN

    RETURN -- Dont execute below.

END

BEGIN TRY

    BEGIN TRAN
    INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'NTDefaultDeDupPruningPerformanceAlert', 'Default DeDup Pruning Performance alert', @curUtcDateTime, 16, 0 , (16 + 2))

        -- Get NTNotificationRule id for 'DeDup Pruning Performance'

    SET @thisAlertId = (SELECT id FROM NTNotificationRule WITH (NOLOCK) WHERE notificationName='DeDup Pruning Performance')

    IF @thisAlertId IS NOT NULL

    BEGIN

        -- Disable it in NTNotificationRule

UPDATE NTNotificationRule SET status = status | 1

		WHERE id = @thisAlertId

    END

END TRY

BEGIN CATCH

    SET @errorCode = ERROR_NUMBER()

    SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

END CATCH

IF @errorCode = 0

    COMMIT TRAN

ELSE

BEGIN

    IF LEN(@errorString) > 0

        Print @errorString

    ELSE

        Print 'SQL Error encountered while running the script hence rolling back Transaction'

    ROLLBACK TRAN

END

