

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDefaultDataVerificationFailureDetected.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

DECLARE  @errorCode INT         

DECLARE  @errorString VARCHAR(1024)   

DECLARE @Alertguid uniqueidentifier

SELECT  @Alertguid='7A5341EE-DCA9-4E4B-BFA8-5A3D42C91937'

DECLARE	@emptyDateTime		DATETIME = '1900-01-01 00:00:00.000'

IF NOT EXISTS ( SELECT 1 FROM GXUniqueSQLScriptExecTracking  WITH(NOLOCK) WHERE SqlScriptGUID = @Alertguid )

BEGIN 

	DECLARE @nowTime			INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

	DECLARE @xmlEntities		NVARCHAR(MAX)= '<CVGui_CommCellTreeNode>

	  <clients includeAll="0" />

	  <clientGroups includeAll="0" />

	  <libraries includeAll="0" />

	  <mediaAgents includeAll="0" />

	  <storagePolcies includeAll="0" />

	  <trackingPolicies includeAll="0" />

	  <trackingSchedules />

	  <trackingJobs />

	  <criterias includeAll="0" />

	  <workflows includeAll="0" />

	  <commcells includeAll="0" />

	</CVGui_CommCellTreeNode>'

	DECLARE @adminID			INT = ISNULL((SELECT TOP 1 id from UMUsers where (flags & 67) = 67), 1)

	DECLARE @localeId			INT = 0

	DECLARE	@ruleState			INT = 2					-- Alert Severity

DECLARE	@reportOptions		INT = 1

	DECLARE @persistTimeSeconds INT = 0

DECLARE @notifType			INT = 131072 + 8192 + 1

	DECLARE @queryId			INT

	DECLARE @alertId			INT = 1

DECLARE @alertType			INT = 65												-- 'NT_ALERTTYPE_CUSTOM_QUERY'

	DECLARE @notificationName	NVARCHAR(128)	= 'Data Verification Failure Detected'							-- 'NT_MAX_NOTIFICATION_NAME_SIZE'

	DECLARE @description		NVARCHAR(1024)	= 'Default Data Verification Failure Detected Alert'			-- 'NT_MAX_ALERT_DESCRIPTION_SIZE'

	DECLARE @msgFmtText			NVARCHAR(max)

	DECLARE @msgFmtHtml 		NVARCHAR(max)

	DECLARE	@thisAlertId		INT

	SET @errorCode	= 0

	SET @errorString = ''

	BEGIN TRY

		BEGIN TRAN

		SET @msgFmtHtml = '<SUBJECT BEGIN> Alert: <ALERT NAME> <IS ESCALATED?> <SUBJECT END><div>  &lt;INDEX 0&gt;  </div>'

		SET @msgFmtText	 = '<SUBJECT BEGIN> Alert: <ALERT NAME> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_ MsgNewLine_ MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Alert Rule Name : <QUERY NAME> MsgNewLine_MsgTab_ Column1 : <INDEX 0> MsgNewLine_MsgTab_ Condition Cleared: : <CONDITION CLEARED Y/N>'

		-- Check whether this alert is already present. If so, dont insert again.

		IF NOT EXISTS (SELECT 1 FROM NTNotificationRule

			WHERE notificationName=@notificationName AND revision=1

			)

		BEGIN

DECLARE @status INT = 2048 + 16 + 256
			INSERT INTO NTNotificationRule (categoryId,				alertTypeId,


											notificationName,		revision,

											lastModified,			description,

											notifType,				notifOwner,

											locale,					status,

											ruleState,				ruleState2,

											lastTimeTriggered,		lastTimeTriggered2,

											lastTimeChecked,		hasAttachments,

											hasAttachments2,		xmlEntityList,

											origCCId,				GUID            )

			SELECT							9,				@alertType,

											@notificationName,		1,

											@nowTime,				@description,

											@notifType,				@adminID,

											@localeId,				@status,								    

											@ruleState,				@ruleState,

											@emptyDateTime,			@emptyDateTime,

											@emptyDateTime,			0,

											0,						@xmlEntities ,

											2,						newid()

			SET @thisAlertId = @@Identity
			INSERT INTO NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)


SELECT 75, 1, @thisAlertId, @reportOptions , 0, @persistTimeSeconds
			INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)


				VALUES (@thisAlertId, 1, null, null, 0)
			INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)


				VALUES (@thisAlertId, 2, null, null, 0)

			-- :ADD DEFAULT MESSAGES:--
			INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


								SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

								messageFormatType, formatStringHtml)

VALUES		(@thisAlertId, 1, 1, @msgFmtText, N'',

               					0, 0, 0, 0, 0,

								1, @msgFmtHtml)
			INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


								SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

								messageFormatType, formatStringHtml)

VALUES		(@thisAlertId, 8192, 1, @msgFmtText, N'',

               					0, 0, 0, 0, 0,

								1, @msgFmtHtml)
			INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


								SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

								messageFormatType, formatStringHtml)

VALUES		(@thisAlertId, 131072, 1, @msgFmtText, N'',

               					0, 0, 0, 0, 0,

								0, N'')
			INSERT INTO NTnotificationUsers(NtnotificationId,userId,escalationLevel)


			SELECT @thisAlertId,@adminID,1

			IF NOT EXISTS ( SELECT 1 FROM NTQueryList WHERE queryName = 'Data Verification Failure Detected Custom Rule')

			BEGIN

				Print  'Creating alert Rule " Data Verification Failure Detected Custom Rule " since its not present  in the machine '

				DECLARE @GUID VARCHAR(40)

				SET @GUID = NEWID()
				INSERT INTO NTQueryList VALUES


				(

				0 ,    -- queryMessageId

				86400, --default frequency (24hr*60min*60sec)

				0,     -- status 

				1,     -- Query Creator

				1,     -- Visibility

				0,     -- Task Id 

				-----  Query ---------- 

				'DECLARE @htmlContent NVARCHAR(MAX)

				EXEC NTD_DataVerificationFailureDetectionHTMLContent @htmlContent OUTPUT

				IF @htmlContent <> ''''

				BEGIN

					SELECT @htmlContent

				END'

			------------------------- Query ends ------------------------------------------------

				,

				---- xmlInfo ----

				'<?xml version="1.0" encoding="UTF-16" standalone="no" ?><App_AdditionalQueryDetails alertCriteria="0" alertType="0" defaultHtmlTemplate="" defaultTextTemplate="" isHealthParam="0" querySeverity="2"><externalQueryEntity _type_="125"/><scriptDescription description="A custom rule for Data Verification Failure Detection." guid="abc3ce57-7085-4f45-9d90-162ceeb09f36" reportName="Data Verification Failure Detected Custom Rule" revision="$Revision: 1.1.2.5 $ M&lt;1572506187447>"/></App_AdditionalQueryDetails>',

				'Data Verification Failure Detected Custom Rule', -- queryName

				'A custom rule for Data Verification Failure Detection.', --queryDescription

				'',                     -- queryCriteriaName

				@GUID,                  -- GUID

					---- commcellAssociation ----

				'<App_Associations><entity _type_="124" commCellId="2" /></App_Associations>',

				0						-- isOverwriteAssociationAtAlertAllowed

				)	

			END

			SELECT @queryId = queryId FROM NTQueryList  

			WHERE queryName  = 'Data Verification Failure Detected Custom Rule'

			IF NOT EXISTS (SELECT 1 FROM NTQueryColumnList WHERE QueryId = @queryId)

			BEGIN
            	INSERT INTO NTQueryColumnList VALUES


				(

				@queryId ,  0 , 0 , 1 , 'Column1' , 'Column1' , 0 ,'2,3,0,1' , 0 , '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'

				)

			END
			INSERT INTO NTNotificationQueryMapping 


			VALUES(

				@queryId, @thisAlertId, @emptyDateTime, @emptyDateTime,

				0, 0,

				'',

				'<CVGui_QueryAdditionalInfo isHTMLContent ="true" ><queryParameters/><externalQueryInfo _type_="125"/></CVGui_QueryAdditionalInfo>',

				'',

				'Data Verification Failure Detected Custom Rule'

			)

		END
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


			VALUES(@Alertguid , 'NTDefaultAlert_DataVerificationFailureDetected', 'Tblscript to add Alert to notify admin on Data Verification Failure Detection', @nowTime, 16, 0 , (16 + 2))

		COMMIT TRAN

	END TRY

	BEGIN CATCH

		SET @errorCode = ERROR_NUMBER()

		SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

		IF LEN(@errorString) > 0

			Print @errorString

		ELSE

			Print 'SQL Error encountered while running the script hence rolling back Transaction'

		ROLLBACK TRAN

		THROW;  

	END CATCH

END

ELSE

BEGIN

	-- IsScheduled column value was incorrectly set on NTNotificationQueryMapping for alert 'Data Verification Failure Detected Custom Rule' resulting never getting triggered

	BEGIN TRY

		BEGIN TRAN

		UPDATE	NTNotificationQueryMapping

		SET		isScheduled = 0, nextRunTime = @emptyDateTime

		WHERE	QueryId = (	SELECT MAX(QueryId)

							FROM NTQueryList  

							WHERE queryName  = 'Data Verification Failure Detected Custom Rule')

				AND isScheduled = 1

				AND taskId = 0

		COMMIT TRAN

	END TRY

	BEGIN CATCH

		SET @errorCode = ERROR_NUMBER()

		SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

		IF LEN(@errorString) > 0

			Print @errorString

		ELSE

			Print 'SQL Error encountered while running the script hence rolling back Transaction'

		ROLLBACK TRAN

		THROW;  

	END CATCH

END

