

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDefaultClientGroupLicenseLimitAlert.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

DECLARE  @errorCode			INT         

DECLARE  @errorString		VARCHAR(1024)   

DECLARE @nowTime			INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

DECLARE @taskId				INT

DECLARE @xmlEntities		NVARCHAR(MAX)= '<CVGui_CommCellTreeNode>

	<associations _type_="124" commCellId="2" />

	<clientGroups includeAll="0" />

	<clients includeAll="0" />

	<commcells includeAll="0" />

	<criterias includeAll="0" />

	<libraries includeAll="0" />

	<mediaAgents includeAll="0" />

	<storagePolcies includeAll="0" />

	<trackingJobs />

	<trackingPolicies includeAll="0" />

	<trackingSchedules />

	<workflows includeAll="0" />

</CVGui_CommCellTreeNode>'

DECLARE @adminID			INT = ISNULL((SELECT TOP 1 id from UMUsers where (flags & 67) = 67), 1)

DECLARE	@emptyDateTime		DATETIME = '1900-01-01 00:00:00.000'

DECLARE @localeId			INT = 0

DECLARE	@ruleState			INT = 1					-- Alert Severity

DECLARE	@reportOptions		INT = 3					-- 'NT_REPORT_IMMEDIATE' + 'NT_REPORT_REPEATED'

DECLARE @persistTimeSeconds INT = 900

DECLARE @createdAlertsId	INT = 1

DECLARE @notifType			INT = 131073			-- 'NT_EMAIL_ALERTNOTIF' + 'NT_ALERTNOTIF_FOR_CI'

DECLARE @queryId			INT

----  FOR CURSOR -----

DECLARE @alertId			INT

DECLARE @alertType			INT

DECLARE @notificationName	NVARCHAR(128)			-- 'NT_MAX_NOTIFICATION_NAME_SIZE'

DECLARE @description		NVARCHAR(1024)			-- 'NT_MAX_ALERT_DESCRIPTION_SIZE'

DECLARE @msgFmtText			NVARCHAR(max)

DECLARE @msgFmtHtml 		NVARCHAR(max)

DECLARE @cursorXmlEntities  NVARCHAR(MAX)

--

--

DECLARE @alertsToAdd table (

		alertId				INT PRIMARY KEY,

		alertType			INT NOT NULL,

		notificationName	NVARCHAR(128),

		description			NVARCHAR(1024),

		msgFmtText			NVARCHAR(MAX),

		msgFmtHtml			NVARCHAR(MAX),

		xmlEntities			NVARCHAR(MAX)

)

DECLARE @criteriasToAdd table (

		alertId				INT,

		criteriaId			INT,

		criteriaParamType	INT,

		criteriaParamValue	INT,

		criteriaParamUnit	INT

		PRIMARY KEY(alertId,criteriaId)

)

----------------------

DECLARE	@thisAlertId		INT

SET @errorCode	= 0

SET @errorString = ''

BEGIN TRY

	BEGIN TRAN

	DECLARE @htmldefaultTemplateForLicenseUsageAlert NVARCHAR(max)

	DECLARE @textdefaultTemplateForLicenseUsageAlert NVARCHAR(max)

IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name='UseNewAlertTemplate' AND value=1)

		SET @htmldefaultTemplateForLicenseUsageAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Alert Rule Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;QUERY NAME&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif">&lt;TABLE DATA&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Condition Cleared</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CONDITION CLEARED Y/N&gt;</font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'

	ELSE

		SET @htmldefaultTemplateForLicenseUsageAlert = '

<SUBJECT BEGIN> Alert: <ALERT NAME> <IS ESCALATED?> <SUBJECT END><table cellpadding="0" cellspacing="0" border="1" align="center" width="100%" style="border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-style: solid; border-top-color: #dedede; border-right-color: #dedede; border-bottom-color: #dedede; border-left-style: solid; border-right-style: solid; border-top-width: 0px; border-right-width: 0px">

 <tr>

 <td>

 <center>

 <table cellpadding="0" border="0" id="contentTbl" width="100%" align="center" cellspacing="0">

 <tr style="background-color: #666666">

 <td valign="middle" align="left">

 <div style="margin-left: 10px; margin-bottom: 4px; margin-top: 4px">

 <font size="6" face="Helvetica,sans-serif" color="#EEEEEE">&lt;ALERT NAME&gt; </font>

 </div>

 </td>

 </tr>

 <tr>

 <td colspan="1" valign="middle" align="left" bgcolor="#DCDEDE">

 <ul style="margin-top: 4px; margin-bottom: 4px">

 <font size="4" face="Helvetica,sans-serif"><strong>CommCell: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong>

 </ul>

 <ul style="margin-top: 4px; margin-bottom: 4px">

 <font size="4" face="Helvetica,sans-serif"><strong>Type: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong>

 </ul>

 </td>

 </tr>

 <tr>

 <td width="100%" colspan="1" align="left">

 <ul>

 <li style="margin-top: 4px; margin-bottom: 4px">

 <font size="3" face="Helvetica,sans-serif" color="#000000">User: &lt;USER NAME&gt; </font>

 </li>

 <li style="margin-top: 4px; margin-bottom: 4px">

 <font size="3" face="Helvetica,sans-serif" color="#000000">Alert Rule Name : &lt;QUERY NAME&gt; </font>

 </li>

 </ul>

 <div>

 <div>

 <b><font color="#ff0000">Following Client Groups are exceeding the assigned license usage limit:</font></b>

 </div>

 <div> </div>

 </div>

 <div>

 &lt;TABLE DATA&gt;

 </div>

 <ul>

 <li style="margin-top: 4px; margin-bottom: 4px"> </li>

 </ul>

 </td>

 </tr>

 <tr style="background-color: #666666">

 <td colspan="1" align="left">

 

 </td>

 </tr>

 </table>

 </center>

 </td>

 </tr>

 </table>'

	SET @textdefaultTemplateForLicenseUsageAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_ MsgNewLine_ MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Alert Rule Name : <QUERY NAME> MsgNewLine_MsgTab_ Client Group : <INDEX 0> MsgNewLine_MsgTab_ Quota Limit (Local) : <INDEX 1> MsgNewLine_MsgTab_ Quota Used (Local) : <INDEX 2> MsgNewLine_MsgTab_ Quota Limit (Global) : <INDEX 3> MsgNewLine_MsgTab_ Quota Used (Global) : <INDEX 4> MsgNewLine_MsgTab_ Condition Cleared: : <CONDITION CLEARED Y/N>'
	INSERT INTO @alertsToAdd VALUES(


			@createdAlertsId,

			65,		-- 'NT_ALERTTYPE_CUSTOM_QUERY'

			'Client Groups Exceeding Assigned License Limits',

			'Default Alert for Client Groups Exceeding Assigned License Limits',

			@textdefaultTemplateForLicenseUsageAlert,

			@htmldefaultTemplateForLicenseUsageAlert,

			@xmlEntities

	)
	INSERT INTO @criteriasToAdd


	SELECT @createdAlertsId, 75 /* NT_GENERIC_QUERY (Custom Query)*/, NULL, NULL, NULL

	IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN

		CLOSE newDefaultAlertsCursor

	IF ( CURSOR_STATUS('global','newDefaultAlertsCursor') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursor') = -1 )

		DEALLOCATE newDefaultAlertsCursor

	DECLARE newDefaultAlertsCursor CURSOR FOR

		SELECT  alertId, alertType, notificationName, description, msgFmtText, msgFmtHtml, xmlEntities

			FROM @alertsToAdd

	OPEN newDefaultAlertsCursor

	FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId, @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml, @cursorXmlEntities

	WHILE @@FETCH_STATUS = 0

	BEGIN

		-- Check whether this alert is already present. If so, dont insert again.

		IF EXISTS (SELECT 1 FROM NTNotificationRule

			WHERE notificationName=@notificationName AND revision=1

		)

		BEGIN

			FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId, @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml, @cursorXmlEntities

			CONTINUE

		END
		INSERT INTO NTNotificationRule (categoryId,				alertTypeId,


										notificationName,		revision,

										lastModified,			description,

										notifType,				notifOwner,

										locale,					status,

										ruleState,				ruleState2,

										lastTimeTriggered,		lastTimeTriggered2,

										lastTimeChecked,		hasAttachments,

										hasAttachments2,		xmlEntityList,

										origCCId,				GUID            )

		SELECT							categoryID,						@alertType,

										@notificationName,		1,

										@nowTime,				@description,

										@notifType,				@adminID,

										@localeId,				(2049),								    

										-- 2048 + 1 for specifying the alert is system generated and disabled.

										@ruleState,				@ruleState,

										@emptyDateTime,			@emptyDateTime,

										@emptyDateTime,			0,

										0,						@cursorXmlEntities ,

										2,						newid()

		FROM NTAlertType WHERE id = @alertType

		SET @thisAlertId = @@Identity
		INSERT INTO NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)


		SELECT criteriaId, 1, @thisAlertId, @reportOptions , 0, @persistTimeSeconds

		FROM @criteriasToAdd

		WHERE alertId = @alertId

		IF EXISTS (SELECT 1 FROM @criteriasToAdd WHERE alertId = @alertId AND criteriaParamType IS NOT NULL AND

			criteriaParamValue IS NOT NULL AND criteriaParamUnit IS NOT NULL)

		BEGIN
			INSERT INTO NTSelCriteriaParams (selCriteriaid, paramIndex, type, value, unit, occurrences)


			SELECT id, 0, criteriaParamType, criteriaParamValue, criteriaParamUnit, 0

			FROM NTSelcriteria , @criteriasToAdd newCriterias

			WHERE NTSelcriteria.ruleid = @thisAlertId

				AND newCriterias.alertId = @alertId

				AND newCriterias.criteriaParamType IS NOT NULL 

				AND newCriterias.criteriaParamValue IS NOT NULL AND newCriterias.criteriaParamUnit IS NOT NULL

		END
		INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)


			VALUES (@thisAlertId, 1, null, null, 0)
		INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)


			VALUES (@thisAlertId, 2, null, null, 0)

		-- :ADD DEFAULT MESSAGES:--
		INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


							SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

							messageFormatType, formatStringHtml)

			VALUES		(@thisAlertId, 1, 1, @msgFmtText, N'',

               				0, 0, 0, 0, 0,

							1, @msgFmtHtml)
		INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


							SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

							messageFormatType, formatStringHtml)

			VALUES		(@thisAlertId, 8192, 1, @msgFmtText, N'',

               				0, 0, 0, 0, 0,

							1, @msgFmtHtml)
		INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


							SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

							messageFormatType, formatStringHtml)

			VALUES		(@thisAlertId, 131072, 1, @msgFmtText, N'',

               				0, 0, 0, 0, 0,

							0, N'')
		INSERT INTO NTnotificationUsers(NtnotificationId,userId,escalationLevel)


		SELECT @thisAlertId,@adminID,1

		FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId, @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml, @cursorXmlEntities

		IF NOT EXISTS ( SELECT 1 FROM NTQueryList WHERE queryName = 'Client Group License Usage Check')

		BEGIN

			Print  'Creating alert Rule " Client Group License Usage Check " since its not present  in the machine '

			DECLARE @GUID VARCHAR(40)

			SET @GUID = NEWID()
			INSERT INTO NTQueryList VALUES


			(

			0 ,    -- queryMessageId

			900, --default frequency

			0,     -- status 

			1,     -- Query Creator

			1,     -- Visibility

			0,     -- Task Id 

			-----  Query ---------- 

			'SELECT  CG.name AS ''ClientGroup'',

					CAST (CP.longlongVal AS VARCHAR(32)) + '' GB'' AS ''LicenseLimitLocal'', 

					CAST (U.quotaUsedGB AS VARCHAR(32)) + '' GB'' AS ''LicenseUsedLocal'', 

					CAST(U.globalLimitGB AS VARCHAR(32)) + '' GB'' AS ''LicenseLimitGlobal'', 

					CAST(U.globalUsedGB AS VARCHAR(32)) + '' GB'' AS ''LicenseUsedGlobal''

			FROM    APP_ComponentProp CP

					INNER JOIN RptClientGroupQuotaUsage U

						ON CP.componentId = U.clientGroupId

					INNER JOIN APP_ClientGroup CG

						ON CP.componentId = CG.id

			WHERE   CP.componentType = 8 

				AND CP.propertyTypeId = 3400 

				AND U.quotaType = 100002

				AND ((CP.longlongVal > 0 AND CP.longlongVal < U.quotaUsedGB) OR (CP.longlongVal > 0 AND CP.longlongVal < U.globalUsedGB))

				AND (U.globalLimitGB <= 0 OR ((U.globalLimitGB > 0 AND U.globalLimitGB < U.quotaUsedGB) OR (U.globalLimitGB > 0 AND U.globalLimitGB < U.globalUsedGB)))

				AND EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = ''Enable Quota Limits at Client Group'' AND modified = 0 AND value = ''1'')'

------------------------- Query ends ------------------------------------------------

			,

			---- xmlInfo ----

			'<?xml version="1.0" encoding="UTF-16" standalone="no" ?><App_AdditionalQueryDetails alertCriteria="0" alertType="0" defaultHtmlTemplate="" defaultTextTemplate="" isHealthParam="0" querySeverity="1"><externalQueryEntity _type_="125"/><scriptDescription description="" guid="36FA0F07-6196-46DD-B564-67D674610B25" reportName="Client Group License Usage Check" revision=""/></App_AdditionalQueryDetails>',

			'Client Group License Usage Check',	-- queryName

			'Client Group License Usage Check',		--queryDescription

			'',						-- queryCriteriaName

			@GUID,					-- GUID

			---- commcellAssociation ----

			'<App_Associations>

				<entity _type_="124" clientSidePackage="1" commCellId="2" consumeLicense="1" srmReportSet="0" srmReportType="0" type="0" />

			</App_Associations>',

			1						-- isOverwriteAssociationAtAlertAllowed

			)

		END

		SELECT @queryId = queryId , @taskId = taskId FROM NTQueryList  

		WHERE queryName  = 'Client Group License Usage Check'

		IF NOT EXISTS (SELECT 1 FROM NTQueryColumnList WHERE QueryId = @queryId)

		BEGIN
			INSERT INTO NTQueryColumnList VALUES


			(

			@queryId ,  0 , 1 , 1 , 'ClientGroup' , 'Client Group' , 0 ,'2,3,0,1' , 0 , '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1"/>'

			)
			INSERT INTO NTQueryColumnList VALUES


			(

			@queryId ,  1 , 0 , 1 , 'LicenseLimitLocal' , 'License Limit (Local)' , 0 ,'2,3,0,1' , 0 , '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1"/>'

			)
			INSERT INTO NTQueryColumnList VALUES


			(

			@queryId ,  2 , 0 , 1 , 'LicenseUsedLocal' , 'License Used (Local)' , 0 ,'2,3,0,1' , 0 , '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1"/>'

			)
			INSERT INTO NTQueryColumnList VALUES


			(

			@queryId ,  3 , 0 , 1 , 'LicenseLimitGlobal' , 'License Limit (Global)' , 0 ,'2,3,0,1' , 0 , '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1"/>'

			)
			INSERT INTO NTQueryColumnList VALUES


			(

			@queryId ,  4 , 0 , 1 , 'LicenseUsedGlobal' , 'License Used (Global)' , 0 ,'2,3,0,1' , 0 , '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1"/>'

			)

		END
		INSERT INTO NTNotificationQueryMapping 


		VALUES(

			@queryId, @thisAlertId, @emptyDateTime, @emptyDateTime,

			0, @taskId,

			'',

			'<CVGui_QueryAdditionalInfo><externalQueryInfo _type_="125"/><queryParameters/></CVGui_QueryAdditionalInfo>',

			'',

			'Client Group License Usage Check'

		)

	END	

	IF EXISTS (SELECT 1 FROM NTQueryList WHERE queryName = 'Client Group License Usage Check')

	BEGIN

		UPDATE NTQueryList SET queryString = '

				SELECT  CG.name AS ''ClientGroup'',

						CAST (CP.longlongVal AS VARCHAR(32)) + '' GB'' AS ''LicenseLimitLocal'', 

						CAST (U.quotaUsedGB AS VARCHAR(32)) + '' GB'' AS ''LicenseUsedLocal'', 

						CAST(U.globalLimitGB AS VARCHAR(32)) + '' GB'' AS ''LicenseLimitGlobal'', 

						CAST(U.globalUsedGB AS VARCHAR(32)) + '' GB'' AS ''LicenseUsedGlobal''

				FROM    APP_ComponentProp CP

						INNER JOIN RptClientGroupQuotaUsage U

							ON CP.componentId = U.clientGroupId

						INNER JOIN APP_ClientGroup CG

							ON CP.componentId = CG.id

				WHERE   CP.componentType = 8 

					AND CP.propertyTypeId = 3400 

					AND U.quotaType = 100002

					AND ((CP.longlongVal > 0 AND CP.longlongVal < U.quotaUsedGB) OR (CP.longlongVal > 0 AND CP.longlongVal < U.globalUsedGB))

					AND (U.globalLimitGB <= 0 OR ((U.globalLimitGB > 0 AND U.globalLimitGB < U.quotaUsedGB) OR (U.globalLimitGB > 0 AND U.globalLimitGB < U.globalUsedGB)))

					AND EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = ''Enable Quota Limits at Client Group'' AND modified = 0 AND value = ''1'')'

		WHERE queryName = 'Client Group License Usage Check'

	END

END TRY

BEGIN CATCH

	SET @errorCode = ERROR_NUMBER()

	SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

END CATCH

IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN

	CLOSE newDefaultAlertsCursor

IF ( CURSOR_STATUS('global','newDefaultAlertsCursor') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursor') = -1 )

	DEALLOCATE newDefaultAlertsCursor

IF @errorCode = 0

	COMMIT TRAN

ELSE

BEGIN

	IF LEN(@errorString) > 0

		Print @errorString

	ELSE

		Print 'SQL Error encountered while running the script hence rolling back Transaction'

	ROLLBACK TRAN

END

