

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDefaultApplianceHwAlert.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/NTDefaultApplianceHwAlert.script,v $ $Id: NTDefaultApplianceHwAlert.script,v 1.1.2.7 2020/07/08 05:58:08 shubhamagrawal Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

-- 5CBC6A65-34FD-4F16-A6C6-DABCBDC02DDB --this was used in this script, so it can be present in DB

-- 00FFC930-07DE-482D-9687-F412D8AD8DCD --this was used in this script, so it can be present in DB

DECLARE @Alertguid uniqueidentifier

SELECT  @Alertguid='9F026B4C-7063-4D96-9E03-80E9C5EDA8C1'

DECLARE @ChangingDefaultFrequencyGUID uniqueidentifier = 'E3F0570C-A0D8-441A-8E58-EA0783734135'

DECLARE  @errorCode INT         

DECLARE  @errorString VARCHAR(1024)   

DECLARE @nowTime INT 			= DATEDIFF(second, '01/01/1970', GetUTCdate())

DECLARE @defaultFreq INT 		= 3600 --1 hour

DECLARE	@reportOptions	INT 	= 1 | 4

DECLARE @msgFmtText	NVARCHAR(max) = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_ MsgNewLine_ MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Alert Rule Name : <QUERY NAME> MsgNewLine_MsgTab_ Storage Pool : <INDEX 0> MsgNewLine_MsgTab_ Host Name : <INDEX 1> MsgNewLine_MsgTab_ Hardware Entity name : <INDEX 2> MsgNewLine_MsgTab_ Hardware Entity Status : <INDEX 3> MsgNewLine_MsgTab_ Commcell Id : <INDEX 4> MsgNewLine_MsgTab_ Node Serial Number : <INDEX 5> MsgNewLine_MsgTab_ Emails to contact : <INDEX 6> MsgNewLine_MsgTab_ Condition Cleared: : <CONDITION CLEARED Y/N>'

Declare @alertQuery NVARCHAR(max) = '

	create table #tbl_HWDetailForAlert(

		NodeId		int,

		NodeName		nvarchar(510),

		EntityType		int,

		EntityId		int,

		EntityName		varchar(256),

		EntityInfo		varchar(256),

		EntityStatus	        int,

		EntityStatusStr	        varchar(16),

		StoragePoolId			int,

		StoragePoolName			NVARCHAR(256)

	)
	insert into #tbl_HWDetailForAlert


	exec MMGetScaleOutHwInfoForHwEntity 1,31,1

	Declare @commcellNumber INTEGER

	SELECT @commcellNumber = number FROM APP_CommCell (READUNCOMMITTED) WHERE id =2

	SET QUOTED_IDENTIFIER  on 

	select T.StoragePoolName, T.NodeName, T.EntityName, T.EntityStatusStr, @commcellNumber AS CommCellNumber,

		S.HardwareInformation.value(''(/MediaManager_WSPlatformHwInfo/systemInfo/@serialNo)[1]'', ''varchar(125)'') as NodeSerialNumber,

		ISNULL(EP.stringVal, '''') as CustomerEmail,

		T.EntityType

	FROM #tbl_HWDetailForAlert T

		INNER JOIN MMscaleoutmainfo S (READUNCOMMITTED) ON S.clientId = T.NodeId 

LEFT JOIN MMEntityProp EP (READUNCOMMITTED) ON EP.EntityId = T.StoragePoolId AND EP.EntityType = 9 AND EP.propertyName = ''DialHomeEmailAddress'' AND EP.CommCellId = 2

	WHERE T.EntityStatus = 0 

	drop table #tbl_HWDetailForAlert'

IF NOT EXISTS ( SELECT 1 FROM GXUniqueSQLScriptExecTracking  WITH(NOLOCK) WHERE SqlScriptGUID = @Alertguid )

BEGIN 

	DECLARE @taskId				INT

	DECLARE @xmlEntities		NVARCHAR(MAX)= '<CVGui_CommCellTreeNode>

		<associations _type_="124" commCellId="2" />

		<clientGroups includeAll="0" />

		<clients includeAll="0" />

		<commcells includeAll="0" />

		<criterias includeAll="0" />

		<libraries includeAll="0" />

		<mediaAgents includeAll="0" />

		<storagePolcies includeAll="0" />

		<trackingJobs />

		<trackingPolicies includeAll="0" />

		<trackingSchedules />

		<workflows includeAll="0" />

	</CVGui_CommCellTreeNode>'

	DECLARE @adminID			INT = ISNULL((SELECT TOP 1 id from UMUsers where (flags & 67) = 67), 1)

	DECLARE	@emptyDateTime		DATETIME = '1900-01-01 00:00:00.000'

	DECLARE @localeId			INT = 0

	DECLARE	@ruleState			INT = 2					-- Alert Severity

	DECLARE @persistTimeSeconds INT = 0

	DECLARE @notifType			INT = 131073			

	DECLARE @queryId			INT

	DECLARE @alertId			INT = 1

	DECLARE @alertType			INT = 65																-- 'NT_ALERTTYPE_CUSTOM_QUERY'

	DECLARE @notificationName	NVARCHAR(128)	= 'Dial home for Hyperscale and Appliance hardware'				-- 'NT_MAX_NOTIFICATION_NAME_SIZE'

	DECLARE @description		NVARCHAR(1024)	= 'Default alert for Hyperscale Hardware Monitoring'			-- 'NT_MAX_ALERT_DESCRIPTION_SIZE'

	DECLARE @msgFmtHtml 		NVARCHAR(max)

	DECLARE @criteriasToAdd table (

			alertId				INT,

			criteriaId			INT,

			criteriaParamType	INT,

			criteriaParamValue	INT,

			criteriaParamUnit	INT

			PRIMARY KEY(alertId,criteriaId)

	)

	----------------------

	DECLARE	@thisAlertId		INT

	SET @errorCode	= 0

	SET @errorString = ''

	BEGIN TRY

		BEGIN TRAN

		BEGIN

IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name='UseNewAlertTemplate' AND value=1 and modified=0)

				SET @msgFmtHtml = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border-top-color: #2f4e66; border-top-style: solid; border-top-width: 1px; border-right-color: #2f4e66; border-right-style: solid; border-right-width: 1px; border-bottom-color: #2f4e66; border-bottom-style: solid; border-bottom-width: 1px; border-left-color: #2f4e66; border-left-style: solid; border-left-width: 1px"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"><td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Alert Rule Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;QUERY NAME&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif">&lt;TABLE DATA&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Condition Cleared</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CONDITION CLEARED Y/N&gt;</font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At: &lt;TIME&gt; </font> </td> </tr> </table> </center></td> </tr> </table></div>'

			ELSE

				SET @msgFmtHtml = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellpadding="0" cellspacing="0" border="1" align="center" width="100%" style="border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-style: solid; border-top-color: #dedede; border-right-color: #dedede; border-bottom-color: #dedede; border-left-style: solid; border-right-style: solid; border-top-width: 0px; border-right-width: 0px"> <tr> <td> <center> <table cellpadding="0" border="0" id="contentTbl" width="100%" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td valign="middle" align="left"> <div style="margin-left: 10px; margin-bottom: 4px; margin-top: 4px"> <font size="6" face="Helvetica,sans-serif" color="#EEEEEE">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td colspan="1" valign="middle" align="left" bgcolor="#DCDEDE"> <ul style="margin-top: 4px; margin-bottom: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>CommCell: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-top: 4px; margin-bottom: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>Type: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-top: 4px; margin-bottom: 4px"> <font size="3" face="Helvetica,sans-serif" color="#000000">User: &lt;USER NAME&gt;</font> </li> <li style="margin-top: 4px; margin-bottom: 4px"> <font size="3" face="Helvetica,sans-serif" color="#000000">Alert Rule Name : &lt;QUERY NAME&gt;</font> </li> <font size="3" face="Helvetica,sans-serif" color="#000000">&lt;TABLE DATA&gt;</font> <li style="margin-top: 4px; margin-bottom: 4px"> <font size="3" face="Helvetica,sans-serif" color="#000000">Condition Cleared: : &lt;CONDITION CLEARED Y/N&gt;</font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">   </td> </tr> </table> </center> </td> </tr> </table> </div>' 
			INSERT INTO @criteriasToAdd


			SELECT @alertId, 75 /* NT_GENERIC_QUERY (Custom Query)*/, NULL, NULL, NULL

				-- Check whether this alert is already present. If so, dont insert again.

				IF NOT EXISTS (SELECT 1 FROM NTNotificationRule

					WHERE notificationName=@notificationName AND revision=1

				)

				BEGIN
				INSERT INTO NTNotificationRule (categoryId,				alertTypeId,


												notificationName,		revision,

												lastModified,			description,

												notifType,				notifOwner,

												locale,					status,

												ruleState,				ruleState2,

												lastTimeTriggered,		lastTimeTriggered2,

												lastTimeChecked,		hasAttachments,

												hasAttachments2,		xmlEntityList,

												origCCId,				GUID            )

				SELECT							9,						@alertType,

												@notificationName,		1,

												@nowTime,				@description,

												@notifType,				@adminID,

												@localeId,				(2048),								    

												-- Status 2049 ( Default alert, disabled ). Creating this alert in disabled state

												@ruleState,				@ruleState,

												@emptyDateTime,			@emptyDateTime,

												@emptyDateTime,			0,

												0,						@xmlEntities ,

												2,						newid()

				FROM NTAlertType WHERE id = @alertType

				SET @thisAlertId = @@Identity
				INSERT INTO NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)


				SELECT criteriaId, 1, @thisAlertId, @reportOptions , 0, @persistTimeSeconds

				FROM @criteriasToAdd

				WHERE alertId = @alertId

				IF EXISTS (SELECT 1 FROM @criteriasToAdd WHERE alertId = @alertId AND criteriaParamType IS NOT NULL AND

					criteriaParamValue IS NOT NULL AND criteriaParamUnit IS NOT NULL)

				BEGIN
					INSERT INTO NTSelCriteriaParams (selCriteriaid, paramIndex, type, value, unit, occurrences)


					SELECT id, 0, criteriaParamType, criteriaParamValue, criteriaParamUnit, 0

					FROM NTSelcriteria , @criteriasToAdd newCriterias

					WHERE NTSelcriteria.ruleid = @thisAlertId

						AND newCriterias.alertId = @alertId

						AND newCriterias.criteriaParamType IS NOT NULL 

						AND newCriterias.criteriaParamValue IS NOT NULL AND newCriterias.criteriaParamUnit IS NOT NULL

				END
				INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)


					VALUES (@thisAlertId, 1, null, null, 0)
				INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)


					VALUES (@thisAlertId, 2, null, null, 0)

				-- :ADD DEFAULT MESSAGES:--
				INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


									SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

									messageFormatType, formatStringHtml)

					VALUES		(@thisAlertId, 1, 1, @msgFmtText, N'',

									0, 0, 0, 0, 0,

									1, @msgFmtHtml)
				INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


									SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

									messageFormatType, formatStringHtml)

					VALUES		(@thisAlertId, 131072, 1, @msgFmtText, N'',

									0, 0, 0, 0, 0,

									0, N'')
				INSERT INTO NTnotificationUsers(NtnotificationId,userId,escalationLevel)


				SELECT @thisAlertId,@adminID,1
				INSERT INTO NTnotificationNonGalaxyUsers(NtnotificationId,nonGalaxyUserName,escalationLevel)


				SELECT @thisAlertId,'hyperscalealerts@commvault.com',1

				IF NOT EXISTS ( SELECT 1 FROM NTQueryList WHERE queryName = 'HyperScale-HardwareAlerts')

				BEGIN

					Print  'Creating alert Rule " HyperScale Hardware Monitoring Alert " since its not present  in the machine '

					DECLARE @GUID VARCHAR(40)

					SET @GUID = NEWID()
					INSERT INTO NTQueryList VALUES


					(

					0 ,    -- queryMessageId

					@defaultFreq, --default frequency

					0,     -- status 

					1,     -- Query Creator

					1,     -- Visibility

					0,     -- Task Id 

					@alertQuery,		-----  Query ---------- 

					---- xmlInfo ----

					'<?xml version="1.0" encoding="UTF-16" standalone="no" ?><App_AdditionalQueryDetails alertCriteria="0" alertType="0" isHealthParam="0" querySeverity="3"><externalQueryEntity _type_="125"/><scriptDescription description="Rule to notify hardware components that are offline on commvault hyperscale appliances" guid="482B4F23-1E3E-43D9-A806-7752446BA8C6" reportName="HyperScale-HardwareAlerts" revision="$Revision: 1.1.2.7 $ M&lt;1542215634924>"/></App_AdditionalQueryDetails>',

					'HyperScale-HardwareAlerts', -- queryName

					'Rule to notify hardware components that are offline on commvault hyperscale appliances', --queryDescription

					'',                     -- queryCriteriaName

					@GUID,                  -- GUID

					---- commcellAssociation ----

					'<App_Associations><entity _type_="125" /></App_Associations>',

					1						-- isOverwriteAssociationAtAlertAllowed

					)	

				END

				SELECT 	@queryId = queryId , @taskId = taskId 

				FROM 	NTQueryList  

				WHERE 	queryName  = 'HyperScale-HardwareAlerts'

				DELETE FROM NTQueryColumnList WHERE QueryId = @queryId	
				INSERT INTO NTQueryColumnList


				VALUES	(@queryId,	0,	1,	1,	'StoragePoolName',	'Storage Pool',				0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

						(@queryId,	1,	1,	1,	'NodeName',			'Node',						0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

						(@queryId,	2,	1,	1,	'EntityName',		'Hardware Entity Name',		0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

						(@queryId,	3,	0,	1,	'EntityStatusStr',	'Hardware Entity Status',	1,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

						(@queryId,	4,	0,	0,	'CommcellNumber',	'Commcell Id',				0,	'0,1,4,5,6,7',	0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

						(@queryId,	5,	0,	1,	'NodeSerialNumber',	'Node Serial Number',		1,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

						(@queryId,	6,	0,	1,	'CustomerEmail',	'Contact to Email',			0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

						(@queryId,	7,	0,	0,	'EntityType',		'EntityType',				1,	'0,1,4,5,6,7',	0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>')	
				INSERT INTO NTNotificationQueryMapping 


				VALUES(

					@queryId, @thisAlertId, @emptyDateTime, @emptyDateTime,

					0, @taskId,

					'',

					'<CVGui_QueryAdditionalInfo><queryParameters/><externalQueryInfo _type_="125"/></CVGui_QueryAdditionalInfo>',

					'',

					'HyperScale-HardwareAlerts'

				)

			END

		END

	END TRY

	BEGIN CATCH

		SET @errorCode = ERROR_NUMBER()

		SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

	END CATCH
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


	VALUES	(@Alertguid , 'NTDefaultAlert_ApplianceHardwareMonitoringAlert', 'Tblscript to add default alerts for HyperScale hardware components', @nowTime, 16, 0 , (16 + 2)),

			('176FE4CC-458E-43B9-8B08-070CD37EBE4C' , 'NTDefaultAlert_ApplianceHardwareMonitoringAlert', 'Tblscript to include default hyperscale alert emali recipient ', @nowTime, 16, 0 , (16 + 2)),

			( @ChangingDefaultFrequencyGUID, 'NTDefaultAlert_ApplianceHardwareMonitoringAlert', 'Tblscript for changing default frequency', @nowTime, 16, 0 , (16 + 2))

	SELECT @errorCode=@@error

	IF @errorCode = 0

		COMMIT TRAN

	ELSE

	BEGIN

		IF LEN(@errorString) > 0

			Print @errorString

		ELSE

			Print 'SQL Error encountered while running the script hence rolling back Transaction'

		ROLLBACK TRAN

	END

END

IF NOT EXISTS ( SELECT 1 FROM GXUniqueSQLScriptExecTracking  WITH(NOLOCK) WHERE SqlScriptGUID = '176FE4CC-458E-43B9-8B08-070CD37EBE4C' )

BEGIN 

	DECLARE @tempAlertId INT = 0;

	SET @tempAlertId = (SELECT TOP 1 Id FROM  NTNotificationRule WHERE notificationName = 'Hyperscale Hardware Monitoring Alert')

	IF(ISNULL(@tempAlertId, 0) <> 0)

	BEGIN

		DECLARE @newNotificationName	NVARCHAR(128)	= 'Dial home for Hyperscale and Appliance hardware'

		UPDATE NTNotificationRule

		SET notificationName = @newNotificationName

		WHERE id = @tempAlertId

		IF NOT EXISTS( SELECT 1 FROM NTnotificationNonGalaxyUsers WHERE NtnotificationId = @tempAlertId AND nonGalaxyUserName = 'hyperscalealerts@commvault.com')

		BEGIN
			INSERT INTO NTnotificationNonGalaxyUsers(NtnotificationId, nonGalaxyUserName, escalationLevel)


				SELECT @tempAlertId, 'hyperscalealerts@commvault.com', 1

		END

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


		VALUES('176FE4CC-458E-43B9-8B08-070CD37EBE4C' , 'NTDefaultAlert_ApplianceHardwareMonitoringAlert', 'Tblscript to include default hyperscale alert emali recipient ', @nowTime, 16, 0 , (16 + 2))

END

IF NOT EXISTS ( SELECT 1 FROM GXUniqueSQLScriptExecTracking (READUNCOMMITTED) WHERE SqlScriptGUID = @ChangingDefaultFrequencyGUID )

BEGIN

	IF EXISTS ( SELECT 1 FROM NTQueryList WHERE queryName = 'HyperScale-HardwareAlerts')

	BEGIN

		DECLARE @tmpQueryId INT

		SELECT @tmpQueryId = queryId FROM NTQueryList WHERE queryName  = 'HyperScale-HardwareAlerts'

		UPDATE 	C

		SET     formatString = @msgFmtText

		FROM    NTmessageFormat C

			INNER JOIN NTNotificationQueryMapping map ON map.NtNotificationId = C.NtNotificationId

		WHERE map.QueryId = @tmpQueryId

		UPDATE C

        SET reportingOptions = @reportOptions

        FROM NTSelCriteria C

            INNER JOIN NTNotificationQueryMapping map ON map.NtNotificationId = C.ruleId

        WHERE QueryId = @tmpQueryId

		DELETE FROM NTQueryColumnList WHERE QueryId = @tmpQueryId	
		INSERT INTO NTQueryColumnList


		VALUES	(@tmpQueryId,	0,	1,	1,	'StoragePoolName',	'Storage Pool',				0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

				(@tmpQueryId,	1,	1,	1,	'NodeName',			'Node',						0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

				(@tmpQueryId,	2,	1,	1,	'EntityName',		'Hardware Entity Name',		1,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

				(@tmpQueryId,	3,	0,	1,	'EntityStatusStr',	'Hardware Entity Status',	0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

				(@tmpQueryId,	4,	0,	0,	'CommcellNumber',	'Commcell Id',				0,	'0,1,4,5,6,7',	0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

				(@tmpQueryId,	5,	0,	1,	'NodeSerialNumber',	'Node Serial Number',		1,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

				(@tmpQueryId,	6,	0,	1,	'CustomerEmail',	'Contact to Email',			0,	'2,3,0,1',		0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

				(@tmpQueryId,	7,	0,	0,	'EntityType',		'EntityType',				1,	'0,1,4,5,6,7',	0,	'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>')	

		UPDATE 	NTQueryList

		SET  	queryString = @alertQuery,

				defaultfrequency = IIF(defaultfrequency = 86400, @defaultFreq, defaultfrequency)

		WHERE 	queryName = 'HyperScale-HardwareAlerts'

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


		VALUES( @ChangingDefaultFrequencyGUID, 'NTDefaultAlert_ApplianceHardwareMonitoringAlert', 'Tblscript for changing default frequency', @nowTime, 16, 0 , (16 + 2))

END

