

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDefaultAlertForVSAV2ClientsWithReplicaSnaps.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

--

--  +========================================================================+

--  |      

--  |       Copyright (c) 1998  CommVault Systems, Inc.                

--  |               All rights reserved.                                

--  |                                                                   

--  |                                                                

--  |     This is unpublished proprietary source code of CommVault  

--  |     Systems, Inc. The copyright notice above does not evidence 

--  |     any actual or intended publication of such source code. 

--  +========================================================================+

--  +========================================================================+

--  |   Script Name: NTDefaultAlertForVSAV2ClientsWithReplicaSnaps.script   

--  |   Description: Delete the rule and alert created for alerting when VSA V2 clients

--	|					have replica snapshots (unsupported configuration)

--  +========================================================================+

DECLARE @uniqueSQLScriptGUIDString VARCHAR(128) = '83CD9353-A3F2-4F55-BE10-0B2A58858F85'

DECLARE @uniqueSQLScriptGUIDExists BIT = 0

SELECT @uniqueSQLScriptGUIDExists = 1

FROM GXUniqueSQLScriptExecTracking WITH (READUNCOMMITTED)

WHERE

    SqlScriptGUID = @uniqueSQLScriptGUIDString

IF @uniqueSQLScriptGUIDExists = 0

BEGIN

	DECLARE @queryId INT = 0            			

	DECLARE @ruleIDs TABLE (ruleId INT)

	DECLARE  @errorCode         INT         

    DECLARE  @errorString       VARCHAR(1024)   

	DECLARE @nowTime            INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

	SET @errorCode  = 0

    SET @errorString = ''	

	SET @queryId = (SELECT queryId FROM NTQueryList WITH (READUNCOMMITTED) WHERE queryName = 'Notify VSA V2 unsupported configuration')
	INSERT INTO @ruleIDs


	SELECT NtNotificationId FROM NTNotificationQueryMapping WITH (READUNCOMMITTED) WHERE QueryId = @queryId

    BEGIN TRY

        BEGIN TRAN

        BEGIN

			DELETE FROM NTDetectedAlerts WHERE ntNotificationId IN (SELECT ruleId FROM @ruleIDs)

			DELETE FROM NTnotificationUsers WHERE NTnotificationID IN (SELECT ruleId FROM @ruleIDs)

			DELETE FROM NTmessageFormat WHERE NTnotificationID IN (SELECT ruleId FROM @ruleIDs)

			DELETE FROM NTmessages WHERE NTnotificationID IN (SELECT ruleId FROM @ruleIDs)

			DELETE FROM NTSelCriteria WHERE ruleId IN (SELECT ruleId FROM @ruleIDs)

			DELETE FROM NTnotificationAction WHERE NTnotificationID IN (SELECT ruleId FROM @ruleIDs)

			DELETE FROM NTattachedFiles WHERE NTnotificationID IN (SELECT ruleId FROM @ruleIDs)

			DELETE FROM NTRomsQueue WHERE NTnotificationID IN (SELECT ruleId FROM @ruleIDs)

			DELETE FROM NTAlertSubScriptions WHERE ntRuleId IN (SELECT ruleId FROM @ruleIDs)

			DELETE FROM NTnotificationExternalGroups WHERE NTnotificationID IN (SELECT ruleId FROM @ruleIDs)

			DELETE FROM NTnotificationGroups WHERE NTnotificationID IN (SELECT ruleId FROM @ruleIDs)

			DELETE FROM NTmessageTracking WHERE NTnotificationID IN (SELECT ruleId FROM @ruleIDs)

			DELETE FROM NTSpoolQueue WHERE NTnotificationID IN (SELECT ruleId FROM @ruleIDs)

			DELETE FROM NTmessageHistory WHERE NTnotificationID IN (SELECT ruleId FROM @ruleIDs)

			DELETE FROM NTnotificationRule WHERE id IN (SELECT ruleId FROM @ruleIDs)

			DELETE FROM NTNotificationQueryMapping WHERE QueryId = @queryId

			DELETE FROM NTQueryColumnList WHERE queryId = @queryId

			DELETE FROM NTQueryList WHERE queryId = @queryId
			INSERT INTO GXUniqueSQLScriptExecTracking


            VALUES(@uniqueSQLScriptGUIDString, 'Delete VSA V2 unsupported configuration alert', 'Delete VSA V2 unsupported configuration alert', @nowTime, 16, 0, 18)

        END  

    END TRY

    BEGIN CATCH

        SET @errorCode = ERROR_NUMBER()

        SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

    END CATCH

    IF @errorCode = 0

        COMMIT TRAN

    ELSE

    BEGIN

        IF LEN(@errorString) > 0

            Print @errorString

        ELSE

            Print 'SQL Error encountered while running the script hence rolling back Transaction'

        ROLLBACK TRAN

    END

END
