

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDefaultAlertForNoDDBVerificationJob.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

--

--  +========================================================================+

--  |      

--  |       Copyright (c) 1998  CommVault Systems, Inc.                

--  |               All rights reserved.                                

--  |                                                                   

--  |                                                                

--  |     This is unpublished proprietary source code of CommVault  

--  |     Systems, Inc. The copyright notice above does not evidence 

--  |     any actual or intended publication of such source code. 

--  +========================================================================+

--  +========================================================================+

--  |   Script Name: NTDefaultAlertForNoDDBVerificationJob.script   

--  |   Description: Default rule and alert for alerting when DDB Verification

--  |				job did not run in last n days

--  +========================================================================+

DECLARE @uniqueSQLScriptGUIDString VARCHAR(128) = '3C4C48B0-DAD0-4E82-B98A-3C0995C43580'

DECLARE @uniqueSQLScriptGUIDExists BIT = 0

SELECT @uniqueSQLScriptGUIDExists = 1

FROM GXUniqueSQLScriptExecTracking 

WHERE

    SqlScriptGUID = @uniqueSQLScriptGUIDString

IF @uniqueSQLScriptGUIDExists = 0

BEGIN

    DECLARE  @errorCode         INT         

    DECLARE  @errorString       VARCHAR(1024)   

	DECLARE @nowTime            INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

    DECLARE @xmlEntities        NVARCHAR(MAX)= '<CVGui_CommCellTreeNode>  <clients includeAll="0" />  <clientGroups includeAll="0" />  <libraries includeAll="0" />  <mediaAgents includeAll="0" />  <storagePolcies includeAll="0" />  <trackingPolicies includeAll="0" />  <trackingSchedules />  <trackingJobs />  <criterias includeAll="0" />  <workflows includeAll="0" />  <commcells includeAll="0" /></CVGui_CommCellTreeNode>'

DECLARE @adminID            INT = ISNULL((SELECT TOP 1 id from UMUsers where (flags & (0x001+0x002+0x040)) >0), 1)

    DECLARE @emptyDateTime      DATETIME = '1900-01-01 00:00:00.000'

    DECLARE @localeId           INT = 0

    DECLARE @ruleState          INT = 3                 -- Alert Severity

DECLARE @reportOptions      INT = 1

    DECLARE @persistTimeSeconds INT = 0

	DECLARE @delayTimeSeconds INT = 0

    DECLARE @createdAlertsId    INT = 1

DECLARE @notifType          INT = 1 + 131072

    DECLARE @queryId            INT	

DECLARE @alertType          INT = 65

    DECLARE @notificationName   NVARCHAR(128)  = 'No DDB Verification Job in last n days'         -- 'NT_MAX_NOTIFICATION_NAME_SIZE'

    DECLARE @description        NVARCHAR(1024)  = 'Default alert rule for No DDB Verification Job in last n days on active Deduplication Engines of copies belonging to selected storage policies'       -- 'NT_MAX_ALERT_DESCRIPTION_SIZE'

    DECLARE @thisAlertId        INT

    DECLARE @criteriasToAdd table (

            criteriaId          INT,

            criteriaParamType   INT,

            criteriaParamValue  INT,

            criteriaParamUnit   INT

            PRIMARY KEY(criteriaId)

    )

    SET @errorCode  = 0

    SET @errorString = ''

    BEGIN TRY

        BEGIN TRAN

        BEGIN

            DECLARE @htmldefaultTemplate NVARCHAR(max)

            DECLARE @textdefaultTemplate NVARCHAR(max)

IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name='UseNewAlertTemplate' AND value=1)

				SET @htmldefaultTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border-top-color: #2f4e66; border-top-style: solid; border-top-width: 1px; border-right-color: #2f4e66; border-right-style: solid; border-right-width: 1px; border-bottom-color: #2f4e66; border-bottom-style: solid; border-bottom-width: 1px; border-left-color: #2f4e66; border-left-style: solid; border-left-width: 1px"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Alert Rule Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;QUERY NAME&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif">&lt;INPUT DATA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif">&lt;TABLE DATA&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Condition Cleared</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CONDITION CLEARED Y/N&gt;</font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At: &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'

			ELSE

				SET @htmldefaultTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellpadding="0" cellspacing="0" border="1" align="center" width="100%" style="border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-style: solid; border-top-color: #dedede; border-right-color: #dedede; border-bottom-color: #dedede; border-left-style: solid; border-right-style: solid; border-top-width: 0px; border-right-width: 0px"> <tr> <td> <center> <table cellpadding="0" border="0" id="contentTbl" width="100%" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td valign="middle" align="left"> <div style="margin-left: 10px; margin-bottom: 4px; margin-top: 4px"> <font size="6" face="Helvetica,sans-serif" color="#EEEEEE">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td colspan="1" valign="middle" align="left" bgcolor="#DCDEDE"> <ul style="margin-top: 4px; margin-bottom: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>CommCell: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-top: 4px; margin-bottom: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>Type: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-top: 4px; margin-bottom: 4px"> <font size="3" face="Helvetica,sans-serif" color="#000000">User: &lt;USER NAME&gt;</font> </li> <li style="margin-top: 4px; margin-bottom: 4px"> <font size="3" face="Helvetica,sans-serif" color="#000000">Alert Rule Name : &lt;QUERY NAME&gt;</font> </li> <font size="3" face="Helvetica,sans-serif" color="#000000">&lt;INPUT DATA&gt;&lt;TABLE DATA&gt;</font> <li style="margin-top: 4px; margin-bottom: 4px"> <font size="3" face="Helvetica,sans-serif" color="#000000">Condition Cleared: : &lt;CONDITION CLEARED Y/N&gt;</font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left"> </td> </tr> </table> </center> </td> </tr> </table> </div>'

			SET @textdefaultTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_ MsgNewLine_ MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Alert Rule Name : <QUERY NAME> MsgNewLine_MsgTab_ <INPUT DATA> MsgNewLine_MsgTab_ SIDBStoreName : <INDEX 0> MsgNewLine_MsgTab_ Existing jobs on Disk and DDB last verified on : <INDEX 1> MsgNewLine_MsgTab_ Condition Cleared: : <CONDITION CLEARED Y/N>'    
            INSERT INTO @criteriasToAdd


SELECT 75, NULL, NULL, NULL

			IF NOT EXISTS (SELECT 1 FROM NTNotificationRule  WHERE notificationName=@notificationName AND revision=1 )

            BEGIN
                INSERT INTO NTNotificationRule (categoryId,             alertTypeId,


                                                notificationName,       revision,

                                                lastModified,           description,

                                                notifType,              notifOwner,

                                                locale,                 status,

                                                ruleState,              ruleState2,

                                                lastTimeTriggered,      lastTimeTriggered2,

                                                lastTimeChecked,        hasAttachments,

                                                hasAttachments2,        xmlEntityList,

                                                origCCId,               GUID            )

                SELECT                          categoryID,             @alertType,

                                                @notificationName,      1,

                                                @nowTime,               @description,

                                                @notifType,             @adminID,

@localeId,              2048 +  1 ,

                                                @ruleState,             @ruleState,

                                                @emptyDateTime,         @emptyDateTime,

                                                @emptyDateTime,         0,

                                                0,                      @xmlEntities ,

                                                2,                      newid()

                FROM NTAlertType WHERE id = @alertType

                SET @thisAlertId = @@Identity
                INSERT INTO NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)


                SELECT criteriaId, 1, @thisAlertId, @reportOptions , @delayTimeseconds, @persistTimeSeconds

                FROM @criteriasToAdd

                IF EXISTS (SELECT 1 FROM @criteriasToAdd WHERE criteriaParamType IS NOT NULL AND criteriaParamValue IS NOT NULL AND criteriaParamUnit IS NOT NULL)

                BEGIN
                    INSERT INTO NTSelCriteriaParams (selCriteriaid, paramIndex, type, value, unit, occurrences)


                    SELECT id, 0, criteriaParamType, criteriaParamValue, criteriaParamUnit, 0

                    FROM NTSelcriteria , @criteriasToAdd newCriterias

                    WHERE NTSelcriteria.ruleid = @thisAlertId

                        AND newCriterias.criteriaParamType IS NOT NULL 

                        AND newCriterias.criteriaParamValue IS NOT NULL AND newCriterias.criteriaParamUnit IS NOT NULL

                END
                INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)


                    VALUES (@thisAlertId, 1, null, null, 0)
                INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)


                    VALUES (@thisAlertId, 2, null, null, 0)

                -- :ADD DEFAULT MESSAGES:--
                INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


                                    SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

                                    messageFormatType, formatStringHtml)

VALUES      (@thisAlertId, 1, 1, @textdefaultTemplate, N'',

                                    0, 0, 0, 0, 0,

                                    1, @htmldefaultTemplate)            
                INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


                                    SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

                                    messageFormatType, formatStringHtml)

VALUES      (@thisAlertId,   131072, 1, @textdefaultTemplate, N'',

                                    0, 0, 0, 0, 0,

                                    0, @textdefaultTemplate)
                INSERT INTO NTnotificationUsers(NtnotificationId,userId,escalationLevel)


                SELECT @thisAlertId,@adminID,1

                IF NOT EXISTS ( SELECT 1 FROM NTQueryList WHERE queryName = 'No DDB Verification Job in last n days')

                BEGIN

                    DECLARE @GUID VARCHAR(40)

                    SET @GUID = NEWID()
                    INSERT INTO NTQueryList (queryMessageId, defaultfrequency, status, queryCreator, visibility, taskId, queryString, xmlInfo, queryName, queryDescription, queryCriteriaName, GUID, commcellAssociation, isOverwriteAssociationAtAlertAllowed)


                    VALUES

                    (

                    0 ,             -- queryMessageId

                    24 * 3600,      --default frequency 

                    0,              -- status 

                    @adminID,       -- Query Creator

                    1,              -- Visibility

                    0,              -- Task Id 

                    -----  Query ---------- 

                    ' SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

					SET QUOTED_IDENTIFIER ON

					SET NOCOUNT ON

					-- DECLARE @noDDBDataVerificationForDays INTEGER = 2

					-- DECLARE @policyList TABLE(EntityId INT, entityname NVARCHAR(max))

					-- DECLARE @userId INT = 1

					-- INSERT INTO @policyList

					-- SELECT	AG.id, AG.name

					-- FROM	archGroup AG

					--storage policies user has access

					IF OBJECT_ID(''tempdb..#getNonIdaObjects_OutputTable'') IS NOT NULL DROP TABLE #getNonIdaObjects_OutputTable

					CREATE TABLE #getNonIdaObjects_OutputTable (entityId INT PRIMARY KEY)    

					EXEC sec_getNonIdaObjectsForThisUser @userid, 17 /*STORAGE_POLICY_ENTITY*/, 4 /*EV_MANAGE_ARCHIVES*/, ''#getNonIdaObjects_OutputTable'' 

					DELETE P

					FROM    @policyList P LEFT OUTER JOIN #getNonIdaObjects_OutputTable T ON P.EntityId = T.EntityId

					WHERE T.EntityId IS NULL

					DECLARE @nowTime INT =dbo.getunixTime(getutcdate())

					DECLARE @checkDDBDVTime INT = (@nowTime - (@noDDBDataVerificationForDays * 24 * 3600))

					--DECLARE @checkDDBDVTime INT = (@nowTime - (@noDDBDataVerificationForDays * 60))

					DECLARE @storeList TABLE(SIDBStoreId INT, SIDBStoreName NVARCHAR(256), LastDataVerificationTime INT, PolicyId INT, CopyId INT PRIMARY KEY(SIDBStoreId))

					--Get the stores whose last data verification time is older than n days
					INSERT INTO @storeList


					SELECT	I.SIDBStoreId, I.SIDBStoreName, I.LastDataVerificationTime, AGC.archGroupId, AGC.id 

					FROM	@PolicyList AG

							INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON AG.EntityId = AGC.archGroupId

							INNER JOIN archCopySIDBStore S WITH (READUNCOMMITTED) ON AGC.id = S.CopyId

							INNER JOIN IdxSIDBStore I WITH (READUNCOMMITTED) ON S.SIDBStoreId = I.SIDBStoreId

					WHERE	I.SealedTime = 0

							AND I.TotalDataSizeBytes > 0

							AND I.LastDataVerificationTime < @checkDDBDVTime

AND (S.flags & 4) > 0

							AND (AGC.dedupeFlags & 134217728/*CVA_USE_GLOBAL_DEDUP_STORE_FLAG*/) = 0

					GROUP BY I.SIDBStoreId, I.SIDBStoreName, I.SIDBStoreAliasName, I.LastDataVerificationTime, AGC.archGroupId, AGC.id 

					--Delete the stores with running DDB Verification jobs

					DELETE  S

					FROM	@StoreList S,

							(SELECT DISTINCT CloudId SIDBStoreId

							FROM	JMAdminJobInfoTable WITH (READUNCOMMITTED)

WHERE	opType = 31 AND CloudId > 0 AND (ER_BkpLevel & (0x10 + 0x8 + 0x4)) > 0) JA

					WHERE	S.SIDBStoreId = JA.SIDBStoreId

					--Delete the stores having data on hyperscale, Hedwig or cloud

					DELETE  S

					FROM	@storeList S

							INNER JOIN MMDataPath DPath WITH (READUNCOMMITTED) ON S.CopyId = DPath.CopyId

							INNER JOIN MMDrivePool DP WITH (READUNCOMMITTED) ON DPath.DrivePoolId = DP.DrivePoolId

							INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON DP.MasterPoolId = MP.MasterPoolId

					WHERE	(MP.Attribute & 64/*MNTPTH_ATTRIB_GFS_VOL_CONFIGURED*/) != 0

							OR MP.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/

					--Delete the store without new data after the last verification

					DELETE  S

					FROM	@StoreList S,

							(SELECT S.SIDBStoreId, MAX(AC.createTime) LastChunkCreateTime

							FROM @StoreList S

								INNER JOIN MMVolume MV WITH (READUNCOMMITTED) ON S.SIDBStoreId = MV.SIDBStoreId

								INNER JOIN archChunk AC  WITH (READUNCOMMITTED) ON MV.VolumeId = AC.volumeId

							GROUP BY S.SIDBStoreId) T

					WHERE	S.SIDBStoreId = T.SIDBStoreId

							AND S.LastDataVerificationTime > T.LastChunkCreateTime

					SELECT	SIDBStoreName, dbo.UTCToClientLocalTime(dbo.GetDateTime(LastDataVerificationTime), 2) ''ExistingJobsOnDiskAndDDBLastVerifiedOn''

					FROM	@storeList

					',

                    ------------------------- Query ends ------------------------------------------------                   

                    ---- xmlInfo ----

                    '<?xml version="1.0" encoding="UTF-16" standalone="no" ?><App_AdditionalQueryDetails alertCriteria="0" alertType="0" defaultHtmlTemplate="" defaultTextTemplate="" isHealthParam="0" querySeverity="2"><externalQueryEntity _type_="125"/><scriptDescription description="" guid="5633EB8D-128E-4B27-884E-A16A8BB1FA27" reportName="No DDB DataVerification Job for last n days" revision="$Revision: 1.1.2.1 $ M&lt;1598993006881>"/></App_AdditionalQueryDetails>',

                    'No DDB Verification Job in last n days',  -- queryName

                    'Default alert rule for No DDB Verification Job in last n days on active Deduplication Engines of copies belonging to selected storage policies.',     --queryDescription 

                    '',                     -- queryCriteriaName

                    @GUID,                  -- GUID

                    ---- commcellAssociation ----

                    '<App_Associations>  <entity _type_="124" commCellId="2" /></App_Associations>',

                    0                       -- isOverwriteAssociationAtAlertAllowed

                    )   

                END

                SELECT @queryId = queryId FROM NTQueryList  

                WHERE queryName  = 'No DDB Verification Job in last n days'

                IF NOT EXISTS (SELECT 1 FROM NTQueryColumnList WHERE QueryId = @queryId)

                BEGIN
                    INSERT INTO NTQueryColumnList VALUES


                        (@queryId, 0, 1, 1, 'SIDBStoreName', 'SIDBStoreName', 0, '2,3,0,1', 0, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

                        (@queryId, 0, 0, 0, 'policyList', 'Storage Policies', 0, '', 1, '<App_XMLSchema attribute="0" className="commvault.msgs.CvEntities.StoragePolicyEntity" controlHidden="0" controlType="2" displayName="Storage Policies" documentation="" hidden="0" inputName="policyList" inputType="commvault.msgs.CvEntities.StoragePolicyEntity" listType="1" maximumValue="" minimumValue="" name="policyList" readOnly="0" required="1" searchable="0" type="{commvault.msgs.CvEntities}StoragePolicyEntity"/>'),

                        (@queryId, 1, 1, 2, 'ExistingJobsOnDiskAndDDBLastVerifiedOn', 'Existing jobs on Disk and DDB last verified on', 0, '0,1,4,5,6,7,8', 0, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'), 

						(@queryId, 1, 0, 0, 'noDDBDataVerificationForDays', 'No DDB Data Verification for Days', 0, '', 1, '<App_XMLSchema attribute="0" className="java.lang.Integer" controlHidden="0" controlType="0" defaultValue="2" displayName="No DDB Data Verification for Days" documentation="" hidden="0" inputName="noDDBDataVerificationForDays" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" name="noDDBDataVerificationForDays" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"><defaultValues val="2"/></App_XMLSchema>')

                END
                INSERT INTO NTNotificationQueryMapping 


                VALUES(

                    @queryId, @thisAlertId, @emptyDateTime, @emptyDateTime,

                    0, 0,

                    '',

                    '<CVGui_QueryAdditionalInfo isHTMLContent="0"><queryParameters><queryParameters isList="0" javaType="" listColDataType="" paramName="policyList" sqlDataType="" value="&lt;policyList>&lt;isAllEntitiesSelected>true&lt;/isAllEntitiesSelected>&lt;/policyList>"/><queryParameters isList="0" javaType="" listColDataType="" paramName="noDDBDataVerificationForDays" sqlDataType="" value="&lt;noDDBDataVerificationForDays>2&lt;/noDDBDataVerificationForDays>"/></queryParameters><externalQueryInfo _type_="125"/></CVGui_QueryAdditionalInfo>',

                    '',

                    'No DDB Verification Job in last n days' 

                )      
				INSERT INTO GXUniqueSQLScriptExecTracking


				VALUES(@uniqueSQLScriptGUIDString, 'No DDB Verification Job in last n days alert', 'No DDB Verification Job in last n days alert', @nowTime, 16, 0, 18)

            END

        END  

    END TRY

    BEGIN CATCH

        SET @errorCode = ERROR_NUMBER()

        SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

    END CATCH

    IF @errorCode = 0

        COMMIT TRAN

    ELSE

    BEGIN

        IF LEN(@errorString) > 0

            Print @errorString

        ELSE

            Print 'SQL Error encountered while running the script hence rolling back Transaction'

        ROLLBACK TRAN

    END

END
