

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDefaultAlertForEdgeQuota.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/NTDefaultAlertForEdgeQuota.script,v $ $Id: NTDefaultAlertForEdgeQuota.script,v 1.1.2.5 2019/12/12 22:39:22 vdevassy Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

declare @guid uniqueidentifier = '45B0769D-2D2A-4336-B02A-4B8E3357F93F'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       

DECLARE @globalParamAlertCreateExec INT = 0

SELECT @globalParamAlertCreateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

declare  @errorCode             integer = 0

declare  @errorString           nvarchar(1024) = ''

IF (@globalParamAlertCreateExec = 0)        -- not done, create the default alerts.

BEGIN
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'DefaultAlertForEdgeDrive', 'Tblscript to create default subscription based alerts', @curUtcDateTime, 16, 0 , (16 + 2))

	if exists(

		select 1 from GxGlobalParam where name='MiniBrandId' and modified = 0

	and value in ('106','107')

	)

	begin

		-- dont create the below default alerts.

		return 

	end

	DECLARE @nowTime			as integer	= @curUtcDateTime

	DECLARE @xmlEntities		AS nvarchar(MAX)= '<CVGui_CommCellTreeNode><clients includeAll="0" /><clientGroups includeAll="0" /><libraries includeAll="0" /><mediaAgents includeAll="0" /><storagePolcies includeAll="0" /><trackingPolicies includeAll="0" /><trackingSchedules /><trackingJobs /><criterias includeAll="0" /><workflows includeAll="0" /><associations _type_="12" /><commcells includeAll="0" /></CVGui_CommCellTreeNode>'

	DECLARE	@emptyDateTime		AS datetime	= '1900-01-01 00:00:00.000'

	DECLARE @localeId			AS integer		= 0

	-- We need only 1 alert per message since client owners are being addressed. We cant send emails to owners of multiple clients. 

DECLARE @status				AS integer		= 128 + 16		-- 'NNT_STATUS_LAPTOP_ALERT

	DECLARE	@ruleState			AS integer		= 0

	DECLARE	@reportOptions		AS integer		= 3		-- 'NT_REPORT_IMMEDIATE' 

	DECLARE @persistTimeSeconds AS integer		= 86400 -- 1 day repeat duration

DECLARE	@categoryId			as integer 		=  2				-- 'NT_CATEGORY_JOB_MANAGEMENT'

	DECLARE @adminID			as integer		= ISNULL((Select top 1 ID from UMUSERS where (flags & 67) = 67 AND Name <> 'ROMS'), 1)

	DECLARE @SelCriteriaId		integer

	DECLARE @htmldefaultTemplate nvarchar(max)

	DECLARE @textdefaultTemplate nvarchar(max)	

IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name='UseNewAlertTemplate' AND value=1)

		set @htmldefaultTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>User </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;USER NAME&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Quota Limit </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;QUOTA LIMIT&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Space consumed </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SPACE CONSUMED&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Object size </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;OBJECT SIZE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Job ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;JOB ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Operation Performed By</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;OPERATION PERFORMED BY USER&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Status</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;STATUS&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Comments</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMENT&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Condition Cleared</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CONDITION CLEARED Y/N&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>&lt;CLEANUP DATA TEXT&gt; </b></font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'

	ELSE

		set @htmldefaultTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table cellpadding="0" cellspacing="0" border="1" align="center" width="75%" style="border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-style: solid; border-top-color: #dedede; border-right-color: #dedede; border-bottom-color: #dedede; border-left-style: solid; border-right-style: solid; border-top-width: 0px; border-right-width: 0px"><tr><td><center><table cellpadding="0" border="0" id="contentTbl" width="100%" align="center" cellspacing="0"><tr style="background-color: #666666"><td valign="middle" align="left"><div style="margin-left: 10px; margin-bottom: 4px; margin-top: 4px"><font size="6" face="Helvetica,sans-serif" color="#EEEEEE">&lt;ALERT NAME&gt; </font></div></td></tr><tr><td colspan="1" valign="middle" align="left" bgcolor="#DCDEDE"><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>CommCell: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong></ul><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>Type: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong></ul><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>Detected Criteria: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;DETECTED CRITERIA&gt;</font></strong></ul><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>Detected Time: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;TIME&gt;</font></strong></ul></td></tr><tr><td width="100%" colspan="1" align="left"><ul><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">User: &lt;USER NAME&gt; </font></li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Quota Limit : &lt;QUOTA LIMIT&gt; </font></li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Space consumed : &lt;SPACE CONSUMED&gt; </font></li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Object size : &lt;OBJECT SIZE&gt; </font></li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Job ID: &lt;JOB ID&gt; </font></li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Comments: &lt;COMMENT&gt; </font></li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Condition Cleared: &lt;CONDITION CLEARED Y/N&gt; </font></li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">&lt;CLEANUP DATA TEXT&gt;</font></li></ul></td></tr><tr style="background-color: #666666"><td colspan="1" align="left">&nbsp;</td></tr></table></center></td></tr></table>'

	set @textdefaultTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Quota Limit : <QUOTA LIMIT> MsgNewLine_MsgTab_ Space consumed : <SPACE CONSUMED> MsgNewLine_MsgTab_ Object size :  <OBJECT SIZE> MsgNewLine_MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Comments: <COMMENT> MsgNewLine_MsgTab_ Condition Cleared: <CONDITION CLEARED Y/N> MsgNewLine_MsgTab_'

	DECLARE @thisCriteria		int

DECLARE @notifType			AS integer	= 1			-- !! WAS !! 'NT_LAPTOP_ALERTNOTIF' + EMAIL (TO FAKE OUT GUI, FOR NOW!)

	--

	---

	----  FOR CURSOR -----

	DECLARE @alertType			INTEGER

DECLARE @notificationName	NVARCHAR(128)			-- 'NT_MAX_NOTIFICATION_NAME_SIZE'

DECLARE @description		NVARCHAR(1024)			-- 'NT_MAX_ALERT_DESCRIPTION_SIZE'

	DECLARE @msgFmtText			NVARCHAR(max) 

	DECLARE @msgFmtHtml 		NVARCHAR(max)

	--

	--		

	DECLARE @alertsToAdd table (

			alertType			int Not Null,

notificationName	nvarchar(128),

description			nvarchar(1024),

			msgFmtText			nvarchar(max),

			msgFmtHtml			nvarchar(max)

	)

	----------------------

	DECLARE	@thisAlertId		integer

	SET @errorCode	= 0

	SET @errorString= ''

	BEGIN TRY

		BEGIN TRAN

			-- CLEANUP FOR TESTING PURPOSES ONLY!

		--UPDATE NTNotificationRule SET status=2, revision = 0 where status = @status			-- Logically Delete old Alerts

		INSERT @alertsToAdd VALUES(

70,

				'Edge drive quota alert',

				'Alert for edge drive quota validation',

				@textdefaultTemplate,

				@htmldefaultTemplate				

				)

		DECLARE newAlertsCursor CURSOR STATIC FOR

			SELECT  alertType, notificationName, description, msgFmtText, msgFmtHtml

			   FROM @alertsToAdd

		OPEN newAlertsCursor

			FETCH NEXT FROM newAlertsCursor INTO @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml

			WHILE @@FETCH_STATUS = 0

			BEGIN

			-- Check whether this alert is already present. If so, dont insert again. 

			if exists(select 1 from NTNotificationRule

				where ( notificationName=@notificationName)

				and revision=1

			)

			begin

				FETCH NEXT FROM newAlertsCursor INTO @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml

				continue

			end

			INSERT NTNotificationRule (	categoryId,				alertTypeId,

										notificationName,		revision,

										lastModified,			description,

										notifType,				notifOwner,

										locale,					status,

										ruleState,				ruleState2,

										lastTimeTriggered,		lastTimeTriggered2,

										lastTimeChecked,		hasAttachments,

										hasAttachments2,		xmlEntityList,

										origCCId,				GUID)

			VALUES (					@categoryId,			@alertType				,

										@notificationName,		1,

										@nowTime,				@description,

										@notifType,				@adminID,			

0,					(@status|2048),			-- 0 DefaultLocale US-English

										@ruleState,				@ruleState,

										@emptyDateTime,			@emptyDateTime,

										@emptyDateTime,			0,

										0,						@xmlEntities,

										default,				newid() )	

			SET @thisAlertId = @@Identity 

			INSERT NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)

VALUES(80, 1, @thisAlertId, @reportOptions, 0, @persistTimeSeconds)		-- 'NT_CLIENT_JOB_NOT_RUN

            INSERT NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)

VALUES(81, 1, @thisAlertId, @reportOptions, 0, @persistTimeSeconds)		-- 'NT_CLIENT_JOB_NOT_RUN

            INSERT NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)

VALUES(82, 1, @thisAlertId, @reportOptions, 0, @persistTimeSeconds)		-- 'NT_CLIENT_JOB_NOT_RUN
		INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)		


			VALUES (@thisAlertId, 1, null, null, 0)
		INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)		


			VALUES (@thisAlertId, 2, null, null, 0)

	-- ADD DEFAULT (EMAIL) MESSAGE:			

										 --

			INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,

								SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,

								baseDir,userName,password, rssID, messageFormatType, formatStringHtml)

				VALUES		(@thisAlertId, 1, 1, @msgFmtText, N'', 

0, 0, 0, 0, 2,

							 '', '', '', '', 1, @msgFmtHtml)

	-- ADD DEFAULT USER (SHOULDN'T HAVE TO DO THIS, BUT REQ'D TO SUPPORT CURRENT ALERT GUI)

	--		INSERT NTnotificationUsers  (NTnotificationID, userId,    escalationLevel)

	--			VALUES (@thisAlertId, @adminID, 1)

			FETCH NEXT FROM newAlertsCursor INTO @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml

		END

	END TRY

	 BEGIN CATCH

		 set @errorCode = ERROR_NUMBER()

		 set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()

	 END CATCH

 		IF ( CURSOR_STATUS('global', 'newAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN

			CLOSE newAlertsCursor

		IF ( CURSOR_STATUS('global','newAlertsCursor') = -1     OR CURSOR_STATUS('local','newAlertsCursor') = -1 )

			DEALLOCATE newAlertsCursor	

	IF @errorCode = 0

		COMMIT TRAN

	ELSE 

		ROLLBACK TRAN

END

else

begin

	-- Update template for existing alerts to include token ALERT_TOKEN_USER_CLEAN_UP_DATA

	declare @guidForTemplateUpdate uniqueidentifier = '45DD5EA9-DD4C-43F6-B3F9-BA1113582378'

	DECLARE @globalParamAlertTemplateUpdateExec INT = 0

	SELECT @globalParamAlertTemplateUpdateExec = 1

	FROM

		GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

	WHERE

		gp.SqlScriptGUID = @guidForTemplateUpdate

	if (@globalParamAlertTemplateUpdateExec=0)

	begin

		BEGIN TRY

			BEGIN Tran
			INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guidForTemplateUpdate, 'DefaultAlertForEdgeDriveTemplateUpdate', 'Tblscript to create update template for default edge drive alert', @curUtcDateTime, 16, 0 , (16 + 2))

			DECLARE @htmldefaultTemplateUpdated nvarchar(max)

IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name='UseNewAlertTemplate' AND value=1)

				set @htmldefaultTemplateUpdated = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>User </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;USER NAME&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Quota Limit </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;QUOTA LIMIT&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Space consumed </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SPACE CONSUMED&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Object size </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;OBJECT SIZE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Job ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;JOB ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Operation Performed By</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;OPERATION PERFORMED BY USER&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Status</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;STATUS&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Comments</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMENT&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Condition Cleared</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CONDITION CLEARED Y/N&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>&lt;CLEANUP DATA TEXT&gt; </b></font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'

			ELSE

				set @htmldefaultTemplateUpdated = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table cellpadding="0" cellspacing="0" border="1" align="center" width="75%" style="border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-style: solid; border-top-color: #dedede; border-right-color: #dedede; border-bottom-color: #dedede; border-left-style: solid; border-right-style: solid; border-top-width: 0px; border-right-width: 0px"><tr><td><center><table cellpadding="0" border="0" id="contentTbl" width="100%" align="center" cellspacing="0"><tr style="background-color: #666666"><td valign="middle" align="left"><div style="margin-left: 10px; margin-bottom: 4px; margin-top: 4px"><font size="6" face="Helvetica,sans-serif" color="#EEEEEE">&lt;ALERT NAME&gt; </font></div></td></tr><tr><td colspan="1" valign="middle" align="left" bgcolor="#DCDEDE"><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>CommCell: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong></ul><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>Type: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong></ul><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>Detected Criteria: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;DETECTED CRITERIA&gt;</font></strong></ul><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>Detected Time: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;TIME&gt;</font></strong></ul></td></tr><tr><td width="100%" colspan="1" align="left"><ul><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">User: &lt;USER NAME&gt; </font></li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Quota Limit : &lt;QUOTA LIMIT&gt; </font></li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Space consumed : &lt;SPACE CONSUMED&gt; </font></li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Object size : &lt;OBJECT SIZE&gt; </font></li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Job ID: &lt;JOB ID&gt; </font></li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Comments: &lt;COMMENT&gt; </font></li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Condition Cleared: &lt;CONDITION CLEARED Y/N&gt; </font></li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">&lt;CLEANUP DATA TEXT&gt;</font></li></ul></td></tr><tr style="background-color: #666666"><td colspan="1" align="left">&nbsp;</td></tr></table></center></td></tr></table>'

			DECLARE @xmlEntitiesUpdated xml = '<CVGui_CommCellTreeNode><clients includeAll="0" /><clientGroups includeAll="0" /><libraries includeAll="0" /><mediaAgents includeAll="0" /><storagePolcies includeAll="0" /><trackingPolicies includeAll="0" /><trackingSchedules /><trackingJobs /><criterias includeAll="0" /><workflows includeAll="0" /><associations _type_="12" /><commcells includeAll="0" /></CVGui_CommCellTreeNode>'

			DECLARE @notificationNameForCheck nvarchar(max)='Edge drive quota alert'

			update NTMessageFormat 

			set formatStringHtml = @htmldefaultTemplateUpdated

			from NTMessageFormat inner join NTNotificationRule on 

			NTNotificationRule.id = NTMessageFormat.NTNotificationId

and NTNotificationRule.alertTypeId=70

and (NTNotificationRule.status&2048)>0

			and NTNotificationRule.revision=1

			and (NTNotificationRule.status&2)=0

			and notificationName=@notificationNameForCheck

			Update NTNotificationRule

			set xmlEntityList = @xmlEntitiesUpdated

where alertTypeId=70

and (NTNotificationRule.status&2048)>0

			and NTNotificationRule.revision=1

			and (NTNotificationRule.status&2)=0

			and notificationName=@notificationNameForCheck

		END TRY

		 BEGIN CATCH

			 set @errorCode = ERROR_NUMBER()

			 set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()

		 END CATCH

		IF @errorCode = 0

			COMMIT TRAN

		ELSE 

			ROLLBACK TRAN

	end

end

SET NOCOUNT OFF

GO

