

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDefaultAlertForDirtyVolumes.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]='@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/NTDefaultAlertForDirtyVolumes.script,v $ $Id: NTDefaultAlertForDirtyVolumes.script,v 1.1.4.8 2019/04/16 16:17:38 saggarwal Exp $';

-- PUT ANY #DEFINES HERE

-- ----------------------

-- Add simpana event viewer alert for Dirty volumes.

SET NOCOUNT ON

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTrackINg WHERE SqlScriptGUID = '3679CB6C-2F34-4395-9184-8B4A8CD16A92')    -- GUID NOT present

BEGIN

	DECLARE @allClientXmlEntities   AS nvarchar(MAX)= '<CVGui_CommCellTreeNode>

													  <associations _type_="2">

														<flags exclude="0" />

													  </associations>

													  <clientGroups includeAll="0" />

													  <clients includeAll="0" />

													  <commcells includeAll="0" />

													  <criterias includeAll="0" />

													  <libraries includeAll="0" />

													  <mediaAgents includeAll="0" />

													  <storagePolcies includeAll="0" />

													  <trackingJobs />

													  <trackingPolicies includeAll="0" />

													  <trackingSchedules />

													  <workflows includeAll="0" />

													</CVGui_CommCellTreeNode>'

	DECLARE @adminID                  AS integer    = ISNULL((Select top 1 ID from UMUSERS where (flags & 67) = 67), 1)

	DECLARE @masterGroupId            AS integer    = ISNULL((Select top 1 ID from UMGroups where name='master'),1)    --_US_ADMIN_GROUP__

	DECLARE @emptyDateTime            AS datetime   = '1900-01-01 00:00:00.000'

	DECLARE @localeId                 AS integer           = 1

	DECLARE @ruleState                AS integer           = 0

	DECLARE @reportOptions            AS integer           = 1           -- 'NT_REPORT_IMMEDIATE' 

	DECLARE @persistTimeSeconds		  AS integer          = 0

	DECLARE @SelCriteriaId            integer

	DECLARE @nowTime                  as integer    =  (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETUTCDATE()))

	DECLARE @notifType                AS integer    = 1                  -- !! WAS !! 'NT_LAPTOP_ALERTNOTIF' + EMAIL (TO FAKE OUT GUI, FOR NOW!)

	DECLARE @thisAlertId			  integer

	----  FOR CURSOR -----

	DECLARE @alertId                  INTEGER

	DECLARE @alertType                INTEGER

	DECLARE @notificationName		  NVARCHAR(128)              -- 'NT_MAX_NOTIFICATION_NAME_SIZE'

	DECLARE @description			  NVARCHAR(1024)             -- 'NT_MAX_ALERT_DESCRIPTION_SIZE'

	DECLARE @msgFmtText               NVARCHAR(max) 

	DECLARE @msgFmtHtml               NVARCHAR(max)

	DECLARE @cursorXmlEntities        nvarchar(MAX)

	DECLARE @alertsToAdd table (

				  alertId                    int primary key,

				  alertType                  int Not Null,

				  notificationName           nvarchar(128),

				  description                nvarchar(1024),

				  msgFmtText                 nvarchar(max),

				  msgFmtHtml                 nvarchar(max),             

				  xmlEntities                nvarchar(MAX)

	)

	DECLARE @criteriasToAdd table (

              alertId                           int ,

              criteriaId                        int ,

              criteriaParamType                 int,

              criteriaParamValue                int,

              criteriaParamUnit                 int

              primary key(alertId,criteriaId)

	)

	DECLARE @simpanaEventCriteria table (

				alertId         int ,

				criteriaxml     nvarchar(max)              

	)

	DECLARE @createdAlertsId   INT = 1

	DECLARE @htmldefaultTemplate nvarchar(max)

	DECLARE @textdefaultTemplate nvarchar(max)

	DECLARE  @errorCode             integer = 0

	DECLARE  @errorString           nvarchar(1024) = ''

IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name='UseNewAlertTemplate' AND value=1)

		SET @htmldefaultTemplate ='<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Event ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Monitoring Criteria</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;MONITORING CRITERIA STRING&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Severity</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT SEVERITY&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Job ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;JOB ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Event Date</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT DATE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Program</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;EVENT PROGRAM&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Client</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CLIENT DISPLAY NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Description</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DESCRIPTION&gt;</font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'

	ELSE

		SET @htmldefaultTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table cellpadding="0" cellspacing="0" border="1" align="center" width="75%" style="border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-style: solid; border-top-color: #dedede; border-right-color: #dedede; border-bottom-color: #dedede; border-left-style: solid; border-right-style: solid; border-top-width: 0px; border-right-width: 0px">

	 <tr>

	 <td>

	 <center>

	 <table cellpadding="0" border="0" id="contentTbl" width="100%" align="center" cellspacing="0">

	 <tr style="background-color: #666666">

	 <td valign="middle" align="left">

	 <div style="margin-left: 10px; margin-bottom: 4px; margin-top: 4px">

	 <font size="6" face="Helvetica,sans-serif" color="#EEEEEE">&lt;ALERT NAME&gt; </font>

	 </div>

	 </td>

	 </tr>

	 <tr>

	 <td colspan="1" valign="middle" align="left" bgcolor="#DCDEDE">

	 <ul style="margin-top: 4px; margin-bottom: 4px">

	 <font size="4" face="Helvetica,sans-serif"><strong>CommCell: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong>

	 </ul>

	 <ul style="margin-top: 4px; margin-bottom: 4px">

	 <font size="4" face="Helvetica,sans-serif"><strong>Type: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong>

	 </ul>

	 <ul style="margin-top: 4px; margin-bottom: 4px">

	 <font size="4" face="Helvetica,sans-serif"><strong>Detected Criteria: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;DETECTED CRITERIA&gt;</font></strong>

	 </ul>

	 <ul style="margin-top: 4px; margin-bottom: 4px">

	 <font size="4" face="Helvetica,sans-serif"><strong>Detected Time: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;TIME&gt;</font></strong>

	 </ul>

	 </td>

	 </tr>

	 <tr>

	 <td width="100%" colspan="1" align="left">

	 <ul>

	 <li style="margin-top: 4px; margin-bottom: 4px">

	 <font size="3" face="Helvetica,sans-serif" color="#000000">Event ID: &lt;EVENT ID&gt; </font>

	 </li>

	 <li style="margin-top: 4px; margin-bottom: 4px">

	 <font size="3" face="Helvetica,sans-serif" color="#000000">Monitoring Criteria: &lt;MONITORING CRITERIA STRING&gt; </font>

	 </li>

	 <li style="margin-top: 4px; margin-bottom: 4px">

	 <font size="3" face="Helvetica,sans-serif" color="#000000">Severity: &lt;EVENT SEVERITY&gt; </font>

	 </li>

	 <li style="margin-top: 4px; margin-bottom: 4px">

	 <font size="3" face="Helvetica,sans-serif" color="#000000">Job ID: &lt;JOB ID&gt; </font>

	 </li>

	 <li style="margin-top: 4px; margin-bottom: 4px">

	 <font size="3" face="Helvetica,sans-serif" color="#000000">Event Date: &lt;EVENT DATE&gt; </font>

	 </li>

	 <li style="margin-top: 4px; margin-bottom: 4px">

	 <font size="3" face="Helvetica,sans-serif" color="#000000">Program: &lt;EVENT PROGRAM&gt; </font>

	 </li>

	 <li style="margin-top: 4px; margin-bottom: 4px">

	 <font size="3" face="Helvetica,sans-serif" color="#000000">Client: &lt;CLIENT DISPLAY NAME&gt; </font>

	 </li>

	 <li style="margin-top: 4px; margin-bottom: 4px">

	 <font size="3" face="Helvetica,sans-serif" color="#000000">Description: &lt;DESCRIPTION&gt; </font>

	 </li>

	 <li style="margin-top: 4px; margin-bottom: 4px">

	 <font size="3" face="Helvetica,sans-serif" color="#000000">Owner Name: &lt;OWNER NAME&gt; </font>

	 </li>

	 <li style="margin-top: 4px; margin-bottom: 4px">

	 <font size="3" face="Helvetica,sans-serif" color="#000000">Owner Email: &lt;OWNER EMAIL&gt; </font>

	 </li>

	 </ul>

	 </td>

	 </tr>

	 <tr style="background-color: #666666">

	 <td colspan="1" align="left">

 

	 </td>

	 </tr>

	 </table>

	 </center>

	 </td>

	 </tr>

	 </table>'

	SET @textdefaultTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Event ID: <EVENT ID> MsgNewLine_MsgTab_ Monitoring Criteria: <MONITORING CRITERIA STRING> MsgNewLine_MsgTab_ Severity: <EVENT SEVERITY> MsgNewLine_MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Event Date: <EVENT DATE> MsgNewLine_MsgTab_ Program: <EVENT PROGRAM> MsgNewLine_MsgTab_ Client: <CLIENT DISPLAY NAME> MsgNewLine_MsgTab_ Description: <DESCRIPTION> MsgNewLine_MsgTab_'

	DECLARE @eventCriteriaXml nvarchar(max)

	SET @eventCriteriaXml = '<?xml version=''1.0'' encoding=''UTF-8''?><LogMonitoring_ConditionsList criteriaName="(Event Code equals to 17:88)" opBetweenConditions="0"><conditions matchWholeWord="0" isCaseSensitive="0" value2="" value1="17:88" isInclusive="0" isregex="1" operation="0"><column _type_="87" columnId="6" columnName="Event Code" /></conditions></LogMonitoring_ConditionsList>'

	BEGIN TRY

		BEGIN TRAN
		 INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('3679CB6C-2F34-4395-9184-8B4A8CD16A92', 'DefaultDirtyVolumeAlert', 'Create default Dirty Volume alerts', datediff(second, '01/01/1970', GetUTCdate()), 16, 0 , (16 + 2))
		 INSERT INTO @alertsToAdd


			SELECT    @createdAlertsId,

58 ,

					  'Dirty volumes on client ',

					  'Default alert for dirty volumes on client',

					  @textdefaultTemplate,

					  @htmldefaultTemplate,

					  @allClientXmlEntities
		INSERT INTO @criteriasToAdd


			SELECT @createdAlertsId,62,NULL,NULL,NULL
		INSERT INTO @simpanaEventCriteria


			 VALUES ( @createdAlertsId , @eventCriteriaXml )    

		IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN

			  CLOSE newDefaultAlertsCursor

		IF ( CURSOR_STATUS('global','newDefaultAlertsCursor') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursor') = -1 )

			  DEALLOCATE newDefaultAlertsCursor

		DECLARE newDefaultAlertsCursor CURSOR FOR

			  SELECT  alertId, alertType, notificationName, description, msgFmtText, msgFmtHtml , XmlEntities 

				 FROM @alertsToAdd

		OPEN newDefaultAlertsCursor

			  FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId,@alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml,@cursorXmlEntities 

			  WHILE @@FETCH_STATUS = 0

				  BEGIN

					  -- Check whether this alert is already present. If so, dont insert again. 

					  IF EXISTS(SELECT 1 FROM NTNotificationRule

							 WHERE notificationName=@notificationName)

					  BEGIN

							 FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId,@alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml,@cursorXmlEntities 

							 CONTINUE

					  END

					  INSERT NTNotificationRule (   categoryId,						    alertTypeId,

													notificationName,					revision,

													lastModified,						description,

													notifType,							notifOwner,

													locale,                             status,

													ruleState,							ruleState2,

													lastTimeTriggered,					lastTimeTriggered2,

													lastTimeChecked,					hasAttachments,

													hasAttachments2,					xmlEntityList,

													origCCId,							GUID)

VALUES (8,  @alertType,

													@notificationName,						1,

													@nowTime,								@description,

													@notifType,								@adminID,                     

0,										2048+1 ,

													@ruleState,								@ruleState,

													@emptyDateTime,							@emptyDateTime,

													@emptyDateTime,							0,

													0,										@cursorXmlEntities ,

													2,										newid() )

					SET @thisAlertId = @@Identity 

					INSERT NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)

						SELECT criteriaId,1,@thisAlertId,0,0,0

						FROM @criteriasToAdd

						WHERE alertId = @alertId

              SET @SelCriteriaId = @@identity
					INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)            


					  VALUES (@thisAlertId, 1, null, null, 0)
					INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)            


					  VALUES (@thisAlertId, 2, null, null, 0)

					-- ADD DEFAULT (EMAIL) MESSAGE:                 

																	  --

					INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,

											SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,

											baseDir,userName,password, rssID, messageFormatType, formatStringHtml)

						VALUES		        (@thisAlertId, 1, 1, @msgFmtText, N'', 

											 0, 0, 0, 0, 2,

											'', '', '', '', 1, @msgFmtHtml)                
					INSERT into NTnotificationUsers(NtnotificationId,userId,escalationLevel)


					   SELECT @thisAlertId,@adminID,1              

					-- Add an entry into for "Simpana Event Log Monitoring" AlertType if criteria is present

					DECLARE @templateId int

					-- Only one template for Simpana events. Hence retrieve the template id and store it here.

					SELECT @templateId = templateId

					FROM

					APP_Template WHERE templateForMonitoringType = 3
					INSERT into dbo.NTSimpanaEventCriteria(commcellId,notifRuleId,templateId,criteriaXML,severity)


						SELECT 2,@thisAlertId,@templateId,criteriaxml,0

						FROM @simpanaEventCriteria 

						WHERE alertid =  @alertId

					FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId,@alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml,@cursorXmlEntities     

			   END

	END TRY

	BEGIN CATCH

		SET @errorCode = ERROR_NUMBER()

		SET @errorString = 'Script [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

	END CATCH

	IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN

		  CLOSE newDefaultAlertsCursor

	IF ( CURSOR_STATUS('global','newDefaultAlertsCursor') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursor') = -1 )

		  DEALLOCATE newDefaultAlertsCursor 

	IF @errorCode=0

		COMMIT TRAN

	ELSE

		BEGIN

			IF LEN(@errorString) > 0

				Print @errorString

			ELSE

				Print 'SQL Error encountered while running the script hence rolling back Transaction'

			ROLLBACK TRAN

		END

END

ELSE

BEGIN

	DECLARE @disableAlertGuid uniqueidentifier='3679CB6C-2F34-4395-9184-8B4A8CD16A93'

	IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @disableAlertGuid)

	BEGIN

		DECLARE @errCode INT=0

		DECLARE @errString  nvarchar(1024) = ''

		BEGIN TRY

			BEGIN Tran

			UPDATE NTNotificationRule

SET status= status | 1

			WHERE notificationName='Dirty volumes on client'

AND (status & 2048) > 0
			INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@disableAlertGuid, 'DisableDirtyVolumeAlert', 'Disable dirty volume alert', datediff(second, '01/01/1970', GetUTCdate()), 16, 0 , (16 + 2))

		END TRY

		BEGIN CATCH

			SET @errCode = ERROR_NUMBER()

			SET @errString = 'Script [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

		END CATCH

		IF @errCode=0

			COMMIT TRAN

		ELSE

			BEGIN

				IF LEN(@errString) > 0

					Print @errString

				ELSE

					Print 'SQL Error encountered while running the script hence rolling back Transaction'

				ROLLBACK TRAN

			END

	END

END

SET NOCOUNT OFF

