

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDefaultAlertForDataAgingDisabled.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

--

--  +========================================================================+

--  |      

--  |       Copyright (c) 1998  CommVault Systems, Inc.                

--  |               All rights reserved.                                

--  |                                                                   

--  |                                                                

--  |     This is unpublished proprietary source code of CommVault  

--  |     Systems, Inc. The copyright notice above does not evidence 

--  |     any actual or intended publication of such source code. 

--  +========================================================================+

--  +========================================================================+

--  |   Script Name: NTDefaultAlertforDataAgingDisabled.script   

--  |   Description: Default rule and alert for alerting when data aging

--  |				is disabled in clietn and client group level

--  +========================================================================+

DECLARE @uniqueSQLScriptGUIDString VARCHAR(128) = 'D7D90C72-CA37-462A-A521-D8356B7C760F'

DECLARE @uniqueSQLScriptGUIDExists BIT = 0

SELECT @uniqueSQLScriptGUIDExists = 1

FROM GXUniqueSQLScriptExecTracking 

WHERE

    SqlScriptGUID = @uniqueSQLScriptGUIDString

IF @uniqueSQLScriptGUIDExists = 0

BEGIN

    DECLARE  @errorCode         INT         

    DECLARE  @errorString       VARCHAR(1024)   

	DECLARE @nowTime            INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

    DECLARE @xmlEntities        NVARCHAR(MAX)= '<CVGui_CommCellTreeNode>  <clients includeAll="0" />  <clientGroups includeAll="0" />  <libraries includeAll="0" />  <mediaAgents includeAll="0" />  <storagePolcies includeAll="0" />  <trackingPolicies includeAll="0" />  <trackingSchedules />  <trackingJobs />  <criterias includeAll="0" />  <workflows includeAll="0" />  <commcells includeAll="0" /></CVGui_CommCellTreeNode>'

DECLARE @adminID            INT = ISNULL((SELECT TOP 1 id from UMUsers where (flags & (0x001+0x002+0x040)) >0), 1)

    DECLARE @emptyDateTime      DATETIME = '1900-01-01 00:00:00.000'

    DECLARE @localeId           INT = 0

    DECLARE @ruleState          INT = 3                 -- Alert Severity

DECLARE @reportOptions      INT = 1

    DECLARE @persistTimeSeconds INT = 0

	DECLARE @delayTimeSeconds INT = 0

    DECLARE @createdAlertsId    INT = 1

DECLARE @notifType          INT = 1 + 131072

    DECLARE @queryId            INT	

DECLARE @alertType          INT = 65

    DECLARE @notificationName   NVARCHAR(128)  = 'Data Aging is disabled for last n days'         -- 'NT_MAX_NOTIFICATION_NAME_SIZE'

    DECLARE @description        NVARCHAR(1024)  = 'Alert when data aging is disabled for n days'       -- 'NT_MAX_ALERT_DESCRIPTION_SIZE'

    DECLARE @thisAlertId        INT

    DECLARE @criteriasToAdd table (

            criteriaId          INT,

            criteriaParamType   INT,

            criteriaParamValue  INT,

            criteriaParamUnit   INT

            PRIMARY KEY(criteriaId)

    )

    SET @errorCode  = 0

    SET @errorString = ''

    BEGIN TRY

        BEGIN TRAN

        BEGIN

            DECLARE @htmldefaultTemplate NVARCHAR(max)

            DECLARE @textdefaultTemplate NVARCHAR(max)

IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name='UseNewAlertTemplate' AND value=1)

				SET @htmldefaultTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border-top-color: #2f4e66; border-top-style: solid; border-top-width: 1px; border-right-color: #2f4e66; border-right-style: solid; border-right-width: 1px; border-bottom-color: #2f4e66; border-bottom-style: solid; border-bottom-width: 1px; border-left-color: #2f4e66; border-left-style: solid; border-left-width: 1px"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Alert Rule Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;QUERY NAME&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif">&lt;INPUT DATA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif">&lt;TABLE DATA&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Condition Cleared</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CONDITION CLEARED Y/N&gt;</font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At: &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'

			ELSE

				SET @htmldefaultTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellpadding="0" cellspacing="0" border="1" align="center" width="100%" style="border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-style: solid; border-top-color: #dedede; border-right-color: #dedede; border-bottom-color: #dedede; border-left-style: solid; border-right-style: solid; border-top-width: 0px; border-right-width: 0px"> <tr> <td> <center> <table cellpadding="0" border="0" id="contentTbl" width="100%" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td valign="middle" align="left"> <div style="margin-left: 10px; margin-bottom: 4px; margin-top: 4px"> <font size="6" face="Helvetica,sans-serif" color="#EEEEEE">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td colspan="1" valign="middle" align="left" bgcolor="#DCDEDE"> <ul style="margin-top: 4px; margin-bottom: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>CommCell: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-top: 4px; margin-bottom: 4px"> <font size="4" face="Helvetica,sans-serif"><strong>Type: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-top: 4px; margin-bottom: 4px"> <font size="3" face="Helvetica,sans-serif" color="#000000">User: &lt;USER NAME&gt;</font> </li> <li style="margin-top: 4px; margin-bottom: 4px"> <font size="3" face="Helvetica,sans-serif" color="#000000">Alert Rule Name : &lt;QUERY NAME&gt;</font> </li> <font size="3" face="Helvetica,sans-serif" color="#000000">&lt;INPUT DATA&gt;&lt;TABLE DATA&gt;</font> <li style="margin-top: 4px; margin-bottom: 4px"> <font size="3" face="Helvetica,sans-serif" color="#000000">Condition Cleared: : &lt;CONDITION CLEARED Y/N&gt;</font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left"> </td> </tr> </table> </center> </td> </tr> </table> </div>'

			SET @textdefaultTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME><SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_ MsgNewLine_ MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Alert Rule Name : <QUERY NAME> MsgNewLine_MsgTab_ <INPUT DATA> MsgNewLine_MsgTab_ Clone JobID : <INDEX 0> MsgNewLine_MsgTab_ Source Client : <INDEX 1> MsgNewLine_MsgTab_ Source Instance : <INDEX 2> MsgNewLine_MsgTab_ Target Client : <INDEX 3> MsgNewLine_MsgTab_ Target Instance : <INDEX 4> MsgNewLine_MsgTab_ Database Type : <INDEX 5> MsgNewLine_MsgTab_ Creation Time : <INDEX 7> MsgNewLine_MsgTab_ Expiration Time : <INDEX 8> MsgNewLine_MsgTab_ Condition Cleared: : <CONDITION CLEARED Y/N>'    
            INSERT INTO @criteriasToAdd


SELECT 75, NULL, NULL, NULL

			IF NOT EXISTS (SELECT 1 FROM NTNotificationRule  WHERE notificationName=@notificationName AND revision=1 )

            BEGIN
                INSERT INTO NTNotificationRule (categoryId,             alertTypeId,


                                                notificationName,       revision,

                                                lastModified,           description,

                                                notifType,              notifOwner,

                                                locale,                 status,

                                                ruleState,              ruleState2,

                                                lastTimeTriggered,      lastTimeTriggered2,

                                                lastTimeChecked,        hasAttachments,

                                                hasAttachments2,        xmlEntityList,

                                                origCCId,               GUID            )

                SELECT                          categoryID,             @alertType,

                                                @notificationName,      1,

                                                @nowTime,               @description,

                                                @notifType,             @adminID,

@localeId,              2048 +  1 ,

                                                @ruleState,             @ruleState,

                                                @emptyDateTime,         @emptyDateTime,

                                                @emptyDateTime,         0,

                                                0,                      @xmlEntities ,

                                                2,                      newid()

                FROM NTAlertType WHERE id = @alertType

                SET @thisAlertId = @@Identity
                INSERT INTO NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)


                SELECT criteriaId, 1, @thisAlertId, @reportOptions , @delayTimeseconds, @persistTimeSeconds

                FROM @criteriasToAdd

                IF EXISTS (SELECT 1 FROM @criteriasToAdd WHERE criteriaParamType IS NOT NULL AND criteriaParamValue IS NOT NULL AND criteriaParamUnit IS NOT NULL)

                BEGIN
                    INSERT INTO NTSelCriteriaParams (selCriteriaid, paramIndex, type, value, unit, occurrences)


                    SELECT id, 0, criteriaParamType, criteriaParamValue, criteriaParamUnit, 0

                    FROM NTSelcriteria , @criteriasToAdd newCriterias

                    WHERE NTSelcriteria.ruleid = @thisAlertId

                        AND newCriterias.criteriaParamType IS NOT NULL 

                        AND newCriterias.criteriaParamValue IS NOT NULL AND newCriterias.criteriaParamUnit IS NOT NULL

                END
                INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)


                    VALUES (@thisAlertId, 1, null, null, 0)
                INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)


                    VALUES (@thisAlertId, 2, null, null, 0)

                -- :ADD DEFAULT MESSAGES:--
                INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


                                    SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

                                    messageFormatType, formatStringHtml)

VALUES      (@thisAlertId, 1, 1, @textdefaultTemplate, N'',

                                    0, 0, 0, 0, 0,

                                    1, @htmldefaultTemplate)            
                INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


                                    SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

                                    messageFormatType, formatStringHtml)

VALUES      (@thisAlertId,   131072, 1, @textdefaultTemplate, N'',

                                    0, 0, 0, 0, 0,

                                    0, @textdefaultTemplate)
                INSERT INTO NTnotificationUsers(NtnotificationId,userId,escalationLevel)


                SELECT @thisAlertId,@adminID,1

                IF NOT EXISTS ( SELECT 1 FROM NTQueryList WHERE queryName = 'Data aging is disabled for n days')

                BEGIN

                    DECLARE @GUID VARCHAR(40)

                    SET @GUID = NEWID()
                    INSERT INTO NTQueryList (queryMessageId, defaultfrequency, status, queryCreator, visibility, taskId, queryString, xmlInfo, queryName, queryDescription, queryCriteriaName, GUID, commcellAssociation, isOverwriteAssociationAtAlertAllowed)


                    VALUES

                    (

                    0 ,             -- queryMessageId

                    3600,           --default frequency

                    0,              -- status 

                    @adminID,       -- Query Creator

                    1,              -- Visibility

                    0,              -- Task Id 

                    -----  Query ---------- 

                    ' SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

					--declare @ndays int = 0

					--declare @clientList table(entityId int , entityName varchar(512))

					--declare @clientGroupList table(entityId int , entityName varchar(512))

					declare @currentTimestamp int = dbo.getunixtime(getutcdate())

					SELECT   description, entityId, entityType FROM(

					select ''Data aging has been disabled in client group '' + CG.entityName + '' for ''+cast((@currentTimestamp-M.timeServer)/(60*60*24) as varchar) +'' days'' description,CG.entityId, 28 as entityType,  M.timeServer   from evmsg M

					inner join evparam P on M.id=P.evmsgid and messageId=318769248 

					inner join @clientGroupList CG on CG.entityName = P.data

					where @currentTimestamp-M.timeServer>@ndays*24*60*60

					union 

					select ''Data aging has been disabled in client '' + CG.entityName + '' for ''+cast((@currentTimestamp-M.timeServer)/(60*60*24) as varchar) +'' days '' description,CG.entityId, 3 as entityType, M.timeServer from evmsg M

					inner join evparam P on M.id=P.evmsgid and messageId=318769246 

					inner join @clientList CG on CG.entityName = P.data

					where @currentTimestamp-M.timeServer>@ndays*24*60*60

					union 

					select ''Data aging has been disabled in client '' + C.name + '' for ''+cast((@currentTimestamp-M.timeServer)/(60*60*24) as varchar) +'' days '' description, C.id as entityId, 3 as entityType,M.timeServer  from evmsg M

					inner join evparam P on M.id=P.evmsgid and messageId=318769246 

					inner join App_Client C on C.Name = P.data

					inner join APP_ClientGroupAssoc CGA ON CGA.clientId = C.Id

					inner join @clientGroupList CG ON CG.entityId =  CGA.clientGroupId

					where @currentTimestamp-M.timeServer>@ndays*24*60*60

					)A order BY A.timeServer desc',

                    ------------------------- Query ends ------------------------------------------------                   

                    ---- xmlInfo ----

                    '<?xml version="1.0" encoding="UTF-16" standalone="no" ?><App_AdditionalQueryDetails alertCriteria="0" alertType="0" defaultHtmlTemplate="" defaultTextTemplate="" isHealthParam="0" querySeverity="3"><externalQueryEntity _type_="125"/><scriptDescription description="" guid="871D2061-6F31-426B-8161-57984F792850" reportName="Data aging is disabled for n days" revision="$Revision: 1.1.2.1 $ M&lt;1568643357397>"/></App_AdditionalQueryDetails>',

                    'Data aging is disabled for n days',  -- queryName

                    'Default alert rule for Data aging is disabled for n days.',     --queryDescription

                    '',                     -- queryCriteriaName

                    @GUID,                  -- GUID

                    ---- commcellAssociation ----

                    '<App_Associations>  <entity _type_="124" commCellId="2" /></App_Associations>',

                    0                       -- isOverwriteAssociationAtAlertAllowed

                    )   

                END

                SELECT @queryId = queryId FROM NTQueryList  

                WHERE queryName  = 'Data aging is disabled for n days'

                IF NOT EXISTS (SELECT 1 FROM NTQueryColumnList WHERE QueryId = @queryId)

                BEGIN
                    INSERT INTO NTQueryColumnList VALUES


                        (@queryId, 0, 1, 1, 'description', 'Description', 0, '2,3,0,1', 0, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

                        (@queryId, 0, 0, 0, 'ndays', 'Days', 0, '', 1, '<App_XMLSchema attribute="0" className="java.lang.Integer" controlHidden="0" controlType="0" defaultValue="1" displayName="Days" documentation="" hidden="0" inputName="ndays" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" name="ndays" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"><defaultValues val="1"/></App_XMLSchema>'),

                        (@queryId, 1, 0, 0, 'entityId', 'entityId', 1, '0,1,4,5,6,7', 0, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>'),

						(@queryId, 1, 0, 0, 'clientGroupList', 'Client groups', 0, '', 1, '<App_XMLSchema attribute="0" className="commvault.msgs.CvEntities.ClientGroupEntity" controlHidden="0" controlType="2" defaultValue="&lt;All>" displayName="Client Groups" documentation="" hidden="0" inputName="clientGroupList" inputType="commvault.msgs.CvEntities.ClientGroupEntity" listType="1" maximumValue="" minimumValue="" name="clientGroupList" readOnly="0" required="0" searchable="0" type="{commvault.msgs.CvEntities}ClientGroupEntity"><defaultValues val="&lt;All>"/></App_XMLSchema>'),

						(@queryId, 2, 0, 0, 'entityType', 'entityType', 1, '0,1,4,5,6,7', 0, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>'),

						(@queryId, 2, 0, 0, 'clientList', 'Clients', 0, '', 1, '<App_XMLSchema attribute="0" className="commvault.msgs.CvEntities.ClientEntity" controlHidden="0" controlType="2" defaultValue="&lt;All>" displayName="Clients" documentation="" hidden="0" inputName="clientList" inputType="commvault.msgs.CvEntities.ClientEntity" listType="1" maximumValue="" minimumValue="" name="clientList" readOnly="0" required="0" searchable="0" type="{commvault.msgs.CvEntities}ClientEntity"><defaultValues val="&lt;All>"/></App_XMLSchema>')

                END
                INSERT INTO NTNotificationQueryMapping 


                VALUES(

                    @queryId, @thisAlertId, @emptyDateTime, @emptyDateTime,

                    0, 0,

                    '',

                    '<CVGui_QueryAdditionalInfo><queryParameters><queryParameters isList="0" javaType="" listColDataType="" paramName="ndays" sqlDataType="" value="&lt;ndays>1&lt;/ndays>"/><queryParameters isList="0" javaType="" listColDataType="" paramName="clientGroupList" sqlDataType="" value="&lt;clientGroupList>&lt;isAllEntitiesSelected>true&lt;/isAllEntitiesSelected>&lt;/clientGroupList>"/><queryParameters isList="0" javaType="" listColDataType="" paramName="clientList" sqlDataType="" value="&lt;clientList>&lt;isAllEntitiesSelected>true&lt;/isAllEntitiesSelected>&lt;/clientList>"/></queryParameters><externalQueryInfo _type_="125"/></CVGui_QueryAdditionalInfo>',

                    '',

                    'Data aging is disabled for n days'

                )      
				INSERT INTO GXUniqueSQLScriptExecTracking


				VALUES(@uniqueSQLScriptGUIDString, 'Data aging disabled alert', 'Data aging disabled alert', @nowTime, 16, 0, 18)

            END

        END  

    END TRY

    BEGIN CATCH

        SET @errorCode = ERROR_NUMBER()

        SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

    END CATCH

    IF @errorCode = 0

        COMMIT TRAN

    ELSE

    BEGIN

        IF LEN(@errorString) > 0

            Print @errorString

        ELSE

            Print 'SQL Error encountered while running the script hence rolling back Transaction'

        ROLLBACK TRAN

    END

END
