

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTDBCloneExpirationAlert.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

--

--  +========================================================================+

--  |      

--	|		Copyright (c) 1998  CommVault Systems, Inc.                

--  |               All rights reserved.                                

--  |                                                                   

--  |                                                                

--  |     This is unpublished proprietary source code of CommVault  

--  |     Systems, Inc. The copyright notice above does not evidence 

--  |     any actual or intended publication of such source code. 

--  +========================================================================+

--  +========================================================================+

--  |   Script Name: NTDBCloneExpirationAlert.script   

--	|	Description: Default rule and alert for the expiring Database clones.	               

--  |				 Custom alert rule will run once in every 24 hours

--  |                and sends email with info severity to the Clone creation user. 

--	|				 By default clones expiring in the next 3 days are

--  |                considered for alert.

--	|	Author:		 stelagamsetti

--  +========================================================================+

DECLARE @uniqueSQLScriptGUIDString VARCHAR(128) = 'D6D90C71-CA37-462A-A521-D8356B7C760F'

DECLARE @uniqueSQLScriptGUIDExists BIT = 0

SELECT @uniqueSQLScriptGUIDExists = 1

FROM GXUniqueSQLScriptExecTracking 

WHERE

	SqlScriptGUID = @uniqueSQLScriptGUIDString

IF @uniqueSQLScriptGUIDExists = 0

BEGIN

	DECLARE  @errorCode         INT         

	DECLARE  @errorString       VARCHAR(1024)   

	DECLARE @nowTime            INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

	DECLARE @taskId             INT

	DECLARE @xmlEntities        NVARCHAR(MAX)= '<CVGui_CommCellTreeNode>

		<associations _type_="124" commCellId="2" />

		<clientGroups includeAll="0" />

		<clients includeAll="0" />

		<commcells includeAll="0" />

		<criterias includeAll="0" />

		<libraries includeAll="0" />

		<mediaAgents includeAll="0" />

		<storagePolcies includeAll="0" />

		<trackingJobs />

		<trackingPolicies includeAll="0" />

		<trackingSchedules />

		<workflows includeAll="0" />

	</CVGui_CommCellTreeNode>'

	DECLARE @adminID            INT = ISNULL((SELECT TOP 1 id from UMUsers where (flags & 67) = 67), 1)

	DECLARE @emptyDateTime      DATETIME = '1900-01-01 00:00:00.000'

	DECLARE @localeId           INT = 0

	DECLARE @ruleState          INT = 3                 -- Alert Severity

	DECLARE @reportOptions      INT = 1025                 -- 'NT_REPORT_IMMEDIATE' + 'NT_REPORT_CURRENT_RESULTS'

	DECLARE @persistTimeSeconds INT = 0

	DECLARE @createdAlertsId    INT = 1

	DECLARE @notifType          INT = 131073            -- 'NT_EMAIL_ALERTNOTIF' + 'NT_ALERTNOTIF_FOR_CI'

	DECLARE @queryId            INT

	----  FOR CURSOR -----

	DECLARE @alertId            INT

	DECLARE @alertType          INT

	DECLARE @notificationName   NVARCHAR(128)           -- 'NT_MAX_NOTIFICATION_NAME_SIZE'

	DECLARE @description        NVARCHAR(1024)          -- 'NT_MAX_ALERT_DESCRIPTION_SIZE'

	DECLARE @msgFmtText         NVARCHAR(max)

	DECLARE @msgFmtHtml         NVARCHAR(max)

	DECLARE @cursorXmlEntities  NVARCHAR(MAX)

	--

	--

	DECLARE @alertsToAdd table (

			alertId             INT PRIMARY KEY,

			alertType           INT NOT NULL,

			notificationName    NVARCHAR(128),

			description         NVARCHAR(1024),

			msgFmtText          NVARCHAR(MAX),

			msgFmtHtml          NVARCHAR(MAX),

			xmlEntities         NVARCHAR(MAX)

	)

	DECLARE @criteriasToAdd table (

			alertId             INT,

			criteriaId          INT,

			criteriaParamType   INT,

			criteriaParamValue  INT,

			criteriaParamUnit   INT

			PRIMARY KEY(alertId,criteriaId)

	)

	----------------------

	DECLARE @thisAlertId        INT

	DECLARE @existingAlertId    INT

	DECLARE @existingQueryId    INT

	SET @errorCode  = 0

	SET @errorString = ''

	BEGIN TRY

		BEGIN TRAN

		BEGIN

			DECLARE @htmldefaultTemplateForCloneExpiryAlert NVARCHAR(max)

			DECLARE @textdefaultTemplateForCloneExpiryAlert NVARCHAR(max)

			SET @htmldefaultTemplateForCloneExpiryAlert = '

					<SUBJECT BEGIN> Alert: <ALERT NAME><SUBJECT END><div id="contentTbl-table-scroll">

					<table cellspacing="0" cellpadding="0" width="100%" style="border-top-color: #2f4e66; border-top-style: solid; border-top-width: 1px; border-right-color: #2f4e66; border-right-style: solid; border-right-width: 1px; border-bottom-color: #2f4e66; border-bottom-style: solid; border-bottom-width: 1px; border-left-color: #2f4e66; border-left-style: solid; border-left-width: 1px">

					<tr>

					<td>

					<center>

					<table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0">

					<tr style="background-color: #2f4e66">

					<td valign="middle" align="left" colspan="3">

					<div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px">

					<font color="#FFFFFF" size="5" face="sans-serif"><b>Your database clone &lt;INDEX 3&gt;/&lt;INDEX 4&gt; is going to expire &lt;INDEX 11&gt;.</b></font>

					</div>

					</td>

					</tr>

					<tr>

					<td colspan="3" style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px">

					<font size="3" color="#444444" face="sans-serif">&lt;TABLE DATA&gt;</font>

					</td>

					</tr>

					<tr style="background-color: #2f4e66">

					<td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px">

					<font size="3" face="sans-serif" color="#ffffff">Generated At: &lt;TIME&gt; </font>

					</td>

					</tr>

					</table>

					</center>

					</td>

					</tr>

					</table>

					</div>'

			SET @textdefaultTemplateForCloneExpiryAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME><SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_ MsgNewLine_ MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Alert Rule Name : <QUERY NAME> MsgNewLine_MsgTab_ <INPUT DATA> MsgNewLine_MsgTab_ Clone JobID : <INDEX 0> MsgNewLine_MsgTab_ Source Client : <INDEX 1> MsgNewLine_MsgTab_ Source Instance : <INDEX 2> MsgNewLine_MsgTab_ Target Client : <INDEX 3> MsgNewLine_MsgTab_ Target Instance : <INDEX 4> MsgNewLine_MsgTab_ Database Type : <INDEX 5> MsgNewLine_MsgTab_ Creation Time : <INDEX 7> MsgNewLine_MsgTab_ Expiration Time : <INDEX 8> MsgNewLine_MsgTab_ Condition Cleared: : <CONDITION CLEARED Y/N>'
			INSERT INTO @alertsToAdd VALUES(


					@createdAlertsId,

					65,     -- 'NT_ALERTTYPE_CUSTOM_QUERY'

					'Clone expiration alert',

					'Default alert for Database clones expiring soon',

					@textdefaultTemplateForCloneExpiryAlert,

					@htmldefaultTemplateForCloneExpiryAlert,

					@xmlEntities

			)
			INSERT INTO @criteriasToAdd


			SELECT @createdAlertsId, 75 /* NT_GENERIC_QUERY (Custom Query)*/, NULL, NULL, NULL

			IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN

				CLOSE newDefaultAlertsCursor

			IF ( CURSOR_STATUS('global','newDefaultAlertsCursor') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursor') = -1 )

				DEALLOCATE newDefaultAlertsCursor

			DECLARE newDefaultAlertsCursor CURSOR FOR

				SELECT  alertId, alertType, notificationName, description, msgFmtText, msgFmtHtml, xmlEntities

					FROM @alertsToAdd

			OPEN newDefaultAlertsCursor

			FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId, @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml, @cursorXmlEntities

			WHILE @@FETCH_STATUS = 0

			BEGIN

				-- Check whether this alert is already present. If so, dont insert again.

				IF EXISTS (SELECT 1 FROM NTNotificationRule

					WHERE notificationName=@notificationName AND revision=1

				)

				BEGIN

					FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId, @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml, @cursorXmlEntities

					CONTINUE

				END
				INSERT INTO NTNotificationRule (categoryId,             alertTypeId,


												notificationName,       revision,

												lastModified,           description,

												notifType,              notifOwner,

												locale,                 status,

												ruleState,              ruleState2,

												lastTimeTriggered,      lastTimeTriggered2,

												lastTimeChecked,        hasAttachments,

												hasAttachments2,        xmlEntityList,

												origCCId,               GUID            )

				SELECT                          categoryID,                     @alertType,

												@notificationName,      1,

												@nowTime,               @description,

												@notifType,             @adminID,

												@localeId,              (2064),                                 

												-- 2048 for specifying the alert is system generated. + 16 for individual notification

												@ruleState,             @ruleState,

												@emptyDateTime,         @emptyDateTime,

												@emptyDateTime,         0,

												0,                      @cursorXmlEntities ,

												2,                      newid()

				FROM NTAlertType WHERE id = @alertType

				SET @thisAlertId = @@Identity
				INSERT INTO NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)


				SELECT criteriaId, 1, @thisAlertId, @reportOptions , 0, @persistTimeSeconds

				FROM @criteriasToAdd

				WHERE alertId = @alertId

				IF EXISTS (SELECT 1 FROM @criteriasToAdd WHERE alertId = @alertId AND criteriaParamType IS NOT NULL AND

					criteriaParamValue IS NOT NULL AND criteriaParamUnit IS NOT NULL)

				BEGIN
					INSERT INTO NTSelCriteriaParams (selCriteriaid, paramIndex, type, value, unit, occurrences)


					SELECT id, 0, criteriaParamType, criteriaParamValue, criteriaParamUnit, 0

					FROM NTSelcriteria , @criteriasToAdd newCriterias

					WHERE NTSelcriteria.ruleid = @thisAlertId

						AND newCriterias.alertId = @alertId

						AND newCriterias.criteriaParamType IS NOT NULL 

						AND newCriterias.criteriaParamValue IS NOT NULL AND newCriterias.criteriaParamUnit IS NOT NULL

				END
				INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)


					VALUES (@thisAlertId, 1, null, null, 0)
				INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)


					VALUES (@thisAlertId, 2, null, null, 0)

				-- :ADD DEFAULT MESSAGES:--
				INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


									SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

									messageFormatType, formatStringHtml)

					VALUES      (@thisAlertId, 1, 1, @msgFmtText, N'',

									0, 0, 0, 0, 0,

									1, @msgFmtHtml)            
				INSERT INTO NTmessageFormat (NTnotificationID, messageType, escalationLevel, formatString, formattedMessage,


									SubjFieldStart, SubjFieldLen, MsgBodyStart, MsgBodyLen, mfOptions,

									messageFormatType, formatStringHtml)

					VALUES      (@thisAlertId, 131072, 1, @msgFmtText, N'',

									0, 0, 0, 0, 0,

									0, N'')
				INSERT INTO NTnotificationUsers(NtnotificationId,userId,escalationLevel)


				SELECT @thisAlertId,@adminID,1

				FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId, @alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml, @cursorXmlEntities

				IF NOT EXISTS ( SELECT 1 FROM NTQueryList WHERE queryName = 'Expiring clones')

				BEGIN

					Print  'Creating alert Rule " Expiring clones" since its not present  in the machine '

					DECLARE @GUID VARCHAR(40)

					SET @GUID = NEWID()
					INSERT INTO NTQueryList (queryMessageId, defaultfrequency, status, queryCreator, visibility, taskId, queryString, xmlInfo, queryName, queryDescription, queryCriteriaName, GUID, commcellAssociation, isOverwriteAssociationAtAlertAllowed)


					VALUES

					(

					0 ,				-- queryMessageId

					86400,			--default frequency

					0,				-- status 

					@adminID,		-- Query Creator

					1,				-- Visibility

					0,				-- Task Id 

					-----  Query ---------- 

					'	DECLARE @timeNow INT = dbo.GetUnixTime(GETUTCDATE())

						SELECT	DISTINCT

								TC.OpJobId AS ''CloneJobID'',

								C1.displayName AS ''SourceClient'',

								I1.name AS ''SourceInstance'',

								C2.displayName AS ''TargetClient'',

								ISNULL(TC.TargetEntityName, '''') AS ''TargetInstance'',

								IDA.displayName AS ''Agent'',

								TC.ParentJobId AS ''SourceBackupJob'',

								CONVERT(varchar, dbo.UTCToCellLocalTime(dbo.GetDateTime(TC.CreationTime), 2), 0) AS ''CreationTime'',

								CONVERT(varchar, dbo.UTCToCellLocalTime(dbo.GetDateTime(MV.ExpireTime), 2), 0) AS ''ExpirationTime'',

								CASE WHEN ISNULL(U.name, '''') = '''' THEN U.login ELSE U.name END AS ''Creator'',

								U.email AS ''email'',

								CASE WHEN (MV.ExpireTime - @timeNow) / (24 * 60 * 60) < 1 THEN ''soon''

									WHEN (MV.ExpireTime - @timeNow) / (24 * 60 * 60) = 1 THEN ''in '' + CAST((MV.ExpireTime - @timeNow) / (24 * 60 * 60) AS VARCHAR(16)) + '' day'' 

									ELSE ''in '' + CAST((MV.ExpireTime - @timeNow) / (24 * 60 * 60) AS VARCHAR(16)) + '' days'' END AS ''ExpireDays''

						FROM	SMTestCloneDetails TC

							LEFT OUTER JOIN SMMountVolume MV

								ON TC.OpJobId = MV.MountJobId

							INNER JOIN APP_Application A

								ON A.instance = TC.SourceInstanceId

							INNER JOIN APP_iDAType IDA

								ON A.appTypeId = IDA.type

							INNER JOIN UMUsers U

								ON TC.UserId = U.id

							INNER JOIN APP_Client C1

								ON TC.SourceClientId = C1.id

							INNER JOIN APP_Client C2

								ON TC.TargetClientId = C2.id

							INNER JOIN APP_InstanceName I1

								ON TC.SourceInstanceId = I1.id

						WHERE	MV.ExpireTime > @timeNow

							AND	MV.ExpireTime < (@timeNow + (@ExpireDays * 24 * 60 * 60))

							AND ISNULL(U.email, '''') <> ''''

						ORDER BY C1.displayName, I1.name',

					------------------------- Query ends ------------------------------------------------					

					---- xmlInfo ----

					'<?xml version="1.0" encoding="UTF-16" standalone="no" ?><App_AdditionalQueryDetails alertCriteria="0" alertType="0" defaultHtmlTemplate="" defaultTextTemplate="" isHealthParam="0" querySeverity="3"><externalQueryEntity _type_="125"/><scriptDescription description="" guid="B14BA277-979A-46C7-A362-1A0E1BD883C6" reportName="Expiring clones" revision="$Revision: 1.1.2.2 $ M&lt;1546288739736>"/></App_AdditionalQueryDetails>',

					'Expiring clones',  -- queryName

					'Default alert for Database clones expiring soon.',     --queryDescription

					'',                     -- queryCriteriaName

					@GUID,                  -- GUID

					---- commcellAssociation ----

					'<App_Associations><entity _type_="124" commCellId="2" commCellName="" /></App_Associations>',

					1                       -- isOverwriteAssociationAtAlertAllowed

					)   

				END

				SELECT @queryId = queryId , @taskId = taskId FROM NTQueryList  

				WHERE queryName  = 'Expiring clones'

				IF NOT EXISTS (SELECT 1 FROM NTQueryColumnList WHERE QueryId = @queryId)

				BEGIN
					INSERT INTO NTQueryColumnList VALUES


						(@queryId, 0, 0, 0, 'ExpireDays', 'Expire days', 0, '', 1, '<App_XMLSchema attribute="0" className="java.lang.Integer" controlHidden="0" controlType="10" defaultValue="3" displayName="Expire days" documentation="Number of days the clone is going to expire" hidden="0" inputName="ExpireDays" inputType="java.lang.Integer" listType="0" maximumValue="99" minimumValue="1" name="ExpireDays" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"><defaultValues val="3"/></App_XMLSchema>'),

						(@queryId, 0, 0, 0, 'CloneJobID', 'Clone JobID', 0, '0,1,4,5,6,7', 0, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

						(@queryId, 1, 0, 1, 'SourceClient', 'Source Client', 0, '2,3,0,1', 0, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

						(@queryId, 2, 0, 1, 'SourceInstance', 'Source Instance', 0, '2,3,0,1', 0, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

						(@queryId, 3, 0, 1, 'TargetClient', 'Target Client', 0, '2,3,0,1', 0, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

						(@queryId, 4, 0, 1, 'TargetInstance', 'Target Instance', 0, '2,3,0,1', 0, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

						(@queryId, 5, 0, 1, 'Agent', 'Database Type', 0, '2,3,0,1', 0, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

						(@queryId, 6, 0, 0, 'SourceBackupJob', 'Source Backup Job', 0, '0,1,4,5,6,7', 0, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>'),

						(@queryId, 7, 0, 2, 'CreationTime', 'Creation Time', 0, '0,1,4,5,6,7,8', 0, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

						(@queryId, 8, 0, 2, 'ExpirationTime', 'Expiration Time', 0, '0,1,4,5,6,7,8', 0, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'),

						(@queryId, 9, 0, 1, 'Creator', 'Creator', 0, '2,3,0,1', 0, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>'),

						(@queryId, 10, 0, 1, 'email', 'email', 0, '2,3,0,1', 0, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="1"/>'),

						(@queryId, 11, 0, 1, 'ExpireDays', 'ExpireDays', 0, '2,3,0,1', 0, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>')             

				END
				INSERT INTO NTNotificationQueryMapping 


				VALUES(

					@queryId, @thisAlertId, @emptyDateTime, @emptyDateTime,

					0, @taskId,

					'',

					'<CVGui_QueryAdditionalInfo><queryParameters><queryParameters isList="0" javaType="" listColDataType="" paramName="ExpireDays" sqlDataType="" value="&lt;ExpireDays>3&lt;/ExpireDays>"/></queryParameters><externalQueryInfo _type_="125"/></CVGui_QueryAdditionalInfo>',

					'',

					'Expiring clones'

				)       

			END

		END  

	END TRY

	BEGIN CATCH

		SET @errorCode = ERROR_NUMBER()

		SET @errorString = 'Procedure [' + ISNULL(ERROR_PROCEDURE(), '') + '] Error Line [' + Convert(varchar(5), ISNULL(ERROR_LINE(), '')) + ']. ' + ISNULL(ERROR_MESSAGE(), '')

	END CATCH

	IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN

		CLOSE newDefaultAlertsCursor

	IF ( CURSOR_STATUS('global','newDefaultAlertsCursor') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursor') = -1 )

		DEALLOCATE newDefaultAlertsCursor

	IF @errorCode = 0

		COMMIT TRAN

	ELSE

	BEGIN

		IF LEN(@errorString) > 0

			Print @errorString

		ELSE

			Print 'SQL Error encountered while running the script hence rolling back Transaction'

		ROLLBACK TRAN

	END
	INSERT INTO GXUniqueSQLScriptExecTracking


		VALUES(@uniqueSQLScriptGUIDString, 'ExpiringClonesAlert', 'Expiring database clones alert', @nowTime, 16, 0, 18)

END

