

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTCreateDefaultRuleForOfflineClients.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/NTCreateDefaultRuleForOfflineClients.script,v $ $Id: NTCreateDefaultRuleForOfflineClients.script,v 1.1.2.5 2020/12/11 21:43:09 mnatarajan Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

	DECLARE @guid uniqueidentifier = '1279132B-B87F-44DB-A6E6-3334AEED7B9E'

	DECLARE @curUtcDateTime BIGINT = DATEDIFF(SECOND, '01/01/1970', GetUTCdate())       

	DECLARE @queryName nvarchar(max) = 'Notify offline clients'

	DECLARE @globalParamPlanUpdateExec INT = 0

	SELECT @globalParamPlanUpdateExec = 1

	FROM

		GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

	WHERE

		gp.SqlScriptGUID = @guid

	DECLARE @sqlQuery NVARCHAR(MAX) = 'SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

--DECLARE @offlineThresholdTime INT = 10

DECLARE @nowTime INT =dbo.getunixTime(getutcdate())

--DECLARE @ClientGroupList TABLE(EntityId int, entityname nvarchar(max))

--DECLARE @ClientList TABLE(EntityId int, entityname nvarchar(max))

IF object_id(''tempdb.dbo.#ClientListAggregated'') IS NOT NULL drop table #ClientListAggregated

CREATE TABLE #ClientListAggregated (clientId int, physicalClientId INT,  PRIMARY KEY (clientId,physicalClientId) )

-- For clients we need to identify their proxies also

IF object_id(''tempdb.dbo.#tmpClient'') IS NOT NULL drop table #tmpClient

create table #tmpClient

    (   ClientId        integer,

        subclientId     integer,

        INSTANCE        integer,

        appTypeId       integer

    )
INSERT INTO #tmpClient


SELECT EntityID,0,0,0 FROM @ClientList

UNION

SELECT APP_ClientGroupAssoc.clientId,0,0,0

FROM @ClientGroupList ClientGroupList 

INNER JOIN APP_ClientGroupAssoc (NOLOCK) ON APP_ClientGroupAssoc.clientGroupId = ClientGroupList.EntityId 

LEFT JOIN @ClientList ClientList ON ClientList.EntityId = APP_ClientGroupAssoc.clientId

WHERE ClientList.EntityId IS NULL

IF object_id(''tempdb.dbo.#tmpClientProxyPairs'') IS NOT NULL drop table #tmpClientProxyPairs

create table #tmpClientProxyPairs(ClientId      integer,

                        instanceId          integer,

                        proxyClientId           integer,

                        ClientAppType               integer,

                        isIndexServer               integer DEFAULT 0,  --0 meaning proxyclient, 1 meaning index server

                        iscloudindexServer  integer DEFAULT 0,    -- 1 meaning cloud index server

                        cloudindexServer    integer DEFAULT 0,

                        isproxyclientGroup  integer DEFAULT 0 , -- 1 meaning client Group

                        clientGroup         integer DEFAULT 0,

                        subclientId         integer DEFAULT 0

                        )

IF exists (select * from #tmpClient)

    EXEC APPGetProxyClientInfo ''#tmpClient'',''#tmpClientProxyPairs'',1
INSERT INTO #ClientListAggregated(clientId,physicalClientId)


SELECT Clientid,proxyClientID FROM #tmpClientProxyPairs

UNION

SELECT tmpClient.Clientid,tmpClient.ClientID FROM #tmpClient tmpClient

LEFT JOIN #tmpClientProxyPairs tmpClientProxyPairs

ON tmpClient.ClientId = tmpClientProxyPairs.ClientId

WHERE tmpClientProxyPairs.ClientId IS NULL 

-- Delete psuedo clients for failover from list. MR 302339

DELETE ClientList 

FROM #ClientListAggregated ClientList

INNER JOIN APP_ClientProp WITH(NOLOCK) ON APP_ClientProp.attrName = ''Linked CS Client'' AND APP_ClientProp.modified = 0

AND CAST(ClientList.clientId AS NVARCHAR(10)) = APP_ClientProp.attrVal

;WITH nwReadniess(clientId, latestUpdateTime)

AS

(

    SELECT ToClientId, MAX(LastUpdateTime) FROM CCRClientToClient WITH(NOLOCK) WHERE FromClientId = 2 AND serviceType = 0 GROUP BY ToClientId

)

SELECT ClientId, physicalClientID, DisplayName,

	CASE WHEN ClientId = physicalClientId THEN ''Client is not ready since ''+CAST(offlineTime as NVARCHAR(100)) +''.''

	ELSE	''Client is not ready since ''+CAST(offlineTime as NVARCHAR(100)) +''. Physical Client [''+PhysicalClientDisplayName+''].''

	END Status

FROM 

(

	SELECT clientTbl.clientId, clientTbl.physicalClientId, ISNULL(App_client.displayName,App_client.name) DisplayName ,	

			ISNULL(physicalClient.displayName,physicalClient.name) PhysicalClientDisplayName, 

			dbo.UTCToCellLocalTime(dbo.getdatetime(CASE WHEN CCR.lastOfflineTime>0 THEN CCR.lastOfflineTime ELSE APP_Client.refTime END),2) OfflineTime

	FROM  nwReadniess R 

	INNER JOIN CCRClientToClient CCR WITH(NOLOCK)

	ON R.clientId = CCR.ToClientId AND R.latestUpdateTime = CCR.LastUpdateTime

	INNER JOIN #ClientListAggregated clientTbl

	ON clientTbl.physicalClientId = CCR.ToClientId AND FromClientId = 2 AND serviceType = 0 

	INNER JOIN APP_Client (NOLOCK) ON APP_Client.id = clientTbl.clientId

	INNER JOIN APP_Client (NOLOCK) PhysicalClient ON PhysicalClient.id = clientTbl.physicalClientId

	WHERE CCR.flag != 1 

	AND @nowTime-CCR.lastOfflineTime>=(@offlineThresholdTime*60)

	AND (PhysicalClient.status & 2) = 0 -- ignore deconfigured clients

	AND  (PhysicalClient.specialClientFlags & 2) = 0

) T

IF object_id(''tempdb.dbo.#tmpClient'') IS NOT NULL drop table #tmpClient

IF object_id(''tempdb.dbo.#tmpClientProxyPairs'') IS NOT NULL drop table #tmpClientProxyPairs

IF object_id(''tempdb.dbo.#ClientListAggregated'') IS NOT NULL drop table #ClientListAggregated

'

	IF (@globalParamPlanUpdateExec = 1)        

	BEGIN

		-- Update the output data type for clientID and physicalClientId columns.

		UPDATE NTQueryColumnList

		SET lmDataType = 14, -- Client entity

		supportedOpTypes = '9',

		columnFriendlyName = CASE WHEN ColumnName = 'ClientId' THEN  'Client(s)' ELSE 'Physical Client' END,

		isColumnFilterable = 0, -- Because we have physical client and client column, filter support isnt there. So removing filter option

		isPrimaryKey = CASE WHEN ColumnName = 'ClientId' THEN  1 ELSE 0 END -- Keep Primary key as ClientId and not physical clientID so that we get alert for each VM

		FROM NTQueryColumnList INNER JOIN NTQueryList (NOLOCK) ON 

		NTQueryColumnList.queryID = NTQueryList.queryId

		AND NTQueryList.queryName = @queryName

		AND NTQueryColumnList.columnType = 0 -- Output column type. 

		AND NTQueryColumnList.columnName in ('ClientId','physicalClientID')

		UPDATE NTQueryList

		SET queryString = @sqlquery

		WHERE queryName = @queryName

		RETURN

	END

	-- not done, create the default alert rule. 

BEGIN TRY

	BEGIN TRAN 

    DECLARE @queryId INT

    SET @queryId = 0    

DECLARE @adminID            as integer      = ISNULL((Select top 1 ID from UMUSERS where (flags & 0x040) >0 AND Name <> 'ROMS'), 1)

    DECLARE @errCode INTEGER

    DECLARE @errStr  nvarchar(1024) = ''    

	DECLARE @customRuleGuid uniqueidentifier = '1279132B-B87F-44DB-A6E6-3334AEED7B9E'

    IF EXISTS(SELECT 1 FROM NTQueryList (NOLOCK) WHERE queryName=@queryName)

    BEGIN

        GOTO FINISH_PROCESSING

    END    
    INSERT INTO NTQueryList(queryMessageId,defaultfrequency,status,queryCreator,visibility,taskId,queryString,


        xmlInfo,queryName,queryDescription,queryCriteriaName,GUID,commcellAssociation,isOverwriteAssociationAtAlertAllowed)

select 0,900,2,@adminID,0,0,@sqlQuery,

'<?xml version="1.0" encoding="UTF-16" standalone="no" ?><App_AdditionalQueryDetails alertCriteria="0" alertType="0" defaultHtmlTemplate="" defaultTextTemplate="" isHealthParam="0" querySeverity="3"><externalQueryEntity _type_="125"/><scriptDescription description="Custom rule to notify clients which are offline" guid="F2BE42DA-076C-45BD-9679-F8719DC8EE61" reportName="Notify offline clients" revision="$Revision: 1.1.2.5 $ M&lt;1585269116598>"/></App_AdditionalQueryDetails>',

@queryName,'Custom rule to notify clients which are offline',

'',@customRuleGuid,

'<App_Associations><entity _type_="124" commCellId="2" /></App_Associations>',0

    SET @queryId = SCOPE_IDENTITY()
    INSERT INTO NTQueryColumnList(queryId,columnIndex,isColumnFilterable,lmDataType,columnName,columnFriendlyName,


isPrimaryKey,supportedOpTypes,columnType,xmlInfo)

SELECT @queryId,0,0,0,'ClientList','Client(s)',0,'',1,'<App_XMLSchema attribute="0" className="commvault.msgs.CvEntities.ClientEntity" controlHidden="0" controlType="2" displayName="Client(s)" documentation="" hidden="0" inputName="ClientList" inputType="commvault.msgs.CvEntities.ClientEntity" listType="1" maximumValue="" minimumValue="" name="ClientList" readOnly="0" required="0" searchable="0" type="{commvault.msgs.CvEntities}ClientEntity"/>'

UNION ALL

SELECT @queryId,1,0,0,'ClientGroupList','Client Group(s)',0,'',1,'<App_XMLSchema attribute="0" className="commvault.msgs.CvEntities.ClientGroupEntity" controlHidden="0" controlType="2" displayName="Client Group(s)" documentation="" hidden="0" inputName="ClientGroupList" inputType="commvault.msgs.CvEntities.ClientGroupEntity" listType="1" maximumValue="" minimumValue="" name="ClientGroupList" readOnly="0" required="0" searchable="0" type="{commvault.msgs.CvEntities}ClientGroupEntity"/>'

UNION ALL

SELECT @queryId,2,0,0,'offlineThresholdTime','Notify if clients are offline for (In minutes)',0,'',1,'<App_XMLSchema attribute="0" className="java.lang.Integer" controlHidden="0" controlType="0" defaultValue="30" displayName="Notify if clients are offline for (In minutes)" documentation="" hidden="0" inputName="offlineThresholdTime" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" name="offlineThresholdTime" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"><defaultValues val="30"/></App_XMLSchema>'

UNION ALL

SELECT @queryId,0,0,14,'ClientId','Client(s)',1,'9',0,'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>'

UNION ALL

SELECT @queryId,1,0,14,'physicalClientID','Physical Client',0,'9',0,'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>'

UNION ALL

SELECT @queryId,2,0,1,'DisplayName','Client',0,'2,3,0,1',0,'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1"/>'

UNION ALL

SELECT @queryId,3,0,1,'Status','Status',0,'2,3,0,1',0,'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1"/>'

FINISH_PROCESSING:
   INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'DefaultCustomRuleClientoffline', 'Create alert rule to notify offline clients', @curUtcDateTime, 16, 0 , (16 + 2))

	COMMIT TRAN     

END TRY

BEGIN CATCH

    IF @@TRANCOUNT > 0

        ROLLBACK TRAN 

    if len(@errStr)=0 and len(ERROR_MESSAGE())>0

    begin

        set @errStr = ERROR_MESSAGE()

    end

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

        ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

        ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

        ERROR MESSAGE: ' + ERROR_MESSAGE() + '

        ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

        ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

    if len(@errStr)>0

        RAISERROR(@errStr, 16, 1)

END CATCH

