

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTCreateDefaultAlertForDeconfigVMs.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/NTCreateDefaultAlertForDeconfigVMs.script,v $ $Id: NTCreateDefaultAlertForDeconfigVMs.script,v 1.1.2.1 2020/02/26 15:41:47 mnatarajan Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

	DECLARE @guid uniqueidentifier = '83C91549-DD3F-430F-A6B1-810AB9D32906'

	DECLARE @curUtcDateTime BIGINT = DATEDIFF(SECOND, '01/01/1970', GetUTCdate())       

	DECLARE @globalParamPlanUpdateExec INT = 0

	SELECT @globalParamPlanUpdateExec = 1

	FROM

		GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

	WHERE

		gp.SqlScriptGUID = @guid

	IF (@globalParamPlanUpdateExec = 1)        -- not done, create the default alert rule and the alert. 

		RETURN

BEGIN TRY

	BEGIN TRAN 

    DECLARE @queryId INT

    SET @queryId = 0    

    DECLARE @adminID            as integer      = ISNULL((Select top 1 ID from UMUSERS where (flags & 67) = 67 AND Name <> 'ROMS'), 1)

    DECLARE @masterGroupId              INT = ISNULL((Select top 1 ID from UMGroups where name='master'), 1)    --_US_ADMIN_GROUP__

    DECLARE @errCode INTEGER

    DECLARE @errStr  nvarchar(1024) = ''

    DECLARE @queryName nvarchar(max) = 'Notify deconfigured Virtual Machines'

    IF EXISTS(SELECT 1 FROM NTQueryList (NOLOCK) WHERE queryName=@queryName)

    BEGIN

        GOTO FINISH_PROCESSING

    END    
    INSERT INTO NTQueryList(queryMessageId,defaultfrequency,status,queryCreator,visibility,taskId,queryString,


        xmlInfo,queryName,queryDescription,queryCriteriaName,GUID,commcellAssociation,isOverwriteAssociationAtAlertAllowed)

select 0,3600,2,@adminID,0,0,

'SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

SELECT App_Client.Id,ISNULL(App_Client.displayName,App_Client.name)

FROM APP_ClientProp

INNER JOIN APP_Client ON APP_ClientProp.componentNameId = App_Client.id

AND attrName=''IndexingV2_VSA''

AND APP_ClientProp.modified=0

AND attrval<>''0''

AND (APP_Client.status&2)>0 -- CV_STATUS_UNINSTALLED

LEFT JOIN APP_ClientProp VMDeletedTime ON VMDeletedTime.componentNameId = App_Client.id

AND VMDeletedTime.attrName=''Virtual Machine deletion time''

AND VMDeletedTime.modified=0

AND VMDeletedTime.attrval<>''0''

LEFT JOIN simInstalledPackages ON simInstalledPackages.ClientId = App_Client.Id

WHERE simInstalledPackages.ClientId IS NULL AND VMDeletedTime.componentnameid IS NULL	

', 

--------- END QUERY ---------

--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------

'<?xml version="1.0" encoding="UTF-16" standalone="no" ?><App_AdditionalQueryDetails alertCriteria="0" alertType="0" defaultHtmlTemplate="" defaultTextTemplate="" isHealthParam="0" querySeverity="3"><externalQueryEntity _type_="125"/><scriptDescription description="Custom rule to notify deconfigured Virtual Machines" guid="281AC25C-9FEB-4788-A90C-3074E716BC94" reportName="Notify deconfigured Virtual Machines" revision="$Revision: 1.1.2.1 $ M&lt;1581632949605>"/></App_AdditionalQueryDetails>',

@queryName,'Custom rule to notify deconfigured Virtual Machines',

'',NEWID(),

'<App_Associations><entity _type_="124" commCellId="2" /></App_Associations>',0

    SET @queryId = @@IDENTITY
    INSERT INTO NTQueryColumnList(queryId,columnIndex,isColumnFilterable,lmDataType,columnName,columnFriendlyName,


isPrimaryKey,supportedOpTypes,columnType,xmlInfo)

SELECT @queryId,0,1,14,'Id','Id',1,'9',0,'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>'

UNION

SELECT @queryId,1,0,1,'Column1','VM Client Name',0,'2,3,0,1',0,'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="1" isAlertRecipient="0"/>'

	-- Now that rule is created, create the alert . 

	DECLARE @xmlEntities        AS nvarchar(MAX)= '<CVGui_CommCellTreeNode><clients includeAll="0" /><clientGroups includeAll="0" /><libraries includeAll="0" /><mediaAgents includeAll="0" /><storagePolcies includeAll="0" /><trackingPolicies includeAll="0" /><trackingSchedules /><trackingJobs /><criterias includeAll="0" /><workflows includeAll="0" /><commcells includeAll="0" /></CVGui_CommCellTreeNode>'

    DECLARE @emptyDateTime      AS datetime = '1900-01-01 00:00:00.000'

    DECLARE @localeId           AS integer      = 0

DECLARE @status             AS integer      = 2048 + 1     -- 'NNT_STATUS_LAPTOP_ALERT|NT_STATUS_DISABLED

    DECLARE @ruleState          AS integer      = 0

    DECLARE @reportOptions      AS integer      = 1     -- 'NT_REPORT_IMMEDIATE' 

    DECLARE @persistTimeSeconds AS integer      = 0		-- No repeat duration

DECLARE @categoryId         as integer      =  9                -- 'NT_CATEGORY_CUSTOM_ALERT'

    DECLARE @SelCriteriaId      integer

	DECLARE @htmldefaultTemplate nvarchar(max)

    DECLARE @textdefaultTemplate nvarchar(max)  

IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name='UseNewAlertTemplate' AND value=1)

	 BEGIN

		SET @htmldefaultTemplate = '<SUBJECT BEGIN>Alert: <ALERT NAME> <IS ESCALATED?><SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border-top-color: #2f4e66; border-top-style: solid; border-top-width: 1px; border-right-color: #2f4e66; border-right-style: solid; border-right-width: 1px; border-bottom-color: #2f4e66; border-bottom-style: solid; border-bottom-width: 1px; border-left-color: #2f4e66; border-left-style: solid; border-left-width: 1px"><tr><td><center><table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"><tr style="background-color: #2f4e66"><td valign="middle" align="left" colspan="3"><div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"><font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font></div></td></tr><tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"><td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"><font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font></td></tr><tr><td colspan="3" style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"><font size="3" color="#444444" face="sans-serif">&lt;TABLE DATA&gt;</font></td></tr><tr><td colspan="3" style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"><font size="3" color="#444444" face="sans-serif">We detected that above VM(s) are not being backed up (either removed from subclient or filtered) and hence have been deconfigured. </font></td></tr><tr><td colspan="3" style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"><font size="3" color="#444444" face="sans-serif"> Please complete any pending operations like backup copy or restore. </font></td></tr><tr style="background-color: #2f4e66"><td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"><font size="3" face="sans-serif" color="#ffffff">Generated At: &lt;TIME&gt; </font></td></tr></table></center></td></tr></table></div>'

	 END

	 ELSE

	 BEGIN

		SET @htmldefaultTemplate = '<SUBJECT BEGIN>Alert: <ALERT NAME> <IS ESCALATED?><SUBJECT END><div id="contentTbl-table-scroll"><table cellpadding="0" cellspacing="0" border="1" align="center" width="100%" style="border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-style: solid; border-top-color: #dedede; border-right-color: #dedede; border-bottom-color: #dedede; border-left-style: solid; border-right-style: solid; border-top-width: 0px; border-right-width: 0px"><tr><td><center><table cellpadding="0" border="0" id="contentTbl" width="100%" align="center" cellspacing="0"><tr style="background-color: #666666"><td valign="middle" align="left"><div style="margin-left: 10px; margin-bottom: 4px; margin-top: 4px"><font size="6" face="Helvetica,sans-serif" color="#EEEEEE">&lt;ALERT NAME&gt; </font></div></td></tr><tr><td colspan="1" valign="middle" align="left" bgcolor="#DCDEDE"><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>CommCell: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong></ul></td></tr><tr><td width="100%" colspan="1" align="left"><ul style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">&lt;TABLE DATA&gt;</font></ul><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"> We detected that above VM(s) are not being backed up (either removed from subclient or filtered) and hence have been deconfigured. </font></ul></td></tr><tr><td width="100%" colspan="1" align="left"><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"> Please complete any pending operations like backup copy or restore. </font></ul></td></tr><tr style="background-color: #666666"><td colspan="1" align="left">&#160;</td></tr></table></center></td></tr></table></div>'

	 END

    SET @textdefaultTemplate = '<SUBJECT BEGIN>Alert: <ALERT NAME> <IS ESCALATED?><SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_ MsgNewLine_ MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Alert Rule Name : <QUERY NAME> MsgNewLine_MsgTab_ Client Name : <INDEX 1> MsgNewLine_MsgTab_ Decommissioned Time : <INDEX 2> MsgNewLine_MsgTab_ Condition Cleared: : <CONDITION CLEARED Y/N>'

    DECLARE @thisCriteria       int

DECLARE @notifType          AS integer  = 1 | 131072

    --

    ---

    ----  FOR CURSOR -----

DECLARE @alertType          INTEGER = 65

DECLARE @notificationName   NVARCHAR(128)         -- 'NT_MAX_NOTIFICATION_NAME_SIZE'

DECLARE @description        NVARCHAR(1024)         -- 'NT_MAX_ALERT_DESCRIPTION_SIZE'

    --

    --      

    DECLARE @thisAlertId        integer

    SET @notificationName = 'Virtual Machine(s) has been deconfigured'        

    SET @description = 'Alert to notify administrator when VMs has been deconfigured'

	SELECT @thisAlertId = NTNotificationRule.id FROM NTNotificationRule 

	INNER JOIN NTNotificationProp (NOLOCK) ON NTNotificationProp.componentNameID = NTNotificationRule.Id

AND NTNotificationProp.attrName = 'VM Deconfigured Alert'

WHERE (status& 2048)>0 and revision=1

AND (Status& 2=0)

	AND NTNotificationRule.alertTypeID = @alertType

    -- Check whether this alert is already present. If so, dont insert again. 

    IF @thisAlertId>0

    BEGIN

        GOTO FINISH_PROCESSING

    END

    INSERT NTNotificationRule ( categoryId,             alertTypeId,

                                notificationName,       revision,

                                lastModified,           description,

                                notifType,              notifOwner,

                                locale,                 status,

                                ruleState,              ruleState2,

                                lastTimeTriggered,      lastTimeTriggered2,

                                lastTimeChecked,        hasAttachments,

                                hasAttachments2,        xmlEntityList,

                                origCCId,               GUID)

    VALUES (                    @categoryId,            @alertType              ,

                                @notificationName,      1,

                                @curUtcDateTime,        @description,

                                @notifType,             @adminID,           

                                0,						@status,          -- 0 DefaultLocale US-English

                                @ruleState,             @ruleState,

                                @emptyDateTime,         @emptyDateTime,

                                @emptyDateTime,         0,

                                0,                      @xmlEntities,

                                default,                newid() )   

    SET @thisAlertId = @@Identity 

    INSERT NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)

VALUES(75, 1, @thisAlertId, @reportOptions, 0, @persistTimeSeconds)      -- 'NT_GENERIC_QUERY
	INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)     


		VALUES (@thisAlertId, 1, null, null, 0)
	INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)     


		VALUES (@thisAlertId, 2, null, null, 0)
	Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)


VALUES (@thisAlertId, 'VM Decommissioned Alert', '7','1',dbo.GetUnixTime(GETUTCDATE()),0)

-- ADD DEFAULT (EMAIL) MESSAGE:         

                                    --

    INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,

                        SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,

                        baseDir,userName,password, rssID, messageFormatType, formatStringHtml)

    SELECT      @thisAlertId, 1,	  1, @textdefaultTemplate, N'', 0, 0, 0, 0, 0,'', '', '', '', 1, @htmldefaultTemplate

    UNION ALL

    SELECT		@thisAlertId, 131072, 1, @textdefaultTemplate, N'', 0, 0, 0, 0, 0,'', '', '', '', 0, @htmldefaultTemplate
		INSERT INTO NTNotificationQueryMapping 


            VALUES(

                @queryId, @thisAlertId, @emptyDateTime, @emptyDateTime,

                0, 0,

                '',

                '<CVGui_QueryAdditionalInfo><queryParameters/><externalQueryInfo _type_="125"/></CVGui_QueryAdditionalInfo>',

                '',

                'Notify decommissioned Virtual Machines'

            )  
        INSERT INTO NTnotificationGroups(NTNotificationId,groupId,escalationLevel)


        SELECT @thisAlertId, @masterGroupId, 1

-- ADD DEFAULT USER (SHOULDN'T HAVE TO DO THIS, BUT REQ'D TO SUPPORT CURRENT ALERT GUI)

--      INSERT NTnotificationUsers  (NTnotificationID, userId,    escalationLevel)

--          VALUES (@thisAlertId, @adminID, 1)

FINISH_PROCESSING:
   INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'DefaultVMDeconfiguredAlert', 'Create alert to notify VMs deconfigured', @curUtcDateTime, 16, 0 , (16 + 2))

	COMMIT TRAN     

END TRY

BEGIN CATCH

    IF @@TRANCOUNT > 0

        ROLLBACK TRAN 

    if len(@errStr)=0 and len(ERROR_MESSAGE())>0

    begin

        set @errStr = ERROR_MESSAGE()

    end

    if len(@errStr)>0

        RAISERROR(@errStr, 16, 1)   

END CATCH

