

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/NTCleanupAlertAssociationToPlan.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/NTCleanupAlertAssociationToPlan.script,v $ $Id: NTCleanupAlertAssociationToPlan.script,v 1.1.4.2 2020/05/28 06:58:11 alakra Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

DECLARE @guid uniqueidentifier = '17FDDF14-2805-4002-B2E5-105F14609916'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       

DECLARE @globalParamPlanUpdateExec INT = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamPlanUpdateExec = 0)        -- not done, create the activity monitoring dashboard

BEGIN

	BEGIN TRY

	BEGIN TRAN

	DELETE App_PlanProp FROM App_PlanProp

	INNER JOIN App_Plan (NOLOCK) ON App_PlanProp.componentNameId = App_Plan.id

AND (App_Plan.flag & 0x40000000) = 0 AND ( (App_Plan.flag & 0x00004) = 0)

	WHERE App_PlanProp.attrName = 'Alert' and App_Plan.subType!=33554439 -- Alert association is supported for laptop plans alone. Laptop          =  33554439
    INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'PlanUpdateAlertInfoInPlanProp', 'Cleanup alert association to plans', @curUtcDateTime, 16, 0 , (16 + 2))

	COMMIT TRAN	

	END TRY

	BEGIN CATCH

		DECLARE @o_errorCode INT

		DECLARE @tmpErrorString NVARCHAR

		-- Call procedure to print error information.

		-- Call procedure to get error information.

		EXECUTE dbo.GetError @tmpErrorString OUTPUT , @o_errorCode OUTPUT

		PRINT 'Error: [ ' + @tmpErrorString + ' ]. Rolling back transaction'

		-- Rollback any active or uncommittable transactions before

		-- inserting information in the ErrorLog

		IF XACT_STATE() <> 0

		BEGIN

		PRINT 'Error: [ ' + @tmpErrorString + ' ]. Rolling back transaction'

			ROLLBACK TRANSACTION;

		END

		RAISERROR(@tmpErrorString, 16, 1)  

	 END CATCH;

END

SET NOCOUNT OFF

GO

