

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/MigrateDiskLibraryToStorage.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

BEGIN

BEGIN TRANSACTION MigrateDiskLibraryToStorage

BEGIN TRY  

	DECLARE @errCode		INTEGER

	DECLARE @errStr			varchar(1024) 

IF object_id('tempdb.dbo.#updatableSubTasks') IS NOT null DROP TABLE #updatableSubTasks

DECLARE @curUtcDateTime BIGINT = DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETDATE())  

DECLARE @reportId INT

DECLARE @OptionID INT = 353854670

SELECT  @reportID = reportid 

FROM app_reports WITH (NOLOCK)

WHERE name ='Disk library utilization'

CREATE TABLE #updatableSubTasks (taskId INT, subTaskId INT, updatedURL NVARCHAR(MAX))
INSERT INTO #updatableSubTasks    


SELECT ST.taskID,O.subTaskId,

 substring(t.value('@url', 'NVARCHAR(MAX)'),1,PATINDEX('%pageSize%',t.value('@url', 'NVARCHAR(MAX)'))-1) 

 + 'input.CommCell%3D%255B2%255D%26input.storageType%3D%255B%2522Disk%2520Library%2522%255D%26'

 + substring(t.value('@url', 'NVARCHAR(MAX)'),PATINDEX('%pageSize%',t.value('@url', 'NVARCHAR(MAX)')),len(t.value('@url', 'NVARCHAR(MAX)')))

FROM  TM_SubTask ST WITH (NOLOCK)

INNER JOIN TM_SubTaskXMLOptions O WITH (NOLOCK)

ON ST.subTaskId = O.subTaskId

CROSS APPLY O.xmlValue.nodes('//./webReportOption[1]') A(t)

WHERE            subTaskType = 1

                        AND operationType = 4004

                        AND     O.xmlValue.exist('//./webReportOption[1]/@reportType[.="CustomReports"]') = 1

                        AND  t.value('@reportId', 'INT') = @reportID 

update #updatableSubTasks  -- in case the URL using report Name , replace the old report name with new one

set updatedURL = replace(updatedURL,'Disk%2520library%2520utilization','Storage%2520Utilization')

UPDATE  O

SET     xmlValue.modify('replace value of (/TMMsg_JobOption/adminOpts/reportOption/webReportOption/@url)[1] with sql:column("S.updatedURL")')

FROM  TM_SubTaskXMLOptions O WITH (NOLOCK)

INNER JOIN  #updatableSubTasks S   ON O.subTaskId = S.subTaskId

UPDATE T

SET                  T.value = S.updatedURL

FROM  TM_SubTaskOptions T WITH (NOLOCK)

INNER JOIN     #updatableSubTasks S

ON T.subTaskId = S.subTaskId 

AND T.optionId = @OptionID

------below two updates are for TM_JobXMLOpetions and TM_JobOptions-----

------we will update the original records with modified time first then insert new records to these two tables----------------------------

UPDATE J 

SET   J.modified =@curUtcDateTime

FROM  TM_JobXMLOptions J WITH (NOLOCK) 

INNER JOIN     #updatableSubTasks S WITH (NOLOCK) 

ON J.subTaskId = S.subTaskId 

AND J.modified = 0 

UPDATE J 

SET    modified =@curUtcDateTime

FROM  TM_JobOptions J WITH (NOLOCK) 

INNER JOIN  #updatableSubTasks S

ON J.subTaskId = S.subTaskId 

AND J.optionId = @OptionID

AND J.modified = 0

----below code will add new entry for these two tables
INSERT INTO TM_JobXMLOptions(jobId, xmlValue, taskId, subTaskId, lastJobId, created, modified)        


SELECT 0,STXO.xmlValue,ST.taskId,ST.subTaskId,0,@curUtcDateTime, 0

FROM #updatableSubTasks ST

INNER JOIN TM_SubTaskXMLOptions STXO  WITH (NOLOCK) ON ST.subTaskId = STXO.subTaskId
INSERT INTO TM_JobOptions(jobId, optionId, type, value, taskId, subTaskId,lastJobId, created,modified)


SELECT 0,J.optionId, J.type, J.value, S.taskId,J.subTaskID,0,@curUtcDateTime,0

FROM tm_subtaskoptions J WITH (NOLOCK)

INNER JOIN #updatableSubTasks S  ON J.subtaskId = S.subtaskId 

AND J.optionId = @OptionID 

IF object_id('tempdb.dbo.#updatableSubTasks') IS NOT null DROP TABLE #updatableSubTasks

END TRY

BEGIN CATCH

    SET @errCode = ERROR_NUMBER()

    SET @errStr = 'Procedure [' + ERROR_PROCEDURE() + '] Error Number [' + CONVERT(NVARCHAR(15), @errCode) + '] Error Line [' + CONVERT(NVARCHAR(15), ERROR_LINE()) + ']. ' + ERROR_MESSAGE()               

END CATCH  

IF @errCode <> 0

BEGIN

    PRINT @errStr

    ROLLBACK TRANSACTION MigrateDiskLibraryToStorage

END

ELSE

        COMMIT  TRANSACTION MigrateDiskLibraryToStorage

END
