

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/MMVolume.script] ---------- 


SET QUOTED_IDENTIFIER ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2015  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

DECLARE @nowTime INTEGER = DATEDIFF(second, '01/01/1970', GETUTCDATE())

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'a260a68e-6b66-413a-afb7-1e144c7aa173')

BEGIN

    DECLARE @ErrVal INTEGER = 0

    DECLARE @RowCount INTEGER = 0

    DECLARE @updateReleaseTime INTEGER = dbo.getUnixTime('01/24/2019')

    IF object_id('tempdb.dbo.#tempVolIdList') is not null DROP TABLE #tempVolIdList

    CREATE TABLE #tempVolIdList (VolumeId INT, MediaSideId INT, PhysicalBytesMB INT)
    INSERT INTO #tempVolIdList


    SELECT V.VolumeId, V.MediaSideId, 0

    FROM MMVolume V WITH (READUNCOMMITTED)

    WHERE V.LastBackupTime > @updateReleaseTime

AND V.RecordingFormatId <> 10001

    UPDATE T

    SET T.PhysicalBytesMB = T2.PhysicalBytesMB

    FROM #tempVolIdList T,

		(SELECT C.volumeId, SUM(C.physicalSize / (1024 * 1024)) as PhysicalBytesMB

                    FROM archChunk C WITH (READUNCOMMITTED), #tempVolIdList VOL

	            WHERE VOL.VolumeId = C.volumeId

	            GROUP BY C.volumeId

	        ) T2

    WHERE T.VolumeId = T2.VolumeId

    UPDATE MMVolume

    SET PhysicalBytesMB = T.PhysicalBytesMB

    FROM MMVolume V

        INNER JOIN #tempVolIdList T ON V.VolumeId = T.volumeId

    UPDATE MS

    SET PhysicalBytesMB = T.PhysicalBytesMB

    FROM MMMediaSide MS

        INNER JOIN #tempVolIdList T ON T.MediaSideId = MS.MediaSideId

    IF object_id('tempdb.dbo.#tempVolIdList') is not null DROP TABLE #tempVolIdList
    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('a260a68e-6b66-413a-afb7-1e144c7aa173', 'UpdateVolumeSizeForTapeScript', 'Script to update the volume size for tape based on chunks.', @nowTime, 16, 0, 17)

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'AAEB25FA-01D7-4C11-9DF9-4A4EE4BE485A')

BEGIN

UPDATE Vol SET VolumeFlags = 2 /*VOL_FULL*/, VolumeFullReason = 42046, VolumeFullTime = @nowTime

	FROM MMVolume Vol 

	INNER JOIN MMCloudVolCacheMountPath CACHE WITH(NOLOCK) ON CACHE.volumeId = Vol.VolumeId

	WHERE Vol.VolumeFlags IN (1 /*VOL_ACTIVE*/, 7 /*VOL_ACTIVE_APPEND*/) 
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('AAEB25FA-01D7-4C11-9DF9-4A4EE4BE485A', 'MarkHybridVolumesFull', 'Script to mark the hybrid volumes full.', @nowTime, 16, 0, 20)

END

