

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/MMVaultTrackerActionOperations.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @guid nvarchar(256)

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.3 $'

SET @name = 'VaultTracker Action Operations'

SET @description = 'Workflow to allow operations to be performed on VaultTracker Actions from AdminConsole'

SET @version = 1

SET @flags = 6

SET @guid = 'c56aaa76-0293-4887-a08a-feded2fbd57e'

SET @definition = '<workflow apiMode="0" config="&lt;configuration /&gt;" description="Workflow to allow operations to be performed on VaultTracker Actions from AdminConsole" executeOnWeb="0" inputs="&lt;inputs&gt;&lt;actionId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;operationId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;" interactive="1" isHtmlDescription="0" name="VaultTracker Action Operations" outputs="&lt;outputs /&gt;" revision="$Revision: 1.1.2.3 $" tags="" uniqueGuid="56891316-fc03-4990-b5dd-c79dda11fc67" variables="&lt;variables&gt;&lt;cmd class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/variables&gt;" webHidden="0" workflowId="83">

  <schema>

    <inputs attribute="0" className="" name="inputs" type="">

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" hidden="0" inputType="java.lang.Integer" listType="0" name="actionId" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" hidden="0" inputType="java.lang.Integer" listType="0" name="operationId" type="{http://www.w3.org/2001/XMLSchema}integer" />

    </inputs>

    <variables className="" name="variables" type="">

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" hidden="0" inputType="java.lang.String" listType="0" name="cmd" type="{http://www.w3.org/2001/XMLSchema}string" />

    </variables>

    <outputs className="" name="outputs" type="" />

    <config className="" name="configuration" type="" />

  </schema>

  <Start commented="0" continueOnFailure="0" created="0" description="" displayName="Start" height="36" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="image;image=/images/jgraphx/house.png" uniqueName="Start_1" waitSetting="0" width="58" x="147" y="109">

    <inputs val="&lt;inputs /&gt;" />

    <transition activity="Script_1" commented="0" originalStyle="" points="" sourceX="174" sourceY="127" status="0" style="defaultEdge" targetX="310" targetY="127" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Start>

  <Activity commented="0" continueOnFailure="0" created="1551152063570" description="activity to execute code snippets in the selected language" displayName="Generate Cmd" height="40" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_1" waitSetting="0" width="111" x="255" y="107">

    <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;String cmd = &amp;quot;qoperation vtaction -vta &amp;quot; + xpath:{/workflow/inputs/actionId} + &amp;quot; -cmd &amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;switch(xpath:{/workflow/inputs/operationId}) {&amp;#xD;&amp;#xA;    case 1: &amp;#xD;&amp;#xA;        cmd += &amp;quot;abort&amp;quot;;&amp;#xD;&amp;#xA;        break;&amp;#xD;&amp;#xA;    case 2: &amp;#xD;&amp;#xA;        cmd += &amp;quot;pick&amp;quot;;&amp;#xD;&amp;#xA;        break;&amp;#xD;&amp;#xA;    case 3:&amp;#xD;&amp;#xA;        cmd += &amp;quot;reach&amp;quot;;&amp;#xD;&amp;#xA;        break;&amp;#xD;&amp;#xA;    case 4:&amp;#xD;&amp;#xA;        cmd += &amp;quot;return&amp;quot;;&amp;#xD;&amp;#xA;        break;&amp;#xD;&amp;#xA;    default:&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Unknown operation&amp;quot;);    &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;return cmd;&quot; /&gt;&lt;/inputs&gt;" />

    <transition activity="ImpersonateCreator_1" commented="0" originalStyle="" points="" sourceX="310" sourceY="127" status="0" style="defaultEdge" targetX="477" targetY="127" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="1" created="1551152272433" description="Execute a command on a remote machine" displayName="ExecuteCommand" height="40" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_1" waitSetting="0" width="134" x="948" y="108">

    <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;hostName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;displayName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;commCellName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;csGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;type class=&quot;commvault.msgs.CvEntities.CommCellType&quot; _list_=&quot;false&quot; /&gt;&lt;flags class=&quot;commvault.msgs.CvEntities.EntityFlags&quot; _list_=&quot;false&quot; /&gt;&lt;GUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;newName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_1/output} -tk xpath:{/workflow/ImpersonateExecutor_1/token}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

    <transition activity="Script_2" commented="0" originalStyle="" points="" sourceX="1015" sourceY="130" status="0" style="defaultEdge" targetX="1005" targetY="236" transitionIndex="0" x="361" y="3">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1551152558903" description="impersonates the user who executes the workflow" displayName="ImpersonateExecutor" height="44" interactive="0" jobMode="0" name="ImpersonateExecutor" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ImpersonateUser" uniqueName="ImpersonateExecutor_1" waitSetting="0" width="153" x="762" y="106">

    <inputs val="&lt;inputs /&gt;" />

    <transition activity="ExecuteCommand_1" commented="0" originalStyle="" points="" sourceX="838" sourceY="130" status="0" style="defaultEdge" targetX="996" targetY="123" transitionIndex="0" x="361" y="3">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1551153651937" description="activity to execute code snippets in the selected language" displayName="Generate Cmd" height="40" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_2" waitSetting="0" width="111" x="956" y="178">

    <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;import java.util.regex.*;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try {&amp;#xD;&amp;#xA;    String returnString = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    String opString = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    if(null != xpath:{/workflow/ExecuteCommand_1/commandOutput}) {&amp;#xD;&amp;#xA;        opString = xpath:{/workflow/ExecuteCommand_1/commandOutput};&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    logger.info(opString);&amp;#xD;&amp;#xA;    if(xpath:{/workflow/ExecuteCommand_1/exitCode} &amp;gt; 0 || xpath:{/workflow/ExecuteCommand_1/errorCode} &amp;gt; 0) {&amp;#xD;&amp;#xA;        Pattern p = Pattern.compile(&amp;quot;.*: (.*)&amp;quot;);&amp;#xD;&amp;#xA;        Matcher m = p.matcher(opString);&amp;#xD;&amp;#xA;        if(m.find()) {&amp;#xD;&amp;#xA;            returnString = m.group(1);&amp;#xD;&amp;#xA;        } else {&amp;#xD;&amp;#xA;            returnString = opString;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    } else {&amp;#xD;&amp;#xA;        returnString = &amp;quot;Successfully performed operation on action&amp;quot;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    return returnString;&amp;#xD;&amp;#xA;}catch(e) {&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Error - &amp;quot; + e);&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

    <transition activity="InformationalMessage_1" commented="0" originalStyle="" points="" sourceX="1011" sourceY="200" status="0" style="defaultEdge" targetX="1009" targetY="266" transitionIndex="0" x="361" y="3">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1551154203045" description="displays an informational message to the user" displayName="InformationalMessage" height="34" interactive="0" jobMode="0" name="InformationalMessage" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity" uniqueName="InformationalMessage_1" waitSetting="0" width="157" x="931" y="247">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs name="outputs">

        <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

      </outputs>

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;message&gt;xpath:{/workflow/Script_2/output}&lt;/message&gt;&lt;dialogType&gt;Popup&lt;/dialogType&gt;&lt;iconType&gt;Information&lt;/iconType&gt;&lt;title&gt;Operation result&lt;/title&gt;&lt;html&gt;false&lt;/html&gt;&lt;formProperties /&gt;&lt;/inputs&gt;" />

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1553149918556" description="executes queries against a commcell database" displayName="CommServDBQuery" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_1" waitSetting="0" width="143" x="585" y="110">

    <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;DECLARE @userId INT = xpath:{/workflow/system/executor/userId}&amp;#xD;&#xD;&#xA;DECLARE @commCellId INT = 2&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;IF OBJECT_ID(''tempdb.dbo.#clientLstWithAgentMgmtCap'') IS NOT NULL&amp;#xD;&#xD;&#xA;    DROP TABLE #clientLstWithAgentMgmtCap&amp;#xD;&#xD;&#xA;CREATE TABLE #clientLstWithAgentMgmtCap&amp;#xD;&#xD;&#xA;(&amp;#xD;&#xD;&#xA;    clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT&amp;#xD;&#xD;&#xA;)&amp;#xD;&#xD;&#xA;EXEC sec_getIdaObjectsForUser @userId, 3 , 2, 0, ''#clientLstWithAgentMgmtCap''&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;IF NOT EXISTS(SELECT 1 FROM #clientLstWithAgentMgmtCap WHERE clientId = @commCellId)&amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;&#x9;DECLARE @userName VARCHAR(MAX) = (SELECT name FROM UMUsers WHERE id = @userId)&amp;#xD;&#xD;&#xA;&#x9;DECLARE @clientName VARCHAR(MAX) = (SELECT name FROM APP_Client WHERE id = @commCellId)&amp;#xD;&#xD;&#xA;&#x9;SELECT ''User ['' + @userName + ''] doesn''''t have [Agent Management] permission on ['' + @clientName + ''] [client]''&amp;#xD;&#xD;&#xA;END&amp;#xD;&#xD;&#xA;ELSE&amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;    SELECT ''Success''&amp;#xD;&#xD;&#xA;END&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA; &lt;/query&gt;&lt;/inputs&gt;" />

    <transition activity="ImpersonateExecutor_1" commented="0" originalStyle="" points="" sourceX="644" sourceY="217" status="0" style="defaultEdge" targetX="817" targetY="127" transitionIndex="0" x="179" y="1">

      <condition language="1" script="&quot;Success&quot;.equals(xpath:{/workflow/CommServDBQuery_1/resultSets/row[1]/col[1]})" />

    </transition>

    <transition activity="InformationalMessage_3" commented="0" originalStyle="" points="" sourceX="656" sourceY="127" status="0" style="defaultEdge" targetX="657" targetY="231" transitionIndex="0" x="179" y="1">

      <condition language="1" script="!&quot;Success&quot;.equals(xpath:{/workflow/CommServDBQuery_1/resultSets/row[1]/col[1]})" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1553152208341" description="displays an informational message to the user" displayName="InformationalMessage" height="34" interactive="0" jobMode="0" name="InformationalMessage" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity" uniqueName="InformationalMessage_3" waitSetting="0" width="157" x="579" y="214">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs name="outputs">

        <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

      </outputs>

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;message&gt;xpath:{/workflow/CommServDBQuery_1/resultSets/row[1]/col[1]}&lt;/message&gt;&lt;dialogType&gt;Popup&lt;/dialogType&gt;&lt;iconType&gt;Information&lt;/iconType&gt;&lt;title&gt;Operation result&lt;/title&gt;&lt;html&gt;false&lt;/html&gt;&lt;formProperties /&gt;&lt;/inputs&gt;" />

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1553184377262" description="impersonates the user who created the workflow" displayName="ImpersonateCreator" height="34" interactive="0" jobMode="0" name="ImpersonateCreator" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ImpersonateCreator" uniqueName="ImpersonateCreator_1" waitSetting="0" width="145" x="404" y="110">

    <inputs val="&lt;inputs /&gt;" />

    <transition activity="CommServDBQuery_1" commented="0" originalStyle="" sourceX="493" sourceY="128" status="0" style="defaultEdge" targetX="734" targetY="132" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision, uniqueGuid, AutoDeploy)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision, @guid, 1)

	SET @workflowId = SCOPE_IDENTITY()
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = revision From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision, uniqueGuid = @guid

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END
