

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/MMSDSStoragePool.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/MMSDSStoragePool.script,v $ $Id: MMSDSStoragePool.script,v 1.1.2.3 2020/06/13 05:12:07 aselvanayagam Exp $";
-- TABLENAME MMSDSStoragePool, MMDiskHwInfo

print '... inserting Table: MMSDSStoragePool,'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME MMSDSStoragePool, MMDiskHwInfo

DECLARE @nowTime	INT

SET     @nowTime =  DATEDIFF(SECOND, '01/01/1970', GetUTCdate())

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '30DC48C8-C649-4886-BB1E-53120CC57AE5')

BEGIN

	declare @tblStoragePool table (clientGroupId int, storagePoolName nvarchar(1024), libraryId int, GDSPId int, dispFactor int, redFactor int , NodesPerBlock int)
	INSERT INTO @tblStoragePool


	SELECT DISTINCT A.clientGroupId, B.name, 0,0,0,0,0

	FROM APP_ClientGroupAssoc A, APP_ClientGroup B, APP_AdvanceSettings S

	WHERE A.ClientGroupId = B.id

AND S.EntityType = 28

	AND S.EntityId = B.id

AND S.keyName = 'StoragePool'

	AND CONVERT(nvarchar(max),S.value) = 'true'

	AND S.enabled = 1

AND S.relativePath= 'CommServDB.MediaAgent'

	AND S.deleted = 0

	UPDATE T

	SET dispFactor = cast (value as nvarchar)

	from APP_AdvanceSettings S WITH (READUNCOMMITTED), @tblStoragePool T

WHERE S.keyName = 'Disperse Factor' AND S.relativePath= 'CommServDB.MediaAgent'

AND S.entityType = 28 AND S.enabled=1 AND S.entityId = T.clientGroupId

	AND S.deleted = 0	 

	UPDATE T	

	SET redFactor = cast (value as nvarchar)

	FROM APP_AdvanceSettings S WITH (READUNCOMMITTED), @tblStoragePool T

WHERE S.keyName = 'Redundancy factor' AND S.relativePath= 'CommServDB.MediaAgent'

AND S.entityType = 28 AND S.enabled=1 AND S.entityId = T.clientGroupId

	AND S.deleted = 0

	UPDATE T	

	SET nodesPerBlock = cast (value as nvarchar)

	FROM APP_AdvanceSettings S WITH (READUNCOMMITTED),  @tblStoragePool T

WHERE S.keyName = 'No. of MediaAgents' AND S.relativePath= 'CommServDB.MediaAgent'

AND S.entityType = 28 AND S.enabled=1 AND S.entityId = T.clientGroupId

	AND S.deleted = 0

	UPDATE T

	SET libraryId = L.LibraryId

	FROM MMDevice D WITH (READUNCOMMITTED), MMEntityProp ME WITH (READUNCOMMITTED), @tblStoragePool T, MMMountPathToStorageDevice MPSD, MMMountPath MP, MMLibrary L

	WHERE D.DeviceId = ME.EntityId

AND ME.EntityType = 8

AND ME.propertyName = 'DeviceClientGroup'

	AND T.clientGroupId = ME.intVal

	AND D.DeviceId = MPSD.DeviceId

	AND MPSD.MountPathId = MP.MountPathId

	AND MP.LibraryId = L.LibraryId

	UPDATE T

	SET GDSPId = G.id

	FROM MMDataPath D WITH (READUNCOMMITTED), MMMountPath M WITH (READUNCOMMITTED), MMDrivePool P WITH (READUNCOMMITTED), @tblStoragePool T, archGroupCopy C, archGroup G

	WHERE M.MasterPoolId = P.MasterPoolId AND P.DrivePoolId = D.DrivePoolId AND M.LibraryId = T.libraryId 

	AND D.CopyId = C.ID AND C.archGroupId = G.id

	IF NOT EXISTS (SELECT 1 from MMSDSStoragePool S, @tblStoragePool T where T.storagePoolName = S.StoragePoolName)

	BEGIN
		INSERT INTO MMSDSStoragePool


		SELECT storagePoolName, libraryId, GDSPId, dispFactor, redFactor, nodesPerBlock, 0, '', '', 300, 0

		FROM @tblStoragePool T

	END

	ELSE

	BEGIN

		UPDATE MMSDSStoragePool

		SET NodesPerBlock = T.nodesPerBlock

		FROM MMSDSStoragePool S, @tblStoragePool T

		WHERE S.LibraryId = T.libraryId

		AND S.NodesPerBlock = 0

	END

	UPDATE MMDiskHWInfo

	SET mountPathUsageType = 2

	FROM MMDiskHWInfo D, @tblStoragePool T,

	MMMountPath MP, MMMountPathToStorageDevice MSD

	WHERE T.libraryId = MP.LibraryId

		AND MP.MountPathId = MSD.MountPathId

		AND D.deviceId = MSD.DeviceId

		AND D.deviceOSPath LIKE '/ws/disk%'

	UPDATE MMDiskHWInfo

	SET mountPathUsageType = 1

	FROM MMDiskHWInfo D, @tblStoragePool T,

	MMMountPath MP, MMMountPathToStorageDevice MSD

	WHERE T.libraryId = MP.LibraryId

		AND MP.MountPathId = MSD.MountPathId

		AND D.deviceId = MSD.DeviceId

		AND deviceOSPath LIKE '/ws/ddb%'

	declare @tblHostBlock table (hostId int, blockNum int, deviceId int, nodesPerBlock int, libraryId int)
	INSERT INTO @tblHostBlock


	SELECT DISTINCT hostId,0, D.deviceId, T.NodesPerBlock, MP.LibraryId

	FROM MMDiskHWInfo D,@tblStoragePool T,

	MMMountPath MP, MMMountPathToStorageDevice MSD

	WHERE T.libraryId = MP.LibraryId

		AND MP.MountPathId = MSD.MountPathId

		AND D.deviceId = MSD.DeviceId

	AND D.flags & 1 = 1

	declare deviceCursor CURSOR FOR

	SELECT deviceId, nodesPerBlock from @tblHostBlock

	declare @i int = 1

	declare @deviceId int = 0

	declare @nodesBlock int  = 0

	OPEN deviceCursor

	FETCH NEXT FROM deviceCursor INTO @deviceId, @nodesBlock

	WHILE @@FETCH_STATUS = 0

	BEGIN

		set @i = 0

		WHILE (EXISTS( (SELECT 1 from @tblHostBlock where blockNum = 0 and deviceId = @deviceId)))

		BEGIN

			UPDATE @tblHostBlock

			SET blockNum = @i

			FROM (SELECT TOP (@nodesBlock) hostId FROM @tblHostBlock where blockNum = 0 and deviceId = @deviceId) AS TT, @tblHostBlock T

			WHERE TT.hostId = T.hostId

			SET @i = @i + 1

		END

		FETCH NEXT FROM  deviceCursor INTO @deviceId, @nodesBlock

	END

	CLOSE deviceCursor

	DEALLOCATE deviceCursor

	UPDATE MMDiskHWInfo

	SET blockNumber = T.nodesPerBlock

	FROM MMDiskHWInfo D, @tblHostBlock T, @tblStoragePool S

	WHERE D.deviceId = T.deviceId 

		AND D.hostId = T.hostId 

		AND T.libraryId = S.libraryId
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('30DC48C8-C649-4886-BB1E-53120CC57AE5', 'Scale-out storage pool upgrade script', 'Script to populate the new tables created for scale out storage pool after SP7', @nowTime, 16, 0, 18)

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'BED1204D-8DF0-4657-A692-F48D44B14A64')

BEGIN

	UPDATE MMSDSStoragePool SET Flags |= 2048 --MM_STORAGEPOOLINFO_GLUSTER_SP
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('BED1204D-8DF0-4657-A692-F48D44B14A64', 'Scale-out storage pool upgrade script', 'Script to update flag values for existing storage pools after upgrading to SP20', @nowTime, 16, 0, 20)

END

