

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/MMProcsToRun.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2017 CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/MMProcsToRun.script,v $ $Id: MMProcsToRun.script,v 1.1.2.7 2020/12/16 21:28:01 chandru Exp $";
-- TABLENAME MMProcsToRun

print '... inserting Table: MMProcsToRun'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME MMProcsToRun

DECLARE @nowTime	INT

SET     @nowTime =  DATEDIFF(SECOND, '01/01/1970', GetUTCdate())

DECLARE @UpgFromRel INT

DECLARE @UpgFromBuild INT

DECLARE @UpgFromSP INT

SELECT @UpgFromRel = CAST(Status AS INTEGER) FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease'

SELECT @UpgFromBuild = CAST(Status AS INTEGER) FROM DBUpgradeSteps WHERE Step = 'UpgradeFromBuild'

SELECT @UpgFromSP = CAST(Status AS INTEGER) FROM DBUpgradeSteps WHERE Step = 'UpgradeFromSPMajor'

DECLARE @SPName varchar (1024)

DECLARE @SPArgs varchar (2048)

DECLARE @checkSum integer

set @checkSum = 0

---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

-- Script file for inserting procs to run in mmprocstorun table.  MM will periodically execute all these procs one after another via MMExecProactiveProcs stored proc.  See that proc for details.

-- !!! Some caveats/rules/guidelines !!!

-- 1 - [SPArgs] values should not have spaces in between the commas

-- 2 - For each proc to run if you want to run in a specific time interval, have those checks and updating of lastattempttime in your proc itself.  Use MMCheckAndTweakDDBPruning as template.

-- 3 - Use LastRunOut for storing anything from the last run of your proc if you'd like to remember something for the next run of your proc.

---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

set @SPName = 'MMCheckAndSubmitMPDefragJob'

set @SPArgs = '2,0'

set @checkSum = isnull (checksum(@SPName, @SPArgs), 0)

IF @checkSum <> 0 AND exists (select 1 from MMProcsToRun where ProcId = @checkSum)

BEGIN

	DELETE FROM MMProcsToRun 

	WHERE	ProcId = @checkSum
END
set @tblRetCode = @@error   
if (@tblRetCode <> 0)
BEGIN
	set @tblRetCode = @@error;
	print 'RETVAL: 98 Table [MMProcsToRun]'
END
-----------------------------------------------------

set @SPName = 'MMCheckAndTweakDDBPruning'

set @SPArgs = '2,0'

set @checkSum = isnull (checksum(@SPName, @SPArgs), 0)

IF @checkSum <> 0 AND not exists (select 1 from MMProcsToRun where ProcId = @checkSum)

BEGIN
	INSERT INTO	MMProcsToRun (SPName, SPArgs, AddTime, LastAttemptTime, LastRunTime, flags, LastRunOut)


	VALUES (@SPName, @SPArgs, @nowTime, 0, 0, 0, '')
END
set @tblRetCode = @@error   
if (@tblRetCode <> 0)
BEGIN
	set @tblRetCode = @@error;
	print 'RETVAL: 01 Table [MMProcsToRun]'
END
-----------------------------------------------------

set @SPName = 'DACallDAPopulateTroubleshootingInfo'

set @SPArgs = '0'

set @checkSum = isnull (checksum(@SPName, @SPArgs), 0)

IF @checkSum <> 0 AND not exists (select 1 from MMProcsToRun where ProcId = @checkSum)

BEGIN
	INSERT INTO	MMProcsToRun (SPName, SPArgs, AddTime, LastAttemptTime, LastRunTime, flags, LastRunOut)


	VALUES (@SPName, @SPArgs, @nowTime, 0, 0, 0, '')
END
set @tblRetCode = @@error   
if (@tblRetCode <> 0)
BEGIN
	set @tblRetCode = @@error;
	print 'RETVAL: 01 Table [MMProcsToRun]'
END
-----------------------------------------------------

set @SPName = 'archMarkJobsDoNotCopy'

set @SPArgs = '2,0'

set @checkSum = isnull (checksum(@SPName, @SPArgs), 0)

IF @checkSum <> 0 AND not exists (select 1 from MMProcsToRun where ProcId = @checkSum)

BEGIN
	INSERT INTO	MMProcsToRun (SPName, SPArgs, AddTime, LastAttemptTime, LastRunTime, flags, LastRunOut)


	VALUES (@SPName, @SPArgs, @nowTime, 0, 0, 0, '')
END
set @tblRetCode = @@error   
if (@tblRetCode <> 0)
BEGIN
	set @tblRetCode = @@error;
	print 'RETVAL: 01 Table [MMProcsToRun]'
END
-----------------------------------------------------

