

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/MMMountPath.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/
-- TABLENAME MMMountPath

print '... inserting Table: MMMountPath'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME MMMountPath

-- set physical pruning enabled for all mount paths for a release to release upgrade only.

DECLARE @40TB INT = 41943040 -- 40 TB is the max reserve space to set

IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[DBUpgradeSteps]') and OBJECTPROPERTY(id, N'IsTable') = 1) 

BEGIN

IF EXISTS(SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' AND CAST(Status AS INTEGER) <= 15)

		BEGIN

			UPDATE MMMountPath

SET Attribute = Attribute | 8

			WHERE MountPathId > 0

		END

END

DECLARE @nowTime INTEGER = DATEDIFF(second, '01/01/1970', GETUTCDATE())

-- for hyperscale mount paths, set the reserve space to minimum between 40TB and 4% of total capacity.

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '31703DEC-BD27-4539-8A61-599D22833E97')

BEGIN

IF EXISTS(SELECT 1 FROM MMMountPath WHERE Attribute & 64 = 64)

	BEGIN		

		UPDATE MP

		SET MP.MagneticSpaceRsrvInMB =				(

														CEILING(

																( CASE WHEN MP.MagneticSpaceRsrvInMB < MS.TotalSpaceMB/25 THEN 

																	(CASE WHEN MS.TotalSpaceMB/25 > @40TB THEN @40TB ELSE MS.TotalSpaceMB/25 END)

																ELSE 

																	(CASE WHEN MP.MagneticSpaceRsrvInMB > @40TB THEN @40TB ELSE MP.MagneticSpaceRsrvInMB END) 

																END)

														/1024.0/1024.0) -- round to next TB

													)*1024*1024

		FROM  MMMountPath MP(NOLOCK), MMMediaSide MS(NOLOCK)

		WHERE MP.MediaSideId = MS.MediaSideId

AND   MP.Attribute & 64 = 64

	END
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('31703DEC-BD27-4539-8A61-599D22833E97', 'SetRsrvSpaceForHyperScaleMP', 'Update script to set reserve space of hyperscale mountpath to minimum of 40TB or 4% of total capacity', @nowTime, 16, 0, 18)

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '9259F5A2-FFBB-4751-B5C7-6AC113715E96')

BEGIN

	UPDATE MP

SET MP.Attribute = MP.Attribute | 8192

	FROM MMMountPath MP

	WHERE MP.MaxConcurrentWriters = 0
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('9259F5A2-FFBB-4751-B5C7-6AC113715E96', 'UpdateDisabledMountPathAttributes', 'Script to prevent MountPath references when it is disabled for new writes', @nowTime, 16, 0, (16 + 3))

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'A01D39B9-1E29-4948-849A-61DF361CC86E')

BEGIN

	UPDATE MP

SET MP.Attribute = MP.Attribute & ~(128)

	FROM MMMountPath MP

WHERE MP.Attribute & (64 | 128 | 1024) = (64 | 128 | 1024)
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('A01D39B9-1E29-4948-849A-61DF361CC86E', 'DisableDrillHoleForGluster', 'Script to prevent MountPath drillholes for Gluster MP', @nowTime, 16, 0, (16 + 3))

END

-- for HyperScaleX mount paths, set the reserve space to minimum between 40TB and 3% of total capacity.

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'AA015F3F-6D3B-4299-98F0-C28196B18866')

BEGIN

IF EXISTS(SELECT 1 FROM MMMountPath WHERE Attribute & 64 = 64)

	BEGIN

		;WITH MP_CTE(MountPathId, MagneticSpaceComputed)

		AS

		(

			SELECT MP.MountPathId, (CEILING(

											( CASE WHEN MP.MagneticSpaceRsrvInMB < MS.TotalSpaceMB/33 THEN 

												(CASE WHEN MS.TotalSpaceMB/33 > @40TB THEN @40TB ELSE MS.TotalSpaceMB/33 END)

											ELSE 

												(CASE WHEN MP.MagneticSpaceRsrvInMB > @40TB THEN @40TB ELSE MP.MagneticSpaceRsrvInMB END) 

											END)

									/1024.0/1024.0) -- round to next TB

								)*1024*1024

			FROM  MMMountPath MP(NOLOCK)

			INNER JOIN MMMediaSide MS(NOLOCK) ON MP.MediaSideId = MS.MediaSideId

			INNER JOIN MMSDSStoragePool SDS(NOLOCK) ON MP.LibraryId = SDS.LibraryId

WHERE MP.Attribute  & 64 = 64

AND SDS.Flags & 4096 = 4096

		)

		UPDATE MP

		SET MP.MagneticSpaceRsrvInMB = CASE WHEN MP.MagneticSpaceRsrvInMB < T.MagneticSpaceComputed

											THEN MP.MagneticSpaceRsrvInMB

											ELSE T.MagneticSpaceComputed

									END

		FROM  MMMountPath MP(NOLOCK)

		INNER JOIN MP_CTE T(NOLOCK) ON MP.MountPathId = T.MountPathId

	END
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('AA015F3F-6D3B-4299-98F0-C28196B18866', 'SetRsrvSpaceForHyperScaleXMP', 'Update script to set reserve space of HyperScale X mountpath to minimum of 40TB or 3% of total capacity', @nowTime, 16, 0, 25)

END

