

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/MMHost.script] ---------- 


SET QUOTED_IDENTIFIER ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2015  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

DECLARE @nowTime INTEGER = DATEDIFF(second, '01/01/1970', GETUTCDATE())

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'c09b0484-597d-47f4-8a1f-73d873c9f2c1')

BEGIN

    UPDATE MMHost

SET Attribute = Attribute | 512 | 256

    WHERE ClientId > 1
    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('c09b0484-597d-47f4-8a1f-73d873c9f2c1', 'SetMediaCRCOnMAScript', 'Script to set Media CRC option for Media Agents', @nowTime, 16, 0, 17)

END

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = 'a889e5db-3790-4170-9b92-6d207ade78b5')

    BEGIN 

		IF OBJECT_ID('tempdb.dbo.#windowsMediaAgents') IS NOT NULL 

			DROP TABLE #windowsMediaAgents

		CREATE TABLE #windowsMediaAgents (

			clientId					INT PRIMARY KEY

		)
		INSERT INTO #windowsMediaAgents


		SELECT 	DISTINCT CN.id 

		FROM 	MMHOST MH

				LEFT OUTER JOIN APP_VMToPMMap VC ON VC.VMClientId = MH.ClientId

				INNER JOIN App_Client CN ON CN.id = ISNULL(VC.PMClientId, MH.ClientId)

				INNER JOIN SimInstalledPackages PKG ON PKG.ClientId = CN.id

				INNER JOIN simOperatingSystem OS ON CN.simOperatingSystemId = OS.id

				INNER JOIN MMDrivePool MD ON MD.clientId = MH.ClientId

				INNER JOIN MMMountPath MP ON MD.MasterPoolId = MP.MasterPoolId

WHERE 	PKG.simPackageID IN (51, 1301)

                AND (CN.releaseId > 16 OR (CN.releaseId = 16 AND PKG.HighestSP > 6))

				AND OS.Type = 'Windows'

AND MD.DrivePoolType = 10001

				AND MP.MountPathTypeId <> 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/

		-- Remove existing DLP propereries as a safety step.

		DELETE 

		FROM APP_ClientProp

		WHERE componentNameId IN (SELECT clientId FROM #windowsMediaAgents)

		AND (attrName = 'enableDLP' OR attrName = 'dlpEnableAutomaticDecryption')
		INSERT INTO APP_Clientprop


		SELECT clientId,'enableDLP',2,1,@nowTime,0,0 FROM #windowsMediaAgents
		INSERT INTO APP_Clientprop


		SELECT clientId,'dlpEnableAutomaticDecryption',2,1,@nowTime,0,0 FROM #windowsMediaAgents
		INSERT INTO APP_WorkQueueRequest(clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)


        SELECT DISTINCT clientId, -1,11,'',@nowTime,0,0,0 

        FROM #windowsMediaAgents 
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('a889e5db-3790-4170-9b92-6d207ade78b5', 'setDLPPropertiesForMediaAgent', 'Script to set enableDLP and dlpEnableAutomaticDecryption for Windows MediaAgents ', @nowTime, 16, 0, 16+1)

   END

