

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/MMDeletedAF.script] ---------- 


SET QUOTED_IDENTIFIER ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2015  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '90c783a9-f296-4b88-a956-43a31caa8abb')

BEGIN

    DECLARE @ErrVal INTEGER = 0

    DECLARE @RowCount INTEGER = 0

    DECLARE @maxRowsToPruneInBatch  INTEGER = 2000

    SELECT  @maxRowsToPruneInBatch = ISNULL(value, 2000)

    FROM    MMConfigs WITH (READUNCOMMITTED)

    WHERE   name = 'DA_CONFIG_MAX_JOB_HISTORIES_TO_PRUNE_IN_BATCH'

    DECLARE @nowTime INTEGER = DATEDIFF(second, '01/01/1970', GETUTCDATE())

    -- we are executing below on v11 only so no additional version check is needed.

    WHILE (1 = 1)

    BEGIN

	DELETE TOP (@maxRowsToPruneInBatch) D

	FROM MMDeletedAF D 

		INNER JOIN MMVolume V WITH (READUNCOMMITTED) ON D.VolumeId = V.VolumeId

		INNER JOIN MMMountPath M WITH (READUNCOMMITTED) ON V.MediaSideId = M.MediaSideId

WHERE (D.Status & 256) > 0

	AND V.VolumeFlags = 6 -- VOL_RECYCLE

	AND M.MountPathTypeId = 7 -- MOUNT_PATH_EXTERNAL_REMOTE_HOST

AND (M.Attribute & 32) = 0

	AND V.SIDBStoreId > 0

	SELECT @ErrVal = @@ERROR,  @RowCount = @@ROWCOUNT

	IF @ErrVal <> 0

	BEGIN

		BREAK

	END

	IF @RowCount = 0

		BREAK

    END
    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('90c783a9-f296-4b88-a956-43a31caa8abb', 'CleanupMMDAFForNonMicroPruneCloudScript', 'Cleanup script to clean MMDeletedAF for non-microprune cloud mountpaths', @nowTime, 16, 0, 17)

END

