

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/MMDatapath.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2015  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

DECLARE @curTime BIGINT = DATEDIFF(second, '01/01/1970', GetUTCdate())    

UPDATE D 

SET IsHardwareCompressed = 0 

FROM MMDatapath D 

JOIN MMDrivePool DP 

    ON D.DrivePoolId = DP.DrivePoolId

WHERE DP.DrivePoolType = 10001

    AND D.IsHardwareCompressed = 1

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = '93B7EB77-DAA5-40DF-B46E-65252AD31153')

BEGIN

    --Reset chunksize to default for cloud datapaths whose size is set by user to low value. There will be GUI change to not allow less than 1 GB going forward

	UPDATE DP SET ChunksizeMB = 0

	FROM MMDataPath DP INNER JOIN MMDrivePool DPOOL WITH(NOLOCK) ON DP.DrivePoolId = DPOOL.DrivePoolId

	INNER JOIN MMMountPath MP WITH(NOLOCK) ON DPOOL.MasterPoolId = MP.MasterPoolId

	WHERE MP.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/ AND DP.ChunkSizeMB < 1024 AND DP.ChunkSizeMB > 0
    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('93B7EB77-DAA5-40DF-B46E-65252AD31153', 'ResetCloudDataPathChunkSize', 'Update script to change the cloud datapaths with low chunk size set by user to default size', @curTime, 16, 0, 18)

END 

