

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/MMCloudStorageArchiveRecall.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @guid nvarchar(256)

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.36.4.3 $'

SET @name = 'Cloud Storage Archive Recall'

SET @description = 'Performs recall of archived data for Cloud storage'

SET @version = 1

SET @flags = 2/*AUTODEPLOY*/|4/*CV_WORKFLOW*/|8/*READONLY*/

SET @guid = 'bcfb82c7-a1e6-490d-bc4a-d455c21fc11e'

SET @definition = '<workflow apiMode="0" config="&lt;configuration /&gt;" description="Performs recall of archived data for Cloud storage" executeOnWeb="0" inputs="&lt;inputs&gt;&lt;bIndexOnlyRecall class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/bIndexOnlyRecall&gt;&lt;job_id class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;&amp;lt;JOB ID&amp;gt;&lt;/job_id&gt;&lt;ignore_jpr class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/ignore_jpr&gt;&lt;retry_interval_mins class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;0&lt;/retry_interval_mins&gt;&lt;amazonLine class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;amazonString class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;recall_period class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;7&lt;/recall_period&gt;&lt;recall_mode class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;0&lt;/recall_mode&gt;&lt;azureLine class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;azureString class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;move_back_data class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/move_back_data&gt;&lt;recall_mode_azure class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;0&lt;/recall_mode_azure&gt;&lt;/inputs&gt;" interactive="1" isHtmlDescription="0" manualPercentageComplete="0" name="Cloud Storage Archive Recall" outputs="&lt;outputs /&gt;" revision="$Revision: 1.1.2.36.4.3 $" tags="" uniqueGuid="30371c38-37f1-4c5e-b323-7fbeff1fb36e" variables="&lt;variables&gt;&lt;bPreConditionSuccess class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/bPreConditionSuccess&gt;&lt;sCSIntance class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;iJobId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;0&lt;/iJobId&gt;&lt;iJobOption class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;0&lt;/iJobOption&gt;&lt;iSkipJobStatus class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;bFinalizeRecallSettingsSuccess class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/bFinalizeRecallSettingsSuccess&gt;&lt;bJobRunning class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/bJobRunning&gt;&lt;iAppType class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;iDebugMode class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;sRecallData class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;iThreadRowNumber class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;0&lt;/iThreadRowNumber&gt;&lt;sRecallCommandInfo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;bRecallSuccess class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;true&lt;/bRecallSuccess&gt;&lt;bCheckBrowseAndRestoreProcessSuccess class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/bCheckBrowseAndRestoreProcessSuccess&gt;&lt;sWarning class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;iRetryInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;bRecallFail class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/bRecallFail&gt;&lt;bNoDataOnCloud class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/bNoDataOnCloud&gt;&lt;sFailedMPList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt; &lt;/sFailedMPList&gt;&lt;bFailedMP class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/bFailedMP&gt;&lt;bRestoreJobFailed class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/bRestoreJobFailed&gt;&lt;sRestoreFailedRvMA class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;bWfCancel class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/bWfCancel&gt;&lt;vsav1 class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;0&lt;/vsav1&gt;&lt;iBkpType class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;JM_CLOUD_RECALL_WF_ID class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;101&lt;/JM_CLOUD_RECALL_WF_ID&gt;&lt;/variables&gt;" webHidden="0" workflowId="101">

  <schema>

    <inputs attribute="0" className="" name="inputs" type="">

      <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="Backup JobId" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="job_id" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.Boolean" controlHidden="0" controlType="5" defaultValue="" displayName="Ignore JPR" documentation="" hidden="0" inputType="java.lang.Boolean" listType="0" maximumValue="" minimumValue="" name="ignore_jpr" readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean" />

      <children attribute="0" className="java.lang.Integer" controlHidden="0" controlType="2" defaultValue="" displayName="Recall Monitoring Interval" documentation="Interval between checking for recall status (Ideally the approximate time taken to recall data from archive storage for the vendor. NOTE: Aggressive polling can lead to increased cost)" hidden="0" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" name="retry_interval_mins" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer">

        <options val="0" />

        <options val="5" />

        <options val="15" />

        <options val="60" />

        <options val="240" />

        <options val="480" />

        <options val="720" />

        <options val="1440" />

        <options val="2880" />

        <labelsForOptions val="Default" />

        <labelsForOptions val="5 mins" />

        <labelsForOptions val="15 mins" />

        <labelsForOptions val="1 hour" />

        <labelsForOptions val="4 hours" />

        <labelsForOptions val="8 hours" />

        <labelsForOptions val="12 hours" />

        <labelsForOptions val="24 hours" />

        <labelsForOptions val="48 hours" />

      </children>

      <children attribute="0" className="java.lang.String" controlHidden="0" controlType="3" defaultValue="" displayName=" " documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="amazonLine" readOnly="1" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlHidden="0" controlType="3" defaultValue="" displayName="AWS Settings:" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="amazonString" readOnly="1" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.Integer" controlHidden="0" controlType="0" defaultValue="" displayName="Retention Days" documentation="Days to retain data on S3 for access after which they will be removed" hidden="0" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" name="recall_period" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="java.lang.Integer" controlHidden="0" controlType="2" defaultValue="" displayName="Retrieval option" documentation="The mode to retrieve data from Glacier to S3. Cost will differ based on the mode selected." hidden="0" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" name="recall_mode" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer">

        <options val="0" />

        <options val="1" />

        <options val="2" />

        <labelsForOptions val="Standard" />

        <labelsForOptions val="Expedited (Higher recall cost)" />

        <labelsForOptions val="Bulk" />

      </children>

      <children attribute="0" className="java.lang.String" controlHidden="0" controlType="3" defaultValue="" displayName=" " documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="azureLine" readOnly="1" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlHidden="0" controlType="3" defaultValue="" displayName="Azure Settings:" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="azureString" readOnly="1" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.Boolean" controlHidden="0" controlType="5" defaultValue="" displayName="Auto-archive recalled files on restore job completion" documentation="" hidden="0" inputType="java.lang.Boolean" listType="0" maximumValue="" minimumValue="" name="move_back_data" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean" />

      <children attribute="0" className="java.lang.Integer" controlHidden="0" controlType="2" defaultValue="" displayName="Retrieval option" documentation="The mode to retrieve data from Archive Tier. Cost will differ based on the mode selected." hidden="0" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" name="recall_mode_azure" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer">

        <options val="0" />

        <options val="1" />

        <labelsForOptions val="Standard Priority" />

        <labelsForOptions val="High Priority" />

      </children>

      <children attribute="0" className="java.lang.Boolean" controlHidden="0" controlType="5" defaultValue="" displayName="Recall only index files" documentation="With this option selected, only data required to browse is recalled" hidden="0" inputType="java.lang.Boolean" listType="0" maximumValue="" minimumValue="" name="bIndexOnlyRecall" readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean" />

    </inputs>

    <variables attribute="0" className="" name="variables" type="">

      <children attribute="0" className="java.lang.Boolean" controlType="5" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Boolean" listType="0" name="bPreConditionSuccess" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sCSIntance" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="iJobId" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="iJobOption" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="iSkipJobStatus" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="java.lang.Boolean" controlType="5" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Boolean" listType="0" name="bFinalizeRecallSettingsSuccess" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean" />

      <children attribute="0" className="java.lang.Boolean" controlType="5" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Boolean" listType="0" name="bJobRunning" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean" />

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="iAppType" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="iDebugMode" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sRecallData" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="iThreadRowNumber" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sRecallCommandInfo" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="bRecallSuccess" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.Boolean" controlType="5" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Boolean" listType="0" name="bCheckBrowseAndRestoreProcessSuccess" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sWarning" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="iRetryInterval" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="java.lang.Boolean" controlType="5" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Boolean" listType="0" name="bRecallFail" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean" />

      <children attribute="0" className="java.lang.Boolean" controlType="5" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Boolean" listType="0" name="bNoDataOnCloud" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sFailedMPList" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.Boolean" controlType="5" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Boolean" listType="0" name="bFailedMP" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean" />

      <children attribute="0" className="java.lang.Boolean" controlType="5" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Boolean" listType="0" name="bRestoreJobFailed" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" hidden="0" inputType="java.lang.String" listType="0" name="sRestoreFailedRvMA" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.Boolean" controlType="5" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Boolean" listType="0" name="bWfCancel" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean" />

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="vsav1" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" hidden="0" inputType="java.lang.Integer" listType="0" name="iBkpType" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="JM_CLOUD_RECALL_WF_ID" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

    </variables>

    <outputs className="" name="outputs" type="" />

    <config attribute="0" className="" name="configuration" type="" />

  </schema>

  <formProperties css="" formVersion="0" javaScript="" pageMode="0">

    <rules />

  </formProperties>

  <Start commented="0" continueOnFailure="0" created="0" description="" displayName="Start" height="36" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="image;image=/images/jgraphx/house.png" uniqueName="Start_1" waitSetting="0" width="58" x="38" y="89">

    <inputs val="&lt;inputs /&gt;" />

    <transition activity="ImpersonateCreator_4" commented="0" description="" originalStyle="" points="" sourceX="67" sourceY="107" status="0" style="defaultEdge" targetX="377" targetY="112" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Start>

  <Activity commented="0" continueOnFailure="0" created="1573501569982" description="executes a defined process block within the workflow" displayName="Check Pre-conditions" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#85E0E0;gradientColor=#85E0E0" uniqueName="ExecuteProcessBlock_3" waitSetting="0" width="152" x="134" y="90">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs name="ProcessBlock_2">

        <children name="Start_3" />

        <children name="CommServDBQuery_1" type="">

          <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                <options val="GALAXY" />

                <options val="NBU" />

                <options val="NETAPP" />

                <options val="TSM" />

                <options val="VEEAM" />

              </children>

              <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

              <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

              <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

          </children>

          <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="WorkflowEnd_2" />

        <children name="Script_3">

          <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        </children>

        <children name="CommServDBQuery_5" type="">

          <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                <options val="GALAXY" />

                <options val="NBU" />

                <options val="NETAPP" />

                <options val="TSM" />

                <options val="VEEAM" />

              </children>

              <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

              <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

              <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

          </children>

          <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="WorkflowEnd_4" />

        <children name="Decision_1" />

        <children name="WorkflowEnd_5" />

        <children name="WorkflowEnd_6" />

        <children name="DisableLogging_2" />

        <children name="Decision_3" />

        <children name="Script_41">

          <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        </children>

        <children name="Script_42">

          <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        </children>

        <children name="Script_43">

          <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        </children>

        <children name="EnableLogging_11" />

        <children name="DisableLogging_19" />

        <children name="DisableLogging_20" />

        <children name="DisableLogging_21" />

        <children name="DisableLogging_22" />

        <children name="DisableLogging_23" />

        <children name="ExecuteProcessBlock_33">

          <children name="Start_9" />

          <children name="CommServDBQuery_6" type="">

            <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                  <options val="GALAXY" />

                  <options val="NBU" />

                  <options val="NETAPP" />

                  <options val="TSM" />

                  <options val="VEEAM" />

                </children>

                <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

            </children>

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="Script_6">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="ExecuteCommand_2">

            <children className="java.lang.Integer" documentation="the exitCode recieved from executing the command" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Integer" documentation="the return code recieved from completion of the command" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" documentation="the output from the command or error message if it failed" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="Script_8">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="DisableLogging_3" />

          <children name="EnableLogging_2" />

          <children name="Decision_5" />

          <children name="EnableLogging_8" />

          <children name="DisableLogging_9" />

        </children>

        <children name="Script_182">

          <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        </children>

        <children name="DisableLogging_51" />

        <children name="WorkflowEnd_28" />

      </outputs>

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;processBlock&gt;ProcessBlock_2&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

    <transition activity="ExecuteProcessBlock_14" commented="0" description="" displayName="Success" originalStyle="" points="" sourceX="236" sourceY="107" status="0" style="defaultEdge" targetX="422" targetY="107" transitionIndex="0" x="15" y="34">

      <condition language="1" script="true == xpath:{/workflow/variables/bPreConditionSuccess}" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1573501694229" description="creates a super process group" displayName="Check Pre-conditions" height="270" interactive="0" jobMode="0" name="ProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#85E0E0;gradientColor=#85E0E0" uniqueName="ProcessBlock_2" waitSetting="0" width="2476" x="58" y="430">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs className="" defaultValue="" listType="0" name="outputs" type="" />

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1573501694229" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_3" waitSetting="0" width="61" x="23" y="71">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="ExecuteProcessBlock_33" commented="0" description="" originalStyle="" points="" sourceX="53" sourceY="74" status="0" style="defaultEdge" targetX="210" targetY="76" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1573502331086" description="executes queries against a commcell database" displayName="Check workflow deployed" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_1" waitSetting="0" width="176" x="911" y="69">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @dep_ver int = (select top 1 version from WF_Deploy(nolock) where WorkflowId = xpath:{/workflow/system/workflow/workflowId} order by Deployed desc)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @ins_ver int = 0;&amp;#xD;&#xD;&#xA;declare @ins_revision varchar(max) = ''''&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select @ins_ver = version,&amp;#xD;&#xD;&#xA;&#x9;@ins_revision = isnull(revision, '''')&amp;#xD;&#xD;&#xA;from WF_Definition(nolock)&amp;#xD;&#xD;&#xA;where WorkflowId = xpath:{/workflow/system/workflow/workflowId}&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select @ins_ver version, @dep_ver deployed, @ins_revision revision&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="Script_41" commented="0" description="" originalStyle="" points="" sourceX="895" sourceY="86" status="0" style="defaultEdge" targetX="1116" targetY="148" transitionIndex="0" x="139" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1573502468931" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_2" waitSetting="0" width="106" x="1180" y="225">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Failure Reason: Workflow is not deployed on the latest installed version [ver: xpath:{/workflow/CommServDBQuery_1/resultSets[1]/row[1]/col[1]}]. Current deployed version is [ver: xpath:{/workflow/CommServDBQuery_1/resultSets[1]/row[1]/col[2]}]. Please deploy the workflow and try again.&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1573506142983" description="activity to execute code snippets in the selected language" displayName="Pre-condition check completed" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_3" waitSetting="0" width="200" x="2038" y="69">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    int iJobId = xpath:{/workflow/CommServDBQuery_5/resultSets[1]/row[1]/col[@name=&amp;quot;jobId&amp;quot;]};&amp;#xD;&amp;#xA;    int iJobOption = xpath:{/workflow/CommServDBQuery_5/resultSets[1]/row[1]/col[@name=&amp;quot;jobOption&amp;quot;]};&amp;#xD;&amp;#xA;    int iAppType = xpath:{/workflow/CommServDBQuery_5/resultSets[1]/row[1]/col[@name=&amp;quot;appType&amp;quot;]};&amp;#xD;&amp;#xA;    int iBkpType = xpath:{/workflow/CommServDBQuery_5/resultSets[1]/row[1]/col[@name=&amp;quot;bkpType&amp;quot;]};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;iJobId&amp;quot;, iJobId);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;iJobOption&amp;quot;, iJobOption);    &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;iAppType&amp;quot;, iAppType);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;iBkpType&amp;quot;, iBkpType);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;sRestoreFailedRvMA&amp;quot;,&amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String sJobType = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    switch(iJobOption)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        case 1001:&amp;#xD;&amp;#xA;            sJobType = &amp;quot;Browse and Restore&amp;quot;;&amp;#xD;&amp;#xA;            break;&amp;#xD;&amp;#xA;        case 1005:&amp;#xD;&amp;#xA;            sJobType = &amp;quot;Restore by Job&amp;quot;;&amp;#xD;&amp;#xA;            break;        &amp;#xD;&amp;#xA;        case 2:&amp;#xD;&amp;#xA;            sJobType = &amp;quot;Backup&amp;quot;;&amp;#xD;&amp;#xA;            break;&amp;#xD;&amp;#xA;        case 4036:&amp;#xD;&amp;#xA;            sJobType = &amp;quot;DDB Reconstruction&amp;quot;;&amp;#xD;&amp;#xA;            break;&amp;#xD;&amp;#xA;        case 12:&amp;#xD;&amp;#xA;            sJobType = &amp;quot;Index Restore&amp;quot;;&amp;#xD;&amp;#xA;            break;&amp;#xD;&amp;#xA;        default:&amp;#xD;&amp;#xA;            sJobType = &amp;quot;Unknown&amp;quot;; //Should not be hitting this code&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;Input jobId = [&amp;quot; + workflow.getVariable(&amp;quot;iJobId&amp;quot;) + &amp;quot;] jobType = [&amp;quot; + sJobType + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;bPreConditionSuccess&amp;quot;, true);&amp;#xD;&amp;#xA;} &amp;#xD;&amp;#xA;catch(e) {&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to check pre-conditions. Exception &amp;quot; + e);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;bPreConditionSuccess&amp;quot;, false);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_22" commented="0" description="" originalStyle="" points="" sourceX="1974" sourceY="86" status="0" style="defaultEdge" targetX="2175" targetY="86" transitionIndex="0" x="139" y="0" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1573509355741" description="executes queries against a commcell database" displayName="Check JobId Valid" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_5" waitSetting="0" width="143" x="1359" y="69">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @jobId int =  ISNULL(TRY_CAST(''xpath:{/workflow/inputs/job_id}'' as int), 0);&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @jobOption int = 0;&amp;#xD;&#xD;&#xA;declare @appType int = 0;&amp;#xD;&#xD;&#xA;declare @bkpType int = 0;&amp;#xD;&#xD;&#xA;select @jobOption = ISNULL([140018], 0),&amp;#xD;&#xD;&#xA;        @appType = ISNULL([140004], 0)&amp;#xD;&#xD;&#xA;from ( select value,optionId&amp;#xD;&#xD;&#xA;       from dbo.GetAllJobOptions(@jobid))&amp;#xD;&#xD;&#xA;       as SourceTable pivot (&amp;#xD;&#xD;&#xA;       max(value) for optionid in ([140018], [140004]))&amp;#xD;&#xD;&#xA;       as pivottable;&amp;#xD;&#xD;&#xA;--for older backup jobs, joboptions might not have the values&amp;#xD;&#xD;&#xA;if @jobOption = 0 and exists(select 1 from JMBkpStats where jobId = @jobId)&amp;#xD;&#xD;&#xA;   select top 1 @appType = appType, @jobOption = 2, @bkpType = bkplevel&amp;#xD;&#xD;&#xA;   from JMBkpStats where jobId = @jobId&amp;#xD;&#xD;&#xA;   order by commcellId &amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;--Feature enabled by default &amp;gt;= SP23&amp;#xD;&#xD;&#xA;declare @autoRecallEnabled int = 1&amp;#xD;&#xD;&#xA;IF EXISTS(SELECT 1&amp;#xD;&#xD;&#xA;   FROM GxGlobalParam&amp;#xD;&#xD;&#xA;   WHERE name = ''EnableAutoCloudIndexRecall''&amp;#xD;&#xD;&#xA;        AND modified = 0&amp;#xD;&#xD;&#xA;        AND value = ''false'')&amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;    set @autoRecallEnabled = 0&amp;#xD;&#xD;&#xA;END&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if @autoRecallEnabled = 1&amp;#xD;&#xD;&#xA;begin&amp;#xD;&#xD;&#xA;    --for index restore jobs&amp;#xD;&#xD;&#xA;    if @jobOption = 0&amp;#xD;&#xD;&#xA;    begin&amp;#xD;&#xD;&#xA;       select top 1 @jobOption = opType from JMJobInfo(READUNCOMMITTED) where jobId = @jobId&amp;#xD;&#xD;&#xA;       if @jobOption = 0&amp;#xD;&#xD;&#xA;       begin&amp;#xD;&#xD;&#xA;           select top 1 @jobOption = opType from JMRestoreStats(READUNCOMMITTED) where jobId = @jobId&amp;#xD;&#xD;&#xA;       end&amp;#xD;&#xD;&#xA;    end   &amp;#xD;&#xD;&#xA;end&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select  @jobId jobId,&amp;#xD;&#xD;&#xA;        @appType appType,&amp;#xD;&#xD;&#xA;        @jobOption jobOption,&amp;#xD;&#xD;&#xA;        @bkpType bkpType&amp;#xD;&#xD;&#xA;        &amp;#xD;&#xD;&#xA;------------------------------------------------------&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @ccId int&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @WfJID int = xpath:{/workflow/system/jobId};&amp;#xD;&#xD;&#xA;declare @existingWfJID int = 0&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;--0 = n/a&amp;#xD;&#xD;&#xA;--1 = insert&amp;#xD;&#xD;&#xA;--2 = update&amp;#xD;&#xD;&#xA;--3 = already associated to current job&amp;#xD;&#xD;&#xA;--4 = already associated to another job&amp;#xD;&#xD;&#xA;declare @changeType int = 0 &amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if @jobOption IN(12/*INDEXRESTORE*/, 1001/*TASK_OPERATION_TYPE_RESTORE*/, 1005/*TASK_OPERATION_TYPE_RESTORE_BY_JOB*/)&amp;#xD;&#xD;&#xA;begin&amp;#xD;&#xD;&#xA;&#x9;select @ccId = id&amp;#xD;&#xD;&#xA;&#x9;from app_client(nolock)&amp;#xD;&#xD;&#xA;&#x9;where name = ''xpath:{/workflow/system/commCellName}'';&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;select top 1 @existingWfJID = attributeValueInt&amp;#xD;&#xD;&#xA;&#x9;from JMJobOptions(READUNCOMMITTED)&amp;#xD;&#xD;&#xA;&#x9;where attributeId = xpath:{/workflow/variables/JM_CLOUD_RECALL_WF_ID}&amp;#xD;&#xD;&#xA;&#x9;and jobId = @jobId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;if @existingWfJID = 0&amp;#xD;&#xD;&#xA;&#x9;begin&amp;#xD;&#xD;&#xA;&#x9;&#x9;INSERT INTO JMJobOptions(jobId, commCellId, attributeid, attributeName, attributeValueInt, attributeValue)&amp;#xD;&#xD;&#xA;        VALUES(@jobId, @ccId, xpath:{/workflow/variables/JM_CLOUD_RECALL_WF_ID}, ''Cloud Recall Workflow JobId'', @wfJID, '''');&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;&#x9;SET @changeType = 1&amp;#xD;&#xD;&#xA;&#x9;end&amp;#xD;&#xD;&#xA;&#x9;else&amp;#xD;&#xD;&#xA;&#x9;begin&amp;#xD;&#xD;&#xA;&#x9;&#x9;if not exists (select 1 from JMJobInfo where jobId = @existingWfJID)&amp;#xD;&#xD;&#xA;&#x9;&#x9;begin&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;UPDATE JMJobOptions&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;SET attributeValueInt = @wfJID&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;WHERE jobId = @jobId&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;AND attributeid = xpath:{/workflow/variables/JM_CLOUD_RECALL_WF_ID}&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;SET @changeType = 2&amp;#xD;&#xD;&#xA;&#x9;&#x9;end&amp;#xD;&#xD;&#xA;&#x9;&#x9;else &amp;#xD;&#xD;&#xA;        begin&amp;#xD;&#xD;&#xA;            if @wfJID = @existingWfJID&amp;#xD;&#xD;&#xA;                SET @changeType = 3&amp;#xD;&#xD;&#xA;            else&amp;#xD;&#xD;&#xA;              SET @changeType = 4&amp;#xD;&#xD;&#xA;        end&amp;#xD;&#xD;&#xA;&#x9;end&amp;#xD;&#xD;&#xA;end&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select @WfJID wfJID, @existingWfJID existingWfJID, @changeType changeType&amp;#xD;&#xD;&#xA;&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="Script_42" commented="0" description="" originalStyle="" points="" sourceX="1430" sourceY="86" status="0" style="defaultEdge" targetX="1777" targetY="80" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1573509688012" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_4" waitSetting="0" width="108" x="1548" y="213">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Failure Reason: Input JobId [xpath:{/workflow/inputs/job_id}] was invalid.&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1574192976691" description="if/else based decision" displayName="Alert Issue" height="66" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_1" waitSetting="0" width="91" x="434" y="53">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/inputs/job_id}.equals(&quot;&amp;lt;JOB ID&amp;gt;&quot;)&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="Decision_3" commented="0" description="" displayName="Alert is valid" offsetX="-6" offsetY="0" originalStyle="" points="" sourceX="369" sourceY="74" status="0" style="defaultEdge" targetX="538" targetY="75" transitionIndex="0" value="false" x="139" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="DisableLogging_19" commented="0" description="" displayName="Alert needs reconfiguring" offsetX="6" offsetY="0" originalStyle="" points="" sourceX="339" sourceY="74" status="0" style="defaultEdge" targetX="340" targetY="178" transitionIndex="0" value="true" x="139" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1574193099152" description="Ends the workflow" displayName="WorkflowEnd (OS)" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_5" waitSetting="0" width="134" x="415" y="224">

        <onEnter language="1" script="logger.info(&quot;Workflow is missing some required inputs. Please reconfigure the alert which is triggering the workflow.&quot;);" />

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Failure Reason: Workflow is missing some required inputs. Please reconfigure the alert which is triggering the workflow.&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1574285349040" description="Ends the workflow" displayName="WorkflowEnd" height="35" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_6" waitSetting="0" width="106" x="1887" y="212">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Failure Reason: Input JobId [xpath:{/workflow/inputs/job_id}] is not among the supported job types&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1575488421535" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_2" waitSetting="0" width="117" x="737" y="69">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="CommServDBQuery_1" commented="0" description="" originalStyle="" points="" sourceX="555" sourceY="75" status="0" style="defaultEdge" targetX="749" targetY="71" transitionIndex="0" x="139" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1575492306641" description="if/else based decision" displayName="Debug" height="54" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_3" waitSetting="0" width="66" x="628" y="59">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;1 == xpath:{/workflow/variables/iDebugMode}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="CommServDBQuery_5" commented="0" description="" displayName="Debug enabled" offsetX="-17" offsetY="-14" originalStyle="" points="819.0,40.0" sourceX="521" sourceY="74" status="0" style="defaultEdge" targetX="1177" targetY="68" transitionIndex="0" value="true" x="139" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="DisableLogging_2" commented="0" description="" originalStyle="" points="" sourceX="519" sourceY="73" status="0" style="defaultEdge" targetX="662" targetY="81" transitionIndex="0" value="false" x="139" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1576691237487" description="activity to execute code snippets in the selected language" displayName="Check workflow deployed" height="35" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_41" waitSetting="0" width="176" x="1141" y="69">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;int version = xpath:{/workflow/CommServDBQuery_1/resultSets/row/col[@name=&amp;quot;version&amp;quot;]};&amp;#xD;&amp;#xA;int deployed = xpath:{/workflow/CommServDBQuery_1/resultSets/row/col[@name=&amp;quot;deployed&amp;quot;]};&amp;#xD;&amp;#xA;String revision = xpath:{/workflow/CommServDBQuery_1/resultSets/row/col[@name=&amp;quot;revision&amp;quot;]};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(0 == version)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Could not find workflow with Id &amp;quot; + Integer.toString(xpath:{/workflow/system/workflow/workflowId}) + &amp;quot; in the database&amp;quot;);&amp;#xD;&amp;#xA;    //soft failure. As recall might still work&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(version != deployed)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Workflow installed version is &amp;quot; + Integer.toString(version) + &amp;quot; but deployed version is &amp;quot; + Integer.toString(deployed) + &amp;quot;. Deploy the workflow and try again.&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;logger.info(&amp;quot;Workflow deployed on latest installed version [&amp;quot; + Integer.toString(version) + &amp;quot;] Revision [&amp;quot; + revision + &amp;quot;]&amp;quot;); &amp;#xD;&amp;#xA;return true;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="CommServDBQuery_5" commented="0" description="" originalStyle="" points="" sourceX="1125" sourceY="86" status="0" style="defaultEdge" targetX="1282" targetY="88" transitionIndex="0" x="139" y="0">

          <condition language="1" script="true == xpath:{/workflow/Script_41/output}" />

        </transition>

        <transition activity="DisableLogging_20" commented="0" description="" displayName="Not deployed" originalStyle="" points="" sourceX="1125" sourceY="86" status="0" style="defaultEdge" targetX="1122" targetY="182" transitionIndex="0" x="139" y="0">

          <condition language="1" script="false == xpath:{/workflow/Script_41/output}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1576696065108" description="activity to execute code snippets in the selected language" displayName="Check JobId Valid" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_42" waitSetting="0" width="131" x="1535" y="69">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/CommServDBQuery_5/resultSets[1]/row[1]/col[@name=&amp;quot;jobId&amp;quot;]} == 0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Input JobId [&amp;quot; + xpath:{/workflow/inputs/job_id} + &amp;quot;] was invalid.&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;return true;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_21" commented="0" description="" displayName="Non integral jobId" originalStyle="" points="" sourceX="1562" sourceY="116" status="0" style="defaultEdge" targetX="1346" targetY="195" transitionIndex="0" x="134" y="-1">

          <condition language="1" script="false == xpath:{/workflow/Script_42/output}" />

        </transition>

        <transition activity="Script_182" commented="0" description="" originalStyle="" points="" sourceX="1498" sourceY="86" status="0" style="defaultEdge" targetX="1671" targetY="86" transitionIndex="0" x="134" y="-1">

          <condition language="1" script="true == xpath:{/workflow/Script_42/output}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1576696177142" description="activity to execute code snippets in the selected language" displayName="Check JobId Valid" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_43" waitSetting="0" width="131" x="1870" y="69">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/CommServDBQuery_5/resultSets[1]/row[1]/col[@name=&amp;quot;jobOption&amp;quot;]} == 0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Input JobId [&amp;quot; + xpath:{/workflow/inputs/job_id} + &amp;quot;] is not among the supported job types&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;return true;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_23" commented="0" description="" displayName="Unsupported Job type" originalStyle="" points="" sourceX="1671" sourceY="86" status="0" style="defaultEdge" targetX="1701" targetY="177" transitionIndex="0" x="134" y="-1">

          <condition language="1" script="false == xpath:{/workflow/Script_43/output}" />

        </transition>

        <transition activity="Script_3" commented="0" description="" originalStyle="" points="" sourceX="1671" sourceY="86" status="0" style="defaultEdge" targetX="1913" targetY="91" transitionIndex="0" x="134" y="-1">

          <condition language="1" script="true == xpath:{/workflow/Script_43/output}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578670620598" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_11" waitSetting="0" width="113" x="275" y="69">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Decision_1" commented="0" description="" originalStyle="" points="" sourceX="216" sourceY="148" status="0" style="defaultEdge" targetX="346" targetY="86" transitionIndex="0" x="139" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578672613174" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_19" waitSetting="0" width="117" x="420" y="169">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="WorkflowEnd_5" commented="0" description="" originalStyle="" points="" sourceX="478" sourceY="186" status="0" style="defaultEdge" targetX="699" targetY="191" transitionIndex="0" x="139" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578672807273" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_20" waitSetting="0" width="117" x="1175" y="159">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="WorkflowEnd_2" commented="0" description="" originalStyle="" points="" sourceX="1231" sourceY="194" status="0" style="defaultEdge" targetX="1426" targetY="193" transitionIndex="0" x="139" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578673361079" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_21" waitSetting="0" width="117" x="1542" y="150">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="WorkflowEnd_4" commented="0" description="" originalStyle="" points="" sourceX="1595" sourceY="185" status="0" style="defaultEdge" targetX="1415" targetY="181" transitionIndex="0" x="139" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578673413607" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_22" waitSetting="0" width="117" x="2079" y="156">

        <inputs val="&lt;inputs /&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578673427126" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_23" waitSetting="0" width="117" x="1880" y="155">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="WorkflowEnd_6" commented="0" description="" originalStyle="" points="" sourceX="1771" sourceY="181" status="0" style="defaultEdge" targetX="1919" targetY="177" transitionIndex="0" x="139" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1575492003264" description="executes a defined process block within the workflow" displayName="Check Debug Mode" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;gradientColor=#BEE0B8;fillColor=#BEE0B8" uniqueName="ExecuteProcessBlock_33" waitSetting="0" width="139" x="112" y="69">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="">

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sRegKey" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sRegFolder" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sResultVariable" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children attribute="0" className="java.lang.Integer" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" name="iDefaultValue" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

          </inputs>

          <outputs name="ProcessBlock_8">

            <children name="Start_9" />

            <children name="CommServDBQuery_6" type="">

              <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                    <options val="GALAXY" />

                    <options val="NBU" />

                    <options val="NETAPP" />

                    <options val="TSM" />

                    <options val="VEEAM" />

                  </children>

                  <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                  <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                  <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

              </children>

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Script_6">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="ExecuteCommand_2">

              <children className="java.lang.Integer" documentation="the exitCode recieved from executing the command" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" documentation="the return code recieved from completion of the command" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" documentation="the output from the command or error message if it failed" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Script_8">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="DisableLogging_3" />

            <children name="EnableLogging_2" />

            <children name="Decision_5" />

            <children name="EnableLogging_8" />

            <children name="DisableLogging_9" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;sRegKey class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;nCloudChunkRecallDebug&lt;/sRegKey&gt;&lt;sRegFolder class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;CommServe&lt;/sRegFolder&gt;&lt;sResultVariable class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;iDebugMode&lt;/sResultVariable&gt;&lt;iDefaultValue class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;0&lt;/iDefaultValue&gt;&lt;/inputs&gt;&lt;processBlock&gt;ProcessBlock_8&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="EnableLogging_11" commented="0" description="" originalStyle="" points="" sourceX="196" sourceY="172" status="0" style="defaultEdge" targetX="319" targetY="97" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1608157172864" description="activity to execute code snippets in the selected language" displayName="Check JobId Valid" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_182" waitSetting="0" width="131" x="1700" y="69">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;int wfJid = xpath:{/workflow/CommServDBQuery_5/resultSets[2]/row[1]/col[@name=&amp;quot;wfJID&amp;quot;]};&amp;#xD;&amp;#xA;int oldWfJid = xpath:{/workflow/CommServDBQuery_5/resultSets[2]/row[1]/col[@name=&amp;quot;existingWfJID&amp;quot;]};&amp;#xD;&amp;#xA;int changeType = xpath:{/workflow/CommServDBQuery_5/resultSets[2]/row[1]/col[@name=&amp;quot;changeType&amp;quot;]};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(4 == changeType)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Recall is already being processed by Workflow JobId [&amp;quot; + Integer.toString(oldWfJid) + &amp;quot;]. Stopping this workflow job.&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(1 == changeType)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Restore job is not being processed by any Workflows. Associated restore job to Workflow JobId [&amp;quot; + Integer.toString(wfJid) + &amp;quot;].&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;else if(2 == changeType)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Previously associated Workflow JobId [&amp;quot; + Integer.toString(oldWfJid) + &amp;quot;] is no longer running. Reassociating restore job to current Workflow JobId [&amp;quot; + Integer.toString(wfJid) + &amp;quot;].&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;else if(3 == changeType)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Current restore job is already associated with this workflow.&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;return true;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="Script_43" commented="0" description="" originalStyle="" points="" sourceX="1765" sourceY="86" status="0" style="defaultEdge" targetX="1927" targetY="86" transitionIndex="0" x="0" y="0">

          <condition language="4" script="true == xpath:{/workflow/Script_182/output}" />

        </transition>

        <transition activity="DisableLogging_51" commented="0" description="" displayName="Already processed" originalStyle="" points="" sourceX="1765" sourceY="86" status="0" style="defaultEdge" targetX="1776" targetY="170" transitionIndex="0" x="0" y="0">

          <condition language="4" script="false == xpath:{/workflow/Script_182/output}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1608157325448" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_51" waitSetting="0" width="117" x="1707" y="150">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="WorkflowEnd_28" commented="0" description="" originalStyle="" points="" sourceX="1765" sourceY="167" status="0" style="defaultEdge" targetX="1767" targetY="230" transitionIndex="0" x="-58" y="-430">

          <condition language="4" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1608157325821" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_28" waitSetting="0" width="108" x="1713" y="213">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Failure Reason: Recall is being processed or already processed by Workflow JobId [xpath:{/workflow/CommServDBQuery_5/resultSets[2]/row[1]/col[@name=&quot;existingWfJID&quot;]}].&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1574194232351" description="executes a defined process block within the workflow" displayName="Finalize recall settings" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#85E0E0;gradientColor=#85E0E0" uniqueName="ExecuteProcessBlock_14" waitSetting="0" width="156" x="363" y="90">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs name="ProcessBlock_7">

        <children name="Start_8" />

        <children name="ExecuteProcessBlock_15">

          <children name="Start_9" />

          <children name="CommServDBQuery_6" type="">

            <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                  <options val="GALAXY" />

                  <options val="NBU" />

                  <options val="NETAPP" />

                  <options val="TSM" />

                  <options val="VEEAM" />

                </children>

                <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

            </children>

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="Script_6">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="ExecuteCommand_2">

            <children className="java.lang.Integer" documentation="the exitCode recieved from executing the command" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Integer" documentation="the return code recieved from completion of the command" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" documentation="the output from the command or error message if it failed" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="Script_8">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="DisableLogging_3" />

          <children name="EnableLogging_2" />

          <children name="Decision_5" />

          <children name="EnableLogging_8" />

          <children name="DisableLogging_9" />

        </children>

        <children name="ExecuteProcessBlock_16">

          <children name="Start_9" />

          <children name="CommServDBQuery_6" type="">

            <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                  <options val="GALAXY" />

                  <options val="NBU" />

                  <options val="NETAPP" />

                  <options val="TSM" />

                  <options val="VEEAM" />

                </children>

                <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

            </children>

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="Script_6">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="ExecuteCommand_2">

            <children className="java.lang.Integer" documentation="the exitCode recieved from executing the command" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Integer" documentation="the return code recieved from completion of the command" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" documentation="the output from the command or error message if it failed" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="Script_8">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="DisableLogging_3" />

          <children name="EnableLogging_2" />

          <children name="Decision_5" />

          <children name="EnableLogging_8" />

          <children name="DisableLogging_9" />

        </children>

        <children name="Script_14">

          <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        </children>

        <children name="EnableLogging_18" />

        <children name="DisableLogging_24" />

      </outputs>

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;processBlock&gt;ProcessBlock_7&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

    <transition activity="ExecuteProcessBlock_17" commented="0" description="" offsetX="3" offsetY="0" originalStyle="" points="" sourceX="489" sourceY="107" status="0" style="defaultEdge" targetX="745" targetY="108" transitionIndex="0" x="17" y="0">

      <condition language="1" script="true == xpath:{/workflow/variables/bFinalizeRecallSettingsSuccess} &amp;&amp; (1001 == xpath:{/workflow/variables/iJobOption} || 1005 == xpath:{/workflow/variables/iJobOption})" />

    </transition>

    <transition activity="ExecuteProcessBlock_21" commented="0" description="" originalStyle="" points="" sourceX="441" sourceY="107" status="0" style="defaultEdge" targetX="833" targetY="155" transitionIndex="0" x="0" y="0">

      <condition language="1" script="true == xpath:{/workflow/variables/bFinalizeRecallSettingsSuccess} &amp;&amp; 2 == xpath:{/workflow/variables/iJobOption}" />

    </transition>

    <transition activity="ExecuteProcessBlock_78" commented="0" description="" originalStyle="" points="" sourceX="441" sourceY="107" status="0" style="defaultEdge" targetX="651" targetY="43" transitionIndex="0" x="0" y="0">

      <condition language="4" script="true == xpath:{/workflow/variables/bFinalizeRecallSettingsSuccess} &amp;&amp; 12 == xpath:{/workflow/variables/iJobOption}" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1574195666431" description="creates a super process group" displayName="Finalize Recall Settings" height="147" interactive="0" jobMode="0" name="ProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#85E0E0;gradientColor=#85E0E0" uniqueName="ProcessBlock_7" waitSetting="0" width="1032" x="59" y="714">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs className="" defaultValue="" listType="0" name="outputs" type="" />

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1574195666431" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_8" waitSetting="0" width="58" x="25" y="65">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="ExecuteProcessBlock_15" commented="0" description="" originalStyle="" points="" sourceX="54" sourceY="80" status="0" style="defaultEdge" targetX="233" targetY="80" transitionIndex="0" x="1" y="-6">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1574359341628" description="executes a defined process block within the workflow" displayName="Check sleep interval override" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;opacity=100;fillColor=#BEE0B8;gradientColor=#BEE0B8" uniqueName="ExecuteProcessBlock_15" waitSetting="0" width="195" x="136" y="63">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="">

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sRegKey" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sRegFolder" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sResultVariable" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children attribute="0" className="java.lang.Integer" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" name="iDefaultValue" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

          </inputs>

          <outputs name="ProcessBlock_8">

            <children name="Start_9" />

            <children name="CommServDBQuery_6" type="">

              <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                    <options val="GALAXY" />

                    <options val="NBU" />

                    <options val="NETAPP" />

                    <options val="TSM" />

                    <options val="VEEAM" />

                  </children>

                  <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                  <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                  <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

              </children>

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Script_6">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="ExecuteCommand_2">

              <children className="java.lang.Integer" documentation="the exitCode recieved from executing the command" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" documentation="the return code recieved from completion of the command" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" documentation="the output from the command or error message if it failed" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Script_8">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="DisableLogging_3" />

            <children name="EnableLogging_2" />

            <children name="Decision_5" />

            <children name="EnableLogging_8" />

            <children name="DisableLogging_9" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;sRegKey class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;nCloudChunkRecallSleepIntervalMins&lt;/sRegKey&gt;&lt;sRegFolder class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;CommServe&lt;/sRegFolder&gt;&lt;iDefaultValue class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;0&lt;/iDefaultValue&gt;&lt;sResultVariable class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;iRetryInterval&lt;/sResultVariable&gt;&lt;/inputs&gt;&lt;processBlock&gt;ProcessBlock_8&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_16" commented="0" description="" originalStyle="" points="" sourceX="233" sourceY="80" status="0" style="defaultEdge" targetX="477" targetY="80" transitionIndex="0" x="1" y="-6">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1574362194527" description="executes a defined process block within the workflow" displayName="Check skip job status override" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;gradientColor=#BEE0B8;fillColor=#BEE0B8" uniqueName="ExecuteProcessBlock_16" waitSetting="0" width="200" x="369" y="63">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="">

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sRegKey" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sRegFolder" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sResultVariable" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children attribute="0" className="java.lang.Integer" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" name="iDefaultValue" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

          </inputs>

          <outputs name="ProcessBlock_8">

            <children name="Start_9" />

            <children name="CommServDBQuery_6" type="">

              <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                    <options val="GALAXY" />

                    <options val="NBU" />

                    <options val="NETAPP" />

                    <options val="TSM" />

                    <options val="VEEAM" />

                  </children>

                  <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                  <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                  <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

              </children>

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Script_6">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="ExecuteCommand_2">

              <children className="java.lang.Integer" documentation="the exitCode recieved from executing the command" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" documentation="the return code recieved from completion of the command" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" documentation="the output from the command or error message if it failed" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Script_8">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="DisableLogging_3" />

            <children name="EnableLogging_2" />

            <children name="Decision_5" />

            <children name="EnableLogging_8" />

            <children name="DisableLogging_9" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;sRegKey class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;nCloudChunkRecallIgnoreJobStatus&lt;/sRegKey&gt;&lt;sRegFolder class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;CommServe&lt;/sRegFolder&gt;&lt;sResultVariable class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;iSkipJobStatus&lt;/sResultVariable&gt;&lt;iDefaultValue class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;0&lt;/iDefaultValue&gt;&lt;/inputs&gt;&lt;processBlock&gt;ProcessBlock_8&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="EnableLogging_18" commented="0" description="" originalStyle="" points="" sourceX="477" sourceY="80" status="0" style="defaultEdge" targetX="675" targetY="80" transitionIndex="0" x="1" y="-6">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1574363600861" description="activity to execute code snippets in the selected language" displayName="Finalize values" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_14" waitSetting="0" width="112" x="756" y="63">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;iRetryInterval = workflow.getVariable(&amp;quot;iRetryInterval&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(0 == iRetryInterval &amp;amp;&amp;amp; 0 != xpath:{/workflow/inputs/retry_interval_mins})&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;iRetryInterval&amp;quot;, xpath:{/workflow/inputs/retry_interval_mins});&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(0 != iRetryInterval) {&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Retry interval manually set to &amp;quot; + iRetryInterval + &amp;quot; mins&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;bFinalizeRecallSettingsSuccess&amp;quot;, true);&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_24" commented="0" description="" originalStyle="" points="" sourceX="812" sourceY="80" status="0" style="defaultEdge" targetX="984" targetY="79" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578673489917" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_18" waitSetting="0" width="113" x="607" y="63">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Script_14" commented="0" description="" originalStyle="" points="" sourceX="660" sourceY="112" status="0" style="defaultEdge" targetX="763" targetY="81" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578673508485" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_24" waitSetting="0" width="117" x="897" y="63">

        <inputs val="&lt;inputs /&gt;" />

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1574286414615" description="creates a super process group" displayName="Read registry value (DWORD)" height="173" interactive="0" jobMode="0" name="ProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;gradientColor=#BEE0B8;fillColor=#BEE0B8" uniqueName="ProcessBlock_8" waitSetting="0" width="1527" x="14" y="4111">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="">

        <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sRegKey" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sRegFolder" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sResultVariable" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.Integer" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" name="iDefaultValue" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      </inputs>

      <outputs className="" defaultValue="" listType="0" name="outputs" type="">

        <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sRegKey" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sRegFolder" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sResultVariable" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.Integer" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" name="iDefaultValue" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      </outputs>

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;sRegKey class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;sRegFolder class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;iDefaultValue class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;0&lt;/iDefaultValue&gt;&lt;sResultVariable class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1574286414615" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_9" waitSetting="0" width="58" x="18" y="101">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="EnableLogging_8" commented="0" description="" originalStyle="" points="" sourceX="47" sourceY="116" status="0" style="defaultEdge" targetX="141" targetY="72" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1574286266623" description="executes queries against a commcell database" displayName="Get CS Instance" height="35" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_6" waitSetting="0" width="120" x="581" y="99">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;select distinct attrVal&amp;#xD;&#xD;&#xA;from APP_ClientProp(nolock) cp&amp;#xD;&#xD;&#xA;join APP_Client(nolock) c on c.id = cp.componentNameId&amp;#xD;&#xD;&#xA;where c.name = ''xpath:{/workflow/system/commCellName}'' &amp;#xD;&#xD;&#xA;    and cp.attrName = ''Galaxy Instance name'' &amp;#xD;&#xD;&#xA;    and CP.modified = 0&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="EnableLogging_2" commented="0" description="" originalStyle="" points="" sourceX="175" sourceY="86" status="0" style="defaultEdge" targetX="326" targetY="80" transitionIndex="0" x="0" y="0" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1574286724974" description="activity to execute code snippets in the selected language" displayName="Get CS Instance" height="35" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_6" waitSetting="0" width="120" x="893" y="99">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/CommServDBQuery_6/resultSets/rowCount} == 0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to get CS Instance. Could not determine value for key [&amp;quot; + xpath:{/workflow/ProcessBlock_8/sRegKey} + &amp;quot;]&amp;quot;); &amp;#xD;&amp;#xA;    int iRegValue = xpath:{/workflow/ProcessBlock_8/iDefaultValue};&amp;#xD;&amp;#xA;    workflow.setVariable(xpath:{/workflow/ProcessBlock_8/sResultVariable}, iRegValue);&amp;#xD;&amp;#xA;    return false;    &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String sCSInstance = xpath:{/workflow/CommServDBQuery_6/resultSets[1]/row[1]/col[@name=&amp;quot;attrVal&amp;quot;]};&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;sCSIntance&amp;quot;, sCSInstance);&amp;#xD;&amp;#xA;logger.info(&amp;quot;CS Instance determined to be &amp;quot; + sCSInstance);&amp;#xD;&amp;#xA;return true;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteCommand_2" commented="0" description="" displayName="Success" originalStyle="" points="" sourceX="401" sourceY="86" status="0" style="defaultEdge" targetX="576" targetY="85" transitionIndex="0" x="0" y="0">

          <condition language="1" script="true == activity.output" />

        </transition>

        <transition activity="DisableLogging_9" commented="0" description="" originalStyle="" points="1213.0,153.0" sourceX="953" sourceY="116" status="0" style="defaultEdge" targetX="1476" targetY="116" transitionIndex="0" x="0" y="0">

          <condition language="1" script="false == activity.output" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="1" created="1574287347194" description="Execute a command on a remote machine" displayName="Read Registry" height="35" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_2" waitSetting="0" width="109" x="1090" y="99">

        <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

        <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;hostName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;displayName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;commCellName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;csGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;type class=&quot;commvault.msgs.CvEntities.CommCellType&quot; _list_=&quot;false&quot; /&gt;&lt;flags class=&quot;commvault.msgs.CvEntities.EntityFlags&quot; _list_=&quot;false&quot; /&gt;&lt;GUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;newName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;reg&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Query &quot;HKLM\SOFTWARE\CommVault Systems\Galaxy\xpath:{/workflow/variables/sCSIntance}\xpath:{/workflow/ProcessBlock_8/sRegFolder}&quot; /v xpath:{/workflow/ProcessBlock_8/sRegKey} || ver&amp;gt;nul &lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

        <transition activity="Script_8" commented="0" description="" originalStyle="" points="" sourceX="546" sourceY="86" status="0" style="defaultEdge" targetX="701" targetY="86" transitionIndex="0" x="0" y="0" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1574287503408" description="activity to execute code snippets in the selected language" displayName="Extract Reg Value" height="35" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_8" waitSetting="0" width="131" x="1234" y="99">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try &amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    if(0 != xpath:{/workflow/ExecuteCommand_2/exitCode} || 0 != xpath:{/workflow/ExecuteCommand_2/errorCode})&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Failed to find key [&amp;quot; + xpath:{/workflow/ProcessBlock_8/sRegKey} + &amp;quot;] in registry&amp;quot;); &amp;#xD;&amp;#xA;        return false;    &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    int iRegValue = xpath:{/workflow/ProcessBlock_8/iDefaultValue};&amp;#xD;&amp;#xA;    workflow.setVariable(xpath:{/workflow/ProcessBlock_8/sResultVariable}, iRegValue);&amp;#xD;&amp;#xA;    String sRegValue = xpath:{/workflow/ExecuteCommand_2/commandOutput};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(sRegValue.contains(&amp;quot;The system was unable to find the specified registry key or value&amp;quot;))&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Key [&amp;quot; + xpath:{/workflow/ProcessBlock_8/sRegKey} + &amp;quot;] not set in registry&amp;quot;); &amp;#xD;&amp;#xA;        return false;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    int idx = sRegValue.indexOf(&amp;quot;REG_DWORD&amp;quot;);&amp;#xD;&amp;#xA;    if(idx &amp;gt;= 0)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        val = sRegValue.substring(idx + &amp;quot;REG_DWORD&amp;quot;.length()).trim();&amp;#xD;&amp;#xA;        val = val.substring(2).trim();&amp;#xD;&amp;#xA;        iRegValue = Integer.parseInt(val, 16);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;Found key [&amp;quot; + xpath:{/workflow/ProcessBlock_8/sRegKey} + &amp;quot;] with value [&amp;quot; + Integer.toString(iRegValue) + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(xpath:{/workflow/ProcessBlock_8/sResultVariable}, iRegValue);&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e) &amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to read registry value [&amp;quot; + xpath:{/workflow/ProcessBlock_8/sRegKey} + &amp;quot;]. Exception &amp;quot; + e);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_9" commented="0" description="" originalStyle="" points="" sourceX="1199" sourceY="116" status="0" style="defaultEdge" targetX="1421" targetY="125" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1575488661062" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="35" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_3" waitSetting="0" width="117" x="420" y="99">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="CommServDBQuery_6" commented="0" description="" originalStyle="" points="" sourceX="206" sourceY="139" status="0" style="defaultEdge" targetX="335" targetY="86" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1575488687313" description="turns on all logging for the current job" displayName="EnableLogging" height="35" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_2" waitSetting="0" width="113" x="746" y="99">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Script_6" commented="0" description="" originalStyle="" points="" sourceX="582" sourceY="86" status="0" style="defaultEdge" targetX="737" targetY="79" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1575492949727" description="if/else based decision" displayName="Debug" height="54" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_5" waitSetting="0" width="66" x="316" y="89">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;1 == xpath:{/workflow/variables/iDebugMode}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_3" commented="0" description="" originalStyle="" points="" sourceX="245" sourceY="86" status="0" style="defaultEdge" targetX="369" targetY="88" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="CommServDBQuery_6" commented="0" description="" displayName="Debug enabled" offsetX="-6" offsetY="-14" originalStyle="" points="349.0,61.0" sourceX="245" sourceY="86" status="0" style="defaultEdge" targetX="573" targetY="75" transitionIndex="0" value="true" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578605184237" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_8" waitSetting="0" width="113" x="106" y="99">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="ExecuteCommand_2" commented="0" description="" displayName="CS Instance known" offsetX="44" offsetY="-27" originalStyle="" points="632.0,40.0" sourceX="47" sourceY="86" status="0" style="defaultEdge" targetX="568" targetY="87" transitionIndex="0" x="0" y="0">

          <condition language="1" script="!xpath:{/workflow/variables/sCSIntance}.isEmpty()" />

        </transition>

        <transition activity="Decision_5" commented="0" description="" displayName="CS Instance&#xA;unknown" originalStyle="" points="" sourceX="47" sourceY="86" status="0" style="defaultEdge" targetX="151" targetY="83" transitionIndex="0" x="0" y="0">

          <condition language="1" script="xpath:{/workflow/variables/sCSIntance}.isEmpty()&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578605189660" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_9" waitSetting="0" width="117" x="1400" y="99">

        <inputs val="&lt;inputs /&gt;" />

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1574364768641" description="executes a defined process block within the workflow" displayName="Restore" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#85E0E0;gradientColor=#85E0E0" uniqueName="ExecuteProcessBlock_17" waitSetting="0" width="156" x="575" y="90">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs name="ProcessBlock_13">

        <children name="Start_14" />

        <children name="ExecuteProcessBlock_27">

          <children name="Start_16" />

          <children name="CommServDBQuery_13" type="">

            <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                  <options val="GALAXY" />

                  <options val="NBU" />

                  <options val="NETAPP" />

                  <options val="TSM" />

                  <options val="VEEAM" />

                </children>

                <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

            </children>

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="DisableLogging_4" />

          <children name="EnableLogging_3" />

          <children name="Decision_6" />

          <children name="WorkflowEnd_9" />

          <children name="Script_38">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="DisableLogging_28" />

          <children name="DisableLogging_29" />

          <children name="Decision_18" />

          <children name="Script_89">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="ExecuteCommand_18">

            <children className="java.lang.Integer" documentation="the exitCode recieved from executing the command" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Integer" documentation="the return code recieved from completion of the command" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" documentation="the output from the command or error message if it failed" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="ExecuteProcessBlock_73">

            <children name="Start_41" />

            <children name="Job_2" type="">

              <children className="workflow.types.cmd.JobDetails" inputType="workflow.types.cmd.JobDetails" listType="1" name="job" type="{workflow.types.cmd}JobDetails">

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="jobId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" inputType="java.lang.String" name="jobType" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="status" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="phase" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Script_100">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="EnableLogging_31" />

            <children name="DisableLogging_47" />

          </children>

          <children name="EnableLogging_39" />

          <children name="Script_160">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="ImpersonateCreator_2">

            <children className="java.lang.String" inputType="java.lang.String" name="token" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="Execute_4">

            <children className="java.lang.String" documentation="xml output contents" inputType="java.lang.String" name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="Script_159">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="Execute_5">

            <children className="java.lang.String" documentation="xml output contents" inputType="java.lang.String" name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="Script_161">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="ExecuteCommand_53">

            <children className="java.lang.Integer" documentation="the exitCode recieved from executing the command" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Integer" documentation="the return code recieved from completion of the command" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" documentation="the output from the command or error message if it failed" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="ExecuteProcessBlock_75">

            <children name="Start_15" />

            <children name="Script_20">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="EnableLogging_14" />

            <children name="DisableLogging_15" />

            <children name="ExecuteProcessBlock_67">

              <children name="Start_41" />

              <children name="Job_2" type="">

                <children className="workflow.types.cmd.JobDetails" inputType="workflow.types.cmd.JobDetails" listType="1" name="job" type="{workflow.types.cmd}JobDetails">

                  <children className="java.lang.Integer" inputType="java.lang.Integer" name="jobId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" inputType="java.lang.String" name="jobType" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="status" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="phase" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children name="Script_100">

                <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

              <children name="EnableLogging_31" />

              <children name="DisableLogging_47" />

            </children>

          </children>

          <children name="ExecuteCommand_54">

            <children className="java.lang.Integer" documentation="the exitCode recieved from executing the command" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Integer" documentation="the return code recieved from completion of the command" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" documentation="the output from the command or error message if it failed" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="EnableLogging_40" />

          <children name="CommServDBQuery_63" type="">

            <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                  <options val="GALAXY" />

                  <options val="NBU" />

                  <options val="NETAPP" />

                  <options val="TSM" />

                  <options val="VEEAM" />

                </children>

                <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

            </children>

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="CommServDBQuery_64" type="">

            <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                  <options val="GALAXY" />

                  <options val="NBU" />

                  <options val="NETAPP" />

                  <options val="TSM" />

                  <options val="VEEAM" />

                </children>

                <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

            </children>

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="Script_183">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="DisableLogging_52" />

          <children name="WorkflowEnd_29" />

        </children>

        <children name="ExecuteProcessBlock_30">

          <children name="Start_25" />

          <children name="CommServDBQuery_15" type="">

            <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                  <options val="GALAXY" />

                  <options val="NBU" />

                  <options val="NETAPP" />

                  <options val="TSM" />

                  <options val="VEEAM" />

                </children>

                <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

            </children>

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="EnableLogging_16" />

          <children name="DisableLogging_17" />

          <children name="Script_31">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

        </children>

        <children name="ExecuteProcessBlock_31">

          <children name="Start_28" />

          <children name="EnableLogging_17" />

          <children name="DisableLogging_18" />

        </children>

        <children name="Script_90">

          <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        </children>

        <children name="WorkflowEnd_10" />

        <children name="EnableLogging_29" />

        <children name="Decision_19" />

        <children name="DisableLogging_41" />

        <children name="CommServDBQuery_45" type="">

          <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                <options val="GALAXY" />

                <options val="NBU" />

                <options val="NETAPP" />

                <options val="TSM" />

                <options val="VEEAM" />

              </children>

              <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

              <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

              <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

          </children>

          <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="ExecuteProcessBlock_51">

          <children name="Start_40" />

          <children name="EnableLogging_27" />

          <children name="Decision_15" />

          <children name="DisableLogging_34" />

          <children name="CommServDBQuery_41" type="">

            <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                  <options val="GALAXY" />

                  <options val="NBU" />

                  <options val="NETAPP" />

                  <options val="TSM" />

                  <options val="VEEAM" />

                </children>

                <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

            </children>

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="Script_81">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="Script_87">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="DisableLogging_40" />

          <children name="EnableLogging_28" />

        </children>

        <children name="ExecuteProcessBlock_60">

          <children name="Start_35" />

          <children name="Script_65">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="Script_72">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="InformationalMessage_2">

            <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="InformationalMessage_3">

            <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="EndUserSession_4" />

          <children name="Script_74">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="DisableLogging_30" />

          <children name="Script_175">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="Script_181">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="InformationalMessage_13">

            <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

        </children>

        <children name="ExecuteProcessBlock_61">

          <children name="Start_25" />

          <children name="CommServDBQuery_15" type="">

            <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                  <options val="GALAXY" />

                  <options val="NBU" />

                  <options val="NETAPP" />

                  <options val="TSM" />

                  <options val="VEEAM" />

                </children>

                <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

            </children>

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="EnableLogging_16" />

          <children name="DisableLogging_17" />

          <children name="Script_31">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

        </children>

        <children name="Decision_20" />

        <children name="DisableLogging_45" />

        <children name="CommServDBQuery_47" type="">

          <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                <options val="GALAXY" />

                <options val="NBU" />

                <options val="NETAPP" />

                <options val="TSM" />

                <options val="VEEAM" />

              </children>

              <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

              <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

              <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

          </children>

          <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="ExecuteProcessBlock_63">

          <children name="Start_40" />

          <children name="EnableLogging_27" />

          <children name="Decision_15" />

          <children name="DisableLogging_34" />

          <children name="CommServDBQuery_41" type="">

            <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                  <options val="GALAXY" />

                  <options val="NBU" />

                  <options val="NETAPP" />

                  <options val="TSM" />

                  <options val="VEEAM" />

                </children>

                <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

            </children>

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="Script_81">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="Script_87">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="DisableLogging_40" />

          <children name="EnableLogging_28" />

        </children>

        <children name="EndUserSession_6" />

        <children name="ExecuteProcessBlock_66">

          <children name="Start_40" />

          <children name="EnableLogging_27" />

          <children name="Decision_15" />

          <children name="DisableLogging_34" />

          <children name="CommServDBQuery_41" type="">

            <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                  <options val="GALAXY" />

                  <options val="NBU" />

                  <options val="NETAPP" />

                  <options val="TSM" />

                  <options val="VEEAM" />

                </children>

                <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

            </children>

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="Script_81">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="Script_87">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="DisableLogging_40" />

          <children name="EnableLogging_28" />

        </children>

        <children name="WorkflowEnd_15" />

        <children name="Decision_35" />

        <children name="Decision_36" />

        <children name="WorkflowEnd_16" />

        <children name="Decision_37" />

        <children name="WorkflowEnd_17" />

        <children name="Decision_44" />

        <children name="WorkflowEnd_23" />

        <children name="Decision_47" />

        <children name="WorkflowEnd_26" />

        <children name="Decision_48" />

        <children name="WorkflowEnd_27" />

      </outputs>

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;processBlock&gt;ProcessBlock_13&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

    <transition activity="WorkflowEnd_14" commented="0" description="" originalStyle="" points="" sourceX="653" sourceY="107" status="0" style="defaultEdge" targetX="856" targetY="142" transitionIndex="0" x="0" y="0">

      <condition language="1" script="xpath:{/workflow/variables/bRecallFail}" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1574364951501" description="executes a defined process block within the workflow" displayName="Backup" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#85E0E0;gradientColor=#85E0E0" uniqueName="ExecuteProcessBlock_21" waitSetting="0" width="155" x="575" y="144">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs name="ProcessBlock_28">

        <children name="Start_33" />

        <children name="CommServDBQuery_30" type="">

          <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                <options val="GALAXY" />

                <options val="NBU" />

                <options val="NETAPP" />

                <options val="TSM" />

                <options val="VEEAM" />

              </children>

              <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

              <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

              <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

          </children>

          <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="CommServDBQuery_34" type="">

          <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                <options val="GALAXY" />

                <options val="NBU" />

                <options val="NETAPP" />

                <options val="TSM" />

                <options val="VEEAM" />

              </children>

              <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

              <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

              <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

          </children>

          <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="Decision_12" />

        <children name="DisableLogging_10" />

        <children name="EnableLogging_9" />

        <children name="Script_69">

          <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        </children>

        <children name="InformationalMessage_1">

          <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="Decision_14" />

        <children name="DisableLogging_26" />

        <children name="Script_76">

          <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        </children>

        <children name="CommServDBQuery_37" type="">

          <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                <options val="GALAXY" />

                <options val="NBU" />

                <options val="NETAPP" />

                <options val="TSM" />

                <options val="VEEAM" />

              </children>

              <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

              <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

              <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

          </children>

          <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children className="" defaultValue="" listType="0" name="PopupInput_11" type="">

          <children attribute="0" className="java.lang.String" controlHidden="0" controlType="2" defaultValue="" displayName="Select Copy/Copies" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="copy" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

            <options val="xpath:{/workflow/CommServDBQuery_37/resultSets/row/col[1]}" />

            <labelsForOptions val="xpath:{/workflow/CommServDBQuery_37/resultSets/row/col[2]}" />

          </children>

          <children className="java.lang.Boolean" inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean" />

          <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="InformationalMessage_6">

          <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="Script_77">

          <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        </children>

        <children name="CommServDBQuery_38" type="">

          <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                <options val="GALAXY" />

                <options val="NBU" />

                <options val="NETAPP" />

                <options val="TSM" />

                <options val="VEEAM" />

              </children>

              <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

              <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

              <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

          </children>

          <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="InformationalMessage_7">

          <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children className="" defaultValue="" listType="0" name="PopupInput_12" type="">

          <children attribute="0" className="java.lang.String" controlHidden="0" controlType="2" defaultValue="" displayName="Select VM(s)" documentation="" hidden="0" inputType="java.lang.String" listType="1" maximumValue="" minimumValue="" name="VMs" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

            <options val="xpath:{/workflow/CommServDBQuery_38/resultSets/row/col[1]}" />

            <labelsForOptions val="xpath:{/workflow/CommServDBQuery_38/resultSets/row/col[2]}" />

          </children>

          <children className="java.lang.Boolean" inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean" />

          <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="Script_78">

          <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        </children>

        <children name="Script_79">

          <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        </children>

        <children name="InformationalMessage_8">

          <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="CommServDBQuery_39" type="">

          <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                <options val="GALAXY" />

                <options val="NBU" />

                <options val="NETAPP" />

                <options val="TSM" />

                <options val="VEEAM" />

              </children>

              <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

              <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

              <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

          </children>

          <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="Script_80">

          <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        </children>

        <children name="EnableLogging_22" />

        <children name="EnableLogging_23" />

        <children name="ExecuteProcessBlock_46">

          <children name="Start_35" />

          <children name="Script_65">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="Script_72">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="InformationalMessage_2">

            <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="InformationalMessage_3">

            <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="EndUserSession_4" />

          <children name="Script_74">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="DisableLogging_30" />

          <children name="Script_175">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="Script_181">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="InformationalMessage_13">

            <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

        </children>

        <children name="CommServDBQuery_42" type="">

          <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                <options val="GALAXY" />

                <options val="NBU" />

                <options val="NETAPP" />

                <options val="TSM" />

                <options val="VEEAM" />

              </children>

              <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

              <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

              <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

          </children>

          <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children className="" defaultValue="" listType="0" name="PopupInput_14" type="">

          <children attribute="0" className="java.lang.String" controlHidden="0" controlType="2" defaultValue="" displayName="Select DB(s)" documentation="" hidden="0" inputType="java.lang.String" listType="1" maximumValue="" minimumValue="" name="DBs" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

            <options val="xpath:{/workflow/CommServDBQuery_42/resultSets/row/col[1]}" />

            <labelsForOptions val="xpath:{/workflow/CommServDBQuery_42/resultSets/row/col[2]}" />

          </children>

          <children className="java.lang.Boolean" inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean" />

          <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="Script_82">

          <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        </children>

        <children name="EnableLogging_24" />

        <children name="EnableLogging_25" />

        <children name="Decision_17" />

        <children name="DisableLogging_38" />

        <children name="EnableLogging_26" />

        <children name="Script_85">

          <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        </children>

        <children name="Script_86">

          <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        </children>

        <children name="InformationalMessage_9">

          <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="ExecuteProcessBlock_50">

          <children name="Start_40" />

          <children name="EnableLogging_27" />

          <children name="Decision_15" />

          <children name="DisableLogging_34" />

          <children name="CommServDBQuery_41" type="">

            <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                  <options val="GALAXY" />

                  <options val="NBU" />

                  <options val="NETAPP" />

                  <options val="TSM" />

                  <options val="VEEAM" />

                </children>

                <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

            </children>

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="Script_81">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="Script_87">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="DisableLogging_40" />

          <children name="EnableLogging_28" />

        </children>

        <children name="ExecuteProcessBlock_56">

          <children name="Start_25" />

          <children name="CommServDBQuery_15" type="">

            <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                  <options val="GALAXY" />

                  <options val="NBU" />

                  <options val="NETAPP" />

                  <options val="TSM" />

                  <options val="VEEAM" />

                </children>

                <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

            </children>

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="EnableLogging_16" />

          <children name="DisableLogging_17" />

          <children name="Script_31">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

        </children>

        <children name="ExecuteProcessBlock_57">

          <children name="Start_28" />

          <children name="EnableLogging_17" />

          <children name="DisableLogging_18" />

        </children>

        <children name="DisableLogging_44" />

        <children name="ExecuteProcessBlock_64">

          <children name="Start_40" />

          <children name="EnableLogging_27" />

          <children name="Decision_15" />

          <children name="DisableLogging_34" />

          <children name="CommServDBQuery_41" type="">

            <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                  <options val="GALAXY" />

                  <options val="NBU" />

                  <options val="NETAPP" />

                  <options val="TSM" />

                  <options val="VEEAM" />

                </children>

                <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

            </children>

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="Script_81">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="Script_87">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="DisableLogging_40" />

          <children name="EnableLogging_28" />

        </children>

        <children name="WorkflowEnd_19" />

        <children name="Decision_39" />

        <children name="Decision_45" />

        <children name="WorkflowEnd_25" />

        <children name="CommServDBQuery_60" type="">

          <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                <options val="GALAXY" />

                <options val="NBU" />

                <options val="NETAPP" />

                <options val="TSM" />

                <options val="VEEAM" />

              </children>

              <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

              <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

              <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

          </children>

          <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="Script_178">

          <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        </children>

        <children name="ExecuteProcessBlock_77">

          <children name="Start_47" />

          <children name="EnableLogging_41" />

          <children name="Decision_46" />

          <children name="DisableLogging_48" />

          <children name="CommServDBQuery_59" type="">

            <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                  <options val="GALAXY" />

                  <options val="NBU" />

                  <options val="NETAPP" />

                  <options val="TSM" />

                  <options val="VEEAM" />

                </children>

                <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

            </children>

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="Script_176">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="Script_177">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="DisableLogging_49" />

          <children name="EnableLogging_42" />

          <children name="Execute_8">

            <children className="java.lang.String" documentation="xml output contents" inputType="java.lang.String" name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="ExecuteProcessBlock_76">

            <children name="Start_19" />

            <children name="DisableLogging_1" />

            <children name="Execute_1">

              <children className="java.lang.String" documentation="xml output contents" inputType="java.lang.String" name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Script_ClientDetails">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="Decision_4" />

            <children name="EnableLogging_13" />

            <children name="DisableLogging_14" />

          </children>

          <children name="Script_179">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="CommServDBQuery_61" type="">

            <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                  <options val="GALAXY" />

                  <options val="NBU" />

                  <options val="NETAPP" />

                  <options val="TSM" />

                  <options val="VEEAM" />

                </children>

                <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

            </children>

            <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

          </children>

          <children name="Decision_49" />

          <children name="Script_180">

            <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

          </children>

          <children name="DisableLogging_50" />

        </children>

        <children name="EndUserSession_8" />

      </outputs>

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;processBlock&gt;ProcessBlock_28&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

    <transition activity="WorkflowEnd_14" commented="0" description="" originalStyle="" points="" sourceX="652" sourceY="161" status="0" style="defaultEdge" targetX="874" targetY="138" transitionIndex="0" x="0" y="0">

      <condition language="1" script="xpath:{/workflow/variables/bRecallFail}" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1575311401658" description="creates a super process group" displayName="Restore" height="414" interactive="0" jobMode="0" name="ProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#85E0E0;gradientColor=#85E0E0" uniqueName="ProcessBlock_13" waitSetting="0" width="2135" x="60" y="871">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs className="" defaultValue="" listType="0" name="outputs" type="" />

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1575311401658" description="" displayName="Start(OC)" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_14" waitSetting="0" width="83" x="9" y="114">

        <onEnter language="1" script="workflow.setVariable(&quot;iCommandRetry&quot;, 1);" />

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="EndUserSession_6" commented="0" description="" originalStyle="" points="" sourceX="53" sourceY="129" status="0" style="defaultEdge" targetX="147" targetY="128" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1575319748639" description="executes a defined process block within the workflow" displayName="Get Recall Data Using Restore Vector" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#FAD39E;gradientColor=#FAD39E" uniqueName="ExecuteProcessBlock_27" waitSetting="0" width="240" x="663" y="339">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

          <outputs name="ProcessBlock_15">

            <children name="Start_16" />

            <children name="CommServDBQuery_13" type="">

              <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                    <options val="GALAXY" />

                    <options val="NBU" />

                    <options val="NETAPP" />

                    <options val="TSM" />

                    <options val="VEEAM" />

                  </children>

                  <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                  <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                  <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

              </children>

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="DisableLogging_4" />

            <children name="EnableLogging_3" />

            <children name="Decision_6" />

            <children name="WorkflowEnd_9" />

            <children name="Script_38">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="DisableLogging_28" />

            <children name="DisableLogging_29" />

            <children name="Decision_18" />

            <children name="Script_89">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="ExecuteCommand_18">

              <children className="java.lang.Integer" documentation="the exitCode recieved from executing the command" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" documentation="the return code recieved from completion of the command" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" documentation="the output from the command or error message if it failed" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="ExecuteProcessBlock_73">

              <children name="Start_41" />

              <children name="Job_2" type="">

                <children className="workflow.types.cmd.JobDetails" inputType="workflow.types.cmd.JobDetails" listType="1" name="job" type="{workflow.types.cmd}JobDetails">

                  <children className="java.lang.Integer" inputType="java.lang.Integer" name="jobId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" inputType="java.lang.String" name="jobType" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="status" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="phase" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children name="Script_100">

                <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

              <children name="EnableLogging_31" />

              <children name="DisableLogging_47" />

            </children>

            <children name="EnableLogging_39" />

            <children name="Script_160">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="ImpersonateCreator_2">

              <children className="java.lang.String" inputType="java.lang.String" name="token" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Execute_4">

              <children className="java.lang.String" documentation="xml output contents" inputType="java.lang.String" name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Script_159">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="Execute_5">

              <children className="java.lang.String" documentation="xml output contents" inputType="java.lang.String" name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Script_161">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="ExecuteCommand_53">

              <children className="java.lang.Integer" documentation="the exitCode recieved from executing the command" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" documentation="the return code recieved from completion of the command" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" documentation="the output from the command or error message if it failed" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="ExecuteProcessBlock_75">

              <children name="Start_15" />

              <children name="Script_20">

                <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

              <children name="EnableLogging_14" />

              <children name="DisableLogging_15" />

              <children name="ExecuteProcessBlock_67">

                <children name="Start_41" />

                <children name="Job_2" type="">

                  <children className="workflow.types.cmd.JobDetails" inputType="workflow.types.cmd.JobDetails" listType="1" name="job" type="{workflow.types.cmd}JobDetails">

                    <children className="java.lang.Integer" inputType="java.lang.Integer" name="jobId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                    <children className="java.lang.String" inputType="java.lang.String" name="jobType" type="{http://www.w3.org/2001/XMLSchema}string" />

                    <children className="java.lang.String" inputType="java.lang.String" name="status" type="{http://www.w3.org/2001/XMLSchema}string" />

                    <children className="java.lang.String" inputType="java.lang.String" name="phase" type="{http://www.w3.org/2001/XMLSchema}string" />

                  </children>

                  <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children name="Script_100">

                  <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

                <children name="EnableLogging_31" />

                <children name="DisableLogging_47" />

              </children>

            </children>

            <children name="ExecuteCommand_54">

              <children className="java.lang.Integer" documentation="the exitCode recieved from executing the command" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.Integer" documentation="the return code recieved from completion of the command" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" documentation="the output from the command or error message if it failed" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="EnableLogging_40" />

            <children name="CommServDBQuery_63" type="">

              <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                    <options val="GALAXY" />

                    <options val="NBU" />

                    <options val="NETAPP" />

                    <options val="TSM" />

                    <options val="VEEAM" />

                  </children>

                  <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                  <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                  <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

              </children>

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="CommServDBQuery_64" type="">

              <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                    <options val="GALAXY" />

                    <options val="NBU" />

                    <options val="NETAPP" />

                    <options val="TSM" />

                    <options val="VEEAM" />

                  </children>

                  <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                  <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                  <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

              </children>

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Script_183">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="DisableLogging_52" />

            <children name="WorkflowEnd_29" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;processBlock&gt;ProcessBlock_15&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="Decision_35" commented="0" description="" originalStyle="" points="" sourceX="591" sourceY="352" status="0" style="defaultEdge" targetX="792" targetY="413" transitionIndex="0" x="267" y="282">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1575389767282" description="executes a defined process block within the workflow" displayName="Prepare Recall Commands" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#BEE0B8;gradientColor=#BEE0B8" uniqueName="ExecuteProcessBlock_30" waitSetting="0" width="182" x="1483" y="339">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="">

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sCloudToolMode" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="iIndexFree" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

          </inputs>

          <outputs name="ProcessBlock_23">

            <children name="Start_25" />

            <children name="CommServDBQuery_15" type="">

              <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                    <options val="GALAXY" />

                    <options val="NBU" />

                    <options val="NETAPP" />

                    <options val="TSM" />

                    <options val="VEEAM" />

                  </children>

                  <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                  <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                  <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

              </children>

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="EnableLogging_16" />

            <children name="DisableLogging_17" />

            <children name="Script_31">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;sCloudToolMode class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;2&lt;/sCloudToolMode&gt;&lt;iIndexFree class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;0&lt;/iIndexFree&gt;&lt;/inputs&gt;&lt;processBlock&gt;ProcessBlock_23&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_31" commented="0" description="" originalStyle="" points="1990.0,270.0" sourceX="942" sourceY="128" status="0" style="defaultEdge" targetX="1214" targetY="129" transitionIndex="0" x="274" y="5">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1575389787175" description="executes a defined process block within the workflow" displayName="Recall Files" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#BEE0B8;gradientColor=#BEE0B8" uniqueName="ExecuteProcessBlock_31" waitSetting="0" width="94" x="1957" y="196">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

          <outputs name="ProcessBlock_24">

            <children name="Start_28" />

            <children name="EnableLogging_17" />

            <children name="DisableLogging_18" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;processBlock&gt;ProcessBlock_24&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="EndUserSession_6" commented="0" description="" originalStyle="" points="948.0,401.0" sourceX="1746" sourceY="213" status="0" style="defaultEdge" targetX="170" targetY="130" transitionIndex="0" x="0" y="0">

          <condition language="1" script="int iMaxRetryCount = 1;&#xD;&#xA;if(xpath:{/workflow/variables/bRecallFail})&#xD;&#xA;{&#xD;&#xA;    int commandRetry = workflow.getVariable(&quot;iCommandRetry&quot;);&#xD;&#xA;    if(commandRetry &gt; iMaxRetryCount)&#xD;&#xA;    {&#xD;&#xA;        return false;&#xD;&#xA;    }&#xD;&#xA;    logger.info(&quot;Retrying recall. Attempt &quot; + Integer.toString(commandRetry) + &quot;/&quot; + Integer.toString(iMaxRetryCount));    &#xD;&#xA;    workflow.setVariable(&quot;iCommandRetry&quot;, ++commandRetry);&#xD;&#xA;    return true;     &#xD;&#xA;}&#xD;&#xA;return false;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1581025711658" description="activity to execute code snippets in the selected language" displayName="Determine Agent" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_90" waitSetting="0" width="125" x="434" y="195">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;int iAppType = xpath:{/workflow/variables/iAppType};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(106 == iAppType || 81 == iAppType)&amp;#xD;&amp;#xA;    return iAppType;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;return 1;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;//TODO: Once all agents are tested, we will need to return 0 for unsupported agents &quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_27" commented="0" description="" displayName="Agents supporting&#xA;Restore Vector" offsetX="3" offsetY="8" originalStyle="" points="" sourceX="483" sourceY="135" status="0" style="defaultEdge" targetX="761" targetY="129" transitionIndex="0" x="0" y="0">

          <condition language="1" script="1 == xpath:{/workflow/Script_90/output}" />

        </transition>

        <transition activity="WorkflowEnd_10" commented="0" description="" displayName="Unsupported Agent" offsetX="1" offsetY="-3" originalStyle="" points="" sourceX="483" sourceY="135" status="0" style="defaultEdge" targetX="788" targetY="72" transitionIndex="0" x="0" y="0">

          <condition language="1" script="0 == xpath:{/workflow/Script_90/output}" />

        </transition>

        <transition activity="Decision_19" commented="0" description="" displayName="VSA" offsetX="-2" offsetY="-21" originalStyle="" points="" sourceX="619" sourceY="135" status="0" style="defaultEdge" targetX="732" targetY="228" transitionIndex="0" x="0" y="0">

          <condition language="1" script="106 == xpath:{/workflow/Script_90/output}" />

        </transition>

        <transition activity="Decision_20" commented="0" description="" displayName="DB" offsetX="24" offsetY="1" originalStyle="" points="" sourceX="619" sourceY="135" status="0" style="defaultEdge" targetX="741" targetY="331" transitionIndex="0" x="0" y="0">

          <condition language="1" script="81 == xpath:{/workflow/Script_90/output}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1581025945779" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_10" waitSetting="0" width="106" x="439" y="284">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Failure Reason: Recall via Alert is not supported for this agent. Refer documentation for details.&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1581365037690" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_29" waitSetting="0" width="113" x="255" y="112">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="ExecuteProcessBlock_66" commented="0" description="" displayName="Restore By Job" originalStyle="" points="" sourceX="311" sourceY="129" status="0" style="defaultEdge" targetX="458" targetY="58" transitionIndex="0" x="0" y="0">

          <condition language="1" script="1005 == xpath:{/workflow/variables/iJobOption}" />

        </transition>

        <transition activity="Script_90" commented="0" description="" displayName="Browse &amp; Restore" originalStyle="" points="" sourceX="311" sourceY="129" status="0" style="defaultEdge" targetX="489" targetY="136" transitionIndex="0" x="0" y="0">

          <condition language="1" script="1001 == xpath:{/workflow/variables/iJobOption}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1581365195629" description="if/else based decision" displayName="Debug" height="54" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_19" waitSetting="0" width="66" x="672" y="83">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;1 == xpath:{/workflow/variables/iDebugMode}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_41" commented="0" description="" displayName="Disabled" originalStyle="" points="" sourceX="740" sourceY="227" status="0" style="defaultEdge" targetX="925" targetY="227" transitionIndex="0" value="false" x="242" y="-2168">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="CommServDBQuery_45" commented="0" description="" originalStyle="" points="833.0,69.0" sourceX="740" sourceY="227" status="0" style="defaultEdge" targetX="1118" targetY="230" transitionIndex="0" value="true" x="296" y="6">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1581365195646" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_41" waitSetting="0" width="117" x="826" y="93">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="CommServDBQuery_45" commented="0" description="" originalStyle="" points="" sourceX="925" sourceY="227" status="0" style="defaultEdge" targetX="1078" targetY="227" transitionIndex="0" x="242" y="-2168">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1581365195660" description="executes queries against a commcell database" displayName="Get VM Details" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_45" waitSetting="0" width="113" x="977" y="93">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @jobid int = xpath:{/workflow/variables/iJobId};&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @vsalist table(guid varchar(max))&amp;#xD;&#xD;&#xA;insert into @vsalist&amp;#xD;&#xD;&#xA;select substring(value,2,LEN(value))&amp;#xD;&#xD;&#xA;from dbo.GetAllJobOptions(@jobId)&amp;#xD;&#xD;&#xA;where optionId = 150001 /*TM_SOURCE*/&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @vmClientIdList varchar(max)&amp;#xD;&#xD;&#xA;select @vmClientIdList = coalesce(@vmClientIdList + '','', '''') + CAST(c.id as varchar(max))&amp;#xD;&#xD;&#xA;from APP_Client(nolock) c&amp;#xD;&#xD;&#xA;join @vsalist v on v.guid = c.GUID&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select @vmClientIdList vmClientIdList&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @jobType int = xpath:{/workflow/variables/iJobOption};&amp;#xD;&#xD;&#xA;declare @appType int = xpath:{/workflow/variables/iAppType};&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;--INPUT DATA&amp;#xD;&#xD;&#xA;if object_id(''tempdb.dbo.#i_afList'') is not null drop table #i_afList&amp;#xD;&#xD;&#xA;create table #i_afList(afId int, offset bigint)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if object_id(''tempdb.dbo.#i_copyList'') is not null drop table #i_copyList&amp;#xD;&#xD;&#xA;create table #i_copyList(copyId int);&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;--OUTPUT DATA&amp;#xD;&#xD;&#xA;declare @o_errorCode int = 0;&amp;#xD;&#xD;&#xA;declare @o_errorMsg varchar(max);&amp;#xD;&#xD;&#xA;declare @maxJid int = 0&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;--Table for start and end job values&amp;#xD;&#xD;&#xA;declare @bkpJobInfoTable table(appId int, fromBackupJob int, toBackupJob int)&amp;#xD;&#xD;&#xA;declare @copyId int = 0;&amp;#xD;&#xD;&#xA;declare @bkpJobId int = 0;&amp;#xD;&#xD;&#xA;declare @toTime int = 0;&amp;#xD;&#xD;&#xA;declare @appId int = 0;&amp;#xD;&#xD;&#xA;declare @backupSetId int = 0;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select @bkpJobId = ISNULL(TRY_CAST([1694742669] as int), 0) /*BROWSEOPTION_BROWSE_JOB_ID*/&amp;#xD;&#xD;&#xA;&#x9;&#x9;, @toTime = ISNULL(TRY_CAST([237388043] as int),  DATEDIFF(s, ''1970-01-01 00:00:00'', GETUTCDATE())) /*BROWSEOPTION_TIMERANGE_TO_TIME*/&amp;#xD;&#xD;&#xA;&#x9;&#x9;, @appId = ISNULL(TRY_CAST([140007] as int), 0) /*COM_SUBCLIENT_ID*/&amp;#xD;&#xD;&#xA;&#x9;&#x9;, @backupSetId = ISNULL(TRY_CAST([140006] as int), 0) /*COM_BACKUPSET_ID*/&amp;#xD;&#xD;&#xA;&#x9;&#x9;, @copyId = ISNULL(TRY_CAST([957862300] as int), 0) /* COPYPRECEDENCE_COPY_PRECEDENCE*/&amp;#xD;&#xD;&#xA;from ( select value,optionId&amp;#xD;&#xD;&#xA;&#x9;&#x9;from dbo.GetAllJobOptions(@jobid))&amp;#xD;&#xD;&#xA;&#x9;&#x9;as SourceTable pivot (&amp;#xD;&#xD;&#xA;&#x9;&#x9;max(value) for optionid in ([1694742669], [237388043], [140007], [140006], [957862300]))&amp;#xD;&#xD;&#xA;&#x9;&#x9;as pivottable;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;--select @bkpJobId jobId, @toTime toTime, @appId appId, @backupSetId bkpSet&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if @bkpJobId &amp;lt;&amp;gt; 0 /*Restored for backup job*/&amp;#xD;&#xD;&#xA;begin&amp;#xD;&#xD;&#xA;&#x9;insert into @bkpJobInfoTable(appId, toBackupJob)&amp;#xD;&#xD;&#xA;&#x9;select @appId, @bkpJobId&amp;#xD;&#xD;&#xA;end&amp;#xD;&#xD;&#xA;else /*Time based restore*/&amp;#xD;&#xD;&#xA;begin&amp;#xD;&#xD;&#xA;&#x9;declare @appIdTable table(appId int)&amp;#xD;&#xD;&#xA;&#x9;if @appId &amp;gt; 0 /*Subclient level Browse*/&amp;#xD;&#xD;&#xA;&#x9;begin&amp;#xD;&#xD;&#xA;&#x9;&#x9;insert into @appIdTable&amp;#xD;&#xD;&#xA;&#x9;&#x9;select @appId&amp;#xD;&#xD;&#xA;&#x9;end&amp;#xD;&#xD;&#xA;&#x9;else if @backupSetId &amp;gt; 0 /*BackupSet level browse*/&amp;#xD;&#xD;&#xA;&#x9;begin&amp;#xD;&#xD;&#xA;&#x9;&#x9;insert into @appIdTable&amp;#xD;&#xD;&#xA;&#x9;&#x9;select id&amp;#xD;&#xD;&#xA;&#x9;&#x9;from APP_Application(nolock)&amp;#xD;&#xD;&#xA;&#x9;&#x9;where backupSet = @backupSetId&amp;#xD;&#xD;&#xA;&#x9;end&amp;#xD;&#xD;&#xA;&#x9;else&amp;#xD;&#xD;&#xA;&#x9;begin&amp;#xD;&#xD;&#xA;&#x9;&#x9;set @o_errorCode = 1&amp;#xD;&#xD;&#xA;&#x9;&#x9;set @o_errorMsg = ''Unable to determine backup data corresponding to the restore job''&amp;#xD;&#xD;&#xA;&#x9;&#x9;goto EndTran&#x9;&amp;#xD;&#xD;&#xA;&#x9;end&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;insert into @bkpJobInfoTable(appId, toBackupJob)&amp;#xD;&#xD;&#xA;&#x9;select a.appId, max(jobId)&amp;#xD;&#xD;&#xA;&#x9;from JMBkpStats(nolock) bkp&amp;#xD;&#xD;&#xA;&#x9;join @appIdTable a on a.appId = bkp.appId&amp;#xD;&#xD;&#xA;&#x9;where servEndDate &amp;lt;= @toTime&amp;#xD;&#xD;&#xA;&#x9;group by a.appId&amp;#xD;&#xD;&#xA;end&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select top 1 @maxJid = toBackupJob&amp;#xD;&#xD;&#xA;from @bkpJobInfoTable&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;EndTran:&amp;#xD;&#xD;&#xA;select @o_errorCode, @o_errorMsg&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if @maxJid = 0&amp;#xD;&#xD;&#xA;&#x9;select 1&amp;#xD;&#xD;&#xA;else&amp;#xD;&#xD;&#xA;begin&amp;#xD;&#xD;&#xA;&#x9;if exists(select 1 from JMJobDataLink(nolock)&amp;#xD;&#xD;&#xA;&#x9;&#x9;where parentJobId = @maxJid or childJobId = @maxJid)&amp;#xD;&#xD;&#xA;&#x9;&#x9;select 2&amp;#xD;&#xD;&#xA;&#x9;else&amp;#xD;&#xD;&#xA;&#x9;&#x9;select 1&amp;#xD;&#xD;&#xA;end&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="Decision_47" commented="0" description="" originalStyle="" points="" sourceX="1078" sourceY="227" status="0" style="defaultEdge" targetX="1320" targetY="229" transitionIndex="0" x="296" y="6">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1581366398554" description="executes a defined process block within the workflow" displayName="Recall Data Using DB" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#FAD39E;gradientColor=#FAD39E" uniqueName="ExecuteProcessBlock_51" waitSetting="0" width="148" x="1272" y="79">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="">

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sCopyIdList" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sIdList" readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

          </inputs>

          <outputs name="ProcessBlock_30">

            <children name="Start_40" />

            <children name="EnableLogging_27" />

            <children name="Decision_15" />

            <children name="DisableLogging_34" />

            <children name="CommServDBQuery_41" type="">

              <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                    <options val="GALAXY" />

                    <options val="NBU" />

                    <options val="NETAPP" />

                    <options val="TSM" />

                    <options val="VEEAM" />

                  </children>

                  <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                  <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                  <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

              </children>

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Script_81">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="Script_87">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="DisableLogging_40" />

            <children name="EnableLogging_28" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;sCopyIdList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;-1&lt;/sCopyIdList&gt;&lt;sIdList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_45/resultSets[1]/row[1]/col[1]}&lt;/sIdList&gt;&lt;/inputs&gt;&lt;processBlock&gt;ProcessBlock_30&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_60" commented="0" description="" originalStyle="" points="" sourceX="1370" sourceY="227" status="0" style="defaultEdge" targetX="2091" targetY="255" transitionIndex="0" x="296" y="6">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1581375097614" description="executes a defined process block within the workflow" displayName="Process Backup Recall Data" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#FAD39E;gradientColor=#FAD39E" uniqueName="ExecuteProcessBlock_60" waitSetting="0" width="191" x="1446" y="93">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

          <outputs name="ProcessBlock_29">

            <children name="Start_35" />

            <children name="Script_65">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="Script_72">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="InformationalMessage_2">

              <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="InformationalMessage_3">

              <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="EndUserSession_4" />

            <children name="Script_74">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="DisableLogging_30" />

            <children name="Script_175">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="Script_181">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="InformationalMessage_13">

              <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;processBlock&gt;ProcessBlock_29&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="Decision_37" commented="0" description="" originalStyle="" points="1483.0,158.0" sourceX="1407" sourceY="110" status="0" style="defaultEdge" targetX="1408" targetY="184" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1581376221406" description="executes a defined process block within the workflow" displayName="Prepare Recall Commands" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#BEE0B8;gradientColor=#BEE0B8" uniqueName="ExecuteProcessBlock_61" waitSetting="0" width="182" x="1532" y="195">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="">

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sCloudToolMode" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="iIndexFree" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

          </inputs>

          <outputs name="ProcessBlock_23">

            <children name="Start_25" />

            <children name="CommServDBQuery_15" type="">

              <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                    <options val="GALAXY" />

                    <options val="NBU" />

                    <options val="NETAPP" />

                    <options val="TSM" />

                    <options val="VEEAM" />

                  </children>

                  <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                  <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                  <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

              </children>

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="EnableLogging_16" />

            <children name="DisableLogging_17" />

            <children name="Script_31">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;sCloudToolMode class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;2&lt;/sCloudToolMode&gt;&lt;iIndexFree class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;1&lt;/iIndexFree&gt;&lt;/inputs&gt;&lt;processBlock&gt;ProcessBlock_23&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_31" commented="0" description="" originalStyle="" points="" sourceX="1770" sourceY="227" status="0" style="defaultEdge" targetX="1553" targetY="140" transitionIndex="0" x="296" y="6">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1582155652283" description="if/else based decision" displayName="Debug" height="54" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_20" waitSetting="0" width="66" x="672" y="185">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;1 == xpath:{/workflow/variables/iDebugMode}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_45" commented="0" description="" displayName="Disabled" originalStyle="" points="" sourceX="741" sourceY="328" status="0" style="defaultEdge" targetX="922" targetY="330" transitionIndex="0" value="false" x="296" y="6">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="CommServDBQuery_47" commented="0" description="" originalStyle="" points="862.0,169.0" sourceX="741" sourceY="328" status="0" style="defaultEdge" targetX="1114" targetY="334" transitionIndex="0" value="true" x="296" y="6">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1582155672359" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_45" waitSetting="0" width="117" x="828" y="194">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="CommServDBQuery_47" commented="0" description="" originalStyle="" points="" sourceX="925" sourceY="328" status="0" style="defaultEdge" targetX="1074" targetY="327" transitionIndex="0" x="296" y="6">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1582155683871" description="executes queries against a commcell database" displayName="Get DB Details" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_47" waitSetting="0" width="113" x="985" y="194">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @jobid int = xpath:{/workflow/variables/iJobId};&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @dbNamelist table(db varchar(max))&amp;#xD;&#xD;&#xA;insert into @dbNamelist&amp;#xD;&#xD;&#xA;select value&amp;#xD;&#xD;&#xA;from dbo.GetAllJobOptions(@jobId)&amp;#xD;&#xD;&#xA;where optionId = 150001 /*TM_SOURCE*/&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @dbIdList varchar(max)&amp;#xD;&#xD;&#xA;select @dbIdList = coalesce(@dbIdList + '','', '''') + CAST(sn2.id as varchar(max))&amp;#xD;&#xD;&#xA;from sqlNames2(nolock) sn2&amp;#xD;&#xD;&#xA;join @dbNamelist d on d.db = sn2.name&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select @dbIdList dbIdList&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_63" commented="0" description="" originalStyle="" points="" sourceX="1081" sourceY="328" status="0" style="defaultEdge" targetX="1206" targetY="326" transitionIndex="0" x="296" y="6">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1582155723334" description="executes a defined process block within the workflow" displayName="Recall Data Using DB" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#FAD39E;gradientColor=#FAD39E" uniqueName="ExecuteProcessBlock_63" waitSetting="0" width="148" x="1131" y="194">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="">

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sCopyIdList" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sIdList" readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

          </inputs>

          <outputs name="ProcessBlock_30">

            <children name="Start_40" />

            <children name="EnableLogging_27" />

            <children name="Decision_15" />

            <children name="DisableLogging_34" />

            <children name="CommServDBQuery_41" type="">

              <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                    <options val="GALAXY" />

                    <options val="NBU" />

                    <options val="NETAPP" />

                    <options val="TSM" />

                    <options val="VEEAM" />

                  </children>

                  <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                  <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                  <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

              </children>

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Script_81">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="Script_87">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="DisableLogging_40" />

            <children name="EnableLogging_28" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;sCopyIdList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;-1&lt;/sCopyIdList&gt;&lt;sIdList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_47/resultSets[1]/row[1]/col[1]}&lt;/sIdList&gt;&lt;/inputs&gt;&lt;processBlock&gt;ProcessBlock_30&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_60" commented="0" description="" originalStyle="" points="1510.0,234.0" sourceX="1227" sourceY="328" status="0" style="defaultEdge" targetX="1399" targetY="228" transitionIndex="0" x="296" y="6">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1582172007309" description="ends the interactive user session" displayName="EndUserSession" height="34" interactive="0" jobMode="0" name="EndUserSession" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.InteractiveEndSessionActivity" uniqueName="EndUserSession_6" waitSetting="0" width="124" x="112" y="112">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="EnableLogging_29" commented="0" description="" originalStyle="" points="" sourceX="312" sourceY="190" status="0" style="defaultEdge" targetX="312" targetY="122" transitionIndex="0" x="132" y="1">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1582665823131" description="executes a defined process block within the workflow" displayName="Recall Data Using DB" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#FAD39E;gradientColor=#FAD39E" uniqueName="ExecuteProcessBlock_66" waitSetting="0" width="148" x="432" y="41">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="">

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sCopyIdList" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sIdList" readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

          </inputs>

          <outputs name="ProcessBlock_30">

            <children name="Start_40" />

            <children name="EnableLogging_27" />

            <children name="Decision_15" />

            <children name="DisableLogging_34" />

            <children name="CommServDBQuery_41" type="">

              <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                    <options val="GALAXY" />

                    <options val="NBU" />

                    <options val="NETAPP" />

                    <options val="TSM" />

                    <options val="VEEAM" />

                  </children>

                  <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                  <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                  <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

              </children>

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Script_81">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="Script_87">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="DisableLogging_40" />

            <children name="EnableLogging_28" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;sCopyIdList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;-1&lt;/sCopyIdList&gt;&lt;sIdList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;0&lt;/sIdList&gt;&lt;/inputs&gt;&lt;processBlock&gt;ProcessBlock_30&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_60" commented="0" description="" originalStyle="" points="1563.0,92.0" sourceX="497" sourceY="58" status="0" style="defaultEdge" targetX="1365" targetY="105" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1585515140977" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_15" waitSetting="0" width="106" x="940" y="251">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Failure Reason: No data on cloud storage detected for the input jobId [xpath:{/workflow/variables/iJobId}]&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1585515158745" description="if/else based decision" displayName="No Data" height="72" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_35" waitSetting="0" width="79" x="952" y="320">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/bNoDataOnCloud}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="WorkflowEnd_15" commented="0" description="" originalStyle="" points="" sourceX="991" sourceY="356" status="0" style="defaultEdge" targetX="1008" targetY="263" transitionIndex="0" value="true" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="Decision_44" commented="0" description="" originalStyle="" points="" sourceX="991" sourceY="356" status="0" style="defaultEdge" targetX="1291" targetY="353" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1585515318651" description="if/else based decision" displayName="Failed" height="72" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_36" waitSetting="0" width="79" x="1242" y="320">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/sRecallData}.isEmpty()&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_30" commented="0" description="" originalStyle="" points="" sourceX="1111" sourceY="338" status="0" style="defaultEdge" targetX="1496" targetY="353" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="WorkflowEnd_16" commented="0" description="" originalStyle="" points="" sourceX="1185" sourceY="356" status="0" style="defaultEdge" targetX="1200" targetY="269" transitionIndex="0" value="true" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1585515340727" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_16" waitSetting="0" width="106" x="1230" y="253">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Failure Reason: Failed to parse restore vector for the input jobId [xpath:{/workflow/variables/iJobId}]&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1585516082332" description="if/else based decision" displayName="No Data" height="72" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_37" waitSetting="0" width="79" x="1366" y="150">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/sRecallData}.isEmpty()&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="WorkflowEnd_17" commented="0" description="" originalStyle="" points="" sourceX="1405" sourceY="186" status="0" style="defaultEdge" targetX="1416" targetY="288" transitionIndex="0" value="true" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="ExecuteProcessBlock_61" commented="0" description="" originalStyle="" points="" sourceX="1405" sourceY="186" status="0" style="defaultEdge" targetX="1644" targetY="104" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1585516096856" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_17" waitSetting="0" width="106" x="1352" y="261">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Failure Reason: No data on cloud storage detected for the input jobId [xpath:{/workflow/variables/iJobId}]&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1585522326629" description="if/else based decision" displayName="Failed MPs" height="72" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_44" waitSetting="0" width="91" x="1092" y="320">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/bFailedMP}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="Decision_36" commented="0" description="" originalStyle="" points="" sourceX="1093" sourceY="318" status="0" style="defaultEdge" targetX="1302" targetY="354" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="WorkflowEnd_23" commented="0" description="" originalStyle="" points="" sourceX="1143" sourceY="356" status="0" style="defaultEdge" targetX="1148" targetY="266" transitionIndex="0" value="true" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1585522341247" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_23" waitSetting="0" width="106" x="1086" y="253">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/sFailedMPList}&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1595550044252" description="if/else based decision" displayName="Is V1" height="51" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_47" waitSetting="0" width="58" x="1123" y="84">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;0 == xpath:{/workflow/CommServDBQuery_45/resultSets[2]/row[1]/col[1]}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="WorkflowEnd_26" commented="0" description="" originalStyle="" points="1853.0,159.0" sourceX="1152" sourceY="109" status="0" style="defaultEdge" targetX="1846" targetY="47" transitionIndex="0" value="False" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="Decision_48" commented="0" description="" originalStyle="" points="" sourceX="1152" sourceY="109" status="0" style="defaultEdge" targetX="1236" targetY="128" transitionIndex="0" value="True" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1595550161172" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_26" waitSetting="0" width="106" x="1793" y="30">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_45/resultSets[2]/row[1]/col[2]}&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1595550179270" description="if/else based decision" displayName="Is V1" height="51" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_48" waitSetting="0" width="58" x="1204" y="83">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;2 == xpath:{/workflow/CommServDBQuery_45/resultSets[3]/row[1]/col[1]}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="WorkflowEnd_27" commented="0" description="" originalStyle="" points="1479.0,48.0" sourceX="1233" sourceY="108" status="0" style="defaultEdge" targetX="1786" targetY="108" transitionIndex="0" value="False" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="ExecuteProcessBlock_51" commented="0" description="" originalStyle="" points="" sourceX="1233" sourceY="108" status="0" style="defaultEdge" targetX="1333" targetY="95" transitionIndex="0" value="True" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1595550231937" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_27" waitSetting="0" width="106" x="1704" y="93">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Please run the workflow manually with backup job Id as input for V1 index jobs.&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1575314065001" description="creates a super process group" displayName="Check Job Running" height="140" interactive="0" jobMode="0" name="ProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#BEE0B8;gradientColor=#BEE0B8" uniqueName="ProcessBlock_14" waitSetting="0" width="625" x="16" y="4438">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs className="" defaultValue="" listType="0" name="outputs" type="" />

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1575314065001" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_15" waitSetting="0" width="64" x="21" y="69">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="ExecuteProcessBlock_67" commented="0" description="" originalStyle="" points="" sourceX="53" sourceY="84" status="0" style="defaultEdge" targetX="132" targetY="50" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1575314198786" description="activity to execute code snippets in the selected language" displayName="Script" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_20" waitSetting="0" width="74" x="385" y="67">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String status = xpath:{/workflow/ExecuteProcessBlock_67/Script_100/output};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    if(status.isEmpty())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Job &amp;quot; + Integer.toString(xpath:{/workflow/variables/iJobId}) + &amp;quot; not found or failed to check job status&amp;quot;);    &amp;#xD;&amp;#xA;        return false;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    if(status.equals(&amp;quot;Pending&amp;quot;) || status.equals(&amp;quot;Running&amp;quot;) || status.equals(&amp;quot;Waiting&amp;quot;) || status.equals(&amp;quot;Queued&amp;quot;) || status.equals(&amp;quot;Suspended&amp;quot;) || status.equals(&amp;quot;Suspend Pending&amp;quot;) || status.equals(&amp;quot;Interrupt Pending&amp;quot;))&amp;#xD;&amp;#xA;        return true;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    return false;    &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to check job status. Exception &amp;quot; + e);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_15" commented="0" description="" originalStyle="" points="" sourceX="416" sourceY="84" status="0" style="defaultEdge" targetX="529" targetY="84" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578671172009" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_14" waitSetting="0" width="113" x="244" y="67">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Script_20" commented="0" description="" originalStyle="" points="" sourceX="300" sourceY="84" status="0" style="defaultEdge" targetX="425" targetY="83" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578671202629" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_15" waitSetting="0" width="117" x="486" y="67">

        <inputs val="&lt;inputs /&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1583263132047" description="executes a defined process block within the workflow" displayName="Get Job State" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess" uniqueName="ExecuteProcessBlock_67" waitSetting="0" width="106" x="113" y="67">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

          <outputs name="ProcessBlock_31">

            <children name="Start_41" />

            <children name="Job_2" type="">

              <children className="workflow.types.cmd.JobDetails" inputType="workflow.types.cmd.JobDetails" listType="1" name="job" type="{workflow.types.cmd}JobDetails">

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="jobId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" inputType="java.lang.String" name="jobType" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="status" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="phase" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Script_100">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="EnableLogging_31" />

            <children name="DisableLogging_47" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;processBlock&gt;ProcessBlock_31&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="EnableLogging_14" commented="0" description="" originalStyle="" points="" sourceX="136" sourceY="47" status="0" style="defaultEdge" targetX="326" targetY="91" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1575481675666" description="creates a super process group" displayName="Get Recall Data Using Restore Vector" height="1040" interactive="0" jobMode="0" name="ProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#FADB9E;gradientColor=#FADB9E" uniqueName="ProcessBlock_15" waitSetting="0" width="2438" x="84" y="1863">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs className="" defaultValue="" listType="0" name="outputs" type="" />

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1575481675666" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_16" waitSetting="0" width="72" x="27" y="140">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Decision_6" commented="0" description="" originalStyle="" points="" sourceX="65" sourceY="171" status="0" style="defaultEdge" targetX="205" targetY="171" transitionIndex="0" x="-93" y="-1276">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1575482052202" description="executes queries against a commcell database" displayName="Get MediaAgent List" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_13" waitSetting="0" width="143" x="236" y="138">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @jobid int = xpath:{/workflow/variables/iJobId};&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;-- MAs picked in the following order&amp;#xD;&#xD;&#xA;-- 1. MA selected for restore&amp;#xD;&#xD;&#xA;-- 2. Index server for backupset&amp;#xD;&#xD;&#xA;-- 3. Check all enabled datapath MAs in the SP&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if object_id(''tempdb.dbo.#tempMAList'') is not null DROP TABLE #tempMAList&amp;#xD;&#xD;&#xA;CREATE TABLE  #tempMAList (id int identity(1,1), mediaAgent int, release int, version int)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;-- 1. MA selected for restore&amp;#xD;&#xD;&#xA;declare @backup_set_id int = null &amp;#xD;&#xD;&#xA;declare @media_agent_id int = null&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select&#x9;@backup_set_id = [140006],&#x9;&#x9; &amp;#xD;&#xD;&#xA;&#x9;&#x9;@media_agent_id = [1254245399]&amp;#xD;&#xD;&#xA;from (&#x9;select value, optionId &amp;#xD;&#xD;&#xA;&#x9;&#x9;from dbo.GetAllJobOptions(@jobid)) as source_table  &amp;#xD;&#xD;&#xA;pivot ( max(value) for optionId in ([140006], [1254245399])) as pivottable &amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if @media_agent_id is not null &amp;#xD;&#xD;&#xA;begin&amp;#xD;&#xD;&#xA;&#x9;insert into #tempMAList(mediaAgent) values (@media_agent_id);&amp;#xD;&#xD;&#xA;&#x9;set @media_agent_id = null;&amp;#xD;&#xD;&#xA;end&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;-- 2. Index server for backupset&amp;#xD;&#xD;&#xA;select @media_agent_id = currentIdxServer &amp;#xD;&#xD;&#xA;        from app_indexdbinfo(nolock) &amp;#xD;&#xD;&#xA;        where backupSetId = @backup_set_id &amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if @media_agent_id is not null &amp;#xD;&#xD;&#xA;begin&amp;#xD;&#xD;&#xA;&#x9;insert into #tempMAList(mediaAgent) values (@media_agent_id);&amp;#xD;&#xD;&#xA;&#x9;set @media_agent_id = null;&amp;#xD;&#xD;&#xA;end&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;-- 3. Check all enabled datapath MAs in the SP&amp;#xD;&#xD;&#xA;insert into #tempMAList(mediaAgent)&amp;#xD;&#xD;&#xA;select distinct&#x9;dpl.ClientId&amp;#xD;&#xD;&#xA;from MMDrivePool(nolock) dpl&amp;#xD;&#xD;&#xA;join MMDataPath(nolock) dp on dp.DrivePoolId = dpl.DrivePoolId &amp;#xD;&#xD;&#xA;join archGroupCopy(nolock) agc on agc.id = dp.CopyId &amp;#xD;&#xD;&#xA;join APP_Application(nolock) a on a.dataArchGrpID = agc.archGroupId &amp;#xD;&#xD;&#xA;left join #tempMAList t on t.mediaAgent = dpl.ClientId&amp;#xD;&#xD;&#xA;where backupSet = @backup_set_id &amp;#xD;&#xD;&#xA;and dp.Flag &amp;amp; 4 &amp;gt; 0&amp;#xD;&#xD;&#xA;and t.id is null&amp;#xD;&#xD;&#xA;and dpl.ClientId &amp;gt; 1&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;update t&amp;#xD;&#xD;&#xA;set release = r.release&amp;#xD;&#xD;&#xA;, version = ip.HighestSP&amp;#xD;&#xD;&#xA;from #tempMAList t&amp;#xD;&#xD;&#xA;join APP_Client(nolock) c on c.id = t.mediaAgent&amp;#xD;&#xD;&#xA;join simAllGalaxyRel(nolock) r on r.id = c.releaseId&amp;#xD;&#xD;&#xA;left join simInstalledPackages(nolock) ip on ip.ClientId = c.id and ip.simPackageID in (51, 1301) /*MediaAgent*/&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @maList table(id int, mediaAgentId int, name varchar(max), attrVal varchar(max), release int, version int)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;insert into @maList&amp;#xD;&#xD;&#xA;select distinct m.id, m.mediaAgent, a.name, acp.attrVal, m.release, m.version&amp;#xD;&#xD;&#xA;from APP_ClientProp(nolock) acp&amp;#xD;&#xD;&#xA;join APP_Client(nolock) a on a.id = acp.componentNameId&amp;#xD;&#xD;&#xA;join #tempMAList m on a.id = m.mediaAgent&amp;#xD;&#xD;&#xA;where m.id in (select min(id) from #tempMAList group by mediaAgent)&amp;#xD;&#xD;&#xA;and acp.attrName like ''%Galaxy Instance name%''  &amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select id, mediaAgentId, name, attrVal, release, version&amp;#xD;&#xD;&#xA;from @maList&amp;#xD;&#xD;&#xA;order by id&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select distinct id, cast(mediaAgentId as varchar(max)) mediaAgentId, name&amp;#xD;&#xD;&#xA;from @maList&amp;#xD;&#xD;&#xA;where not exists (&amp;#xD;&#xD;&#xA;&#x9;select 1&amp;#xD;&#xD;&#xA;&#x9;from APP_AdvanceSettings(NOLOCK)&amp;#xD;&#xD;&#xA;&#x9;where keyName = ''Do_Not_DELETE_RESTORE_VECTOR''&amp;#xD;&#xD;&#xA;&#x9;and relativePath = ''EventManager''&amp;#xD;&#xD;&#xA;&#x9;and enabled = 1&amp;#xD;&#xD;&#xA;&#x9;and deleted = 0&amp;#xD;&#xD;&#xA;&#x9;and entityId = mediaAgentId)&amp;#xD;&#xD;&#xA;order by id&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="EnableLogging_3" commented="0" description="" originalStyle="" points="" sourceX="323" sourceY="187" status="0" style="defaultEdge" targetX="518" targetY="186" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1575487658092" description="iterates a group of activities over a list of values" displayName="Iterate MediaAgents" height="450" interactive="0" jobMode="0" name="ForEach" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#E0E085;gradientColor=#E0E085" uniqueName="ForEach_1" waitSetting="0" width="2375" x="32" y="585">

        <activitySchema>

          <inputs>

            <children className="java.lang.String" inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children className="java.lang.Object" inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            <children className="java.lang.Integer" defaultValue="1" inputType="java.lang.Integer" name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Boolean" defaultValue="false" inputType="java.lang.Boolean" name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean" />

          </inputs>

          <outputs name="outputs">

            <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="0" name="row" type="{workflow.types.data}DataRow">

              <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;name class=&quot;java.lang.String&quot;&gt;row&lt;/name&gt;&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_13/resultSets[1]/row}&lt;/values&gt;&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;1&lt;/numberOfParallelExecutions&gt;&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/continueOnFailure&gt;&lt;/inputs&gt;" />

        <transition activity="Decision_18" commented="0" description="" originalStyle="" points="" sourceX="887" sourceY="425" status="0" style="defaultEdge" targetX="999" targetY="159" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <superProcess>

          <Start commented="0" continueOnFailure="0" created="1575487658092" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_17" waitSetting="0" width="58" x="43" y="113">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="Script_165" commented="0" description="" originalStyle="" points="" sourceX="72" sourceY="76" status="0" style="defaultEdge" targetX="280" targetY="76" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Start>

          <Activity commented="0" continueOnFailure="0" created="1575490258602" description="executes a defined process block within the workflow" displayName="Get Client Details" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#BEE0B8;gradientColor=#BEE0B8" uniqueName="ExecuteProcessBlock_32" waitSetting="0" width="126" x="546" y="111">

            <activitySchema>

              <inputs className="" defaultValue="" listType="0" name="inputs" type="">

                <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sClientName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

              </inputs>

              <outputs name="ProcessBlock_17">

                <children name="Start_19" />

                <children name="DisableLogging_1" />

                <children name="Execute_1">

                  <children className="java.lang.String" documentation="xml output contents" inputType="java.lang.String" name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children name="Script_ClientDetails">

                  <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

                <children name="Decision_4" />

                <children name="EnableLogging_13" />

                <children name="DisableLogging_14" />

              </outputs>

            </activitySchema>

            <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;sClientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ForEach_1/row/col[@name=&quot;name&quot;]}&lt;/sClientName&gt;&lt;/inputs&gt;&lt;processBlock&gt;ProcessBlock_17&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

            <transition activity="EnableLogging_6" commented="0" description="" originalStyle="" points="" sourceX="299" sourceY="76" status="0" style="defaultEdge" targetX="487" targetY="135" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1575497185015" description="activity to execute code snippets in the selected language" displayName="Get DumpRV startUpPath" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_22" waitSetting="0" width="172" x="909" y="111">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{    &amp;#xD;&amp;#xA;    Map m = xpath:{/workflow/ExecuteProcessBlock_32/Script_ClientDetails/output};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(m.get(&amp;quot;clientOs&amp;quot;).contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;        return m.get(&amp;quot;clientBaseFolder&amp;quot;);&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to get startup path for looking up restore vector for v1 index. Exception &amp;quot; + e);&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_23" commented="0" description="" originalStyle="" points="" sourceX="361" sourceY="76" status="0" style="defaultEdge" targetX="509" targetY="76" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1575497222173" description="activity to execute code snippets in the selected language" displayName="Get DumpRV command" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_23" waitSetting="0" width="161" x="1109" y="111">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    Map m = xpath:{/workflow/ExecuteProcessBlock_32/Script_ClientDetails/output};&amp;#xD;&amp;#xA;    String command;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(m.get(&amp;quot;clientOs&amp;quot;).toLowerCase().contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;        command = &amp;quot;CreateIndex.exe&amp;quot;;&amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;        command = m.get(&amp;quot;clientMediaAgentFolder&amp;quot;) + &amp;quot;/createIndex&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    return command;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to get command for looking up restore vector for v1 index. Exception &amp;quot; + e);&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_92" commented="0" description="" originalStyle="" points="" sourceX="665" sourceY="76" status="0" style="defaultEdge" targetX="835" targetY="76" transitionIndex="0" x="0" y="0">

              <condition language="1" script="!xpath:{/workflow/Script_23/output}.isEmpty()" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1575498481273" description="Execute a command on a remote machine" displayName="Run Dump RV" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_3" waitSetting="0" width="107" x="1501" y="111">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ForEach_1/row/col[@name=&quot;name&quot;]}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_22/output}&lt;/startUpPath&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_23/output}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_92/output}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_26" commented="0" description="" originalStyle="" points="" sourceX="1034" sourceY="128" status="0" style="defaultEdge" targetX="1370" targetY="134" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1575605776764" description="executes queries against a commcell database" displayName="Get Recall Data" height="36" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_14" waitSetting="0" width="116" x="614" y="289">

            <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @copyPrec int = 0;&amp;#xD;&#xD;&#xA;declare @jobid int = xpath:{/workflow/variables/iJobId};&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;--Check if copy was explicitly selected for the job&amp;#xD;&#xD;&#xA;select @copyPrec = ISNULL([957862300], 0) &amp;#xD;&#xD;&#xA;from ( select value,optionId&amp;#xD;&#xD;&#xA;       from dbo.GetAllJobOptions(@jobid))&amp;#xD;&#xD;&#xA;&#x9;   as SourceTable PIVOT ( &amp;#xD;&#xD;&#xA;&#x9;   MAX(value) FOR OPTIONID IN ([957862300]))&amp;#xD;&#xD;&#xA;&#x9;   AS PIVOTTABLE&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if object_id(''tempdb.dbo.#tempDeviceInfo'') is not null drop table #tempDeviceInfo&amp;#xD;&#xD;&#xA;create table #tempDeviceInfo (DeviceId int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, DeviceTypeId int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, Folder varchar(2048)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, MountPathId bigint&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;--, username nvarchar(max)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;--, password nvarchar(max)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, MountPathName nvarchar(1024)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, MediaSideId int)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;insert into #tempDeviceInfo &amp;#xD;&#xD;&#xA;select distinct d.DeviceId, d.DeviceTypeId, dc.Folder, mp.MountPathId&amp;#xD;&#xD;&#xA;--, dc.UserName, dc.UserPassword&amp;#xD;&#xD;&#xA;, mp.MountPathName, mp.MediaSideId&amp;#xD;&#xD;&#xA;from MMMountPath(nolock) mp&amp;#xD;&#xD;&#xA;join MMMountPathToStorageDevice(nolock) mpsd on mpsd.MountPathId = mp.MountPathId&amp;#xD;&#xD;&#xA;join MMDevice(nolock) d on d.DeviceId = mpsd.DeviceId&amp;#xD;&#xD;&#xA;join MMDeviceController(nolock) dc ON dc.DeviceId = d.DeviceId&amp;#xD;&#xD;&#xA;where d.DeviceTypeId &amp;lt;&amp;gt; 1&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if object_id(''tempdb.dbo.#chunkInfo'') is not null drop table #chunkInfo&amp;#xD;&#xD;&#xA;create table #chunkInfo(&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;iMountPathId int,&#x9;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;iVolumeId int,&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;hasStore int,&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;iarchFileId int,&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;iarchChunkId bigint,&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;physicalOffset bigint,&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;cclip varchar(255),&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;archCopyId smallint,&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;commCellId int,&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;chunkNumber int);&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;insert into #chunkInfo&#x9;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xD;&#xA;select distinct d.MountPathId&amp;#xD;&#xD;&#xA;    , v.VolumeId&amp;#xD;&#xD;&#xA;    , case v.SIDBStoreId WHEN 0 THEN 0 ELSE 1 END as hasStore&amp;#xD;&#xD;&#xA;    , m.archFileId&amp;#xD;&#xD;&#xA;    , m.archChunkId&amp;#xD;&#xD;&#xA;    , m.physicalOffset&amp;#xD;&#xD;&#xA;    , case d.DeviceTypeId when 53 then c.cclip else '''' end cclip&amp;#xD;&#xD;&#xA;    , m.archCopyId&amp;#xD;&#xD;&#xA;    , m.commCellId&amp;#xD;&#xD;&#xA;    , m.chunkNumber&amp;#xD;&#xD;&#xA;from archchunkmapping(nolock) m&amp;#xD;&#xD;&#xA;join archchunk(nolock) c on c.id = m.archChunkId &amp;#xD;&#xD;&#xA;   and c.commCellId = m.chunkCommCellId&amp;#xD;&#xD;&#xA;join mmvolume(nolock) v on v.VolumeId = c.volumeId&amp;#xD;&#xD;&#xA;join #tempDeviceInfo(nolock) d on d.MediaSideId = v.MediaSideId&amp;#xD;&#xD;&#xA;join archGroupCopy(nolock) agc on agc.id = m.archCopyId&amp;#xD;&#xD;&#xA;where (@copyPrec = 0 or agc.copy = @copyPrec)&amp;#xD;&#xD;&#xA;xpath:{/workflow/Script_Restore_Vector_Query/output}&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;--Detect copy precedence when nothing explicitly selected by user&amp;#xD;&#xD;&#xA;if @copyPrec = 0&amp;#xD;&#xD;&#xA;begin&amp;#xD;&#xD;&#xA;&#x9;declare copy_cursor cursor for&amp;#xD;&#xD;&#xA;&#x9;select distinct iarchFileId, commCellId&amp;#xD;&#xD;&#xA;&#x9;from #chunkInfo&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;declare @archFileId int = 0&amp;#xD;&#xD;&#xA;&#x9;declare @commCellId int = 0&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;open copy_cursor&amp;#xD;&#xD;&#xA;&#x9;fetch next from copy_cursor into @archFileId, @commCellId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;while @@FETCH_STATUS = 0&amp;#xD;&#xD;&#xA;&#x9;begin&amp;#xD;&#xD;&#xA;&#x9;&#x9;declare @l_outArchCopyId int&amp;#xD;&#xD;&#xA;&#x9;&#x9;declare @l_outAFC_isValid int&amp;#xD;&#xD;&#xA;&#x9;&#x9;declare @l_outAFC_flag int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&amp;#xD;&#xD;&#xA;&#x9;&#x9;exec archFileCopyPreferred @archFileId,@commCellId,0,1,1,@l_outArchCopyId output,@l_outAFC_isValid output,@l_outAFC_flag output&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;&#x9;delete from #chunkInfo where iarchFileId = @archFileId &amp;#xD;&#xD;&#xA;            and archCopyId &amp;lt;&amp;gt; @l_outArchCopyId &amp;#xD;&#xD;&#xA;            and commCellId = @commCellId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;&#x9;fetch next from copy_cursor into @archFileId, @commCellId&amp;#xD;&#xD;&#xA;&#x9;end&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;close copy_cursor&amp;#xD;&#xD;&#xA;    deallocate copy_cursor&amp;#xD;&#xD;&#xA;end&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;--Chunk Information&amp;#xD;&#xD;&#xA;select cast(iMountPathId as varchar(max)) MountPathId&amp;#xD;&#xD;&#xA;&#x9;&#x9;,cast(iVolumeId as varchar(max)) VolumeId&amp;#xD;&#xD;&#xA;&#x9;&#x9;,cast(hasStore as varchar(max)) hasStore&amp;#xD;&#xD;&#xA;&#x9;&#x9;,cast(iarchFileId as varchar(max)) archFileId&amp;#xD;&#xD;&#xA;&#x9;&#x9;,cast(iarchChunkId as varchar(max)) archChunkId&amp;#xD;&#xD;&#xA;&#x9;&#x9;,cast(physicalOffset as varchar(max)) physicalOffset&amp;#xD;&#xD;&#xA;&#x9;&#x9;,cclip  &amp;#xD;&#xD;&#xA;from #chunkInfo&amp;#xD;&#xD;&#xA;order by iMountPathId, iarchFileId, chunkNumber&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;--Mountpath - MA information for parallel execution&amp;#xD;&#xD;&#xA;if object_id(''tempdb.dbo.#mountPathInfo'') is not null drop table #mountPathInfo&amp;#xD;&#xD;&#xA;create table #mountPathInfo(MountPathId int&#x9;  &amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, ChunkCount int)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;insert into #mountPathInfo&amp;#xD;&#xD;&#xA;select iMountPathId&amp;#xD;&#xD;&#xA;        , COUNT(*)&amp;#xD;&#xD;&#xA;from #chunkInfo&amp;#xD;&#xD;&#xA;group by iMountPathId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;--rowNumber - to inject delays between executions&amp;#xD;&#xD;&#xA;--ChunkCount - for splitting chunks between parallel recall processes&amp;#xD;&#xD;&#xA;select cast(row_number() over (order by (select 1)) as varchar(max)) rowNumber&amp;#xD;&#xD;&#xA;&#x9;, cast(mpi.MountPathId as varchar(max)) MountPathId&amp;#xD;&#xD;&#xA;&#x9;, di.MountPathName&amp;#xD;&#xD;&#xA;&#x9;, cast(di.DeviceTypeId as varchar(max)) DeviceTypeId&amp;#xD;&#xD;&#xA;&#x9;, cast(mpi.ChunkCount as varchar(max)) ChunkCount&amp;#xD;&#xD;&#xA;from #mountPathInfo mpi&amp;#xD;&#xD;&#xA;join #tempDeviceInfo di on di.MountPathId = mpi.MountPathId&amp;#xD;&#xD;&#xA;order by mpi.MountPathId&lt;/query&gt;&lt;/inputs&gt;" />

            <transition activity="EnableLogging_5" commented="0" description="" originalStyle="" points="" sourceX="959" sourceY="256" status="0" style="defaultEdge" targetX="1103" targetY="256" transitionIndex="0" x="-7" y="33" />

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1575836000248" description="activity to execute code snippets in the selected language" displayName="Get Recall Data" height="32" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_30" waitSetting="0" width="116" x="2095" y="329">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;import org.jdom2.Element;&amp;#xD;&amp;#xA;import org.jdom2.Document;&amp;#xD;&amp;#xA;import org.jdom2.output.XMLOutputter;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    DataSet rs1 = xpath:{/workflow/CommServDBQuery_14/resultSets}.get(0);&amp;#xD;&amp;#xA;    DataSet rs2 = xpath:{/workflow/CommServDBQuery_14/resultSets}.get(1);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    Element mountPaths = new Element(&amp;quot;MountPaths&amp;quot;);&amp;#xD;&amp;#xA;    Document doc = new Document(mountPaths);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    Map mpMap = new HashMap(); &amp;#xD;&amp;#xA;    //order is guaranteed by the query. Ordered by MountPathId -&amp;gt; VolumeId -&amp;gt; ArchFileId -&amp;gt; ChunkId&amp;#xD;&amp;#xA;    while(rs1.hasNext())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        Element chunk = new Element(&amp;quot;Chunk&amp;quot;);&amp;#xD;&amp;#xA;        chunk.setAttribute(&amp;quot;VolumeId&amp;quot;, rs1.get(&amp;quot;VolumeId&amp;quot;));&amp;#xD;&amp;#xA;        chunk.setAttribute(&amp;quot;IsDeduped&amp;quot;, rs1.get(&amp;quot;hasStore&amp;quot;));&amp;#xD;&amp;#xA;        chunk.setAttribute(&amp;quot;ArchFileId&amp;quot;, rs1.get(&amp;quot;archFileId&amp;quot;));&amp;#xD;&amp;#xA;        chunk.setAttribute(&amp;quot;Chunk&amp;quot;, rs1.get(&amp;quot;archChunkId&amp;quot;));&amp;#xD;&amp;#xA;        chunk.setAttribute(&amp;quot;Offset&amp;quot;, rs1.get(&amp;quot;physicalOffset&amp;quot;));&amp;#xD;&amp;#xA;        chunk.setAttribute(&amp;quot;Cclip&amp;quot;, rs1.get(&amp;quot;cclip&amp;quot;));&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        if(null != mpMap &amp;amp;&amp;amp; mpMap.containsKey(rs1.get(&amp;quot;MountPathId&amp;quot;)))&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            List elementList = mpMap.get(rs1.get(&amp;quot;MountPathId&amp;quot;));&amp;#xD;&amp;#xA;            elementList.add(chunk);&amp;#xD;&amp;#xA;            mpMap.put(rs1.get(&amp;quot;MountPathId&amp;quot;), elementList); &amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        else&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            List elementList = new ArrayList();&amp;#xD;&amp;#xA;            elementList.add(chunk);&amp;#xD;&amp;#xA;            mpMap.put(rs1.get(&amp;quot;MountPathId&amp;quot;), elementList);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    int threadCount = 1;&amp;#xD;&amp;#xA;    int mpCount = xpath:{/workflow/CommServDBQuery_14/resultSets[2]/rowCount};&amp;#xD;&amp;#xA;//    Let threadCount per mountpath stay as 1 as sqlite reads could conflict&amp;#xD;&amp;#xA;//    if(mpCount &amp;lt; 10) &amp;#xD;&amp;#xA;//    {&amp;#xD;&amp;#xA;//        threadCount = (10 / mpCount);&amp;#xD;&amp;#xA;//    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    while(rs2.hasNext()) &amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        Element mountPath = new Element(&amp;quot;MountPath&amp;quot;);&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;MountPathId&amp;quot;, rs2.get(&amp;quot;MountPathId&amp;quot;));&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;MountPathName&amp;quot;, rs2.get(&amp;quot;MountPathName&amp;quot;));&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;Vendor&amp;quot;, rs2.get(&amp;quot;DeviceTypeId&amp;quot;));&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;MediaAgentId&amp;quot;, Integer.toString(xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;mediaAgentId&amp;quot;]}));&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;MediaAgentOs&amp;quot;, xpath:{/workflow/ExecuteProcessBlock_32/Script_ClientDetails/output}.get(&amp;quot;clientOs&amp;quot;));&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;MediaAgentInstance&amp;quot;, xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;attrVal&amp;quot;]});&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;MediaAgentName&amp;quot;, xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;name&amp;quot;]});&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;MediaAgentBase&amp;quot;, xpath:{/workflow/ExecuteProcessBlock_32/Script_ClientDetails/output}.get(&amp;quot;clientBaseFolder&amp;quot;));&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;MediaAgentTemp&amp;quot;, xpath:{/workflow/ExecuteProcessBlock_32/Script_ClientDetails/output}.get(&amp;quot;clientTempFolder&amp;quot;));&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;ChunkCount&amp;quot;, rs2.get(&amp;quot;ChunkCount&amp;quot;));&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;RowNumber&amp;quot;, rs2.get(&amp;quot;rowNumber&amp;quot;));&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;ThreadCount&amp;quot;, Integer.toString(threadCount));&amp;#xD;&amp;#xA;        mountPaths.addContent(mountPath); &amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        if(null != mpMap &amp;amp;&amp;amp; mpMap.containsKey(rs2.get(&amp;quot;MountPathId&amp;quot;)))&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            Element chunks = new Element(&amp;quot;Chunks&amp;quot;);&amp;#xD;&amp;#xA;            &amp;#xD;&amp;#xA;            List elementList = mpMap.get(rs2.get(&amp;quot;MountPathId&amp;quot;));&amp;#xD;&amp;#xA;            for(int iter = 0; iter &amp;lt; elementList.size(); ++iter)&amp;#xD;&amp;#xA;            {&amp;#xD;&amp;#xA;                chunks.addContent(elementList.get(iter));&amp;#xD;&amp;#xA;            }&amp;#xD;&amp;#xA;            mountPath.addContent(chunks);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;sRecallData&amp;quot;, new XMLOutputter().outputString(doc));&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to generate file list for recall. Exception &amp;quot; + e);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Break_3" commented="0" description="" originalStyle="" points="" sourceX="1057" sourceY="359" status="0" style="defaultEdge" targetX="1072" targetY="476" transitionIndex="0" x="54" y="40" />

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1575924716111" description="if/else based decision" displayName="Debug" height="57" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_7" waitSetting="0" width="66" x="501" y="279">

            <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;1 == xpath:{/workflow/variables/iDebugMode}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

            <transition activity="DisableLogging_5" commented="0" description="" displayName="Debug Disabled" offsetX="0" offsetY="-3" originalStyle="" points="" sourceX="931" sourceY="256" status="0" style="defaultEdge" targetX="931" targetY="164" transitionIndex="0" value="false" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

            <transition activity="CommServDBQuery_14" commented="0" description="" originalStyle="" points="" sourceX="931" sourceY="256" status="0" style="defaultEdge" targetX="1116" targetY="257" transitionIndex="0" value="true" x="-7" y="33">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1575924818875" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_5" waitSetting="0" width="117" x="476" y="378">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="CommServDBQuery_14" commented="0" description="" originalStyle="" points="672.0,372.0" sourceX="931" sourceY="164" status="0" style="defaultEdge" targetX="1070" targetY="248" transitionIndex="0" x="-7" y="33">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1575924973017" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_5" waitSetting="0" width="113" x="773" y="290">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="Script_44" commented="0" description="" originalStyle="" points="" sourceX="1226" sourceY="256" status="0" style="defaultEdge" targetX="1249" targetY="136" transitionIndex="0" x="-7" y="33">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1575933126470" description="interrupts a process block execution" displayName="Break" height="34" interactive="0" jobMode="0" name="Break" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.InterruptActivity" uniqueName="Break_1" waitSetting="0" width="100" x="339" y="378">

            <inputs val="&lt;inputs /&gt;" />

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1576697043225" description="activity to execute code snippets in the selected language" displayName="Get Recall Data" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_44" waitSetting="0" width="116" x="927" y="290">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(0 == xpath:{/workflow/CommServDBQuery_14/resultSets[1]/rowCount} || 0 == xpath:{/workflow/CommServDBQuery_14/resultSets[2]/rowCount})&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Did not find any data on cloud for the input&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;return true;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Break_2" commented="0" description="" originalStyle="" points="" sourceX="843" sourceY="319" status="0" style="defaultEdge" targetX="844" targetY="412" transitionIndex="0" x="0" y="0">

              <condition language="1" script="false == xpath:{/workflow/Script_44/output}" />

            </transition>

            <transition activity="ForEach_2" commented="0" description="" originalStyle="" points="" sourceX="985" sourceY="307" status="0" style="defaultEdge" targetX="1120" targetY="324" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1576698342049" description="if/else based decision" displayName="Debug" height="54" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_8" waitSetting="0" width="66" x="452" y="101">

            <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;1 == xpath:{/workflow/variables/iDebugMode}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

            <transition activity="DisableLogging_6" commented="0" description="" originalStyle="" points="" sourceX="169" sourceY="76" status="0" style="defaultEdge" targetX="170" targetY="150" transitionIndex="0" value="false" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

            <transition activity="ExecuteProcessBlock_32" commented="0" description="" originalStyle="" points="" sourceX="169" sourceY="76" status="0" style="defaultEdge" targetX="263" targetY="77" transitionIndex="0" value="true" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1576698448701" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_6" waitSetting="0" width="117" x="428" y="39">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="ExecuteProcessBlock_32" commented="0" description="" originalStyle="" points="612.0,106.0" sourceX="170" sourceY="150" status="0" style="defaultEdge" targetX="338" targetY="61" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1576698548806" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_6" waitSetting="0" width="113" x="705" y="111">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="Script_22" commented="0" description="" displayName="Success" originalStyle="" points="" sourceX="205" sourceY="76" status="0" style="defaultEdge" targetX="361" targetY="76" transitionIndex="0" x="0" y="0">

              <condition language="1" script="if(null == xpath:{/workflow/ExecuteProcessBlock_32/Script_ClientDetails/output})&#xD;&#xA;{&#xD;&#xA;    logger.info(&quot;Failed to get client details for MA &quot; + xpath:{/workflow/ForEach_1/row/col[@name=&quot;name&quot;]});&#xD;&#xA;    return false;&#xD;&#xA;}&#xD;&#xA;return true;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1578420282238" description="interrupts a process block execution" displayName="Break (OS)" height="34" interactive="0" jobMode="0" name="Break" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.InterruptActivity" uniqueName="Break_2" waitSetting="0" width="100" x="937" y="385">

            <onEnter language="1" script="workflow.setVariable(&quot;bNoDataOnCloud&quot;, true);" />

            <inputs val="&lt;inputs /&gt;" />

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1578420284103" description="interrupts a process block execution" displayName="Break" height="34" interactive="0" jobMode="0" name="Break" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.InterruptActivity" uniqueName="Break_3" waitSetting="0" width="100" x="2255" y="328">

            <inputs val="&lt;inputs /&gt;" />

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1575518833897" description="activity to execute code snippets in the selected language" displayName="Check Restore Vector" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_26" waitSetting="0" width="155" x="1679" y="111">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Checking if MA [&amp;quot; + xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;name&amp;quot;]} + &amp;quot;] has the restore vector&amp;quot;);&amp;#xD;&amp;#xA;    Map m = xpath:{/workflow/ExecuteProcessBlock_32/Script_ClientDetails/output}; &amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    String os = xpath:{/workflow/ExecuteProcessBlock_32/Script_ClientDetails/output}.get(&amp;quot;clientOs&amp;quot;);&amp;#xD;&amp;#xA;    String cmd;&amp;#xD;&amp;#xA;          &amp;#xD;&amp;#xA;    if(os.toLowerCase().contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;        cmd = &amp;quot;CloudChunkRecall.exe&amp;quot;;  &amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;        cmd = m.get(&amp;quot;clientBaseFolder&amp;quot;) + &amp;quot;/CloudChunkRecall&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    return cmd;    &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Error generating recall command for parsing restore vector&amp;quot; + e);&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_93" commented="0" description="" originalStyle="" points="1880.0,164.0" sourceX="1408" sourceY="128" status="0" style="defaultEdge" targetX="1408" targetY="203" transitionIndex="0" x="0" y="0">

              <condition language="1" script="!xpath:{/workflow/Script_26/output}.isEmpty()" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1575519703419" description="Execute a command on a remote machine" displayName="Check Restore Vector" height="40" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_4" waitSetting="0" width="155" x="1589" y="177">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ForEach_1/row/col[@name=&quot;name&quot;]}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_22/output}&lt;/startUpPath&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_26/output}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_93/output} -idxver 1&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_V1_Parse_Result" commented="0" description="" originalStyle="" points="" sourceX="1592" sourceY="128" status="0" style="defaultEdge" targetX="1590" targetY="192" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1575558658196" description="activity to execute code snippets in the selected language" displayName="Check Restore Vector" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_V1_Parse_Result" waitSetting="0" width="155" x="1388" y="180">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String mediaAgent = xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;name&amp;quot;]};&amp;#xD;&amp;#xA;    int errorCode = xpath:{/workflow/ExecuteCommand_4/errorCode};&amp;#xD;&amp;#xA;    int exitCode = xpath:{/workflow/ExecuteCommand_4/exitCode};&amp;#xD;&amp;#xA;    String commandOutput = xpath:{/workflow/ExecuteCommand_4/commandOutput};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(errorCode != 0)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Failed to run tool on &amp;quot; + mediaAgent);&amp;#xD;&amp;#xA;        return false; //Still try to check if v2 index restore vector is present &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(exitCode != 0)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        if(commandOutput.contains(&amp;quot;No such file or directory&amp;quot;))&amp;#xD;&amp;#xA;        {   &amp;#xD;&amp;#xA;            logger.info(&amp;quot;V1 index support for cloud restores not available on this MA - &amp;quot; + mediaAgent);&amp;#xD;&amp;#xA;            return false; //Still try to check if v2 index restore vector is present&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        if(commandOutput.contains(&amp;quot;V1 restore vector not found&amp;quot;))&amp;#xD;&amp;#xA;        {   &amp;#xD;&amp;#xA;            //logger.info(&amp;quot;V1 Restore vector not found on MA - &amp;quot; + mediaAgent);&amp;#xD;&amp;#xA;            return false; //Still try to check if v2 index restore vector is present&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        logger.info(&amp;quot;Error running tool on MA &amp;quot; + mediaAgent);&amp;#xD;&amp;#xA;        return false; &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;Restore vector found on MA &amp;quot; + mediaAgent);&amp;#xD;&amp;#xA;    return true; //Don''t check further if restore vector is found&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Exception parsing restore vector check response. Exception&amp;quot; + e);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_5" commented="0" description="" displayName="No restore vector for V1 index found" originalStyle="" points="" sourceX="1591" sourceY="197" status="0" style="defaultEdge" targetX="948" targetY="208" transitionIndex="0" x="0" y="0">

              <condition language="1" script="false == xpath:{/workflow/Script_V1_Parse_Result/output}" />

            </transition>

            <transition activity="Script_27" commented="0" description="" displayName="Restore vector found - V1 Index" originalStyle="" points="972.0,245.0" sourceX="1591" sourceY="197" status="0" style="defaultEdge" targetX="393" targetY="196" transitionIndex="0" x="0" y="0">

              <condition language="1" script="true == xpath:{/workflow/Script_V1_Parse_Result/output}" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1575559656444" description="Execute a command on a remote machine" displayName="Check Restore Vector" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_5" waitSetting="0" width="155" x="1013" y="180">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ForEach_1/row/col[@name=&quot;name&quot;]}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_22/output}&lt;/startUpPath&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_26/output}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_93/output} -idxver 2&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_V2_Parse_Result" commented="0" description="" originalStyle="" points="" sourceX="877" sourceY="197" status="0" style="defaultEdge" targetX="461" targetY="199" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1575559723677" description="activity to execute code snippets in the selected language" displayName="Check Restore Vector" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_V2_Parse_Result" waitSetting="0" width="155" x="776" y="180">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String mediaAgent = xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;name&amp;quot;]};&amp;#xD;&amp;#xA;    int errorCode = xpath:{/workflow/ExecuteCommand_5/errorCode};&amp;#xD;&amp;#xA;    int exitCode = xpath:{/workflow/ExecuteCommand_5/exitCode};&amp;#xD;&amp;#xA;    String commandOutput = xpath:{/workflow/ExecuteCommand_5/commandOutput};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(errorCode != 0)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Failed to run tool on &amp;quot; + mediaAgent);&amp;#xD;&amp;#xA;        return false; &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(exitCode != 0)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        if(commandOutput.contains(&amp;quot;No such file or directory&amp;quot;))&amp;#xD;&amp;#xA;        {   &amp;#xD;&amp;#xA;            logger.info(&amp;quot;Restore vector not found on MA - &amp;quot; + mediaAgent);&amp;#xD;&amp;#xA;            return false; &amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        logger.info(&amp;quot;Error running tool on MA &amp;quot; + mediaAgent);&amp;#xD;&amp;#xA;        return false; &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;Restore vector found on MA &amp;quot; + mediaAgent);&amp;#xD;&amp;#xA;    return true; //Don''t check further if restore vector is found&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Exception parsing restore vector check response. Exception&amp;quot; + e);&amp;#xD;&amp;#xA;    return false; &amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_27" commented="0" description="" displayName="Restore vector found - V2 Index" originalStyle="" points="" sourceX="779" sourceY="197" status="0" style="defaultEdge" targetX="647" targetY="199" transitionIndex="0" x="0" y="0">

              <condition language="1" script="true == xpath:{/workflow/Script_V2_Parse_Result/output}" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1575587755036" description="activity to execute code snippets in the selected language" displayName="Command" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_27" waitSetting="0" width="88" x="397" y="180">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String os = xpath:{/workflow/ExecuteProcessBlock_32/Script_ClientDetails/output}.get(&amp;quot;clientOs&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(os.toLowerCase().contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;        return &amp;quot;type&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    return &amp;quot;cat&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to read restore vector data. Exception: &amp;quot; + e);&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_28" commented="0" description="" originalStyle="" points="" sourceX="389" sourceY="197" status="0" style="defaultEdge" targetX="307" targetY="195" transitionIndex="0" x="0" y="0">

              <condition language="1" script="!xpath:{/workflow/Script_27/output}.isEmpty()" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1575588291104" description="activity to execute code snippets in the selected language" displayName="Argument" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_28" waitSetting="0" width="86" x="262" y="180">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String os = xpath:{/workflow/ExecuteProcessBlock_32/Script_ClientDetails/output}.get(&amp;quot;clientOs&amp;quot;);&amp;#xD;&amp;#xA;    String arg = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(!os.toLowerCase().contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;        arg = xpath:{/workflow/ExecuteProcessBlock_32/Script_ClientDetails/output}.get(&amp;quot;clientTempFolder&amp;quot;) + &amp;quot;/&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    arg += &amp;quot;CloudChunk_&amp;quot; + Integer.toString(xpath:{/workflow/system/jobId}) + &amp;quot;_af.txt&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    return arg;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to read restore vector data. Exception: &amp;quot; + e);&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_29" commented="0" description="" originalStyle="" points="" sourceX="277" sourceY="197" status="0" style="defaultEdge" targetX="187" targetY="200" transitionIndex="0" x="0" y="0">

              <condition language="1" script="!xpath:{/workflow/Script_28/output}.isEmpty()" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1575588477017" description="activity to execute code snippets in the selected language" displayName="Path" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_29" waitSetting="0" width="56" x="155" y="180">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String os = xpath:{/workflow/ExecuteProcessBlock_32/Script_ClientDetails/output}.get(&amp;quot;clientOs&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(os.toLowerCase().contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;        return xpath:{/workflow/ExecuteProcessBlock_32/Script_ClientDetails/output}.get(&amp;quot;clientTempFolder&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to read restore vector data. Exception: &amp;quot; + e);&amp;#xD;&amp;#xA;    return &amp;quot;error&amp;quot;;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_7" commented="0" description="" originalStyle="" points="" sourceX="183" sourceY="197" status="0" style="defaultEdge" targetX="183" targetY="269" transitionIndex="0" x="0" y="0" />

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1575588523487" description="Execute a command on a remote machine" displayName="Parse Restore Vector" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_7" waitSetting="0" width="153" x="106" y="290">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ForEach_1/row/col[@name=&quot;name&quot;]}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_29/output}&lt;/startUpPath&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_27/output}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_28/output}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_Restore_Vector_Query" commented="0" description="" originalStyle="" points="" sourceX="178" sourceY="265" status="0" style="defaultEdge" targetX="362" targetY="267" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1575588591331" description="activity to execute code snippets in the selected language" displayName="Parse Restore Vector" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_Restore_Vector_Query" waitSetting="0" width="153" x="312" y="290">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;//CloudChunkRecall creates a text file contaninig the archfile and minimum offset.&amp;#xD;&amp;#xA;//Since we do not know the individual file size, we do not have a way to determine the end offset&amp;#xD;&amp;#xA;//As a result we determine the first chunk required for the AFile and assume all chunks after that might be required in the worst case.&amp;#xD;&amp;#xA;//For dedup, this results in recalling additional metadata files which should not be a big overhead, but for non-dedup&amp;#xD;&amp;#xA;//we could end up recalling more chunks than required. &amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    int errorCode = xpath:{/workflow/ExecuteCommand_7/errorCode};&amp;#xD;&amp;#xA;    int exitCode = xpath:{/workflow/ExecuteCommand_7/exitCode};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(errorCode != 0 || exitCode != 0)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Failed to read restore vector data. ErrorCode [&amp;quot; + Integer.toString(errorCode) + &amp;quot;] ExitCode [&amp;quot; + Integer.toString(exitCode) + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;        return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    String data = xpath:{/workflow/ExecuteCommand_7/commandOutput};&amp;#xD;&amp;#xA;    int appType = xpath:{/workflow/variables/iAppType};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(data.isEmpty())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Failed to read restore vector data&amp;quot;);&amp;#xD;&amp;#xA;        return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String[] dataSplit = data.split(&amp;quot;\\s+&amp;quot;);&amp;#xD;&amp;#xA;    String query = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    for(String afileOffset : dataSplit)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        int idx = afileOffset.indexOf(&amp;quot;(&amp;quot;);&amp;#xD;&amp;#xA;        String size = afileOffset.substring(idx + 1, afileOffset.length() - 1);&amp;#xD;&amp;#xA;        switch(appType)&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            case 13: /*APP_NAS_FS*/&amp;#xD;&amp;#xA;                if(!size.trim().equals(&amp;quot;0&amp;quot;))&amp;#xD;&amp;#xA;                    query += (query.isEmpty() ? &amp;quot;&amp;quot; : &amp;quot; or&amp;quot;) + &amp;quot;(m.archFileId = &amp;quot; + afileOffset.substring(0, idx) + &amp;quot; and m.logicalOffset = 0)&amp;quot;;&amp;#xD;&amp;#xA;                query += (query.isEmpty() ? &amp;quot;&amp;quot; : &amp;quot; or&amp;quot;) + &amp;quot;(m.archFileId = &amp;quot; + afileOffset.substring(0, idx) + &amp;quot; and m.logicalOffset + m.logicalSize &amp;gt;= &amp;quot; + afileOffset.substring(idx + 1, afileOffset.length() - 1) + &amp;quot;)&amp;quot;;&amp;#xD;&amp;#xA;                break;&amp;#xD;&amp;#xA;            default:&amp;#xD;&amp;#xA;                query += (query.isEmpty() ? &amp;quot;&amp;quot; : &amp;quot; or&amp;quot;) + &amp;quot;(m.archFileId = &amp;quot; + afileOffset.substring(0, idx) + &amp;quot; and m.physicalOffset + m.physicalSize &amp;gt;= &amp;quot; + afileOffset.substring(idx + 1, afileOffset.length() - 1) + &amp;quot;)&amp;quot;;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(query.isEmpty())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Failed to read restore vector data. Empty query&amp;quot;);&amp;#xD;&amp;#xA;        return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    query = &amp;quot;and (&amp;quot; + query + &amp;quot;)&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;Successfully parsed restore vector&amp;quot;);&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;    return query;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to read restore vector data. Exception: &amp;quot; + e);&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Decision_7" commented="0" description="" originalStyle="" points="" sourceX="768" sourceY="256" status="0" style="defaultEdge" targetX="974" targetY="256" transitionIndex="0" x="-7" y="33">

              <condition language="1" script="!xpath:{/workflow/Script_Restore_Vector_Query/output}.isEmpty()" />

            </transition>

            <transition activity="Break_1" commented="0" description="" displayName="No AFs" offsetX="1" offsetY="0" originalStyle="" points="" sourceX="768" sourceY="256" status="0" style="defaultEdge" targetX="995" targetY="167" transitionIndex="0" x="-7" y="33">

              <condition language="1" script="//Breaking after this point since restore vector was detected. This means no other MA is likely to have the restore vector and hance no point in processing them.&#xD;&#xA;xpath:{/workflow/Script_Restore_Vector_Query/output}.isEmpty()" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1582834613207" description="activity to execute code snippets in the selected language" displayName="Get DumpRV command" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_92" waitSetting="0" width="161" x="1306" y="111">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    Map m = xpath:{/workflow/ExecuteProcessBlock_32/Script_ClientDetails/output};&amp;#xD;&amp;#xA;    String command = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    String outputFile;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(m.get(&amp;quot;clientOs&amp;quot;).toLowerCase().contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;        outputFile = m.get(&amp;quot;clientTempFolder&amp;quot;) + &amp;quot;\\CloudChunk_&amp;quot; + Integer.toString(xpath:{/workflow/system/jobId}) + &amp;quot;_restorevector.csv&amp;quot;;&amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;        outputFile = m.get(&amp;quot;clientTempFolder&amp;quot;) + &amp;quot;/CloudChunk_&amp;quot; + Integer.toString(xpath:{/workflow/system/jobId}) + &amp;quot;_restorevector.csv&amp;quot;; &amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String instance = &amp;quot; -vm \&amp;quot;&amp;quot; + xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;attrVal&amp;quot;]} + &amp;quot;\&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    String clientname = &amp;quot; -cn \&amp;quot;&amp;quot; + xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;name&amp;quot;]} + &amp;quot;\&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    String jobId = &amp;quot; -jobId &amp;quot; + xpath:{/workflow/variables/iJobId};&amp;#xD;&amp;#xA;    String output_path = &amp;quot; -path \&amp;quot;&amp;quot; + outputFile + &amp;quot;\&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    command += &amp;quot; -dumpRV &amp;quot; + instance + clientname + jobId + output_path;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    return command;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to get command for looking up restore vector for v1 index. Exception &amp;quot; + e);&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_3" commented="0" description="" originalStyle="" points="" sourceX="1070" sourceY="128" status="0" style="defaultEdge" targetX="1236" targetY="129" transitionIndex="0" x="0" y="0">

              <condition language="1" script="!xpath:{/workflow/Script_92/output}.isEmpty()" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1582834790937" description="activity to execute code snippets in the selected language" displayName="Check Restore Vector" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_93" waitSetting="0" width="155" x="1782" y="181">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String instance = &amp;quot; -vm \&amp;quot;&amp;quot; + xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;attrVal&amp;quot;]} + &amp;quot;\&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    String jobId = &amp;quot; -j &amp;quot; + Integer.toString(xpath:{/workflow/variables/iJobId});&amp;#xD;&amp;#xA;    String logJobId = &amp;quot; -lj &amp;quot; + xpath:{/workflow/system/jobId};    &amp;#xD;&amp;#xA;    String cmd = &amp;quot;-mode 1&amp;quot; + instance + jobId + logJobId + &amp;quot; -o \&amp;quot;&amp;quot; + xpath:{/workflow/ExecuteProcessBlock_32/Script_ClientDetails/output}.get(&amp;quot;clientTempFolder&amp;quot;) + &amp;quot;\&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    return cmd;    &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Error generating recall command for parsing restore vector&amp;quot; + e);&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_4" commented="0" description="" originalStyle="" points="" sourceX="1581" sourceY="70" status="0" style="defaultEdge" targetX="1679" targetY="202" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1585519129757" description="iterates a group of activities over a list of values" displayName="Iterate MountPaths" height="164" interactive="0" jobMode="0" name="ForEach" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#E0E085;gradientColor=#E0E085" uniqueName="ForEach_2" waitSetting="0" width="791" x="1104" y="262">

            <activitySchema>

              <inputs>

                <children className="java.lang.String" inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.Object" inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                <children className="java.lang.Integer" defaultValue="1" inputType="java.lang.Integer" name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.Boolean" defaultValue="false" inputType="java.lang.Boolean" name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean" />

              </inputs>

              <outputs name="outputs">

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="0" name="row" type="{workflow.types.data}DataRow">

                  <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

              </outputs>

            </activitySchema>

            <inputs val="&lt;inputs&gt;&lt;name class=&quot;java.lang.String&quot;&gt;row&lt;/name&gt;&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_14/resultSets[2]/row}&lt;/values&gt;&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;1&lt;/numberOfParallelExecutions&gt;&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/continueOnFailure&gt;&lt;/inputs&gt;" />

            <transition activity="Script_155" commented="0" description="" originalStyle="" points="" sourceX="1499" sourceY="344" status="0" style="defaultEdge" targetX="1952" targetY="326" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

            <superProcess>

              <Start commented="0" continueOnFailure="0" created="1585519129757" description="" displayName="Start" height="28" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_42" waitSetting="0" width="72" x="18" y="76">

                <inputs val="&lt;inputs /&gt;" />

                <transition activity="Script_154" commented="0" description="" originalStyle="" points="" sourceX="49" sourceY="81" status="0" style="defaultEdge" targetX="351" targetY="81" transitionIndex="0" x="0" y="0">

                  <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

                </transition>

              </Start>

              <Activity commented="0" continueOnFailure="0" created="1585519192349" description="activity to execute code snippets in the selected language" displayName="Get Recall Data" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_154" waitSetting="0" width="116" x="120" y="73">

                <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;Map m = xpath:{/workflow/ExecuteProcessBlock_32/Script_ClientDetails/output};&amp;#xD;&amp;#xA;if(m.get(&amp;quot;clientOs&amp;quot;).toLowerCase().contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;return false;&quot; /&gt;&lt;/inputs&gt;" />

                <transition activity="Script_151" commented="0" description="" displayName="Win" originalStyle="" points="" sourceX="178" sourceY="82" status="0" style="defaultEdge" targetX="329" targetY="57" transitionIndex="0" x="0" y="0">

                  <condition language="1" script="Map m = xpath:{/workflow/ExecuteProcessBlock_32/Script_ClientDetails/output};&#xA;&#xA;if(m.get(&quot;clientOs&quot;).toLowerCase().contains(&quot;windows&quot;))&#xA;    return true;&#xA;return false;" />

                </transition>

                <transition activity="ExecuteCommand_50" commented="0" description="" displayName="Unix" originalStyle="" points="" sourceX="178" sourceY="82" status="0" style="defaultEdge" targetX="309" targetY="111" transitionIndex="0" x="0" y="0">

                  <condition language="1" script="Map m = xpath:{/workflow/ExecuteProcessBlock_32/Script_ClientDetails/output};&#xA;&#xA;if(m.get(&quot;clientOs&quot;).toLowerCase().contains(&quot;windows&quot;))&#xA;    return false;&#xA;return true;" />

                </transition>

              </Activity>

              <Activity commented="0" continueOnFailure="0" created="1585518734252" description="activity to execute code snippets in the selected language" displayName="Get Recall Data" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_151" waitSetting="0" width="116" x="326" y="34">

                <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;int mpId = Integer.parseInt(xpath:{/workflow/ForEach_2/row/col[2]});&amp;#xD;&amp;#xA;return &amp;quot;0x&amp;quot; + Integer.toHexString(mpId);&quot; /&gt;&lt;/inputs&gt;" />

                <transition activity="ExecuteCommand_51" commented="0" description="" originalStyle="" points="" sourceX="384" sourceY="51" status="0" style="defaultEdge" targetX="597" targetY="49" transitionIndex="0" x="0" y="0">

                  <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

                </transition>

              </Activity>

              <Activity commented="0" continueOnFailure="1" created="1585518734280" description="Execute a command on a remote machine" displayName="Get Recall Data" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_50" waitSetting="0" width="116" x="329" y="114">

                <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

                <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ForEach_1/row/col[@name=&quot;name&quot;]}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;grep&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;-rw &quot;OrigMPId xpath:{/workflow/ForEach_2/row/col[2]}&quot; /etc/CommVaultRegistry/Galaxy/xpath:{/workflow/ForEach_1/row/col[@name=&quot;attrVal&quot;]}/MediaAgent | wc -l&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

                <transition activity="Script_152" commented="0" description="" originalStyle="" points="" sourceX="387" sourceY="131" status="0" style="defaultEdge" targetX="676" targetY="120" transitionIndex="0" x="0" y="0">

                  <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

                </transition>

              </Activity>

              <Activity commented="0" continueOnFailure="1" created="1585518734306" description="Execute a command on a remote machine" displayName="Get Recall Data" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_51" waitSetting="0" width="116" x="498" y="34">

                <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

                <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ForEach_1/row/col[@name=&quot;name&quot;]}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Reg&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Query &quot;HKLM\SOFTWARE\CommVault Systems\Galaxy\xpath:{/workflow/ForEach_1/row/col[@name=&quot;attrVal&quot;]}\MediaAgent&quot; /v OrigMPId /s | findstr &quot;xpath:{/workflow/Script_151/output}&quot;&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

                <transition activity="Script_153" commented="0" description="" originalStyle="" points="" sourceX="556" sourceY="51" status="0" style="defaultEdge" targetX="718" targetY="49" transitionIndex="0" x="0" y="0">

                  <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

                </transition>

              </Activity>

              <Activity commented="0" continueOnFailure="0" created="1585518734321" description="activity to execute code snippets in the selected language" displayName="Get Recall Data" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_153" waitSetting="0" width="116" x="661" y="34">

                <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;String result = xpath:{/workflow/ExecuteCommand_51/commandOutput};&amp;#xD;&amp;#xA;String mpId = xpath:{/workflow/Script_151/output};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String sFailedMPList = xpath:{/workflow/variables/sFailedMPList};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(!result.contains(mpId))&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    if(sFailedMPList.trim().isEmpty())&amp;#xD;&amp;#xA;        sFailedMPList = xpath:{/workflow/ForEach_2/row/col[3]};&amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;        sFailedMPList += &amp;quot;, &amp;quot; + xpath:{/workflow/ForEach_2/row/col[3]};    &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;sFailedMPList&amp;quot;, sFailedMPList);&quot; /&gt;&lt;/inputs&gt;" />

              </Activity>

              <Activity commented="0" continueOnFailure="0" created="1585518734295" description="activity to execute code snippets in the selected language" displayName="Get Recall Data" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_152" waitSetting="0" width="116" x="659" y="114">

                <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;String result = xpath:{/workflow/ExecuteCommand_50/commandOutput};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String sFailedMPList = xpath:{/workflow/variables/sFailedMPList};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(result.trim().equals(&amp;quot;0&amp;quot;))&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;     if(sFailedMPList.trim().isEmpty())&amp;#xD;&amp;#xA;        sFailedMPList = xpath:{/workflow/ForEach_2/row/col[3]};&amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;        sFailedMPList += &amp;quot;, &amp;quot; + xpath:{/workflow/ForEach_2/row/col[3]};       &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;sFailedMPList&amp;quot;, sFailedMPList);&quot; /&gt;&lt;/inputs&gt;" />

              </Activity>

            </superProcess>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1585521472751" description="activity to execute code snippets in the selected language" displayName="Get Recall Data" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_155" waitSetting="0" width="116" x="1933" y="328">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;String sFailedMPList = xpath:{/workflow/variables/sFailedMPList};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(sFailedMPList.trim().isEmpty())&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;bFailedMP&amp;quot;, true);&amp;#xD;&amp;#xA;sFailedMPList = &amp;quot;Failure Reason: Registry on MA is missing mountpath information. Share MediaAgent [&amp;quot; + xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;name&amp;quot;]} + &amp;quot;] with mountpath(s) [&amp;quot; + xpath:{/workflow/variables/sFailedMPList} + &amp;quot;]. &amp;quot;;&amp;#xD;&amp;#xA;logger.info(sFailedMPList);&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;sFailedMPList&amp;quot;, sFailedMPList);&amp;#xD;&amp;#xA;return false;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_30" commented="0" description="" originalStyle="" points="" sourceX="1835" sourceY="197" status="0" style="defaultEdge" targetX="2038" targetY="180" transitionIndex="0" x="0" y="0">

              <condition language="1" script="xpath:{/workflow/Script_155/output}" />

            </transition>

            <transition activity="Break_4" commented="0" description="" originalStyle="" points="" sourceX="1835" sourceY="197" status="0" style="defaultEdge" targetX="1852" targetY="114" transitionIndex="0" x="0" y="0">

              <condition language="1" script="!xpath:{/workflow/Script_155/output}" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1585523779932" description="interrupts a process block execution" displayName="Break" height="34" interactive="0" jobMode="0" name="Break" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.InterruptActivity" uniqueName="Break_4" waitSetting="0" width="100" x="1941" y="260">

            <inputs val="&lt;inputs /&gt;" />

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1586951922600" description="activity to execute code snippets in the selected language" displayName="Check Restore Vector" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_165" waitSetting="0" width="155" x="168" y="111">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;String sRestoreFailedRvMA = xpath:{/workflow/variables/sRestoreFailedRvMA};&amp;#xD;&amp;#xA;String currentMA = xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;name&amp;quot;]};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(!sRestoreFailedRvMA.isEmpty() &amp;amp;&amp;amp; !currentMA.equals(sRestoreFailedRvMA))&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Skipping restore vector check on  - [&amp;quot; + currentMA + &amp;quot;] as Restore Vector was found on [&amp;quot; + sRestoreFailedRvMA + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;return true;&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Decision_8" commented="0" description="" originalStyle="" points="" sourceX="245" sourceY="128" status="0" style="defaultEdge" targetX="484" targetY="126" transitionIndex="0" x="0" y="0">

              <condition language="1" script="xpath:{/workflow/Script_165/output}" />

            </transition>

          </Activity>

        </superProcess>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1575488739777" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_4" waitSetting="0" width="117" x="118" y="42">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="CommServDBQuery_13" commented="0" description="" originalStyle="" points="304.0,104.0" sourceX="205" sourceY="171" status="0" style="defaultEdge" targetX="349" targetY="157" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1575488807555" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_3" waitSetting="0" width="113" x="408" y="138">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Script_38" commented="0" description="" originalStyle="" points="" sourceX="509" sourceY="233" status="0" style="defaultEdge" targetX="742" targetY="59" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1575493206451" description="if/else based decision" displayName="Debug" height="54" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_6" waitSetting="0" width="66" x="142" y="128">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;1 == xpath:{/workflow/variables/iDebugMode}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_4" commented="0" description="" displayName="Debug Disabled" originalStyle="" points="" sourceX="175" sourceY="171" status="0" style="defaultEdge" targetX="291" targetY="171" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="CommServDBQuery_13" commented="0" description="" offsetX="-2" offsetY="-1" originalStyle="" points="" sourceX="175" sourceY="171" status="0" style="defaultEdge" targetX="493" targetY="163" transitionIndex="0" value="true" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1575495800708" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_9" waitSetting="0" width="106" x="711" y="45">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Failure Reason: No MediaAgents detected for getting information on data requiring recall&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1576690469010" description="activity to execute code snippets in the selected language" displayName="Get MediaAgent List" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_38" waitSetting="0" width="143" x="548" y="138">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(0 == xpath:{/workflow/CommServDBQuery_13/resultSets/rowCount})&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;No MediaAgents detected for getting information on data requiring recall&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;iRestoreVectorRetryCount&amp;quot;, 3);&amp;#xD;&amp;#xA;return true;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_29" commented="0" description="" displayName="No MAs detected" originalStyle="" points="" sourceX="642" sourceY="187" status="0" style="defaultEdge" targetX="650" targetY="264" transitionIndex="0" x="0" y="0">

          <condition language="1" script="false == xpath:{/workflow/Script_38/output}" />

        </transition>

        <transition activity="ExecuteProcessBlock_73" commented="0" description="" originalStyle="" points="" sourceX="653" sourceY="268" status="0" style="defaultEdge" targetX="903" targetY="58" transitionIndex="0" x="0" y="0">

          <condition language="1" script="true == xpath:{/workflow/Script_38/output}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578928317764" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_28" waitSetting="0" width="117" x="2225" y="36">

        <inputs val="&lt;inputs /&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578928329880" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_29" waitSetting="0" width="117" x="557" y="45">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="WorkflowEnd_9" commented="0" description="" originalStyle="" points="" sourceX="615" sourceY="62" status="0" style="defaultEdge" targetX="819" targetY="63" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1581022851119" description="if/else based decision" displayName="Success" height="62" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_18" waitSetting="0" width="80" x="2246" y="107">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;!xpath:{/workflow/variables/sRecallData}.isEmpty() || xpath:{/workflow/variables/bNoDataOnCloud} || xpath:{/workflow/variables/bFailedMP}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_28" commented="0" description="" displayName="Data found/No data on cloud" offsetX="2" offsetY="6" originalStyle="" points="" sourceX="1116" sourceY="134" status="0" style="defaultEdge" targetX="1002" targetY="92" transitionIndex="0" value="true" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="Script_89" commented="0" description="" originalStyle="" points="" sourceX="1116" sourceY="134" status="0" style="defaultEdge" targetX="1009" targetY="134" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1581022939182" description="activity to execute code snippets in the selected language" displayName="Retry" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_89" waitSetting="0" width="63" x="2148" y="121">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;int iRestoreVectorRetryCount = workflow.getVariable(&amp;quot;iRestoreVectorRetryCount&amp;quot;);&amp;#xD;&amp;#xA;//--iRestoreVectorRetryCount;&amp;#xD;&amp;#xA;//workflow.setVariable(&amp;quot;iRestoreVectorRetryCount&amp;quot;, iRestoreVectorRetryCount);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(workflow.getVariable(&amp;quot;bRestoreJobFailed&amp;quot;))&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Could not parse the restore vector for the failed job. Run the wokflow job with backup JobId as input as a workaround to recall all the data required or the backup job to be restored.&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(iRestoreVectorRetryCount &amp;gt;= 0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to find restore vector. Retrying&amp;quot;);&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}   &amp;#xD;&amp;#xA;return false;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteCommand_18" commented="0" description="" originalStyle="" points="" sourceX="1009" sourceY="134" status="0" style="defaultEdge" targetX="908" targetY="132" transitionIndex="0" x="0" y="0">

          <condition language="1" script="true == xpath:{/workflow/Script_89/output}" />

        </transition>

        <transition activity="DisableLogging_28" commented="0" description="" originalStyle="" points="2184.0,96.0" sourceX="1009" sourceY="134" status="0" style="defaultEdge" targetX="1126" targetY="53" transitionIndex="0" x="0" y="0">

          <condition language="1" script="false == xpath:{/workflow/Script_89/output}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1581023001604" description="Execute a command on a remote machine" displayName="Check Restore Vector" height="34" interactive="0" jobMode="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_18" waitSetting="0" width="155" x="1949" y="121">

        <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;hostName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;displayName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;commCellName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;csGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;type class=&quot;commvault.msgs.CvEntities.CommCellType&quot; _list_=&quot;false&quot; /&gt;&lt;flags class=&quot;commvault.msgs.CvEntities.EntityFlags&quot; _list_=&quot;false&quot; /&gt;&lt;GUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;newName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;ping&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;127.0.0.1 -n 301 &amp;gt; nul&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_73" commented="0" description="" originalStyle="" points="" sourceX="856" sourceY="134" status="0" style="defaultEdge" targetX="851" targetY="216" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1586867824891" description="executes a defined process block within the workflow" displayName="Checking if job failed" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#BEE0B8;gradientColor=#BEE0B8" uniqueName="ExecuteProcessBlock_73" waitSetting="0" width="147" x="546" y="203">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

          <outputs name="ProcessBlock_31">

            <children name="Start_41" />

            <children name="Job_2" type="">

              <children className="workflow.types.cmd.JobDetails" inputType="workflow.types.cmd.JobDetails" listType="1" name="job" type="{workflow.types.cmd}JobDetails">

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="jobId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" inputType="java.lang.String" name="jobType" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="status" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.String" inputType="java.lang.String" name="phase" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Script_100">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="EnableLogging_31" />

            <children name="DisableLogging_47" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;processBlock&gt;ProcessBlock_31&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="EnableLogging_39" commented="0" description="" originalStyle="" points="" sourceX="619" sourceY="220" status="0" style="defaultEdge" targetX="447" targetY="222" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1586737546400" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_39" waitSetting="0" width="113" x="399" y="203">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Script_160" commented="0" description="" originalStyle="" points="" sourceX="455" sourceY="220" status="0" style="defaultEdge" targetX="191" targetY="236" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1586897833078" description="activity to execute code snippets in the selected language" displayName="Check Job Status" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_160" waitSetting="0" width="130" x="107" y="203">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;String state = xpath:{/workflow/ExecuteProcessBlock_73/Script_100/output};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(state.equals(&amp;quot;Pending&amp;quot;) || state.equals(&amp;quot;Running&amp;quot;) || state.equals(&amp;quot;Waiting&amp;quot;) || state.equals(&amp;quot;Queued&amp;quot;) || state.equals(&amp;quot;Suspended&amp;quot;) || state.equals(&amp;quot;Suspend Pending&amp;quot;) || state.equals(&amp;quot;Interrupt Pending&amp;quot;))&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Job is running. Continuing with restore vector parsing&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(state.equals(&amp;quot;Failed&amp;quot;))&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;bRestoreJobFailed&amp;quot;, true);&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Restore job failed. Handling the case of non-restartable jobs&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;logger.info(&amp;quot;Restore job is not running. Current State - &amp;quot; + state + &amp;quot;. Exiting workflow.&amp;quot;);&amp;#xD;&amp;#xA;return true;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="ForEach_1" commented="0" description="" displayName="Job Running" originalStyle="" points="53.0,406.0" sourceX="172" sourceY="220" status="0" style="defaultEdge" targetX="141" targetY="560" transitionIndex="0" x="0" y="0">

          <condition language="1" script="!xpath:{/workflow/Script_160/output}" />

        </transition>

        <transition activity="CommServDBQuery_64" commented="0" description="" originalStyle="" points="" sourceX="172" sourceY="220" status="0" style="defaultEdge" targetX="172" targetY="284" transitionIndex="0" x="-84" y="-1509">

          <condition language="1" script="xpath:{/workflow/Script_160/output} &amp;&amp; xpath:{/workflow/variables/bRestoreJobFailed}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1586897947621" description="iterates a group of activities over a list of values" displayName="Iterate MediaAgents without registry value set" height="108" interactive="0" jobMode="0" name="ForEach" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#E0E085;gradientColor=#E0E085" uniqueName="ForEach_3" waitSetting="0" width="292" x="425" y="270">

        <activitySchema>

          <inputs>

            <children className="java.lang.String" inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children className="java.lang.Object" inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            <children className="java.lang.Integer" defaultValue="1" inputType="java.lang.Integer" name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Boolean" defaultValue="false" inputType="java.lang.Boolean" name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean" />

          </inputs>

          <outputs name="outputs">

            <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="0" name="row" type="{workflow.types.data}DataRow">

              <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;name class=&quot;java.lang.String&quot;&gt;row&lt;/name&gt;&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_13/resultSets[2]/row}&lt;/values&gt;&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;1&lt;/numberOfParallelExecutions&gt;&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/continueOnFailure&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteCommand_53" commented="0" description="" originalStyle="" points="" sourceX="499" sourceY="324" status="0" style="defaultEdge" targetX="742" targetY="314" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <superProcess>

          <Start commented="0" continueOnFailure="0" created="1586897947621" description="" displayName="Start" height="32" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_43" waitSetting="0" width="59" x="44" y="56">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="Execute_2" commented="0" description="" originalStyle="" points="" sourceX="61" sourceY="71" status="0" style="defaultEdge" targetX="156" targetY="66" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Start>

          <Activity commented="0" continueOnFailure="1" created="1586896878530" description="" displayName="Add Registry (OS)" height="34" interactive="0" jobMode="0" maxRestarts="0" name="Execute" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute" uniqueName="Execute_2" waitSetting="0" width="130" x="138" y="55">

            <onEnter language="1" script="logger.info(&quot;Adding DO_NOT_DELETE_RESTORE_VECTOR on client [&quot; + xpath:{/workflow/ForEach_3/row/col[@name=&quot;name&quot;]} + &quot;]&quot;);" />

            <inputs val="&lt;inputs&gt;&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;&amp;lt;App_SetClientPropertiesRequest&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&amp;lt;association&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&amp;lt;entity&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&amp;lt;clientName/&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&amp;lt;/entity&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&amp;lt;/association&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&amp;lt;clientProperties&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&amp;lt;clientProps&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&amp;lt;registryKeys&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&amp;lt;deleted/&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&amp;lt;enabled/&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&amp;lt;isInheritedFromClientGroup&amp;gt;false&amp;lt;/isInheritedFromClientGroup&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&amp;lt;keyName&amp;gt;DO_NOT_DELETE_RESTORE_VECTOR&amp;lt;/keyName&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&amp;lt;relativepath&amp;gt;EventManager&amp;lt;/relativepath&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&amp;lt;type&amp;gt;INTEGER&amp;lt;/type&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&amp;lt;value/&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&amp;lt;/registryKeys&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&amp;lt;/clientProps&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&amp;lt;/clientProperties&amp;gt;&amp;#xD;&#xD;&#xA;&amp;lt;/App_SetClientPropertiesRequest&amp;gt;&lt;/inputXml&gt;&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/escapeXml&gt;&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;-clientName xpath:{/workflow/ForEach_3/row/col[@name=&quot;name&quot;]} -deleted 0 -enabled 1 -value 1&lt;/commandArgs&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ImpersonateCreator_2/token}&lt;/token&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

          </Activity>

        </superProcess>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1586899808306" description="iterates a group of activities over a list of values" displayName="Iterate MediaAgents with registry value newly set" height="126" interactive="0" jobMode="0" name="ForEach" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#E0E085;gradientColor=#E0E085" uniqueName="ForEach_5" waitSetting="0" width="370" x="1895" y="244">

        <activitySchema>

          <inputs>

            <children className="java.lang.String" inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children className="java.lang.Object" inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            <children className="java.lang.Integer" defaultValue="1" inputType="java.lang.Integer" name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Boolean" defaultValue="false" inputType="java.lang.Boolean" name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean" />

          </inputs>

          <outputs name="outputs">

            <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="0" name="row" type="{workflow.types.data}DataRow">

              <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;name class=&quot;java.lang.String&quot;&gt;row&lt;/name&gt;&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_13/resultSets[2]/row}&lt;/values&gt;&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;1&lt;/numberOfParallelExecutions&gt;&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/continueOnFailure&gt;&lt;/inputs&gt;" />

        <transition activity="ForEach_1" commented="0" description="" originalStyle="" points="2325.0,459.0" sourceX="1932" sourceY="461" status="0" style="defaultEdge" targetX="1930" targetY="558" transitionIndex="0" x="0" y="0">

          <condition language="1" script="String sRestoreFailedRvMA = xpath:{/workflow/variables/sRestoreFailedRvMA};&#xD;&#xA;&#xD;&#xA;if(!sRestoreFailedRvMA.isEmpty())&#xD;&#xA;{&#xD;&#xA;    return true;&#xD;&#xA;}&#xD;&#xA;else&#xD;&#xA;{&#xD;&#xA;    logger.info(&quot;Restore vector could not be generated from job resubmission.&quot;);&#xD;&#xA;    return false;&#xD;&#xA;}" />

        </transition>

        <superProcess>

          <Start commented="0" continueOnFailure="0" created="1586899808306" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_46" waitSetting="0" width="58" x="18" y="58">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="Execute_3" commented="0" description="" originalStyle="" points="" sourceX="47" sourceY="73" status="0" style="defaultEdge" targetX="202" targetY="74" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Start>

          <Activity commented="0" continueOnFailure="0" created="1586900038753" description="" displayName="Clean up Registry (OS)" height="34" interactive="0" jobMode="0" name="Execute" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute" uniqueName="Execute_3" waitSetting="0" width="157" x="124" y="57">

            <onEnter language="1" script="logger.info(&quot;Removing DO_NOT_DELETE_RESTORE_VECTOR on client [&quot; + xpath:{/workflow/ForEach_5/row/col[@name=&quot;name&quot;]} + &quot;]&quot;);" />

            <inputs val="&lt;inputs&gt;&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;&amp;lt;App_SetClientPropertiesRequest&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&amp;lt;association&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&amp;lt;entity&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&amp;lt;clientName/&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&amp;lt;/entity&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&amp;lt;/association&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&amp;lt;clientProperties&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&amp;lt;clientProps&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&amp;lt;registryKeys&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&amp;lt;deleted/&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&amp;lt;enabled/&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&amp;lt;isInheritedFromClientGroup&amp;gt;false&amp;lt;/isInheritedFromClientGroup&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&amp;lt;keyName&amp;gt;DO_NOT_DELETE_RESTORE_VECTOR&amp;lt;/keyName&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&amp;lt;relativepath&amp;gt;EventManager&amp;lt;/relativepath&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&amp;lt;type&amp;gt;INTEGER&amp;lt;/type&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&amp;lt;value/&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&amp;lt;/registryKeys&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&amp;lt;/clientProps&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&amp;lt;/clientProperties&amp;gt;&amp;#xD;&#xD;&#xA;&amp;lt;/App_SetClientPropertiesRequest&amp;gt;&lt;/inputXml&gt;&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/escapeXml&gt;&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;-clientName xpath:{/workflow/ForEach_5/row/col[@name=&quot;name&quot;]} -deleted 1 -enabled 0 -value 0&lt;/commandArgs&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ImpersonateCreator_2/token}&lt;/token&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

          </Activity>

        </superProcess>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1586897014336" description="impersonates the user who created the workflow" displayName="ImpersonateCreator" height="34" interactive="0" jobMode="0" name="ImpersonateCreator" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ImpersonateCreator" uniqueName="ImpersonateCreator_2" waitSetting="0" width="145" x="100" y="307">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="ForEach_3" commented="0" description="" originalStyle="" points="" sourceX="172" sourceY="284" status="0" style="defaultEdge" targetX="185" targetY="368" transitionIndex="0" x="0" y="0">

          <condition language="1" script="xpath:{/workflow/CommServDBQuery_13/resultSets[2]/rowCount} &gt; 0" />

        </transition>

        <transition activity="ForEach_4" commented="0" description="" displayName="All MAs have registry value" originalStyle="" points="" sourceX="172" sourceY="284" status="0" style="defaultEdge" targetX="172" targetY="404" transitionIndex="0" x="0" y="0">

          <condition language="1" script="xpath:{/workflow/CommServDBQuery_13/resultSets[2]/rowCount} == 0" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1586899770165" description="iterates a group of activities over a list of values" displayName="Iterate MediaAgents and check for restore vector folder" height="176" interactive="0" jobMode="0" name="ForEach" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#E0E085;gradientColor=#E0E085" uniqueName="ForEach_4" waitSetting="0" width="2310" x="85" y="398">

        <activitySchema>

          <inputs>

            <children className="java.lang.String" inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children className="java.lang.Object" inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            <children className="java.lang.Integer" defaultValue="1" inputType="java.lang.Integer" name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Boolean" defaultValue="false" inputType="java.lang.Boolean" name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean" />

          </inputs>

          <outputs name="outputs">

            <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="0" name="row" type="{workflow.types.data}DataRow">

              <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;name class=&quot;java.lang.String&quot;&gt;row&lt;/name&gt;&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_13/resultSets[1]/row}&lt;/values&gt;&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;1&lt;/numberOfParallelExecutions&gt;&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/continueOnFailure&gt;&lt;/inputs&gt;" />

        <transition activity="ForEach_5" commented="0" description="" originalStyle="" points="" sourceX="451" sourceY="455" status="0" style="defaultEdge" targetX="950" targetY="396" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <superProcess>

          <Start commented="0" continueOnFailure="0" created="1586899770165" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_44" waitSetting="0" width="58" x="34" y="56">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="ExecuteProcessBlock_74" commented="0" description="" originalStyle="" points="" sourceX="63" sourceY="71" status="0" style="defaultEdge" targetX="188" targetY="71" transitionIndex="0" x="0" y="0">

              <condition language="4" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Start>

          <Activity commented="0" continueOnFailure="0" created="1586917656664" description="executes a defined process block within the workflow" displayName="Get Client Details" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#BEE0B8;gradientColor=#BEE0B8" uniqueName="ExecuteProcessBlock_74" waitSetting="0" width="126" x="125" y="54">

            <activitySchema>

              <inputs className="" defaultValue="" listType="0" name="inputs" type="">

                <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sClientName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

              </inputs>

              <outputs name="ProcessBlock_17">

                <children name="Start_19" />

                <children name="DisableLogging_1" />

                <children name="Execute_1">

                  <children className="java.lang.String" documentation="xml output contents" inputType="java.lang.String" name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children name="Script_ClientDetails">

                  <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

                <children name="Decision_4" />

                <children name="EnableLogging_13" />

                <children name="DisableLogging_14" />

              </outputs>

            </activitySchema>

            <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;sClientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ForEach_4/row/col[@name=&quot;name&quot;]}&lt;/sClientName&gt;&lt;/inputs&gt;&lt;processBlock&gt;ProcessBlock_17&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

            <transition activity="EnableLogging_38" commented="0" description="" originalStyle="" points="" sourceX="170" sourceY="81" status="0" style="defaultEdge" targetX="347" targetY="66" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1586917660445" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_38" waitSetting="0" width="113" x="290" y="54">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="CommServDBQuery_58" commented="0" description="" originalStyle="" points="" sourceX="346" sourceY="71" status="0" style="defaultEdge" targetX="502" targetY="71" transitionIndex="0" x="-169" y="-1907">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1586925694411" description="activity to execute code snippets in the selected language" displayName="Find Index Folder" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_162" waitSetting="0" width="125" x="601" y="54">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;Map m = xpath:{/workflow/ExecuteProcessBlock_74/Script_ClientDetails/output};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(m.get(&amp;quot;clientOs&amp;quot;).toLowerCase().contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    return &amp;quot;reg&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;return &amp;quot;grep&amp;quot;;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_163" commented="0" description="" originalStyle="" points="" sourceX="645" sourceY="81" status="0" style="defaultEdge" targetX="787" targetY="84" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1586925888956" description="executes queries against a commcell database" displayName="Get Client Instance" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_58" waitSetting="0" width="143" x="431" y="54">

            <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;select distinct attrVal&amp;#xD;&#xD;&#xA;from APP_ClientProp(nolock) cp&amp;#xD;&#xD;&#xA;join APP_Client(nolock) c on c.id = cp.componentNameId&amp;#xD;&#xD;&#xA;where c.name = ''xpath:{/workflow/ForEach_4/row/col[@name=&quot;name&quot;]}'' &amp;#xD;&#xD;&#xA;    and cp.attrName = ''Galaxy Instance name'' &amp;#xD;&#xD;&#xA;    and CP.modified = 0&lt;/query&gt;&lt;/inputs&gt;" />

            <transition activity="Script_162" commented="0" description="" originalStyle="" points="" sourceX="484" sourceY="81" status="0" style="defaultEdge" targetX="627" targetY="85" transitionIndex="0" x="0" y="0">

              <condition language="1" script="xpath:{/workflow/CommServDBQuery_58/resultSets/rowCount} &gt; 0" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1586926050657" description="activity to execute code snippets in the selected language" displayName="Find Index Folder" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_163" waitSetting="0" width="125" x="757" y="54">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;Map m = xpath:{/workflow/ExecuteProcessBlock_74/Script_ClientDetails/output};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(m.get(&amp;quot;clientOs&amp;quot;).toLowerCase().contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    return &amp;quot;Query \&amp;quot;HKLM\\SOFTWARE\\CommVault Systems\\Galaxy\\&amp;quot; + xpath:{/workflow/CommServDBQuery_58/resultSets/row[1]/col[1]} + &amp;quot;\\Machines\&amp;quot; /v \&amp;quot;dFSINDEXCACHE\&amp;quot; /s&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;return &amp;quot;-r \&amp;quot;dFSINDEXCACHE\&amp;quot; \&amp;quot;/etc/CommVaultRegistry/Galaxy/&amp;quot; + xpath:{/workflow/CommServDBQuery_58/resultSets/row[1]/col[1]} + &amp;quot;/Machines/\&amp;quot;&amp;quot;;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_55" commented="0" description="" originalStyle="" points="" sourceX="819" sourceY="71" status="0" style="defaultEdge" targetX="989" targetY="70" transitionIndex="0" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1586926244728" description="Execute a command on a remote machine" displayName="Find Index Folder" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_55" waitSetting="0" width="125" x="927" y="53">

            <onExit language="4" script="workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ForEach_4/row/col[@name=&quot;name&quot;]}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_162/output}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_163/output}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_164" commented="0" description="" originalStyle="" points="" sourceX="989" sourceY="70" status="0" style="defaultEdge" targetX="1155" targetY="70" transitionIndex="0" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1586926316564" description="activity to execute code snippets in the selected language" displayName="Find Index Folder" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_164" waitSetting="0" width="125" x="1093" y="53">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String data = xpath:{/workflow/ExecuteCommand_55/commandOutput};&amp;#xD;&amp;#xA;    String sRegValue = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    Map m = xpath:{/workflow/ExecuteProcessBlock_74/Script_ClientDetails/output};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(m.get(&amp;quot;clientOs&amp;quot;).toLowerCase().contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        int idx = data.indexOf(&amp;quot;REG_SZ&amp;quot;);&amp;#xD;&amp;#xA;        if(idx &amp;gt;= 0)&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            sRegValue = data.substring(idx + &amp;quot;REG_SZ&amp;quot;.length()).trim();&amp;#xD;&amp;#xA;            String[] lines = sRegValue.split(System.getProperty(&amp;quot;line.separator&amp;quot;));&amp;#xD;&amp;#xA;            if(lines.length &amp;gt; 0)&amp;#xD;&amp;#xA;                sRegValue = lines[0];&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        int idx = data.indexOf(&amp;quot;dFSINDEXCACHE&amp;quot;);&amp;#xD;&amp;#xA;        if(idx &amp;gt;= 0)&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            sRegValue = data.substring(idx + &amp;quot;dFSINDEXCACHE &amp;quot;.length()).trim();&amp;#xD;&amp;#xA;            String[] lines = sRegValue.split(System.getProperty(&amp;quot;line.separator&amp;quot;));&amp;#xD;&amp;#xA;            if(lines.length &amp;gt; 0)&amp;#xD;&amp;#xA;                sRegValue = lines[0];&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;Index folder for client - &amp;quot; +  xpath:{/workflow/ForEach_4/row/col[@name=&amp;quot;name&amp;quot;]} + &amp;quot; is [&amp;quot; + sRegValue + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    return sRegValue;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to find index directory for client - &amp;quot; +  xpath:{/workflow/ForEach_4/row/col[@name=&amp;quot;name&amp;quot;]});&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_166" commented="0" description="" originalStyle="" points="" sourceX="1137" sourceY="80" status="0" style="defaultEdge" targetX="1338" targetY="81" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1586952174548" description="activity to execute code snippets in the selected language" displayName="Check if V1 index" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_166" waitSetting="0" width="128" x="1259" y="53">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    Map m = xpath:{/workflow/ExecuteProcessBlock_74/Script_ClientDetails/output};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(m.get(&amp;quot;clientOs&amp;quot;).toLowerCase().contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        return &amp;quot;dir&amp;quot;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        return &amp;quot;ls&amp;quot;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed during v1 index check for client - &amp;quot; +  xpath:{/workflow/ForEach_4/row/col[@name=&amp;quot;name&amp;quot;]});&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_167" commented="0" description="" originalStyle="" points="" sourceX="1323" sourceY="70" status="0" style="defaultEdge" targetX="1550" targetY="62" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1586953220558" description="activity to execute code snippets in the selected language" displayName="Check if V1 index" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_167" waitSetting="0" width="128" x="1421" y="53">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    Map m = xpath:{/workflow/ExecuteProcessBlock_74/Script_ClientDetails/output};&amp;#xD;&amp;#xA;    int jobId = xpath:{/workflow/variables/iJobId};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String sIndexFolder = xpath:{/workflow/Script_164/output};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(m.get(&amp;quot;clientOs&amp;quot;).toLowerCase().contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        sIndexFolder += &amp;quot;\\CV_Index\\restores&amp;quot;;&amp;#xD;&amp;#xA;        return &amp;quot;/b /ad \&amp;quot;&amp;quot; + sIndexFolder + &amp;quot;\&amp;quot; | find \&amp;quot;&amp;quot; + Integer.toString(jobId) + &amp;quot;\&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        sIndexFolder += &amp;quot;/CV_Index/restores&amp;quot;;&amp;#xD;&amp;#xA;        return &amp;quot;-d &amp;quot; + sIndexFolder + &amp;quot;/* | sed ''s:.*/::'' | grep \&amp;quot;&amp;quot; + Integer.toString(jobId) + &amp;quot;\&amp;quot;&amp;quot;;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed during v1 index check for client - &amp;quot; +  xpath:{/workflow/ForEach_4/row/col[@name=&amp;quot;name&amp;quot;]});&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_56" commented="0" description="" originalStyle="" points="" sourceX="1485" sourceY="70" status="0" style="defaultEdge" targetX="1657" targetY="70" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1586953659403" description="Execute a command on a remote machine" displayName="Check if V1 index" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_56" waitSetting="0" width="134" x="1590" y="53">

            <onExit language="4" script="workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ForEach_4/row/col[@name=&quot;name&quot;]}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_166/output}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_167/output}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_168" commented="0" description="" originalStyle="" points="" sourceX="1657" sourceY="70" status="0" style="defaultEdge" targetX="1832" targetY="70" transitionIndex="0" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1586953754849" description="activity to execute code snippets in the selected language" displayName="Check if V1 index" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_168" waitSetting="0" width="128" x="1768" y="53">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;import java.util.regex.Matcher;&amp;#xD;&amp;#xA;import java.util.regex.Pattern;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{   &amp;#xD;&amp;#xA;    String op = xpath:{/workflow/ExecuteCommand_56/commandOutput};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String[] lines = op.split(&amp;quot;\\n&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String oldFolderName = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    String newFolderName = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    Pattern p1 = Pattern.compile(&amp;quot;[0-9]+_([0-9]+)&amp;quot;);&amp;#xD;&amp;#xA;    Pattern p2 = Pattern.compile(&amp;quot;([0-9]+)&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    for(String line : lines)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        Matcher m1 = p1.matcher(line);&amp;#xD;&amp;#xA;        if(m1.find())&amp;#xD;&amp;#xA;        {  &amp;#xD;&amp;#xA;           newFolderName = m1.group(1);&amp;#xD;&amp;#xA;           oldFolderName = m1.group(0);    &amp;#xD;&amp;#xA;           break;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        Matcher m2 = p2.matcher(line);&amp;#xD;&amp;#xA;        if(m2.find())&amp;#xD;&amp;#xA;        {  &amp;#xD;&amp;#xA;          newFolderName = m2.group(1);&amp;#xD;&amp;#xA;          oldFolderName = m2.group(0);&amp;#xD;&amp;#xA;          break;    &amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(!newFolderName.isEmpty())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Restore vector folder found on client [&amp;quot; + xpath:{/workflow/ForEach_4/row/col[@name=&amp;quot;name&amp;quot;]} + &amp;quot;]. Renamed &amp;quot; + oldFolderName + &amp;quot; to &amp;quot; +  newFolderName);&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;sRestoreFailedRvMA&amp;quot;, xpath:{/workflow/ForEach_4/row/col[@name=&amp;quot;name&amp;quot;]});&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        Map m = xpath:{/workflow/ExecuteProcessBlock_74/Script_ClientDetails/output};&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        String sIndexFolder = xpath:{/workflow/Script_164/output};&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        if(m.get(&amp;quot;clientOs&amp;quot;).toLowerCase().contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            sIndexFolder += &amp;quot;\\CV_Index\\restores\\&amp;quot;;&amp;#xD;&amp;#xA;            return &amp;quot;\&amp;quot;&amp;quot; + sIndexFolder + oldFolderName + &amp;quot;\&amp;quot; \&amp;quot;&amp;quot; + newFolderName + &amp;quot;\&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        sIndexFolder += &amp;quot;/CV_Index/restores/&amp;quot;;&amp;#xD;&amp;#xA;        return &amp;quot;\&amp;quot;&amp;quot; + sIndexFolder + oldFolderName + &amp;quot;\&amp;quot; \&amp;quot;&amp;quot; + sIndexFolder + newFolderName + &amp;quot;\&amp;quot;&amp;quot;;    &amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;    &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed during v1 index check for client - &amp;quot; +  xpath:{/workflow/ForEach_4/row/col[@name=&amp;quot;name&amp;quot;]});&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_169" commented="0" description="" originalStyle="" points="" sourceX="1832" sourceY="70" status="0" style="defaultEdge" targetX="1835" targetY="152" transitionIndex="0" x="0" y="0">

              <condition language="1" script="xpath:{/workflow/Script_168/output}.isEmpty()" />

            </transition>

            <transition activity="Script_170" commented="0" description="" originalStyle="" points="" sourceX="1832" sourceY="70" status="0" style="defaultEdge" targetX="2089" targetY="62" transitionIndex="0" x="0" y="0">

              <condition language="1" script="!xpath:{/workflow/Script_168/output}.isEmpty()" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1586981570238" description="activity to execute code snippets in the selected language" displayName="Check if V2 index" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_169" waitSetting="0" width="128" x="1774" y="129">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    Map m = xpath:{/workflow/ExecuteProcessBlock_74/Script_ClientDetails/output};&amp;#xD;&amp;#xA;    int jobId = xpath:{/workflow/variables/iJobId};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String sIndexFolder = xpath:{/workflow/Script_164/output};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(m.get(&amp;quot;clientOs&amp;quot;).toLowerCase().contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        sIndexFolder += &amp;quot;\\CvIdxDB\\Temp&amp;quot;;&amp;#xD;&amp;#xA;        return &amp;quot;/b /ad \&amp;quot;&amp;quot; + sIndexFolder + &amp;quot;\&amp;quot; | find \&amp;quot;&amp;quot; + Integer.toString(jobId) + &amp;quot;\&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        sIndexFolder += &amp;quot;/CvIdxDB/Temp&amp;quot;;&amp;#xD;&amp;#xA;        return &amp;quot;-d &amp;quot; + sIndexFolder + &amp;quot;/* | sed ''s:.*/::'' | grep \&amp;quot;&amp;quot; + Integer.toString(jobId) + &amp;quot;\&amp;quot;&amp;quot;;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed during v1 index check for client - &amp;quot; +  xpath:{/workflow/ForEach_4/row/col[@name=&amp;quot;name&amp;quot;]});&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_58" commented="0" description="" originalStyle="" points="" sourceX="1838" sourceY="146" status="0" style="defaultEdge" targetX="1699" targetY="128" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1586981583833" description="activity to execute code snippets in the selected language" displayName="Check if V1 index" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_170" waitSetting="0" width="128" x="1972" y="53">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{   &amp;#xD;&amp;#xA;    Map m = xpath:{/workflow/ExecuteProcessBlock_74/Script_ClientDetails/output};&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;    if(m.get(&amp;quot;clientOs&amp;quot;).toLowerCase().contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;        return &amp;quot;ren&amp;quot;;&amp;#xD;&amp;#xA;    return &amp;quot;mv&amp;quot;; &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed during v1 index check for client - &amp;quot; +  xpath:{/workflow/ForEach_4/row/col[@name=&amp;quot;name&amp;quot;]});&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_57" commented="0" description="" originalStyle="" points="" sourceX="2036" sourceY="70" status="0" style="defaultEdge" targetX="2212" targetY="70" transitionIndex="0" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1586982203150" description="Execute a command on a remote machine" displayName="Check if V1 index" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_57" waitSetting="0" width="134" x="2145" y="53">

            <onExit language="4" script="workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ForEach_4/row/col[@name=&quot;name&quot;]}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_170/output}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_168/output}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Break_5" commented="0" description="" originalStyle="" points="" sourceX="2038" sourceY="150" status="0" style="defaultEdge" targetX="2100" targetY="113" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1586982437224" description="Execute a command on a remote machine" displayName="Check if V2 index" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_58" waitSetting="0" width="134" x="1602" y="129">

            <onExit language="4" script="workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ForEach_4/row/col[@name=&quot;name&quot;]}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_166/output}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_169/output}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_171" commented="0" description="" originalStyle="" points="" sourceX="1669" sourceY="146" status="0" style="defaultEdge" targetX="1513" targetY="140" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1586982481326" description="activity to execute code snippets in the selected language" displayName="Check if V2 index" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_171" waitSetting="0" width="128" x="1432" y="129">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;import java.util.regex.Matcher;&amp;#xD;&amp;#xA;import java.util.regex.Pattern;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{   &amp;#xD;&amp;#xA;    String op = xpath:{/workflow/ExecuteCommand_58/commandOutput};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String[] lines = op.split(&amp;quot;\\n&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String oldFolderName = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    String newFolderName = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    Pattern p1 = Pattern.compile(&amp;quot;([0-9]+_restore)_[0-9]+&amp;quot;);&amp;#xD;&amp;#xA;    Pattern p2 = Pattern.compile(&amp;quot;([0-9]+_restore)+&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    for(String line : lines)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        Matcher m1 = p1.matcher(line);&amp;#xD;&amp;#xA;        if(m1.find())&amp;#xD;&amp;#xA;        {  &amp;#xD;&amp;#xA;           newFolderName = m1.group(1);&amp;#xD;&amp;#xA;           oldFolderName = m1.group(0);&amp;#xD;&amp;#xA;           break;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        Matcher m2 = p2.matcher(line);&amp;#xD;&amp;#xA;        if(m2.find())&amp;#xD;&amp;#xA;        {  &amp;#xD;&amp;#xA;           newFolderName = m2.group(1);&amp;#xD;&amp;#xA;           oldFolderName = m2.group(0);&amp;#xD;&amp;#xA;           break;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(!newFolderName.isEmpty())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Restore vector folder found on client [&amp;quot; + xpath:{/workflow/ForEach_4/row/col[@name=&amp;quot;name&amp;quot;]} + &amp;quot;]. Renamed &amp;quot; + oldFolderName + &amp;quot; to &amp;quot; +  newFolderName);&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;sRestoreFailedRvMA&amp;quot;, xpath:{/workflow/ForEach_4/row/col[@name=&amp;quot;name&amp;quot;]});&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        Map m = xpath:{/workflow/ExecuteProcessBlock_74/Script_ClientDetails/output};&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        String sIndexFolder = xpath:{/workflow/Script_164/output};&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        if(m.get(&amp;quot;clientOs&amp;quot;).toLowerCase().contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            sIndexFolder += &amp;quot;\\CvIdxDB\\Temp\\&amp;quot;;&amp;#xD;&amp;#xA;            return &amp;quot;\&amp;quot;&amp;quot; + sIndexFolder + oldFolderName + &amp;quot;\&amp;quot; \&amp;quot;&amp;quot; + newFolderName + &amp;quot;\&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        sIndexFolder += &amp;quot;/CvIdxDB/Temp/&amp;quot;;&amp;#xD;&amp;#xA;        return &amp;quot;\&amp;quot;&amp;quot; + sIndexFolder + oldFolderName + &amp;quot;\&amp;quot; \&amp;quot;&amp;quot; + sIndexFolder + newFolderName + &amp;quot;\&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;    &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed during v1 index check for client - &amp;quot; +  xpath:{/workflow/ForEach_4/row/col[@name=&amp;quot;name&amp;quot;]});&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_172" commented="0" description="" originalStyle="" points="" sourceX="1496" sourceY="146" status="0" style="defaultEdge" targetX="1315" targetY="149" transitionIndex="0" x="0" y="0">

              <condition language="1" script="!xpath:{/workflow/Script_171/output}.isEmpty()" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1586982558797" description="activity to execute code snippets in the selected language" displayName="Check if V2 index" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_172" waitSetting="0" width="128" x="1258" y="129">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{   &amp;#xD;&amp;#xA;    Map m = xpath:{/workflow/ExecuteProcessBlock_74/Script_ClientDetails/output};&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;    if(m.get(&amp;quot;clientOs&amp;quot;).toLowerCase().contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;        return &amp;quot;ren&amp;quot;;&amp;#xD;&amp;#xA;    return &amp;quot;mv&amp;quot;; &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed during v1 index check for client - &amp;quot; +  xpath:{/workflow/ForEach_4/row/col[@name=&amp;quot;name&amp;quot;]});&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_59" commented="0" description="" originalStyle="" points="" sourceX="1322" sourceY="146" status="0" style="defaultEdge" targetX="1157" targetY="141" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1586982570720" description="Execute a command on a remote machine" displayName="Check if V2 index" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_59" waitSetting="0" width="134" x="1077" y="129">

            <onExit language="4" script="workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ForEach_4/row/col[@name=&quot;name&quot;]}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_172/output}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_171/output}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Break_6" commented="0" description="" originalStyle="" points="" sourceX="1144" sourceY="146" status="0" style="defaultEdge" targetX="1018" targetY="147" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1586988042271" description="interrupts a process block execution" displayName="Break" height="34" interactive="0" jobMode="0" name="Break" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.InterruptActivity" uniqueName="Break_5" waitSetting="0" width="100" x="2082" y="127">

            <inputs val="&lt;inputs /&gt;" />

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1586988047862" description="interrupts a process block execution" displayName="Break" height="34" interactive="0" jobMode="0" name="Break" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.InterruptActivity" uniqueName="Break_6" waitSetting="0" width="100" x="938" y="129">

            <inputs val="&lt;inputs /&gt;" />

          </Activity>

        </superProcess>

      </Activity>

      <Activity commented="0" continueOnFailure="1" created="1586900880477" description="" displayName="Get Restore Job Details" height="34" interactive="0" jobMode="0" maxRestarts="0" name="Execute" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute" uniqueName="Execute_4" waitSetting="0" width="163" x="920" y="307">

        <inputs val="&lt;inputs&gt;&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;&amp;lt;TMMsg_GetTaskDetailByJobReq jobId=&quot;xpath:{/workflow/variables/iJobId}&quot;/&amp;gt; &lt;/inputXml&gt;&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/escapeXml&gt;&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ImpersonateCreator_2/token}&lt;/token&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

        <transition activity="Script_159" commented="0" description="" originalStyle="" points="" sourceX="943" sourceY="324" status="0" style="defaultEdge" targetX="1152" targetY="324" transitionIndex="0" x="0" y="0">

          <condition language="4" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1586900953493" description="activity to execute code snippets in the selected language" displayName="Process Details For Resubmission" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_159" waitSetting="0" width="200" x="1104" y="307">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;import org.jdom2.Element;&amp;#xD;&amp;#xA;import org.jdom2.Document;&amp;#xD;&amp;#xA;import org.jdom2.Attribute;&amp;#xD;&amp;#xA;import org.jdom2.input.SAXBuilder;&amp;#xD;&amp;#xA;import org.jdom2.output.XMLOutputter;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String data = xpath:{/workflow/Execute_4/outputXml};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    InputStream stream = new ByteArrayInputStream(data.getBytes(&amp;quot;UTF-8&amp;quot;));&amp;#xD;&amp;#xA;    SAXBuilder builder = new SAXBuilder();&amp;#xD;&amp;#xA;    Document doc;&amp;#xD;&amp;#xA;    doc = builder.build(stream);&amp;#xD;&amp;#xA;    Element GetTaskDetailResp = doc.getRootElement();&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    Element CreateTaskReq = new Element(&amp;quot;TMMsg_CreateTaskReq&amp;quot;);&amp;#xD;&amp;#xA;    Document returnDoc = new Document(CreateTaskReq);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    CreateTaskReq.setAttribute(&amp;quot;submitJobId&amp;quot;, Integer.toString(xpath:{/workflow/variables/iJobId}));&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    for(Element taskInfo : GetTaskDetailResp.getChildren())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        CreateTaskReq.addContent(taskInfo.clone());&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;sJobInfoDetails&amp;quot;,new XMLOutputter().outputString(returnDoc));&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;&amp;#x9;logger.info(&amp;quot;Error parsing restore job details. Exception: &amp;quot; + e);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="Execute_5" commented="0" description="" originalStyle="" points="" sourceX="974" sourceY="324" status="0" style="defaultEdge" targetX="1175" targetY="330" transitionIndex="0" x="0" y="0">

          <condition language="1" script="xpath:{/workflow/Script_159/output}" />

        </transition>

        <transition activity="ForEach_5" commented="0" description="" originalStyle="" points="1208.0,249.0" sourceX="974" sourceY="324" status="0" style="defaultEdge" targetX="979" targetY="411" transitionIndex="0" x="0" y="0">

          <condition language="1" script="!xpath:{/workflow/Script_159/output}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="1" created="1586904400726" description="" displayName="Resubmit Job" height="34" interactive="0" jobMode="0" maxRestarts="0" name="Execute" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute" uniqueName="Execute_5" waitSetting="0" width="108" x="1324" y="307">

        <inputs val="&lt;inputs&gt;&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;java:{workflow.getVariable(&quot;sJobInfoDetails&quot;)}&lt;/inputXml&gt;&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/escapeXml&gt;&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ImpersonateCreator_2/token}&lt;/token&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

        <transition activity="Script_161" commented="0" description="" originalStyle="" points="" sourceX="1338" sourceY="324" status="0" style="defaultEdge" targetX="1519" targetY="324" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1586904983485" description="activity to execute code snippets in the selected language" displayName="Get New Restore JobId" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_161" waitSetting="0" width="159" x="1454" y="307">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;import org.jdom2.Element;&amp;#xD;&amp;#xA;import org.jdom2.Document;&amp;#xD;&amp;#xA;import org.jdom2.Attribute;&amp;#xD;&amp;#xA;import org.jdom2.input.SAXBuilder;&amp;#xD;&amp;#xA;import org.jdom2.output.XMLOutputter;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String data = xpath:{/workflow/Execute_5/outputXml};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    InputStream stream = new ByteArrayInputStream(data.getBytes(&amp;quot;UTF-8&amp;quot;));&amp;#xD;&amp;#xA;    SAXBuilder builder = new SAXBuilder();&amp;#xD;&amp;#xA;    Document doc;&amp;#xD;&amp;#xA;    doc = builder.build(stream);&amp;#xD;&amp;#xA;    Element CreateTaskResp = doc.getRootElement();&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    int jobId = 0;&amp;#xD;&amp;#xA;    for(Element child : CreateTaskResp.getChildren())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        if(child.getName().equals(&amp;quot;jobIds&amp;quot;) &amp;amp;&amp;amp; child.hasAttributes())&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            String job = child.getAttributeValue(&amp;quot;val&amp;quot;);&amp;#xD;&amp;#xA;            jobId = Integer.parseInt(job);&amp;#xD;&amp;#xA;                &amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(jobId == 0)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Failed to resubmit failed restore job for restore vector information.&amp;quot;);&amp;#xD;&amp;#xA;        return false;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;iJobId&amp;quot;, jobId);&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Restore job resubmitted. New restore JID [&amp;quot; + Integer.toString(jobId) + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;&amp;#x9;logger.info(&amp;quot;Failed to resubmit failed restore job for restore vector information. Exception: &amp;quot; + e);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="CommServDBQuery_63" commented="0" description="" originalStyle="" points="1513.0,261.0" sourceX="1341" sourceY="324" status="0" style="defaultEdge" targetX="669" targetY="401" transitionIndex="0" x="0" y="0">

          <condition language="1" script="xpath:{/workflow/Script_161/output}" />

        </transition>

        <transition activity="ForEach_5" commented="0" description="" originalStyle="" points="1527.0,263.0" sourceX="1341" sourceY="324" status="0" style="defaultEdge" targetX="1171" targetY="407" transitionIndex="0" x="0" y="0">

          <condition language="1" script="!xpath:{/workflow/Script_161/output}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="1" created="1586920226541" description="Execute a command on a remote machine" displayName="Get Restore Job Details" height="36" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_53" waitSetting="0" width="163" x="737" y="306">

        <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

        <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;hostName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;displayName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;commCellName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;csGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;type class=&quot;commvault.msgs.CvEntities.CommCellType&quot; _list_=&quot;false&quot; /&gt;&lt;flags class=&quot;commvault.msgs.CvEntities.EntityFlags&quot; _list_=&quot;false&quot; /&gt;&lt;GUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;newName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;ping&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;127.0.0.1 -n 61 &amp;gt; nul&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

        <transition activity="Execute_4" commented="0" description="" originalStyle="" points="" sourceX="796" sourceY="265" status="0" style="defaultEdge" targetX="794" targetY="324" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1586920419404" description="executes a defined process block within the workflow" displayName="Monitor resubmitted job" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess" uniqueName="ExecuteProcessBlock_75" waitSetting="0" width="200" x="1679" y="307">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

          <outputs name="ProcessBlock_14">

            <children name="Start_15" />

            <children name="Script_20">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="EnableLogging_14" />

            <children name="DisableLogging_15" />

            <children name="ExecuteProcessBlock_67">

              <children name="Start_41" />

              <children name="Job_2" type="">

                <children className="workflow.types.cmd.JobDetails" inputType="workflow.types.cmd.JobDetails" listType="1" name="job" type="{workflow.types.cmd}JobDetails">

                  <children className="java.lang.Integer" inputType="java.lang.Integer" name="jobId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" inputType="java.lang.String" name="jobType" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="status" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="phase" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children name="Script_100">

                <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

              <children name="EnableLogging_31" />

              <children name="DisableLogging_47" />

            </children>

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;processBlock&gt;ProcessBlock_14&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="EnableLogging_40" commented="0" description="" originalStyle="" points="1738.0,366.0" sourceX="1779" sourceY="324" status="0" style="defaultEdge" targetX="1694" targetY="399" transitionIndex="0" x="0" y="0">

          <condition language="1" script="!xpath:{/workflow/ExecuteProcessBlock_75/Script_20/output}" />

        </transition>

        <transition activity="ExecuteCommand_54" commented="0" description="" originalStyle="" points="1834.0,265.0" sourceX="1779" sourceY="324" status="0" style="defaultEdge" targetX="1792" targetY="203" transitionIndex="0" x="0" y="0">

          <condition language="1" script="xpath:{/workflow/ExecuteProcessBlock_75/Script_20/output}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="1" created="1586920554510" description="Execute a command on a remote machine" displayName="Monitor resubmitted job" height="36" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_54" waitSetting="0" width="165" x="1687" y="188">

        <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

        <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;hostName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;displayName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;commCellName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;csGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;type class=&quot;commvault.msgs.CvEntities.CommCellType&quot; _list_=&quot;false&quot; /&gt;&lt;flags class=&quot;commvault.msgs.CvEntities.EntityFlags&quot; _list_=&quot;false&quot; /&gt;&lt;GUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;newName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;ping&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;127.0.0.1 -n 61 &amp;gt; nul&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_75" commented="0" description="" originalStyle="" points="1710.0,271.0" sourceX="1767" sourceY="204" status="0" style="defaultEdge" targetX="1768" targetY="313" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1586922960767" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_40" waitSetting="0" width="113" x="1489" y="349">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="ForEach_4" commented="0" description="" originalStyle="" points="" sourceX="2045" sourceY="324" status="0" style="defaultEdge" targetX="1428" targetY="406" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1608158277490" description="executes queries against a commcell database" displayName="Get New Restore JobId" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_63" waitSetting="0" width="159" x="1441" y="179">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @jobId int = xpath:{/workflow/variables/iJobId};&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @ccId int&amp;#xD;&#xD;&#xA;select @ccId = id&amp;#xD;&#xD;&#xA;from app_client(nolock)&amp;#xD;&#xD;&#xA;where name = ''xpath:{/workflow/system/commCellName}'';&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @wfJID int = xpath:{/workflow/system/jobId};&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;IF EXISTS(SELECT 1 &amp;#xD;&#xD;&#xA;    FROM JMJobOptions(READUNCOMMITTED)&amp;#xD;&#xD;&#xA;    WHERE attributeId = xpath:{/workflow/variables/JM_CLOUD_RECALL_WF_ID}&amp;#xD;&#xD;&#xA;    AND jobId = @jobId)&amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;    DELETE FROM JMJobOptions &amp;#xD;&#xD;&#xA;    WHERE jobId = @jobId&amp;#xD;&#xD;&#xA;    AND commCellId = @ccId&amp;#xD;&#xD;&#xA;    AND attributeid = xpath:{/workflow/variables/JM_CLOUD_RECALL_WF_ID}&amp;#xD;&#xD;&#xA;END&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;INSERT INTO JMJobOptions(jobId, commCellId, attributeid, attributeName, attributeValueInt, attributeValue)&amp;#xD;&#xD;&#xA;VALUES(@jobId, @ccId, xpath:{/workflow/variables/JM_CLOUD_RECALL_WF_ID}, ''Cloud Recall Workflow JobId'', @wfJID, '''');&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_75" commented="0" description="" originalStyle="" points="" sourceX="1520" sourceY="196" status="0" style="defaultEdge" targetX="1723" targetY="329" transitionIndex="0" x="0" y="0">

          <condition language="4" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1608158721173" description="executes queries against a commcell database" displayName="Check if processed" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_64" waitSetting="0" width="140" x="86" y="253">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @jobId int = xpath:{/workflow/variables/iJobId};&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @ccId int&amp;#xD;&#xD;&#xA;select @ccId = id&amp;#xD;&#xD;&#xA;from app_client(nolock)&amp;#xD;&#xD;&#xA;where name = ''xpath:{/workflow/system/commCellName}'';&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @wfJID int = xpath:{/workflow/system/jobId};&amp;#xD;&#xD;&#xA;declare @existingJid int = xpath:{/workflow/system/jobId};&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;IF EXISTS(SELECT 1 &amp;#xD;&#xD;&#xA;    FROM JMJobOptions(READUNCOMMITTED)&amp;#xD;&#xD;&#xA;    WHERE attributeId = xpath:{/workflow/variables/JM_CLOUD_RECALL_WF_ID}&amp;#xD;&#xD;&#xA;    AND jobId = @jobId)&amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;    SELECT TOP 1 @existingJid = attributeValueInt&amp;#xD;&#xD;&#xA;    FROM JMJobOptions(READUNCOMMITTED)&amp;#xD;&#xD;&#xA;    WHERE attributeId = xpath:{/workflow/variables/JM_CLOUD_RECALL_WF_ID}&amp;#xD;&#xD;&#xA;    AND jobId = @jobId&amp;#xD;&#xD;&#xA;END&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;IF @wfJID = @existingJid&amp;#xD;&#xD;&#xA;    select 1 op&amp;#xD;&#xD;&#xA;else&amp;#xD;&#xD;&#xA;    select 0 op&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="Script_183" commented="0" description="" originalStyle="" points="" sourceX="156" sourceY="270" status="0" style="defaultEdge" targetX="332" targetY="270" transitionIndex="0" x="0" y="0">

          <condition language="4" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1608158979880" description="activity to execute code snippets in the selected language" displayName="Check if processed" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_183" waitSetting="0" width="140" x="262" y="253">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;4&quot; script=&quot;if(1 == xpath:{/workflow/CommServDBQuery_64/resultSets[1]/row[1]/col[@name=&amp;quot;op&amp;quot;]})&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;return false;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="ImpersonateCreator_2" commented="0" description="" originalStyle="" points="" sourceX="332" sourceY="270" status="0" style="defaultEdge" targetX="217" targetY="332" transitionIndex="0" x="0" y="0">

          <condition language="4" script="xpath:{/workflow/Script_183/output}" />

        </transition>

        <transition activity="DisableLogging_52" commented="0" description="" originalStyle="" points="574.0,260.0" sourceX="332" sourceY="270" status="0" style="defaultEdge" targetX="791" targetY="265" transitionIndex="0" x="0" y="0">

          <condition language="4" script="!xpath:{/workflow/Script_183/output}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1608159060312" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_52" waitSetting="0" width="117" x="738" y="250">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="WorkflowEnd_29" commented="0" description="" originalStyle="" points="" sourceX="796" sourceY="267" status="0" style="defaultEdge" targetX="941" targetY="274" transitionIndex="0" x="0" y="0">

          <condition language="4" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1608159073534" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_29" waitSetting="0" width="106" x="883" y="251">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Failure Reason: There is already another workflow job processing the restore job&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1575490190985" description="creates a super process group" displayName="Get Client Details" height="140" interactive="0" jobMode="0" name="ProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#BEE0B8;gradientColor=#BEE0B8" uniqueName="ProcessBlock_17" waitSetting="0" width="987" x="654" y="4288">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="">

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sClientName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      </inputs>

      <outputs className="" defaultValue="" listType="0" name="outputs" type="">

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sClientName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      </outputs>

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;sClientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1575490190985" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_19" waitSetting="0" width="63" x="24" y="72">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="EnableLogging_13" commented="0" description="" originalStyle="" points="" sourceX="55" sourceY="87" status="0" style="defaultEdge" targetX="175" targetY="86" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1575487710146" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_1" waitSetting="0" width="117" x="370" y="70">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Execute_1" commented="0" description="" originalStyle="" points="" sourceX="316" sourceY="87" status="0" style="defaultEdge" targetX="473" targetY="87" transitionIndex="0" x="-741" y="-1350">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1575488855551" description="" displayName="Client Properties" height="34" interactive="0" jobMode="0" name="Execute" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute" uniqueName="Execute_1" waitSetting="0" width="125" x="525" y="70">

        <inputs val="&lt;inputs&gt;&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;&amp;lt;App_GetClientPropertiesRequest&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&amp;lt;association&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&amp;lt;entity&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&amp;lt;clientName/&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&amp;lt;/entity&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&amp;lt;/association&amp;gt;&amp;#xD;&#xD;&#xA;&amp;lt;/App_GetClientPropertiesRequest&amp;gt;&lt;/inputXml&gt;&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/escapeXml&gt;&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;-clientName &quot;xpath:{/workflow/ProcessBlock_17/sClientName}&quot;&lt;/commandArgs&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

        <transition activity="Script_ClientDetails" commented="0" description="" originalStyle="" points="" sourceX="473" sourceY="87" status="0" style="defaultEdge" targetX="635" targetY="87" transitionIndex="0" x="-741" y="-1350">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1575489302369" description="activity to execute code snippets in the selected language" displayName="Client Properties" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_ClientDetails" waitSetting="0" width="125" x="681" y="70">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;//Get Temp directory for client&amp;#xD;&amp;#xA;import java.util.regex.Matcher;&amp;#xD;&amp;#xA;import java.util.regex.Pattern;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String outputXml = xpath:{/workflow/Execute_1/outputXml};&amp;#xD;&amp;#xA;    String[] list = outputXml.split(&amp;quot;\n&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    Pattern pattern1 = Pattern.compile(&amp;quot;.*&amp;lt;OSName&amp;gt;(.*?)&amp;lt;/OSName&amp;gt;.*&amp;quot;)&amp;#xD;&amp;#xA;            , pattern2 = Pattern.compile(&amp;quot;.*&amp;lt;installDirectory&amp;gt;(.*?)&amp;lt;/installDirectory&amp;gt;.*&amp;quot;);  &amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String os, installFolder;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    for (String line:list)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        Matcher matcher1 = pattern1.matcher(line);&amp;#xD;&amp;#xA;        if (matcher1.find()) &amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            os = matcher1.group(1);&amp;#xD;&amp;#xA;        }    &amp;#xD;&amp;#xA;        Matcher matcher2 = pattern2.matcher(line);&amp;#xD;&amp;#xA;        if (matcher2.find()) &amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            installFolder = matcher2.group(1);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    Map m = new HashMap();&amp;#xD;&amp;#xA;    m.put(&amp;quot;clientOs&amp;quot;, os);&amp;#xD;&amp;#xA;    m.put(&amp;quot;clientInstallFolder&amp;quot;, installFolder);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;Client Details - OS [&amp;quot; + os + &amp;quot;] Install Folder [&amp;quot; + installFolder + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;    if(os.toLowerCase().contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        m.put(&amp;quot;clientMediaAgentFolder&amp;quot;, installFolder + &amp;quot;\\MediaAgent&amp;quot;);&amp;#xD;&amp;#xA;        m.put(&amp;quot;clientBaseFolder&amp;quot;, installFolder + &amp;quot;\\Base&amp;quot;);&amp;#xD;&amp;#xA;        m.put(&amp;quot;clientTempFolder&amp;quot;, installFolder + &amp;quot;\\Base\\Temp&amp;quot;);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;    {   &amp;#xD;&amp;#xA;        m.put(&amp;quot;clientMediaAgentFolder&amp;quot;, installFolder + &amp;quot;/MediaAgent&amp;quot;);&amp;#xD;&amp;#xA;        m.put(&amp;quot;clientBaseFolder&amp;quot;, installFolder + &amp;quot;/Base&amp;quot;);&amp;#xD;&amp;#xA;        m.put(&amp;quot;clientTempFolder&amp;quot;, installFolder + &amp;quot;/Base/Temp&amp;quot;);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    return m;&amp;#xD;&amp;#xA; }&amp;#xD;&amp;#xA; catch(e)&amp;#xD;&amp;#xA; {&amp;#xD;&amp;#xA;     logger.info(&amp;quot;Exception getting client props &amp;quot; + e);&amp;#xD;&amp;#xA;     return null;&amp;#xD;&amp;#xA; }   &amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_14" commented="0" description="" originalStyle="" points="" sourceX="743" sourceY="87" status="0" style="defaultEdge" targetX="912" targetY="85" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1575492873180" description="if/else based decision" displayName="Debug" height="54" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_4" waitSetting="0" width="66" x="267" y="60">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;1 == xpath:{/workflow/variables/iDebugMode}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="Execute_1" commented="0" description="" displayName="Debug enabled" offsetX="-20" offsetY="-10" originalStyle="" points="505.0,41.0" sourceX="166" sourceY="79" status="0" style="defaultEdge" targetX="493" targetY="72" transitionIndex="0" value="true" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="DisableLogging_1" commented="0" description="" originalStyle="" points="" sourceX="166" sourceY="79" status="0" style="defaultEdge" targetX="290" targetY="72" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578671083440" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_13" waitSetting="0" width="113" x="121" y="70">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Decision_4" commented="0" description="" originalStyle="" points="" sourceX="167" sourceY="87" status="0" style="defaultEdge" targetX="285" targetY="88" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578671113453" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_14" waitSetting="0" width="117" x="841" y="70">

        <inputs val="&lt;inputs /&gt;" />

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1575515059071" description="creates a super process group" displayName="MediaAgent Version" height="140" interactive="0" jobMode="0" name="ProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#BEE0B8;gradientColor=#BEE0B8" uniqueName="ProcessBlock_18" waitSetting="0" width="558" x="654" y="4440">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="">

        <children attribute="0" className="java.lang.Integer" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" name="iRelease" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

        <children attribute="0" className="java.lang.Integer" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" name="iVersion" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      </inputs>

      <outputs className="" defaultValue="" listType="0" name="outputs" type="">

        <children attribute="0" className="java.lang.Integer" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" name="iRelease" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

        <children attribute="0" className="java.lang.Integer" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" name="iVersion" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      </outputs>

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;iRelease class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;iVersion class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1575515059071" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_20" waitSetting="0" width="58" x="22" y="62">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="EnableLogging_15" commented="0" description="" originalStyle="" points="" sourceX="59" sourceY="77" status="0" style="defaultEdge" targetX="198" targetY="80" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1575515121722" description="activity to execute code snippets in the selected language" displayName="Is Older Version" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_IsOlder" waitSetting="0" width="121" x="260" y="60">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;//if(xpath:{/workflow/ProcessBlock_18/iRelease} &amp;lt;= 11 &amp;amp;&amp;amp; xpath:{/workflow/ProcessBlock_18/iVersion} &amp;lt; 19)&amp;#xD;&amp;#xA;//    return true;&amp;#xD;&amp;#xA;//else&amp;#xD;&amp;#xA;//    return false;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;//Following code will be replaced once binary changes are made. Considering all MAs as older version until then&amp;#xD;&amp;#xA;return true;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_16" commented="0" description="" originalStyle="" points="" sourceX="320" sourceY="77" status="0" style="defaultEdge" targetX="476" targetY="77" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578671223879" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_16" waitSetting="0" width="117" x="418" y="60">

        <inputs val="&lt;inputs /&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578671228635" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_15" waitSetting="0" width="113" x="111" y="60">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Script_IsOlder" commented="0" description="" originalStyle="" points="" sourceX="175" sourceY="77" status="0" style="defaultEdge" targetX="320" targetY="78" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1575586497752" description="creates a super process group" displayName="Legend" height="217" interactive="0" jobMode="0" name="ProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#E0E085;gradientColor=#E0E085" uniqueName="ProcessBlock_22" waitSetting="0" width="207" x="58" y="195">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs className="" defaultValue="" listType="0" name="outputs" type="" />

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="0" description="" displayName="  " height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_24" waitSetting="0" width="36" x="84" y="50">

        <inputs val="&lt;inputs /&gt;" />

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1575585697505" description="activity to delay the workflow execution in minutes" displayName="Utility Process Blocks" height="34" interactive="0" jobMode="0" name="Delay" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.DelayActivity;fillColor=#BEE0B8;gradientColor=#BEE0B8" uniqueName="Delay_2" waitSetting="0" width="154" x="26" y="100">

        <inputs val="&lt;inputs&gt;&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;&gt;Minutes&lt;/delayInterval&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1575586538125" description="activity to delay the workflow execution in minutes" displayName="Main Process Blocks" height="34" interactive="0" jobMode="0" name="Delay" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.DelayActivity;fillColor=#85E0E0;gradientColor=#85E0E0" uniqueName="Delay_3" waitSetting="0" width="150" x="28" y="49">

        <inputs val="&lt;inputs&gt;&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;&gt;Minutes&lt;/delayInterval&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1575586599092" description="activity to delay the workflow execution in minutes" displayName="Sub Process Blocks" height="34" interactive="0" jobMode="0" name="Delay" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.DelayActivity;fillColor=#FADB9E;gradientColor=#FADB9E" uniqueName="Delay_4" waitSetting="0" width="145" x="30" y="158">

        <inputs val="&lt;inputs&gt;&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;&gt;Minutes&lt;/delayInterval&gt;&lt;/inputs&gt;" />

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1575909723467" description="creates a super process group" displayName="Prepare Recall Commands" height="156" interactive="0" jobMode="0" name="ProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#BEE0B8;gradientColor=#BEE0B8" uniqueName="ProcessBlock_23" waitSetting="0" width="795" x="14" y="4591">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="">

        <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sCloudToolMode" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="iIndexFree" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      </inputs>

      <outputs className="" defaultValue="" listType="0" name="outputs" type="">

        <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sCloudToolMode" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="iIndexFree" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      </outputs>

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;sCloudToolMode class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;2&lt;/sCloudToolMode&gt;&lt;iIndexFree class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;0&lt;/iIndexFree&gt;&lt;/inputs&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1575909723467" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_25" waitSetting="0" width="58" x="26" y="70">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="EnableLogging_16" commented="0" description="" originalStyle="" points="" sourceX="55" sourceY="127" status="0" style="defaultEdge" targetX="579" targetY="127" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1576438685102" description="executes queries against a commcell database" displayName="CommCellId" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_15" waitSetting="0" width="98" x="256" y="68">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;select id&amp;#xD;&#xD;&#xA;from app_client(nolock)&amp;#xD;&#xD;&#xA;where name = ''xpath:{/workflow/system/commCellName}'';&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="Script_31" commented="0" description="" originalStyle="" points="" sourceX="305" sourceY="127" status="0" style="defaultEdge" targetX="502" targetY="124" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578671739483" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_16" waitSetting="0" width="113" x="115" y="68">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="CommServDBQuery_15" commented="0" description="" originalStyle="" points="" sourceX="167" sourceY="76" status="0" style="defaultEdge" targetX="324" targetY="129" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578671749045" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_17" waitSetting="0" width="117" x="608" y="68">

        <inputs val="&lt;inputs /&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1575921240007" description="activity to execute code snippets in the selected language" displayName="Generate Recall Command" height="32" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_31" waitSetting="0" width="181" x="388" y="69">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;//Input XML&amp;#xD;&amp;#xA;//&amp;lt;MountPath MountPathId=&amp;quot;&amp;quot; MountPathName=&amp;quot;&amp;quot; Vendor=&amp;quot;&amp;quot; MediaAgentId=&amp;quot;&amp;quot; MediaAgentOs=&amp;quot;&amp;quot; MediaAgentInstance=&amp;quot;&amp;quot; MediaAgentName=&amp;quot;&amp;quot; MediaAgentBase=&amp;quot;&amp;quot; MediaAgentTemp=&amp;quot;&amp;quot; ChunkCount=&amp;quot;&amp;quot; RowNumber=&amp;quot;&amp;quot; ThreadCount=&amp;quot;&amp;quot;&amp;gt;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#xD;&amp;#xA;//&amp;#x9;&amp;lt;Chunks&amp;gt;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#xD;&amp;#xA;//&amp;#x9;&amp;#x9;&amp;lt;Chunk VolumeId=&amp;quot;&amp;quot; IsDeduped=&amp;quot;&amp;quot; ArchFileId=&amp;quot;&amp;quot; Chunk=&amp;quot;&amp;quot; Offset=&amp;quot;&amp;quot; Cclip=&amp;quot;&amp;quot;&amp;gt;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#xD;&amp;#xA;//&amp;#x9;&amp;#x9;&amp;lt;Chunk VolumeId=&amp;quot;&amp;quot; IsDeduped=&amp;quot;&amp;quot; ArchFileId=&amp;quot;&amp;quot; Chunk=&amp;quot;&amp;quot; Offset=&amp;quot;&amp;quot; Cclip=&amp;quot;&amp;quot;&amp;gt;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#xD;&amp;#xA;//&amp;#x9;&amp;lt;/Chunks&amp;gt;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#xD;&amp;#xA;//&amp;lt;/MountPath&amp;gt;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;//Output XML&amp;#xD;&amp;#xA;//&amp;lt;recallCommands&amp;gt;&amp;#xD;&amp;#xA;//&amp;#x9;&amp;lt;recallCommand clientName=&amp;quot;&amp;quot; clientBase=&amp;quot;&amp;quot; clientTemp=&amp;quot;&amp;quot; clientOs=&amp;quot;&amp;quot; rowNumber=&amp;quot;&amp;quot; cmd=&amp;quot;&amp;quot; arg=&amp;quot;&amp;quot; azureMode=&amp;quot;&amp;quot; mode=&amp;quot;&amp;quot; mountPathName=&amp;quot;&amp;quot; processIdentifier=&amp;quot;&amp;quot; jid=&amp;quot;&amp;quot;/&amp;gt;&amp;#xD;&amp;#xA;//&amp;#x9;&amp;lt;recallCommand clientName=&amp;quot;&amp;quot; clientBase=&amp;quot;&amp;quot; clientTemp=&amp;quot;&amp;quot; clientOs=&amp;quot;&amp;quot; rowNumber=&amp;quot;&amp;quot; cmd=&amp;quot;&amp;quot; arg=&amp;quot;&amp;quot; azureMode=&amp;quot;&amp;quot; mode=&amp;quot;&amp;quot; mountPathName=&amp;quot;&amp;quot; processIdentifier=&amp;quot;&amp;quot; jid=&amp;quot;&amp;quot;/&amp;gt;&amp;#xD;&amp;#xA;//&amp;lt;/recallCommands&amp;gt;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;//MoutpathId Vendor&amp;#xD;&amp;#xA;//V_Volume1 isDedup&amp;#xD;&amp;#xA;//  ArchFile1,Chunk1(offset),Chunk2(offset),Chunk3(offset)&amp;#xD;&amp;#xA;//  ArchFile2,Chunk3(offset),Chunk4(offset),Chunk5(offset)&amp;#xD;&amp;#xA;//V_Volume2 isDedup&amp;#xD;&amp;#xA;//  ArchFile3,Chunk7(offset),Chunk8(offset),Chunk9(offset)&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;import commvault.cte.workflow.activities.cmd.operation.OperationExecute;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;import org.jdom2.Element;&amp;#xD;&amp;#xA;import org.jdom2.Document;&amp;#xD;&amp;#xA;import org.jdom2.Attribute;&amp;#xD;&amp;#xA;import org.jdom2.input.SAXBuilder;&amp;#xD;&amp;#xA;import org.jdom2.output.XMLOutputter;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    //Global vars&amp;#xD;&amp;#xA;    String data         = xpath:{/workflow/variables/sRecallData};&amp;#xD;&amp;#xA;    String sWorkflowJid = Integer.toString(xpath:{/workflow/system/jobId});&amp;#xD;&amp;#xA;    String sCloudMode   = xpath:{/workflow/ProcessBlock_23/sCloudToolMode};&amp;#xD;&amp;#xA;    boolean bIsRestore  = (1001 == xpath:{/workflow/variables/iJobOption} || 1005 == xpath:{/workflow/variables/iJobOption});&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;    //Input data        &amp;#xD;&amp;#xA;    InputStream stream = new ByteArrayInputStream(data.getBytes(&amp;quot;UTF-8&amp;quot;));&amp;#xD;&amp;#xA;    SAXBuilder builder = new SAXBuilder();&amp;#xD;&amp;#xA;    Document doc;&amp;#xD;&amp;#xA;    doc = builder.build(stream);&amp;#xD;&amp;#xA;    Element mountPaths = doc.getRootElement();&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    //Output data&amp;#xD;&amp;#xA;    Element recallCommands = new Element(&amp;quot;recallCommands&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    int &amp;#x9;iCommandNumber = 1;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    for(Element mountPath : mountPaths.getChildren())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        int iNumFiles       = Integer.parseInt(mountPath.getAttributeValue(&amp;quot;ThreadCount&amp;quot;));&amp;#xD;&amp;#xA;        int iChunkCount     = Integer.parseInt(mountPath.getAttributeValue(&amp;quot;ChunkCount&amp;quot;));  &amp;#xD;&amp;#xA;        int iChunksPerFile  = iChunkCount / iNumFiles;&amp;#xD;&amp;#xA;        int iChunksPerWrite = (53 == Integer.parseInt(mountPath.getAttributeValue(&amp;quot;Vendor&amp;quot;)) ? 25 : 100);&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        if(bIsRestore || iChunkCount &amp;lt; 10)&amp;#xD;&amp;#xA;            iChunksPerFile = iChunkCount;&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        String sFileData = mountPath.getAttributeValue(&amp;quot;MountPathId&amp;quot;) + &amp;quot; &amp;quot; + mountPath.getAttributeValue(&amp;quot;Vendor&amp;quot;);&amp;#xD;&amp;#xA;        List dataList = new ArrayList();&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        int iFileNumber      = 1;&amp;#xD;&amp;#xA;        int iTrackChunkCount = 0;&amp;#xD;&amp;#xA;        int iTrackVolId      = 0;&amp;#xD;&amp;#xA;        int iTrackAfId       = 0;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;        String sFileNamePrefix  = &amp;quot;CloudChunk_&amp;quot; +  sWorkflowJid + &amp;quot;_IP_&amp;quot; + mountPath.getAttributeValue(&amp;quot;MountPathId&amp;quot;) + &amp;quot;_&amp;quot;;&amp;#xD;&amp;#xA;        String sFilePath        = mountPath.getAttributeValue(&amp;quot;MediaAgentTemp&amp;quot;) + (mountPath.getAttributeValue(&amp;quot;MediaAgentOs&amp;quot;).toLowerCase().contains(&amp;quot;windows&amp;quot;) ? &amp;quot;\\&amp;quot; : &amp;quot;/&amp;quot;);&amp;#xD;&amp;#xA;        String cmdPrefix        = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;        int commCellId = 2;&amp;#xD;&amp;#xA;        if(xpath:{/workflow/CommServDBQuery_15/resultSets[1]/rowCount} &amp;gt; 0)&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            commCellId = xpath:{/workflow/CommServDBQuery_15/resultSets[1]/row[1]/col[1]};&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        int azureMode = 1;&amp;#xD;&amp;#xA;        if(1 ==  xpath:{/workflow/inputs/recall_mode_azure})&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            azureMode = 3;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;        String cmdPrefix     = &amp;quot; -vm \&amp;quot;&amp;quot; + mountPath.getAttributeValue(&amp;quot;MediaAgentInstance&amp;quot;) + &amp;quot;\&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;                cmdPrefix   += &amp;quot; -cc &amp;quot; +  Integer.toString(commCellId);&amp;#xD;&amp;#xA;                cmdPrefix   += &amp;quot; -amazon_d &amp;quot; + Integer.toString(xpath:{/workflow/inputs/recall_period});&amp;#xD;&amp;#xA;                cmdPrefix   += &amp;quot; -amazon_c &amp;quot; +  Integer.toString(xpath:{/workflow/inputs/recall_mode});&amp;#xD;&amp;#xA;                cmdPrefix   += &amp;quot; -o \&amp;quot;&amp;quot; + mountPath.getAttributeValue(&amp;quot;MediaAgentTemp&amp;quot;) + &amp;quot;\&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;                        &amp;#xD;&amp;#xA;        if(0 != xpath:{/workflow/variables/iRetryInterval})&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;                cmdPrefix += &amp;quot; -sleep &amp;quot; + Integer.toString(xpath:{/workflow/variables/iRetryInterval});&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        else if(3 == azureMode)&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;                cmdPrefix += &amp;quot; -sleep 20&amp;quot;;&amp;#xD;&amp;#xA;        }                &amp;#xD;&amp;#xA;        if(1 == xpath:{/workflow/ProcessBlock_23/iIndexFree})&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;                cmdPrefix += &amp;quot; -indexfree 1&amp;quot;;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        Element chunks = mountPath.getChild(&amp;quot;Chunks&amp;quot;);&amp;#xD;&amp;#xA;        for(Element chunk : chunks.getChildren())&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            ++iTrackChunkCount;&amp;#xD;&amp;#xA;            &amp;#xD;&amp;#xA;            if(53 == Integer.parseInt(mountPath.getAttributeValue(&amp;quot;Vendor&amp;quot;) /*Glacier*/))&amp;#xD;&amp;#xA;            {&amp;#xD;&amp;#xA;                sFileData += &amp;quot; &amp;quot; + chunk.getAttributeValue(&amp;quot;Cclip&amp;quot;);&amp;#xD;&amp;#xA;            }&amp;#xD;&amp;#xA;            else&amp;#xD;&amp;#xA;            {&amp;#xD;&amp;#xA;                if(iTrackVolId != Integer.parseInt(chunk.getAttributeValue(&amp;quot;VolumeId&amp;quot;)))&amp;#xD;&amp;#xA;                {&amp;#xD;&amp;#xA;                    sFileData += &amp;quot; V_&amp;quot; + chunk.getAttributeValue(&amp;quot;VolumeId&amp;quot;) + &amp;quot; &amp;quot; + chunk.getAttributeValue(&amp;quot;IsDeduped&amp;quot;);&amp;#xD;&amp;#xA;                    iTrackVolId = Integer.parseInt(chunk.getAttributeValue(&amp;quot;VolumeId&amp;quot;));&amp;#xD;&amp;#xA;                    iTrackAfId = 0;&amp;#xD;&amp;#xA;                }&amp;#xD;&amp;#xA;                &amp;#xD;&amp;#xA;                if(iTrackAfId != Integer.parseInt(chunk.getAttributeValue(&amp;quot;ArchFileId&amp;quot;)))&amp;#xD;&amp;#xA;                {&amp;#xD;&amp;#xA;                    sFileData += &amp;quot; &amp;quot; + chunk.getAttributeValue(&amp;quot;ArchFileId&amp;quot;);&amp;#xD;&amp;#xA;                    iTrackAfId = Integer.parseInt(chunk.getAttributeValue(&amp;quot;ArchFileId&amp;quot;));&amp;#xD;&amp;#xA;                }&amp;#xD;&amp;#xA;                &amp;#xD;&amp;#xA;                sFileData += &amp;quot;,&amp;quot; + chunk.getAttributeValue(&amp;quot;Chunk&amp;quot;) + &amp;quot;(&amp;quot; + chunk.getAttributeValue(&amp;quot;Offset&amp;quot;) + &amp;quot;)&amp;quot;;&amp;#xD;&amp;#xA;            }&amp;#xD;&amp;#xA;                &amp;#xD;&amp;#xA;            if((iFileNumber &amp;lt; iNumFiles &amp;amp;&amp;amp; iTrackChunkCount &amp;gt;= (iChunksPerFile * iFileNumber))&amp;#xD;&amp;#xA;                || (iFileNumber == iNumFiles &amp;amp;&amp;amp; iTrackChunkCount == Integer.parseInt(mountPath.getAttributeValue(&amp;quot;ChunkCount&amp;quot;))))&amp;#xD;&amp;#xA;            { &amp;#xD;&amp;#xA;                dataList.add(sFileData);&amp;#xD;&amp;#xA;                &amp;#xD;&amp;#xA;                //write all contents to file&amp;#xD;&amp;#xA;                String sFileName = sFileNamePrefix + Integer.toString(iFileNumber) + &amp;quot;.txt&amp;quot;;&amp;#xD;&amp;#xA;                String sFileFullName = sFilePath + sFileName;&amp;#xD;&amp;#xA;                &amp;#xD;&amp;#xA;                boolean overWrite = true;&amp;#xD;&amp;#xA;                for(String fileData : dataList)&amp;#xD;&amp;#xA;                {   &amp;#xD;&amp;#xA;                    String cmd, arg;&amp;#xD;&amp;#xA;                    &amp;#xD;&amp;#xA;                    String writeMethod = (overWrite ? &amp;quot;&amp;gt;&amp;quot; : &amp;quot;&amp;gt;&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;                    overWrite = false; //only first write to overwrite                   &amp;#xD;&amp;#xA;                    &amp;#xD;&amp;#xA;                    if(mountPath.getAttributeValue(&amp;quot;MediaAgentOs&amp;quot;).toLowerCase().contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;                    {&amp;#xD;&amp;#xA;                        if(53 == Integer.parseInt(mountPath.getAttributeValue(&amp;quot;Vendor&amp;quot;) /*Glacier*/))&amp;#xD;&amp;#xA;                        {&amp;#xD;&amp;#xA;                            cmd = &amp;quot;echo&amp;quot;;&amp;#xD;&amp;#xA;                            arg = fileData + &amp;quot; &amp;quot; + writeMethod + &amp;quot; \&amp;quot;&amp;quot; +  sFileFullName + &amp;quot;\&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;                        }&amp;#xD;&amp;#xA;                        else&amp;#xD;&amp;#xA;                        {&amp;#xD;&amp;#xA;                            cmd = &amp;quot;if&amp;quot;;&amp;#xD;&amp;#xA;                            arg = &amp;quot;1==1 echo | set /P var=\&amp;quot;&amp;quot; + fileData + &amp;quot;\&amp;quot; &amp;quot; + writeMethod + &amp;quot; \&amp;quot;&amp;quot; + sFileFullName + &amp;quot;\&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;                        }&amp;#xD;&amp;#xA;                    }&amp;#xD;&amp;#xA;                    else&amp;#xD;&amp;#xA;                    {&amp;#xD;&amp;#xA;                        cmd = &amp;quot;echo&amp;quot;;&amp;#xD;&amp;#xA;                        arg = &amp;quot;-n \&amp;quot;&amp;quot; + fileData + &amp;quot;\&amp;quot; &amp;quot; + writeMethod + &amp;quot; \&amp;quot;&amp;quot; + sFileFullName + &amp;quot;\&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;                    }&amp;#xD;&amp;#xA;                    &amp;#xD;&amp;#xA;                    Element execCmd = new Element(&amp;quot;App_ExecuteCommandReq&amp;quot;);&amp;#xD;&amp;#xA;                    Document docInner = new Document(execCmd);&amp;#xD;&amp;#xA;                    execCmd.setAttribute(&amp;quot;arguments&amp;quot;, arg);&amp;#xD;&amp;#xA;                    execCmd.setAttribute(&amp;quot;command&amp;quot;, cmd);&amp;#xD;&amp;#xA;                    execCmd.setAttribute(&amp;quot;startupPath&amp;quot;, mountPath.getAttributeValue(&amp;quot;MediaAgentTemp&amp;quot;));&amp;#xD;&amp;#xA;                    execCmd.setAttribute(&amp;quot;waitForProcessCompletion&amp;quot;, &amp;quot;1&amp;quot;);&amp;#xD;&amp;#xA;                    &amp;#xD;&amp;#xA;                    Element client = new Element(&amp;quot;client&amp;quot;);&amp;#xD;&amp;#xA;                    client.setAttribute(&amp;quot;_type_&amp;quot;, &amp;quot;3&amp;quot;);&amp;#xD;&amp;#xA;                    client.setAttribute(&amp;quot;clientName&amp;quot;, mountPath.getAttributeValue(&amp;quot;MediaAgentName&amp;quot;));&amp;#xD;&amp;#xA;                    client.setAttribute(&amp;quot;hostName&amp;quot;, xpath:{/workflow/system/commCellHost}.toString());&amp;#xD;&amp;#xA;                    execCmd.addContent(client);&amp;#xD;&amp;#xA;                    &amp;#xD;&amp;#xA;                    OperationExecute exec = new OperationExecute();&amp;#xD;&amp;#xA;                    exec.inputXml = new XMLOutputter().outputString(docInner);&amp;#xD;&amp;#xA;                    exec.commandArgs = &amp;quot; -tk &amp;quot; + workflow.getCurrentUserToken();&amp;#xD;&amp;#xA;                    exec.execute(workflow);&amp;#xD;&amp;#xA;                    execOutput = exec.outputXml;&amp;#xD;&amp;#xA;                }&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;                dataList.clear();&amp;#xD;&amp;#xA;                sFileData = mountPath.getAttributeValue(&amp;quot;MountPathId&amp;quot;) + &amp;quot; &amp;quot; + mountPath.getAttributeValue(&amp;quot;Vendor&amp;quot;);&amp;#xD;&amp;#xA;                iTrackVolId = iTrackAfId = 0;&amp;#xD;&amp;#xA;                                        &amp;#xD;&amp;#xA;                //If not restore job, this is the end of a command&amp;#xD;&amp;#xA;                if(!bIsRestore&amp;#xD;&amp;#xA;                    || (bIsRestore &amp;amp;&amp;amp; recallCommands.getChildren().size() == 0))&amp;#xD;&amp;#xA;                {                        &amp;#xD;&amp;#xA;                    Element recallCommand = new Element(&amp;quot;recallCommand&amp;quot;);&amp;#xD;&amp;#xA;                    recallCommand.setAttribute(&amp;quot;clientName&amp;quot;         , mountPath.getAttributeValue(&amp;quot;MediaAgentName&amp;quot;));&amp;#xD;&amp;#xA;                    recallCommand.setAttribute(&amp;quot;clientBase&amp;quot;         , mountPath.getAttributeValue(&amp;quot;MediaAgentBase&amp;quot;));&amp;#xD;&amp;#xA;                    recallCommand.setAttribute(&amp;quot;clientTemp&amp;quot;         , mountPath.getAttributeValue(&amp;quot;MediaAgentTemp&amp;quot;));&amp;#xD;&amp;#xA;                    recallCommand.setAttribute(&amp;quot;mode&amp;quot;               , sCloudMode);&amp;#xD;&amp;#xA;                    recallCommand.setAttribute(&amp;quot;mountPathName&amp;quot;      , mountPath.getAttributeValue(&amp;quot;MountPathName&amp;quot;));&amp;#xD;&amp;#xA;                    recallCommand.setAttribute(&amp;quot;mountPathId&amp;quot;        , mountPath.getAttributeValue(&amp;quot;MountPathId&amp;quot;));&amp;#xD;&amp;#xA;                    recallCommand.setAttribute(&amp;quot;clientOs&amp;quot;           , mountPath.getAttributeValue(&amp;quot;MediaAgentOs&amp;quot;).toLowerCase());&amp;#xD;&amp;#xA;                    recallCommand.setAttribute(&amp;quot;rowNumber&amp;quot;          , Integer.toString(iCommandNumber));                            &amp;#xD;&amp;#xA;                    recallCommand.setAttribute(&amp;quot;inputFiles&amp;quot;         , &amp;quot; -i \&amp;quot;&amp;quot; + sFileFullName + &amp;quot;\&amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;                    recallCommand.setAttribute(&amp;quot;azureMode&amp;quot;          , Integer.toString(azureMode));&amp;#xD;&amp;#xA;                    recallCommand.setAttribute(&amp;quot;processIdentifier&amp;quot;  , sFileName);&amp;#xD;&amp;#xA;                    &amp;#xD;&amp;#xA;                    if(!bIsRestore)&amp;#xD;&amp;#xA;                    {&amp;#xD;&amp;#xA;                        recallCommand.setAttribute(&amp;quot;cmd&amp;quot;                , cmdPrefix + &amp;quot; -lj &amp;quot; + sWorkflowJid + Integer.toString(iCommandNumber));&amp;#xD;&amp;#xA;                        recallCommand.setAttribute(&amp;quot;logJobId&amp;quot;           , sWorkflowJid + Integer.toString(iCommandNumber));&amp;#xD;&amp;#xA;                        ++iCommandNumber;&amp;#xD;&amp;#xA;                    }&amp;#xD;&amp;#xA;                    else&amp;#xD;&amp;#xA;                    {&amp;#xD;&amp;#xA;                        recallCommand.setAttribute(&amp;quot;cmd&amp;quot;                , cmdPrefix + &amp;quot; -lj &amp;quot; + sWorkflowJid);&amp;#xD;&amp;#xA;                        recallCommand.setAttribute(&amp;quot;logJobId&amp;quot;           , sWorkflowJid);&amp;#xD;&amp;#xA;                    }&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;                    recallCommands.addContent(recallCommand);&amp;#xD;&amp;#xA;                }&amp;#xD;&amp;#xA;                else&amp;#xD;&amp;#xA;                {&amp;#xD;&amp;#xA;                    Element recallCommand = recallCommands.getChild(&amp;quot;recallCommand&amp;quot;);&amp;#xD;&amp;#xA;                    String inputFiles = recallCommand.getAttributeValue(&amp;quot;inputFiles&amp;quot;);&amp;#xD;&amp;#xA;                    inputFiles += &amp;quot; -i \&amp;quot;&amp;quot; + sFileFullName + &amp;quot;\&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;                    recallCommand.setAttribute(&amp;quot;inputFiles&amp;quot;, inputFiles);    &amp;#xD;&amp;#xA;                }                        &amp;#xD;&amp;#xA;                &amp;#xD;&amp;#xA;                ++iFileNumber;&amp;#xD;&amp;#xA;            }&amp;#xD;&amp;#xA;            else if(0 == iTrackChunkCount % iChunksPerWrite)&amp;#xD;&amp;#xA;            {&amp;#xD;&amp;#xA;                dataList.add(sFileData);&amp;#xD;&amp;#xA;                sFileData = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;            }&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    returnDoc = new Document(recallCommands);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;sRecallCommandInfo&amp;quot;, new XMLOutputter().outputString(returnDoc));&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Error generating recall command. Exception: &amp;quot; + e);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_17" commented="0" description="" originalStyle="" points="" sourceX="478" sourceY="127" status="0" style="defaultEdge" targetX="992" targetY="120" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1576467311094" description="creates a super process group" displayName="Recall Files" height="1368" interactive="0" jobMode="0" name="ProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#BEE0B8;gradientColor=#BEE0B8" uniqueName="ProcessBlock_24" waitSetting="0" width="3446" x="13" y="4759">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs className="" defaultValue="" listType="0" name="outputs" type="" />

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1576467311094" description="" displayName="Start" height="29" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_28" waitSetting="0" width="66" x="86" y="384">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="EnableLogging_17" commented="0" description="" originalStyle="" points="" sourceX="51" sourceY="282" status="0" style="defaultEdge" targetX="166" targetY="282" transitionIndex="0" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1576461598330" description="iterates a group of activities over a list of xml nodes" displayName="For Each Recall Command" height="1294" interactive="0" jobMode="0" name="ForEachXml" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#E0E085;gradientColor=#E0E085" uniqueName="ForEachXml_2" waitSetting="0" width="3006" x="249" y="44">

        <inputs val="&lt;inputs&gt;&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/sRecallCommandInfo}&lt;/xml&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;/recallCommands/recallCommand&lt;/xpath&gt;&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;10&lt;/numberOfParallelExecutions&gt;&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/continueOnFailure&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_18" commented="0" description="" originalStyle="" points="" sourceX="723" sourceY="282" status="0" style="defaultEdge" targetX="1307" targetY="275" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <superProcess>

          <Start commented="0" continueOnFailure="0" created="1576461598330" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_27" waitSetting="0" width="58" x="24" y="118">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="XPathMultiQuery_2" commented="0" description="" originalStyle="" points="" sourceX="53" sourceY="77" status="0" style="defaultEdge" targetX="193" targetY="77" transitionIndex="0" x="-445" y="-2950">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Start>

          <Activity commented="0" continueOnFailure="0" created="1576466054568" description="retrieves a list of values from xml" displayName="Extract Xml Data" height="34" interactive="0" jobMode="0" name="XPathMultiQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.MultiXPathActivity" uniqueName="XPathMultiQuery_2" waitSetting="0" width="125" x="133" y="56">

            <activitySchema>

              <outputs name="outputs">

                <children listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children listType="0" name="clientBase" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children listType="0" name="rowNumber" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children listType="0" name="cmd" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children listType="0" name="azureMode" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children listType="0" name="mode" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children listType="0" name="mountPathName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children listType="0" name="clientOs" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children listType="0" name="clientTemp" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children listType="0" name="processIdentifier" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children listType="0" name="mountPathId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children listType="0" name="inputFiles" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children listType="0" name="logJobId" type="{http://www.w3.org/2001/XMLSchema}string" />

              </outputs>

            </activitySchema>

            <inputs val="&lt;inputs&gt;&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ForEachXml_2/values}&lt;/xml&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;clientName&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@clientName&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;clientBase&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@clientBase&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;rowNumber&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@rowNumber&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;Integer&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;cmd&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@cmd&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;azureMode&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@azureMode&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;mode&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@mode&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;mountPathName&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@mountPathName&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;clientOs&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@clientOs&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;clientTemp&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@clientTemp&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;processIdentifier&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@processIdentifier&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;mountPathId&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@mountPathId&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;Integer&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;inputFiles&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@inputFiles&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;logJobId&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@logJobId&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;/inputs&gt;" />

            <transition activity="Decision_21" commented="0" description="" originalStyle="" points="" sourceX="195" sourceY="73" status="0" style="defaultEdge" targetX="199" targetY="193" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1576466288501" description="activity to execute code snippets in the selected language" displayName="Wait" height="32" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_33" waitSetting="0" width="56" x="168" y="344">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;int duration = (1 + (60 * (xpath:{/workflow/XPathMultiQuery_2/rowNumber} - 1)));&amp;#xD;&amp;#xA;String sleep = &amp;quot;127.0.0.1 -n &amp;quot; + Integer.toString(duration) + &amp;quot; &amp;gt; nul&amp;quot;;&amp;#xD;&amp;#xA;return sleep;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="EnableLogging_32" commented="0" description="" originalStyle="" points="" sourceX="196" sourceY="479" status="0" style="defaultEdge" targetX="290" targetY="479" transitionIndex="0" x="-560" y="-2548">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1576466348855" description="Execute a command on a remote machine" displayName="Wait" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_8" waitSetting="0" width="56" x="167" y="516">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;hostName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;displayName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;commCellName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;csGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;type class=&quot;commvault.msgs.CvEntities.CommCellType&quot; _list_=&quot;false&quot; /&gt;&lt;flags class=&quot;commvault.msgs.CvEntities.EntityFlags&quot; _list_=&quot;false&quot; /&gt;&lt;GUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;newName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;ping&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_33/output}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_95" commented="0" description="" originalStyle="" points="" sourceX="193" sourceY="383" status="0" style="defaultEdge" targetX="322" targetY="383" transitionIndex="0" x="-657" y="-2644">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1576466385402" description="Execute a command on a remote machine" displayName="Recalling Files" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_9" waitSetting="0" width="111" x="731" y="516">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientName}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_95/output}&lt;/startUpPath&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_94/output}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_47/output}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Decision_30" commented="0" description="" displayName="Get PID" originalStyle="" points="" sourceX="786" sourceY="567" status="0" style="defaultEdge" targetX="908" targetY="506" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1576699656121" description="activity to execute code snippets in the selected language" displayName="Recalling Files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_47" waitSetting="0" width="111" x="416" y="516">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;String cmd = xpath:{/workflow/XPathMultiQuery_2/cmd};&amp;#xD;&amp;#xA;cmd += &amp;quot; -azure_c &amp;quot; + xpath:{/workflow/XPathMultiQuery_2/azureMode} + &amp;quot; -mode &amp;quot; + xpath:{/workflow/XPathMultiQuery_2/mode} + &amp;quot; &amp;quot; + xpath:{/workflow/XPathMultiQuery_2/inputFiles};&amp;#xD;&amp;#xA;return cmd.replace(&amp;quot;&amp;amp;quot;&amp;quot;, &amp;quot;\&amp;quot;&amp;quot;);&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_94" commented="0" description="" originalStyle="" points="" sourceX="311" sourceY="383" status="0" style="defaultEdge" targetX="441" targetY="391" transitionIndex="0" x="-212" y="306">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1576734557082" description="activity to execute code snippets in the selected language" displayName="Checking Recall Success" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_53" waitSetting="0" width="174" x="1233" y="729">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/ExecuteCommand_25/commandOutput}.trim().contains(&amp;quot;true&amp;quot;))&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Recall successful for command [&amp;quot; + xpath:{/workflow/Script_94/output} + &amp;quot; &amp;quot; + xpath:{/workflow/Script_47/output} + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;logger.info(&amp;quot;Recall failed for command [&amp;quot; + xpath:{/workflow/Script_94/output} + &amp;quot; &amp;quot; + xpath:{/workflow/Script_47/output} + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;return false;&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Decision_29" commented="0" description="" originalStyle="" points="" sourceX="1320" sourceY="746" status="0" style="defaultEdge" targetX="852" targetY="812" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1582836893458" description="activity to execute code snippets in the selected language" displayName="Recalling Files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity;fillColor=#CCCCCC;gradientColor=#CCCCCC" uniqueName="Script_94" waitSetting="0" width="111" x="581" y="516">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String os = xpath:{/workflow/XPathMultiQuery_2/clientOs};    &amp;#xD;&amp;#xA;    String cmd = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(os.contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;        cmd = &amp;quot;CloudChunkRecall.exe&amp;quot;;        &amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;        cmd = xpath:{/workflow/XPathMultiQuery_2/clientBase} + &amp;quot;/CloudChunkRecall&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;Running [&amp;quot; + xpath:{/workflow/XPathMultiQuery_2/clientName} + &amp;quot;] &amp;quot; + cmd + &amp;quot; &amp;quot; + xpath:{/workflow/Script_47/output});&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String sThreadRetry = &amp;quot;iThreadRetry&amp;quot; + Integer.toString(xpath:{/workflow/XPathMultiQuery_2/rowNumber});&amp;#xD;&amp;#xA;    workflow.setVariable(sThreadRetry, 1);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String sCommandRetry = &amp;quot;iCommandRetry&amp;quot; + Integer.toString(xpath:{/workflow/XPathMultiQuery_2/rowNumber});&amp;#xD;&amp;#xA;    workflow.setVariable(sCommandRetry, 1);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    return cmd;    &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to generate command to recall files. Exception &amp;quot; + e);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Decision_32" commented="0" description="" displayName="Running PIDs" originalStyle="" points="" sourceX="636" sourceY="533" status="0" style="defaultEdge" targetX="640" targetY="466" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1582837143380" description="activity to execute code snippets in the selected language" displayName="Recalling Files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_95" waitSetting="0" width="111" x="268" y="516">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String os = xpath:{/workflow/XPathMultiQuery_2/clientOs};    &amp;#xD;&amp;#xA;    String cmd = xpath:{/workflow/XPathMultiQuery_2/clientBase};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(os.contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;        return cmd;     &amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to generate command to recall files. Exception &amp;quot; + e);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_47" commented="0" description="" originalStyle="" points="" sourceX="312" sourceY="395" status="0" style="defaultEdge" targetX="441" targetY="437" transitionIndex="0" x="-212" y="306">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583184921941" description="if/else based decision" displayName="Restore" height="58" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_21" waitSetting="0" width="75" x="156" y="181">

            <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;1001 == xpath:{/workflow/variables/iJobOption} || 1005 == xpath:{/workflow/variables/iJobOption}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

            <transition activity="Decision_23" commented="0" description="" originalStyle="" points="" sourceX="193" sourceY="210" status="0" style="defaultEdge" targetX="317" targetY="211" transitionIndex="0" value="true" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

            <transition activity="Script_33" commented="0" description="" originalStyle="" points="" sourceX="193" sourceY="210" status="0" style="defaultEdge" targetX="174" targetY="298" transitionIndex="0" value="false" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583185577211" description="if/else based decision" displayName="OS" height="52" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_22" waitSetting="0" width="56" x="832" y="184">

            <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&quot;windows&quot;)&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

            <transition activity="Script_96" commented="0" description="" displayName="Windows" originalStyle="" points="" sourceX="860" sourceY="210" status="0" style="defaultEdge" targetX="980" targetY="157" transitionIndex="0" value="true" x="-95" y="-4112">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

            <transition activity="ExecuteCommand_20" commented="0" description="" displayName="Unix" originalStyle="" points="" sourceX="485" sourceY="247" status="0" style="defaultEdge" targetX="631" targetY="269" transitionIndex="0" value="false" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1583186883704" description="Execute a command on a remote machine" displayName="ExecuteCommand" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_19" waitSetting="0" width="134" x="1076" y="141">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientName}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Reg&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Query &quot;HKLM\SOFTWARE\CommVault Systems\Galaxy\xpath:{/workflow/CommServDBQuery_48/resultSets[1]/row[1]/col[1]}\MediaAgent&quot; /v OrigMPId /s | findstr &quot;xpath:{/workflow/Script_96/output}&quot;&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_98" commented="0" description="" originalStyle="" points="" sourceX="1143" sourceY="158" status="0" style="defaultEdge" targetX="1289" targetY="167" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583187320878" description="activity to execute code snippets in the selected language" displayName="Script" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_96" waitSetting="0" width="100" x="940" y="141">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;int mpId = xpath:{/workflow/XPathMultiQuery_2/mountPathId};&amp;#xD;&amp;#xA;return &amp;quot;0x&amp;quot; + Integer.toHexString(mpId);&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_19" commented="0" description="" originalStyle="" points="" sourceX="704" sourceY="151" status="0" style="defaultEdge" targetX="827" targetY="153" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583188181608" description="executes queries against a commcell database" displayName="Get MA Instance" height="35" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_48" waitSetting="0" width="122" x="533" y="193">

            <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;select distinct attrVal&amp;#xD;&#xD;&#xA;from APP_ClientProp(nolock) cp&amp;#xD;&#xD;&#xA;join APP_Client(nolock) c on c.id = cp.componentNameId&amp;#xD;&#xD;&#xA;where c.name = ''xpath:{/workflow/XPathMultiQuery_2/clientName}'' &amp;#xD;&#xD;&#xA;    and cp.attrName = ''Galaxy Instance name'' &amp;#xD;&#xD;&#xA;    and CP.modified = 0&lt;/query&gt;&lt;/inputs&gt;" />

            <transition activity="EnableLogging_30" commented="0" description="" originalStyle="" points="" sourceX="594" sourceY="210" status="0" style="defaultEdge" targetX="750" targetY="215" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583188228170" description="if/else based decision" displayName="Debug" height="54" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_23" waitSetting="0" width="66" x="286" y="183">

            <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;1 == xpath:{/workflow/variables/iDebugMode}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

            <transition activity="DisableLogging_46" commented="0" description="" originalStyle="" points="" sourceX="319" sourceY="210" status="0" style="defaultEdge" targetX="417" targetY="213" transitionIndex="0" value="false" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

            <transition activity="CommServDBQuery_48" commented="0" description="" displayName="Enabled" originalStyle="" points="456.0,165.0" sourceX="319" sourceY="210" status="0" style="defaultEdge" targetX="622" targetY="207" transitionIndex="0" value="true" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583188251436" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_46" waitSetting="0" width="117" x="383" y="193">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="CommServDBQuery_48" commented="0" description="" originalStyle="" points="" sourceX="441" sourceY="210" status="0" style="defaultEdge" targetX="588" targetY="156" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583188382726" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_30" waitSetting="0" width="113" x="684" y="193">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="Decision_22" commented="0" description="" originalStyle="" points="" sourceX="740" sourceY="210" status="0" style="defaultEdge" targetX="956" targetY="246" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583251841319" description="activity to execute code snippets in the selected language" displayName="Script" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_98" waitSetting="0" width="100" x="1251" y="141">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;String result = xpath:{/workflow/ExecuteCommand_19/commandOutput};&amp;#xD;&amp;#xA;String mpId = xpath:{/workflow/Script_96/output};&amp;#xD;&amp;#xA;if(result.contains(mpId))&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;return false;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="WorkflowEnd_11" commented="0" description="" originalStyle="" points="" sourceX="1301" sourceY="158" status="0" style="defaultEdge" targetX="1435" targetY="156" transitionIndex="0" x="0" y="0">

              <condition language="1" script="false == xpath:{/workflow/Script_98/output}" />

            </transition>

            <transition activity="Decision_25" commented="0" description="" originalStyle="" points="" sourceX="1301" sourceY="158" status="0" style="defaultEdge" targetX="413" targetY="350" transitionIndex="0" x="0" y="0">

              <condition language="1" script="true == xpath:{/workflow/Script_98/output}" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1583260663622" description="Execute a command on a remote machine" displayName="ExecuteCommand" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_20" waitSetting="0" width="134" x="941" y="233">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientName}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;grep&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;-rw &quot;OrigMPId xpath:{/workflow/XPathMultiQuery_2/mountPathId}&quot; /etc/CommVaultRegistry/Galaxy/xpath:{/workflow/CommServDBQuery_48/resultSets[1]/row[1]/col[1]}/MediaAgent | wc -l&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_99" commented="0" description="" originalStyle="" points="" sourceX="1008" sourceY="250" status="0" style="defaultEdge" targetX="1151" targetY="254" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583261730833" description="activity to execute code snippets in the selected language" displayName="Script" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_99" waitSetting="0" width="100" x="1111" y="233">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;String result = xpath:{/workflow/ExecuteCommand_20/commandOutput};&amp;#xD;&amp;#xA;logger.info(&amp;quot;[&amp;quot; + result.trim() + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;if(result.trim().equals(&amp;quot;0&amp;quot;))&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;return true;    &amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="WorkflowEnd_11" commented="0" description="" originalStyle="" points="" sourceX="1161" sourceY="250" status="0" style="defaultEdge" targetX="1293" targetY="96" transitionIndex="0" x="0" y="0">

              <condition language="1" script="false == xpath:{/workflow/Script_99/output}" />

            </transition>

            <transition activity="Decision_25" commented="0" description="" originalStyle="" points="1298.0,278.0" sourceX="1161" sourceY="250" status="0" style="defaultEdge" targetX="472" targetY="354" transitionIndex="0" x="0" y="0">

              <condition language="1" script="true == xpath:{/workflow/Script_99/output}" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583264106226" description="Ends the workflow" displayName="WorkflowEnd (OS)" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_11" waitSetting="0" width="134" x="1240" y="79">

            <onEnter language="1" script="logger.info(&quot;Reason: Registry missing mountpath information. Share MediaAgent [&quot; + xpath:{/workflow/XPathMultiQuery_2/clientName} + &quot;] with mountpath &quot; + xpath:{/workflow/XPathMultiQuery_2/mountPathName}); " />

            <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Failure Reason: Registry missing mountpath information. Share MediaAgent [xpath:{/workflow/XPathMultiQuery_2/clientName}] with mountpath xpath:{/workflow/XPathMultiQuery_2/mountPathName} &lt;/failureMessage&gt;&lt;/inputs&gt;" />

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583264145317" description="executes a defined process block within the workflow" displayName="Checking if data recall is required" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#BEE0B8;gradientColor=#BEE0B8" uniqueName="ExecuteProcessBlock_68" waitSetting="0" width="224" x="1410" y="284">

            <activitySchema>

              <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

              <outputs name="ProcessBlock_31">

                <children name="Start_41" />

                <children name="Job_2" type="">

                  <children className="workflow.types.cmd.JobDetails" inputType="workflow.types.cmd.JobDetails" listType="1" name="job" type="{workflow.types.cmd}JobDetails">

                    <children className="java.lang.Integer" inputType="java.lang.Integer" name="jobId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                    <children className="java.lang.String" inputType="java.lang.String" name="jobType" type="{http://www.w3.org/2001/XMLSchema}string" />

                    <children className="java.lang.String" inputType="java.lang.String" name="status" type="{http://www.w3.org/2001/XMLSchema}string" />

                    <children className="java.lang.String" inputType="java.lang.String" name="phase" type="{http://www.w3.org/2001/XMLSchema}string" />

                  </children>

                  <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children name="Script_100">

                  <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

                <children name="EnableLogging_31" />

                <children name="DisableLogging_47" />

              </outputs>

            </activitySchema>

            <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;processBlock&gt;ProcessBlock_31&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

            <transition activity="EnableLogging_36" commented="0" description="" originalStyle="" points="" sourceX="1300" sourceY="401" status="0" style="defaultEdge" targetX="1460" targetY="338" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583265258410" description="executes queries against a commcell database" displayName="Put restore job in waiting" height="35" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_49" waitSetting="0" width="171" x="419" y="386">

            <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @displaystate int;&amp;#xD;&#xD;&#xA;select @displaystate = displaystate&amp;#xD;&#xD;&#xA;from JMJobInfo(READUNCOMMITTED)&amp;#xD;&#xD;&#xA;where jobid = xpath:{/workflow/variables/iJobId};&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @failurereason varchar(max) = ''xpath:{/workflow/CommServDBQuery_49/resultSets/row[1]/col[1]}'';&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if(@displaystate = 5 /*Suspended*/)&amp;#xD;&#xD;&#xA;begin&amp;#xD;&#xD;&#xA;    update JMJobInfo set displaystate = 3, failurereason = @failurereason where jobid = xpath:{/workflow/variables/iJobId};&amp;#xD;&#xD;&#xA;    select 5, @displaystate&amp;#xD;&#xD;&#xA;end&amp;#xD;&#xD;&#xA;else if(@displaystate = 7)&amp;#xD;&#xD;&#xA;begin&amp;#xD;&#xD;&#xA;    select 7, @displaystate&amp;#xD;&#xD;&#xA;end&amp;#xD;&#xD;&#xA;else&amp;#xD;&#xD;&#xA;    select 0, @displaystate&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&lt;/query&gt;&lt;/inputs&gt;" />

            <transition activity="Script_116" commented="0" description="" originalStyle="" points="" sourceX="504" sourceY="403" status="0" style="defaultEdge" targetX="374" targetY="406" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583267435087" description="activity to execute code snippets in the selected language" displayName="Checking Recall Success" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_106" waitSetting="0" width="174" x="1692" y="597">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    return &amp;quot;if&amp;quot;;&amp;#xD;&amp;#xA;return &amp;quot;true&amp;quot;;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_107" commented="0" description="" originalStyle="" points="1788.0,696.0" sourceX="1055" sourceY="544" status="0" style="defaultEdge" targetX="861" targetY="546" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583267600988" description="activity to execute code snippets in the selected language" displayName="Checking Recall Success" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_107" waitSetting="0" width="174" x="1701" y="729">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;String file = &amp;quot;CloudChunk_&amp;quot; + xpath:{/workflow/XPathMultiQuery_2/logJobId} + &amp;quot;_Result.txt&amp;quot;;&amp;#xD;&amp;#xA;if(xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    return &amp;quot;exist \&amp;quot;&amp;quot; + file + &amp;quot;\&amp;quot; (echo true) else (echo false)&amp;quot;;&amp;#xD;&amp;#xA;return &amp;quot;&amp;amp;&amp;amp; [ -f &amp;quot; + xpath:{/workflow/XPathMultiQuery_2/clientTemp} + &amp;quot;/&amp;quot; + file + &amp;quot; ] &amp;amp;&amp;amp; echo \&amp;quot;true\&amp;quot; || echo \&amp;quot;false\&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_25" commented="0" description="" originalStyle="" points="" sourceX="846" sourceY="544" status="0" style="defaultEdge" targetX="710" targetY="544" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1583270602361" description="Execute a command on a remote machine" displayName="Checking Recall Success" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_25" waitSetting="0" width="174" x="1467" y="729">

            <onExit language="1" script="workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientName}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientTemp}&lt;/startUpPath&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_106/output}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_107/output}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_53" commented="0" description="" originalStyle="" points="" sourceX="666" sourceY="544" status="0" style="defaultEdge" targetX="584" targetY="642" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583270749703" description="activity to execute code snippets in the selected language" displayName="Check if Azure data archival is required" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_108" waitSetting="0" width="255" x="995" y="895">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    return &amp;quot;dir&amp;quot;;&amp;#xD;&amp;#xA;return &amp;quot;find&amp;quot;;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_109" commented="0" description="" originalStyle="" points="" sourceX="304" sourceY="632" status="0" style="defaultEdge" targetX="619" targetY="652" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583270981205" description="activity to execute code snippets in the selected language" displayName="Check if Azure data archival is required" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_109" waitSetting="0" width="255" x="1286" y="895">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String file = &amp;quot;CloudChunk_&amp;quot; + xpath:{/workflow/XPathMultiQuery_2/logJobId} + &amp;quot;_OP_&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;        return &amp;quot;/b /a-d | find \&amp;quot;&amp;quot; + file + &amp;quot;\&amp;quot; || ver&amp;gt;nul&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    return &amp;quot;\&amp;quot;&amp;quot; + xpath:{/workflow/XPathMultiQuery_2/clientTemp} + &amp;quot;/\&amp;quot; -type f -exec basename {} .po \\; | grep \&amp;quot;&amp;quot; + file + &amp;quot;\&amp;quot; || true&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to generate command to archive files. Exception &amp;quot; + e);&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_26" commented="0" description="" originalStyle="" points="" sourceX="789" sourceY="510" status="0" style="defaultEdge" targetX="1080" targetY="540" transitionIndex="0" x="187" y="-122">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583271413764" description="Execute a command on a remote machine" displayName="Check if Azure data archival is required" height="34" interactive="0" jobMode="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_26" waitSetting="0" width="271" x="1576" y="895">

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientName}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientTemp}&lt;/startUpPath&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_108/output}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_109/output}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_110" commented="0" description="" originalStyle="" points="" sourceX="1091" sourceY="510" status="0" style="defaultEdge" targetX="1369" targetY="501" transitionIndex="0" x="187" y="-122">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583271475247" description="activity to execute code snippets in the selected language" displayName="Check if Azure data archival is required" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_110" waitSetting="0" width="255" x="1575" y="983">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String op = xpath:{/workflow/ExecuteCommand_26/commandOutput}.trim();&amp;#xD;&amp;#xA;    String[] lines = op.split(&amp;quot;\\n&amp;quot;);&amp;#xD;&amp;#xA;    String input_file = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    String prefix = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    if(xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;        prefix = xpath:{/workflow/XPathMultiQuery_2/clientTemp} + &amp;quot;\\&amp;quot;; &amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;        prefix = xpath:{/workflow/XPathMultiQuery_2/clientTemp} + &amp;quot;/&amp;quot;;&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;    for(String line:lines)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        if(!line.trim().isEmpty())&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            input_file += &amp;quot; -i \&amp;quot;&amp;quot; + prefix + line.trim() + &amp;quot;\&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(input_file.trim().isEmpty())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;No Azure files requiring archiving found for the recall. Completing Workflow Job&amp;quot;);&amp;#xD;&amp;#xA;        return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;Azure files requiring archiving found for the recall. Proceeding with archival.&amp;quot;);&amp;#xD;&amp;#xA;    String cmd = xpath:{/workflow/XPathMultiQuery_2/cmd};&amp;#xD;&amp;#xA;    cmd += &amp;quot; -azure_c 2 -mode 3&amp;quot; + input_file;&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Running [&amp;quot; + xpath:{/workflow/XPathMultiQuery_2/clientName} + &amp;quot;] &amp;quot; + xpath:{/workflow/Script_94/output} + &amp;quot; &amp;quot; + cmd);&amp;#xD;&amp;#xA;    return cmd.replace(&amp;quot;&amp;amp;quot;&amp;quot;, &amp;quot;\&amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to generate command to archive files. Exception &amp;quot; + e);&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Decision_34" commented="0" description="" originalStyle="" points="" sourceX="1193" sourceY="632" status="0" style="defaultEdge" targetX="1414" targetY="634" transitionIndex="0" x="0" y="0">

              <condition language="1" script="!xpath:{/workflow/Script_110/output}.isEmpty()" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1583273788942" description="Execute a command on a remote machine" displayName="Archiving Azure files" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_27" waitSetting="0" width="149" x="734" y="983">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientName}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_95/output}&lt;/startUpPath&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_94/output}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_110/output}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Decision_33" commented="0" description="" displayName="Get PID" originalStyle="" points="" sourceX="808" sourceY="1000" status="0" style="defaultEdge" targetX="812" targetY="1085" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583273993719" description="activity to execute code snippets in the selected language" displayName="Archiving Azure files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_112" waitSetting="0" width="146" x="1096" y="1151">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;String sThreadRetry = &amp;quot;iThreadRetry&amp;quot; + Integer.toString(xpath:{/workflow/XPathMultiQuery_2/rowNumber});&amp;#xD;&amp;#xA;workflow.setVariable(sThreadRetry, 1);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String file = &amp;quot;CloudChunk_&amp;quot; + xpath:{/workflow/XPathMultiQuery_2/logJobId} + &amp;quot;_OP_&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    return &amp;quot;path win32_process get ProcessID,commandline /format:csv | findstr \&amp;quot;&amp;quot; + file + &amp;quot;\&amp;quot; | findstr \&amp;quot;CloudChunkRecall\&amp;quot; | findstr /V cmd.exe&amp;quot;;&amp;#xD;&amp;#xA;return &amp;quot;-ef | grep \&amp;quot;&amp;quot; + file + &amp;quot;\&amp;quot; | grep CloudChunkRecall | awk ''{print $2}'' | head -1&amp;quot;;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_39" commented="0" description="" originalStyle="" points="" sourceX="1169" sourceY="1168" status="0" style="defaultEdge" targetX="1356" targetY="1169" transitionIndex="0" x="356" y="84">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583275425523" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_32" waitSetting="0" width="113" x="141" y="434">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="ExecuteCommand_8" commented="0" description="" originalStyle="" points="" sourceX="284" sourceY="417" status="0" style="defaultEdge" targetX="188" targetY="476" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583441164222" description="executes a defined process block within the workflow" displayName="Waiting for restore job completion" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess" uniqueName="ExecuteProcessBlock_69" waitSetting="0" width="200" x="33" y="895">

            <activitySchema>

              <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

              <outputs name="ProcessBlock_14">

                <children name="Start_15" />

                <children name="Script_20">

                  <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

                <children name="EnableLogging_14" />

                <children name="DisableLogging_15" />

                <children name="ExecuteProcessBlock_67">

                  <children name="Start_41" />

                  <children name="Job_2" type="">

                    <children className="workflow.types.cmd.JobDetails" inputType="workflow.types.cmd.JobDetails" listType="1" name="job" type="{workflow.types.cmd}JobDetails">

                      <children className="java.lang.Integer" inputType="java.lang.Integer" name="jobId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                      <children className="java.lang.String" inputType="java.lang.String" name="jobType" type="{http://www.w3.org/2001/XMLSchema}string" />

                      <children className="java.lang.String" inputType="java.lang.String" name="status" type="{http://www.w3.org/2001/XMLSchema}string" />

                      <children className="java.lang.String" inputType="java.lang.String" name="phase" type="{http://www.w3.org/2001/XMLSchema}string" />

                    </children>

                    <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

                    <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

                  </children>

                  <children name="Script_100">

                    <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                  </children>

                  <children name="EnableLogging_31" />

                  <children name="DisableLogging_47" />

                </children>

              </outputs>

            </activitySchema>

            <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;processBlock&gt;ProcessBlock_14&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_30" commented="0" description="" originalStyle="" points="208.0,974.0" sourceX="203" sourceY="618" status="0" style="defaultEdge" targetX="194" targetY="671" transitionIndex="0" x="0" y="0">

              <condition language="1" script="xpath:{/workflow/ExecuteProcessBlock_69/Script_20/output}" />

            </transition>

            <transition activity="EnableLogging_35" commented="0" description="" originalStyle="" points="" sourceX="203" sourceY="618" status="0" style="defaultEdge" targetX="366" targetY="615" transitionIndex="0" x="0" y="0">

              <condition language="1" script="!xpath:{/workflow/ExecuteProcessBlock_69/Script_20/output}" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583441309340" description="executes queries against a commcell database" displayName="Resume Restore Job" height="35" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_50" waitSetting="0" width="149" x="480" y="729">

            <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @displaystate int;&amp;#xD;&#xD;&#xA;select @displaystate = displaystate&amp;#xD;&#xD;&#xA;from JMJobInfo(READUNCOMMITTED)&amp;#xD;&#xD;&#xA;where jobid = xpath:{/workflow/variables/iJobId};&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if(@displaystate = 3)&amp;#xD;&#xD;&#xA;begin&amp;#xD;&#xD;&#xA;    update JMJobInfo set displaystate = 5 where jobid = xpath:{/workflow/variables/iJobId};&amp;#xD;&#xD;&#xA;    select 1&amp;#xD;&#xD;&#xA;end&amp;#xD;&#xD;&#xA;else if(@displaystate = 5)&amp;#xD;&#xD;&#xA;begin&amp;#xD;&#xD;&#xA;    select 5&amp;#xD;&#xD;&#xA;end&amp;#xD;&#xD;&#xA;else&amp;#xD;&#xD;&#xA;    select 0&lt;/query&gt;&lt;/inputs&gt;" />

            <transition activity="Script_131" commented="0" description="" originalStyle="" points="" sourceX="292" sourceY="544" status="0" style="defaultEdge" targetX="147" targetY="543" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583441461812" description="Execute a command on a remote machine" displayName="Waiting for restore job completion" height="34" interactive="0" jobMode="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_30" waitSetting="0" width="200" x="40" y="1005">

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;hostName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;displayName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;commCellName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;csGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;type class=&quot;commvault.msgs.CvEntities.CommCellType&quot; _list_=&quot;false&quot; /&gt;&lt;flags class=&quot;commvault.msgs.CvEntities.EntityFlags&quot; _list_=&quot;false&quot; /&gt;&lt;GUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;newName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;ping&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;127.0.0.1 -n 61 &amp;gt; nul&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteProcessBlock_69" commented="0" description="" originalStyle="" points="68.0,976.0" sourceX="208" sourceY="684" status="0" style="defaultEdge" targetX="199" targetY="622" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1583772898133" description="executes a defined process block within the workflow" displayName="Check if Azure data archival is required" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess" uniqueName="ExecuteProcessBlock_71" waitSetting="0" width="276" x="448" y="895">

            <activitySchema>

              <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

              <outputs name="ProcessBlock_31">

                <children name="Start_41" />

                <children name="Job_2" type="">

                  <children className="workflow.types.cmd.JobDetails" inputType="workflow.types.cmd.JobDetails" listType="1" name="job" type="{workflow.types.cmd}JobDetails">

                    <children className="java.lang.Integer" inputType="java.lang.Integer" name="jobId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                    <children className="java.lang.String" inputType="java.lang.String" name="jobType" type="{http://www.w3.org/2001/XMLSchema}string" />

                    <children className="java.lang.String" inputType="java.lang.String" name="status" type="{http://www.w3.org/2001/XMLSchema}string" />

                    <children className="java.lang.String" inputType="java.lang.String" name="phase" type="{http://www.w3.org/2001/XMLSchema}string" />

                  </children>

                  <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children name="Script_100">

                  <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

                <children name="EnableLogging_31" />

                <children name="DisableLogging_47" />

              </outputs>

            </activitySchema>

            <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;processBlock&gt;ProcessBlock_31&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

            <transition activity="EnableLogging_33" commented="0" description="" originalStyle="" points="" sourceX="454" sourceY="618" status="0" style="defaultEdge" targetX="641" targetY="618" transitionIndex="0" x="0" y="0">

              <condition language="1" script="String status = xpath:{/workflow/ExecuteProcessBlock_71/Script_100/output};&#xD;&#xA;logger.info(&quot;JID [&quot; + Integer.toString(xpath:{/workflow/variables/iJobId}) + &quot;] completed with State [&quot; + status + &quot;].&quot;);&#xD;&#xA;if(status.toLowerCase().contains(&quot;completed&quot;))&#xD;&#xA;    return true;&#xD;&#xA;return false;" />

            </transition>

            <transition activity="WorkflowEnd_12" commented="0" description="" originalStyle="" points="" sourceX="483" sourceY="693" status="0" style="defaultEdge" targetX="504" targetY="777" transitionIndex="0" x="0" y="0">

              <condition language="1" script="String status = xpath:{/workflow/ExecuteProcessBlock_71/Script_100/output};&#xA;logger.info(&quot;JID [&quot; + Integer.toString(xpath:{/workflow/variables/iJobId}) + &quot;] completed with State [&quot; + status + &quot;].&quot;);&#xA;if(status.toLowerCase().contains(&quot;completed&quot;))&#xA;    return false;&#xA;return true;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583773241186" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_12" waitSetting="0" width="106" x="541" y="967">

            <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;COMPLETED_WITH_ERRORS&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Failure Reason: Recall completed but restore job failed. Check log for more information.&lt;/failureMessage&gt;&lt;/inputs&gt;" />

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583779403138" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_33" waitSetting="0" width="113" x="762" y="895">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="Script_108" commented="0" description="" displayName="Move back selected" originalStyle="" points="" sourceX="578" sourceY="690" status="0" style="defaultEdge" targetX="655" targetY="630" transitionIndex="0" x="0" y="0">

              <condition language="1" script="xpath:{/workflow/inputs/move_back_data}" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1583862874811" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_35" waitSetting="0" width="113" x="269" y="894">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="ExecuteProcessBlock_71" commented="0" description="" originalStyle="" points="" sourceX="313" sourceY="681" status="0" style="defaultEdge" targetX="370" targetY="612" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584587335385" description="if/else based decision" displayName="Skip Job &#xA;Status" height="74" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_25" waitSetting="0" width="82" x="1258" y="265">

            <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;1==xpath:{/workflow/variables/iSkipJobStatus} || xpath:{/workflow/variables/bRestoreJobFailed}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteProcessBlock_68" commented="0" description="" displayName="No" offsetX="86" offsetY="-4" originalStyle="" points="" sourceX="1299" sourceY="250" status="0" style="defaultEdge" targetX="1302" targetY="344" transitionIndex="0" value="false" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

            <transition activity="Script_33" commented="0" description="" displayName="Yes" offsetX="54" offsetY="-20" originalStyle="" points="200.0,342.0" sourceX="1299" sourceY="250" status="0" style="defaultEdge" targetX="182" targetY="358" transitionIndex="0" value="true" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584587833742" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_13" waitSetting="0" width="106" x="1378" y="329">

            <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Failure Reason: Restore job is not currently running.&lt;/failureMessage&gt;&lt;/inputs&gt;" />

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584588156722" description="activity to execute code snippets in the selected language" displayName="Check Job Status" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_115" waitSetting="0" width="130" x="1176" y="383">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;String status = xpath:{/workflow/ExecuteProcessBlock_68/Script_100/output};&amp;#xD;&amp;#xA;logger.info(&amp;quot;JID [&amp;quot; + Integer.toString(xpath:{/workflow/variables/iJobId}) + &amp;quot;] Current State [&amp;quot; + status + &amp;quot;]&amp;quot;); &amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String sThreadJobStatus = &amp;quot;sThreadJobStatus&amp;quot; + Integer.toString(xpath:{/workflow/XPathMultiQuery_2/rowNumber});&amp;#xD;&amp;#xA;workflow.setVariable(sThreadJobStatus, status);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(status.equals(&amp;quot;Pending&amp;quot;))&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Attempting to suspend restore job&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(status.equals(&amp;quot;Suspend Pending&amp;quot;)) //Just to be safe&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String sThreadJobStatusTimeout = &amp;quot;sThreadJobStatusTimeout&amp;quot; + Integer.toString(xpath:{/workflow/XPathMultiQuery_2/rowNumber});&amp;#xD;&amp;#xA;    workflow.setVariable(sThreadJobStatusTimeout, 0);&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_33" commented="0" description="" displayName="Running/Waiting/Queued/Suspended/Suspend Pending/Interrupt Pending" offsetX="54" offsetY="-22" originalStyle="" points="1098.0,325.0" sourceX="380" sourceY="357" status="0" style="defaultEdge" targetX="192" targetY="540" transitionIndex="0" x="0" y="0">

              <condition language="1" script="String status = xpath:{/workflow/ExecuteProcessBlock_68/Script_100/output};&#xD;&#xA;if(status.equals(&quot;Running&quot;) || status.equals(&quot;Waiting&quot;)|| status.equals(&quot;Queued&quot;)|| status.equals(&quot;Suspended&quot;) || status.equals(&quot;Suspend Pending&quot;) || status.equals(&quot;Interrupt Pending&quot;))&#xD;&#xA;    return true;&#xD;&#xA;return false;" />

            </transition>

            <transition activity="WorkflowEnd_13" commented="0" description="" displayName="Unsupported" originalStyle="" points="" sourceX="1300" sourceY="401" status="0" style="defaultEdge" targetX="1554" targetY="402" transitionIndex="0" x="0" y="0">

              <condition language="1" script="String status = xpath:{/workflow/ExecuteProcessBlock_68/Script_100/output};&#xA;if(status.equals(&quot;Running&quot;) || status.equals(&quot;Waiting&quot;)|| status.equals(&quot;Queued&quot;)|| status.equals(&quot;Suspended&quot;) || status.equals(&quot;Suspend Pending&quot;) || status.equals(&quot;Interrupt Pending&quot;) || status.equals(&quot;Pending&quot;))&#xA;    return false;&#xA;return true;" />

            </transition>

            <transition activity="CommServDBQuery_54" commented="0" description="" displayName="Pending" offsetX="4" offsetY="-2" originalStyle="" points="" sourceX="1162" sourceY="317" status="0" style="defaultEdge" targetX="804" targetY="317" transitionIndex="0" x="0" y="0">

              <condition language="1" script="String status = xpath:{/workflow/ExecuteProcessBlock_68/Script_100/output};&#xA;if(status.equals(&quot;Pending&quot;))&#xA;    return true;&#xA;return false;&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584588512293" description="activity to execute code snippets in the selected language" displayName="Put restore job in waiting" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity;fillColor=#CCCCCC;gradientColor=#CCCCCC" uniqueName="Script_116" waitSetting="0" width="171" x="228" y="387">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/CommServDBQuery_49/resultSets/rowCount} &amp;gt; 0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    int result = xpath:{/workflow/CommServDBQuery_49/resultSets/row[1]/col[1]};    &amp;#xD;&amp;#xA;    int oldState = xpath:{/workflow/CommServDBQuery_49/resultSets/row[1]/col[2]};&amp;#xD;&amp;#xA;    if(5 == result) /*suspended*/&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;JID [&amp;quot; + Integer.toString(xpath:{/workflow/variables/iJobId}) + &amp;quot;] Updated Job Display State from [Suspended] to [Waiting]&amp;quot;);&amp;#xD;&amp;#xA;        String sThreadJobStatus = &amp;quot;sThreadJobStatus&amp;quot; + Integer.toString(xpath:{/workflow/XPathMultiQuery_2/rowNumber});&amp;#xD;&amp;#xA;        workflow.setVariable(sThreadJobStatus, &amp;quot;Waiting&amp;quot;);&amp;#xD;&amp;#xA;        return true;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    else if(7 == result) /*suspend pending*/&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        String sThreadJobStatus = &amp;quot;sThreadJobStatus&amp;quot; + Integer.toString(xpath:{/workflow/XPathMultiQuery_2/rowNumber});&amp;#xD;&amp;#xA;        String sThreadJobStatusTimeout = &amp;quot;sThreadJobStatusTimeout&amp;quot; + Integer.toString(xpath:{/workflow/XPathMultiQuery_2/rowNumber});&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        int maxAttempts = 15; //wait for upto 15 mins for suspend pending&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        String jobStatus = workflow.getVariable(sThreadJobStatus);&amp;#xD;&amp;#xA;        if(!jobStatus.equals(&amp;quot;Suspend Pending&amp;quot;)) &amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            workflow.setVariable(sThreadJobStatusTimeout, 1);&amp;#xD;&amp;#xA;            logger.info(&amp;quot;JID [&amp;quot; + Integer.toString(xpath:{/workflow/variables/iJobId}) + &amp;quot;] Job State is [Suspend Pending]. Waiting until state change/timeout&amp;quot;);&amp;#xD;&amp;#xA;            workflow.setVariable(sThreadJobStatus, &amp;quot;Suspend Pending&amp;quot;);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        else&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            int attempts = workflow.getVariable(sThreadJobStatusTimeout);&amp;#xD;&amp;#xA;            if(attempts &amp;gt; 15)&amp;#xD;&amp;#xA;            {&amp;#xD;&amp;#xA;                logger.info(&amp;quot;JID [&amp;quot; + Integer.toString(xpath:{/workflow/variables/iJobId}) + &amp;quot;] Job State is still in [Suspend Pending] and wait timeout has reached. Moving ahead with data recall&amp;quot;);&amp;#xD;&amp;#xA;                return true;&amp;#xD;&amp;#xA;            }&amp;#xD;&amp;#xA;            workflow.setVariable(sThreadJobStatusTimeout, ++attempts);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        return false;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;JID [&amp;quot; + Integer.toString(xpath:{/workflow/variables/iJobId}) + &amp;quot;] Job State not updated as current State is not [Suspended]. Current State # [&amp;quot; + Integer.toString(oldState) + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Unable to determine job state&amp;quot;);&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_33" commented="0" description="" originalStyle="" points="212.0,404.0" sourceX="540" sourceY="404" status="0" style="defaultEdge" targetX="210" targetY="364" transitionIndex="0" x="0" y="0">

              <condition language="1" script="true == xpath:{/workflow/Script_116/output}" />

            </transition>

            <transition activity="ExecuteCommand_52" commented="0" description="" originalStyle="" points="" sourceX="313" sourceY="404" status="0" style="defaultEdge" targetX="440" targetY="473" transitionIndex="0" x="0" y="0">

              <condition language="1" script="false == xpath:{/workflow/Script_116/output}" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1584591388726" description="Execute a command on a remote machine" displayName="Recalling Files" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_31" waitSetting="0" width="111" x="1226" y="517">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientName}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_127/output}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_128/output}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_117" commented="0" description="" originalStyle="" points="" sourceX="1281" sourceY="534" status="0" style="defaultEdge" targetX="1427" targetY="534" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584591710522" description="activity to execute code snippets in the selected language" displayName="Recalling Files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity;fillColor=#CCCCCC;gradientColor=#CCCCCC" uniqueName="Script_117" waitSetting="0" width="111" x="1372" y="517">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;import java.util.regex.Matcher;&amp;#xD;&amp;#xA;import java.util.regex.Pattern;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;int iMaxRetryCount = 3;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String sThreadRetry = &amp;quot;iThreadRetry&amp;quot; + Integer.toString(xpath:{/workflow/XPathMultiQuery_2/rowNumber});&amp;#xD;&amp;#xA;int iThreadRetry = workflow.getVariable(sThreadRetry);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{  &amp;#xD;&amp;#xA;    if(xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&amp;quot;windows&amp;quot;) &amp;amp;&amp;amp; (xpath:{/workflow/ExecuteCommand_31/exitCode} != 0 || xpath:{/workflow/ExecuteCommand_31/errorCode} != 0))&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        List oldPids = xpath:{/workflow/Script_145/output};&amp;#xD;&amp;#xA;        List newPids = xpath:{/workflow/Script_144/output};&amp;#xD;&amp;#xA;        newPids.removeAll(oldPids);&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        if(newPids.size() &amp;gt; 0)&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            String candidate = Integer.toString(newPids.get(0));&amp;#xD;&amp;#xA;            if(1 == iThreadRetry) &amp;#xD;&amp;#xA;                logger.info(&amp;quot;Candidate recall process &amp;quot; + newPids.toString());&amp;#xD;&amp;#xA;            return candidate;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        else &amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            if(1 == iThreadRetry)&amp;#xD;&amp;#xA;                logger.info(&amp;quot;No candidate recall processes.&amp;quot;);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(iThreadRetry &amp;gt; iMaxRetryCount)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Recall process seems to have completed. Checking for output file to determine command status&amp;quot;);&amp;#xD;&amp;#xA;        workflow.setVariable(sThreadRetry,1);&amp;#xD;&amp;#xA;        return &amp;quot;Failed&amp;quot;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String op = xpath:{/workflow/ExecuteCommand_31/commandOutput};&amp;#xD;&amp;#xA;    if(0 != xpath:{/workflow/ExecuteCommand_31/errorCode} || 0 != xpath:{/workflow/ExecuteCommand_31/exitCode} || op.isEmpty())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Recall process seems to have completed. Checking again. Attempt &amp;quot; + Integer.toString(iThreadRetry) + &amp;quot;/&amp;quot; + Integer.toString(iMaxRetryCount));&amp;#xD;&amp;#xA;        workflow.setVariable(sThreadRetry,++iThreadRetry);&amp;#xD;&amp;#xA;        return &amp;quot;Retry&amp;quot;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        String[] vals = op.split(&amp;quot;,&amp;quot;);&amp;#xD;&amp;#xA;        if(vals.length &amp;lt; 3)&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            logger.info(&amp;quot;Recall process seems to have completed. Checking again. Attempt &amp;quot; + Integer.toString(iThreadRetry) + &amp;quot;/&amp;quot; + Integer.toString(iMaxRetryCount));&amp;#xD;&amp;#xA;            workflow.setVariable(sThreadRetry,++iThreadRetry);&amp;#xD;&amp;#xA;            return &amp;quot;Retry&amp;quot;;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        Pattern p = Pattern.compile(&amp;quot;([0-9]+.*)&amp;quot;);&amp;#xD;&amp;#xA;        Matcher m = p.matcher(vals[2]);&amp;#xD;&amp;#xA;        if(!m.find())&amp;#xD;&amp;#xA;        {  &amp;#xD;&amp;#xA;            logger.info(&amp;quot;Recall process seems to have completed. Checking again. Attempt &amp;quot; + Integer.toString(iThreadRetry) + &amp;quot;/&amp;quot; + Integer.toString(iMaxRetryCount));&amp;#xD;&amp;#xA;            workflow.setVariable(sThreadRetry,++iThreadRetry);&amp;#xD;&amp;#xA;            return &amp;quot;Retry&amp;quot;;&amp;#xD;&amp;#xA;        }   &amp;#xD;&amp;#xA;        op = m.group(1);&amp;#xD;&amp;#xA;    } &amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    workflow.setVariable(sThreadRetry,1);&amp;#xD;&amp;#xA;    op = op.trim();&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Process ID [&amp;quot; + op + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    return op.trim();&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Recall process seems to have completed. Checking again. Attempt &amp;quot; + Integer.toString(iThreadRetry) + &amp;quot;/&amp;quot; + Integer.toString(iMaxRetryCount));&amp;#xD;&amp;#xA;    workflow.setVariable(sThreadRetry,++iThreadRetry);&amp;#xD;&amp;#xA;    return &amp;quot;Retry&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA; &quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_33" commented="0" description="" displayName="Retry" offsetX="0" offsetY="8" originalStyle="" points="" sourceX="1197" sourceY="512" status="0" style="defaultEdge" targetX="1195" targetY="449" transitionIndex="0" x="0" y="0">

              <condition language="1" script="xpath:{/workflow/Script_117/output}.equals(&quot;Retry&quot;)" />

            </transition>

            <transition activity="Script_106" commented="0" description="" originalStyle="" points="1426.0,582.0" sourceX="1273" sourceY="512" status="0" style="defaultEdge" targetX="1111" targetY="837" transitionIndex="0" x="0" y="0">

              <condition language="1" script="xpath:{/workflow/Script_117/output}.equals(&quot;Failed&quot;)" />

            </transition>

            <transition activity="Script_129" commented="0" description="" displayName="Monitor PID" originalStyle="" points="" sourceX="1273" sourceY="512" status="0" style="defaultEdge" targetX="1682" targetY="519" transitionIndex="0" x="0" y="0">

              <condition language="1" script="!xpath:{/workflow/Script_117/output}.equals(&quot;Retry&quot;) &amp;&amp; !xpath:{/workflow/Script_117/output}.equals(&quot;Failed&quot;)" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1584592698700" description="Execute a command on a remote machine" displayName="Recalling Files" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_33" waitSetting="0" width="111" x="1371" y="440">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;hostName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;displayName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;commCellName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;csGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;type class=&quot;commvault.msgs.CvEntities.CommCellType&quot; _list_=&quot;false&quot; /&gt;&lt;flags class=&quot;commvault.msgs.CvEntities.EntityFlags&quot; _list_=&quot;false&quot; /&gt;&lt;GUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;newName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;ping&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;127.0.0.1 -n 21 &amp;gt; nul&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_31" commented="0" description="" originalStyle="" points="1281.0,484.0" sourceX="1196" sourceY="457" status="0" style="defaultEdge" targetX="1075" targetY="519" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1584626025653" description="Execute a command on a remote machine" displayName="Recalling Files" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_35" waitSetting="0" width="111" x="1894" y="515">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientName}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_129/output}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_130/output}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_119" commented="0" description="" originalStyle="" points="" sourceX="2003" sourceY="510" status="0" style="defaultEdge" targetX="2202" targetY="514" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584626703675" description="activity to execute code snippets in the selected language" displayName="Recalling Files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity;fillColor=#CCCCCC;gradientColor=#CCCCCC" uniqueName="Script_119" waitSetting="0" width="111" x="2054" y="515">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;int iMaxRetryCount = 3;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;String sThreadRetry = &amp;quot;iThreadRetry&amp;quot; + Integer.toString(xpath:{/workflow/XPathMultiQuery_2/rowNumber});&amp;#xD;&amp;#xA;int iThreadRetry = workflow.getVariable(sThreadRetry);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    if(iThreadRetry &amp;gt; iMaxRetryCount)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Recall process with PID [&amp;quot; + xpath:{/workflow/Script_117/output} + &amp;quot;] seems to have completed. Checking for output file to determine recall status&amp;quot;);&amp;#xD;&amp;#xA;        return &amp;quot;Failed&amp;quot;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String op = xpath:{/workflow/ExecuteCommand_35/commandOutput};&amp;#xD;&amp;#xA;    if(0 != xpath:{/workflow/ExecuteCommand_35/errorCode} || 0 != xpath:{/workflow/ExecuteCommand_35/exitCode} || op.isEmpty() || !op.trim().toLowerCase().contains(&amp;quot;cloudchunkrecal&amp;quot;))&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Recall process with PID [&amp;quot; + xpath:{/workflow/Script_117/output} + &amp;quot;] seems to have completed. Checking again. Attempt &amp;quot; + Integer.toString(iThreadRetry) + &amp;quot;/&amp;quot; + Integer.toString(iMaxRetryCount));&amp;#xD;&amp;#xA;        workflow.setVariable(sThreadRetry,++iThreadRetry);&amp;#xD;&amp;#xA;        return &amp;quot;Retry&amp;quot;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    //reset retry count on success&amp;#xD;&amp;#xA;    workflow.setVariable(sThreadRetry,1);&amp;#xD;&amp;#xA;    return &amp;quot;Success&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Recall process with PID [&amp;quot; + xpath:{/workflow/Script_117/output} + &amp;quot;] seems to have completed. Checking again. Attempt &amp;quot; + Integer.toString(iThreadRetry) + &amp;quot;/&amp;quot; + Integer.toString(iMaxRetryCount));&amp;#xD;&amp;#xA;    workflow.setVariable(sThreadRetry,++iThreadRetry);&amp;#xD;&amp;#xA;    return &amp;quot;Retry&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA; &quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_38" commented="0" description="" displayName="Retry" offsetX="0" offsetY="6" originalStyle="" points="" sourceX="2163" sourceY="510" status="0" style="defaultEdge" targetX="2173" targetY="445" transitionIndex="0" x="0" y="0">

              <condition language="1" script="xpath:{/workflow/Script_119/output}.equals(&quot;Retry&quot;)" />

            </transition>

            <transition activity="Decision_28" commented="0" description="" originalStyle="" points="" sourceX="2163" sourceY="510" status="0" style="defaultEdge" targetX="2301" targetY="510" transitionIndex="0" x="0" y="0">

              <condition language="1" script="xpath:{/workflow/Script_119/output}.equals(&quot;Success&quot;)" />

            </transition>

            <transition activity="Script_106" commented="0" description="" originalStyle="" points="2112.0,588.0" sourceX="1649" sourceY="534" status="0" style="defaultEdge" targetX="1333" targetY="845" transitionIndex="0" x="0" y="0">

              <condition language="1" script="xpath:{/workflow/Script_119/output}.equals(&quot;Failed&quot;)" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1584628912470" description="Execute a command on a remote machine" displayName="Recalling Files" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_36" waitSetting="0" width="111" x="2051" y="436">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;hostName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;displayName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;commCellName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;csGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;type class=&quot;commvault.msgs.CvEntities.CommCellType&quot; _list_=&quot;false&quot; /&gt;&lt;flags class=&quot;commvault.msgs.CvEntities.EntityFlags&quot; _list_=&quot;false&quot; /&gt;&lt;GUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;newName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;ping&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;127.0.0.1 -n 301 &amp;gt; nul&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_35" commented="0" description="" originalStyle="" points="1952.0,509.0" sourceX="2160" sourceY="445" status="0" style="defaultEdge" targetX="2025" targetY="514" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584629148709" description="if/else based decision" displayName="Restore" height="58" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_28" waitSetting="0" width="75" x="2214" y="503">

            <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;1!=xpath:{/workflow/variables/iSkipJobStatus} &amp;amp;&amp;amp; (1001 == xpath:{/workflow/variables/iJobOption} || 1005 == xpath:{/workflow/variables/iJobOption}) &amp;amp;&amp;amp; !xpath:{/workflow/variables/bRestoreJobFailed}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteProcessBlock_72" commented="0" description="" displayName="Yes" originalStyle="" points="" sourceX="2251" sourceY="532" status="0" style="defaultEdge" targetX="2406" targetY="532" transitionIndex="0" value="true" x="514" y="-2">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

            <transition activity="ExecuteCommand_36" commented="0" description="" displayName="No" offsetX="0" offsetY="-17" originalStyle="" points="2252.0,453.0" sourceX="2305" sourceY="510" status="0" style="defaultEdge" targetX="2173" targetY="434" transitionIndex="0" value="false" x="-1" y="-4">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1584629969107" description="executes a defined process block within the workflow" displayName="Recalling Files" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#BEE0B8;gradientColor=#BEE0B8" uniqueName="ExecuteProcessBlock_72" waitSetting="0" width="111" x="2496" y="515">

            <activitySchema>

              <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

              <outputs name="ProcessBlock_31">

                <children name="Start_41" />

                <children name="Job_2" type="">

                  <children className="workflow.types.cmd.JobDetails" inputType="workflow.types.cmd.JobDetails" listType="1" name="job" type="{workflow.types.cmd}JobDetails">

                    <children className="java.lang.Integer" inputType="java.lang.Integer" name="jobId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                    <children className="java.lang.String" inputType="java.lang.String" name="jobType" type="{http://www.w3.org/2001/XMLSchema}string" />

                    <children className="java.lang.String" inputType="java.lang.String" name="status" type="{http://www.w3.org/2001/XMLSchema}string" />

                    <children className="java.lang.String" inputType="java.lang.String" name="phase" type="{http://www.w3.org/2001/XMLSchema}string" />

                  </children>

                  <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children name="Script_100">

                  <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

                <children name="EnableLogging_31" />

                <children name="DisableLogging_47" />

              </outputs>

            </activitySchema>

            <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;processBlock&gt;ProcessBlock_31&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_137" commented="0" description="" originalStyle="" points="" sourceX="2551" sourceY="532" status="0" style="defaultEdge" targetX="2528" targetY="472" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1584630245922" description="executes queries against a commcell database" displayName="Put restore job in waiting" height="37" interactive="0" jobMode="0" maxRestarts="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_53" waitSetting="0" width="171" x="2703" y="538">

            <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @displaystate int;&amp;#xD;&#xD;&#xA;select @displaystate = displaystate&amp;#xD;&#xD;&#xA;from JMJobInfo(READUNCOMMITTED)&amp;#xD;&#xD;&#xA;where jobid = xpath:{/workflow/variables/iJobId};&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @failurereason varchar(max) = ''xpath:{/workflow/CommServDBQuery_55/resultSets/row[1]/col[1]}'';&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if(@displaystate = 5 /*Suspended*/)&amp;#xD;&#xD;&#xA;begin&amp;#xD;&#xD;&#xA;    update JMJobInfo set displaystate = 3, failurereason = @failurereason where jobid = xpath:{/workflow/variables/iJobId};&amp;#xD;&#xD;&#xA;    select 5, @displaystate&amp;#xD;&#xD;&#xA;end&amp;#xD;&#xD;&#xA;else if(@displaystate = 7)&amp;#xD;&#xD;&#xA;begin&amp;#xD;&#xD;&#xA;    select 7, @displaystate&amp;#xD;&#xD;&#xA;end&amp;#xD;&#xD;&#xA;else&amp;#xD;&#xD;&#xA;    select 0, @displaystate&amp;#xD;&#xD;&#xA;&lt;/query&gt;&lt;/inputs&gt;" />

            <transition activity="Script_121" commented="0" description="" originalStyle="" points="" sourceX="2840" sourceY="532" status="0" style="defaultEdge" targetX="2839" targetY="440" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584630523757" description="activity to execute code snippets in the selected language" displayName="Put restore job in waiting" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity;fillColor=#CCCCCC;gradientColor=#CCCCCC" uniqueName="Script_121" waitSetting="0" width="171" x="2698" y="431">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/CommServDBQuery_53/resultSets/rowCount} &amp;gt; 0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    int result = xpath:{/workflow/CommServDBQuery_53/resultSets/row[1]/col[1]};&amp;#xD;&amp;#xA;    int oldState = xpath:{/workflow/CommServDBQuery_53/resultSets/row[1]/col[2]};&amp;#xD;&amp;#xA;    if(5 == result) /*Suspended*/&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;JID [&amp;quot; + Integer.toString(xpath:{/workflow/variables/iJobId}) + &amp;quot;] Updated Job Display State from [Suspended] to [Waiting]&amp;quot;);&amp;#xD;&amp;#xA;        String sThreadJobStatus = &amp;quot;sThreadJobStatus&amp;quot; + Integer.toString(xpath:{/workflow/XPathMultiQuery_2/rowNumber});&amp;#xD;&amp;#xA;        workflow.setVariable(sThreadJobStatus, &amp;quot;Waiting&amp;quot;);&amp;#xD;&amp;#xA;        return true;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    else if(7 == result) /*Suspend Pending*/&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;JID [&amp;quot; + Integer.toString(xpath:{/workflow/variables/iJobId}) + &amp;quot;] Job State is [Suspend Pending]. Will attempt putting job in [Waiting] State later&amp;quot;);&amp;#xD;&amp;#xA;        return true;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    logger.info(&amp;quot;JID [&amp;quot; + Integer.toString(xpath:{/workflow/variables/iJobId}) + &amp;quot;] Job State not updated as current State is not [Suspended]. Current State # [&amp;quot; + Integer.toString(oldState) + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Unable to determine job state&amp;quot;);&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="EnableLogging_37" commented="0" description="" originalStyle="" points="2774.0,408.0" sourceX="2837" sourceY="448" status="0" style="defaultEdge" targetX="2145" targetY="452" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1584631737413" description="Execute a command on a remote machine" displayName="Recalling Files" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_37" waitSetting="0" width="111" x="2744" y="289">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientName}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_135/output}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_136/output}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584640575083" description="activity to execute code snippets in the selected language" displayName="Recalling Files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_127" waitSetting="0" width="111" x="932" y="517">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    return &amp;quot;wmic&amp;quot;;&amp;#xD;&amp;#xA;return &amp;quot;ps&amp;quot;;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_128" commented="0" description="" originalStyle="" points="" sourceX="987" sourceY="586" status="0" style="defaultEdge" targetX="978" targetY="676" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584641004465" description="activity to execute code snippets in the selected language" displayName="Recalling Files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_128" waitSetting="0" width="111" x="1074" y="517">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    return &amp;quot;path win32_process get ProcessID,commandline /format:csv | findstr \&amp;quot;&amp;quot; + xpath:{/workflow/XPathMultiQuery_2/processIdentifier} + &amp;quot;\&amp;quot; | findstr \&amp;quot;CloudChunkRecall\&amp;quot; | findstr /V cmd.exe&amp;quot;;&amp;#xD;&amp;#xA;return &amp;quot;-ef | grep \&amp;quot;&amp;quot; + xpath:{/workflow/XPathMultiQuery_2/processIdentifier} + &amp;quot;\&amp;quot; | grep CloudChunkRecall | awk ''{print $2}'' | head -1&amp;quot;;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_31" commented="0" description="" originalStyle="" points="" sourceX="1129" sourceY="586" status="0" style="defaultEdge" targetX="1301" targetY="526" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584641502951" description="activity to execute code snippets in the selected language" displayName="Recalling Files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_129" waitSetting="0" width="111" x="1580" y="515">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    return &amp;quot;tasklist&amp;quot;;&amp;#xD;&amp;#xA;return &amp;quot;ps&amp;quot;;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_130" commented="0" description="" originalStyle="" points="" sourceX="1635" sourceY="536" status="0" style="defaultEdge" targetX="1794" targetY="537" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584641580339" description="activity to execute code snippets in the selected language" displayName="Recalling Files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_130" waitSetting="0" width="111" x="1720" y="515">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    return &amp;quot;| findstr &amp;quot; + xpath:{/workflow/Script_117/output};&amp;#xD;&amp;#xA;return &amp;quot;-p &amp;quot; + xpath:{/workflow/Script_117/output} + &amp;quot; -o comm=&amp;quot;;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_35" commented="0" description="" originalStyle="" points="" sourceX="1771" sourceY="536" status="0" style="defaultEdge" targetX="2058" targetY="533" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584644188395" description="activity to execute code snippets in the selected language" displayName="Put restore job in pending" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity;fillColor=#CCCCCC;gradientColor=#CCCCCC" uniqueName="Script_131" waitSetting="0" width="175" x="252" y="729">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/CommServDBQuery_50/resultSets/rowCount} &amp;gt; 0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    int result = xpath:{/workflow/CommServDBQuery_50/resultSets/row[1]/col[1]};&amp;#xD;&amp;#xA;    String sThreadJobStatus = &amp;quot;sThreadJobStatus&amp;quot; + Integer.toString(xpath:{/workflow/XPathMultiQuery_2/rowNumber});    &amp;#xD;&amp;#xA;    if(1 == result)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;JID [&amp;quot; + Integer.toString(xpath:{/workflow/variables/iJobId}) + &amp;quot;] Updated State from [Waiting] to [Suspended]. Attempting Job Resume.&amp;quot;);&amp;#xD;&amp;#xA;        workflow.setVariable(sThreadJobStatus, &amp;quot;Pending&amp;quot;);&amp;#xD;&amp;#xA;        return true;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    else if(5 == result)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;JID [&amp;quot; + Integer.toString(xpath:{/workflow/variables/iJobId}) + &amp;quot;] Job State is [Suspended]. Attempting Job Resume.&amp;quot;);&amp;#xD;&amp;#xA;        workflow.setVariable(sThreadJobStatus, &amp;quot;Pending&amp;quot;);&amp;#xD;&amp;#xA;        return true;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    logger.info(&amp;quot;JID [&amp;quot; + Integer.toString(xpath:{/workflow/variables/iJobId}) + &amp;quot;] Job State not updated as current State not [Waiting]&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Unable to determine job state&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="JobControl_2" commented="0" description="" displayName="Resume" offsetX="-11" offsetY="-17" originalStyle="" points="193.0,702.0" sourceX="329" sourceY="678" status="0" style="defaultEdge" targetX="152" targetY="756" transitionIndex="0" x="0" y="0">

              <condition language="1" script="xpath:{/workflow/Script_131/output}" />

            </transition>

            <transition activity="ExecuteProcessBlock_69" commented="0" description="" originalStyle="" points="213.0,844.0" sourceX="337" sourceY="746" status="0" style="defaultEdge" targetX="187" targetY="914" transitionIndex="0" x="0" y="0">

              <condition language="1" script="!xpath:{/workflow/Script_131/output}" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584647301676" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_36" waitSetting="0" width="113" x="1485" y="382">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="Script_115" commented="0" description="" originalStyle="" points="1382.0,434.0" sourceX="1259" sourceY="431" status="0" style="defaultEdge" targetX="1097" targetY="405" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584672052620" description="if/else based decision" displayName="Success" height="64" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_29" waitSetting="0" width="80" x="992" y="714">

            <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_53/output}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

            <transition activity="Script_132" commented="0" description="" displayName="Success" originalStyle="" points="" sourceX="1032" sourceY="746" status="0" style="defaultEdge" targetX="785" targetY="746" transitionIndex="0" value="true" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

            <transition activity="Script_133" commented="0" description="" displayName="Failed" originalStyle="" points="" sourceX="972" sourceY="794" status="0" style="defaultEdge" targetX="966" targetY="658" transitionIndex="0" value="false" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584672140308" description="activity to execute code snippets in the selected language" displayName="Checking Recall Success" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_132" waitSetting="0" width="174" x="698" y="729">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="CommServDBQuery_50" commented="0" description="" displayName="Restore" offsetX="-212" offsetY="0" originalStyle="" points="" sourceX="455" sourceY="544" status="0" style="defaultEdge" targetX="306" targetY="648" transitionIndex="0" x="0" y="0">

              <condition language="1" script="(1001 == xpath:{/workflow/variables/iJobOption} || 1005 == xpath:{/workflow/variables/iJobOption}) &amp;&amp; !xpath:{/workflow/variables/bRestoreJobFailed}" />

            </transition>

            <transition activity="Execute_6" commented="0" description="" originalStyle="" points="" sourceX="785" sourceY="746" status="0" style="defaultEdge" targetX="872" targetY="841" transitionIndex="0" x="0" y="0">

              <condition language="1" script="xpath:{/workflow/variables/bRestoreJobFailed}" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584672142363" description="activity to execute code snippets in the selected language" displayName="Checking Recall Success" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_133" waitSetting="0" width="174" x="898" y="615">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(1001 == xpath:{/workflow/variables/iJobOption} || 1005 == xpath:{/workflow/variables/iJobOption})&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(xpath:{/workflow/Script_53/output})&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;int iMaxRetryCount = 1;    &amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;String sCommandRetry = &amp;quot;iCommandRetry&amp;quot; + Integer.toString(xpath:{/workflow/XPathMultiQuery_2/rowNumber});&amp;#xD;&amp;#xA;int commandRetry = workflow.getVariable(sCommandRetry);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(commandRetry &amp;gt; iMaxRetryCount)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;logger.info(&amp;quot;Retrying recall. Attempt &amp;quot; + Integer.toString(commandRetry) + &amp;quot;/&amp;quot; + Integer.toString(iMaxRetryCount));&amp;#xD;&amp;#xA;workflow.setVariable(sCommandRetry, ++commandRetry);&amp;#xD;&amp;#xA;return true;     &quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_9" commented="0" description="" displayName="Retry" offsetX="-8" offsetY="46" originalStyle="" points="788.0,608.0" sourceX="966" sourceY="666" status="0" style="defaultEdge" targetX="808" targetY="534" transitionIndex="0" x="0" y="0">

              <condition language="1" script="true == xpath:{/workflow/Script_133/output}" />

            </transition>

            <transition activity="Script_134" commented="0" description="" displayName="Failed" originalStyle="" points="" sourceX="985" sourceY="632" status="0" style="defaultEdge" targetX="1213" targetY="632" transitionIndex="0" x="0" y="0">

              <condition language="1" script="false == xpath:{/workflow/Script_133/output}" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1584729091822" description="Execute a command on a remote machine" displayName="Recalling Files" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_38" waitSetting="0" width="111" x="1879" y="394">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;hostName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;displayName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;commCellName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;csGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;type class=&quot;commvault.msgs.CvEntities.CommCellType&quot; _list_=&quot;false&quot; /&gt;&lt;flags class=&quot;commvault.msgs.CvEntities.EntityFlags&quot; _list_=&quot;false&quot; /&gt;&lt;GUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;newName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;ping&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;127.0.0.1 -n 21 &amp;gt; nul&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_35" commented="0" description="" originalStyle="" points="" sourceX="1934" sourceY="411" status="0" style="defaultEdge" targetX="1947" targetY="534" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584730922594" description="activity to execute code snippets in the selected language" displayName="Checking Recall Success" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_134" waitSetting="0" width="174" x="1146" y="612">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;workflow.setVariable(&amp;quot;bRecallFail&amp;quot;, true);&quot; /&gt;&lt;/inputs&gt;" />

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584731067666" description="activity to execute code snippets in the selected language" displayName="Recalling Files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_135" waitSetting="0" width="111" x="2436" y="289">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    return &amp;quot;taskkill&amp;quot;;&amp;#xD;&amp;#xA;return &amp;quot;kill&amp;quot;;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_136" commented="0" description="" originalStyle="" points="" sourceX="2491" sourceY="306" status="0" style="defaultEdge" targetX="2688" targetY="266" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584731084876" description="activity to execute code snippets in the selected language" displayName="Recalling Files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_136" waitSetting="0" width="111" x="2594" y="289">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    return &amp;quot;/PID &amp;quot; + xpath:{/workflow/Script_117/output} + &amp;quot; /F&amp;quot;;&amp;#xD;&amp;#xA;return &amp;quot;-9 &amp;quot; + xpath:{/workflow/Script_117/output};&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_37" commented="0" description="" originalStyle="" points="" sourceX="2649" sourceY="306" status="0" style="defaultEdge" targetX="2822" targetY="318" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584734292627" description="activity to execute code snippets in the selected language" displayName="Recalling Files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_137" waitSetting="0" width="111" x="2442" y="451">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;String status = xpath:{/workflow/ExecuteProcessBlock_72/Script_100/output};&amp;#xD;&amp;#xA;if(status.equals(&amp;quot;Pending&amp;quot;))&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Attempting to suspend restore job&amp;quot;);&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="EnableLogging_37" commented="0" description="" displayName="Not Killed" offsetX="-46" offsetY="-10" originalStyle="" points="2266.0,432.0" sourceX="2605" sourceY="532" status="0" style="defaultEdge" targetX="2183" targetY="449" transitionIndex="0" x="0" y="0">

              <condition language="1" script="String sThreadJobStatus = &quot;sThreadJobStatus&quot; + Integer.toString(xpath:{/workflow/XPathMultiQuery_2/rowNumber});&#xA;String oldStatus = workflow.getVariable(sThreadJobStatus);&#xA;&#xA;String status = xpath:{/workflow/ExecuteProcessBlock_72/Script_100/output};&#xA;if(status.contains(&quot;Kill&quot;) || status.equals(&quot;Pending&quot;) || status.equals(&quot;Suspended&quot;) || status.isEmpty())&#xA;    return false;&#xA;&#xA;if(!status.equals(oldStatus))&#xA;{&#xA;    logger.info(&quot;Status change detected. JID [&quot; + Integer.toString(xpath:{/workflow/variables/iJobId}) + &quot;] Old State [&quot; + oldStatus + &quot;] Current State [&quot; + status + &quot;]&quot;);&#xA;    workflow.setVariable(sThreadJobStatus, status);&#xA;} &#xA;return true;&#xA;" />

            </transition>

            <transition activity="Script_135" commented="0" description="" displayName="Killed" offsetX="58" offsetY="-10" originalStyle="" points="2520.0,400.0" sourceX="2605" sourceY="532" status="0" style="defaultEdge" targetX="2835" targetY="334" transitionIndex="0" x="0" y="0">

              <condition language="1" script="String status = xpath:{/workflow/ExecuteProcessBlock_72/Script_100/output};&#xA;if(status.contains(&quot;Kill&quot;))&#xA;{&#xA;    logger.info(&quot;Input job is no longer in a running state. Current State [&quot; + status + &quot;]. Stopping recall process.&quot;);&#xA;    String sThreadJobStatus = &quot;sThreadJobStatus&quot; + Integer.toString(xpath:{/workflow/XPathMultiQuery_2/rowNumber});&#xA;    workflow.setVariable(sThreadJobStatus, status);&#xA;    return true;&#xA;}&#xA;return false;" />

            </transition>

            <transition activity="CommServDBQuery_55" commented="0" description="" displayName="Pending" originalStyle="" points="" sourceX="2605" sourceY="532" status="0" style="defaultEdge" targetX="2797" targetY="533" transitionIndex="0" x="0" y="0">

              <condition language="1" script="String status = xpath:{/workflow/ExecuteProcessBlock_72/Script_100/output};&#xA;if(status.equals(&quot;Pending&quot;))&#xA;    return true;&#xA;return false;" />

            </transition>

            <transition activity="CommServDBQuery_57" commented="0" description="" displayName="Suspended" offsetX="-52" offsetY="16" originalStyle="" points="2344.0,432.0" sourceX="2497" sourceY="468" status="0" style="defaultEdge" targetX="2756" targetY="553" transitionIndex="0" x="0" y="0">

              <condition language="1" script="String status = xpath:{/workflow/ExecuteProcessBlock_72/Script_100/output};&#xA;if(status.equals(&quot;Suspended&quot;))&#xA;    return true;&#xA;return false;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1584735449001" description="Execute a command on a remote machine" displayName="Archiving Azure files" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_39" waitSetting="0" width="146" x="1282" y="1151">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientName}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_127/output}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_112/output}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_139" commented="0" description="" originalStyle="" points="" sourceX="1337" sourceY="1168" status="0" style="defaultEdge" targetX="1470" targetY="1169" transitionIndex="0" x="356" y="84">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584735496213" description="activity to execute code snippets in the selected language" displayName="Archiving Azure files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity;fillColor=#CCCCCC;gradientColor=#CCCCCC" uniqueName="Script_139" waitSetting="0" width="146" x="1462" y="1151">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;import java.util.regex.Matcher;&amp;#xD;&amp;#xA;import java.util.regex.Pattern;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;int iMaxRetryCount = 3;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String sThreadRetry = &amp;quot;iThreadRetry&amp;quot; + Integer.toString(xpath:{/workflow/XPathMultiQuery_2/rowNumber});&amp;#xD;&amp;#xA;int iThreadRetry = workflow.getVariable(sThreadRetry);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{  &amp;#xD;&amp;#xA;    if(xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&amp;quot;windows&amp;quot;) &amp;amp;&amp;amp; (xpath:{/workflow/ExecuteCommand_39/exitCode} != 0 || xpath:{/workflow/ExecuteCommand_39/errorCode} != 0))&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        List oldPids = xpath:{/workflow/Script_147/output};&amp;#xD;&amp;#xA;        List newPids = xpath:{/workflow/Script_146/output};&amp;#xD;&amp;#xA;        newPids.removeAll(oldPids);&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        if(newPids.size() &amp;gt; 0)&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            logger.info(&amp;quot;Candidate archive processes &amp;quot; + newPids.toString());&amp;#xD;&amp;#xA;            return Integer.toString(newPids.get(0));&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        else&amp;#xD;&amp;#xA;            logger.info(&amp;quot;No candidate archive processes.&amp;quot;);&amp;#xD;&amp;#xA;           &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    if(iThreadRetry &amp;gt; iMaxRetryCount)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Archiving process seems to have completed. Completing Workflow job.&amp;quot;);&amp;#xD;&amp;#xA;        workflow.setVariable(sThreadRetry,1);&amp;#xD;&amp;#xA;        return &amp;quot;Failed&amp;quot;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String op = xpath:{/workflow/ExecuteCommand_39/commandOutput};&amp;#xD;&amp;#xA;    if(0 != xpath:{/workflow/ExecuteCommand_39/errorCode} || 0 != xpath:{/workflow/ExecuteCommand_39/exitCode} || op.isEmpty())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Archiving process seems to have completed. Checking again. Attempt &amp;quot; + Integer.toString(iThreadRetry) + &amp;quot;/&amp;quot; + Integer.toString(iMaxRetryCount));&amp;#xD;&amp;#xA;        workflow.setVariable(sThreadRetry,++iThreadRetry);&amp;#xD;&amp;#xA;        return &amp;quot;Retry&amp;quot;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        String[] vals = op.split(&amp;quot;,&amp;quot;);&amp;#xD;&amp;#xA;        if(vals.length &amp;lt; 3)&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            logger.info(&amp;quot;Archiving process seems to have completed. Checking again. Attempt &amp;quot; + Integer.toString(iThreadRetry) + &amp;quot;/&amp;quot; + Integer.toString(iMaxRetryCount));&amp;#xD;&amp;#xA;            workflow.setVariable(sThreadRetry,++iThreadRetry);&amp;#xD;&amp;#xA;            return &amp;quot;Retry&amp;quot;;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        Pattern p = Pattern.compile(&amp;quot;([0-9]+.*)&amp;quot;);&amp;#xD;&amp;#xA;        Matcher m = p.matcher(vals[2]);&amp;#xD;&amp;#xA;        if(!m.find())&amp;#xD;&amp;#xA;        {  &amp;#xD;&amp;#xA;            logger.info(&amp;quot;Archiving process seems to have completed. Retrying. Attempt &amp;quot; + Integer.toString(iThreadRetry) + &amp;quot;/&amp;quot; + Integer.toString(iMaxRetryCount));&amp;#xD;&amp;#xA;            workflow.setVariable(sThreadRetry,++iThreadRetry);&amp;#xD;&amp;#xA;            return &amp;quot;Retry&amp;quot;;&amp;#xD;&amp;#xA;        }   &amp;#xD;&amp;#xA;        op = m.group(1);&amp;#xD;&amp;#xA;    } &amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    workflow.setVariable(sThreadRetry,1);&amp;#xD;&amp;#xA;    op = op.trim();&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Archive Process ID [&amp;quot; + op + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    return op.trim();&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Archiving process seems to have completed. Retrying. Attempt &amp;quot; + Integer.toString(iThreadRetry) + &amp;quot;/&amp;quot; + Integer.toString(iMaxRetryCount));&amp;#xD;&amp;#xA;    workflow.setVariable(sThreadRetry,++iThreadRetry);&amp;#xD;&amp;#xA;    return &amp;quot;Retry&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA; &quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_40" commented="0" description="" displayName="Retry" originalStyle="" points="" sourceX="1535" sourceY="1168" status="0" style="defaultEdge" targetX="1532" targetY="1260" transitionIndex="0" x="356" y="84">

              <condition language="1" script="xpath:{/workflow/Script_139/output}.equals(&quot;Retry&quot;)" />

            </transition>

            <transition activity="Script_143" commented="0" description="" displayName="Monitor PID" originalStyle="" points="" sourceX="1535" sourceY="1168" status="0" style="defaultEdge" targetX="1762" targetY="1161" transitionIndex="0" x="356" y="84">

              <condition language="1" script="!xpath:{/workflow/Script_139/output}.equals(&quot;Retry&quot;) &amp;&amp; !xpath:{/workflow/Script_139/output}.equals(&quot;Failed&quot;)" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1584739320405" description="Execute a command on a remote machine" displayName="Archiving Azure files" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_40" waitSetting="0" width="146" x="1465" y="1228">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;hostName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;displayName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;commCellName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;csGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;type class=&quot;commvault.msgs.CvEntities.CommCellType&quot; _list_=&quot;false&quot; /&gt;&lt;flags class=&quot;commvault.msgs.CvEntities.EntityFlags&quot; _list_=&quot;false&quot; /&gt;&lt;GUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;newName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;ping&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;127.0.0.1 -n 21 &amp;gt; nul&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_39" commented="0" description="" originalStyle="" points="1356.0,1222.0" sourceX="1542" sourceY="1249" status="0" style="defaultEdge" targetX="1344" targetY="1174" transitionIndex="0" x="356" y="84">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584739530502" description="activity to execute code snippets in the selected language" displayName="Archiving Azure files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_141" waitSetting="0" width="146" x="1896" y="1149">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    return &amp;quot;| findstr &amp;quot; + xpath:{/workflow/Script_139/output};&amp;#xD;&amp;#xA;return &amp;quot;-p &amp;quot; + xpath:{/workflow/Script_139/output} + &amp;quot; -o comm=&amp;quot;;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_41" commented="0" description="" originalStyle="" points="" sourceX="1769" sourceY="1166" status="0" style="defaultEdge" targetX="1886" targetY="1181" transitionIndex="0" x="356" y="84">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1584739555945" description="Execute a command on a remote machine" displayName="Archiving Azure files" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_41" waitSetting="0" width="146" x="2080" y="1149">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientName}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_143/output}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_141/output}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_142" commented="0" description="" originalStyle="" points="" sourceX="1929" sourceY="1166" status="0" style="defaultEdge" targetX="2098" targetY="1159" transitionIndex="0" x="356" y="84">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584739666065" description="activity to execute code snippets in the selected language" displayName="Archiving Azure files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity;fillColor=#CCCCCC;gradientColor=#CCCCCC" uniqueName="Script_142" waitSetting="0" width="146" x="2282" y="1149">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;int iMaxRetryCount = 3;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;String sThreadRetry = &amp;quot;iThreadRetry&amp;quot; + Integer.toString(xpath:{/workflow/XPathMultiQuery_2/rowNumber});&amp;#xD;&amp;#xA;int iThreadRetry = workflow.getVariable(sThreadRetry);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    if(iThreadRetry &amp;gt; iMaxRetryCount)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Archiving with PID [&amp;quot; + xpath:{/workflow/Script_139/output} + &amp;quot;] is no longer running and is likely to have completed. Completing Workflow job.&amp;quot;);&amp;#xD;&amp;#xA;        return &amp;quot;Failed&amp;quot;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String op = xpath:{/workflow/ExecuteCommand_41/commandOutput};&amp;#xD;&amp;#xA;    if(0 != xpath:{/workflow/ExecuteCommand_41/errorCode} || 0 != xpath:{/workflow/ExecuteCommand_41/exitCode} || op.isEmpty() || !op.trim().toLowerCase().contains(&amp;quot;cloudchunkrecal&amp;quot;))&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Archiving with PID [&amp;quot; + xpath:{/workflow/Script_139/output} + &amp;quot;] is no longer running and is likely to have completed. Checking again. Attempt &amp;quot; + Integer.toString(iThreadRetry) + &amp;quot;/&amp;quot; + Integer.toString(iMaxRetryCount));&amp;#xD;&amp;#xA;        workflow.setVariable(sThreadRetry,++iThreadRetry);&amp;#xD;&amp;#xA;        return &amp;quot;Retry&amp;quot;;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    //reset retry count on success&amp;#xD;&amp;#xA;    workflow.setVariable(sThreadRetry,1);&amp;#xD;&amp;#xA;    return &amp;quot;Success&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Archiving with PID [&amp;quot; + xpath:{/workflow/Script_139/output} + &amp;quot;] is no longer running and is likely to have completed. Checking again. Attempt &amp;quot; + Integer.toString(iThreadRetry) + &amp;quot;/&amp;quot; + Integer.toString(iMaxRetryCount));&amp;#xD;&amp;#xA;    workflow.setVariable(sThreadRetry,++iThreadRetry);&amp;#xD;&amp;#xA;    return &amp;quot;Retry&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA; &quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_42" commented="0" description="" displayName="Retry" originalStyle="" points="" sourceX="2155" sourceY="1166" status="0" style="defaultEdge" targetX="2160" targetY="1250" transitionIndex="0" x="356" y="84">

              <condition language="1" script="xpath:{/workflow/Script_142/output}.equals(&quot;Retry&quot;)" />

            </transition>

            <transition activity="ExecuteCommand_43" commented="0" description="" displayName="Success" originalStyle="" points="2487.0,1248.0" sourceX="2355" sourceY="1166" status="0" style="defaultEdge" targetX="2367" targetY="1304" transitionIndex="0" x="356" y="84">

              <condition language="1" script="xpath:{/workflow/Script_142/output}.equals(&quot;Success&quot;)" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1584739833447" description="Execute a command on a remote machine" displayName="Archiving Azure files" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_42" waitSetting="0" width="146" x="2285" y="1222">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;hostName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;displayName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;commCellName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;csGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;type class=&quot;commvault.msgs.CvEntities.CommCellType&quot; _list_=&quot;false&quot; /&gt;&lt;flags class=&quot;commvault.msgs.CvEntities.EntityFlags&quot; _list_=&quot;false&quot; /&gt;&lt;GUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;newName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;ping&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;127.0.0.1 -n 21 &amp;gt; nul&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_41" commented="0" description="" originalStyle="" points="2151.0,1219.0" sourceX="2158" sourceY="1239" status="0" style="defaultEdge" targetX="1970" targetY="1168" transitionIndex="0" x="356" y="84">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584744329711" description="activity to execute code snippets in the selected language" displayName="Archiving Azure files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_143" waitSetting="0" width="146" x="1712" y="1149">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&amp;quot;windows&amp;quot;))&amp;#xD;&amp;#xA;    return &amp;quot;tasklist&amp;quot;;&amp;#xD;&amp;#xA;return &amp;quot;ps&amp;quot;;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_141" commented="0" description="" originalStyle="" points="" sourceX="1769" sourceY="1122" status="0" style="defaultEdge" targetX="1788" targetY="1161" transitionIndex="0" x="356" y="84">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1584749009076" description="Execute a command on a remote machine" displayName="Recalling Files" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_43" waitSetting="0" width="111" x="2301" y="1260">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;hostName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;displayName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;commCellName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;csGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;type class=&quot;commvault.msgs.CvEntities.CommCellType&quot; _list_=&quot;false&quot; /&gt;&lt;flags class=&quot;commvault.msgs.CvEntities.EntityFlags&quot; _list_=&quot;false&quot; /&gt;&lt;GUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;newName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;ping&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;127.0.0.1 -n 301 &amp;gt; nul&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_41" commented="0" description="" originalStyle="" points="2135.0,1244.0" sourceX="2356" sourceY="1303" status="0" style="defaultEdge" targetX="2169" targetY="1168" transitionIndex="0" x="356" y="84">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584824077862" description="if/else based decision" displayName="OS" height="52" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_30" waitSetting="0" width="56" x="756" y="434">

            <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&quot;windows&quot;)&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

            <transition activity="Script_127" commented="0" description="" displayName="Unix" originalStyle="" points="" sourceX="784" sourceY="460" status="0" style="defaultEdge" targetX="962" targetY="538" transitionIndex="0" value="false" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

            <transition activity="ExecuteCommand_44" commented="0" description="" originalStyle="" points="" sourceX="784" sourceY="460" status="0" style="defaultEdge" targetX="1016" targetY="506" transitionIndex="0" value="true" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584824121866" description="activity to execute code snippets in the selected language" displayName="Recalling Files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_144" waitSetting="0" width="111" x="1050" y="443">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;List pids = new ArrayList();&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(xpath:{/workflow/ExecuteCommand_44/exitCode} != 0 || xpath:{/workflow/ExecuteCommand_44/errorCode} != 0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;No running recall processes detected Post-recall&amp;quot;);&amp;#xD;&amp;#xA;    return pids;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String op = xpath:{/workflow/ExecuteCommand_44/commandOutput};&amp;#xD;&amp;#xA;    if(op.trim().isEmpty())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;No running recall processes detected Post-recall.&amp;quot;);&amp;#xD;&amp;#xA;        return pids;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String[] lines = op.split(&amp;quot;\\r?\\n&amp;quot;);&amp;#xD;&amp;#xA;    for(String line : lines)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        line = line.replaceAll(&amp;quot;\&amp;quot;&amp;quot;, &amp;quot;&amp;quot;);;&amp;#xD;&amp;#xA;        String[] vals = line.split(&amp;quot;,&amp;quot;);&amp;#xD;&amp;#xA;        pids.add(Integer.parseInt(vals[1]));&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Post-recall processes &amp;quot; + pids.toString());    &amp;#xD;&amp;#xA;    return pids;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;No running recall processes detected Post-recall&amp;quot;);&amp;#xD;&amp;#xA;    return pids;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_127" commented="0" description="" originalStyle="" points="1026.0,503.0" sourceX="1105" sourceY="460" status="0" style="defaultEdge" targetX="1024" targetY="535" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1584824403700" description="Execute a command on a remote machine" displayName="Recalling Files" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_44" waitSetting="0" width="111" x="902" y="443">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientName}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;tasklist&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;/fo csv /nh | findstr &quot;CloudChunkRecall&quot;&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_144" commented="0" description="" originalStyle="" points="" sourceX="1243" sourceY="496" status="0" style="defaultEdge" targetX="1016" targetY="449" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584826418553" description="if/else based decision" displayName="OS" height="52" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_32" waitSetting="0" width="56" x="592" y="604">

            <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&quot;windows&quot;)&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_9" commented="0" description="" displayName="Unix" offsetX="-34" offsetY="0" originalStyle="" points="742.0,594.0" sourceX="610" sourceY="468" status="0" style="defaultEdge" targetX="774" targetY="546" transitionIndex="0" value="false" x="0" y="-2">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

            <transition activity="ExecuteCommand_45" commented="0" description="" originalStyle="" points="" sourceX="620" sourceY="630" status="0" style="defaultEdge" targetX="538" targetY="632" transitionIndex="0" value="true" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1584826574398" description="Execute a command on a remote machine" displayName="Recalling Files" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_45" waitSetting="0" width="111" x="448" y="613">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientName}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;tasklist&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;/fo csv /nh | findstr &quot;CloudChunkRecall&quot;&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_145" commented="0" description="" originalStyle="" points="" sourceX="503" sourceY="630" status="0" style="defaultEdge" targetX="620" targetY="698" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584826713765" description="activity to execute code snippets in the selected language" displayName="Recalling Files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_145" waitSetting="0" width="111" x="546" y="677">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;List pids = new ArrayList();&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(xpath:{/workflow/ExecuteCommand_45/exitCode} != 0 || xpath:{/workflow/ExecuteCommand_45/errorCode} != 0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;No running recall processes detected Pre-recall&amp;quot;);&amp;#xD;&amp;#xA;    return pids;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String op = xpath:{/workflow/ExecuteCommand_45/commandOutput};&amp;#xD;&amp;#xA;    if(op.trim().isEmpty())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;No running recall processes detected Pre-recall.&amp;quot;);&amp;#xD;&amp;#xA;        return pids;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String[] lines = op.split(&amp;quot;\\r?\\n&amp;quot;);&amp;#xD;&amp;#xA;    for(String line : lines)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        line = line.replaceAll(&amp;quot;\&amp;quot;&amp;quot;, &amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;        String[] vals = line.split(&amp;quot;,&amp;quot;);&amp;#xD;&amp;#xA;        pids.add(Integer.parseInt(vals[1]));&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Pre-recall processes &amp;quot; + pids.toString());        &amp;#xD;&amp;#xA;    return pids;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;No running recall processes detected Pre-recall&amp;quot;);&amp;#xD;&amp;#xA;    return pids;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_9" commented="0" description="" originalStyle="" points="764.0,626.0" sourceX="601" sourceY="694" status="0" style="defaultEdge" targetX="794" targetY="530" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584839309028" description="if/else based decision" displayName="OS" height="52" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_33" waitSetting="0" width="56" x="786" y="1142">

            <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&quot;windows&quot;)&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_46" commented="0" description="" originalStyle="" points="" sourceX="814" sourceY="1176" status="0" style="defaultEdge" targetX="936" targetY="1168" transitionIndex="0" value="true" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

            <transition activity="Script_112" commented="0" description="" displayName="Unix" originalStyle="" points="" sourceX="814" sourceY="1168" status="0" style="defaultEdge" targetX="1186" targetY="1168" transitionIndex="0" value="false" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1584839370963" description="Execute a command on a remote machine" displayName="Recalling Files" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_46" waitSetting="0" width="111" x="760" y="1227">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientName}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;tasklist&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;/fo csv /nh | findstr &quot;CloudChunkRecall&quot;&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_146" commented="0" description="" originalStyle="" points="" sourceX="935" sourceY="1176" status="0" style="defaultEdge" targetX="1184" targetY="1162" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584839405155" description="activity to execute code snippets in the selected language" displayName="Recalling Files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_146" waitSetting="0" width="111" x="930" y="1227">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;List pids = new ArrayList();&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(xpath:{/workflow/ExecuteCommand_46/exitCode} != 0 || xpath:{/workflow/ExecuteCommand_46/errorCode} != 0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;No running archiving processes detected Post-recall&amp;quot;);&amp;#xD;&amp;#xA;    return pids;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String op = xpath:{/workflow/ExecuteCommand_46/commandOutput};&amp;#xD;&amp;#xA;    if(op.trim().isEmpty())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;No running archiving processes detected Post-recall.&amp;quot;);&amp;#xD;&amp;#xA;        return pids;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String[] lines = op.split(&amp;quot;\\r?\\n&amp;quot;);&amp;#xD;&amp;#xA;    for(String line : lines)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        line = line.replaceAll(&amp;quot;\&amp;quot;&amp;quot;, &amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;        String[] vals = line.split(&amp;quot;,&amp;quot;);&amp;#xD;&amp;#xA;        pids.add(Integer.parseInt(vals[1]));&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Post-archive processes &amp;quot; + pids.toString());        &amp;#xD;&amp;#xA;    return pids;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;No running archiving processes detected Post-recall&amp;quot;);&amp;#xD;&amp;#xA;    return pids;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_112" commented="0" description="" originalStyle="" points="" sourceX="909" sourceY="1142" status="0" style="defaultEdge" targetX="1158" targetY="1166" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584839893408" description="if/else based decision" displayName="OS" height="52" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_34" waitSetting="0" width="56" x="1444" y="974">

            <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientOs}.contains(&quot;windows&quot;)&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_47" commented="0" description="" originalStyle="" points="" sourceX="1472" sourceY="1000" status="0" style="defaultEdge" targetX="1138" targetY="1085" transitionIndex="0" value="true" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

            <transition activity="ExecuteCommand_27" commented="0" description="" originalStyle="" points="1170.0,953.0" sourceX="1472" sourceY="1000" status="0" style="defaultEdge" targetX="768" targetY="1015" transitionIndex="0" value="false" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1584839934411" description="Execute a command on a remote machine" displayName="Recalling Files" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_47" waitSetting="0" width="111" x="1254" y="983">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_2/clientName}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;tasklist&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;/fo csv /nh | findstr &quot;CloudChunkRecall&quot;&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="Script_147" commented="0" description="" originalStyle="" points="" sourceX="1309" sourceY="1000" status="0" style="defaultEdge" targetX="1064" targetY="1005" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1584839963479" description="activity to execute code snippets in the selected language" displayName="Recalling Files" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_147" waitSetting="0" width="111" x="1016" y="983">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;List pids = new ArrayList();&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(xpath:{/workflow/ExecuteCommand_47/exitCode} != 0 || xpath:{/workflow/ExecuteCommand_47/errorCode} != 0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;No running archiving processes detected Pre-recall&amp;quot;);&amp;#xD;&amp;#xA;    return pids;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String op = xpath:{/workflow/ExecuteCommand_47/commandOutput};&amp;#xD;&amp;#xA;    if(op.trim().isEmpty())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;No running archiving processes detected Pre-recall.&amp;quot;);&amp;#xD;&amp;#xA;        return pids;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String[] lines = op.split(&amp;quot;\\r?\\n&amp;quot;);&amp;#xD;&amp;#xA;    for(String line : lines)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        line = line.replaceAll(&amp;quot;\&amp;quot;&amp;quot;, &amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;        String[] vals = line.split(&amp;quot;,&amp;quot;);&amp;#xD;&amp;#xA;        pids.add(Integer.parseInt(vals[1]));&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Pre-archive processes &amp;quot; + pids.toString());        &amp;#xD;&amp;#xA;    return pids;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;No running archiving processes detected Pre-recall&amp;quot;);&amp;#xD;&amp;#xA;    return pids;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteCommand_27" commented="0" description="" originalStyle="" points="" sourceX="1071" sourceY="1008" status="0" style="defaultEdge" targetX="838" targetY="999" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1585625141494" description="executes queries against a commcell database" displayName="Put restore job in waiting" height="35" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_54" waitSetting="0" width="171" x="935" y="384">

            <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @failurereason varchar(max) = '''';&amp;#xD;&#xD;&#xA;select @failurereason = failurereason&amp;#xD;&#xD;&#xA;from JMJobInfo(READUNCOMMITTED)&amp;#xD;&#xD;&#xA;where jobid = xpath:{/workflow/variables/iJobId};&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select @failurereason&lt;/query&gt;&lt;/inputs&gt;" />

            <transition activity="ImpersonateCreator_1" commented="0" description="" originalStyle="" points="" sourceX="1020" sourceY="401" status="0" style="defaultEdge" targetX="820" targetY="402" transitionIndex="0" x="-262" y="-4075">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1585625468048" description="impersonates the user who created the workflow" displayName="ImpersonateCreator" height="34" interactive="0" jobMode="0" name="ImpersonateCreator" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ImpersonateCreator" uniqueName="ImpersonateCreator_1" waitSetting="0" width="145" x="748" y="385">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="Execute_11" commented="0" description="" originalStyle="" points="" sourceX="874" sourceY="370" status="0" style="defaultEdge" targetX="718" targetY="408" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1585626472161" description="Execute a command on a remote machine" displayName="Put restore job in waiting" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_52" waitSetting="0" width="171" x="357" y="458">

            <onExit language="1" script="workflow.clearFailures();&#xD;&#xA;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;hostName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;displayName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;commCellName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;csGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;type class=&quot;commvault.msgs.CvEntities.CommCellType&quot; _list_=&quot;false&quot; /&gt;&lt;flags class=&quot;commvault.msgs.CvEntities.EntityFlags&quot; _list_=&quot;false&quot; /&gt;&lt;GUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;newName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;ping&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;127.0.0.1 -n 61 &amp;gt; nul&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

            <transition activity="CommServDBQuery_49" commented="0" description="" originalStyle="" points="" sourceX="442" sourceY="475" status="0" style="defaultEdge" targetX="526" targetY="403" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1585627315758" description="executes queries against a commcell database" displayName="Put restore job in waiting" height="35" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_55" waitSetting="0" width="171" x="2711" y="760">

            <onEnter language="1" script="logger.info(&quot;Attempting to suspend restore job&quot;);" />

            <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @failurereason varchar(max) = '''';&amp;#xD;&#xD;&#xA;select @failurereason = failurereason&amp;#xD;&#xD;&#xA;from JMJobInfo(READUNCOMMITTED)&amp;#xD;&#xD;&#xA;where jobid = xpath:{/workflow/variables/iJobId};&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select @failurereason&lt;/query&gt;&lt;/inputs&gt;" />

            <transition activity="Execute_12" commented="0" description="" originalStyle="" points="" sourceX="2796" sourceY="777" status="0" style="defaultEdge" targetX="2791" targetY="678" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1585697122960" description="executes queries against a commcell database" displayName="Put restore job in waiting" height="37" interactive="0" jobMode="0" maxRestarts="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_57" waitSetting="0" width="171" x="2229" y="288">

            <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @displaystate int;&amp;#xD;&#xD;&#xA;select @displaystate = displaystate&amp;#xD;&#xD;&#xA;from JMJobInfo(READUNCOMMITTED)&amp;#xD;&#xD;&#xA;where jobid = xpath:{/workflow/variables/iJobId};&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if(@displaystate = 5 /*Suspended*/)&amp;#xD;&#xD;&#xA;begin&amp;#xD;&#xD;&#xA;    update JMJobInfo set displaystate = 3 where jobid = xpath:{/workflow/variables/iJobId};&amp;#xD;&#xD;&#xA;    select 5&amp;#xD;&#xD;&#xA;end&amp;#xD;&#xD;&#xA;else&amp;#xD;&#xD;&#xA;    select 0&amp;#xD;&#xD;&#xA;&lt;/query&gt;&lt;/inputs&gt;" />

            <transition activity="Script_158" commented="0" description="" originalStyle="" points="" sourceX="2314" sourceY="306" status="0" style="defaultEdge" targetX="2132" targetY="305" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1585697176907" description="activity to execute code snippets in the selected language" displayName="Put restore job in waiting" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity;fillColor=#CCCCCC;gradientColor=#CCCCCC" uniqueName="Script_158" waitSetting="0" width="171" x="2012" y="289">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/CommServDBQuery_57/resultSets/rowCount} &amp;gt; 0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    int result = xpath:{/workflow/CommServDBQuery_57/resultSets/row[1]/col[1]};    &amp;#xD;&amp;#xA;    if(5 == result) /*Suspended*/&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;JID [&amp;quot; + Integer.toString(xpath:{/workflow/variables/iJobId}) + &amp;quot;] Updated Job Display State from [Suspended] to [Waiting]&amp;quot;);&amp;#xD;&amp;#xA;        String sThreadJobStatus = &amp;quot;sThreadJobStatus&amp;quot; + Integer.toString(xpath:{/workflow/XPathMultiQuery_2/rowNumber});&amp;#xD;&amp;#xA;        workflow.setVariable(sThreadJobStatus, &amp;quot;Waiting&amp;quot;);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Unable to determine job state&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="EnableLogging_37" commented="0" description="" originalStyle="" points="" sourceX="2097" sourceY="306" status="0" style="defaultEdge" targetX="2112" targetY="445" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1585793577522" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_37" waitSetting="0" width="113" x="2050" y="359">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="ExecuteCommand_36" commented="0" description="" originalStyle="" points="" sourceX="2018" sourceY="368" status="0" style="defaultEdge" targetX="2112" targetY="454" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1586990588675" description="" displayName="Get Restore Job Details" height="34" interactive="0" jobMode="0" maxRestarts="0" name="Execute" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute" uniqueName="Execute_6" waitSetting="0" width="163" x="858" y="815">

            <inputs val="&lt;inputs&gt;&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;&amp;lt;TMMsg_GetTaskDetailByJobReq jobId=&quot;xpath:{/workflow/variables/iJobId}&quot;/&amp;gt; &lt;/inputXml&gt;&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/escapeXml&gt;&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ImpersonateCreator_2/token}&lt;/token&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

            <transition activity="Script_173" commented="0" description="" originalStyle="" points="" sourceX="939" sourceY="832" status="0" style="defaultEdge" targetX="812" targetY="824" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1586990726521" description="activity to execute code snippets in the selected language" displayName="Process Details For Resubmission" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_173" waitSetting="0" width="200" x="641" y="813">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;import org.jdom2.Element;&amp;#xD;&amp;#xA;import org.jdom2.Document;&amp;#xD;&amp;#xA;import org.jdom2.Attribute;&amp;#xD;&amp;#xA;import org.jdom2.input.SAXBuilder;&amp;#xD;&amp;#xA;import org.jdom2.output.XMLOutputter;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String data = xpath:{/workflow/Execute_6/outputXml};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    InputStream stream = new ByteArrayInputStream(data.getBytes(&amp;quot;UTF-8&amp;quot;));&amp;#xD;&amp;#xA;    SAXBuilder builder = new SAXBuilder();&amp;#xD;&amp;#xA;    Document doc;&amp;#xD;&amp;#xA;    doc = builder.build(stream);&amp;#xD;&amp;#xA;    Element GetTaskDetailResp = doc.getRootElement();&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    Element CreateTaskReq = new Element(&amp;quot;TMMsg_CreateTaskReq&amp;quot;);&amp;#xD;&amp;#xA;    Document returnDoc = new Document(CreateTaskReq);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    CreateTaskReq.setAttribute(&amp;quot;submitJobId&amp;quot;, Integer.toString(xpath:{/workflow/variables/iJobId}));&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    for(Element taskInfo : GetTaskDetailResp.getChildren())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        CreateTaskReq.addContent(taskInfo.clone());&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;sJobInfoDetails&amp;quot;,new XMLOutputter().outputString(returnDoc));&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;&amp;#x9;logger.info(&amp;quot;Error parsing restore job details. Exception: &amp;quot; + e);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Execute_7" commented="0" description="" originalStyle="" points="" sourceX="741" sourceY="830" status="0" style="defaultEdge" targetX="562" targetY="824" transitionIndex="0" x="0" y="0">

              <condition language="1" script="xpath:{/workflow/Script_173/output}" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1586990729326" description="" displayName="Resubmit Job" height="34" interactive="0" jobMode="0" maxRestarts="0" name="Execute" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute" uniqueName="Execute_7" waitSetting="0" width="108" x="505" y="813">

            <inputs val="&lt;inputs&gt;&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;java:{workflow.getVariable(&quot;sJobInfoDetails&quot;)}&lt;/inputXml&gt;&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/escapeXml&gt;&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ImpersonateCreator_1/token}&lt;/token&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

            <transition activity="Script_174" commented="0" description="" originalStyle="" points="" sourceX="559" sourceY="830" status="0" style="defaultEdge" targetX="418" targetY="831" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1586990726555" description="activity to execute code snippets in the selected language" displayName="Get New Restore JobId" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_174" waitSetting="0" width="159" x="315" y="823">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;import org.jdom2.Element;&amp;#xD;&amp;#xA;import org.jdom2.Document;&amp;#xD;&amp;#xA;import org.jdom2.Attribute;&amp;#xD;&amp;#xA;import org.jdom2.input.SAXBuilder;&amp;#xD;&amp;#xA;import org.jdom2.output.XMLOutputter;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String data = xpath:{/workflow/Execute_7/outputXml};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    InputStream stream = new ByteArrayInputStream(data.getBytes(&amp;quot;UTF-8&amp;quot;));&amp;#xD;&amp;#xA;    SAXBuilder builder = new SAXBuilder();&amp;#xD;&amp;#xA;    Document doc;&amp;#xD;&amp;#xA;    doc = builder.build(stream);&amp;#xD;&amp;#xA;    Element CreateTaskResp = doc.getRootElement();&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    int jobId = 0;&amp;#xD;&amp;#xA;    for(Element child : CreateTaskResp.getChildren())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        if(child.getName().equals(&amp;quot;jobIds&amp;quot;) &amp;amp;&amp;amp; child.hasAttributes())&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            String job = child.getAttributeValue(&amp;quot;val&amp;quot;);&amp;#xD;&amp;#xA;            jobId = Integer.parseInt(job);&amp;#xD;&amp;#xA;                &amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(jobId == 0)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Failed to resubmit failed restore job for restore vector information.&amp;quot;);&amp;#xD;&amp;#xA;        return false;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;iJobId&amp;quot;, jobId);&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Setting new tracking restore JID to [&amp;quot; + Integer.toString(jobId) + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;&amp;#x9;logger.info(&amp;quot;Failed to resubmit restore job after recall. Exception: &amp;quot; + e);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="CommServDBQuery_65" commented="0" description="" originalStyle="" points="" sourceX="394" sourceY="830" status="0" style="defaultEdge" targetX="333" targetY="779" transitionIndex="0" x="0" y="0">

              <condition language="4" script="xpath:{/workflow/Script_174/output}" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1608166482719" description="executes queries against a commcell database" displayName="Get New Restore JobId" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_65" waitSetting="0" width="159" x="268" y="770">

            <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @jobId int = xpath:{/workflow/variables/iJobId};&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @ccId int&amp;#xD;&#xD;&#xA;select @ccId = id&amp;#xD;&#xD;&#xA;from app_client(nolock)&amp;#xD;&#xD;&#xA;where name = ''xpath:{/workflow/system/commCellName}'';&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @wfJID int = xpath:{/workflow/system/jobId};&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;IF EXISTS(SELECT 1 &amp;#xD;&#xD;&#xA;    FROM JMJobOptions(READUNCOMMITTED)&amp;#xD;&#xD;&#xA;    WHERE attributeId = xpath:{/workflow/variables/JM_CLOUD_RECALL_WF_ID}&amp;#xD;&#xD;&#xA;    AND jobId = @jobId)&amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;    DELETE FROM JMJobOptions &amp;#xD;&#xD;&#xA;    WHERE jobId = @jobId&amp;#xD;&#xD;&#xA;    AND commCellId = @ccId&amp;#xD;&#xD;&#xA;    AND attributeid = xpath:{/workflow/variables/JM_CLOUD_RECALL_WF_ID}&amp;#xD;&#xD;&#xA;END&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;INSERT INTO JMJobOptions(jobId, commCellId, attributeid, attributeName, attributeValueInt, attributeValue)&amp;#xD;&#xD;&#xA;VALUES(@jobId, @ccId, xpath:{/workflow/variables/JM_CLOUD_RECALL_WF_ID}, ''Cloud Recall Workflow JobId'', @wfJID, '''');&lt;/query&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteProcessBlock_69" commented="0" description="" originalStyle="" points="" sourceX="398" sourceY="826" status="0" style="defaultEdge" targetX="200" targetY="927" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1610409713519" description="" displayName="Execute" height="34" interactive="0" jobMode="0" maxRestarts="0" name="Execute" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute" uniqueName="Execute_11" waitSetting="0" width="100" x="620" y="385">

            <onExit language="4" script="workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;&amp;lt;JobManager_PerformMultiCellJobOpReq message=&quot;1&quot; operationDescription=&quot;Suspended by Workflow JID xpath:{/workflow/system/jobId} for cloud recall&quot;&amp;gt;&amp;#xD;&#xD;&#xA;    &amp;lt;jobOpReq operationType=&quot;0&quot;&amp;gt;&amp;#xD;&#xD;&#xA;        &amp;lt;jobs jobId=&quot;xpath:{/workflow/variables/iJobId}&quot;/&amp;gt;&amp;#xD;&#xD;&#xA;    &amp;lt;/jobOpReq&amp;gt;&amp;#xD;&#xD;&#xA;&amp;lt;/JobManager_PerformMultiCellJobOpReq&amp;gt;&lt;/inputXml&gt;&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/escapeXml&gt;&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ImpersonateCreator_1/token}&lt;/tokenFile&gt;&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

            <transition activity="CommServDBQuery_49" commented="0" description="" originalStyle="" points="" sourceX="710" sourceY="402" status="0" style="defaultEdge" targetX="546" targetY="400" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1610409749617" description="" displayName="Execute" height="34" interactive="0" jobMode="0" maxRestarts="0" name="Execute" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute" uniqueName="Execute_12" waitSetting="0" width="100" x="2736" y="641">

            <onEnter language="4" script="logger.info(&quot;Attempting to suspend restore job&quot;);" />

            <onExit language="4" script="workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.COMPLETED);" />

            <inputs val="&lt;inputs&gt;&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;&amp;lt;JobManager_PerformMultiCellJobOpReq message=&quot;1&quot; operationDescription=&quot;Suspended by Workflow JID xpath:{/workflow/system/jobId} for cloud recall&quot;&amp;gt;&amp;#xD;&#xD;&#xA;    &amp;lt;jobOpReq operationType=&quot;0&quot;&amp;gt;&amp;#xD;&#xD;&#xA;        &amp;lt;jobs jobId=&quot;xpath:{/workflow/variables/iJobId}&quot;/&amp;gt;&amp;#xD;&#xD;&#xA;    &amp;lt;/jobOpReq&amp;gt;&amp;#xD;&#xD;&#xA;&amp;lt;/JobManager_PerformMultiCellJobOpReq&amp;gt;&lt;/inputXml&gt;&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/escapeXml&gt;&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ImpersonateCreator_1/token}&lt;/tokenFile&gt;&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

            <transition activity="CommServDBQuery_53" commented="0" description="" originalStyle="" points="" sourceX="2784" sourceY="676" status="0" style="defaultEdge" targetX="2801" targetY="516" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="1" created="1613847710465" description="" displayName="JobControl" height="34" interactive="0" jobMode="0" maxRestarts="0" name="JobControl" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationJobControl" uniqueName="JobControl_2" waitSetting="0" width="100" x="44" y="729">

            <inputs val="&lt;inputs&gt;&lt;operation class=&quot;workflow.types.cmd.JobOperation&quot; _list_=&quot;false&quot;&gt;resume&lt;/operation&gt;&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/iJobId}&lt;/jobId&gt;&lt;priority class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ImpersonateCreator_1/token}&lt;/tokenFile&gt;&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

            <transition activity="ExecuteProcessBlock_69" commented="0" description="" originalStyle="" points="" sourceX="204" sourceY="544" status="0" style="defaultEdge" targetX="496" targetY="665" transitionIndex="0" x="0" y="0">

              <condition language="1" script=" " />

            </transition>

          </Activity>

        </superProcess>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578671785728" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_17" waitSetting="0" width="138" x="50" y="439">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="ForEachXml_2" commented="0" description="" originalStyle="" points="" sourceX="166" sourceY="282" status="0" style="defaultEdge" targetX="708" targetY="44" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578671795135" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_18" waitSetting="0" width="117" x="3315" y="562">

        <inputs val="&lt;inputs /&gt;" />

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1578602814752" description="creates a super process group" displayName="Backup" height="478" interactive="0" jobMode="0" name="ProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#85E0E0;gradientColor=#85E0E0" uniqueName="ProcessBlock_28" waitSetting="0" width="3888" x="52" y="2924">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs className="" defaultValue="" listType="0" name="outputs" type="" />

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1578602814752" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_33" waitSetting="0" width="58" x="22" y="156">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="EnableLogging_25" commented="0" description="" originalStyle="" points="" sourceX="51" sourceY="171" status="0" style="defaultEdge" targetX="174" targetY="241" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1578602954568" description="executes queries against a commcell database" displayName="Determine Agent" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_30" waitSetting="0" width="125" x="1428" y="202">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @jobIds table(jobid int)&amp;#xD;&#xD;&#xA;declare @jobId int = xpath:{/workflow/variables/iJobId}&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;insert into @jobIds&amp;#xD;&#xD;&#xA;select parentjobid&amp;#xD;&#xD;&#xA;from JMJobDataLink(nolock)&amp;#xD;&#xD;&#xA;where childjobId = @jobId&amp;#xD;&#xD;&#xA;union&amp;#xD;&#xD;&#xA;select @jobid&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select top 1 case when appTypeId in (106,81) then appTypeId else 0 end appTypeId&amp;#xD;&#xD;&#xA;from APP_Application(nolock) a&amp;#xD;&#xD;&#xA;join archFile(nolock) af on af.appId = a.id&amp;#xD;&#xD;&#xA;join @jobIds j on j.jobId = af.jobId&amp;#xD;&#xD;&#xA;order by af.commCellId asc&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="Script_76" commented="0" description="" originalStyle="" points="" sourceX="1136" sourceY="219" status="0" style="defaultEdge" targetX="1323" targetY="212" transitionIndex="0" x="633" y="-1">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578605004989" description="executes queries against a commcell database" displayName="Get Recall Data" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_34" waitSetting="0" width="116" x="1437" y="103">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @jobId int = xpath:{/workflow/variables/iJobId};&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @appId int = 0&amp;#xD;&#xD;&#xA;declare @appType int = 0&amp;#xD;&#xD;&#xA;declare @commCellId int = 0&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select @appId = BkpStats.appId&amp;#xD;&#xD;&#xA;&#x9;, @appType = BkpStats.appType&amp;#xD;&#xD;&#xA;&#x9;, @commCellId = commCellId&amp;#xD;&#xD;&#xA;from JMBkpStats(READUNCOMMITTED) BkpStats&amp;#xD;&#xD;&#xA;where BkpStats.jobId = @jobId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @jobs table(jobId int, commCellId int)&amp;#xD;&#xD;&#xA;insert into @jobs values(@jobId, @commCellId)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if @appType = 106 /* VIRTUAL_SERVER_IDA */&amp;#xD;&#xD;&#xA;begin&amp;#xD;&#xD;&#xA;&#x9;--adding child jobs for VSA V2&amp;#xD;&#xD;&#xA;&#x9;insert into @jobs&amp;#xD;&#xD;&#xA;    select distinct JD.childJobId, JD.commCellId&amp;#xD;&#xD;&#xA;    from JMJobDataLink(NOLOCK) JD&amp;#xD;&#xD;&#xA;    join @jobs J ON J.JobId = JD.parentJobId and JD.commCellId = J.commCellId&amp;#xD;&#xD;&#xA;    where JD.parentJobId &amp;lt;&amp;gt; JD.childJobId&amp;#xD;&#xD;&#xA;    and JD.linkType in (7,8)&amp;#xD;&#xD;&#xA;    &amp;#xD;&#xD;&#xA;    insert into @jobs&amp;#xD;&#xD;&#xA;    select distinct JD.parentJobId, JD.commCellId&amp;#xD;&#xD;&#xA;    from JMJobDataLink(NOLOCK) JD&amp;#xD;&#xD;&#xA;    join @jobs J ON J.JobId = JD.childJobId and JD.commCellId = J.commCellId&amp;#xD;&#xD;&#xA;    where JD.parentJobId &amp;lt;&amp;gt; JD.childJobId&amp;#xD;&#xD;&#xA;    and JD.linkType in (7,8)&amp;#xD;&#xD;&#xA;end&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @afIds table(archFileId int, appId int, name nvarchar(2048), cTime int, isV2 int)&amp;#xD;&#xD;&#xA;insert into @afIds&amp;#xD;&#xD;&#xA;select af.id, af.appId, af.name, af.cTime, 0&amp;#xD;&#xD;&#xA;from archFile(READUNCOMMITTED) af&amp;#xD;&#xD;&#xA;join @jobs j on j.jobId = af.jobId&amp;#xD;&#xD;&#xA;where af.fileType in (2, 5 /* V1 Erase Mask */, 6 /* Snap */, 7 /* Components */)&amp;#xD;&#xD;&#xA;and af.isValid &amp;gt; 0&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;update @afIds&amp;#xD;&#xD;&#xA;set isV2 = 1&amp;#xD;&#xD;&#xA;from APP_Application(nolock) a&amp;#xD;&#xD;&#xA;join APP_ClientProp(nolock) cp on cp.componentNameId = a.clientId&amp;#xD;&#xD;&#xA;join @afIds af on af.appId = a.id&amp;#xD;&#xD;&#xA;where cp.attrName = dbo.GetIndexingV2PropNameByAppType(a.appTypeId) and cp.attrVal = ''1''&amp;#xD;&#xD;&#xA;and af.name not in ('''', ''N/A'', ''Not Named'')&amp;#xD;&#xD;&#xA;and af.cTime &amp;gt;= cp.created&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if exists (select 1 from @afIds where isV2 = 1)&amp;#xD;&#xD;&#xA;begin&amp;#xD;&#xD;&#xA;&#x9;declare @indexAppIds table(appId int)&amp;#xD;&#xD;&#xA;&#x9;insert into @indexAppIds&amp;#xD;&#xD;&#xA;&#x9;select distinct appId&amp;#xD;&#xD;&#xA;&#x9;from @afIds&amp;#xD;&#xD;&#xA;&#x9;where isV2 = 1&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;declare @indexGuids table(dbGuid varchar(max), backupSetGuid varchar(max))&amp;#xD;&#xD;&#xA;    insert into @indexGuids&amp;#xD;&#xD;&#xA;&#x9;select distinct IdxDB.dbName, IdxDB.backupSetGUID&amp;#xD;&#xD;&#xA;&#x9;from App_application(READUNCOMMITTED) App&amp;#xD;&#xD;&#xA;&#x9;join App_BackupSetName(READUNCOMMITTED) BkpSet on App.backupSet = BkpSet.id&amp;#xD;&#xD;&#xA;&#x9;join App_IndexDBInfo(READUNCOMMITTED) IdxDB on BkpSet.id = IdxDB.backupSetId AND BkpSet.GUID = IdxDB.backupSetGUID&amp;#xD;&#xD;&#xA;&#x9;join @indexAppIds idxAPP ON idxAPP.appId = APP.id&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;declare getIndexAFsForBackupSet cursor for&amp;#xD;&#xD;&#xA;    select dbGuid, backupSetGuid&amp;#xD;&#xD;&#xA;    from @indexGuids&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;declare @dbGuid varchar(max) = ''''&amp;#xD;&#xD;&#xA;    declare @backupSetGuid varchar(max) = ''''&amp;#xD;&#xD;&#xA;&#x9;declare @OutputTable  table (xmloutput xml)&amp;#xD;&#xD;&#xA;&#x9;declare @mediaPrediction bit = 1&amp;#xD;&#xD;&#xA;&#x9;&amp;#xD;&#xD;&#xA;    declare @copyPrecedence int = 0&amp;#xD;&#xD;&#xA;&#x9;&amp;#xD;&#xD;&#xA;&#x9;declare @xmlParam xml&amp;#xD;&#xD;&#xA;&#x9;declare @xmlOutput xml&amp;#xD;&#xD;&#xA;&#x9;declare @useCopyPrecdenceForCheckpoint INT = 1&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;open getIndexAFsForBackupSet&amp;#xD;&#xD;&#xA;&#x9;fetch next from getIndexAFsForBackupSet into @dbGuid, @backupSetGuid&amp;#xD;&#xD;&#xA;&#x9;while @@FETCH_STATUS = 0&amp;#xD;&#xD;&#xA;&#x9;begin&amp;#xD;&#xD;&#xA;&#x9;&#x9;set @xmlParam = (&amp;#xD;&#xD;&#xA;        select @dbGuid as ''@dbGuid'', @backupSetGuid as ''@backupSetGuid''&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;, @mediaPrediction as ''@isMediaPrediction'', @copyPrecedence as ''@copyPrecedence''&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;, @useCopyPrecdenceForCheckpoint as ''@useCopyPrecdenceForCheckpoint''&amp;#xD;&#xD;&#xA;        for xml path (''Indexing_GetArchFileInfoForJobs''), type)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;&#x9;insert into @OutputTable&amp;#xD;&#xD;&#xA;        exec AppgetArchFileInfoForJobs @xmlParam&amp;#xD;&#xD;&#xA;            &amp;#xD;&#xD;&#xA;        select top 1 @xmlOutput = xmlOutput from @OutputTable&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;        delete from @OutputTable&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;&#x9;insert into @afIds&amp;#xD;&#xD;&#xA;&#x9;&#x9;select A.id, A.appId, A.name, A.cTime, 1&amp;#xD;&#xD;&#xA;&#x9;&#x9;from archFile(READUNCOMMITTED) A&amp;#xD;&#xD;&#xA;&#x9;&#x9;join @xmlOutput.nodes(''Indexing_GetArchFileInfoForJobs/archFileInfoList'') AFInfo(n) &amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;on AFInfo.n.value(''@aFileId'', ''INT'') = A.id AND AFInfo.n.value(''@commCellId'', ''INT'') = A.commCellId&amp;#xD;&#xD;&#xA;&#x9;&#x9;where A.isValid = 1&amp;#xD;&#xD;&#xA;&#x9;&#x9;and not exists (select 1 from @afIds af where af.archFileId = A.id)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;&#x9;fetch next from getIndexAFsForBackupSet into @dbGuid, @backupSetGuid&amp;#xD;&#xD;&#xA;&#x9;end&amp;#xD;&#xD;&#xA;&#x9;close getIndexAFsForBackupSet&amp;#xD;&#xD;&#xA;    deallocate getIndexAFsForBackupSet&amp;#xD;&#xD;&#xA;end&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if object_id(''tempdb.dbo.#tempDeviceInfo'') is not null drop table #tempDeviceInfo&amp;#xD;&#xD;&#xA;create table #tempDeviceInfo (DeviceId int, DeviceTypeId int, Folder varchar(2048), mountpath bigint&amp;#xD;&#xD;&#xA;--, username nvarchar(max), password nvarchar(max)&amp;#xD;&#xD;&#xA;)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;insert into #tempDeviceInfo &amp;#xD;&#xD;&#xA;select distinct d.DeviceId, d.DeviceTypeId, dc.Folder, mp.MountPathId--, dc.UserName, dc.UserPassword&amp;#xD;&#xD;&#xA;from MMMountPath(nolock) mp&amp;#xD;&#xD;&#xA;join MMMountPathToStorageDevice(nolock) mpsd on mpsd.MountPathId = mp.MountPathId&amp;#xD;&#xD;&#xA;join MMDevice(nolock) d on d.DeviceId = mpsd.DeviceId&amp;#xD;&#xD;&#xA;join MMDeviceController(nolock) dc ON dc.DeviceId = d.DeviceId&amp;#xD;&#xD;&#xA;where d.DeviceTypeId &amp;lt;&amp;gt; 1&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @azureMode int = -3;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if object_id(''tempdb.dbo.#metaDataList'') is not null drop table #metaDataList&amp;#xD;&#xD;&#xA;create table #metaDataList (iMountPathId int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, iVolumeId int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, hasStore int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, iarchFileId int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, iarchChunkId bigint&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, physicalOffset bigint&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, DeviceTypeId int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, cclip varchar(max)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, archCopyId smallint&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, commCellId int)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;insert into #metaDataList&amp;#xD;&#xD;&#xA;select distinct MP.MountPathId&amp;#xD;&#xD;&#xA;                , mv.VolumeId&amp;#xD;&#xD;&#xA;                , case mv.SIDBStoreId when 0 then 0 else 1 end as hasStore&amp;#xD;&#xD;&#xA;                , acm.archFileId&amp;#xD;&#xD;&#xA;                , acm.archChunkId&amp;#xD;&#xD;&#xA;                , acm.physicalOffset&amp;#xD;&#xD;&#xA;                , d.DeviceTypeId&amp;#xD;&#xD;&#xA;                , case d.DeviceTypeId when 53 then ac.cclip else '''' end cclip&amp;#xD;&#xD;&#xA;                , acm.archCopyId&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;, acm.commCellId&amp;#xD;&#xD;&#xA;from    @afIds af &amp;#xD;&#xD;&#xA;join    archChunkMapping(nolock) acm on acm.archFileId = af.archFileId&amp;#xD;&#xD;&#xA;join    archChunk(nolock) ac on ac.id = acm.archChunkId and ac.commCellId = acm.chunkCommCellId&amp;#xD;&#xD;&#xA;join    MMVolume(nolock) mv on mv.VolumeId = ac.volumeId&amp;#xD;&#xD;&#xA;join    MMMountPath(nolock) mp on mv.MediaSideId = mp.MediaSideId&amp;#xD;&#xD;&#xA;join    MMMountPathToStorageDevice(nolock) msd on mp.MountPathId = msd.MountPathId&amp;#xD;&#xD;&#xA;join    #tempDeviceInfo(nolock) d on msd.DeviceId = d.DeviceId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare copy_cursor cursor for&amp;#xD;&#xD;&#xA;select distinct iarchFileId, commCellId&amp;#xD;&#xD;&#xA;from #metaDataList&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @archFileId int = 0&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;open copy_cursor&amp;#xD;&#xD;&#xA;fetch next from copy_cursor into @archFileId, @commCellId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;while @@FETCH_STATUS = 0&amp;#xD;&#xD;&#xA;begin&amp;#xD;&#xD;&#xA;&#x9;declare @l_outArchCopyId int&amp;#xD;&#xD;&#xA;&#x9;declare @l_outAFC_isValid int&amp;#xD;&#xD;&#xA;&#x9;declare @l_outAFC_flag int&amp;#xD;&#xD;&#xA;&#x9;&amp;#xD;&#xD;&#xA;&#x9;exec archFileCopyPreferred @archFileId,@commCellId,0,1,1,@l_outArchCopyId output,@l_outAFC_isValid output,@l_outAFC_flag output&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;delete from #metaDataList where iarchFileId = @archFileId &amp;#xD;&#xD;&#xA;&#x9;&#x9;and archCopyId &amp;lt;&amp;gt; @l_outArchCopyId &amp;#xD;&#xD;&#xA;&#x9;&#x9;and commCellId = @commCellId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;fetch next from copy_cursor into @archFileId, @commCellId&amp;#xD;&#xD;&#xA;end&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;close copy_cursor&amp;#xD;&#xD;&#xA;deallocate copy_cursor&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select  cast(iMountPathId as varchar(max)) MountPathId&amp;#xD;&#xD;&#xA;&#x9;&#x9;,cast(iVolumeId as varchar(max)) VolumeId&amp;#xD;&#xD;&#xA;&#x9;&#x9;,cast(hasStore as varchar(max)) hasStore&amp;#xD;&#xD;&#xA;&#x9;&#x9;,cast(iarchFileId as varchar(max)) archFileId&amp;#xD;&#xD;&#xA;&#x9;&#x9;,cast(iarchChunkId as varchar(max)) archChunkId&amp;#xD;&#xD;&#xA;&#x9;&#x9;,cast(physicalOffset as varchar(max)) physicalOffset&amp;#xD;&#xD;&#xA;&#x9;&#x9;,cclip &amp;#xD;&#xD;&#xA;from #metaDataList&amp;#xD;&#xD;&#xA;order by iMountPathId, iVolumeId, iarchFileId, iarchChunkId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if object_id(''tempdb.dbo.#mountPathList'') is not null drop table #mountPathList&amp;#xD;&#xD;&#xA;create table #mountPathList(mountPathId int, clientId int)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;;with cte as&amp;#xD;&#xD;&#xA;(   select mp.MountPathId, dc.ClientId&amp;#xD;&#xD;&#xA;    from #metaDataList mdl&amp;#xD;&#xD;&#xA;    join MMMountPath(nolock) mp on mp.MountPathId = mdl.iMountPathId&amp;#xD;&#xD;&#xA;    left join MMMountPathToStorageDevice(nolock) mpsd on mpsd.MountPathId = mp.MountPathId&amp;#xD;&#xD;&#xA;    left join MMDeviceController(nolock) dc on dc.DeviceId = mpsd.DeviceId&amp;#xD;&#xD;&#xA;    where dc.DeviceControllerEnabled = 1&amp;#xD;&#xD;&#xA;    group by mp.MountPathId, dc.ClientId)&amp;#xD;&#xD;&#xA;insert into #mountPathList&amp;#xD;&#xD;&#xA;select MountPathId, min(ClientId) ClientId&amp;#xD;&#xD;&#xA;from cte&amp;#xD;&#xD;&#xA;group by MountPathId&amp;#xD;&#xD;&#xA;union&amp;#xD;&#xD;&#xA;select distinct dl.iMountPathId, 0&amp;#xD;&#xD;&#xA;from #metaDataList dl&amp;#xD;&#xD;&#xA;left join cte on dl.iMountPathId = cte.MountPathId&amp;#xD;&#xD;&#xA;where cte.MountPathId is null&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if object_id(''tempdb.dbo.#mountPathInfo'') is not null drop table #mountPathInfo&amp;#xD;&#xD;&#xA;create table #mountPathInfo (MountPathId int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, MountPathName nvarchar(max)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, clientId int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, clientName nvarchar(max)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, rowNumber int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, chunkCount int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;insert into #mountPathInfo&amp;#xD;&#xD;&#xA;select sub2.MountPathId, ''['' + l.AliasName + ''] '' + mp.MountPathName MountPathName&amp;#xD;&#xD;&#xA;    , sub2.ClientId&amp;#xD;&#xD;&#xA;    , ac.name clientname&amp;#xD;&#xD;&#xA;    , row_number() over (order by (select 1)) rowNumber&amp;#xD;&#xD;&#xA;    , 0&amp;#xD;&#xD;&#xA;from #mountPathList sub2&amp;#xD;&#xD;&#xA;left join APP_Client(nolock) ac on ac.id = sub2.ClientId&amp;#xD;&#xD;&#xA;left join MMMountPath(nolock) mp on mp.MountPathId = sub2.MountPathId&amp;#xD;&#xD;&#xA;left join MMLibrary(nolock) l on l.libraryid = mp.libraryid&amp;#xD;&#xD;&#xA;order by case when ac.name is null then 0 else 1 end, mountPathId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;;with cte as &amp;#xD;&#xD;&#xA;(select m.MountPathId, count(iarchChunkId) chunkCount&amp;#xD;&#xD;&#xA;from #mountPathInfo m&amp;#xD;&#xD;&#xA;join #metaDataList md on md.iMountPathId = m.mountPathId&amp;#xD;&#xD;&#xA;group by m.mountPathId)&amp;#xD;&#xD;&#xA;update m&amp;#xD;&#xD;&#xA;set chunkCount = cte.chunkCount&amp;#xD;&#xD;&#xA;from #mountPathInfo m&amp;#xD;&#xD;&#xA;join cte on cte.mountPathId = m.mountPathId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select CAST(rowNumber as varchar(max)) rowNumber&amp;#xD;&#xD;&#xA;&#x9;,CAST(mountpath as varchar(max)) MountPathId&amp;#xD;&#xD;&#xA;&#x9;,mpi.MountPathName MountPathName&amp;#xD;&#xD;&#xA;&#x9;, cast(di.DeviceTypeId as varchar(max)) DeviceTypeId&amp;#xD;&#xD;&#xA;&#x9;, cast(mpi.ChunkCount as varchar(max)) ChunkCount&amp;#xD;&#xD;&#xA;&#x9;, cast(mpi.clientId as varchar(max)) clientId&amp;#xD;&#xD;&#xA;&#x9;, mpi.clientName clientName&amp;#xD;&#xD;&#xA;from #mountPathInfo mpi&amp;#xD;&#xD;&#xA;join #tempDeviceInfo di on di.mountpath = mpi.MountPathId&amp;#xD;&#xD;&#xA;order by mpi.MountPathId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select distinct cast(clientId as varchar(max)) clientId, clientName&amp;#xD;&#xD;&#xA;from #mountPathInfo&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select 0 numJobs, 0 size&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="Script_85" commented="0" description="" originalStyle="" points="" sourceX="721" sourceY="80" status="0" style="defaultEdge" targetX="911" targetY="91" transitionIndex="0" x="0" y="0" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578605018524" description="if/else based decision" displayName="Debug" height="57" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_12" waitSetting="0" width="66" x="1179" y="92">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;1 == xpath:{/workflow/variables/iDebugMode}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_10" commented="0" description="" originalStyle="" points="" sourceX="396" sourceY="80" status="0" style="defaultEdge" targetX="511" targetY="82" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="CommServDBQuery_34" commented="0" description="" displayName="Enabled" offsetX="-9" offsetY="-20" originalStyle="" points="1295.0,75.0" sourceX="396" sourceY="80" status="0" style="defaultEdge" targetX="714" targetY="76" transitionIndex="0" value="true" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578605275489" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_10" waitSetting="0" width="117" x="1288" y="103">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="CommServDBQuery_34" commented="0" description="" originalStyle="" points="" sourceX="530" sourceY="80" status="0" style="defaultEdge" targetX="739" targetY="81" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578606034364" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_9" waitSetting="0" width="113" x="1741" y="103">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="EndUserSession_8" commented="0" description="" originalStyle="" points="" sourceX="693" sourceY="120" status="0" style="defaultEdge" targetX="851" targetY="120" transitionIndex="0" x="0" y="0" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578606055193" description="activity to execute code snippets in the selected language" displayName="Get Recall Data" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_69" waitSetting="0" width="116" x="2049" y="103">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;workflow.setVariable(&amp;quot;dBackupRecallDataset1&amp;quot;, xpath:{/workflow/CommServDBQuery_34/resultSets}.get(0));&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;dBackupRecallDataset2&amp;quot;, xpath:{/workflow/CommServDBQuery_34/resultSets}.get(1));&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;dBackupRecallDataset3&amp;quot;, xpath:{/workflow/CommServDBQuery_34/resultSets}.get(2));&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;dBackupRecallDataset4&amp;quot;, xpath:{/workflow/CommServDBQuery_34/resultSets}.get(3));&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_46" commented="0" description="" originalStyle="" points="3073.0,236.0" sourceX="1949" sourceY="120" status="0" style="defaultEdge" targetX="2618" targetY="313" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578612270497" description="displays an informational message to the user" displayName="Error" height="34" interactive="0" jobMode="0" name="InformationalMessage" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity" uniqueName="InformationalMessage_1" waitSetting="0" width="59" x="1623" y="43">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

          <outputs name="outputs">

            <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;message&gt;Failed to get recall data&lt;/message&gt;&lt;dialogType&gt;Popup&lt;/dialogType&gt;&lt;iconType&gt;Error&lt;/iconType&gt;&lt;title&gt;Error&lt;/title&gt;&lt;html&gt;false&lt;/html&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578693337234" description="if/else based decision" displayName="Debug" height="57" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_14" waitSetting="0" width="66" x="1190" y="191">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;1 == xpath:{/workflow/variables/iDebugMode}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_26" commented="0" description="" originalStyle="" points="" sourceX="853" sourceY="219" status="0" style="defaultEdge" targetX="975" targetY="219" transitionIndex="0" value="false" x="633" y="-1">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="CommServDBQuery_30" commented="0" description="" displayName="Enabled" offsetX="-5" offsetY="-13" originalStyle="" points="1345.0,167.0" sourceX="667" sourceY="220" status="0" style="defaultEdge" targetX="998" targetY="228" transitionIndex="0" value="true" x="193" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578693355338" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_26" waitSetting="0" width="117" x="1277" y="202">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="CommServDBQuery_30" commented="0" description="" originalStyle="" points="" sourceX="1005" sourceY="219" status="0" style="defaultEdge" targetX="1111" targetY="217" transitionIndex="0" x="633" y="-1">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578693454870" description="activity to execute code snippets in the selected language" displayName="Determine Agent" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_76" waitSetting="0" width="125" x="1584" y="202">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/CommServDBQuery_30/resultSets/rowCount} &amp;gt; 0)&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;return false;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="InformationalMessage_7" commented="0" description="" displayName="Agent information unknown" originalStyle="" points="" sourceX="1400" sourceY="219" status="0" style="defaultEdge" targetX="1406" targetY="295" transitionIndex="0" x="0" y="0">

          <condition language="1" script="false == xpath:{/workflow/Script_76/output}" />

        </transition>

        <transition activity="CommServDBQuery_39" commented="0" description="" displayName="Generic" offsetX="19" offsetY="0" originalStyle="" points="" sourceX="1522" sourceY="219" status="0" style="defaultEdge" targetX="1765" targetY="221" transitionIndex="0" x="0" y="1">

          <condition language="1" script="true == xpath:{/workflow/Script_76/output} &amp;&amp; 0 == xpath:{/workflow/CommServDBQuery_30/resultSets/row[1]/col[1]}" />

        </transition>

        <transition activity="CommServDBQuery_42" commented="0" description="" displayName="SQL" offsetX="14" offsetY="92" originalStyle="" points="1731.0,307.0" sourceX="1522" sourceY="219" status="0" style="defaultEdge" targetX="1786" targetY="392" transitionIndex="0" x="0" y="0">

          <condition language="1" script="true == xpath:{/workflow/Script_76/output} &amp;&amp; 81 == xpath:{/workflow/CommServDBQuery_30/resultSets/row[1]/col[1]}" />

        </transition>

        <transition activity="CommServDBQuery_38" commented="0" description="" displayName="Virtual &#xA;Server" offsetX="15" offsetY="49" originalStyle="" points="1731.0,262.0" sourceX="1400" sourceY="219" status="0" style="defaultEdge" targetX="1640" targetY="222" transitionIndex="0" x="0" y="0">

          <condition language="1" script="true == xpath:{/workflow/Script_76/output} &amp;&amp; 106 == xpath:{/workflow/CommServDBQuery_30/resultSets/row[1]/col[1]}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578693559839" description="executes queries against a commcell database" displayName="Get Copies" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_37" waitSetting="0" width="91" x="550" y="154">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @jobIds table(jobid int)&amp;#xD;&#xD;&#xA;declare @jobId int = xpath:{/workflow/variables/iJobId}&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;insert into @jobIds&amp;#xD;&#xD;&#xA;select parentjobid&amp;#xD;&#xD;&#xA;from JMJobDataLink(nolock)&amp;#xD;&#xD;&#xA;where childjobId = @jobId&amp;#xD;&#xD;&#xA;union&amp;#xD;&#xD;&#xA;select @jobid&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select distinct cast(agc.id as varchar(max)), ''['' + ag.name + ''] '' + agc.name val&amp;#xD;&#xD;&#xA;from archChunkMapping(nolock) acm&amp;#xD;&#xD;&#xA;join archGroupCopy(nolock) agc on agc.id = acm.archCopyId&amp;#xD;&#xD;&#xA;join archGroup(nolock) ag on ag.id = agc.archGroupId&amp;#xD;&#xD;&#xA;join archChunk(nolock) ac on ac.id = acm.archChunkId&amp;#xD;&#xD;&#xA;join MMVolume(nolock) mv on mv.VolumeId = ac.volumeId&amp;#xD;&#xD;&#xA;join MMMountPath(nolock) mp on mv.MediaSideId = mp.MediaSideId&amp;#xD;&#xD;&#xA;join MMMountPathToStorageDevice(nolock) msd on mp.MountPathId = msd.MountPathId&amp;#xD;&#xD;&#xA;join MMDevice(nolock) d on d.DeviceId = msd.DeviceId&amp;#xD;&#xD;&#xA;join @jobIds j on j.jobId = acm.jobId&amp;#xD;&#xD;&#xA;where d.DeviceTypeId &amp;lt;&amp;gt; 1&amp;#xD;&#xD;&#xA;&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="EnableLogging_26" commented="0" description="" originalStyle="" points="" sourceX="608" sourceY="219" status="0" style="defaultEdge" targetX="712" targetY="219" transitionIndex="0" x="379" y="-1">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578693590335" description="popups an input form for the user to fill out" displayName="Get Copies" height="34" interactive="0" jobMode="0" name="PopupInput" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.InteractiveInputActivity" uniqueName="PopupInput_11" waitSetting="0" width="91" x="926" y="154">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="">

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="2" defaultValue="" displayName="Select Copy/Copies" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="copy" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

              <options val="xpath:{/workflow/CommServDBQuery_37/resultSets/row/col[1]}" />

              <labelsForOptions val="xpath:{/workflow/CommServDBQuery_37/resultSets/row/col[2]}" />

            </children>

          </inputs>

          <outputs className="" defaultValue="" listType="0" name="outputs" type="">

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="2" defaultValue="" displayName="Select Copy/Copies" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="copy" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

              <options val="xpath:{/workflow/CommServDBQuery_37/resultSets/row/col[1]}" />

              <labelsForOptions val="xpath:{/workflow/CommServDBQuery_37/resultSets/row/col[2]}" />

            </children>

            <children className="java.lang.Boolean" inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean" />

            <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;copy class=&quot;java.lang.String&quot; _list_=&quot;true&quot; /&gt;&lt;/inputs&gt;&lt;subject&gt;User Inputs&lt;/subject&gt;&lt;/inputs&gt;" />

        <transition activity="Script_79" commented="0" description="" originalStyle="" points="" sourceX="849" sourceY="219" status="0" style="defaultEdge" targetX="1146" targetY="332" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <properties css="" formVersion="0" javaScript="" pageMode="0">

          <rules />

        </properties>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578927647695" description="displays an informational message to the user" displayName="Get Copies" height="34" interactive="0" jobMode="0" name="InformationalMessage" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity" uniqueName="InformationalMessage_6" waitSetting="0" width="91" x="805" y="221">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

          <outputs name="outputs">

            <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;message&gt;No copies with data on cloud storage found for the entered Backup Job Id xpath:{/workflow/variables/iJobId}. Please verify the entered Job Id.&lt;/message&gt;&lt;dialogType&gt;Popup&lt;/dialogType&gt;&lt;iconType&gt;Information&lt;/iconType&gt;&lt;title&gt;Error&lt;/title&gt;&lt;html&gt;false&lt;/html&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578927667379" description="activity to execute code snippets in the selected language" displayName="Get Copies" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_77" waitSetting="0" width="91" x="805" y="154">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(0 == xpath:{/workflow/CommServDBQuery_37/resultSets/rowCount})&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    return false;   &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;return true;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="InformationalMessage_6" commented="0" description="" originalStyle="" points="" sourceX="728" sourceY="219" status="0" style="defaultEdge" targetX="738" targetY="284" transitionIndex="0" x="0" y="0">

          <condition language="1" script="false == xpath:{/workflow/Script_77/output}" />

        </transition>

        <transition activity="PopupInput_11" commented="0" description="" originalStyle="" points="" sourceX="728" sourceY="219" status="0" style="defaultEdge" targetX="975" targetY="240" transitionIndex="0" x="0" y="0">

          <condition language="1" script="true == xpath:{/workflow/Script_77/output}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578928518194" description="executes queries against a commcell database" displayName="Get VMs" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_38" waitSetting="0" width="77" x="1856" y="298">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @jobIds table(jobid int)&amp;#xD;&#xD;&#xA;declare @jobId int = xpath:{/workflow/variables/iJobId}&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @vmFilter int = 0&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;insert into @jobIds&amp;#xD;&#xD;&#xA;select parentjobid&amp;#xD;&#xD;&#xA;from JMJobDataLink(nolock)&amp;#xD;&#xD;&#xA;where childjobId = @jobId&amp;#xD;&#xD;&#xA;union&amp;#xD;&#xD;&#xA;select @jobid&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if exists (select 1&amp;#xD;&#xD;&#xA;    from JMJobDataLink(nolock)&amp;#xD;&#xD;&#xA;    where childjobId = @jobId)&amp;#xD;&#xD;&#xA; begin&amp;#xD;&#xD;&#xA;    set @vmFilter = (select top 1 ap.clientId&amp;#xD;&#xD;&#xA;         from archfile(nolock) af&amp;#xD;&#xD;&#xA;         join app_application(nolock) ap on ap.id = af.appId&amp;#xD;&#xD;&#xA;         where jobid = @jobId)&amp;#xD;&#xD;&#xA; end&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select distinct cast(c.id as varchar(max)), c.name&amp;#xD;&#xD;&#xA;from APP_VMProp(nolock) vm&amp;#xD;&#xD;&#xA;join APP_Client(nolock) c on c.id = vm.VMclientId&amp;#xD;&#xD;&#xA;join @jobIds j on j.jobId = vm.jobId&amp;#xD;&#xD;&#xA;where @vmFilter = 0 or c.id = @vmFilter&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="EnableLogging_23" commented="0" description="" originalStyle="" points="" sourceX="1894" sourceY="315" status="0" style="defaultEdge" targetX="2015" targetY="315" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578928582295" description="displays an informational message to the user" displayName="Determine Agent" height="34" interactive="0" jobMode="0" name="InformationalMessage" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity" uniqueName="InformationalMessage_7" waitSetting="0" width="125" x="1583" y="282">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

          <outputs name="outputs">

            <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;message /&gt;&lt;dialogType&gt;Popup&lt;/dialogType&gt;&lt;iconType&gt;Information&lt;/iconType&gt;&lt;title /&gt;&lt;html&gt;false&lt;/html&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578928801147" description="popups an input form for the user to fill out" displayName="Get VM" height="34" interactive="0" jobMode="0" name="PopupInput" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.InteractiveInputActivity" uniqueName="PopupInput_12" waitSetting="0" width="70" x="2112" y="298">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="">

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="2" defaultValue="" displayName="Select VM(s)" documentation="" hidden="0" inputType="java.lang.String" listType="1" maximumValue="" minimumValue="" name="VMs" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

              <options val="xpath:{/workflow/CommServDBQuery_38/resultSets/row/col[1]}" />

              <labelsForOptions val="xpath:{/workflow/CommServDBQuery_38/resultSets/row/col[2]}" />

            </children>

          </inputs>

          <outputs className="" defaultValue="" listType="0" name="outputs" type="">

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="2" defaultValue="" displayName="Select VM(s)" documentation="" hidden="0" inputType="java.lang.String" listType="1" maximumValue="" minimumValue="" name="VMs" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

              <options val="xpath:{/workflow/CommServDBQuery_38/resultSets/row/col[1]}" />

              <labelsForOptions val="xpath:{/workflow/CommServDBQuery_38/resultSets/row/col[2]}" />

            </children>

            <children className="java.lang.Boolean" inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean" />

            <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;VMs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;&lt;subject&gt;User Inputs&lt;/subject&gt;&lt;/inputs&gt;" />

        <transition activity="Script_78" commented="0" description="" originalStyle="" points="" sourceX="2147" sourceY="315" status="0" style="defaultEdge" targetX="2248" targetY="315" transitionIndex="0" x="401" y="67">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <properties css="" formVersion="0" javaScript="" pageMode="0">

          <rules />

        </properties>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578928868110" description="activity to execute code snippets in the selected language" displayName="Get VM" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_78" waitSetting="0" width="70" x="2213" y="298">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    ip = xpath:{/workflow/PopupInput_12/VMs};&amp;#xD;&amp;#xA;    String idList = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;    if(ip instanceof Vector) {&amp;#xD;&amp;#xA;        for (int i = 0; i &amp;lt; ip.size(); i++) {&amp;#xD;&amp;#xA;            idList += ip.get(i); &amp;#xD;&amp;#xA;            if(i &amp;lt; ip.size() - 1) idList += &amp;quot;,&amp;quot;;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    else {&amp;#xD;&amp;#xA;        idList += ip;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Input VMs [&amp;quot; + idList + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    return idList;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String err = &amp;quot;Exception &amp;quot; + e;&amp;#xD;&amp;#xA;    logger.info(err);&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="CommServDBQuery_60" commented="0" description="" originalStyle="" points="" sourceX="2118" sourceY="287" status="0" style="defaultEdge" targetX="2217" targetY="287" transitionIndex="0" x="0" y="0">

          <condition language="1" script="!xpath:{/workflow/Script_78/output}.isEmpty()" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578928990074" description="activity to execute code snippets in the selected language" displayName="Get Copies" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_79" waitSetting="0" width="100" x="1040" y="154">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    ip = xpath:{/workflow/PopupInput_11/copy};&amp;#xD;&amp;#xA;    String idList = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;    if(ip instanceof Vector)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        for (int i = 0; i &amp;lt; ip.size(); i++)&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            idList += ip.get(i); &amp;#xD;&amp;#xA;            if(i &amp;lt; ip.size() - 1) idList += &amp;quot;,&amp;quot;;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        idList += ip;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Input Copy/Copies [&amp;quot; + idList + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;    return idList;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String err = &amp;quot;Exception &amp;quot; + e;&amp;#xD;&amp;#xA;    logger.info(err);&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;    &quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="InformationalMessage_8" commented="0" description="" originalStyle="" points="" sourceX="968" sourceY="219" status="0" style="defaultEdge" targetX="974" targetY="287" transitionIndex="0" x="0" y="0">

          <condition language="1" script="xpath:{/workflow/Script_79/output}.isEmpty()" />

        </transition>

        <transition activity="Decision_14" commented="0" description="" originalStyle="" points="" sourceX="1042" sourceY="171" status="0" style="defaultEdge" targetX="1216" targetY="225" transitionIndex="0" x="0" y="0">

          <condition language="4" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578929072624" description="displays an informational message to the user" displayName="Get Copies" height="34" interactive="0" jobMode="0" name="InformationalMessage" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity" uniqueName="InformationalMessage_8" waitSetting="0" width="91" x="1042" y="226">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

          <outputs name="outputs">

            <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;message&gt;Error generating query for recalling files.&lt;/message&gt;&lt;dialogType&gt;Popup&lt;/dialogType&gt;&lt;iconType&gt;Information&lt;/iconType&gt;&lt;title&gt;Error&lt;/title&gt;&lt;html&gt;false&lt;/html&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578929190510" description="executes queries against a commcell database" displayName="Get Recall Data" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_39" waitSetting="0" width="116" x="1848" y="202">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;if object_id(''tempdb.dbo.#afList'') is not null drop table #afList&amp;#xD;&#xD;&#xA;create table #afList(afId int, chunkId int default 0)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;insert into #afList(afId, chunkId)&amp;#xD;&#xD;&#xA;select id, acm.archChunkId from archFile(nolock) af&amp;#xD;&#xD;&#xA;join archChunkMapping(nolock) acm on acm.archFileId = af.id&amp;#xD;&#xD;&#xA;where af.isValid &amp;gt; 0&amp;#xD;&#xD;&#xA;and acm.archCopyId in (xpath:{/workflow/Script_79/output})&amp;#xD;&#xD;&#xA;and af.jobId = xpath:{/workflow/variables/iJobId}&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if object_id(''tempdb.dbo.#tempDeviceInfo'') is not null drop table #tempDeviceInfo&amp;#xD;&#xD;&#xA;create table #tempDeviceInfo (DeviceId int, DeviceTypeId int, Folder varchar(2048), mountpath bigint&amp;#xD;&#xD;&#xA;--, username nvarchar(max), password nvarchar(max)&amp;#xD;&#xD;&#xA;)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;insert into #tempDeviceInfo &amp;#xD;&#xD;&#xA;select distinct d.DeviceId, d.DeviceTypeId, dc.Folder, mp.MountPathId--, dc.UserName, dc.UserPassword&amp;#xD;&#xD;&#xA;from MMMountPath(nolock) mp&amp;#xD;&#xD;&#xA;join MMMountPathToStorageDevice(nolock) mpsd on mpsd.MountPathId = mp.MountPathId&amp;#xD;&#xD;&#xA;join MMDevice(nolock) d on d.DeviceId = mpsd.DeviceId&amp;#xD;&#xD;&#xA;join MMDeviceController(nolock) dc ON dc.DeviceId = d.DeviceId&amp;#xD;&#xD;&#xA;where d.DeviceTypeId &amp;lt;&amp;gt; 1&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @azureMode int = -3;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if object_id(''tempdb.dbo.#metaDataList'') is not null drop table #metaDataList&amp;#xD;&#xD;&#xA;create table #metaDataList (iMountPathId int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, iVolumeId int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, hasStore int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, iarchFileId int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, iarchChunkId bigint&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, physicalOffset bigint&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, DeviceTypeId int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, cclip varchar(max)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, archCopyId smallint&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, physicalSizeMB int&amp;#xD;&#xD;&#xA;                                                , jobId int);&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;insert into #metaDataList&amp;#xD;&#xD;&#xA;select distinct MP.MountPathId&amp;#xD;&#xD;&#xA;                , mv.VolumeId&amp;#xD;&#xD;&#xA;                , case mv.SIDBStoreId when 0 then 0 else 1 end as hasStore&amp;#xD;&#xD;&#xA;                , acm.archFileId&amp;#xD;&#xD;&#xA;                , acm.archChunkId&amp;#xD;&#xD;&#xA;                , acm.physicalOffset&amp;#xD;&#xD;&#xA;                , d.DeviceTypeId&amp;#xD;&#xD;&#xA;                , case d.DeviceTypeId when 53 then ac.cclip else '''' end cclip&amp;#xD;&#xD;&#xA;                , acm.archCopyId&amp;#xD;&#xD;&#xA;                , acm.physicalSize / power(1024, 2)&amp;#xD;&#xD;&#xA;                    , acm.jobId&amp;#xD;&#xD;&#xA;from    #afList(nolock) af &amp;#xD;&#xD;&#xA;join    archChunkMapping(nolock) acm on acm.archFileId = af.afId and (acm.archChunkId = af.chunkId or af.chunkId = 0)&amp;#xD;&#xD;&#xA;join    archChunk(nolock) ac on ac.id = acm.archChunkId and ac.commCellId = acm.chunkCommCellId&amp;#xD;&#xD;&#xA;join    MMVolume(nolock) mv on mv.VolumeId = ac.volumeId&amp;#xD;&#xD;&#xA;join    MMMountPath(nolock) mp on mv.MediaSideId = mp.MediaSideId&amp;#xD;&#xD;&#xA;join    MMMountPathToStorageDevice(nolock) msd on mp.MountPathId = msd.MountPathId&amp;#xD;&#xD;&#xA;join    #tempDeviceInfo(nolock) d on msd.DeviceId = d.DeviceId&amp;#xD;&#xD;&#xA;where    (@azureMode &amp;lt;&amp;gt; -1 or (@azureMode = -1 and d.DeviceTypeId = 3))&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;--declare @rc int = (select count(*) from #metaDataList);&amp;#xD;&#xD;&#xA;--select @rc;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select  cast(iMountPathId as varchar(max)) MountPathId&amp;#xD;&#xD;&#xA;&#x9;&#x9;,cast(iVolumeId as varchar(max)) VolumeId&amp;#xD;&#xD;&#xA;&#x9;&#x9;,cast(hasStore as varchar(max)) hasStore&amp;#xD;&#xD;&#xA;&#x9;&#x9;,cast(iarchFileId as varchar(max)) archFileId&amp;#xD;&#xD;&#xA;&#x9;&#x9;,cast(iarchChunkId as varchar(max)) archChunkId&amp;#xD;&#xD;&#xA;&#x9;&#x9;,cast(physicalOffset as varchar(max)) physicalOffset&amp;#xD;&#xD;&#xA;&#x9;&#x9;,cclip &amp;#xD;&#xD;&#xA;from #metaDataList&amp;#xD;&#xD;&#xA;order by iMountPathId, iVolumeId, iarchFileId, iarchChunkId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if object_id(''tempdb.dbo.#mountPathList'') is not null drop table #mountPathList&amp;#xD;&#xD;&#xA;create table #mountPathList(mountPathId int, clientId int)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;;with cte as&amp;#xD;&#xD;&#xA;(   select mp.MountPathId, dc.ClientId&amp;#xD;&#xD;&#xA;    from #metaDataList mdl&amp;#xD;&#xD;&#xA;    join MMMountPath(nolock) mp on mp.MountPathId = mdl.iMountPathId&amp;#xD;&#xD;&#xA;    left join MMMountPathToStorageDevice(nolock) mpsd on mpsd.MountPathId = mp.MountPathId&amp;#xD;&#xD;&#xA;    left join MMDeviceController(nolock) dc on dc.DeviceId = mpsd.DeviceId&amp;#xD;&#xD;&#xA;    where dc.DeviceControllerEnabled = 1&amp;#xD;&#xD;&#xA;    group by mp.MountPathId, dc.ClientId)&amp;#xD;&#xD;&#xA;insert into #mountPathList&amp;#xD;&#xD;&#xA;select MountPathId, min(ClientId) ClientId&amp;#xD;&#xD;&#xA;from cte&amp;#xD;&#xD;&#xA;group by MountPathId&amp;#xD;&#xD;&#xA;union&amp;#xD;&#xD;&#xA;select distinct dl.iMountPathId, 0&amp;#xD;&#xD;&#xA;from #metaDataList dl&amp;#xD;&#xD;&#xA;left join cte on dl.iMountPathId = cte.MountPathId&amp;#xD;&#xD;&#xA;where cte.MountPathId is null&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if object_id(''tempdb.dbo.#mountPathInfo'') is not null drop table #mountPathInfo&amp;#xD;&#xD;&#xA;create table #mountPathInfo (MountPathId int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, MountPathName nvarchar(max)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, clientId int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, clientName nvarchar(max)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, rowNumber int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;, chunkCount int&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;insert into #mountPathInfo&amp;#xD;&#xD;&#xA;select sub2.MountPathId, ''['' + l.AliasName + ''] '' + mp.MountPathName MountPathName&amp;#xD;&#xD;&#xA;    , sub2.ClientId&amp;#xD;&#xD;&#xA;    , ac.name clientname&amp;#xD;&#xD;&#xA;    , row_number() over (order by (select 1)) rowNumber&amp;#xD;&#xD;&#xA;    , 0&amp;#xD;&#xD;&#xA;from #mountPathList sub2&amp;#xD;&#xD;&#xA;left join APP_Client(nolock) ac on ac.id = sub2.ClientId&amp;#xD;&#xD;&#xA;left join MMMountPath(nolock) mp on mp.MountPathId = sub2.MountPathId&amp;#xD;&#xD;&#xA;left join MMLibrary(nolock) l on l.libraryid = mp.libraryid&amp;#xD;&#xD;&#xA;order by case when ac.name is null then 0 else 1 end, mountPathId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;;with cte as &amp;#xD;&#xD;&#xA;(select m.MountPathId, count(iarchChunkId) chunkCount&amp;#xD;&#xD;&#xA;from #mountPathInfo m&amp;#xD;&#xD;&#xA;join #metaDataList md on md.iMountPathId = m.mountPathId&amp;#xD;&#xD;&#xA;group by m.mountPathId)&amp;#xD;&#xD;&#xA;update m&amp;#xD;&#xD;&#xA;set chunkCount = cte.chunkCount&amp;#xD;&#xD;&#xA;from #mountPathInfo m&amp;#xD;&#xD;&#xA;join cte on cte.mountPathId = m.mountPathId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select CAST(rowNumber as varchar(max)) rowNumber&amp;#xD;&#xD;&#xA;&#x9;,CAST(mountpath as varchar(max)) MountPathId&amp;#xD;&#xD;&#xA;&#x9;,mpi.MountPathName MountPathName&amp;#xD;&#xD;&#xA;&#x9;, cast(di.DeviceTypeId as varchar(max)) DeviceTypeId&amp;#xD;&#xD;&#xA;&#x9;, cast(mpi.ChunkCount as varchar(max)) ChunkCount&amp;#xD;&#xD;&#xA;&#x9;, cast(mpi.clientId as varchar(max)) clientId&amp;#xD;&#xD;&#xA;&#x9;, mpi.clientName clientName&amp;#xD;&#xD;&#xA;from #mountPathInfo mpi&amp;#xD;&#xD;&#xA;join #tempDeviceInfo di on di.mountpath = mpi.MountPathId&amp;#xD;&#xD;&#xA;order by mpi.MountPathId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select distinct cast(clientId as varchar(max)) clientId, clientName&amp;#xD;&#xD;&#xA;from #mountPathInfo&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select count(distinct jobId) numJobs, sum(physicalSizeMB) / 1024 as size&amp;#xD;&#xD;&#xA;from #metaDataList&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="Script_86" commented="0" description="" originalStyle="" points="" sourceX="1782" sourceY="219" status="0" style="defaultEdge" targetX="1914" targetY="214" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578929457450" description="activity to execute code snippets in the selected language" displayName="Get Recall Data" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_80" waitSetting="0" width="116" x="2300" y="202">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;workflow.setVariable(&amp;quot;dBackupRecallDataset1&amp;quot;, xpath:{/workflow/CommServDBQuery_39/resultSets}.get(0));&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;dBackupRecallDataset2&amp;quot;, xpath:{/workflow/CommServDBQuery_39/resultSets}.get(1));&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;dBackupRecallDataset3&amp;quot;, xpath:{/workflow/CommServDBQuery_39/resultSets}.get(2));&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;dBackupRecallDataset4&amp;quot;, xpath:{/workflow/CommServDBQuery_39/resultSets}.get(3));&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_46" commented="0" description="" originalStyle="" points="3013.0,284.0" sourceX="2358" sourceY="219" status="0" style="defaultEdge" targetX="2603" targetY="320" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578929804222" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_22" waitSetting="0" width="113" x="2151" y="202">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Script_80" commented="0" description="" originalStyle="" points="" sourceX="1933" sourceY="219" status="0" style="defaultEdge" targetX="2103" targetY="219" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578929820909" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_23" waitSetting="0" width="113" x="1973" y="298">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="PopupInput_12" commented="0" description="" originalStyle="" points="" sourceX="1899" sourceY="287" status="0" style="defaultEdge" targetX="2034" targetY="284" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578930105610" description="executes a defined process block within the workflow" displayName="Process Backup Recall Data" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#FAD39E;gradientColor=#FAD39E" uniqueName="ExecuteProcessBlock_46" waitSetting="0" width="191" x="2965" y="298">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

          <outputs name="ProcessBlock_29">

            <children name="Start_35" />

            <children name="Script_65">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="Script_72">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="InformationalMessage_2">

              <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="InformationalMessage_3">

              <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="EndUserSession_4" />

            <children name="Script_74">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="DisableLogging_30" />

            <children name="Script_175">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="Script_181">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="InformationalMessage_13">

              <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;processBlock&gt;ProcessBlock_29&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="Decision_45" commented="0" description="" originalStyle="" points="" sourceX="2614" sourceY="315" status="0" style="defaultEdge" targetX="2789" targetY="321" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578930242020" description="executes queries against a commcell database" displayName="Get DBs" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_42" waitSetting="0" width="75" x="1858" y="386">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;select distinct cast(sn2.id as varchar(max)), sn2.name&amp;#xD;&#xD;&#xA;from sqlarchiveinfo s &amp;#xD;&#xD;&#xA;join sqlDbBackupInfo i on i.id = s.sqlDbBackupFileId&amp;#xD;&#xD;&#xA;join sqlNames sn1 on i.sqlnameid = sn1.id&amp;#xD;&#xD;&#xA;join sqlNames2 sn2 on sn1.sqlid = sn2.id&amp;#xD;&#xD;&#xA;where s.backupJobId = xpath:{/workflow/variables/iJobId}&amp;#xD;&#xD;&#xA;order by sn2.name&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="EnableLogging_24" commented="0" description="" originalStyle="" points="" sourceX="1895" sourceY="403" status="0" style="defaultEdge" targetX="1976" targetY="400" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578930276164" description="popups an input form for the user to fill out" displayName="Get DB" height="34" interactive="0" jobMode="0" name="PopupInput" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.InteractiveInputActivity" uniqueName="PopupInput_14" waitSetting="0" width="68" x="2113" y="386">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="">

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="2" defaultValue="" displayName="Select DB(s)" documentation="" hidden="0" inputType="java.lang.String" listType="1" maximumValue="" minimumValue="" name="DBs" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

              <options val="xpath:{/workflow/CommServDBQuery_42/resultSets/row/col[1]}" />

              <labelsForOptions val="xpath:{/workflow/CommServDBQuery_42/resultSets/row/col[2]}" />

            </children>

          </inputs>

          <outputs className="" defaultValue="" listType="0" name="outputs" type="">

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="2" defaultValue="" displayName="Select DB(s)" documentation="" hidden="0" inputType="java.lang.String" listType="1" maximumValue="" minimumValue="" name="DBs" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

              <options val="xpath:{/workflow/CommServDBQuery_42/resultSets/row/col[1]}" />

              <labelsForOptions val="xpath:{/workflow/CommServDBQuery_42/resultSets/row/col[2]}" />

            </children>

            <children className="java.lang.Boolean" inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean" />

            <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;DBs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;&lt;subject&gt;User Inputs&lt;/subject&gt;&lt;/inputs&gt;" />

        <transition activity="Script_82" commented="0" description="" originalStyle="" points="" sourceX="2147" sourceY="403" status="0" style="defaultEdge" targetX="2251" targetY="403" transitionIndex="0" x="379" y="-1">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <properties css="" formVersion="0" javaScript="" pageMode="0">

          <rules />

        </properties>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578930311274" description="activity to execute code snippets in the selected language" displayName="Get DB" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_82" waitSetting="0" width="68" x="2217" y="386">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    ip = xpath:{/workflow/PopupInput_14/DBs};&amp;#xD;&amp;#xA;    String idList = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(ip instanceof Vector) {&amp;#xD;&amp;#xA;        for (int i = 0; i &amp;lt; ip.size(); i++) {&amp;#xD;&amp;#xA;            idList += ip.get(i); &amp;#xD;&amp;#xA;            if(i &amp;lt; ip.size() - 1) idList += &amp;quot;,&amp;quot;;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    else {&amp;#xD;&amp;#xA;        idList += ip;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;Input DBs [&amp;quot; + idList + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    return idList;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    string err = &amp;quot;Exception &amp;quot; + e;&amp;#xD;&amp;#xA;    logger.info(err);&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_64" commented="0" description="" originalStyle="" points="" sourceX="2251" sourceY="403" status="0" style="defaultEdge" targetX="2337" targetY="407" transitionIndex="0" x="0" y="0">

          <condition language="1" script="!xpath:{/workflow/Script_82/output}.isEmpty()" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578930321677" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_24" waitSetting="0" width="113" x="1970" y="386">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="PopupInput_14" commented="0" description="" originalStyle="" points="" sourceX="1896" sourceY="387" status="0" style="defaultEdge" targetX="1989" targetY="382" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578931148781" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_25" waitSetting="0" width="113" x="107" y="154">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Decision_12" commented="0" description="" displayName="Index Recall" offsetX="75" offsetY="-20" originalStyle="" points="136.0,122.0" sourceX="51" sourceY="171" status="0" style="defaultEdge" targetX="220" targetY="120" transitionIndex="0" x="0" y="0">

          <condition language="1" script="xpath:{/workflow/inputs/bIndexOnlyRecall}" />

        </transition>

        <transition activity="Decision_17" commented="0" description="" displayName="Data Recall" offsetX="-1" offsetY="-2" originalStyle="" points="" sourceX="51" sourceY="113" status="0" style="defaultEdge" targetX="132" targetY="114" transitionIndex="0" x="0" y="0">

          <condition language="1" script="!xpath:{/workflow/inputs/bIndexOnlyRecall}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578931201709" description="if/else based decision" displayName="Debug" height="57" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_17" waitSetting="0" width="66" x="315" y="143">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;1 == xpath:{/workflow/variables/iDebugMode}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_38" commented="0" description="" originalStyle="" points="" sourceX="316" sourceY="220" status="0" style="defaultEdge" targetX="318" targetY="284" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="CommServDBQuery_37" commented="0" description="" displayName="Enabled" offsetX="-6" offsetY="27" originalStyle="" points="432.0,235.0" sourceX="346" sourceY="220" status="0" style="defaultEdge" targetX="598" targetY="222" transitionIndex="0" value="true" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578931221252" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_38" waitSetting="0" width="117" x="402" y="154">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="CommServDBQuery_37" commented="0" description="" originalStyle="" points="" sourceX="435" sourceY="220" status="0" style="defaultEdge" targetX="568" targetY="223" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578931229612" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_26" waitSetting="0" width="113" x="665" y="154">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Script_77" commented="0" description="" originalStyle="" points="" sourceX="708" sourceY="282" status="0" style="defaultEdge" targetX="839" targetY="221" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578931684904" description="activity to execute code snippets in the selected language" displayName="Get Recall Data" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_85" waitSetting="0" width="116" x="1594" y="103">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/CommServDBQuery_34/resultSets[1]/rowCount} &amp;gt; 0 &amp;amp;&amp;amp; xpath:{/workflow/CommServDBQuery_34/resultSets[3]/rowCount} &amp;gt; 0)&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;return false;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="EnableLogging_9" commented="0" description="" originalStyle="" points="" sourceX="718" sourceY="79" status="0" style="defaultEdge" targetX="848" targetY="108" transitionIndex="0" x="0" y="0">

          <condition language="1" script="true == xpath:{/workflow/Script_85/output}" />

        </transition>

        <transition activity="InformationalMessage_1" commented="0" description="" originalStyle="" points="" sourceX="782" sourceY="120" status="0" style="defaultEdge" targetX="792" targetY="51" transitionIndex="0" x="0" y="0">

          <condition language="1" script="false == xpath:{/workflow/Script_85/output}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578935760875" description="activity to execute code snippets in the selected language" displayName="Get Recall Data" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_86" waitSetting="0" width="116" x="1998" y="202">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if(xpath:{/workflow/CommServDBQuery_39/resultSets[1]/rowCount} &amp;gt; 0 &amp;amp;&amp;amp; xpath:{/workflow/CommServDBQuery_39/resultSets[3]/rowCount} &amp;gt; 0)&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;return false;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="EnableLogging_22" commented="0" description="" originalStyle="" points="" sourceX="2048" sourceY="219" status="0" style="defaultEdge" targetX="2157" targetY="217" transitionIndex="0" x="0" y="0">

          <condition language="1" script="true == xpath:{/workflow/Script_86/output}" />

        </transition>

        <transition activity="InformationalMessage_9" commented="0" description="" originalStyle="" points="" sourceX="2048" sourceY="219" status="0" style="defaultEdge" targetX="2052" targetY="155" transitionIndex="0" x="0" y="0">

          <condition language="1" script="false == xpath:{/workflow/Script_86/output}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578935776381" description="displays an informational message to the user" displayName="Error" height="34" interactive="0" jobMode="0" name="InformationalMessage" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity" uniqueName="InformationalMessage_9" waitSetting="0" width="59" x="2027" y="148">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

          <outputs name="outputs">

            <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;message&gt;Failed to get recall data&lt;/message&gt;&lt;dialogType&gt;Popup&lt;/dialogType&gt;&lt;iconType&gt;Error&lt;/iconType&gt;&lt;title&gt;Error&lt;/title&gt;&lt;html&gt;false&lt;/html&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1581364852931" description="executes a defined process block within the workflow" displayName="Recall Data Using DB" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#FAD39E;gradientColor=#FAD39E" uniqueName="ExecuteProcessBlock_50" waitSetting="0" width="156" x="2696" y="298">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="">

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sCopyIdList" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sIdList" readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

          </inputs>

          <outputs name="ProcessBlock_30">

            <children name="Start_40" />

            <children name="EnableLogging_27" />

            <children name="Decision_15" />

            <children name="DisableLogging_34" />

            <children name="CommServDBQuery_41" type="">

              <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                    <options val="GALAXY" />

                    <options val="NBU" />

                    <options val="NETAPP" />

                    <options val="TSM" />

                    <options val="VEEAM" />

                  </children>

                  <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                  <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                  <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

              </children>

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Script_81">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="Script_87">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="DisableLogging_40" />

            <children name="EnableLogging_28" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;sCopyIdList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_79/output}&lt;/sCopyIdList&gt;&lt;sIdList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_78/output}&lt;/sIdList&gt;&lt;/inputs&gt;&lt;processBlock&gt;ProcessBlock_30&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_46" commented="0" description="" originalStyle="" points="" sourceX="2404" sourceY="315" status="0" style="defaultEdge" targetX="3210" targetY="322" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1581373194617" description="executes a defined process block within the workflow" displayName="Prepare Recall Commands" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#FAD39E;gradientColor=#FAD39E" uniqueName="ExecuteProcessBlock_56" waitSetting="0" width="182" x="3366" y="298">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="">

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sCloudToolMode" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="iIndexFree" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

          </inputs>

          <outputs name="ProcessBlock_23">

            <children name="Start_25" />

            <children name="CommServDBQuery_15" type="">

              <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                    <options val="GALAXY" />

                    <options val="NBU" />

                    <options val="NETAPP" />

                    <options val="TSM" />

                    <options val="VEEAM" />

                  </children>

                  <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                  <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                  <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

              </children>

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="EnableLogging_16" />

            <children name="DisableLogging_17" />

            <children name="Script_31">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;sCloudToolMode class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;2&lt;/sCloudToolMode&gt;&lt;iIndexFree class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;1&lt;/iIndexFree&gt;&lt;/inputs&gt;&lt;processBlock&gt;ProcessBlock_23&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_57" commented="0" description="" originalStyle="" points="" sourceX="2833" sourceY="315" status="0" style="defaultEdge" targetX="2992" targetY="315" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1581373194651" description="executes a defined process block within the workflow" displayName="Recall Files" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#FAD39E;gradientColor=#FAD39E" uniqueName="ExecuteProcessBlock_57" waitSetting="0" width="94" x="3573" y="298">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

          <outputs name="ProcessBlock_24">

            <children name="Start_28" />

            <children name="EnableLogging_17" />

            <children name="DisableLogging_18" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;processBlock&gt;ProcessBlock_24&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_44" commented="0" description="" originalStyle="" points="" sourceX="2988" sourceY="315" status="0" style="defaultEdge" targetX="3124" targetY="315" transitionIndex="0" x="-57" y="-3604">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1581373194690" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_44" waitSetting="0" width="117" x="3698" y="298">

        <inputs val="&lt;inputs /&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1582156557830" description="executes a defined process block within the workflow" displayName="Recall Data Using DB" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#FAD39E;gradientColor=#FAD39E" uniqueName="ExecuteProcessBlock_64" waitSetting="0" width="156" x="2322" y="386">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="">

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sCopyIdList" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sIdList" readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

          </inputs>

          <outputs name="ProcessBlock_30">

            <children name="Start_40" />

            <children name="EnableLogging_27" />

            <children name="Decision_15" />

            <children name="DisableLogging_34" />

            <children name="CommServDBQuery_41" type="">

              <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                    <options val="GALAXY" />

                    <options val="NBU" />

                    <options val="NETAPP" />

                    <options val="TSM" />

                    <options val="VEEAM" />

                  </children>

                  <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                  <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                  <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

              </children>

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Script_81">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="Script_87">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="DisableLogging_40" />

            <children name="EnableLogging_28" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;sCopyIdList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_79/output}&lt;/sCopyIdList&gt;&lt;sIdList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_82/output}&lt;/sIdList&gt;&lt;/inputs&gt;&lt;processBlock&gt;ProcessBlock_30&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_46" commented="0" description="" originalStyle="" points="3073.0,369.0" sourceX="2400" sourceY="403" status="0" style="defaultEdge" targetX="2608" targetY="320" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1585516275608" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_19" waitSetting="0" width="106" x="3232" y="212">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Failure Reason: No data on cloud storage detected for the input jobId [xpath:{/workflow/variables/iJobId}]&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1585516275608" description="if/else based decision" displayName="No Data" height="72" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_39" waitSetting="0" width="79" x="3246" y="279">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/sRecallData}.isEmpty()&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="WorkflowEnd_19" commented="0" description="" originalStyle="" points="" sourceX="2799" sourceY="315" status="0" style="defaultEdge" targetX="2799" targetY="229" transitionIndex="0" value="true" x="-172" y="-2082">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="ExecuteProcessBlock_56" commented="0" description="" originalStyle="" points="" sourceX="2799" sourceY="315" status="0" style="defaultEdge" targetX="2914" targetY="318" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1591298378409" description="if/else based decision" displayName="No Data" height="72" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_45" waitSetting="0" width="79" x="3245" y="371">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/bWfCancel}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="Decision_39" commented="0" description="" originalStyle="" points="" sourceX="2798" sourceY="407" status="0" style="defaultEdge" targetX="2797" targetY="315" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="WorkflowEnd_25" commented="0" description="" originalStyle="" points="" sourceX="2798" sourceY="407" status="0" style="defaultEdge" targetX="2952" targetY="409" transitionIndex="0" value="true" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1591298392271" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_25" waitSetting="0" width="106" x="3372" y="390">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Failure Reason: Recall cancelled by user&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1595474356961" description="executes queries against a commcell database" displayName="Check Index Version" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_60" waitSetting="0" width="147" x="2311" y="298">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @jobid int = xpath:{/workflow/variables/iJobId};&amp;#xD;&#xD;&#xA;declare @parentJobId int = 0;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select @parentJobId = parentJobId&amp;#xD;&#xD;&#xA;from JMJobDataLink(nolock)&amp;#xD;&#xD;&#xA;where parentJobId = @jobid&amp;#xD;&#xD;&#xA;or childJobId = @jobid&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select @parentJobId&amp;#xD;&#xD;&#xA;&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="Script_178" commented="0" description="" originalStyle="" points="" sourceX="2384" sourceY="315" status="0" style="defaultEdge" targetX="2569" targetY="315" transitionIndex="0" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1595474648718" description="activity to execute code snippets in the selected language" displayName="Check Index Version" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_178" waitSetting="0" width="147" x="2496" y="298">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;int parentJobId = xpath:{/workflow/CommServDBQuery_60/resultSets/row[1]/col[1]};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(0 == parentJobId)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;vsav1&amp;quot;, 1);&amp;#xD;&amp;#xA;    return 1;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;iJobId&amp;quot;, parentJobId);&amp;#xD;&amp;#xA;return 2;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_50" commented="0" description="" originalStyle="" points="" sourceX="2534" sourceY="315" status="0" style="defaultEdge" targetX="2639" targetY="315" transitionIndex="0" x="0" y="0">

          <condition language="1" script="2 == xpath:{/workflow/Script_178/output} || 1 == xpath:{/workflow/variables/iBkpType}" />

        </transition>

        <transition activity="ExecuteProcessBlock_77" commented="0" description="" originalStyle="" points="" sourceX="2569" sourceY="315" status="0" style="defaultEdge" targetX="2747" targetY="254" transitionIndex="0" x="0" y="0">

          <condition language="1" script="1 == xpath:{/workflow/Script_178/output} &amp;&amp; 1 != xpath:{/workflow/variables/iBkpType}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1595475678311" description="executes a defined process block within the workflow" displayName="Recall Data Using VSA" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#FAD39E;gradientColor=#FAD39E" uniqueName="ExecuteProcessBlock_77" waitSetting="0" width="156" x="2694" y="240">

        <activitySchema>

          <inputs attribute="0" className="" defaultValue="" listType="0" name="inputs" type="">

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sCopyIdList" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="sIdList" readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

          </inputs>

          <outputs name="ProcessBlock_32">

            <children name="Start_47" />

            <children name="EnableLogging_41" />

            <children name="Decision_46" />

            <children name="DisableLogging_48" />

            <children name="CommServDBQuery_59" type="">

              <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                    <options val="GALAXY" />

                    <options val="NBU" />

                    <options val="NETAPP" />

                    <options val="TSM" />

                    <options val="VEEAM" />

                  </children>

                  <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                  <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                  <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

              </children>

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Script_176">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="Script_177">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="DisableLogging_49" />

            <children name="EnableLogging_42" />

            <children name="Execute_8">

              <children className="java.lang.String" documentation="xml output contents" inputType="java.lang.String" name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string" />

              <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="ExecuteProcessBlock_76">

              <children name="Start_19" />

              <children name="DisableLogging_1" />

              <children name="Execute_1">

                <children className="java.lang.String" documentation="xml output contents" inputType="java.lang.String" name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

              </children>

              <children name="Script_ClientDetails">

                <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

              </children>

              <children name="Decision_4" />

              <children name="EnableLogging_13" />

              <children name="DisableLogging_14" />

            </children>

            <children name="Script_179">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="CommServDBQuery_61" type="">

              <children className="workflow.types.data.DataSet" inputType="workflow.types.data.DataSet" listType="1" name="resultSets" type="{workflow.types.data}DataSet">

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="java.lang.Integer" inputType="java.lang.Integer" name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children className="commvault.msgs.CvEntities.CommCellEntity" inputType="commvault.msgs.CvEntities.CommCellEntity" listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.Integer" inputType="java.lang.Integer" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" inputType="java.lang.String" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="commvault.msgs.CvEntities.CommCellType" inputType="commvault.msgs.CvEntities.CommCellType" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                    <options val="GALAXY" />

                    <options val="NBU" />

                    <options val="NETAPP" />

                    <options val="TSM" />

                    <options val="VEEAM" />

                  </children>

                  <children className="commvault.msgs.CvEntities.EntityFlags" inputType="commvault.msgs.CvEntities.EntityFlags" name="flags" type="{commvault.msgs.CvEntities}EntityFlags" />

                  <children className="java.lang.String" inputType="java.lang.String" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.String" inputType="java.lang.String" name="newName" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="1" name="row" type="{workflow.types.data}DataRow">

                  <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

              </children>

              <children className="java.lang.Integer" inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

              <children className="java.lang.String" inputType="java.lang.String" name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

            </children>

            <children name="Decision_49" />

            <children name="Script_180">

              <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

            <children name="DisableLogging_50" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;sCopyIdList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_79/output}&lt;/sCopyIdList&gt;&lt;sIdList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_78/output}&lt;/sIdList&gt;&lt;/inputs&gt;&lt;processBlock&gt;ProcessBlock_32&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteProcessBlock_46" commented="0" description="" originalStyle="" points="2986.0,295.0" sourceX="2772" sourceY="257" status="0" style="defaultEdge" targetX="3031" targetY="324" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1609115660413" description="ends the interactive user session" displayName="EndUserSession" height="34" interactive="0" jobMode="0" name="EndUserSession" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.InteractiveEndSessionActivity" uniqueName="EndUserSession_8" waitSetting="0" width="124" x="1889" y="103">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Script_69" commented="0" description="" originalStyle="" points="" sourceX="2121" sourceY="89" status="0" style="defaultEdge" targetX="2122" targetY="129" transitionIndex="0" x="0" y="0">

          <condition language="4" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1578608354211" description="creates a super process group" displayName="Process Backup Recall Data" height="591" interactive="0" jobMode="0" name="ProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#FAD39E;gradientColor=#FAD39E" uniqueName="ProcessBlock_29" waitSetting="0" width="2056" x="77" y="3428">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs className="" defaultValue="" listType="0" name="outputs" type="" />

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1578608354211" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_35" waitSetting="0" width="61" x="40" y="166">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Script_74" commented="0" description="" originalStyle="" points="" sourceX="70" sourceY="115" status="0" style="defaultEdge" targetX="217" targetY="120" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1576770216352" description="activity to execute code snippets in the selected language" displayName="Get Recall Data" height="32" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_65" waitSetting="0" width="116" x="175" y="514">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;import org.jdom2.Element;&amp;#xD;&amp;#xA;import org.jdom2.Document;&amp;#xD;&amp;#xA;import org.jdom2.Attribute;&amp;#xD;&amp;#xA;import org.jdom2.input.SAXBuilder;&amp;#xD;&amp;#xA;import org.jdom2.output.XMLOutputter;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    DataSet rs1 = workflow.getVariable(&amp;quot;dBackupRecallDataset1&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    Element mountPaths = new Element(&amp;quot;MountPaths&amp;quot;);&amp;#xD;&amp;#xA;    Document doc = new Document(mountPaths);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    Map mpMap = new HashMap(); &amp;#xD;&amp;#xA;    //order is guaranteed by the query. Ordered by MountPathId -&amp;gt; VolumeId -&amp;gt; ArchFileId -&amp;gt; ChunkId&amp;#xD;&amp;#xA;    while(rs1.hasNext())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        Element chunk = new Element(&amp;quot;Chunk&amp;quot;);&amp;#xD;&amp;#xA;        chunk.setAttribute(&amp;quot;VolumeId&amp;quot;, rs1.get(&amp;quot;VolumeId&amp;quot;));&amp;#xD;&amp;#xA;        chunk.setAttribute(&amp;quot;IsDeduped&amp;quot;, rs1.get(&amp;quot;hasStore&amp;quot;));&amp;#xD;&amp;#xA;        chunk.setAttribute(&amp;quot;ArchFileId&amp;quot;, rs1.get(&amp;quot;archFileId&amp;quot;));&amp;#xD;&amp;#xA;        chunk.setAttribute(&amp;quot;Chunk&amp;quot;, rs1.get(&amp;quot;archChunkId&amp;quot;));&amp;#xD;&amp;#xA;        chunk.setAttribute(&amp;quot;Offset&amp;quot;, rs1.get(&amp;quot;physicalOffset&amp;quot;));&amp;#xD;&amp;#xA;        chunk.setAttribute(&amp;quot;Cclip&amp;quot;, rs1.get(&amp;quot;cclip&amp;quot;));&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        if(null != mpMap &amp;amp;&amp;amp; mpMap.containsKey(rs1.get(&amp;quot;MountPathId&amp;quot;)))&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            List elementList = mpMap.get(rs1.get(&amp;quot;MountPathId&amp;quot;));&amp;#xD;&amp;#xA;            elementList.add(chunk);&amp;#xD;&amp;#xA;            mpMap.put(rs1.get(&amp;quot;MountPathId&amp;quot;), elementList); &amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        else&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            List elementList = new ArrayList();&amp;#xD;&amp;#xA;            elementList.add(chunk);&amp;#xD;&amp;#xA;            mpMap.put(rs1.get(&amp;quot;MountPathId&amp;quot;), elementList);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    int threadCount = 1;&amp;#xD;&amp;#xA;    int mpCount = workflow.getVariable(&amp;quot;dBackupRecallDataset2&amp;quot;).getRowCount();&amp;#xD;&amp;#xA;    int isVSAv1 = xpath:{/workflow/variables/vsav1};&amp;#xD;&amp;#xA;    if(mpCount &amp;lt; 10 &amp;amp;&amp;amp; 1005 != xpath:{/workflow/variables/iJobOption} /*Keep one thread for Restore by Job*/ &amp;amp;&amp;amp; isVSAv1 != 1) &amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        threadCount = (10 / mpCount);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    Map m = workflow.getVariable(&amp;quot;maMap&amp;quot;);&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;    InputStream stream = new ByteArrayInputStream(workflow.getVariable(&amp;quot;sMountPathsData&amp;quot;).getBytes(&amp;quot;UTF-8&amp;quot;));&amp;#xD;&amp;#xA;    SAXBuilder builder = new SAXBuilder();&amp;#xD;&amp;#xA;    doc2 = builder.build(stream);&amp;#xD;&amp;#xA;    mountPathsData = doc2.getRootElement();&amp;#xD;&amp;#xA;    mountPathInfos = mountPathsData.getChildren();&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    for(int i = 0; i &amp;lt; mountPathInfos.size(); ++i)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        String MediaAgentId =  mountPathInfos.get(i).getAttributeValue(&amp;quot;clientId&amp;quot;);&amp;#xD;&amp;#xA;        Map details = m.get(Integer.parseInt(MediaAgentId));&amp;#xD;&amp;#xA;        //logger.info(Integer.parseInt(MediaAgentId));&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        Element mountPath = new Element(&amp;quot;MountPath&amp;quot;);&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;MountPathId&amp;quot;, mountPathInfos.get(i).getAttributeValue(&amp;quot;MountPathId&amp;quot;));&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;MountPathName&amp;quot;, mountPathInfos.get(i).getAttributeValue(&amp;quot;MountPathName&amp;quot;));&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;Vendor&amp;quot;, mountPathInfos.get(i).getAttributeValue(&amp;quot;DeviceTypeId&amp;quot;));&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;MediaAgentId&amp;quot;, MediaAgentId);&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;MediaAgentOs&amp;quot;, details.get(&amp;quot;clientOs&amp;quot;));&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;MediaAgentInstance&amp;quot;, details.get(&amp;quot;MediaAgentInstance&amp;quot;));&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;MediaAgentName&amp;quot;, details.get(&amp;quot;MediaAgentName&amp;quot;));&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;MediaAgentBase&amp;quot;, details.get(&amp;quot;clientBaseFolder&amp;quot;));&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;MediaAgentTemp&amp;quot;, details.get(&amp;quot;clientTempFolder&amp;quot;));&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;ChunkCount&amp;quot;, mountPathInfos.get(i).getAttributeValue(&amp;quot;ChunkCount&amp;quot;));&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;RowNumber&amp;quot;, mountPathInfos.get(i).getAttributeValue(&amp;quot;rowNumber&amp;quot;));&amp;#xD;&amp;#xA;        mountPath.setAttribute(&amp;quot;ThreadCount&amp;quot;, Integer.toString(threadCount));&amp;#xD;&amp;#xA;        mountPaths.addContent(mountPath); &amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        if(null != mpMap &amp;amp;&amp;amp; mpMap.containsKey(mountPathInfos.get(i).getAttributeValue(&amp;quot;MountPathId&amp;quot;)))&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            Element chunks = new Element(&amp;quot;Chunks&amp;quot;);&amp;#xD;&amp;#xA;            &amp;#xD;&amp;#xA;            List elementList = mpMap.get(mountPathInfos.get(i).getAttributeValue(&amp;quot;MountPathId&amp;quot;));&amp;#xD;&amp;#xA;            for(int iter = 0; iter &amp;lt; elementList.size(); ++iter)&amp;#xD;&amp;#xA;            {&amp;#xD;&amp;#xA;                chunks.addContent(elementList.get(iter));&amp;#xD;&amp;#xA;            }&amp;#xD;&amp;#xA;            mountPath.addContent(chunks);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;sRecallData&amp;quot;, new XMLOutputter().outputString(doc));&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to generate file list for recall. Exception &amp;quot; + e);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="DisableLogging_30" commented="0" description="" originalStyle="" points="" sourceX="16" sourceY="148" status="0" style="defaultEdge" targetX="168" targetY="154" transitionIndex="0" x="-525" y="56">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578612829011" description="activity to execute code snippets in the selected language" displayName="Validating Recall Data" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_72" waitSetting="0" width="153" x="454" y="164">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;import org.jdom2.Element;&amp;#xD;&amp;#xA;import org.jdom2.Document;&amp;#xD;&amp;#xA;import org.jdom2.Attribute;&amp;#xD;&amp;#xA;import org.jdom2.input.SAXBuilder;&amp;#xD;&amp;#xA;import org.jdom2.output.XMLOutputter;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String count = &amp;quot;Total Files to be recalled = &amp;quot; + workflow.getVariable(&amp;quot;dBackupRecallDataset1&amp;quot;).size();&amp;#xD;&amp;#xA;    logger.info(count);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String warning = count + &amp;quot;\n\n&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    boolean started = false;&amp;#xD;&amp;#xA;    boolean failed = false;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    InputStream stream = new ByteArrayInputStream(workflow.getVariable(&amp;quot;sMountPathsData&amp;quot;).getBytes(&amp;quot;UTF-8&amp;quot;));&amp;#xD;&amp;#xA;    SAXBuilder builder = new SAXBuilder();&amp;#xD;&amp;#xA;    doc = builder.build(stream);&amp;#xD;&amp;#xA;    mountPathsData = doc.getRootElement();&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    mountPathInfos = mountPathsData.getChildren();&amp;#xD;&amp;#xA;    for(int i = 0; i &amp;lt; mountPathInfos.size(); ++i)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        if(!started) {&amp;#xD;&amp;#xA;            started = true;&amp;#xD;&amp;#xA;            &amp;#xD;&amp;#xA;            if(0 == mountPathInfos.get(i).getAttributeValue(&amp;quot;clientId&amp;quot;)) {&amp;#xD;&amp;#xA;                failed = true;&amp;#xD;&amp;#xA;                warning = &amp;quot;No valid MediaAgents found to be associated with the following MountPaths:\n&amp;quot;;&amp;#xD;&amp;#xA;            } else {&amp;#xD;&amp;#xA;                warning += &amp;quot;MediaAgent(s) picked for performing recalls:\n&amp;quot;;&amp;#xD;&amp;#xA;            }&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        String mp = mountPathInfos.get(i).getAttributeValue(&amp;quot;MountPathName&amp;quot;);&amp;#xD;&amp;#xA;        if(failed) {&amp;#xD;&amp;#xA;            if(0 == mountPathInfos.get(i).getAttributeValue(&amp;quot;clientId&amp;quot;)) {&amp;#xD;&amp;#xA;                warning += mp + &amp;quot;\n&amp;quot;;    &amp;#xD;&amp;#xA;            } else {&amp;#xD;&amp;#xA;                break;&amp;#xD;&amp;#xA;            }&amp;#xD;&amp;#xA;            &amp;#xD;&amp;#xA;        } else {&amp;#xD;&amp;#xA;            String ma = mountPathInfos.get(i).getAttributeValue(&amp;quot;clientName&amp;quot;);&amp;#xD;&amp;#xA;            warning += &amp;quot;For Mountpath - &amp;quot; + mp + &amp;quot; --&amp;gt; MediaAgent: &amp;quot; + ma + &amp;quot;\n&amp;quot;;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    if(failed) {&amp;#xD;&amp;#xA;        warning += &amp;quot;Associate MediaAgents and try again.\n&amp;quot;;&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;sWarning&amp;quot;, warning);&amp;#xD;&amp;#xA;        return false;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    warning += &amp;quot;\nCheck WorkflowCustom logs for rehydration status\n\n&amp;quot;;&amp;#xD;&amp;#xA;    warning += &amp;quot;Do you want to continue?&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;sWarning&amp;quot;, warning);&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to validate data for recall. Exception &amp;quot; + e);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="InformationalMessage_2" commented="0" description="" originalStyle="" points="" sourceX="220" sourceY="115" status="0" style="defaultEdge" targetX="221" targetY="56" transitionIndex="0" x="0" y="0">

          <condition language="1" script="false == xpath:{/workflow/Script_72/output}" />

        </transition>

        <transition activity="InformationalMessage_3" commented="0" description="" originalStyle="" points="" sourceX="220" sourceY="115" status="0" style="defaultEdge" targetX="448" targetY="112" transitionIndex="0" x="0" y="0">

          <condition language="1" script="!(1001 == xpath:{/workflow/variables/iJobOption} || 1005 == xpath:{/workflow/variables/iJobOption} || 12 == xpath:{/workflow/variables/iJobOption} || xpath:{/workflow/inputs/bIndexOnlyRecall})" />

        </transition>

        <transition activity="ForEachXml_4" commented="0" description="" originalStyle="" points="" sourceX="414" sourceY="181" status="0" style="defaultEdge" targetX="543" targetY="277" transitionIndex="0" x="0" y="0">

          <condition language="1" script="1001 == xpath:{/workflow/variables/iJobOption} || 1005 == xpath:{/workflow/variables/iJobOption} || 12 == xpath:{/workflow/variables/iJobOption} || xpath:{/workflow/inputs/bIndexOnlyRecall}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578613412138" description="displays an informational message to the user" displayName="Error" height="34" interactive="0" jobMode="0" name="InformationalMessage" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity" uniqueName="InformationalMessage_2" waitSetting="0" width="59" x="502" y="105">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

          <outputs name="outputs">

            <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;message&gt;xpath:{/workflow/variables/sWarning}&lt;/message&gt;&lt;dialogType&gt;Popup&lt;/dialogType&gt;&lt;iconType&gt;Error&lt;/iconType&gt;&lt;title&gt;Error&lt;/title&gt;&lt;html&gt;false&lt;/html&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578613446762" description="displays an informational message to the user" displayName="Warning" height="34" interactive="0" jobMode="0" name="InformationalMessage" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity" uniqueName="InformationalMessage_3" waitSetting="0" width="79" x="732" y="164">

        <activitySchema>

          <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

          <outputs name="outputs">

            <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;message&gt;xpath:{/workflow/variables/sWarning}&lt;/message&gt;&lt;dialogType&gt;Popup&lt;/dialogType&gt;&lt;iconType&gt;Warning&lt;/iconType&gt;&lt;title&gt;Note&lt;/title&gt;&lt;html&gt;false&lt;/html&gt;&lt;actions&gt;&lt;name&gt;Yes&lt;/name&gt;&lt;validateForm&gt;true&lt;/validateForm&gt;&lt;/actions&gt;&lt;actions&gt;&lt;name&gt;No&lt;/name&gt;&lt;validateForm&gt;true&lt;/validateForm&gt;&lt;/actions&gt;&lt;actions&gt;&lt;name&gt;Change MediaAgent&lt;/name&gt;&lt;validateForm&gt;true&lt;/validateForm&gt;&lt;/actions&gt;&lt;/inputs&gt;" />

        <transition activity="EndUserSession_4" commented="0" description="" displayName="Yes" originalStyle="" points="" sourceX="383" sourceY="115" status="0" style="defaultEdge" targetX="552" targetY="115" transitionIndex="0" x="0" y="0">

          <condition language="1" script="true == &quot;Yes&quot;.equals(xpath:{/workflow/InformationalMessage_3/actionSelected})" />

        </transition>

        <transition activity="ForEachXml_3" commented="0" description="" originalStyle="" points="" sourceX="577" sourceY="181" status="0" style="defaultEdge" targetX="1205" targetY="181" transitionIndex="0" x="-88" y="-3369">

          <condition language="1" script="if(true == &quot;Change MediaAgent&quot;.equals(xpath:{/workflow/InformationalMessage_3/actionSelected}))&#xD;&#xA;{&#xD;&#xA;    workflow.setVariable(&quot;sMountPathsDataCopy&quot;, workflow.getVariable(&quot;sMountPathsData&quot;));&#xD;&#xA;    return true;&#xD;&#xA;}&#xD;&#xA;return false;" />

        </transition>

        <transition activity="Script_175" commented="0" description="" originalStyle="" points="" sourceX="577" sourceY="181" status="0" style="defaultEdge" targetX="578" targetY="75" transitionIndex="0" x="0" y="0">

          <condition language="1" script="true == &quot;No&quot;.equals(xpath:{/workflow/InformationalMessage_3/actionSelected})" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578614086804" description="ends the interactive user session" displayName="EndUserSession" height="34" interactive="0" jobMode="0" name="EndUserSession" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.InteractiveEndSessionActivity" uniqueName="EndUserSession_4" waitSetting="0" width="124" x="709" y="263">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="ForEachXml_4" commented="0" description="" originalStyle="" points="" sourceX="577" sourceY="280" status="0" style="defaultEdge" targetX="588" targetY="339" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578678349603" description="activity to execute code snippets in the selected language" displayName="Validating Recall Data" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_74" waitSetting="0" width="153" x="146" y="164">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;import org.jdom2.Element;&amp;#xD;&amp;#xA;import org.jdom2.Document;&amp;#xD;&amp;#xA;import org.jdom2.Attribute;&amp;#xD;&amp;#xA;import org.jdom2.input.SAXBuilder;&amp;#xD;&amp;#xA;import org.jdom2.output.XMLOutputter;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    DataSet rs = workflow.getVariable(&amp;quot;dBackupRecallDataset2&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    Element mountPathsData = new Element(&amp;quot;MountPathsData&amp;quot;);&amp;#xD;&amp;#xA;    Document doc = new Document(mountPathsData);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    while(rs.hasNext())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        Element mountPathInfo = new Element(&amp;quot;MountPathInfo&amp;quot;);&amp;#xD;&amp;#xA;        mountPathInfo.setAttribute(&amp;quot;rowNumber&amp;quot;, rs.get(&amp;quot;rowNumber&amp;quot;));&amp;#xD;&amp;#xA;        mountPathInfo.setAttribute(&amp;quot;MountPathId&amp;quot;, rs.get(&amp;quot;MountPathId&amp;quot;));&amp;#xD;&amp;#xA;        mountPathInfo.setAttribute(&amp;quot;MountPathName&amp;quot;, rs.get(&amp;quot;MountPathName&amp;quot;));&amp;#xD;&amp;#xA;        mountPathInfo.setAttribute(&amp;quot;DeviceTypeId&amp;quot;, rs.get(&amp;quot;DeviceTypeId&amp;quot;));&amp;#xD;&amp;#xA;        mountPathInfo.setAttribute(&amp;quot;ChunkCount&amp;quot;, rs.get(&amp;quot;ChunkCount&amp;quot;));&amp;#xD;&amp;#xA;        mountPathInfo.setAttribute(&amp;quot;clientId&amp;quot;, rs.get(&amp;quot;clientId&amp;quot;)); &amp;#xD;&amp;#xA;        mountPathInfo.setAttribute(&amp;quot;clientName&amp;quot;, rs.get(&amp;quot;clientName&amp;quot;));&amp;#xD;&amp;#xA;        mountPathsData.addContent(mountPathInfo);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;sMountPathsData&amp;quot;, new XMLOutputter().outputString(doc));&amp;#xD;&amp;#xA;    return true;    &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to validate data for recall. Exception &amp;quot; + e);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="Script_181" commented="0" description="" originalStyle="" points="" sourceX="222" sourceY="115" status="0" style="defaultEdge" targetX="497" targetY="106" transitionIndex="0" x="0" y="0">

          <condition language="1" script="xpath:{/workflow/Script_74/output}" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578684885689" description="iterates a group of activities over a list of xml nodes" displayName="ForEachXml MountPathInfo" height="240" interactive="0" jobMode="0" name="ForEachXml" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#E0E085;gradientColor=#E0E085" uniqueName="ForEachXml_3" waitSetting="0" width="1074" x="914" y="61">

        <inputs val="&lt;inputs&gt;&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;java:{workflow.getVariable(&quot;sMountPathsDataCopy&quot;)}&lt;/xml&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;/MountPathsData/MountPathInfo&lt;/xpath&gt;&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;1&lt;/numberOfParallelExecutions&gt;&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/continueOnFailure&gt;&lt;/inputs&gt;" />

        <transition activity="Script_72" commented="0" description="" originalStyle="" points="605.0,119.0" sourceX="575" sourceY="324" status="0" style="defaultEdge" targetX="415" targetY="110" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <superProcess>

          <Start commented="0" continueOnFailure="0" created="1578684885689" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_38" waitSetting="0" width="58" x="21" y="87">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="XPathMultiQuery_4" commented="0" description="" originalStyle="" points="" sourceX="50" sourceY="102" status="0" style="defaultEdge" targetX="206" targetY="59" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Start>

          <Activity commented="0" continueOnFailure="0" created="1578615046308" description="executes queries against a commcell database" displayName="Find Candidate MAs" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_35" waitSetting="0" width="141" x="372" y="85">

            <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;select distinct cast(mp.MountPathId as varchar(max)), ''['' + l.AliasName + ''] '' + mp.MountPathName MountPathName, cast(ac.id as varchar(max)) clientId, ac.name clientName&amp;#xD;&#xD;&#xA;from MMMountPath(nolock) mp&amp;#xD;&#xD;&#xA;join MMMountPathToStorageDevice(nolock) mpsd on mpsd.MountPathId = mp.MountPathId&amp;#xD;&#xD;&#xA;join MMDeviceController(nolock) dc on dc.DeviceId = mpsd.DeviceId&amp;#xD;&#xD;&#xA;join APP_Client(nolock) ac on ac.id = dc.ClientId&amp;#xD;&#xD;&#xA;join MMLibrary(nolock) l on l.libraryid = mp.libraryid&amp;#xD;&#xD;&#xA;where dc.DeviceControllerEnabled = 1&amp;#xD;&#xD;&#xA;and mp.MountPathId = xpath:{/workflow/XPathMultiQuery_4/MountPathId};&lt;/query&gt;&lt;/inputs&gt;" />

            <transition activity="PopupInput_10" commented="0" description="" originalStyle="" points="" sourceX="442" sourceY="102" status="0" style="defaultEdge" targetX="614" targetY="97" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1578614933029" description="if/else based decision" displayName="Debug" height="57" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_13" waitSetting="0" width="66" x="269" y="74">

            <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;1 == xpath:{/workflow/variables/iDebugMode}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

            <transition activity="CommServDBQuery_35" commented="0" description="" originalStyle="" points="" sourceX="1051" sourceY="263" status="0" style="defaultEdge" targetX="1194" targetY="267" transitionIndex="0" value="true" x="885" y="182">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

            <transition activity="DisableLogging_11" commented="0" description="" displayName="Disabled" originalStyle="" points="" sourceX="1051" sourceY="263" status="0" style="defaultEdge" targetX="1052" targetY="355" transitionIndex="0" value="false" x="885" y="182">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1578614951737" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_11" waitSetting="0" width="117" x="241" y="175">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="CommServDBQuery_35" commented="0" description="" originalStyle="" points="441.0,197.0" sourceX="1052" sourceY="355" status="0" style="defaultEdge" targetX="1213" targetY="263" transitionIndex="0" x="885" y="182">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1578615703664" description="popups an input form for the user to fill out" displayName="Change MediaAgent" height="34" interactive="0" jobMode="0" name="PopupInput" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.InteractiveInputActivity" uniqueName="PopupInput_10" waitSetting="0" width="143" x="548" y="85">

            <activitySchema>

              <inputs className="" defaultValue="" listType="0" name="inputs" type="">

                <children attribute="0" className="java.lang.String" controlHidden="0" controlType="2" defaultValue="" displayName="Select MediaAgent for xpath:{/workflow/XPathMultiQuery_4/MountPathName}" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="mediaAgent" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                  <options val="xpath:{/workflow/CommServDBQuery_35/resultSets/row/col[3]}" />

                  <labelsForOptions val="xpath:{/workflow/CommServDBQuery_35/resultSets/row/col[4]}" />

                </children>

              </inputs>

              <outputs className="" defaultValue="" listType="0" name="outputs" type="">

                <children attribute="0" className="java.lang.String" controlHidden="0" controlType="2" defaultValue="" displayName="Select MediaAgent for xpath:{/workflow/XPathMultiQuery_4/MountPathName}" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="mediaAgent" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                  <options val="xpath:{/workflow/CommServDBQuery_35/resultSets/row/col[3]}" />

                  <labelsForOptions val="xpath:{/workflow/CommServDBQuery_35/resultSets/row/col[4]}" />

                </children>

                <children className="java.lang.Boolean" inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean" />

                <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

              </outputs>

            </activitySchema>

            <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;mediaAgent class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_4/clientId}&lt;/mediaAgent&gt;&lt;/inputs&gt;&lt;subject&gt;Select MediaAgent&lt;/subject&gt;&lt;/inputs&gt;" />

            <transition activity="CommServDBQuery_36" commented="0" description="" originalStyle="" points="" sourceX="619" sourceY="102" status="0" style="defaultEdge" targetX="794" targetY="110" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

            <properties css="" formVersion="0" javaScript="" pageMode="0">

              <rules />

            </properties>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1578615899829" description="executes queries against a commcell database" displayName="Change MediaAgent" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_36" waitSetting="0" width="143" x="727" y="85">

            <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;select name&amp;#xD;&#xD;&#xA;from APP_Client(nolock)&amp;#xD;&#xD;&#xA;where id = xpath:{/workflow/PopupInput_10/mediaAgent}&lt;/query&gt;&lt;/inputs&gt;" />

            <transition activity="Script_73" commented="0" description="" originalStyle="" points="" sourceX="798" sourceY="102" status="0" style="defaultEdge" targetX="1023" targetY="103" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1578615966109" description="activity to execute code snippets in the selected language" displayName="Change MediaAgent" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_73" waitSetting="0" width="143" x="905" y="85">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;import org.jdom2.Element;&amp;#xD;&amp;#xA;import org.jdom2.Document;&amp;#xD;&amp;#xA;import org.jdom2.Attribute;&amp;#xD;&amp;#xA;import org.jdom2.input.SAXBuilder;&amp;#xD;&amp;#xA;import org.jdom2.output.XMLOutputter;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;&amp;#x9;InputStream stream = new ByteArrayInputStream(workflow.getVariable(&amp;quot;sMountPathsData&amp;quot;).getBytes(&amp;quot;UTF-8&amp;quot;));&amp;#xD;&amp;#xA;&amp;#x9;SAXBuilder builder = new SAXBuilder();&amp;#xD;&amp;#xA;    doc = builder.build(stream);&amp;#xD;&amp;#xA;    mountPathsData = doc.getRootElement();&amp;#xD;&amp;#xA;&amp;#x9;&amp;#xD;&amp;#xA;&amp;#x9;mountPathInfos = mountPathsData.getChildren();&amp;#xD;&amp;#xA;&amp;#x9;for(int i = 0; i &amp;lt; mountPathInfos.size(); ++i)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;if(Integer.parseInt(mountPathInfos.get(i).getAttributeValue(&amp;quot;MountPathId&amp;quot;)) == xpath:{/workflow/XPathMultiQuery_4/MountPathId})&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;{&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;mountPathInfos.get(i).getAttribute(&amp;quot;clientId&amp;quot;).setValue(xpath:{/workflow/PopupInput_10/mediaAgent});&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;mountPathInfos.get(i).getAttribute(&amp;quot;clientName&amp;quot;).setValue(xpath:{/workflow/CommServDBQuery_36/resultSets[1]/row[1]/col[1]});&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;break;&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;}&amp;#xD;&amp;#xA;&amp;#x9;}&amp;#xD;&amp;#xA;&amp;#x9;&amp;#xD;&amp;#xA;&amp;#x9;workflow.setVariable(&amp;quot;sMountPathsData&amp;quot;, new XMLOutputter().outputString(doc));&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to validate data for recall. Exception &amp;quot; + e);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="EnableLogging_19" commented="0" description="" originalStyle="" points="" sourceX="976" sourceY="102" status="0" style="defaultEdge" targetX="987" targetY="191" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1578687571437" description="retrieves a list of values from xml" displayName="XPathMultiQuery" height="34" interactive="0" jobMode="0" name="XPathMultiQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.MultiXPathActivity" uniqueName="XPathMultiQuery_4" waitSetting="0" width="125" x="110" y="85">

            <activitySchema>

              <outputs name="outputs">

                <children listType="0" name="rowNumber" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children listType="0" name="MountPathId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children listType="0" name="MountPathName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children listType="0" name="DeviceTypeId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children listType="0" name="ChunkCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children listType="0" name="clientId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string" />

              </outputs>

            </activitySchema>

            <inputs val="&lt;inputs&gt;&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ForEachXml_3/values}&lt;/xml&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;rowNumber&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@rowNumber&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;Integer&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;MountPathId&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@MountPathId&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;Integer&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;MountPathName&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@MountPathName&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;DeviceTypeId&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@DeviceTypeId&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;Integer&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;ChunkCount&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@ChunkCount&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;Integer&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;clientId&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@clientId&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;Integer&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;clientName&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@clientName&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;/inputs&gt;" />

            <transition activity="Decision_13" commented="0" description="" originalStyle="" points="" sourceX="172" sourceY="102" status="0" style="defaultEdge" targetX="296" targetY="102" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1578688532264" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_19" waitSetting="0" width="113" x="927" y="173">

            <inputs val="&lt;inputs /&gt;" />

          </Activity>

        </superProcess>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1578688595713" description="iterates a group of activities over a list of xml nodes" displayName="ForEachXml (OS)" height="142" interactive="0" jobMode="0" name="ForEachXml" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="swimlane;fillColor=#E0E085;gradientColor=#E0E085" uniqueName="ForEachXml_4" waitSetting="0" width="1828" x="160" y="329">

        <onEnter language="1" script="Map m = new HashMap();&#xD;&#xA;workflow.setVariable(&quot;maMap&quot;, m);" />

        <inputs val="&lt;inputs&gt;&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;java:{workflow.getVariable(&quot;sMountPathsData&quot;)}&lt;/xml&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;/MountPathsData/MountPathInfo&lt;/xpath&gt;&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;1&lt;/numberOfParallelExecutions&gt;&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/continueOnFailure&gt;&lt;/inputs&gt;" />

        <transition activity="Script_65" commented="0" description="" originalStyle="" points="" sourceX="659" sourceY="400" status="0" style="defaultEdge" targetX="137" targetY="527" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <superProcess>

          <Start commented="0" continueOnFailure="0" created="1578688595713" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="1" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_39" waitSetting="0" width="58" x="23" y="74">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="XPathMultiQuery_5" commented="0" description="" originalStyle="" points="" sourceX="52" sourceY="81" status="0" style="defaultEdge" targetX="190" targetY="83" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Start>

          <Activity commented="0" continueOnFailure="0" created="1578688607300" description="retrieves a list of values from xml" displayName="XPathMultiQuery" height="34" interactive="0" jobMode="0" name="XPathMultiQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.MultiXPathActivity" uniqueName="XPathMultiQuery_5" waitSetting="0" width="125" x="127" y="72">

            <activitySchema>

              <outputs name="outputs">

                <children listType="0" name="rowNumber" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children listType="0" name="MountPathId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children listType="0" name="MountPathName" type="{http://www.w3.org/2001/XMLSchema}string" />

                <children listType="0" name="DeviceTypeId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children listType="0" name="ChunkCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children listType="0" name="clientId" type="{http://www.w3.org/2001/XMLSchema}integer" />

                <children listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string" />

              </outputs>

            </activitySchema>

            <inputs val="&lt;inputs&gt;&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ForEachXml_4/values}&lt;/xml&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;rowNumber&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@rowNumber&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;Integer&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;MountPathId&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@MountPathId&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;Integer&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;MountPathName&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@MountPathName&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;DeviceTypeId&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@DeviceTypeId&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;Integer&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;ChunkCount&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@ChunkCount&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;Integer&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;clientId&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@clientId&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;Integer&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;xpaths class=&quot;workflow.types.XPathOutput&quot; _list_=&quot;true&quot;&gt;&lt;outputName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;clientName&lt;/outputName&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xml/@clientName&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/xpaths&gt;&lt;/inputs&gt;" />

            <transition activity="Script_75" commented="0" description="" originalStyle="" points="436.0,35.0" sourceX="189" sourceY="89" status="0" style="defaultEdge" targetX="353" targetY="89" transitionIndex="0" x="0" y="0">

              <condition language="1" script="0 != xpath:{/workflow/variables/iRetryInterval}" />

            </transition>

            <transition activity="CommServDBQuery_68" commented="0" description="" originalStyle="" points="" sourceX="189" sourceY="89" status="0" style="defaultEdge" targetX="347" targetY="91" transitionIndex="0" x="0" y="0">

              <condition language="4" script="0 == xpath:{/workflow/variables/iRetryInterval}" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1576787427765" description="if/else based decision" displayName="Debug" height="54" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="rhombus;fontStyle=1" uniqueName="Decision_10" waitSetting="0" width="66" x="891" y="62">

            <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;1 == xpath:{/workflow/variables/iDebugMode}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

            <transition activity="DisableLogging_7" commented="0" description="" displayName="Disabled" originalStyle="" points="" sourceX="348" sourceY="81" status="0" style="defaultEdge" targetX="426" targetY="80" transitionIndex="0" value="false" x="187" y="4">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

            <transition activity="ExecuteProcessBlock_43" commented="0" description="" originalStyle="" points="1099.0,37.0" sourceX="348" sourceY="81" status="0" style="defaultEdge" targetX="802" targetY="77" transitionIndex="0" value="true" x="187" y="4">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1576787419935" description="turns off all logging, except for errors, for current job" displayName="DisableLogging" height="34" interactive="0" jobMode="0" name="DisableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingDisable" uniqueName="DisableLogging_7" waitSetting="0" width="117" x="1045" y="72">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="ExecuteProcessBlock_43" commented="0" description="" originalStyle="" points="" sourceX="467" sourceY="81" status="0" style="defaultEdge" targetX="632" targetY="85" transitionIndex="0" x="187" y="4">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1576774538367" description="executes a defined process block within the workflow" displayName="Get Client Details" height="34" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess;fillColor=#BEE0B8;gradientColor=#BEE0B8" uniqueName="ExecuteProcessBlock_43" waitSetting="0" width="126" x="1194" y="72">

            <activitySchema>

              <inputs className="" defaultValue="" listType="0" name="inputs" type="">

                <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sClientName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

              </inputs>

              <outputs name="ProcessBlock_17">

                <children name="Start_19" />

                <children name="DisableLogging_1" />

                <children name="Execute_1">

                  <children className="java.lang.String" documentation="xml output contents" inputType="java.lang.String" name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string" />

                  <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

                  <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

                </children>

                <children name="Script_ClientDetails">

                  <children className="java.lang.Object" inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType" />

                </children>

                <children name="Decision_4" />

                <children name="EnableLogging_13" />

                <children name="DisableLogging_14" />

              </outputs>

            </activitySchema>

            <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;sClientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathMultiQuery_5/clientName}&lt;/sClientName&gt;&lt;/inputs&gt;&lt;processBlock&gt;ProcessBlock_17&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

            <transition activity="CommServDBQuery_28" commented="0" description="" originalStyle="" points="" sourceX="681" sourceY="81" status="0" style="defaultEdge" targetX="982" targetY="76" transitionIndex="0" x="187" y="4">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1576787489891" description="turns on all logging for the current job" displayName="EnableLogging" height="34" interactive="0" jobMode="0" name="EnableLogging" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.LoggingEnable" uniqueName="EnableLogging_7" waitSetting="0" width="113" x="1497" y="72">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="Script_66" commented="0" description="" originalStyle="" points="" sourceX="986" sourceY="83" status="0" style="defaultEdge" targetX="1147" targetY="83" transitionIndex="0" x="187" y="4">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1576787651616" description="executes queries against a commcell database" displayName="Get Client Details" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_28" waitSetting="0" width="126" x="1349" y="72">

            <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;select acp.attrVal&amp;#xD;&#xD;&#xA;from APP_ClientProp(nolock) acp&amp;#xD;&#xD;&#xA;where acp.attrName like ''%Galaxy Instance name%''  &amp;#xD;&#xD;&#xA;and acp.componentNameId = xpath:{/workflow/XPathMultiQuery_5/clientId}&amp;#xD;&#xD;&#xA;and modified = 0&lt;/query&gt;&lt;/inputs&gt;" />

            <transition activity="EnableLogging_7" commented="0" description="" originalStyle="" points="" sourceX="836" sourceY="81" status="0" style="defaultEdge" targetX="1090" targetY="124" transitionIndex="0" x="187" y="4">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1576774771867" description="activity to execute code snippets in the selected language" displayName="Get Client Details" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_66" waitSetting="0" width="126" x="1630" y="72">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;Map m = workflow.getVariable(&amp;quot;maMap&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;Map details = xpath:{/workflow/ExecuteProcessBlock_43/Script_ClientDetails/output};&amp;#xD;&amp;#xA;details.put(&amp;quot;MediaAgentName&amp;quot;, xpath:{/workflow/XPathMultiQuery_5/clientName});&amp;#xD;&amp;#xA;details.put(&amp;quot;MediaAgentInstance&amp;quot;, xpath:{/workflow/CommServDBQuery_28/resultSets[1]/row[1]/col[1]});&amp;#xD;&amp;#xA;m.put(xpath:{/workflow/XPathMultiQuery_5/clientId}, details);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;maMap&amp;quot;, m);&quot; /&gt;&lt;/inputs&gt;" />

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1578688799916" description="activity to execute code snippets in the selected language" displayName="Get Client Details" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="1" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_75" waitSetting="0" width="126" x="630" y="72">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;Map m = workflow.getVariable(&amp;quot;maMap&amp;quot;);&amp;#xD;&amp;#xA;if(m.containsKey(xpath:{/workflow/XPathMultiQuery_5/clientId}))&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;return true;&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Decision_10" commented="0" description="" displayName="Unknown Client" originalStyle="" points="" sourceX="348" sourceY="116" status="0" style="defaultEdge" targetX="472" targetY="83" transitionIndex="0" x="0" y="0">

              <condition language="1" script="true == xpath:{/workflow/Script_75/output}" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1611190802568" description="executes queries against a commcell database" displayName="Recall Duration" height="35" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_68" waitSetting="0" width="116" x="297" y="72">

            <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @deviceTypeId int = xpath:{/workflow/XPathMultiQuery_5/DeviceTypeId};&amp;#xD;&#xD;&#xA;declare @mountPathId int = xpath:{/workflow/XPathMultiQuery_5/MountPathId};&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if @deviceTypeId = 2 and &amp;#xD;&#xD;&#xA;exists (select 1&amp;#xD;&#xD;&#xA;        from MMMountPath(nolock) mp&amp;#xD;&#xD;&#xA;        join MMMountPathToStorageDevice(nolock) mpsd on mpsd.MountPathId = mp.MountPathId&amp;#xD;&#xD;&#xA;        join MMDevice(nolock) d on d.DeviceId = mpsd.DeviceId&amp;#xD;&#xD;&#xA;        join MMDeviceController(nolock) dc ON dc.DeviceId = d.DeviceId&amp;#xD;&#xD;&#xA;        where dc.UserName like ''%@16%''&amp;#xD;&#xD;&#xA;        and mpsd.MountPathId = @mountPathId)&amp;#xD;&#xD;&#xA;    select 12 * 60&amp;#xD;&#xD;&#xA;else if @deviceTypeId = 23&amp;#xD;&#xD;&#xA;    select 5&amp;#xD;&#xD;&#xA;else&amp;#xD;&#xD;&#xA;    select 0&lt;/query&gt;&lt;/inputs&gt;" />

            <transition activity="Script_186" commented="0" description="" originalStyle="" points="" sourceX="376" sourceY="90" status="0" style="defaultEdge" targetX="581" targetY="63" transitionIndex="0" x="0" y="0">

              <condition language="4" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1611190809547" description="activity to execute code snippets in the selected language" displayName="Recall Duration" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_186" waitSetting="0" width="116" x="463" y="72">

            <inputs val="&lt;inputs&gt;&lt;script language=&quot;4&quot; script=&quot;int duration = xpath:{/workflow/CommServDBQuery_68/resultSets/row[1]/col[1]};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(duration &amp;gt; 0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;iRetryInterval&amp;quot;, duration);&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

            <transition activity="Script_75" commented="0" description="" originalStyle