

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/LM_WebUserAuditMonitoringPolicyAndTemplate.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/LM_WebUserAuditMonitoringPolicyAndTemplate.script,v $ $Id: LM_WebUserAuditMonitoringPolicyAndTemplate.script,v 1.1.2.5 2017/03/17 16:22:20 pankajkumar Exp $";

SET NOCOUNT ON

GO

DECLARE @WebConsoleAuditLogMonitoringScriptExec INT = 0

SELECT

    @WebConsoleAuditLogMonitoringScriptExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = 'D64DDDBF-D3C0-40C2-B7A3-C8A081FFF865'

IF (@WebConsoleAuditLogMonitoringScriptExec = 0)        -- not done, create the Web console user activity monitoring policy and template

BEGIN

DECLARE @curUtcDateTime BIGINT

DECLARE @templateId INT

DECLARE @monitoringPolicyId INT

DECLARE @monitoringPOlicyName NVARCHAR(max)

DECLARE @templateName NVARCHAR(max)

DECLARE @templateXMLString NVARCHAR(max)

DECLARE @errorCode int = 0

DECLARE @errorString NVARCHAR(1024) = ''

BEGIN TRY

BEGIN TRANSACTION WebConsoleAuditLogTran

SET @monitoringPOlicyName = 'WebConsole Audit Policy'

SET @curUtcDateTime =  datediff(second, '01/01/1970', GETUTCDATE())

SET @templateName = 'WebConsole user activity audit template'

SET @templateXMLString = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><LogMonitoring_TemplateXML fileExtension="*.log" isFixedWidth="0" lengthOfHeader="10" seperatorList="3" templateForMonitoringType="0" treatMultipleSeparatorAsOne="1"><columns decimalPlaces="2" defaultOpType="0" index="0" isFacet="1" isIndexed="1" primaryDataType="2" primaryTypeFormat="9" solrFieldName="Log__Date" useThousandSeparator="0"><column _type_="87" columnId="1872" columnName="Log  Date"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns decimalPlaces="2" defaultOpType="0" index="1" isFacet="0" isIndexed="1" primaryDataType="3" primaryTypeFormat="17" solrFieldName="Log_Time" useThousandSeparator="0"><column _type_="87" columnId="1873" columnName="Log Time"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns decimalPlaces="2" defaultOpType="2" format="" index="2" isFacet="0" isIndexed="1" primaryDataType="1" primaryTypeFormat="21" solrFieldName="Log_Level" useThousandSeparator="0"><column _type_="87" columnId="1874" columnName="Log Level"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns decimalPlaces="2" defaultOpType="0" format="" index="3" isFacet="1" isIndexed="1" primaryDataType="1" primaryTypeFormat="21" solrFieldName="User" useThousandSeparator="0"><column _type_="87" columnId="1875" columnName="User"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns decimalPlaces="2" defaultOpType="2" format="" index="4" isFacet="0" isIndexed="1" primaryDataType="1" primaryTypeFormat="22" solrFieldName="Log_Info" useThousandSeparator="0"><column _type_="87" columnId="1876" columnName="Log Info"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns></LogMonitoring_TemplateXML>'

--creating template

IF EXISTS (SELECT 1 FROM APP_Template  WITH (NOLOCK) WHERE templateName = @templateName AND status <> 3)

BEGIN

    SET @templateId = (SELECT TOP 1 templateId FROM APP_Template  WITH (NOLOCK) WHERE templateName = @templateName AND status <> 3)

END

ELSE

BEGIN
    INSERT INTO APP_Template VALUES(2,@templateName,@templateXMLString,'This template is used to track user activity',@curUtcDateTime,0,0,1)


    SET @templateId = @@IDENTITY    

END

--creating monitoring policy

IF NOT EXISTS (SELECT 1 FROM APP_MonitoringPolicy  WITH (NOLOCK) WHERE MonitorPolicyName = @monitoringPOlicyName AND status <> 3)

BEGIN
    INSERT INTO APP_MonitoringPolicy VALUES(2,@monitoringPOlicyName,@curUtcDateTime,@curUtcDateTime,'system created Web Console Audit Policy for audit.log logs',1)


    SET @monitoringPolicyId =  @@IDENTITY
    INSERT INTO APP_MonitorAssocEntity (monitorPolicyId,commcellId,flags,created,clientGroupId,clientId,exclude) (select @monitoringPolicyId,2,3,@curUtcDateTime,0,componentNameId , 0 from APP_ClientProp where attrname = 'WebURL' AND modified = 0 group by componentNameId)

    INSERT INTO App_MonitorTemplateAssoc VALUES(@monitoringPolicyId,2,@templateId)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Creater User Id',7,1,@curUtcDateTime,@curUtcDateTime)    

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'index all lines',2,1,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Content',1,'%LOG_DIR%Web\AuditTrail.log',@curUtcDateTime,@curUtcDateTime)   

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Search in subfolders',2,0,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'is NetApp Filler Content',7,0,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture lines before match',2,0,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture lines after match',2,0,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture log file header',2,1,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor old data',2,0,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor older entries enabler',2,1,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor entries older than days',7,7,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'capture as attachment',2,0,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'capture as ftp',2,0,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Enable CI',2,1,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Continuous monitoring',2,1,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'enable ci data ageing',2,1,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'age ci data after days',7,180,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Monitoring Type',7,0,@curUtcDateTime,@curUtcDateTime)


    --Insert cloud info if AnalyticalEngine is already configured

    IF exists(SELECT 1 FROM DM2SearchServerCoreInfo SC WITH (NOLOCK) Join DM2CloudCoreRole CR WITH (NOLOCK) ON SC.CloudId = CR.CloudId Join Dm2cloud C WITH (NOLOCK) ON SC.CloudId = C.cloudid WHERE roleid = 3)

    BEGIN

        DECLARE @cloudId int , @cloudName nvarchar(max)

        SELECT TOP 1 @cloudId = C.cloudId , @cloudName = C.name

            FROM DM2SearchServerCoreInfo SC WITH (NOLOCK) Join DM2CloudCoreRole CR WITH (NOLOCK)

                    ON SC.CloudId = CR.CloudId Join Dm2cloud C WITH (NOLOCK) ON SC.CloudId = C.cloudid

                         WHERE roleid = 3
        INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Cloud Id',7,@cloudId,@curUtcDateTime,@curUtcDateTime)

        INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Cloud Name',1,@cloudName,@curUtcDateTime,@curUtcDateTime)    


    END

END

COMMIT TRANSACTION WebConsoleAuditLogTran

END TRY

BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '

	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

	ERROR MESSAGE: ' + ERROR_MESSAGE() + '

	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

    PRINT N'Rolling back Transactions.'

    ROLLBACK TRANSACTION WebConsoleAuditLogTran

END CATCH
    INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('D64DDDBF-D3C0-40C2-B7A3-C8A081FFF865', 'WebConsoleAuditLogMonitoringScriptExec', 'Create WebConsole User Activity monitoring Policy and template', @curUtcDateTime, 16, 0 , (16 + 1))

END

SET NOCOUNT OFF

GO

