

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/LM_UpdateAlertInfo.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- LM_UpdateAlertInfo.script 

-- ALLOW_COMMENTS_BELOW_HERE:

-- ---------------------------------------------------------------------- 

-- 

--           Copyright (c) 2011  CommVault Systems, Inc. 

--                  All rights reserved. 

-- 

-- 

--        This is unpublished proprietary source code of CommVault 

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

SET QUOTED_IDENTIFIER ON

GO

SET NOCOUNT ON

BEGIN TRY

BEGIN TRANSACTION LMUpdateAlertTran

DECLARE @guid uniqueidentifier = 'D06DF5D7-7425-48F1-871E-5859F1F93176'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate()) 

DECLARE @lmUpdateAlert INT = 0

SELECT @lmUpdateAlert = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF @lmUpdateAlert = 0

BEGIN

	DECLARE @alertTbl TABLE(alertId INT ,searchId INT ,alertProp xml , status INT,addColsInEmail INT , colsToDisplayInAlertEmail NVARCHAR(MAX))
	INSERT INTO @alertTbl


	SELECT 

	searchInfo.value('(/LogMonitoring_SearchURLInfo/alertInfoLst/alertEntity/@alertId)[1]','int') as alertId, 

	searchId,

	searchInfo.query('/LogMonitoring_SearchURLInfo/alertInfoLst') as alertProp,

	CASE WHEN (status&8 >= 8)

		THEN 1

		ELSE 0

	END as alertStatus,

	ISNULL(searchInfo.value('(/LogMonitoring_SearchURLInfo/@addColsInEmail)[1]','int'),0) as addColsInEmail,

	ISNULL(searchInfo.value('(/LogMonitoring_SearchURLInfo/@colsToDisplayInAlertEmail)[1]','NVARCHAR(MAX)'),'') as colsToDisplayInAlertEmail

	FROM LMUserSearch 

	WHERE searchInfo.exist('/LogMonitoring_SearchURLInfo/alertInfoLst') = 1

	UPDATE @alertTbl

	SET alertProp.modify('insert attribute status {sql:column("status")} into (/alertInfoLst)[1]')

	UPDATE @alertTbl

	SET alertProp.modify('insert attribute addColsInEmail {sql:column("addColsInEmail")} into (/alertInfoLst)[1]')

	UPDATE @alertTbl

	SET alertProp.modify('insert attribute colsToDisplayInAlertEmail {sql:column("colsToDisplayInAlertEmail")} into (/alertInfoLst)[1]')
	INSERT INTO APP_LMAlertInfo


	SELECT alertId , searchId , alertProp

	FROM @alertTbl

	UPDATE LMUserSearch

	SET searchInfo.modify('delete //LogMonitoring_SearchURLInfo/alertInfoLst')

	WHERE searchInfo.exist('/LogMonitoring_SearchURLInfo/alertInfoLst') = 1	
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'LM_UpdateAlertInfo', 'Moving alerts to new table to support multiple alert', @curUtcDateTime, 16, 0 , (16 + 2))

	COMMIT TRANSACTION LMUpdateAlertTran	

END

ELSE

       ROLLBACK TRANSACTION LMUpdateAlertTran

END TRY

BEGIN CATCH

    PRINT N'Error occured. At Line(' + CAST(ERROR_LINE() AS NVARCHAR) + N') ErrorNo(' + CAST(ERROR_NUMBER() AS NVARCHAR) + N') ErrorMsg(' + ERROR_MESSAGE() + N').'

    PRINT N'So Rolling back Transactions.'

    ROLLBACK TRANSACTION LMUpdateAlertTran

END CATCH

SET NOCOUNT OFF
