

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/LM_HyperVMonitoringPolicyAndTemplate.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/LM_HyperVMonitoringPolicyAndTemplate.script,v $ $Id: LM_HyperVMonitoringPolicyAndTemplate.script,v 1.1.2.1 2018/03/29 23:13:01 saggarwal Exp $";

SET NOCOUNT ON

GO

DECLARE @HyperVScriptExec INT = 0

SELECT

    @HyperVScriptExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = '4E060BB0-7DB9-45D2-ABF8-228CB0FE0FD4'

IF (@HyperVScriptExec = 0)        -- not done, create the HyperV monitoring policy and template

BEGIN

	DECLARE @curUtcDateTime BIGINT

	DECLARE @templateId INT

	DECLARE @monitoringPolicyId INT

	DECLARE @monitoringPOlicyName NVARCHAR(max)

	DECLARE @templateName NVARCHAR(max)

	DECLARE @templateXMLString NVARCHAR(max)

	DECLARE @errorCode int = 0

	DECLARE @errorString NVARCHAR(1024) = ''

	BEGIN TRY

	BEGIN TRANSACTION HyperVLogTran

	SET @monitoringPOlicyName = 'HyperV Monitoring'

	SET @curUtcDateTime =  datediff(second, '01/01/1970', GETUTCDATE())

	SET @templateName = 'HyperV'

	SET @templateXMLString = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><LogMonitoring_TemplateXML allowSubstringMatch="0" fileExtension="*.csv" isFixedWidth="0" lengthOfHeader="1" seperatorList="8" templateForMonitoringType="9" treatMultipleSeparatorAsOne="0"><columns convertInUTC="0" decimalPlaces="2" defaultOpType="2" format="" index="0" isFacet="1" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="1" primaryTypeFormat="21" solrFieldName="VMName" useThousandSeparator="0"><column _type_="87" columnId="425" columnName="VMName"/><supportedOpTypes val="1"/><supportedOpTypes val="0"/><supportedOpTypes val="3"/><supportedOpTypes val="2"/></columns><columns convertInUTC="0" decimalPlaces="2" defaultOpType="0" index="1" isFacet="1" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="0" primaryTypeFormat="0" solrFieldName="cpuUsage" useThousandSeparator="0"><column _type_="87" columnId="426" columnName="cpuUsage"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns convertInUTC="0" decimalPlaces="2" defaultOpType="0" index="2" isFacet="1" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="0" primaryTypeFormat="26" solrFieldName="cpuUsagePer" useThousandSeparator="0"><column _type_="87" columnId="427" columnName="cpuUsagePer"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns convertInUTC="0" decimalPlaces="2" defaultOpType="0" index="3" isFacet="1" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="0" primaryTypeFormat="26" solrFieldName="diskIORate" useThousandSeparator="0"><column _type_="87" columnId="428" columnName="diskIORate"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns convertInUTC="0" decimalPlaces="2" defaultOpType="0" index="4" isFacet="1" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="0" primaryTypeFormat="0" solrFieldName="diskRead" useThousandSeparator="0"><column _type_="87" columnId="429" columnName="diskRead"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns convertInUTC="0" decimalPlaces="2" defaultOpType="0" index="5" isFacet="0" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="0" primaryTypeFormat="0" solrFieldName="DiskWrite" useThousandSeparator="0"><column _type_="87" columnId="430" columnName="DiskWrite"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns convertInUTC="0" decimalPlaces="2" defaultOpType="0" index="6" isFacet="1" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="0" primaryTypeFormat="0" solrFieldName="memoryUsage" useThousandSeparator="0"><column _type_="87" columnId="431" columnName="memoryUsage"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns convertInUTC="0" decimalPlaces="2" defaultOpType="0" index="7" isFacet="1" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="0" primaryTypeFormat="26" solrFieldName="memoryUsagePer" useThousandSeparator="0"><column _type_="87" columnId="432" columnName="memoryUsagePer"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns convertInUTC="0" decimalPlaces="2" defaultOpType="0" index="8" isFacet="0" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="0" primaryTypeFormat="0" solrFieldName="networkIn" useThousandSeparator="0"><column _type_="87" columnId="433" columnName="networkIn"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns convertInUTC="0" decimalPlaces="2" defaultOpType="0" index="9" isFacet="0" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="0" primaryTypeFormat="0" solrFieldName="networkOut" useThousandSeparator="0"><column _type_="87" columnId="434" columnName="networkOut"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns convertInUTC="0" decimalPlaces="2" defaultOpType="0" index="10" isFacet="0" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="0" primaryTypeFormat="26" solrFieldName="NetworkUsageRate" useThousandSeparator="0"><column _type_="87" columnId="435" columnName="NetworkUsageRate"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns convertInUTC="0" decimalPlaces="2" defaultOpType="0" index="11" isFacet="0" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="2" primaryTypeFormat="10" solrFieldName="date" useThousandSeparator="0"><column _type_="87" columnId="436" columnName="date"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns convertInUTC="0" decimalPlaces="2" defaultOpType="0" index="12" isFacet="0" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="3" primaryTypeFormat="17" solrFieldName="time" useThousandSeparator="0"><column _type_="87" columnId="437" columnName="time"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/></columns></LogMonitoring_TemplateXML>'

	--creating template

	IF EXISTS (SELECT 1 FROM APP_Template  WITH (NOLOCK) WHERE templateName = @templateName AND status <> 3)

	BEGIN

		SET @templateId = (SELECT TOP 1 templateId FROM APP_Template  WITH (NOLOCK) WHERE templateName = @templateName AND status <> 3)

	END

	ELSE

	BEGIN
		INSERT INTO APP_Template VALUES(2,@templateName,@templateXMLString,'Template used for HyperV Log monitoring.',@curUtcDateTime,0,9,0)


		SET @templateId = @@IDENTITY    

	END

	--creating monitoring policy

	IF NOT EXISTS (SELECT 1 FROM APP_MonitoringPolicyProp WHERE attrName='System Created HyperV Policy' and attrVal<>0)

	BEGIN

		IF  EXISTS (SELECT 1 FROM APP_MonitoringPolicy   WHERE MonitorPolicyName = @monitoringPOlicyName AND status <> 3)

	BEGIN

		SET @monitoringPOlicyName =@monitoringPolicyName+ CAST(NEWID() AS NVARCHAR(MAX))

	END
		INSERT INTO APP_MonitoringPolicy VALUES(2,@monitoringPolicyName,@curUtcDateTime,@curUtcDateTime,'System created HyperV Policy',0)


		SET @monitoringPolicyId =  @@IDENTITY
		INSERT INTO App_MonitorTemplateAssoc VALUES(@monitoringPolicyId,2,@templateId)

		INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Creater User Id',7,1,@curUtcDateTime,@curUtcDateTime)    

		INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor old data',2,0,@curUtcDateTime,@curUtcDateTime)

		INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor older entries enabler',2,1,@curUtcDateTime,@curUtcDateTime)

		INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor entries older than days',7,7,@curUtcDateTime,@curUtcDateTime)

		INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Enable CI',2,1,@curUtcDateTime,@curUtcDateTime)

		INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Continuous monitoring',2,1,@curUtcDateTime,@curUtcDateTime)

		INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'enable ci data ageing',2,1,@curUtcDateTime,@curUtcDateTime)

		INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'age ci data after days',7,180,@curUtcDateTime,@curUtcDateTime)

		INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Monitoring Type',7,9,@curUtcDateTime,@curUtcDateTime)

		INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'System Created HyperV Policy',7,1,@curUtcDateTime,@curUtcDateTime)


		--Insert cloud info if AnalyticalEngine is already configured

		IF exists(SELECT 1 FROM DM2SearchServerCoreInfo SC WITH (NOLOCK) Join DM2CloudCoreRole CR WITH (NOLOCK) ON SC.CloudId = CR.CloudId Join Dm2cloud C WITH (NOLOCK) ON SC.CloudId = C.cloudid WHERE roleid = 3)

		BEGIN

			DECLARE @cloudId int , @cloudName nvarchar(max)

			SELECT TOP 1 @cloudId = C.cloudId , @cloudName = C.name

				FROM DM2SearchServerCoreInfo SC WITH (NOLOCK) Join DM2CloudCoreRole CR WITH (NOLOCK)

						ON SC.CloudId = CR.CloudId Join Dm2cloud C WITH (NOLOCK) ON SC.CloudId = C.cloudid

							 WHERE roleid = 3
			INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Cloud Id',7,@cloudId,@curUtcDateTime,@curUtcDateTime)

			INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Cloud Name',1,@cloudName,@curUtcDateTime,@curUtcDateTime)    


		END

		ELSE

		BEGIN

			--Disable HyperV policy

			UPDATE APP_MonitoringPolicy

			set status=1 

			where monitorPolicyId=@monitoringPolicyId

		END

	END
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('4E060BB0-7DB9-45D2-ABF8-228CB0FE0FD4', 'HyperVLogMonitoringScriptExec', 'Create HyperV Policy and template', @curUtcDateTime, 16, 0 , (16 + 1))

	COMMIT TRANSACTION HyperVLogTran

	END TRY

	BEGIN CATCH

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

		ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

		PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '

		ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

		ERROR MESSAGE: ' + ERROR_MESSAGE() + '

		ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

		ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		PRINT N'Rolling back Transactions.'

		ROLLBACK TRANSACTION HyperVLogTran

	END CATCH

END

SET NOCOUNT OFF

GO

