

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/LM_EventViewerMonitoringPolicyAndTemplate.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/LM_EventViewerMonitoringPolicyAndTemplate.script,v $ $Id: LM_EventViewerMonitoringPolicyAndTemplate.script,v 1.1.2.9 2018/06/09 01:08:19 vdevassy Exp $";

SET NOCOUNT ON

GO

DECLARE @EventViewerScriptExec INT = 0

SELECT

    @EventViewerScriptExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = '0C5E7C41-3830-43E8-8ED5-F75C0856BE55'

IF (@EventViewerScriptExec = 0)        -- not done, create the event viewer monitoring policy and template

BEGIN

DECLARE @curUtcDateTime BIGINT

DECLARE @templateId INT

DECLARE @monitoringPolicyId INT

DECLARE @monitoringPOlicyName NVARCHAR(max)

DECLARE @templateName NVARCHAR(max)

DECLARE @templateXMLString NVARCHAR(max)

DECLARE @errorCode int = 0

DECLARE @errorString NVARCHAR(1024) = ''

BEGIN TRY

BEGIN TRANSACTION EventViewerLogTran

SET @monitoringPOlicyName = 'Gui Event Viewer Policy'

SET @curUtcDateTime =  datediff(second, '01/01/1970', GETUTCDATE())

SET @templateName = 'Event Viewer'

SET @templateXMLString = '<LogMonitoring_TemplateXML defaultContent="LMGetEventViewerDataSetForCI" templateForMonitoringType="5"><columns index="0" isIndexed="1" isStored="1" solrFieldName="eventid" isFacet="0" showAsColumn="1" primaryDataType="0" primaryTypeFormat="0"><column _type_="87" columnId="372" columnName="Event ID"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns index="1" isIndexed="1" isStored="1" solrFieldName="occurrencedate" isFacet="1" showAsColumn="1" primaryDataType="2" primaryTypeFormat="9" format="DD-MM-YYYY"><column _type_="87" columnId="373" columnName="Occurrence Date"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns index="2" isIndexed="1" isStored="1" solrFieldName="occurrencetime" isFacet="1" showAsColumn="1" primaryDataType="3" primaryTypeFormat="17" format="HH:MM:SS"><column _type_="87" columnId="374" columnName="Occurrence Time"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/></columns><columns index="3" isIndexed="1" isStored="1" solrFieldName="eventseverity" isFacet="1" showAsColumn="1" primaryDataType="1" primaryTypeFormat="21"><column _type_="87" columnId="375" columnName="Event Severity"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns index="4" isIndexed="1" isStored="1" solrFieldName="jobid" isFacet="1" showAsColumn="1" primaryDataType="1" primaryTypeFormat="21"><column _type_="87" columnId="376" columnName="JobId"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns index="5" isIndexed="1" isStored="1" solrFieldName="commcellid" isFacet="0" showAsColumn="0" primaryDataType="0" primaryTypeFormat="0"><column _type_="87" columnId="377" columnName="CommCell ID"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns index="6" isIndexed="1" isStored="1" solrFieldName="commcellname" isFacet="1" showAsColumn="1" primaryDataType="1" primaryTypeFormat="21"><column _type_="87" columnId="378" columnName="CommCell"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns index="7" isIndexed="1" isStored="1" solrFieldName="clientid" isFacet="0" showAsColumn="0" primaryDataType="0" primaryTypeFormat="0"><column _type_="87" columnId="379" columnName="Client ID"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns index="8" isIndexed="1" isStored="1" solrFieldName="computer" isFacet="1" showAsColumn="1" primaryDataType="1" primaryTypeFormat="21"><column _type_="87" columnId="380" columnName="Computer"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns index="9" isIndexed="1" isStored="1" solrFieldName="eventcode" isFacet="1" showAsColumn="1" primaryDataType="1" primaryTypeFormat="21"><column _type_="87" columnId="381" columnName="Event Code"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns index="10" isIndexed="1" isStored="1" solrFieldName="userid" isFacet="0" showAsColumn="0" primaryDataType="0" primaryTypeFormat="0"><column _type_="87" columnId="382" columnName="User ID"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns index="11" isIndexed="1" isStored="1" solrFieldName="username" isFacet="1" showAsColumn="1" primaryDataType="1" primaryTypeFormat="21"><column _type_="87" columnId="383" columnName="User"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns index="12" isIndexed="1" isStored="1" solrFieldName="libraryid" isFacet="0" showAsColumn="0" primaryDataType="0" primaryTypeFormat="0"><column _type_="87" columnId="384" columnName="Library ID"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns index="13" isIndexed="1" isStored="1" solrFieldName="libraryname" isFacet="1" showAsColumn="1" primaryDataType="1" primaryTypeFormat="21"><column _type_="87" columnId="385" columnName="Library"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns index="14" isIndexed="1" isStored="1" solrFieldName="maid" isFacet="0" showAsColumn="0" primaryDataType="0" primaryTypeFormat="0"><column _type_="87" columnId="386" columnName="Media Agent ID"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns index="15" isIndexed="1" isStored="1" solrFieldName="maname" isFacet="1" showAsColumn="1" primaryDataType="1" primaryTypeFormat="21"><column _type_="87" columnId="387" columnName="Media Agent"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns index="16" isIndexed="1" isStored="1" solrFieldName="mediaid" isFacet="0" showAsColumn="0" primaryDataType="0" primaryTypeFormat="0"><column _type_="87" columnId="388" columnName="Media Id"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns index="17" isIndexed="1" isStored="1" solrFieldName="medianame" isFacet="1" showAsColumn="1" primaryDataType="1" primaryTypeFormat="21"><column _type_="87" columnId="389" columnName="Media"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns index="18" isIndexed="1" isStored="1" solrFieldName="driveid" isFacet="0" showAsColumn="0" primaryDataType="0" primaryTypeFormat="0"><column _type_="87" columnId="390" columnName="Drive Id"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/></columns><columns index="19" isIndexed="1" isStored="1" solrFieldName="drivename" isFacet="1" showAsColumn="1" primaryDataType="1" primaryTypeFormat="21"><column _type_="87" columnId="391" columnName="Drive"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns index="20" isIndexed="1" isStored="1" solrFieldName="program" isFacet="1" showAsColumn="1" primaryDataType="1" primaryTypeFormat="21"><column _type_="87" columnId="392" columnName="Program"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns><columns index="21" isIndexed="1" isStored="1" solrFieldName="description" isFacet="0" showAsColumn="1" primaryDataType="1" primaryTypeFormat="21"><column _type_="87" columnId="393" columnName="Description"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/></columns></LogMonitoring_TemplateXML>'

--creating template

IF EXISTS (SELECT 1 FROM APP_Template  WITH (NOLOCK) WHERE templateName = @templateName AND status <> 3)

BEGIN

    SET @templateId = (SELECT TOP 1 templateId FROM APP_Template  WITH (NOLOCK) WHERE templateName = @templateName AND status <> 3)

END

ELSE

BEGIN
    INSERT INTO APP_Template VALUES(2,@templateName,@templateXMLString,'Template used for indexing Event Viewer data',@curUtcDateTime,0,5,0)


    SET @templateId = @@IDENTITY    

END

--creating monitoring policy

IF NOT EXISTS (SELECT 1 FROM APP_MonitoringPolicy  WITH (NOLOCK) WHERE MonitorPolicyName = @monitoringPOlicyName AND status <> 3)

BEGIN
    INSERT INTO APP_MonitoringPolicy VALUES(2,@monitoringPOlicyName,@curUtcDateTime,@curUtcDateTime,'System created event viewer policy',1)


    SET @monitoringPolicyId =  @@IDENTITY
    INSERT INTO APP_MonitorAssocEntity (monitorPolicyId,commcellId,flags,created,clientGroupId,clientId,exclude) (select @monitoringPolicyId,2,3,@curUtcDateTime,0,componentNameId , 0 from APP_ClientProp where attrname = 'WebURL' AND modified = 0 group by componentNameId)

    INSERT INTO App_MonitorTemplateAssoc VALUES(@monitoringPolicyId,2,@templateId)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Creater User Id',7,1,@curUtcDateTime,@curUtcDateTime)    

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'index all lines',2,1,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Content',1,'%LOG_DIR%Web\EventViewer.log',@curUtcDateTime,@curUtcDateTime)   

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Search in subfolders',2,0,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'is NetApp Filler Content',7,0,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture lines before match',2,0,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture lines after match',2,0,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Capture log file header',2,1,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor old data',2,0,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor older entries enabler',2,1,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Do not monitor entries older than days',7,7,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'capture as attachment',2,0,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'capture as ftp',2,0,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Enable CI',2,1,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Continuous monitoring',2,1,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'enable ci data ageing',2,1,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'age ci data after days',7,180,@curUtcDateTime,@curUtcDateTime)

    INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Monitoring Type',7,5,@curUtcDateTime,@curUtcDateTime)


    --Insert cloud info if AnalyticalEngine is already configured

    IF exists(SELECT 1 FROM DM2SearchServerCoreInfo SC WITH (NOLOCK) Join DM2CloudCoreRole CR WITH (NOLOCK) ON SC.CloudId = CR.CloudId Join Dm2cloud C WITH (NOLOCK) ON SC.CloudId = C.cloudid WHERE roleid = 3)

    BEGIN

        DECLARE @cloudId int , @cloudName nvarchar(max)

        SELECT TOP 1 @cloudId = C.cloudId , @cloudName = C.name

            FROM DM2SearchServerCoreInfo SC WITH (NOLOCK) Join DM2CloudCoreRole CR WITH (NOLOCK)

                    ON SC.CloudId = CR.CloudId Join Dm2cloud C WITH (NOLOCK) ON SC.CloudId = C.cloudid

                         WHERE roleid = 3
        INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Cloud Id',7,@cloudId,@curUtcDateTime,@curUtcDateTime)

        INSERT INTO APP_MonitoringPolicyProp VALUES(@monitoringPolicyId,2,'Cloud Name',1,@cloudName,@curUtcDateTime,@curUtcDateTime)    


    END
    INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('0C5E7C41-3830-43E8-8ED5-F75C0856BE55', 'EventViewerLogMonitoringScriptExec', 'Create Event Viewer Policy and template', @curUtcDateTime, 16, 0 , (16 + 1))

END

COMMIT TRANSACTION EventViewerLogTran

END TRY

BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '

	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

	ERROR MESSAGE: ' + ERROR_MESSAGE() + '

	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

    PRINT N'Rolling back Transactions.'

    ROLLBACK TRANSACTION EventViewerLogTran

END CATCH

END

SET NOCOUNT OFF

GO

